// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directoryservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type AddIpRoutesInput struct {
	_ struct{} `type:"structure"`

	// Identifier (ID) of the directory to which to add the address block.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// IP address blocks, using CIDR format, of the traffic to route. This is often
	// the IP address block of the DNS server used for your on-premises domain.
	//
	// IpRoutes is a required field
	IpRoutes []IpRoute `type:"list" required:"true"`

	// If set to true, updates the inbound and outbound rules of the security group
	// that has the description: "AWS created security group for directory ID directory
	// controllers." Following are the new rules:
	//
	// Inbound:
	//
	//    * Type: Custom UDP Rule, Protocol: UDP, Range: 88, Source: 0.0.0.0/0
	//
	//    * Type: Custom UDP Rule, Protocol: UDP, Range: 123, Source: 0.0.0.0/0
	//
	//    * Type: Custom UDP Rule, Protocol: UDP, Range: 138, Source: 0.0.0.0/0
	//
	//    * Type: Custom UDP Rule, Protocol: UDP, Range: 389, Source: 0.0.0.0/0
	//
	//    * Type: Custom UDP Rule, Protocol: UDP, Range: 464, Source: 0.0.0.0/0
	//
	//    * Type: Custom UDP Rule, Protocol: UDP, Range: 445, Source: 0.0.0.0/0
	//
	//    * Type: Custom TCP Rule, Protocol: TCP, Range: 88, Source: 0.0.0.0/0
	//
	//    * Type: Custom TCP Rule, Protocol: TCP, Range: 135, Source: 0.0.0.0/0
	//
	//    * Type: Custom TCP Rule, Protocol: TCP, Range: 445, Source: 0.0.0.0/0
	//
	//    * Type: Custom TCP Rule, Protocol: TCP, Range: 464, Source: 0.0.0.0/0
	//
	//    * Type: Custom TCP Rule, Protocol: TCP, Range: 636, Source: 0.0.0.0/0
	//
	//    * Type: Custom TCP Rule, Protocol: TCP, Range: 1024-65535, Source: 0.0.0.0/0
	//
	//    * Type: Custom TCP Rule, Protocol: TCP, Range: 3268-33269, Source: 0.0.0.0/0
	//
	//    * Type: DNS (UDP), Protocol: UDP, Range: 53, Source: 0.0.0.0/0
	//
	//    * Type: DNS (TCP), Protocol: TCP, Range: 53, Source: 0.0.0.0/0
	//
	//    * Type: LDAP, Protocol: TCP, Range: 389, Source: 0.0.0.0/0
	//
	//    * Type: All ICMP, Protocol: All, Range: N/A, Source: 0.0.0.0/0
	//
	// Outbound:
	//
	//    * Type: All traffic, Protocol: All, Range: All, Destination: 0.0.0.0/0
	//
	// These security rules impact an internal network interface that is not exposed
	// publicly.
	UpdateSecurityGroupForDirectoryControllers *bool `type:"boolean"`
}

// String returns the string representation
func (s AddIpRoutesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddIpRoutesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AddIpRoutesInput"}

	if s.DirectoryId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DirectoryId"))
	}

	if s.IpRoutes == nil {
		invalidParams.Add(aws.NewErrParamRequired("IpRoutes"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AddIpRoutesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddIpRoutesOutput) String() string {
	return awsutil.Prettify(s)
}

const opAddIpRoutes = "AddIpRoutes"

// AddIpRoutesRequest returns a request value for making API operation for
// AWS Directory Service.
//
// If the DNS server for your on-premises domain uses a publicly addressable
// IP address, you must add a CIDR address block to correctly route traffic
// to and from your Microsoft AD on Amazon Web Services. AddIpRoutes adds this
// address block. You can also use AddIpRoutes to facilitate routing traffic
// that uses public IP ranges from your Microsoft AD on AWS to a peer VPC.
//
// Before you call AddIpRoutes, ensure that all of the required permissions
// have been explicitly granted through a policy. For details about what permissions
// are required to run the AddIpRoutes operation, see AWS Directory Service
// API Permissions: Actions, Resources, and Conditions Reference (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html).
//
//    // Example sending a request using AddIpRoutesRequest.
//    req := client.AddIpRoutesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/AddIpRoutes
func (c *Client) AddIpRoutesRequest(input *AddIpRoutesInput) AddIpRoutesRequest {
	op := &aws.Operation{
		Name:       opAddIpRoutes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddIpRoutesInput{}
	}

	req := c.newRequest(op, input, &AddIpRoutesOutput{})
	return AddIpRoutesRequest{Request: req, Input: input, Copy: c.AddIpRoutesRequest}
}

// AddIpRoutesRequest is the request type for the
// AddIpRoutes API operation.
type AddIpRoutesRequest struct {
	*aws.Request
	Input *AddIpRoutesInput
	Copy  func(*AddIpRoutesInput) AddIpRoutesRequest
}

// Send marshals and sends the AddIpRoutes API request.
func (r AddIpRoutesRequest) Send(ctx context.Context) (*AddIpRoutesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AddIpRoutesResponse{
		AddIpRoutesOutput: r.Request.Data.(*AddIpRoutesOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AddIpRoutesResponse is the response type for the
// AddIpRoutes API operation.
type AddIpRoutesResponse struct {
	*AddIpRoutesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AddIpRoutes request.
func (r *AddIpRoutesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
