// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dataexchange

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Creates a revision for a data set. When they're created, revisions are not
// published to products, and therefore are not available to subscribers. To
// publish a revision to a data set in a product, the revision must first be
// finalized.
type CreateRevisionInput struct {
	_ struct{} `type:"structure"`

	// An optional comment about the revision.
	Comment *string `type:"string"`

	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`

	// A revision tag is an optional label that you can assign to a revision when
	// you create it. Each tag consists of a key and an optional value, both of
	// which you define. When you use tagging, you can also use tag-based access
	// control in IAM policies to control access to these data sets and revisions.
	Tags map[string]string `type:"map"`
}

// String returns the string representation
func (s CreateRevisionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRevisionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateRevisionInput"}

	if s.DataSetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateRevisionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Comment != nil {
		v := *s.Comment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Comment", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.DataSetId != nil {
		v := *s.DataSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "DataSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CreateRevisionOutput struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.
	Arn *string `type:"string"`

	Comment *string `type:"string"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A unique identifier.
	DataSetId *string `type:"string"`

	Finalized *bool `type:"boolean"`

	// A unique identifier.
	Id *string `type:"string"`

	// A unique identifier.
	SourceId *string `type:"string"`

	Tags map[string]string `type:"map"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s CreateRevisionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateRevisionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Comment != nil {
		v := *s.Comment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Comment", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.DataSetId != nil {
		v := *s.DataSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Finalized != nil {
		v := *s.Finalized

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Finalized", protocol.BoolValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceId != nil {
		v := *s.SourceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.UpdatedAt != nil {
		v := *s.UpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdatedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

const opCreateRevision = "CreateRevision"

// CreateRevisionRequest returns a request value for making API operation for
// AWS Data Exchange.
//
// This operation creates a revision for a data set.
//
//    // Example sending a request using CreateRevisionRequest.
//    req := client.CreateRevisionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/CreateRevision
func (c *Client) CreateRevisionRequest(input *CreateRevisionInput) CreateRevisionRequest {
	op := &aws.Operation{
		Name:       opCreateRevision,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/data-sets/{DataSetId}/revisions",
	}

	if input == nil {
		input = &CreateRevisionInput{}
	}

	req := c.newRequest(op, input, &CreateRevisionOutput{})
	return CreateRevisionRequest{Request: req, Input: input, Copy: c.CreateRevisionRequest}
}

// CreateRevisionRequest is the request type for the
// CreateRevision API operation.
type CreateRevisionRequest struct {
	*aws.Request
	Input *CreateRevisionInput
	Copy  func(*CreateRevisionInput) CreateRevisionRequest
}

// Send marshals and sends the CreateRevision API request.
func (r CreateRevisionRequest) Send(ctx context.Context) (*CreateRevisionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateRevisionResponse{
		CreateRevisionOutput: r.Request.Data.(*CreateRevisionOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateRevisionResponse is the response type for the
// CreateRevision API operation.
type CreateRevisionResponse struct {
	*CreateRevisionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateRevision request.
func (r *CreateRevisionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
