# Changelog

## [0.16.1](https://github.com/operator-framework/operator-lifecycle-manager/tree/0.16.1) (2020-09-04)

[Full Changelog](https://github.com/operator-framework/operator-lifecycle-manager/compare/0.16.1...0.16.1)

**Other changes:**

- 0.16.1 Release: Generate Manifests [\#1750](https://github.com/operator-framework/operator-lifecycle-manager/pull/1750) ([awgreene](https://github.com/awgreene))

## [0.16.1](https://github.com/operator-framework/operator-lifecycle-manager/tree/0.16.1) (2020-09-03)

[Full Changelog](https://github.com/operator-framework/operator-lifecycle-manager/compare/0.16.0...0.16.1)

**Closed issues:**

- Issue Installing OLM in Openshift Namespace [\#1683](https://github.com/operator-framework/operator-lifecycle-manager/issues/1683)
- Evicted CatalogSource pod causes failure [\#1677](https://github.com/operator-framework/operator-lifecycle-manager/issues/1677)
- Unable to use OLM to create operator in kubernetes native cluster [\#1660](https://github.com/operator-framework/operator-lifecycle-manager/issues/1660)
- An old version of a dependent package is installed [\#1620](https://github.com/operator-framework/operator-lifecycle-manager/issues/1620)
- Can't recreate operator if the installplan exist in 4.4 [\#1570](https://github.com/operator-framework/operator-lifecycle-manager/issues/1570)
- What is the significance of "internalversion" package? Is it advisable to use it? [\#1527](https://github.com/operator-framework/operator-lifecycle-manager/issues/1527)
- Leader election for olm-operator and catalog-operator [\#1405](https://github.com/operator-framework/operator-lifecycle-manager/issues/1405)
- How to make operator installation method in OCP 4.2+ compatible with OCP 4.1 [\#1320](https://github.com/operator-framework/operator-lifecycle-manager/issues/1320)
- Question: optional dependency [\#819](https://github.com/operator-framework/operator-lifecycle-manager/issues/819)

**Other changes:**

- Bump OLM Version [\#1749](https://github.com/operator-framework/operator-lifecycle-manager/pull/1749) ([awgreene](https://github.com/awgreene))
- Update OWNERS [\#1739](https://github.com/operator-framework/operator-lifecycle-manager/pull/1739) ([kevinrizza](https://github.com/kevinrizza))
- Bug 1872080: Updating Dockerfile baseimages to mach ocp-build-data config [\#1738](https://github.com/operator-framework/operator-lifecycle-manager/pull/1738) ([openshift-bot](https://github.com/openshift-bot))
- Bug 1869523: Fix nodeSelector subscription config override [\#1728](https://github.com/operator-framework/operator-lifecycle-manager/pull/1728) ([awgreene](https://github.com/awgreene))
- Update Owners file [\#1727](https://github.com/operator-framework/operator-lifecycle-manager/pull/1727) ([awgreene](https://github.com/awgreene))
- Bug 1868497: Fix install plan creation for subscriptions that omit channel. [\#1725](https://github.com/operator-framework/operator-lifecycle-manager/pull/1725) ([benluddy](https://github.com/benluddy))
- Bug 1861636: fix\(operator\): re-adopt manually disowned crds [\#1721](https://github.com/operator-framework/operator-lifecycle-manager/pull/1721) ([njhale](https://github.com/njhale))
- Bug 1861605: Update manifests to include the bug fix [\#1720](https://github.com/operator-framework/operator-lifecycle-manager/pull/1720) ([simrandhaliw](https://github.com/simrandhaliw))
- Add Total Test Number to report [\#1717](https://github.com/operator-framework/operator-lifecycle-manager/pull/1717) ([Bowenislandsong](https://github.com/Bowenislandsong))
- Bug 1860035: Fix SubscriptionConfig NodeSelector field [\#1716](https://github.com/operator-framework/operator-lifecycle-manager/pull/1716) ([awgreene](https://github.com/awgreene))
- Bug 1867169: Fix stale content in configmap due to stale bundle image in the node [\#1715](https://github.com/operator-framework/operator-lifecycle-manager/pull/1715) ([dinhxuanvu](https://github.com/dinhxuanvu))
- Bug 1861605: Reduce length of explanation of status of Operator resource [\#1713](https://github.com/operator-framework/operator-lifecycle-manager/pull/1713) ([simrandhaliw](https://github.com/simrandhaliw))
- Add Catalog Source priority for dependency resolution [\#1706](https://github.com/operator-framework/operator-lifecycle-manager/pull/1706) ([Bowenislandsong](https://github.com/Bowenislandsong))
- Remove spurious check for duplicate operators in resolver. [\#1702](https://github.com/operator-framework/operator-lifecycle-manager/pull/1702) ([benluddy](https://github.com/benluddy))
- feat\(resolver\): filtering deprecated bundles in resolver [\#1699](https://github.com/operator-framework/operator-lifecycle-manager/pull/1699) ([dinhxuanvu](https://github.com/dinhxuanvu))
- chore\(clean\): Remove legacy resolver [\#1696](https://github.com/operator-framework/operator-lifecycle-manager/pull/1696) ([ecordell](https://github.com/ecordell))
- change default catalog to index image [\#1695](https://github.com/operator-framework/operator-lifecycle-manager/pull/1695) ([dmesser](https://github.com/dmesser))
- Enable the Operator API by default [\#1694](https://github.com/operator-framework/operator-lifecycle-manager/pull/1694) ([njhale](https://github.com/njhale))
- Remove unnecessary ENV directives from base.Dockerfile. [\#1692](https://github.com/operator-framework/operator-lifecycle-manager/pull/1692) ([benluddy](https://github.com/benluddy))
- feat\(resolver\): Add label dependency type to new resolver [\#1687](https://github.com/operator-framework/operator-lifecycle-manager/pull/1687) ([dinhxuanvu](https://github.com/dinhxuanvu))
- Bug 1860185: fix\(install\): account for installplans when calculating generation [\#1684](https://github.com/operator-framework/operator-lifecycle-manager/pull/1684) ([njhale](https://github.com/njhale))
- Remove unneeded toleration from catalog source pod [\#1680](https://github.com/operator-framework/operator-lifecycle-manager/pull/1680) ([kramvan1](https://github.com/kramvan1))
- Rebuild busybox operator index image [\#1678](https://github.com/operator-framework/operator-lifecycle-manager/pull/1678) ([awgreene](https://github.com/awgreene))
- feat\(operator\): adopt referenced installplans [\#1661](https://github.com/operator-framework/operator-lifecycle-manager/pull/1661) ([njhale](https://github.com/njhale))
- \[metrics\] Dependency resolution metrics [\#1657](https://github.com/operator-framework/operator-lifecycle-manager/pull/1657) ([anik120](https://github.com/anik120))
-  New SAT-based dependency resolver [\#1652](https://github.com/operator-framework/operator-lifecycle-manager/pull/1652) ([ecordell](https://github.com/ecordell))
- Add Conversion Webhook support for OLM [\#1649](https://github.com/operator-framework/operator-lifecycle-manager/pull/1649) ([simrandhaliw](https://github.com/simrandhaliw))
- Bug 1853601: use server-side-apply for catalog source pod update [\#1624](https://github.com/operator-framework/operator-lifecycle-manager/pull/1624) ([ankitathomas](https://github.com/ankitathomas))
- add InstallplanApproval \(automatic/manual\) to OLM metrics [\#1613](https://github.com/operator-framework/operator-lifecycle-manager/pull/1613) ([konsotirop](https://github.com/konsotirop))

## [0.16.0](https://github.com/operator-framework/operator-lifecycle-manager/tree/0.16.0) (2020-07-23)

[Full Changelog](https://github.com/operator-framework/operator-lifecycle-manager/compare/0.15.1...0.16.0)

**Closed issues:**

- Is it possible to run OLM on clusters without OpenShift [\#1658](https://github.com/operator-framework/operator-lifecycle-manager/issues/1658)
- OLM doesn't create roles corresponding to the `permissions` defined in the CSV file [\#1625](https://github.com/operator-framework/operator-lifecycle-manager/issues/1625)
- The required operator from ClusterServiceVersion isn't installed from the default channel. [\#1612](https://github.com/operator-framework/operator-lifecycle-manager/issues/1612)
- Unable to install OLM 0.15.1 on MicroK8s 1.17/stable [\#1584](https://github.com/operator-framework/operator-lifecycle-manager/issues/1584)
- Request respin 0.14.3 release as 0.14.1 CVE and 0.15.1 has kubectl hang issue [\#1576](https://github.com/operator-framework/operator-lifecycle-manager/issues/1576)
- Duplicate apply of 0.15.1 clusterserviceversions.crd.yaml hangs [\#1574](https://github.com/operator-framework/operator-lifecycle-manager/issues/1574)
- webhook alternate port [\#1573](https://github.com/operator-framework/operator-lifecycle-manager/issues/1573)
- 0.15.0 install hang [\#1534](https://github.com/operator-framework/operator-lifecycle-manager/issues/1534)
- OLM 0.14.2 ignores subscription channel changes. [\#1510](https://github.com/operator-framework/operator-lifecycle-manager/issues/1510)
- OOM catalog [\#1497](https://github.com/operator-framework/operator-lifecycle-manager/issues/1497)
- Use Kubeadm instead of Minikube to Support Local Power Build [\#1477](https://github.com/operator-framework/operator-lifecycle-manager/issues/1477)
- Include StatefulSet as Resource owned by Operand [\#1449](https://github.com/operator-framework/operator-lifecycle-manager/issues/1449)
- Operator installed via OLM removes `nullable` from CRD [\#1433](https://github.com/operator-framework/operator-lifecycle-manager/issues/1433)
- How often releases cut? [\#1415](https://github.com/operator-framework/operator-lifecycle-manager/issues/1415)
- install.sh 0.14.1 - CSV "packageserver" failed to reach phase succeeded [\#1360](https://github.com/operator-framework/operator-lifecycle-manager/issues/1360)
- Subscription emits InstallPlan containing update to unrelated operator/clusterServiceVersion [\#1082](https://github.com/operator-framework/operator-lifecycle-manager/issues/1082)
- How to add 3rd party CRD to my operator CSV [\#1060](https://github.com/operator-framework/operator-lifecycle-manager/issues/1060)
- deleting CSV does not delete operator's RBAC related resources [\#1041](https://github.com/operator-framework/operator-lifecycle-manager/issues/1041)
- Update / Patch to deployment during "replace" rejected by kubernetes, fails in a loop [\#952](https://github.com/operator-framework/operator-lifecycle-manager/issues/952)
- CSV not found for CS in other namespace [\#944](https://github.com/operator-framework/operator-lifecycle-manager/issues/944)
- How to tell if OLM is ready after OpenShift install? [\#934](https://github.com/operator-framework/operator-lifecycle-manager/issues/934)
- Don't use readiness condition to detect if updates are in progress [\#922](https://github.com/operator-framework/operator-lifecycle-manager/issues/922)
- Documentation clarification [\#908](https://github.com/operator-framework/operator-lifecycle-manager/issues/908)
- \[doc\] - Installation and configuration process are not clear [\#896](https://github.com/operator-framework/operator-lifecycle-manager/issues/896)
- Deploying an operator without using a subscription object [\#891](https://github.com/operator-framework/operator-lifecycle-manager/issues/891)
- Unable to install 2 operators in mixed installation modes [\#873](https://github.com/operator-framework/operator-lifecycle-manager/issues/873)
- Feature Request: NodeAffinity for Operators [\#840](https://github.com/operator-framework/operator-lifecycle-manager/issues/840)
- Unable to uninstall OLM [\#789](https://github.com/operator-framework/operator-lifecycle-manager/issues/789)

**Other changes:**

- Bug 1859178: fix\(installplans\): GC older installplans [\#1669](https://github.com/operator-framework/operator-lifecycle-manager/pull/1669) ([ecordell](https://github.com/ecordell))
- Bug: Fix incorrect deployment annotations [\#1662](https://github.com/operator-framework/operator-lifecycle-manager/pull/1662) ([awgreene](https://github.com/awgreene))
- Bug 1859717: Fix validate CRD compatibility check and deprecated CRD test case [\#1659](https://github.com/operator-framework/operator-lifecycle-manager/pull/1659) ([dinhxuanvu](https://github.com/dinhxuanvu))
- fix: explicitly delete collection of catalog source pods in grpc e2e test [\#1656](https://github.com/operator-framework/operator-lifecycle-manager/pull/1656) ([exdx](https://github.com/exdx))
- Omit \(hopefully\) redundant yum update from downstream builder stage. [\#1655](https://github.com/operator-framework/operator-lifecycle-manager/pull/1655) ([benluddy](https://github.com/benluddy))
- Return an error when solver input contains duplicate identifiers. [\#1654](https://github.com/operator-framework/operator-lifecycle-manager/pull/1654) ([benluddy](https://github.com/benluddy))
- Refactor solver preference searching. [\#1650](https://github.com/operator-framework/operator-lifecycle-manager/pull/1650) ([benluddy](https://github.com/benluddy))
- fix: remove bundle e2e test skip [\#1647](https://github.com/operator-framework/operator-lifecycle-manager/pull/1647) ([exdx](https://github.com/exdx))
- Add flake analyzer periodics [\#1645](https://github.com/operator-framework/operator-lifecycle-manager/pull/1645) ([Bowenislandsong](https://github.com/Bowenislandsong))
- fix: Use PR head commit in artifact naming instead of merge commit [\#1643](https://github.com/operator-framework/operator-lifecycle-manager/pull/1643) ([Bowenislandsong](https://github.com/Bowenislandsong))
- Bug 1857424: fix\(resolver\): Exclude all installed packages in dependency search [\#1642](https://github.com/operator-framework/operator-lifecycle-manager/pull/1642) ([dinhxuanvu](https://github.com/dinhxuanvu))
- fix: use server-side apply in crd e2e test  [\#1641](https://github.com/operator-framework/operator-lifecycle-manager/pull/1641) ([exdx](https://github.com/exdx))
- test\(e2e\): skip bundle cr install test [\#1640](https://github.com/operator-framework/operator-lifecycle-manager/pull/1640) ([njhale](https://github.com/njhale))
- fix\(metrics\): query cache for object count metrics [\#1639](https://github.com/operator-framework/operator-lifecycle-manager/pull/1639) ([ecordell](https://github.com/ecordell))
- fix: install VPA CRD directly on clusterfor bundle e2e test [\#1637](https://github.com/operator-framework/operator-lifecycle-manager/pull/1637) ([exdx](https://github.com/exdx))
- fix: add installplan status check after subscription status check for gc e2e tests [\#1636](https://github.com/operator-framework/operator-lifecycle-manager/pull/1636) ([exdx](https://github.com/exdx))
- test\(e2e\): delete all subs, installplans, catalogs, and csvs in test teardown [\#1635](https://github.com/operator-framework/operator-lifecycle-manager/pull/1635) ([njhale](https://github.com/njhale))
- Add an AtMost cardinality constraint to the solver package. [\#1632](https://github.com/operator-framework/operator-lifecycle-manager/pull/1632) ([benluddy](https://github.com/benluddy))
- fix: check installplan status in bundle e2e test [\#1631](https://github.com/operator-framework/operator-lifecycle-manager/pull/1631) ([exdx](https://github.com/exdx))
- Documentation improvements - PR template and DEVELOPMENT.md [\#1630](https://github.com/operator-framework/operator-lifecycle-manager/pull/1630) ([matskiv](https://github.com/matskiv))
- Bug 1855088: generate unique \(Cluster\)RoleBinding names [\#1629](https://github.com/operator-framework/operator-lifecycle-manager/pull/1629) ([matskiv](https://github.com/matskiv))
- Bug 1851213: Set Resource to plural in CSV RelatedObjects field [\#1623](https://github.com/operator-framework/operator-lifecycle-manager/pull/1623) ([ankitathomas](https://github.com/ankitathomas))
- Introduce preference order for solver. [\#1619](https://github.com/operator-framework/operator-lifecycle-manager/pull/1619) ([benluddy](https://github.com/benluddy))
- Add workflow to save e2e test artifacts [\#1618](https://github.com/operator-framework/operator-lifecycle-manager/pull/1618) ([Bowenislandsong](https://github.com/Bowenislandsong))
- test\(e2e\): patch installplans w/ server-side apply [\#1617](https://github.com/operator-framework/operator-lifecycle-manager/pull/1617) ([njhale](https://github.com/njhale))
- fix: update README to point to the OLM book website  [\#1611](https://github.com/operator-framework/operator-lifecycle-manager/pull/1611) ([exdx](https://github.com/exdx))
- Add more precise matching to the metric end-to-end tests. [\#1610](https://github.com/operator-framework/operator-lifecycle-manager/pull/1610) ([benluddy](https://github.com/benluddy))
- feat\(operator\): automatically adopt generated resources [\#1607](https://github.com/operator-framework/operator-lifecycle-manager/pull/1607) ([njhale](https://github.com/njhale))
- Retry update in flaky test of CSV w/owned API Service. [\#1604](https://github.com/operator-framework/operator-lifecycle-manager/pull/1604) ([benluddy](https://github.com/benluddy))
- Bug 1822396: Update metric when Subscription is updated [\#1603](https://github.com/operator-framework/operator-lifecycle-manager/pull/1603) ([anik120](https://github.com/anik120))
- bump olm version to 0.16.0 [\#1601](https://github.com/operator-framework/operator-lifecycle-manager/pull/1601) ([kevinrizza](https://github.com/kevinrizza))
- Update ocp manifests with latest template [\#1600](https://github.com/operator-framework/operator-lifecycle-manager/pull/1600) ([kevinrizza](https://github.com/kevinrizza))
- Disable parallel e2e-local runs by default. [\#1598](https://github.com/operator-framework/operator-lifecycle-manager/pull/1598) ([benluddy](https://github.com/benluddy))
- Replace assertions within async assertions. [\#1596](https://github.com/operator-framework/operator-lifecycle-manager/pull/1596) ([benluddy](https://github.com/benluddy))
- Bug 1850709: Remove failfast from operator e2e test [\#1592](https://github.com/operator-framework/operator-lifecycle-manager/pull/1592) ([Bowenislandsong](https://github.com/Bowenislandsong))
- Bug 1849164: don't store full manifests in installplan status \(for bundle images\) [\#1589](https://github.com/operator-framework/operator-lifecycle-manager/pull/1589) ([ecordell](https://github.com/ecordell))
- Bug 1847540: resolve only default channels [\#1583](https://github.com/operator-framework/operator-lifecycle-manager/pull/1583) ([kevinrizza](https://github.com/kevinrizza))
- Bug 1843652: fix\(package-server\): get icons from default channel [\#1579](https://github.com/operator-framework/operator-lifecycle-manager/pull/1579) ([njhale](https://github.com/njhale))
- chore\(modules\): bump api dep to v0.3.7 [\#1578](https://github.com/operator-framework/operator-lifecycle-manager/pull/1578) ([njhale](https://github.com/njhale))
- feat: support priorityclass, poddisruptionbudget, and vpa objects [\#1577](https://github.com/operator-framework/operator-lifecycle-manager/pull/1577) ([exdx](https://github.com/exdx))
- docs: add design docs for including additional objects in bundles [\#1564](https://github.com/operator-framework/operator-lifecycle-manager/pull/1564) ([exdx](https://github.com/exdx))
- feat\(resolver\): don't build new clauses for weights [\#1563](https://github.com/operator-framework/operator-lifecycle-manager/pull/1563) ([ecordell](https://github.com/ecordell))
- beta.kubernetes.io/os deprecated since v1.14, removed in v1.19 [\#1562](https://github.com/operator-framework/operator-lifecycle-manager/pull/1562) ([kramvan1](https://github.com/kramvan1))
- Reduce install.sh flakiness. [\#1558](https://github.com/operator-framework/operator-lifecycle-manager/pull/1558) ([benluddy](https://github.com/benluddy))
- Bug 1822040: Fix delay when OLM applies label to Namespaces [\#1550](https://github.com/operator-framework/operator-lifecycle-manager/pull/1550) ([harishsurf](https://github.com/harishsurf))
- Bug 1838054: fix\(catalog\): no operatorgroups in a namespace should be an error when resolving [\#1549](https://github.com/operator-framework/operator-lifecycle-manager/pull/1549) ([ecordell](https://github.com/ecordell))
- Fix duplicated CRDs in quickstart manifests. [\#1542](https://github.com/operator-framework/operator-lifecycle-manager/pull/1542) ([benluddy](https://github.com/benluddy))
- Bug 1838705: fix\(webhook\): Wire ContainerPort to Webhook [\#1540](https://github.com/operator-framework/operator-lifecycle-manager/pull/1540) ([awgreene](https://github.com/awgreene))
- Changelog for 0.15.1 [\#1539](https://github.com/operator-framework/operator-lifecycle-manager/pull/1539) ([anik120](https://github.com/anik120))
- Manifests for OLM 0.15.1 [\#1538](https://github.com/operator-framework/operator-lifecycle-manager/pull/1538) ([anik120](https://github.com/anik120))
- Bump OLM to 0.15.1 [\#1537](https://github.com/operator-framework/operator-lifecycle-manager/pull/1537) ([anik120](https://github.com/anik120))
- Bug 1828550: add check for storage version changes when installing CRDs [\#1535](https://github.com/operator-framework/operator-lifecycle-manager/pull/1535) ([exdx](https://github.com/exdx))
- Bug 1834936: fix\(resolver\): don't pick operator from same package when resolve requiredAPI [\#1521](https://github.com/operator-framework/operator-lifecycle-manager/pull/1521) ([dinhxuanvu](https://github.com/dinhxuanvu))
- Bug 1822396: Delete subscription metric when an operator is uninstalled [\#1519](https://github.com/operator-framework/operator-lifecycle-manager/pull/1519) ([anik120](https://github.com/anik120))
- Bug 1833195: delete bundle objects after CSV gets deleted [\#1516](https://github.com/operator-framework/operator-lifecycle-manager/pull/1516) ([exdx](https://github.com/exdx))
- Update prow ci logging for e2e tests [\#1512](https://github.com/operator-framework/operator-lifecycle-manager/pull/1512) ([harishsurf](https://github.com/harishsurf))
- cleanup: delete duplicated import in olm [\#1501](https://github.com/operator-framework/operator-lifecycle-manager/pull/1501) ([beautytiger](https://github.com/beautytiger))
- Bug 1823714: Update PkgManifest upon catsrc update [\#1482](https://github.com/operator-framework/operator-lifecycle-manager/pull/1482) ([Bowenislandsong](https://github.com/Bowenislandsong))
- doc: add CONTRIBUTING.md [\#1479](https://github.com/operator-framework/operator-lifecycle-manager/pull/1479) ([camilamacedo86](https://github.com/camilamacedo86))
- Changed address for readiness and liveness probes on registry-server [\#1478](https://github.com/operator-framework/operator-lifecycle-manager/pull/1478) ([marcusportmann](https://github.com/marcusportmann))
- Catch failed Ginkgo assertion in test goroutine. [\#1465](https://github.com/operator-framework/operator-lifecycle-manager/pull/1465) ([benluddy](https://github.com/benluddy))
- Convert metrics\_e2e\_test to ginkgo [\#1443](https://github.com/operator-framework/operator-lifecycle-manager/pull/1443) ([harishsurf](https://github.com/harishsurf))
- feat: add uninstall makefile target [\#1438](https://github.com/operator-framework/operator-lifecycle-manager/pull/1438) ([camilamacedo86](https://github.com/camilamacedo86))
- Doc: Remove legacy webhook proposal [\#1379](https://github.com/operator-framework/operator-lifecycle-manager/pull/1379) ([awgreene](https://github.com/awgreene))

# Changelog

## [0.15.1](https://github.com/operator-framework/operator-lifecycle-manager/tree/0.15.1) (2020-05-21)

[Full Changelog](https://github.com/operator-framework/operator-lifecycle-manager/compare/0.15.0...0.15.1)

**Other changes:**

- Manifests for OLM 0.15.1 [\#1538](https://github.com/operator-framework/operator-lifecycle-manager/pull/1538) ([anik120](https://github.com/anik120))
- Bump OLM to 0.15.1 [\#1537](https://github.com/operator-framework/operator-lifecycle-manager/pull/1537) ([anik120](https://github.com/anik120))
- Changelog for 0.15.0 [\#1533](https://github.com/operator-framework/operator-lifecycle-manager/pull/1533) ([anik120](https://github.com/anik120))
- Bug 1819308: Deleting a CSV removes related CSV metrics [\#1525](https://github.com/operator-framework/operator-lifecycle-manager/pull/1525) ([harishsurf](https://github.com/harishsurf))
- Bug 1826443: Pod Config Deployment Hash Error [\#1472](https://github.com/operator-framework/operator-lifecycle-manager/pull/1472) ([awgreene](https://github.com/awgreene))

## [0.15.0](https://github.com/operator-framework/operator-lifecycle-manager/tree/0.15.0) (2020-05-19)

[Full Changelog](https://github.com/operator-framework/operator-lifecycle-manager/compare/0.14.2...0.15.0)

**Closed issues:**

- Is it possible install an operator to a specific namespace via olm? [\#1490](https://github.com/operator-framework/operator-lifecycle-manager/issues/1490)
- InstallPlan/Update spam with multiple catalogsources containing different operator versions [\#1471](https://github.com/operator-framework/operator-lifecycle-manager/issues/1471)
- How to communicate with application registry without OperatorSource [\#1450](https://github.com/operator-framework/operator-lifecycle-manager/issues/1450)
- \[Best Practise\] How to release a product with operator [\#1427](https://github.com/operator-framework/operator-lifecycle-manager/issues/1427)
- \[Best Practise\] Airgap install operators [\#1420](https://github.com/operator-framework/operator-lifecycle-manager/issues/1420)
- \[Best Practise\] How to define channel name when certify my operator for RH [\#1409](https://github.com/operator-framework/operator-lifecycle-manager/issues/1409)
- Tit [\#1384](https://github.com/operator-framework/operator-lifecycle-manager/issues/1384)
- Stop working on my device immediately. [\#1376](https://github.com/operator-framework/operator-lifecycle-manager/issues/1376)
- OLM fails to install packageserver with FailedDiscoveryCheck error  [\#1368](https://github.com/operator-framework/operator-lifecycle-manager/issues/1368)
- Docs: Clarification opportunities in the Architecture document [\#1346](https://github.com/operator-framework/operator-lifecycle-manager/issues/1346)
- When delete CSV and subscription, how to make operator waiting for its CR deleted [\#1302](https://github.com/operator-framework/operator-lifecycle-manager/issues/1302)
- Deploy Operator through OLM that selects only one namespace [\#1297](https://github.com/operator-framework/operator-lifecycle-manager/issues/1297)
- Unable to specify ImagePullSecrets for private registry in ClusterServiceVersion [\#1294](https://github.com/operator-framework/operator-lifecycle-manager/issues/1294)
- How to deliver fixpak for operand \(operator instance\) [\#1287](https://github.com/operator-framework/operator-lifecycle-manager/issues/1287)
- Add optional flag for having CSV's owned by their Subscription. [\#1283](https://github.com/operator-framework/operator-lifecycle-manager/issues/1283)
- Patch releases needed for CVE to remove unneeded major release churn \(0.13.1?\) [\#1269](https://github.com/operator-framework/operator-lifecycle-manager/issues/1269)
- There is error reported during olm installation [\#1155](https://github.com/operator-framework/operator-lifecycle-manager/issues/1155)
- Expected handling of minor release updates [\#1124](https://github.com/operator-framework/operator-lifecycle-manager/issues/1124)
- Can't install APIService that doesn't introduce a new Kind [\#1122](https://github.com/operator-framework/operator-lifecycle-manager/issues/1122)
- how to shutdown operator instance when last subscription is removed? [\#1088](https://github.com/operator-framework/operator-lifecycle-manager/issues/1088)
- catalog-operator no version tags for configmap-operator-registry image [\#1045](https://github.com/operator-framework/operator-lifecycle-manager/issues/1045)
- What is the Security guidelines for OLM fixing known CVEs? [\#1036](https://github.com/operator-framework/operator-lifecycle-manager/issues/1036)
- Support for K8S 1.16 CRD API V1 Changes [\#1034](https://github.com/operator-framework/operator-lifecycle-manager/issues/1034)
- Configuring deployment limits and environment [\#999](https://github.com/operator-framework/operator-lifecycle-manager/issues/999)
- Make fails when GOPATH contains more than one entry [\#956](https://github.com/operator-framework/operator-lifecycle-manager/issues/956)
- The CRD for the ClusterServiceVersion is missing field [\#930](https://github.com/operator-framework/operator-lifecycle-manager/issues/930)
- Restricting visibility of specific CRDs to some namespaces [\#734](https://github.com/operator-framework/operator-lifecycle-manager/issues/734)
- Api service certificates are created for each api group [\#727](https://github.com/operator-framework/operator-lifecycle-manager/issues/727)
- There seems to be no proper way to uninstall [\#557](https://github.com/operator-framework/operator-lifecycle-manager/issues/557)

**Other changes:**

- Bug 1812019: PackageManifests should include Keywords [\#1520](https://github.com/operator-framework/operator-lifecycle-manager/pull/1520) ([awgreene](https://github.com/awgreene))
- Bug 1833426: Update Webhook E2E Namespace Labels [\#1515](https://github.com/operator-framework/operator-lifecycle-manager/pull/1515) ([awgreene](https://github.com/awgreene))
- Bug 1834136: fix\(queues\): use a single gc queue [\#1513](https://github.com/operator-framework/operator-lifecycle-manager/pull/1513) ([njhale](https://github.com/njhale))
- Bug 1833419: Detect WebhookDescription changes in CSVs [\#1509](https://github.com/operator-framework/operator-lifecycle-manager/pull/1509) ([awgreene](https://github.com/awgreene))
- Bump OLM version to 0.15.0 [\#1503](https://github.com/operator-framework/operator-lifecycle-manager/pull/1503) ([anik120](https://github.com/anik120))
- Bug 1830031: Update OLM to use UID for OG Labels [\#1496](https://github.com/operator-framework/operator-lifecycle-manager/pull/1496) ([awgreene](https://github.com/awgreene))
- Bug 1826446: \(fix\) Admission Webhook names must be unique [\#1489](https://github.com/operator-framework/operator-lifecycle-manager/pull/1489) ([awgreene](https://github.com/awgreene))
- Bug 1818788: Fix Operator Generation code [\#1483](https://github.com/operator-framework/operator-lifecycle-manager/pull/1483) ([awgreene](https://github.com/awgreene))
- Bug 1825330: support creating v1beta CRDs to avoid data loss [\#1470](https://github.com/operator-framework/operator-lifecycle-manager/pull/1470) ([exdx](https://github.com/exdx))
- \(Rebased disc\)^2 [\#1468](https://github.com/operator-framework/operator-lifecycle-manager/pull/1468) ([njhale](https://github.com/njhale))
- Switch api definitions to operator-framework/api [\#1464](https://github.com/operator-framework/operator-lifecycle-manager/pull/1464) ([ecordell](https://github.com/ecordell))
- chore\(deps\): bump to kube 1.18 [\#1462](https://github.com/operator-framework/operator-lifecycle-manager/pull/1462) ([ecordell](https://github.com/ecordell))
- Fix failing E2E bundle unpacking test. [\#1460](https://github.com/operator-framework/operator-lifecycle-manager/pull/1460) ([benluddy](https://github.com/benluddy))
- Add an operator cache for use by the resolver. [\#1458](https://github.com/operator-framework/operator-lifecycle-manager/pull/1458) ([benluddy](https://github.com/benluddy))
- fix: add empty go file to packge to fix make verify [\#1455](https://github.com/operator-framework/operator-lifecycle-manager/pull/1455) ([exdx](https://github.com/exdx))
- Regenerate the chart embedded in the test installer as needed. [\#1454](https://github.com/operator-framework/operator-lifecycle-manager/pull/1454) ([benluddy](https://github.com/benluddy))
- Fix upstream image build [\#1452](https://github.com/operator-framework/operator-lifecycle-manager/pull/1452) ([njhale](https://github.com/njhale))
- Added Github workflow for running e2e tests [\#1451](https://github.com/operator-framework/operator-lifecycle-manager/pull/1451) ([harishsurf](https://github.com/harishsurf))
- feat: support secrets from bundle [\#1447](https://github.com/operator-framework/operator-lifecycle-manager/pull/1447) ([exdx](https://github.com/exdx))
- chore\(docker\): add kubebuilder to base image [\#1446](https://github.com/operator-framework/operator-lifecycle-manager/pull/1446) ([njhale](https://github.com/njhale))
- fix: use busybox csv for catalog polling e2e test [\#1444](https://github.com/operator-framework/operator-lifecycle-manager/pull/1444) ([exdx](https://github.com/exdx))
- Add BugZilla component to OWNERS file [\#1442](https://github.com/operator-framework/operator-lifecycle-manager/pull/1442) ([dinhxuanvu](https://github.com/dinhxuanvu))
- Add initial SAT solver package. [\#1440](https://github.com/operator-framework/operator-lifecycle-manager/pull/1440) ([benluddy](https://github.com/benluddy))
- Convert package manifest e2e to ginkgo test [\#1439](https://github.com/operator-framework/operator-lifecycle-manager/pull/1439) ([harishsurf](https://github.com/harishsurf))
- Admission webhoooks [\#1436](https://github.com/operator-framework/operator-lifecycle-manager/pull/1436) ([awgreene](https://github.com/awgreene))
- feat: support configmap creation from the bundle [\#1434](https://github.com/operator-framework/operator-lifecycle-manager/pull/1434) ([exdx](https://github.com/exdx))
- Convert gc\_e2e\_test.go to ginkgo [\#1429](https://github.com/operator-framework/operator-lifecycle-manager/pull/1429) ([harishsurf](https://github.com/harishsurf))
- Modify dynamic\_resource\_e2e\_test to ginkgo [\#1424](https://github.com/operator-framework/operator-lifecycle-manager/pull/1424) ([harishsurf](https://github.com/harishsurf))
- Remove license year 2: Electric Boogaloo [\#1419](https://github.com/operator-framework/operator-lifecycle-manager/pull/1419) ([njhale](https://github.com/njhale))
- Create APIService after API server deployment [\#1418](https://github.com/operator-framework/operator-lifecycle-manager/pull/1418) ([awgreene](https://github.com/awgreene))
- feat: support v1 CRD objects in OLM [\#1416](https://github.com/operator-framework/operator-lifecycle-manager/pull/1416) ([exdx](https://github.com/exdx))
- Bug 1817833: Add spec validation and improved status for CatalogSources [\#1414](https://github.com/operator-framework/operator-lifecycle-manager/pull/1414) ([njhale](https://github.com/njhale))
- Add tests for GC assumptions. [\#1411](https://github.com/operator-framework/operator-lifecycle-manager/pull/1411) ([benluddy](https://github.com/benluddy))
- End-to-end test binary can set up test clusters [\#1410](https://github.com/operator-framework/operator-lifecycle-manager/pull/1410) ([benluddy](https://github.com/benluddy))
- Reconcile Namespace OG Labels in Namespace Syncer [\#1408](https://github.com/operator-framework/operator-lifecycle-manager/pull/1408) ([awgreene](https://github.com/awgreene))
- Bug 1815761: Fix installplan error when installing from bundles [\#1401](https://github.com/operator-framework/operator-lifecycle-manager/pull/1401) ([ecordell](https://github.com/ecordell))
- Add OG label to namespaces in OperatorGroup [\#1398](https://github.com/operator-framework/operator-lifecycle-manager/pull/1398) ([awgreene](https://github.com/awgreene))
- Ignore differences in CSV .status.conditions in unit tests. [\#1390](https://github.com/operator-framework/operator-lifecycle-manager/pull/1390) ([benluddy](https://github.com/benluddy))
- Bug 1814457: fix\(catsrc\): remove limits on catalogsource pods [\#1389](https://github.com/operator-framework/operator-lifecycle-manager/pull/1389) ([ecordell](https://github.com/ecordell))
- Add e2e test for multiple APIServices on a pod [\#1388](https://github.com/operator-framework/operator-lifecycle-manager/pull/1388) ([awgreene](https://github.com/awgreene))
- Add more CSV information to the PackageManifest [\#1387](https://github.com/operator-framework/operator-lifecycle-manager/pull/1387) ([dinhxuanvu](https://github.com/dinhxuanvu))
- Fix typo in subscription.crd template file [\#1381](https://github.com/operator-framework/operator-lifecycle-manager/pull/1381) ([harishsurf](https://github.com/harishsurf))
- \[release-4.2\] Bug 1797021: Fix bad opgroup annotations [\#1373](https://github.com/operator-framework/operator-lifecycle-manager/pull/1373) ([ecordell](https://github.com/ecordell))
- Convert e2e go tests to ginkgo - using ginkgo convert utility [\#1372](https://github.com/operator-framework/operator-lifecycle-manager/pull/1372) ([harishsurf](https://github.com/harishsurf))
- manifests\(prometheus\): failing operators should be a warning [\#1371](https://github.com/operator-framework/operator-lifecycle-manager/pull/1371) ([ecordell](https://github.com/ecordell))
- chore\(deps\): bump to kube 1.17.3 [\#1370](https://github.com/operator-framework/operator-lifecycle-manager/pull/1370) ([anik120](https://github.com/anik120))
- Bug 1810698: feat\(jitter\): add jitter to controllers to smooth out our spiky resource [\#1353](https://github.com/operator-framework/operator-lifecycle-manager/pull/1353) ([ecordell](https://github.com/ecordell))
- Clarify roles and adds info about Package Server [\#1350](https://github.com/operator-framework/operator-lifecycle-manager/pull/1350) ([flickerfly](https://github.com/flickerfly))
- Bug 1797747: Make provided API ClusterRoles be owned by the corresponding API. [\#1348](https://github.com/operator-framework/operator-lifecycle-manager/pull/1348) ([benluddy](https://github.com/benluddy))
- Bug 1808113: Fix OwnerReferences for bundled CRs [\#1341](https://github.com/operator-framework/operator-lifecycle-manager/pull/1341) ([njhale](https://github.com/njhale))
- Bug 1809294: Update subscription\_sync\_count to include the package name [\#1340](https://github.com/operator-framework/operator-lifecycle-manager/pull/1340) ([simrandhaliw](https://github.com/simrandhaliw))
- Bug 1805412: Support multiple APIServices on a single deployment [\#1339](https://github.com/operator-framework/operator-lifecycle-manager/pull/1339) ([awgreene](https://github.com/awgreene))
- fix\(make\): build cpb as prereq of e2e-local [\#1337](https://github.com/operator-framework/operator-lifecycle-manager/pull/1337) ([njhale](https://github.com/njhale))
- Tolerations & Resources Override using .Subscription.Config [\#1334](https://github.com/operator-framework/operator-lifecycle-manager/pull/1334) ([umangachapagain](https://github.com/umangachapagain))
- Unbreak the minikube mode of build\_local.sh. [\#1332](https://github.com/operator-framework/operator-lifecycle-manager/pull/1332) ([benluddy](https://github.com/benluddy))
- Fix kind detection for local builds. [\#1324](https://github.com/operator-framework/operator-lifecycle-manager/pull/1324) ([benluddy](https://github.com/benluddy))
- Bug 1807128: Don't block on ctx.Done\(\) if startup fails. [\#1323](https://github.com/operator-framework/operator-lifecycle-manager/pull/1323) ([benluddy](https://github.com/benluddy))
- Bug 1799463: Duplicate packages in packageserver APIService response  [\#1322](https://github.com/operator-framework/operator-lifecycle-manager/pull/1322) ([exdx](https://github.com/exdx))
- Add stale bot [\#1319](https://github.com/operator-framework/operator-lifecycle-manager/pull/1319) ([Bowenislandsong](https://github.com/Bowenislandsong))
- Bug 1784024: Use generations to prevent duplicate InstallPlans [\#1316](https://github.com/operator-framework/operator-lifecycle-manager/pull/1316) ([njhale](https://github.com/njhale))
- Update README to include OLM-Book [\#1314](https://github.com/operator-framework/operator-lifecycle-manager/pull/1314) ([awgreene](https://github.com/awgreene))
- add link to olm-book definition of subscription [\#1313](https://github.com/operator-framework/operator-lifecycle-manager/pull/1313) ([madorn](https://github.com/madorn))
- Bug 1805570: Remove run-level 1 from olm and openshift-operators namespaces [\#1308](https://github.com/operator-framework/operator-lifecycle-manager/pull/1308) ([dinhxuanvu](https://github.com/dinhxuanvu))
- Add some examples for Subscription config feature [\#1307](https://github.com/operator-framework/operator-lifecycle-manager/pull/1307) ([madorn](https://github.com/madorn))
- Bug 1804812: fix\(deployment\): deployment spec hash [\#1301](https://github.com/operator-framework/operator-lifecycle-manager/pull/1301) ([ecordell](https://github.com/ecordell))
- Bug 1798051: Reinstate v1alpha2 operatorgroup [\#1300](https://github.com/operator-framework/operator-lifecycle-manager/pull/1300) ([awgreene](https://github.com/awgreene))
- Bug 1786471: fix\(packagemanifests\): Fix index key func to avoid key collision [\#1284](https://github.com/operator-framework/operator-lifecycle-manager/pull/1284) ([dinhxuanvu](https://github.com/dinhxuanvu))
- Bug 1798645: fix\(bundles\): execute opm from tooling container [\#1252](https://github.com/operator-framework/operator-lifecycle-manager/pull/1252) ([njhale](https://github.com/njhale))
- Add alm-examples-metadata [\#1224](https://github.com/operator-framework/operator-lifecycle-manager/pull/1224) ([Jamstah](https://github.com/Jamstah))
- Bug 1762769: Prioritize APIs from same CatSrc [\#1080](https://github.com/operator-framework/operator-lifecycle-manager/pull/1080) ([awgreene](https://github.com/awgreene))
- Lock down package server runtime environment [\#1073](https://github.com/operator-framework/operator-lifecycle-manager/pull/1073) ([javanthropus](https://github.com/javanthropus))

# Changelog

## [0.14.1](https://github.com/operator-framework/operator-lifecycle-manager/tree/0.14.1) (2020-01-30)

[Full Changelog](https://github.com/operator-framework/operator-lifecycle-manager/compare/0.14.0...0.14.1)

**Closed issues:**

- \[Bug\] Cannot create a customresourcedefinition that has been exported via 'oc get -o yaml|json' command and then deleted [\#1260](https://github.com/operator-framework/operator-lifecycle-manager/issues/1260)

**Other changes:**

- Bump version to 0.14.1. [\#1264](https://github.com/operator-framework/operator-lifecycle-manager/pull/1264) ([benluddy](https://github.com/benluddy))
- Bug 1796092: Update operator-registry dependency to v1.5.8. [\#1258](https://github.com/operator-framework/operator-lifecycle-manager/pull/1258) ([benluddy](https://github.com/benluddy))
- Add support for Prometheus Custom Resources [\#1253](https://github.com/operator-framework/operator-lifecycle-manager/pull/1253) ([awgreene](https://github.com/awgreene))
- Fix overly broad .gitignore pattern that was excluding a vendored pac… [\#1250](https://github.com/operator-framework/operator-lifecycle-manager/pull/1250) ([benluddy](https://github.com/benluddy))

## [0.14.0](https://github.com/operator-framework/operator-lifecycle-manager/tree/0.14.0) (2020-01-24)

[Full Changelog](https://github.com/operator-framework/operator-lifecycle-manager/compare/0.13.0...0.14.0)

**Closed issues:**

- Instance creation for dependency operator [\#1214](https://github.com/operator-framework/operator-lifecycle-manager/issues/1214)
- operator-framework command [\#1206](https://github.com/operator-framework/operator-lifecycle-manager/issues/1206)
- validate installModes failed on OCP 4.2.0 [\#1204](https://github.com/operator-framework/operator-lifecycle-manager/issues/1204)
- \[Question\] What does `alm` means? [\#1193](https://github.com/operator-framework/operator-lifecycle-manager/issues/1193)
- Can I specify namespace in "required" operators  in clusterserviceversion  [\#1191](https://github.com/operator-framework/operator-lifecycle-manager/issues/1191)
- using OLM with a restricted network - pod deploy via oc appy does not resolve to use mirror? [\#1184](https://github.com/operator-framework/operator-lifecycle-manager/issues/1184)
- Cannot upgrade operator from v1alpha1 to v1beta1 [\#1180](https://github.com/operator-framework/operator-lifecycle-manager/issues/1180)
- CSV stuck in Pending state, requirement not met on missing serviceAccount that is defined in said CSV [\#1174](https://github.com/operator-framework/operator-lifecycle-manager/issues/1174)
- Cannot delete operator after delete subscription [\#1168](https://github.com/operator-framework/operator-lifecycle-manager/issues/1168)
- Why setting the replicas of packageserver as 2 [\#1164](https://github.com/operator-framework/operator-lifecycle-manager/issues/1164)
- OLM picks an operator dependency randomly for operators handling same resources kind provided by the same CatalogSource [\#1158](https://github.com/operator-framework/operator-lifecycle-manager/issues/1158)
- installplan contains unrelated ownerReference [\#1153](https://github.com/operator-framework/operator-lifecycle-manager/issues/1153)
- Security CVEs in release 0.12.0 [\#1121](https://github.com/operator-framework/operator-lifecycle-manager/issues/1121)
- operatorhubio-catalog is scheduled to run on a MS Windows worker node [\#1119](https://github.com/operator-framework/operator-lifecycle-manager/issues/1119)
- make run-console-local dont exists anymore [\#1064](https://github.com/operator-framework/operator-lifecycle-manager/issues/1064)
- olm-operator crashes with "fatal error: concurrent map iteration and map write" [\#1016](https://github.com/operator-framework/operator-lifecycle-manager/issues/1016)
- Delay of more than 10 minutes for operators to install if subscription is create right after a catalog is created [\#901](https://github.com/operator-framework/operator-lifecycle-manager/issues/901)
- local role becomes cluster role when operator is deployed. [\#874](https://github.com/operator-framework/operator-lifecycle-manager/issues/874)
- ClusterRoles with group/user subjects [\#786](https://github.com/operator-framework/operator-lifecycle-manager/issues/786)
- \(doc\) Link in the installation guide is not working [\#783](https://github.com/operator-framework/operator-lifecycle-manager/issues/783)
- Sync "olm" failed: no catalog sources available [\#740](https://github.com/operator-framework/operator-lifecycle-manager/issues/740)
- Link to example CSVs is incorrect [\#737](https://github.com/operator-framework/operator-lifecycle-manager/issues/737)
- OLM failed -- Tag latest not found in repository quay.io/coreos/olm [\#668](https://github.com/operator-framework/operator-lifecycle-manager/issues/668)
- Installation requirements missing [\#481](https://github.com/operator-framework/operator-lifecycle-manager/issues/481)

**Other changes:**

- Bump version to 0.14.0. [\#1248](https://github.com/operator-framework/operator-lifecycle-manager/pull/1248) ([benluddy](https://github.com/benluddy))
- Vendor helm, since it is used for templating manifests. [\#1247](https://github.com/operator-framework/operator-lifecycle-manager/pull/1247) ([benluddy](https://github.com/benluddy))
- Update internal objects proposal to use annotation on CSV instead of CRD [\#1235](https://github.com/operator-framework/operator-lifecycle-manager/pull/1235) ([robszumski](https://github.com/robszumski))
- adding e2e test framework for rh-operator metrics [\#1233](https://github.com/operator-framework/operator-lifecycle-manager/pull/1233) ([Bowenislandsong](https://github.com/Bowenislandsong))
- fix: typo in catalog polling doc [\#1232](https://github.com/operator-framework/operator-lifecycle-manager/pull/1232) ([exdx](https://github.com/exdx))
- Fix IPv6 incompatibility in TestGrpcAddressCatalogSource. [\#1231](https://github.com/operator-framework/operator-lifecycle-manager/pull/1231) ([benluddy](https://github.com/benluddy))
- Remove pyjq and yq from the release documentation prereqs. [\#1229](https://github.com/operator-framework/operator-lifecycle-manager/pull/1229) ([benluddy](https://github.com/benluddy))
- Update release script to require version 3 of helm. [\#1228](https://github.com/operator-framework/operator-lifecycle-manager/pull/1228) ([benluddy](https://github.com/benluddy))
- fix: refactor catalog polling to use updateStrategy field [\#1226](https://github.com/operator-framework/operator-lifecycle-manager/pull/1226) ([exdx](https://github.com/exdx))
- Reconcile manifests with templates. [\#1225](https://github.com/operator-framework/operator-lifecycle-manager/pull/1225) ([benluddy](https://github.com/benluddy))
- feat\(packageserver\): support label queries and copy CSV labels onto the package [\#1220](https://github.com/operator-framework/operator-lifecycle-manager/pull/1220) ([ecordell](https://github.com/ecordell))
- Only enable CGO for prod builds [\#1219](https://github.com/operator-framework/operator-lifecycle-manager/pull/1219) ([ecordell](https://github.com/ecordell))
- Use vendored transitive dependencies for "go run" of vendored yq. [\#1217](https://github.com/operator-framework/operator-lifecycle-manager/pull/1217) ([benluddy](https://github.com/benluddy))
- Enable CGO and CGO\_DEBUG [\#1216](https://github.com/operator-framework/operator-lifecycle-manager/pull/1216) ([jianzhangbjz](https://github.com/jianzhangbjz))
- Unpack bundles [\#1215](https://github.com/operator-framework/operator-lifecycle-manager/pull/1215) ([njhale](https://github.com/njhale))
- Bug 1791887: chore\(ci\): add dockerfile as a base for building in CI [\#1212](https://github.com/operator-framework/operator-lifecycle-manager/pull/1212) ([ecordell](https://github.com/ecordell))
- Bug 1785674: fix\(deploy\): remove resource limits [\#1207](https://github.com/operator-framework/operator-lifecycle-manager/pull/1207) ([ecordell](https://github.com/ecordell))
- Cleanup codegen [\#1202](https://github.com/operator-framework/operator-lifecycle-manager/pull/1202) ([njhale](https://github.com/njhale))
- Bug 1783011: \[release-4.3\]  Fix CI Unit tests. [\#1196](https://github.com/operator-framework/operator-lifecycle-manager/pull/1196) ([openshift-cherrypick-robot](https://github.com/openshift-cherrypick-robot))
- Bug 1781366: feat\(resolver\): fallback to csv parsing if grcp api does not contain info [\#1194](https://github.com/operator-framework/operator-lifecycle-manager/pull/1194) ([ecordell](https://github.com/ecordell))
- Corrected etcd CRD URL. [\#1192](https://github.com/operator-framework/operator-lifecycle-manager/pull/1192) ([gyliu513](https://github.com/gyliu513))
- Dep is not required. [\#1187](https://github.com/operator-framework/operator-lifecycle-manager/pull/1187) ([gyliu513](https://github.com/gyliu513))
- Add note for version field [\#1185](https://github.com/operator-framework/operator-lifecycle-manager/pull/1185) ([clyang82](https://github.com/clyang82))
- docs - add a mention of bundles to the README to help users find bundle info… [\#1176](https://github.com/operator-framework/operator-lifecycle-manager/pull/1176) ([jmccormick2001](https://github.com/jmccormick2001))
- BUG: Fix CI Unit tests. [\#1175](https://github.com/operator-framework/operator-lifecycle-manager/pull/1175) ([awgreene](https://github.com/awgreene))
- fix: add err check before further operation [\#1173](https://github.com/operator-framework/operator-lifecycle-manager/pull/1173) ([beautytiger](https://github.com/beautytiger))
- Added `keywords` in operator metadata. [\#1163](https://github.com/operator-framework/operator-lifecycle-manager/pull/1163) ([gyliu513](https://github.com/gyliu513))
- feat: catalog source polling for updated registry image [\#1161](https://github.com/operator-framework/operator-lifecycle-manager/pull/1161) ([exdx](https://github.com/exdx))
- Bug 1769003: Implement Structural Schema for CRDs [\#1157](https://github.com/operator-framework/operator-lifecycle-manager/pull/1157) ([awgreene](https://github.com/awgreene))
- fix: make run\_console\_local.sh working on WSLv1 [\#1154](https://github.com/operator-framework/operator-lifecycle-manager/pull/1154) ([wilmardo](https://github.com/wilmardo))
- Add general design goals doc [\#1152](https://github.com/operator-framework/operator-lifecycle-manager/pull/1152) ([njhale](https://github.com/njhale))
- bug 1771811: make certificate updates live upon update [\#1151](https://github.com/operator-framework/operator-lifecycle-manager/pull/1151) ([jpeeler](https://github.com/jpeeler))
- Bug 1779990: fix\(packageserver\): cache packagemanifests [\#1150](https://github.com/operator-framework/operator-lifecycle-manager/pull/1150) ([njhale](https://github.com/njhale))
- fix\(unit\): Fix minor unit test bug and update local cluster to k8s 1.16 [\#1147](https://github.com/operator-framework/operator-lifecycle-manager/pull/1147) ([dinhxuanvu](https://github.com/dinhxuanvu))
- Bug 1760608: add resource limits to all OLM pods and the 0.13.0 release for OCP [\#1142](https://github.com/operator-framework/operator-lifecycle-manager/pull/1142) ([exdx](https://github.com/exdx))
- \[docs\] update changelog command [\#1137](https://github.com/operator-framework/operator-lifecycle-manager/pull/1137) ([gallettilance](https://github.com/gallettilance))
- Generate release changelog [\#1135](https://github.com/operator-framework/operator-lifecycle-manager/pull/1135) ([gallettilance](https://github.com/gallettilance))
- \[release\] - making new release [\#1134](https://github.com/operator-framework/operator-lifecycle-manager/pull/1134) ([gallettilance](https://github.com/gallettilance))
- Bug 1773661: schedule catalogsource pods to linux nodes only [\#1132](https://github.com/operator-framework/operator-lifecycle-manager/pull/1132) ([exdx](https://github.com/exdx))
- Bug 1779313: Enable multiple namespaces sync if catsrc is updated in global ns [\#1125](https://github.com/operator-framework/operator-lifecycle-manager/pull/1125) ([dinhxuanvu](https://github.com/dinhxuanvu))
- Bug 1769030: Replacing operator creates duplicate secrets [\#1123](https://github.com/operator-framework/operator-lifecycle-manager/pull/1123) ([Bowenislandsong](https://github.com/Bowenislandsong))
- Bug 1774720: catalogsource context cancel function leak [\#1116](https://github.com/operator-framework/operator-lifecycle-manager/pull/1116) ([exdx](https://github.com/exdx))
- Bug 1767004: defer provided api update in operator groups [\#1114](https://github.com/operator-framework/operator-lifecycle-manager/pull/1114) ([jpeeler](https://github.com/jpeeler))
- Use the grpc response as the source of truth for update graph data [\#1105](https://github.com/operator-framework/operator-lifecycle-manager/pull/1105) ([ecordell](https://github.com/ecordell))
- doc: add internal image proposal [\#1097](https://github.com/operator-framework/operator-lifecycle-manager/pull/1097) ([robszumski](https://github.com/robszumski))
- Bug 1763749: Prioritize APIs from same CatSrc [\#1091](https://github.com/operator-framework/operator-lifecycle-manager/pull/1091) ([awgreene](https://github.com/awgreene))

# Changelog

## [0.13.0](https://github.com/operator-framework/operator-lifecycle-manager/tree/0.13.0) (2019-11-15)

[Full Changelog](https://github.com/operator-framework/operator-lifecycle-manager/compare/0.13.0...0.13.0)

**Other changes:**

- Bug 1767004: defer provided api update in operator groups [\#1114](https://github.com/operator-framework/operator-lifecycle-manager/pull/1114) ([jpeeler](https://github.com/jpeeler))

## [0.13.0](https://github.com/operator-framework/operator-lifecycle-manager/tree/0.13.0) (2019-11-15)

[Full Changelog](https://github.com/operator-framework/operator-lifecycle-manager/compare/0.12.0...0.13.0)

**Closed issues:**

- Issue 2 [\#1127](https://github.com/operator-framework/operator-lifecycle-manager/issues/1127)
- Issue 1 [\#1126](https://github.com/operator-framework/operator-lifecycle-manager/issues/1126)
- Slack channel? [\#1117](https://github.com/operator-framework/operator-lifecycle-manager/issues/1117)
- InstallPlans not being generated on OpenShift 3.11 with OLM 0.12.0 [\#1113](https://github.com/operator-framework/operator-lifecycle-manager/issues/1113)
- MinKubeVersion error msg as a requirement can cause misunderstandings  [\#1093](https://github.com/operator-framework/operator-lifecycle-manager/issues/1093)
- Instances of Clusterwide CRDs are not displayed properly in InstalledOperators [\#1077](https://github.com/operator-framework/operator-lifecycle-manager/issues/1077)
- CSV required CRDs are resolved from an unpredictable catalog [\#1076](https://github.com/operator-framework/operator-lifecycle-manager/issues/1076)
- Missing channels from package.yaml definition [\#1072](https://github.com/operator-framework/operator-lifecycle-manager/issues/1072)
- Security: new CVEs in 0.12.0 release AND in master, new fixes/release coming?  [\#1066](https://github.com/operator-framework/operator-lifecycle-manager/issues/1066)
- How to troubleshot what is happening with a subscription [\#1063](https://github.com/operator-framework/operator-lifecycle-manager/issues/1063)
- 0.12.0 release isn't versioned correctly [\#1061](https://github.com/operator-framework/operator-lifecycle-manager/issues/1061)

**Other changes:**

- \[docs\] - update release docs [\#1131](https://github.com/operator-framework/operator-lifecycle-manager/pull/1131) ([gallettilance](https://github.com/gallettilance))
- \[release\] - version bump [\#1130](https://github.com/operator-framework/operator-lifecycle-manager/pull/1130) ([gallettilance](https://github.com/gallettilance))
- Fixing doc typo [\#1115](https://github.com/operator-framework/operator-lifecycle-manager/pull/1115) ([bandrade](https://github.com/bandrade))
- Fix several flaky e2e test cases [\#1111](https://github.com/operator-framework/operator-lifecycle-manager/pull/1111) ([dinhxuanvu](https://github.com/dinhxuanvu))
- Alerts for failing OLM operators [\#1104](https://github.com/operator-framework/operator-lifecycle-manager/pull/1104) ([anik120](https://github.com/anik120))
- feat\(resolver\): use provided and required apis from grpc [\#1101](https://github.com/operator-framework/operator-lifecycle-manager/pull/1101) ([ecordell](https://github.com/ecordell))
- feat\(metrics\) Report subscription channel [\#1100](https://github.com/operator-framework/operator-lifecycle-manager/pull/1100) ([awgreene](https://github.com/awgreene))
- feat\(metrics\) Limit Cardinality of CSV metrics [\#1099](https://github.com/operator-framework/operator-lifecycle-manager/pull/1099) ([awgreene](https://github.com/awgreene))
- fix: t.Fatal should be used in main goroutine [\#1096](https://github.com/operator-framework/operator-lifecycle-manager/pull/1096) ([beautytiger](https://github.com/beautytiger))
- docs: Corrected CSV upgrade version. [\#1095](https://github.com/operator-framework/operator-lifecycle-manager/pull/1095) ([gyliu513](https://github.com/gyliu513))
- fix\(olm\): No longer report status if minKubeVersion not specified [\#1094](https://github.com/operator-framework/operator-lifecycle-manager/pull/1094) ([dinhxuanvu](https://github.com/dinhxuanvu))
- fix: refresh architecture and philosophy docs for clarity purposes [\#1092](https://github.com/operator-framework/operator-lifecycle-manager/pull/1092) ([Denton24646](https://github.com/Denton24646))
- Updated values.yaml location. [\#1089](https://github.com/operator-framework/operator-lifecycle-manager/pull/1089) ([gyliu513](https://github.com/gyliu513))
- fix: fix particular typo in clusterserviceversion\_types.go [\#1086](https://github.com/operator-framework/operator-lifecycle-manager/pull/1086) ([Denton24646](https://github.com/Denton24646))
- Fix log message in resolver [\#1085](https://github.com/operator-framework/operator-lifecycle-manager/pull/1085) ([ecordell](https://github.com/ecordell))
- URL with modified manifest directory structure [\#1083](https://github.com/operator-framework/operator-lifecycle-manager/pull/1083) ([sbose78](https://github.com/sbose78))
- Bug 1762769: Prioritize APIs from same CatSrc [\#1080](https://github.com/operator-framework/operator-lifecycle-manager/pull/1080) ([awgreene](https://github.com/awgreene))
- Update Owners [\#1079](https://github.com/operator-framework/operator-lifecycle-manager/pull/1079) ([alecmerdler](https://github.com/alecmerdler))
- Bug 1761924:  Update PackageManifest table handler [\#1078](https://github.com/operator-framework/operator-lifecycle-manager/pull/1078) ([awgreene](https://github.com/awgreene))
- bugfix: assignment to nil map will cause panic [\#1071](https://github.com/operator-framework/operator-lifecycle-manager/pull/1071) ([beautytiger](https://github.com/beautytiger))
- Proposal: RelatedImages [\#1069](https://github.com/operator-framework/operator-lifecycle-manager/pull/1069) ([ecordell](https://github.com/ecordell))
- Add `apk upgrade` to upstream builder [\#1067](https://github.com/operator-framework/operator-lifecycle-manager/pull/1067) ([ecordell](https://github.com/ecordell))
- Fix links to console repo for moved packages [\#1065](https://github.com/operator-framework/operator-lifecycle-manager/pull/1065) ([spadgett](https://github.com/spadgett))
- bug\(install\) Fix packageserver name in install.sh [\#1062](https://github.com/operator-framework/operator-lifecycle-manager/pull/1062) ([awgreene](https://github.com/awgreene))
- Bug 1758008: Manual approval strategy ignored for subsequent releases [\#1059](https://github.com/operator-framework/operator-lifecycle-manager/pull/1059) ([dinhxuanvu](https://github.com/dinhxuanvu))
- feat\(subscription\) Config Volume and VolumeMounts [\#1058](https://github.com/operator-framework/operator-lifecycle-manager/pull/1058) ([awgreene](https://github.com/awgreene))
- Bug: Fix olm chart [\#1056](https://github.com/operator-framework/operator-lifecycle-manager/pull/1056) ([awgreene](https://github.com/awgreene))
- feat\(metrics\) record CSV failures [\#1055](https://github.com/operator-framework/operator-lifecycle-manager/pull/1055) ([awgreene](https://github.com/awgreene))
- \[WIP\] \(proposal\) Make bundle accessible to a cluster [\#1054](https://github.com/operator-framework/operator-lifecycle-manager/pull/1054) ([tkashem](https://github.com/tkashem))
- Bump openshift/client-go version [\#1052](https://github.com/operator-framework/operator-lifecycle-manager/pull/1052) ([njhale](https://github.com/njhale))
- \(release\) Update changelog [\#1051](https://github.com/operator-framework/operator-lifecycle-manager/pull/1051) ([awgreene](https://github.com/awgreene))
- \(release\) Generate manifests for 0.12.0 [\#1050](https://github.com/operator-framework/operator-lifecycle-manager/pull/1050) ([awgreene](https://github.com/awgreene))
- chore\(deps\): bump to kube 1.16 [\#1048](https://github.com/operator-framework/operator-lifecycle-manager/pull/1048) ([ecordell](https://github.com/ecordell))
- fix\(subscriptionconfig\): add missing merge struct tags [\#996](https://github.com/operator-framework/operator-lifecycle-manager/pull/996) ([njhale](https://github.com/njhale))
- refactor\(operatorstatus\): make monitor constructor variadic [\#995](https://github.com/operator-framework/operator-lifecycle-manager/pull/995) ([njhale](https://github.com/njhale))
- feat\(scripts\): add shell lib with some common helper funcs [\#994](https://github.com/operator-framework/operator-lifecycle-manager/pull/994) ([njhale](https://github.com/njhale))

## [0.12.0](https://github.com/operator-framework/operator-lifecycle-manager/tree/0.12.0) (2019-09-27)
[Full Changelog](https://github.com/operator-framework/operator-lifecycle-manager/compare/0.12.0...0.12.0)

**Other changes:**

- \(release\) Generate manifests for 0.12.0 [\#1050](https://github.com/operator-framework/operator-lifecycle-manager/pull/1050) ([awgreene](https://github.com/awgreene))
- \[release-4.1\] Bug 1753394: include git sha in ART builds [\#1044](https://github.com/operator-framework/operator-lifecycle-manager/pull/1044) ([openshift-cherrypick-robot](https://github.com/openshift-cherrypick-robot))

## [0.12.0](https://github.com/operator-framework/operator-lifecycle-manager/tree/0.12.0) (2019-09-26)
[Full Changelog](https://github.com/operator-framework/operator-lifecycle-manager/compare/0.11.0...0.12.0)

**Closed issues:**

- Using OLM API with another operator [\#1042](https://github.com/operator-framework/operator-lifecycle-manager/issues/1042)
- Build fails because of coreos/etcd checksum mismatch [\#1032](https://github.com/operator-framework/operator-lifecycle-manager/issues/1032)
- \[client-go\] An exception occurred when the version number contains English letters [\#1030](https://github.com/operator-framework/operator-lifecycle-manager/issues/1030)
- Rolling updates nullify use of readiness probes [\#1028](https://github.com/operator-framework/operator-lifecycle-manager/issues/1028)
- Feature Request: Support additional resources in ClusterServiceVersion, like StatefulSet and DaemonSet [\#1022](https://github.com/operator-framework/operator-lifecycle-manager/issues/1022)
- Catalog operator consumes 9GB of memory and shows errors of unhealty clients [\#1015](https://github.com/operator-framework/operator-lifecycle-manager/issues/1015)
- \[Question\] How the dependency feature suppose to work? [\#1010](https://github.com/operator-framework/operator-lifecycle-manager/issues/1010)
- OLM creating tons of packageservers [\#986](https://github.com/operator-framework/operator-lifecycle-manager/issues/986)
- The ability to pull CatalogSource images from private docker registries [\#982](https://github.com/operator-framework/operator-lifecycle-manager/issues/982)
- install.sh \(0.11.0\) fails to find the the packageserver csv [\#981](https://github.com/operator-framework/operator-lifecycle-manager/issues/981)
- Service and ConfigMap specification in ClusterServiceVersion [\#972](https://github.com/operator-framework/operator-lifecycle-manager/issues/972)
- Over 10 minutes of delay for operator upgrade to initiate after CatalogSource image is updated. [\#947](https://github.com/operator-framework/operator-lifecycle-manager/issues/947)

**Other changes:**

- \(docs\) Update release.md documentation [\#1047](https://github.com/operator-framework/operator-lifecycle-manager/pull/1047) ([awgreene](https://github.com/awgreene))
- \(release\) cut a release for 0.12.0 [\#1046](https://github.com/operator-framework/operator-lifecycle-manager/pull/1046) ([awgreene](https://github.com/awgreene))
- Bug 1749036: fix install behavior both during and post-install permission changes [\#1039](https://github.com/operator-framework/operator-lifecycle-manager/pull/1039) ([jpeeler](https://github.com/jpeeler))
- Enable vendoring on Go 1.1x [\#1038](https://github.com/operator-framework/operator-lifecycle-manager/pull/1038) ([skitt](https://github.com/skitt))
- \[release-4.1\] Bug 1750867: Make packagemanifest list return all valid packages [\#1037](https://github.com/operator-framework/operator-lifecycle-manager/pull/1037) ([njhale](https://github.com/njhale))
- chore\(docs\): consolidate doc directories [\#1033](https://github.com/operator-framework/operator-lifecycle-manager/pull/1033) ([njhale](https://github.com/njhale))
- Fix broken doc links [\#1031](https://github.com/operator-framework/operator-lifecycle-manager/pull/1031) ([dimitraz](https://github.com/dimitraz))
- Bug 1746811: Make packagemanifest list return all valid packages [\#1029](https://github.com/operator-framework/operator-lifecycle-manager/pull/1029) ([njhale](https://github.com/njhale))
- Bug 1750980: feat\(olm\): don't calculate a patch when updating via a replacement chain [\#1027](https://github.com/operator-framework/operator-lifecycle-manager/pull/1027) ([ecordell](https://github.com/ecordell))
- Bug 1748771: Default Icon for PackageManifest Subresource [\#1026](https://github.com/operator-framework/operator-lifecycle-manager/pull/1026) ([alecmerdler](https://github.com/alecmerdler))
- Bug 1746159: Cleanup leftover cross-namespace OwnerReferences [\#1025](https://github.com/operator-framework/operator-lifecycle-manager/pull/1025) ([njhale](https://github.com/njhale))
- Bug 1744245: Subscription should not point to deleted ip [\#1023](https://github.com/operator-framework/operator-lifecycle-manager/pull/1023) ([tkashem](https://github.com/tkashem))
- Bug 1748914: Drop the hard-coded DNS suffix [\#1019](https://github.com/operator-framework/operator-lifecycle-manager/pull/1019) ([skitt](https://github.com/skitt))
- Bug 1717636: Add proper name to related objects [\#1018](https://github.com/operator-framework/operator-lifecycle-manager/pull/1018) ([jpeeler](https://github.com/jpeeler))
- \[CatalogSource\] Set Global Catalog NS with EnvVar [\#1014](https://github.com/operator-framework/operator-lifecycle-manager/pull/1014) ([awgreene](https://github.com/awgreene))
- Bug 1741799: Remove InstallPlan Source, SourceNamespace from UX [\#1013](https://github.com/operator-framework/operator-lifecycle-manager/pull/1013) ([kevinrizza](https://github.com/kevinrizza))
- Bug 1717638 fix\(olm\): report name and group for related objects [\#1012](https://github.com/operator-framework/operator-lifecycle-manager/pull/1012) ([jpeeler](https://github.com/jpeeler))
- Stop relying on pgrep -q [\#1011](https://github.com/operator-framework/operator-lifecycle-manager/pull/1011) ([skitt](https://github.com/skitt))
- Bug 1746659: chore\(deps\): update grpc dependency [\#1009](https://github.com/operator-framework/operator-lifecycle-manager/pull/1009) ([ecordell](https://github.com/ecordell))
- Bug 1745626: Update GRPC libs [\#1008](https://github.com/operator-framework/operator-lifecycle-manager/pull/1008) ([ecordell](https://github.com/ecordell))
- Bug 1740332: OLM should resume operator install [\#1006](https://github.com/operator-framework/operator-lifecycle-manager/pull/1006) ([tkashem](https://github.com/tkashem))
- Bug 1744490: Add RBAC for PackageManifest Icon Subresource [\#1005](https://github.com/operator-framework/operator-lifecycle-manager/pull/1005) ([alecmerdler](https://github.com/alecmerdler))
- Bug 1738203: Add relatedObjects to cluster operator status  [\#1004](https://github.com/operator-framework/operator-lifecycle-manager/pull/1004) ([dinhxuanvu](https://github.com/dinhxuanvu))
- Bug 1727800: Remove Icon from `PackageManifest` Resource [\#1002](https://github.com/operator-framework/operator-lifecycle-manager/pull/1002) ([alecmerdler](https://github.com/alecmerdler))
- Bug 1744245: fix e2e failure [\#1001](https://github.com/operator-framework/operator-lifecycle-manager/pull/1001) ([tkashem](https://github.com/tkashem))
- Bug 1741475: test\(e2e\): Update permissions during operator upgrade [\#998](https://github.com/operator-framework/operator-lifecycle-manager/pull/998) ([ecordell](https://github.com/ecordell))
- Readme adjustments [\#993](https://github.com/operator-framework/operator-lifecycle-manager/pull/993) ([camilamacedo86](https://github.com/camilamacedo86))
- fix name of dir - replace Documentation for doc [\#992](https://github.com/operator-framework/operator-lifecycle-manager/pull/992) ([camilamacedo86](https://github.com/camilamacedo86))
- feat\(github\) : Add github files [\#991](https://github.com/operator-framework/operator-lifecycle-manager/pull/991) ([camilamacedo86](https://github.com/camilamacedo86))
- Bug 1727800: Icon Subresource for PackageManifest [\#990](https://github.com/operator-framework/operator-lifecycle-manager/pull/990) ([alecmerdler](https://github.com/alecmerdler))
- Bug 1727042: feat\(operatorstatus\): report packageserver as upgradeable [\#989](https://github.com/operator-framework/operator-lifecycle-manager/pull/989) ([ecordell](https://github.com/ecordell))
- \(doc\) How to update operators documentation [\#988](https://github.com/operator-framework/operator-lifecycle-manager/pull/988) ([dinhxuanvu](https://github.com/dinhxuanvu))
- fix\(deploy\): change local deploy to use olm namespace [\#987](https://github.com/operator-framework/operator-lifecycle-manager/pull/987) ([jpeeler](https://github.com/jpeeler))
- Proposal for PackageManifest Icon Subresource [\#985](https://github.com/operator-framework/operator-lifecycle-manager/pull/985) ([alecmerdler](https://github.com/alecmerdler))
- \(doc\) Add deprecated CRD version procedure and note [\#984](https://github.com/operator-framework/operator-lifecycle-manager/pull/984) ([dinhxuanvu](https://github.com/dinhxuanvu))
- Bug 1746270: Remove deprecated CRD's stored versions to allow CRD update [\#983](https://github.com/operator-framework/operator-lifecycle-manager/pull/983) ([dinhxuanvu](https://github.com/dinhxuanvu))
- Bug 1702552: Two "NAME" fields by command "oc get catalogsource" [\#980](https://github.com/operator-framework/operator-lifecycle-manager/pull/980) ([dinhxuanvu](https://github.com/dinhxuanvu))
- Bug 1743748:  Report `Upgradeable` in ClusterOperator status [\#979](https://github.com/operator-framework/operator-lifecycle-manager/pull/979) ([openshift-cherrypick-robot](https://github.com/openshift-cherrypick-robot))
- Bug 1737057: Sub CRD does not validate config [\#978](https://github.com/operator-framework/operator-lifecycle-manager/pull/978) ([tkashem](https://github.com/tkashem))
- Bug 1740174: fix\(catalog\): re-install resources in existing installplan [\#977](https://github.com/operator-framework/operator-lifecycle-manager/pull/977) ([jpeeler](https://github.com/jpeeler))
- Bug 1737156: feat\(metrics\): record sync count for Subscriptions, labeled with name and installedCSV [\#976](https://github.com/operator-framework/operator-lifecycle-manager/pull/976) ([ecordell](https://github.com/ecordell))
- Bug 1737081: catsrc status should show error  [\#974](https://github.com/operator-framework/operator-lifecycle-manager/pull/974) ([tkashem](https://github.com/tkashem))
- Bug 1732914: Operator upgrades fail when versions field is not set [\#973](https://github.com/operator-framework/operator-lifecycle-manager/pull/973) ([dinhxuanvu](https://github.com/dinhxuanvu))
- Bug 1727032 Report `Upgradeable` in ClusterOperator status [\#971](https://github.com/operator-framework/operator-lifecycle-manager/pull/971) ([kevinrizza](https://github.com/kevinrizza))
- Bug 1743345: clean up service account, cluster roles, and cluster role bindings after CSV deletion [\#970](https://github.com/operator-framework/operator-lifecycle-manager/pull/970) ([jpeeler](https://github.com/jpeeler))
- \(doc\) add doc for scoped operator install [\#969](https://github.com/operator-framework/operator-lifecycle-manager/pull/969) ([tkashem](https://github.com/tkashem))
- \(doc\) update new release doc [\#968](https://github.com/operator-framework/operator-lifecycle-manager/pull/968) ([tkashem](https://github.com/tkashem))
- \(release\) update changelog [\#967](https://github.com/operator-framework/operator-lifecycle-manager/pull/967) ([tkashem](https://github.com/tkashem))
- \(release\) generate manifests for 0.11.0 [\#966](https://github.com/operator-framework/operator-lifecycle-manager/pull/966) ([tkashem](https://github.com/tkashem))
- Bug 1714140: fix\(catalog\): re-install resources in existing installplan [\#965](https://github.com/operator-framework/operator-lifecycle-manager/pull/965) ([jpeeler](https://github.com/jpeeler))
- Bug 1732214: Fix panic when binding already exists [\#964](https://github.com/operator-framework/operator-lifecycle-manager/pull/964) ([ecordell](https://github.com/ecordell))
- Bug 1662263: include git sha in ART builds [\#961](https://github.com/operator-framework/operator-lifecycle-manager/pull/961) ([tkashem](https://github.com/tkashem))
- Bug 1717636: Add relatedObjects to cluster operator status [\#960](https://github.com/operator-framework/operator-lifecycle-manager/pull/960) ([dinhxuanvu](https://github.com/dinhxuanvu))
- Bug 1732613: Follow up for pod configuration [\#958](https://github.com/operator-framework/operator-lifecycle-manager/pull/958) ([tkashem](https://github.com/tkashem))
- \(proposal\) improved csv status reporting [\#939](https://github.com/operator-framework/operator-lifecycle-manager/pull/939) ([tkashem](https://github.com/tkashem))
- Operator validation library project proposal [\#924](https://github.com/operator-framework/operator-lifecycle-manager/pull/924) ([gallettilance](https://github.com/gallettilance))

## [0.11.0](https://github.com/operator-framework/operator-lifecycle-manager/tree/0.11.0) (2019-07-26)
[Full Changelog](https://github.com/operator-framework/operator-lifecycle-manager/compare/0.11.0...0.11.0)

**Other changes:**

- Bug 1732613: Follow up for pod configuration [\#958](https://github.com/operator-framework/operator-lifecycle-manager/pull/958) ([tkashem](https://github.com/tkashem))
- test\(e2e\): remove extra resource comparison [\#938](https://github.com/operator-framework/operator-lifecycle-manager/pull/938) ([njhale](https://github.com/njhale))

## [0.11.0](https://github.com/operator-framework/operator-lifecycle-manager/tree/0.11.0) (2019-07-25)
[Full Changelog](https://github.com/operator-framework/operator-lifecycle-manager/compare/0.10.1...0.11.0)

**Closed issues:**

- Get OLM version from cluster [\#935](https://github.com/operator-framework/operator-lifecycle-manager/issues/935)
- Is there documentation for a ClusterServiceVersion install.strategy=image? [\#905](https://github.com/operator-framework/operator-lifecycle-manager/issues/905)
- ignore [\#899](https://github.com/operator-framework/operator-lifecycle-manager/issues/899)
- Wrong steps in the Release notes \(0.10.0\) [\#895](https://github.com/operator-framework/operator-lifecycle-manager/issues/895)
- Ignore [\#894](https://github.com/operator-framework/operator-lifecycle-manager/issues/894)
- Unable to use OLM tool when the operator is cluster-scoped and has not the role [\#888](https://github.com/operator-framework/operator-lifecycle-manager/issues/888)
- Unable to run UI console for OLM [\#886](https://github.com/operator-framework/operator-lifecycle-manager/issues/886)
- Docs - Add a better explanation over the install commands [\#782](https://github.com/operator-framework/operator-lifecycle-manager/issues/782)
- ignore [\#781](https://github.com/operator-framework/operator-lifecycle-manager/issues/781)

**Other changes:**

- \(release\) cut a release for 0.11.0 [\#962](https://github.com/operator-framework/operator-lifecycle-manager/pull/962) ([tkashem](https://github.com/tkashem))
- Bug 1732302: Fix panic when binding already exists [\#959](https://github.com/operator-framework/operator-lifecycle-manager/pull/959) ([cblecker](https://github.com/cblecker))
- fix\(manifest\): fix env var projection in command [\#957](https://github.com/operator-framework/operator-lifecycle-manager/pull/957) ([ecordell](https://github.com/ecordell))
- feat\(deploy\): add resource requests to all pods [\#955](https://github.com/operator-framework/operator-lifecycle-manager/pull/955) ([jpeeler](https://github.com/jpeeler))
- chore\(modules\): pin k8s deps to 1.14 [\#954](https://github.com/operator-framework/operator-lifecycle-manager/pull/954) ([njhale](https://github.com/njhale))
- feat\(metrics\): record sync count for Subscriptions, labeled with name and installedCSV [\#951](https://github.com/operator-framework/operator-lifecycle-manager/pull/951) ([ecordell](https://github.com/ecordell))
- Pod configuration [\#950](https://github.com/operator-framework/operator-lifecycle-manager/pull/950) ([tkashem](https://github.com/tkashem))
- Minor fixes [\#945](https://github.com/operator-framework/operator-lifecycle-manager/pull/945) ([jpeeler](https://github.com/jpeeler))
- Add simple benchmark for namespaced subscription resolution [\#943](https://github.com/operator-framework/operator-lifecycle-manager/pull/943) ([njhale](https://github.com/njhale))
- Remove package server subscription  [\#942](https://github.com/operator-framework/operator-lifecycle-manager/pull/942) ([ecordell](https://github.com/ecordell))
- proposal\(operator-config\): initial proposal for persisting configuration [\#941](https://github.com/operator-framework/operator-lifecycle-manager/pull/941) ([ecordell](https://github.com/ecordell))
- 1723818: package server 4.1 to 4.2 upgrade should not fail [\#937](https://github.com/operator-framework/operator-lifecycle-manager/pull/937) ([tkashem](https://github.com/tkashem))
- Validate existing Custom Resources against new schema prior updating [\#933](https://github.com/operator-framework/operator-lifecycle-manager/pull/933) ([dinhxuanvu](https://github.com/dinhxuanvu))
- feat\(csv\): detect changes to a deployment and persist them [\#931](https://github.com/operator-framework/operator-lifecycle-manager/pull/931) ([ecordell](https://github.com/ecordell))
- Add optional profiling [\#929](https://github.com/operator-framework/operator-lifecycle-manager/pull/929) ([njhale](https://github.com/njhale))
- manifests: move ServiceMonitor manifest to runlevel 90 [\#928](https://github.com/operator-framework/operator-lifecycle-manager/pull/928) ([paulfantom](https://github.com/paulfantom))
- Bug 1723818: CSV name change should not cause upgrade to fail [\#925](https://github.com/operator-framework/operator-lifecycle-manager/pull/925) ([tkashem](https://github.com/tkashem))
- Add Subscription InstallPlan Status [\#923](https://github.com/operator-framework/operator-lifecycle-manager/pull/923) ([njhale](https://github.com/njhale))
- Add a target for compiling bare e2e [\#921](https://github.com/operator-framework/operator-lifecycle-manager/pull/921) ([jpeeler](https://github.com/jpeeler))
- fix\(test\): fixup bare test imports and vars [\#920](https://github.com/operator-framework/operator-lifecycle-manager/pull/920) ([jpeeler](https://github.com/jpeeler))
- fix\(build\): set GO111MODULE=on [\#918](https://github.com/operator-framework/operator-lifecycle-manager/pull/918) ([jpeeler](https://github.com/jpeeler))
- Update CHANGELOG to include changelogs from 0.10.0 and 0.10.1 [\#917](https://github.com/operator-framework/operator-lifecycle-manager/pull/917) ([dinhxuanvu](https://github.com/dinhxuanvu))
- docs\(release\): add additional clarifying details [\#916](https://github.com/operator-framework/operator-lifecycle-manager/pull/916) ([jpeeler](https://github.com/jpeeler))
- Bug 1723851: fix\(catalog\): do not add owner references to clusterroles or crbs \(4.1 cherrypick\) [\#915](https://github.com/operator-framework/operator-lifecycle-manager/pull/915) ([ecordell](https://github.com/ecordell))
- Switch to go 1.12 in the root Dockerfile [\#914](https://github.com/operator-framework/operator-lifecycle-manager/pull/914) ([ecordell](https://github.com/ecordell))
- Add webhook proposal [\#913](https://github.com/operator-framework/operator-lifecycle-manager/pull/913) ([jpeeler](https://github.com/jpeeler))
- fix\(build\): don't use helm in src image [\#912](https://github.com/operator-framework/operator-lifecycle-manager/pull/912) ([ecordell](https://github.com/ecordell))
- Add config options to QueueInformer constructors [\#911](https://github.com/operator-framework/operator-lifecycle-manager/pull/911) ([njhale](https://github.com/njhale))
- fix\(chart\): add missing descriptions to operator group [\#910](https://github.com/operator-framework/operator-lifecycle-manager/pull/910) ([jpeeler](https://github.com/jpeeler))
- allow KUBECONFIG to be set from env in run\_e2e\_bare.sh [\#909](https://github.com/operator-framework/operator-lifecycle-manager/pull/909) ([jpeeler](https://github.com/jpeeler))
- add -l option to $POD\_MANAGER attach [\#907](https://github.com/operator-framework/operator-lifecycle-manager/pull/907) ([madorn](https://github.com/madorn))
- Fix PackageManifest Server Crashes [\#904](https://github.com/operator-framework/operator-lifecycle-manager/pull/904) ([alecmerdler](https://github.com/alecmerdler))
- Allow CRD updates with multiple owners [\#902](https://github.com/operator-framework/operator-lifecycle-manager/pull/902) ([jpeeler](https://github.com/jpeeler))
- Bug 1691546: fix\(catalog\): do not add owner references to clusterroles or crbs [\#900](https://github.com/operator-framework/operator-lifecycle-manager/pull/900) ([ecordell](https://github.com/ecordell))
- Add support for user defined ServiceAccount for OperatorGroup. [\#892](https://github.com/operator-framework/operator-lifecycle-manager/pull/892) ([tkashem](https://github.com/tkashem))
- Change Package Server Global Namespace [\#890](https://github.com/operator-framework/operator-lifecycle-manager/pull/890) ([alecmerdler](https://github.com/alecmerdler))
- make release 0.10.1 [\#889](https://github.com/operator-framework/operator-lifecycle-manager/pull/889) ([dinhxuanvu](https://github.com/dinhxuanvu))
- repair run\_console\_run.sh script [\#885](https://github.com/operator-framework/operator-lifecycle-manager/pull/885) ([madorn](https://github.com/madorn))
- Subscription CatalogSource Status [\#881](https://github.com/operator-framework/operator-lifecycle-manager/pull/881) ([njhale](https://github.com/njhale))
- \(proposal\) Add user defined service account [\#880](https://github.com/operator-framework/operator-lifecycle-manager/pull/880) ([tkashem](https://github.com/tkashem))
- Enable OLM to update CRD when there is only one owner of that CRD [\#878](https://github.com/operator-framework/operator-lifecycle-manager/pull/878) ([dinhxuanvu](https://github.com/dinhxuanvu))
- Package API server monitoring [\#863](https://github.com/operator-framework/operator-lifecycle-manager/pull/863) ([tkashem](https://github.com/tkashem))

## [0.10.1](https://github.com/operator-framework/operator-lifecycle-manager/tree/0.10.1) (2019-06-05)
[Full Changelog](https://github.com/operator-framework/operator-lifecycle-manager/compare/0.10.0...0.10.1)

**Closed issues:**

- Unable to install the olm [\#882](https://github.com/operator-framework/operator-lifecycle-manager/issues/882)
- Doc for defining x-descriptors [\#808](https://github.com/operator-framework/operator-lifecycle-manager/issues/808)
- Api server backed resources missing permissions [\#804](https://github.com/operator-framework/operator-lifecycle-manager/issues/804)
- Seeing a consistent pattern of warnings installing OLM on OS3 cluster [\#803](https://github.com/operator-framework/operator-lifecycle-manager/issues/803)
- Localhost:9000 can't be accessed [\#800](https://github.com/operator-framework/operator-lifecycle-manager/issues/800)
- Unable to see operators after install/deploy the OML by following the installation guide [\#784](https://github.com/operator-framework/operator-lifecycle-manager/issues/784)
- Pull configmap-operator-registry from quay org "operator-framework" not "operatorframework" in 0.8.1 and master [\#779](https://github.com/operator-framework/operator-lifecycle-manager/issues/779)
- "no matches for kind" error during OLM installation [\#746](https://github.com/operator-framework/operator-lifecycle-manager/issues/746)
- need ability to specify roleRef in permissions  [\#732](https://github.com/operator-framework/operator-lifecycle-manager/issues/732)
- none of the deployment works with okd 3.11 [\#715](https://github.com/operator-framework/operator-lifecycle-manager/issues/715)
- Subscription stuck at Upgrading [\#700](https://github.com/operator-framework/operator-lifecycle-manager/issues/700)
- Getting started guide does not work [\#677](https://github.com/operator-framework/operator-lifecycle-manager/issues/677)
- Installation sometimes fails [\#558](https://github.com/operator-framework/operator-lifecycle-manager/issues/558)
- Unhelpful "RequirementsNotMet" message when attempting to deploy Template Service Broker Operator CSV [\#543](https://github.com/operator-framework/operator-lifecycle-manager/issues/543)

**Other changes:**

- Bump release version to 0.10.1 [\#887](https://github.com/operator-framework/operator-lifecycle-manager/pull/887) ([dinhxuanvu](https://github.com/dinhxuanvu))
- Add Internal types for operators.coreos.com API group [\#877](https://github.com/operator-framework/operator-lifecycle-manager/pull/877) ([njhale](https://github.com/njhale))
- Documentation: Fix a few typos [\#876](https://github.com/operator-framework/operator-lifecycle-manager/pull/876) ([marcoderama](https://github.com/marcoderama))
- feat\(install\): Add new install scripts for releases, update release [\#875](https://github.com/operator-framework/operator-lifecycle-manager/pull/875) ([ecordell](https://github.com/ecordell))
- Change Global Catalog Namespace for OpenShift [\#871](https://github.com/operator-framework/operator-lifecycle-manager/pull/871) ([alecmerdler](https://github.com/alecmerdler))
- fix\(operatorgroup\): Remove namespaces requirement for opgroup status [\#869](https://github.com/operator-framework/operator-lifecycle-manager/pull/869) ([dinhxuanvu](https://github.com/dinhxuanvu))
- docs\(release\): add basic steps for making release [\#867](https://github.com/operator-framework/operator-lifecycle-manager/pull/867) ([jpeeler](https://github.com/jpeeler))
- update manifests to 0.10.0 [\#866](https://github.com/operator-framework/operator-lifecycle-manager/pull/866) ([jpeeler](https://github.com/jpeeler))
- chore\(deps\): bump kube deps to 1.14 [\#864](https://github.com/operator-framework/operator-lifecycle-manager/pull/864) ([ecordell](https://github.com/ecordell))
- fix\(catalog\): close grpc connections before deleting them [\#861](https://github.com/operator-framework/operator-lifecycle-manager/pull/861) ([ecordell](https://github.com/ecordell))

## [0.10.0](https://github.com/operator-framework/operator-lifecycle-manager/tree/0.10.0) (2019-05-22)
[Full Changelog](https://github.com/operator-framework/operator-lifecycle-manager/compare/0.9.0...0.10.0)

**Closed issues:**

- Operator lifecycle manager and operator-sdk connection [\#862](https://github.com/operator-framework/operator-lifecycle-manager/issues/862)
- I am getting error while installing OLM [\#854](https://github.com/operator-framework/operator-lifecycle-manager/issues/854)
- Generated Subscriptions should have an owner reference to created Subscription [\#832](https://github.com/operator-framework/operator-lifecycle-manager/issues/832)
- replaces meta data for operator will throw fatal error when no previous version of operator is found. [\#831](https://github.com/operator-framework/operator-lifecycle-manager/issues/831)
- Operator catalog is created but now shown in the OLM UI [\#822](https://github.com/operator-framework/operator-lifecycle-manager/issues/822)
- After it be installed the URL to connect/use it should be informed to the user [\#785](https://github.com/operator-framework/operator-lifecycle-manager/issues/785)
- Add 'operatorgroups' to edit and view clusterroles [\#743](https://github.com/operator-framework/operator-lifecycle-manager/issues/743)
- upstream deployment: olm pod keeps crashing  [\#714](https://github.com/operator-framework/operator-lifecycle-manager/issues/714)

Other changes:

- bump version to 0.10.0 [\#865](https://github.com/operator-framework/operator-lifecycle-manager/pull/865) ([jpeeler](https://github.com/jpeeler))
- \(refactor\) Move csv set and replace to a package [\#860](https://github.com/operator-framework/operator-lifecycle-manager/pull/860) ([tkashem](https://github.com/tkashem))
- fix\(unit\): Remove leftover println causing excessive log in unit test [\#859](https://github.com/operator-framework/operator-lifecycle-manager/pull/859) ([dinhxuanvu](https://github.com/dinhxuanvu))
- fix\(run\_console\_loca\): Fix command and improve output message [\#858](https://github.com/operator-framework/operator-lifecycle-manager/pull/858) ([camilamacedo86](https://github.com/camilamacedo86))
- test\(olm\): test role aggregation for aggregate apiservices [\#856](https://github.com/operator-framework/operator-lifecycle-manager/pull/856) ([ecordell](https://github.com/ecordell))
- fix\(unit\): TestUpdate no longer flakes [\#855](https://github.com/operator-framework/operator-lifecycle-manager/pull/855) ([ecordell](https://github.com/ecordell))
- chore\(deploy\): fix release scripts [\#852](https://github.com/operator-framework/operator-lifecycle-manager/pull/852) ([ecordell](https://github.com/ecordell))
- fix\(operatorgroup\): No targetNamespaces matched namespace selector [\#851](https://github.com/operator-framework/operator-lifecycle-manager/pull/851) ([dinhxuanvu](https://github.com/dinhxuanvu))
-  Bug 1705649: fix olm-operators tolerations [\#850](https://github.com/operator-framework/operator-lifecycle-manager/pull/850) ([ravisantoshgudimetla](https://github.com/ravisantoshgudimetla))
- fix\(deploy\): add missing descriptions to manifests [\#848](https://github.com/operator-framework/operator-lifecycle-manager/pull/848) ([jpeeler](https://github.com/jpeeler))
- fix\(catalog\): fix issue where subscriptions sometimes get "stuck" [\#847](https://github.com/operator-framework/operator-lifecycle-manager/pull/847) ([ecordell](https://github.com/ecordell))
- fix\(deploy\): add missing descriptions [\#845](https://github.com/operator-framework/operator-lifecycle-manager/pull/845) ([jpeeler](https://github.com/jpeeler))
- Add Termination Message to Failing OLM Pods [\#844](https://github.com/operator-framework/operator-lifecycle-manager/pull/844) ([alecmerdler](https://github.com/alecmerdler))
- Fix tolerations [\#843](https://github.com/operator-framework/operator-lifecycle-manager/pull/843) ([ravisantoshgudimetla](https://github.com/ravisantoshgudimetla))
- fix\(catalog\): Fix subscriptions without a sourceNamespace hang forever [\#839](https://github.com/operator-framework/operator-lifecycle-manager/pull/839) ([dinhxuanvu](https://github.com/dinhxuanvu))
- fix\(resolver\): fixes a bug where resolved dependent subscriptions don't [\#838](https://github.com/operator-framework/operator-lifecycle-manager/pull/838) ([ecordell](https://github.com/ecordell))
- Refactor to avoid cache races [\#837](https://github.com/operator-framework/operator-lifecycle-manager/pull/837) ([jpeeler](https://github.com/jpeeler))
- Set limit on length of Status.Conditions of a csv [\#836](https://github.com/operator-framework/operator-lifecycle-manager/pull/836) ([tkashem](https://github.com/tkashem))
- Fix gRPC registry pod recreation [\#835](https://github.com/operator-framework/operator-lifecycle-manager/pull/835) ([njhale](https://github.com/njhale))
- Support semver ranges of versions to skip in the head of a channel [\#834](https://github.com/operator-framework/operator-lifecycle-manager/pull/834) ([ecordell](https://github.com/ecordell))
- test\(e2e\): wait for deployment to exist in csv replacement test [\#833](https://github.com/operator-framework/operator-lifecycle-manager/pull/833) ([ecordell](https://github.com/ecordell))
- Always set LastTransitionTime in OperatorStatusCondition [\#830](https://github.com/operator-framework/operator-lifecycle-manager/pull/830) ([soltysh](https://github.com/soltysh))
- Revert "chore\(cvo\): remove ClusterOperator from manifests" [\#828](https://github.com/operator-framework/operator-lifecycle-manager/pull/828) ([ecordell](https://github.com/ecordell))
- fix\(olm\): Fix the issue with missing events due to rate limit [\#827](https://github.com/operator-framework/operator-lifecycle-manager/pull/827) ([dinhxuanvu](https://github.com/dinhxuanvu))
- chore\(cvo\): remove ClusterOperator from manifests [\#826](https://github.com/operator-framework/operator-lifecycle-manager/pull/826) ([ecordell](https://github.com/ecordell))
- Add node-selector annotation to namespace [\#824](https://github.com/operator-framework/operator-lifecycle-manager/pull/824) ([ravisantoshgudimetla](https://github.com/ravisantoshgudimetla))
- chore\(cvo\): update openshift/api so that OperatorFailing is changed to OperatorDegraded [\#823](https://github.com/operator-framework/operator-lifecycle-manager/pull/823) ([ecordell](https://github.com/ecordell))
- Add validation details for `spec.maturity` field [\#821](https://github.com/operator-framework/operator-lifecycle-manager/pull/821) ([tlwu2013](https://github.com/tlwu2013))
- Subscription Status InstallPlan References [\#820](https://github.com/operator-framework/operator-lifecycle-manager/pull/820) ([njhale](https://github.com/njhale))
- Add priorityClassName [\#817](https://github.com/operator-framework/operator-lifecycle-manager/pull/817) ([jianzhangbjz](https://github.com/jianzhangbjz))
- Update catalog if image changes [\#816](https://github.com/operator-framework/operator-lifecycle-manager/pull/816) ([ecordell](https://github.com/ecordell))
- feat\(packageserver\): add additional info to package server output [\#813](https://github.com/operator-framework/operator-lifecycle-manager/pull/813) ([ecordell](https://github.com/ecordell))
- feat\(rbac\): restrict permissions for namespace admins [\#812](https://github.com/operator-framework/operator-lifecycle-manager/pull/812) ([ecordell](https://github.com/ecordell))
- chore\(cvo\): report progressing=true if the version has updated [\#811](https://github.com/operator-framework/operator-lifecycle-manager/pull/811) ([ecordell](https://github.com/ecordell))
- add logging and separate muxer for metrics [\#809](https://github.com/operator-framework/operator-lifecycle-manager/pull/809) ([jpeeler](https://github.com/jpeeler))
- fix\(catalog\): recreate registry pods when deleted [\#807](https://github.com/operator-framework/operator-lifecycle-manager/pull/807) ([njhale](https://github.com/njhale))
- documentation:  Fix a few typos. [\#806](https://github.com/operator-framework/operator-lifecycle-manager/pull/806) ([marcoderama](https://github.com/marcoderama))
- Garbage Collection for OperatorGroup RBAC [\#795](https://github.com/operator-framework/operator-lifecycle-manager/pull/795) ([alecmerdler](https://github.com/alecmerdler))
- fix\(olm\): generate aggregated clusterroles for ownnamespace operatorgroups correctly [\#794](https://github.com/operator-framework/operator-lifecycle-manager/pull/794) ([ecordell](https://github.com/ecordell))
- Fixing indentation for spec field [\#787](https://github.com/operator-framework/operator-lifecycle-manager/pull/787) ([bergerhoffer](https://github.com/bergerhoffer))
- Add support for Windows WSL in run\_console\_local.sh [\#768](https://github.com/operator-framework/operator-lifecycle-manager/pull/768) ([leszko](https://github.com/leszko))
- fix the labels.provider of packagemanifest issue [\#766](https://github.com/operator-framework/operator-lifecycle-manager/pull/766) ([jianzhangbjz](https://github.com/jianzhangbjz))
- fix\(deployment\): Clean up orphaned deployments [\#759](https://github.com/operator-framework/operator-lifecycle-manager/pull/759) ([dinhxuanvu](https://github.com/dinhxuanvu))
- Add Provided APIs to PackageManifest [\#754](https://github.com/operator-framework/operator-lifecycle-manager/pull/754) ([alecmerdler](https://github.com/alecmerdler))
- Fix small typo. [\#751](https://github.com/operator-framework/operator-lifecycle-manager/pull/751) ([lveyde](https://github.com/lveyde))
- fix\(olm\): add deletion monitoring for api services [\#750](https://github.com/operator-framework/operator-lifecycle-manager/pull/750) ([jpeeler](https://github.com/jpeeler))

## [0.9.0](https://github.com/operator-framework/operator-lifecycle-manager/tree/0.9.0) (2019-04-11)
[Full Changelog](https://github.com/operator-framework/operator-lifecycle-manager/compare/0.8.1...0.9.0)

**Implemented enhancements:**

- feat\(packageserver\): support apps.redhat.com and operators.coreos.com [\#788](https://github.com/operator-framework/operator-lifecycle-manager/pull/788) ([njhale](https://github.com/njhale))
- fix\(metrics\): add service monitor config [\#682](https://github.com/operator-framework/operator-lifecycle-manager/pull/682) ([jpeeler](https://github.com/jpeeler))

**Fixed bugs:**

- fix\(annotation\): don't annotate deployments that aren't owned by a CSV [\#792](https://github.com/operator-framework/operator-lifecycle-manager/pull/792) ([ecordell](https://github.com/ecordell))
- fix\(packageserver\): add struct tags to PackageManifestList [\#791](https://github.com/operator-framework/operator-lifecycle-manager/pull/791) ([njhale](https://github.com/njhale))
- fix\(olm\): use hashes for provided api labels [\#778](https://github.com/operator-framework/operator-lifecycle-manager/pull/778) ([ecordell](https://github.com/ecordell))

**Closed issues:**

- git add issue [\#797](https://github.com/operator-framework/operator-lifecycle-manager/issues/797)
- Unable to install the latest version on minishift [\#780](https://github.com/operator-framework/operator-lifecycle-manager/issues/780)
- scripts/install\_local.sh: upstream-operators.catalogsource.yaml not written correctly [\#772](https://github.com/operator-framework/operator-lifecycle-manager/issues/772)
- flag provided but not defined: -writeStatusName [\#770](https://github.com/operator-framework/operator-lifecycle-manager/issues/770)
- ClusterServiceVersion Status: Failed [\#769](https://github.com/operator-framework/operator-lifecycle-manager/issues/769)
- Upstream quickstart and latest manifests should deploy same OLM image [\#747](https://github.com/operator-framework/operator-lifecycle-manager/issues/747)

**Other changes:**

- Fix modules [\#805](https://github.com/operator-framework/operator-lifecycle-manager/pull/805) ([njhale](https://github.com/njhale))
- Cut Release 0.9.0 [\#802](https://github.com/operator-framework/operator-lifecycle-manager/pull/802) ([alecmerdler](https://github.com/alecmerdler))
- Bump OLM Release Version to 0.9.0 [\#801](https://github.com/operator-framework/operator-lifecycle-manager/pull/801) ([alecmerdler](https://github.com/alecmerdler))
- Update Kubernetes dependencies to 1.12.7 [\#793](https://github.com/operator-framework/operator-lifecycle-manager/pull/793) ([jpeeler](https://github.com/jpeeler))
- chore\(build\): build binaries locally and load them into containers [\#777](https://github.com/operator-framework/operator-lifecycle-manager/pull/777) ([ecordell](https://github.com/ecordell))
- chore\(catalog\): add ClusterOperator status for catalog operator [\#776](https://github.com/operator-framework/operator-lifecycle-manager/pull/776) ([ecordell](https://github.com/ecordell))
- chore\(deploy\): set priorityclass on olm pods [\#775](https://github.com/operator-framework/operator-lifecycle-manager/pull/775) ([ecordell](https://github.com/ecordell))
- chore\(api\): bump operatorgroup and packagemanifest to v1  [\#774](https://github.com/operator-framework/operator-lifecycle-manager/pull/774) ([ecordell](https://github.com/ecordell))
- chore\(manifests\): recut 0.8.1 [\#771](https://github.com/operator-framework/operator-lifecycle-manager/pull/771) ([njhale](https://github.com/njhale))
- docs\(subscriptions\): add improved sub status proposal [\#741](https://github.com/operator-framework/operator-lifecycle-manager/pull/741) ([njhale](https://github.com/njhale))

## [0.8.1](https://github.com/operator-framework/operator-lifecycle-manager/tree/0.8.1) (2019-03-20)
[Full Changelog](https://github.com/operator-framework/operator-lifecycle-manager/compare/0.7.1...0.8.1)

**Implemented enhancements:**

- Grant namespace list to global operators [\#764](https://github.com/operator-framework/operator-lifecycle-manager/pull/764) ([ecordell](https://github.com/ecordell))
- feat\(csv\): requeue csvs on change to CRDs [\#763](https://github.com/operator-framework/operator-lifecycle-manager/pull/763) ([njhale](https://github.com/njhale))
- Add upstream catalog [\#762](https://github.com/operator-framework/operator-lifecycle-manager/pull/762) ([ecordell](https://github.com/ecordell))
- refactor\(images\): use operator-framework namespace for all olm images [\#752](https://github.com/operator-framework/operator-lifecycle-manager/pull/752) ([njhale](https://github.com/njhale))
- clusteroperator: Report when OLM reaches "level" and check syncs [\#748](https://github.com/operator-framework/operator-lifecycle-manager/pull/748) ([smarterclayton](https://github.com/smarterclayton))
- feat\(test\): adds CSV phase reporting for package server [\#745](https://github.com/operator-framework/operator-lifecycle-manager/pull/745) ([jpeeler](https://github.com/jpeeler))
- Add minKubeVersion validation to templates [\#739](https://github.com/operator-framework/operator-lifecycle-manager/pull/739) ([dinhxuanvu](https://github.com/dinhxuanvu))
- OperatorGroup expansion/contraction [\#736](https://github.com/operator-framework/operator-lifecycle-manager/pull/736) ([ecordell](https://github.com/ecordell))
- docs\(operatorgroups\): add more extensive docs [\#721](https://github.com/operator-framework/operator-lifecycle-manager/pull/721) ([njhale](https://github.com/njhale))
- add all-in-one yaml and helper script [\#720](https://github.com/operator-framework/operator-lifecycle-manager/pull/720) ([dmesser](https://github.com/dmesser))
- feat\(csv\): allow use verb in permissions [\#717](https://github.com/operator-framework/operator-lifecycle-manager/pull/717) ([ecordell](https://github.com/ecordell))
- Add Graceful Shutdown to PackageManifest Server [\#711](https://github.com/operator-framework/operator-lifecycle-manager/pull/711) ([alecmerdler](https://github.com/alecmerdler))
- feat\(catalogsource\): allow grpc source types that don't require an image [\#709](https://github.com/operator-framework/operator-lifecycle-manager/pull/709) ([njhale](https://github.com/njhale))
- remove minishift support [\#704](https://github.com/operator-framework/operator-lifecycle-manager/pull/704) ([leseb](https://github.com/leseb))
- fix\(packagemanifest\): Add InstallModes info from CSV to PackageManifest [\#697](https://github.com/operator-framework/operator-lifecycle-manager/pull/697) ([dinhxuanvu](https://github.com/dinhxuanvu))
- fix\(installplans\): add ability to apply Services [\#674](https://github.com/operator-framework/operator-lifecycle-manager/pull/674) ([njhale](https://github.com/njhale))
- test\(validation\): add test to verify OLM can use bundles with CRDs with min/max fields [\#672](https://github.com/operator-framework/operator-lifecycle-manager/pull/672) ([njhale](https://github.com/njhale))
- test\(catalog\): add e2e test to verify configmap changes are detected [\#670](https://github.com/operator-framework/operator-lifecycle-manager/pull/670) ([ecordell](https://github.com/ecordell))
- fix\(operatorgroups\): write out CSV status on OperatorGroup issues [\#669](https://github.com/operator-framework/operator-lifecycle-manager/pull/669) ([njhale](https://github.com/njhale))
- Add minimum kube version to CSV & check it against server version [\#663](https://github.com/operator-framework/operator-lifecycle-manager/pull/663) ([dinhxuanvu](https://github.com/dinhxuanvu))
- Watch all namespaces in local setup by removing watchedNamespaces in local-values [\#657](https://github.com/operator-framework/operator-lifecycle-manager/pull/657) ([chancez](https://github.com/chancez))
- Write cluster operator status after successful startup \(attempt \#2\) [\#652](https://github.com/operator-framework/operator-lifecycle-manager/pull/652) ([jpeeler](https://github.com/jpeeler))
- Consume Operator Registry from PackageManifest Server [\#650](https://github.com/operator-framework/operator-lifecycle-manager/pull/650) ([njhale](https://github.com/njhale))
- update codegen for 2019 [\#646](https://github.com/operator-framework/operator-lifecycle-manager/pull/646) ([jcantrill](https://github.com/jcantrill))
- test\(catalog\): add an e2e test verifying that the rh-operators catalog starts [\#643](https://github.com/operator-framework/operator-lifecycle-manager/pull/643) ([ecordell](https://github.com/ecordell))
- feat\(csv\): add installmodes to CSV spec [\#640](https://github.com/operator-framework/operator-lifecycle-manager/pull/640) ([njhale](https://github.com/njhale))
- feat\(resolver\): take all subscriptions into account when resolving [\#638](https://github.com/operator-framework/operator-lifecycle-manager/pull/638) ([ecordell](https://github.com/ecordell))
- Requeue subscriptions on catalogsource change [\#633](https://github.com/operator-framework/operator-lifecycle-manager/pull/633) ([ecordell](https://github.com/ecordell))
- Add view permissions for CRDs on provided APIs [\#618](https://github.com/operator-framework/operator-lifecycle-manager/pull/618) ([ecordell](https://github.com/ecordell))
- Require pluralname for APIServiceDefinitions in CSVs [\#617](https://github.com/operator-framework/operator-lifecycle-manager/pull/617) ([ecordell](https://github.com/ecordell))
- Verify CRD's condition to ensure it's registered with k8s API \(rebased\) [\#614](https://github.com/operator-framework/operator-lifecycle-manager/pull/614) ([jpeeler](https://github.com/jpeeler))
- chore\(release\): switch image-reference tag to operator-lifecycle-manager [\#612](https://github.com/operator-framework/operator-lifecycle-manager/pull/612) ([ecordell](https://github.com/ecordell))
- feat\(package-server\): create subscription manifest [\#609](https://github.com/operator-framework/operator-lifecycle-manager/pull/609) ([njhale](https://github.com/njhale))
- use quay.io vs registry.reg-aws.openshift.com [\#608](https://github.com/operator-framework/operator-lifecycle-manager/pull/608) ([jboyd01](https://github.com/jboyd01))
- feat\(ci\): remove e2e tests from gitlab [\#602](https://github.com/operator-framework/operator-lifecycle-manager/pull/602) ([ecordell](https://github.com/ecordell))
- feat\(package-server\): self-host package-server with CSV [\#594](https://github.com/operator-framework/operator-lifecycle-manager/pull/594) ([njhale](https://github.com/njhale))
- test\(csv\): use mock-ext-server for owned apiservice e2e test [\#593](https://github.com/operator-framework/operator-lifecycle-manager/pull/593) ([njhale](https://github.com/njhale))
- Add operator namespace [\#591](https://github.com/operator-framework/operator-lifecycle-manager/pull/591) ([jpeeler](https://github.com/jpeeler))
- Don't process CSVs without operatorgroup [\#589](https://github.com/operator-framework/operator-lifecycle-manager/pull/589) ([ecordell](https://github.com/ecordell))
- Adding description to package manifest object [\#587](https://github.com/operator-framework/operator-lifecycle-manager/pull/587) ([galletti94](https://github.com/galletti94))
- Propagate Labels from `CatalogSource` to `PackageManifests` [\#576](https://github.com/operator-framework/operator-lifecycle-manager/pull/576) ([alecmerdler](https://github.com/alecmerdler))
- Make use a valid clusterPermissions rule verb [\#575](https://github.com/operator-framework/operator-lifecycle-manager/pull/575) ([wongma7](https://github.com/wongma7))
- Create role bindings for operator service accounts  [\#571](https://github.com/operator-framework/operator-lifecycle-manager/pull/571) ([ecordell](https://github.com/ecordell))
- feat\(olm\): use cache listers in olm-operator [\#569](https://github.com/operator-framework/operator-lifecycle-manager/pull/569) ([njhale](https://github.com/njhale))
- Operator group follow ups [\#568](https://github.com/operator-framework/operator-lifecycle-manager/pull/568) ([jpeeler](https://github.com/jpeeler))
- feat\(mocks\): generate fakes and mocks in a container [\#564](https://github.com/operator-framework/operator-lifecycle-manager/pull/564) ([njhale](https://github.com/njhale))
- Remove ns annotator [\#563](https://github.com/operator-framework/operator-lifecycle-manager/pull/563) ([ecordell](https://github.com/ecordell))
- Create registry pods for ConfigMap CatalogSources [\#556](https://github.com/operator-framework/operator-lifecycle-manager/pull/556) ([ecordell](https://github.com/ecordell))
- Switch to go modules [\#554](https://github.com/operator-framework/operator-lifecycle-manager/pull/554) ([ecordell](https://github.com/ecordell))
- feat\(make\): add e2e command for running from ci-operator [\#552](https://github.com/operator-framework/operator-lifecycle-manager/pull/552) ([ecordell](https://github.com/ecordell))
- Add test case for supporting multi-version CRD [\#548](https://github.com/operator-framework/operator-lifecycle-manager/pull/548) ([dinhxuanvu](https://github.com/dinhxuanvu))
- Verify Native APIs Present for ClusterServiceVersion [\#541](https://github.com/operator-framework/operator-lifecycle-manager/pull/541) ([alecmerdler](https://github.com/alecmerdler))
- feat\(csv\): detect req and dep change in succeeded/failed phases [\#536](https://github.com/operator-framework/operator-lifecycle-manager/pull/536) ([njhale](https://github.com/njhale))
- Add `assign` verb to csv crd [\#531](https://github.com/operator-framework/operator-lifecycle-manager/pull/531) ([eriknelson](https://github.com/eriknelson))
- Emit Kubernetes Events for ClusterServiceVersion [\#530](https://github.com/operator-framework/operator-lifecycle-manager/pull/530) ([alecmerdler](https://github.com/alecmerdler))
- feat\(csv\): add cert rotation for owned APIServices [\#525](https://github.com/operator-framework/operator-lifecycle-manager/pull/525) ([njhale](https://github.com/njhale))
- Pass Annotations to PackageManifests [\#521](https://github.com/operator-framework/operator-lifecycle-manager/pull/521) ([alecmerdler](https://github.com/alecmerdler))
- feat\(deploy\): add debug variable to all deployments [\#518](https://github.com/operator-framework/operator-lifecycle-manager/pull/518) ([jpeeler](https://github.com/jpeeler))
- feat\(build\): allow skipping minikube during local builds [\#516](https://github.com/operator-framework/operator-lifecycle-manager/pull/516) ([jpeeler](https://github.com/jpeeler))
- Add possible nonResourceURL verbs to validation [\#511](https://github.com/operator-framework/operator-lifecycle-manager/pull/511) ([eriknelson](https://github.com/eriknelson))
- Add CatalogSource-Specific Fields to PackageManifest [\#505](https://github.com/operator-framework/operator-lifecycle-manager/pull/505) ([alecmerdler](https://github.com/alecmerdler))
- Add Runlevels + docker labels [\#502](https://github.com/operator-framework/operator-lifecycle-manager/pull/502) ([ecordell](https://github.com/ecordell))
- Make use a valid clusterPermissions rule verb [\#499](https://github.com/operator-framework/operator-lifecycle-manager/pull/499) ([wongma7](https://github.com/wongma7))
- Always Return Global `PackageManifests` [\#494](https://github.com/operator-framework/operator-lifecycle-manager/pull/494) ([alecmerdler](https://github.com/alecmerdler))
- refine cluster-admin OLM workflow [\#482](https://github.com/operator-framework/operator-lifecycle-manager/pull/482) ([madorn](https://github.com/madorn))
- add OperatorGroup [\#480](https://github.com/operator-framework/operator-lifecycle-manager/pull/480) ([jpeeler](https://github.com/jpeeler))
- feat\(olm\): add RBAC requirements check for CSVs [\#479](https://github.com/operator-framework/operator-lifecycle-manager/pull/479) ([njhale](https://github.com/njhale))
- Allow resolving ClusterRoles [\#477](https://github.com/operator-framework/operator-lifecycle-manager/pull/477) ([ecordell](https://github.com/ecordell))
- Implement Watch for `PackageManifest` API [\#476](https://github.com/operator-framework/operator-lifecycle-manager/pull/476) ([alecmerdler](https://github.com/alecmerdler))

**Fixed bugs:**

- OLM Unable to Upgrade Through Multiple Versions [\#755](https://github.com/operator-framework/operator-lifecycle-manager/issues/755)
- Subscription steps through multiple upgrades [\#761](https://github.com/operator-framework/operator-lifecycle-manager/pull/761) ([ecordell](https://github.com/ecordell))
- Fix typo - k8s version format [\#760](https://github.com/operator-framework/operator-lifecycle-manager/pull/760) ([tlwu2013](https://github.com/tlwu2013))
- fix\(csv\): properly detect apiservice and crd conflicts [\#758](https://github.com/operator-framework/operator-lifecycle-manager/pull/758) ([njhale](https://github.com/njhale))
- Emit `InstallSucceeded` Event for CSV [\#749](https://github.com/operator-framework/operator-lifecycle-manager/pull/749) ([alecmerdler](https://github.com/alecmerdler))
- fix\(packageserver\): set packageserver to IfNotPresent [\#738](https://github.com/operator-framework/operator-lifecycle-manager/pull/738) ([ecordell](https://github.com/ecordell))
- fix\(installmodes\): update support logic to match expected behavior [\#733](https://github.com/operator-framework/operator-lifecycle-manager/pull/733) ([njhale](https://github.com/njhale))
- fix\(packagesever\): add missing name field to api definition [\#731](https://github.com/operator-framework/operator-lifecycle-manager/pull/731) ([ecordell](https://github.com/ecordell))
- fix\(owners\): remove cross-namespace and cluster-\>namespace ownerrefs [\#729](https://github.com/operator-framework/operator-lifecycle-manager/pull/729) ([ecordell](https://github.com/ecordell))
- fix\(csv\): remove regex on base64 image data [\#723](https://github.com/operator-framework/operator-lifecycle-manager/pull/723) ([ecordell](https://github.com/ecordell))
- fix\(ocp\): add csv and deployment for package server [\#722](https://github.com/operator-framework/operator-lifecycle-manager/pull/722) ([jpeeler](https://github.com/jpeeler))
- Fix API Validation for `OperatorGroup` Spec [\#716](https://github.com/operator-framework/operator-lifecycle-manager/pull/716) ([alecmerdler](https://github.com/alecmerdler))
- fix\(manifests\): start manifest file names with 0000\_50\_olm\_\* [\#712](https://github.com/operator-framework/operator-lifecycle-manager/pull/712) ([njhale](https://github.com/njhale))
- fix\(olm\): properly detect cluster operator API [\#710](https://github.com/operator-framework/operator-lifecycle-manager/pull/710) ([jpeeler](https://github.com/jpeeler))
- fix\(registry-pods\): add everything toleration to registry pods [\#708](https://github.com/operator-framework/operator-lifecycle-manager/pull/708) ([njhale](https://github.com/njhale))
- Make e2e more robust [\#703](https://github.com/operator-framework/operator-lifecycle-manager/pull/703) ([jpeeler](https://github.com/jpeeler))
- fix\(deploy\): Add a component prefix to manifests [\#702](https://github.com/operator-framework/operator-lifecycle-manager/pull/702) ([smarterclayton](https://github.com/smarterclayton))
- fix\(csv\): only allow one CSV per provided API across intersecting operatorgroups [\#701](https://github.com/operator-framework/operator-lifecycle-manager/pull/701) ([njhale](https://github.com/njhale))
- fix\(olm\): Remove the "v" prefix in minKubeVersion if presents [\#699](https://github.com/operator-framework/operator-lifecycle-manager/pull/699) ([dinhxuanvu](https://github.com/dinhxuanvu))
- Fix README.md links for CRDs, Descriptor, and Package [\#695](https://github.com/operator-framework/operator-lifecycle-manager/pull/695) ([ron1](https://github.com/ron1))
- fix\(olm\): Fix CSVs api-servers battle for ownership of APIServices [\#690](https://github.com/operator-framework/operator-lifecycle-manager/pull/690) ([dinhxuanvu](https://github.com/dinhxuanvu))
- fix\(subscriptions\): fix race between subscription sync and cache [\#689](https://github.com/operator-framework/operator-lifecycle-manager/pull/689) ([njhale](https://github.com/njhale))
- fix\(reconciler\): set command in pod spec of registry images [\#688](https://github.com/operator-framework/operator-lifecycle-manager/pull/688) ([ecordell](https://github.com/ecordell))
- fix\(permissions\): Generate unique Names for permissions [\#687](https://github.com/operator-framework/operator-lifecycle-manager/pull/687) ([ecordell](https://github.com/ecordell))
- Correct URL for Package Server CSV Link [\#685](https://github.com/operator-framework/operator-lifecycle-manager/pull/685) ([alecmerdler](https://github.com/alecmerdler))
- Ensure Owner References on ConfigMaps for CatalogSources  [\#681](https://github.com/operator-framework/operator-lifecycle-manager/pull/681) ([alecmerdler](https://github.com/alecmerdler))
- fix\(cm-reconciler\): query for pods to overwrite by CatalogSource label [\#680](https://github.com/operator-framework/operator-lifecycle-manager/pull/680) ([njhale](https://github.com/njhale))
- fix\(installplan\): fix bug where too many installplans can be created [\#679](https://github.com/operator-framework/operator-lifecycle-manager/pull/679) ([ecordell](https://github.com/ecordell))
- fix\(subscriptions\): respect startingCSV [\#676](https://github.com/operator-framework/operator-lifecycle-manager/pull/676) ([njhale](https://github.com/njhale))
- Add view role verbs to admin/edit role aggregation.  [\#673](https://github.com/operator-framework/operator-lifecycle-manager/pull/673) ([cliles](https://github.com/cliles))
- add view rbac to 'admin' and 'edit' default roles [\#671](https://github.com/operator-framework/operator-lifecycle-manager/pull/671) ([aweiteka](https://github.com/aweiteka))
- fix\(packageserver\): don't error out when listing [\#667](https://github.com/operator-framework/operator-lifecycle-manager/pull/667) ([njhale](https://github.com/njhale))
- fix\(operatorgroups\): use copied csv for update status [\#665](https://github.com/operator-framework/operator-lifecycle-manager/pull/665) ([njhale](https://github.com/njhale))
- fix\(deploy\): add linux nodeselector [\#653](https://github.com/operator-framework/operator-lifecycle-manager/pull/653) ([ecordell](https://github.com/ecordell))
- fix\(metrics\): remove resources that aren't updated [\#637](https://github.com/operator-framework/operator-lifecycle-manager/pull/637) ([jpeeler](https://github.com/jpeeler))
- fix\(crds\): remove category all from CRDs [\#636](https://github.com/operator-framework/operator-lifecycle-manager/pull/636) ([ecordell](https://github.com/ecordell))
- fix\(charts\): add operator\_namespace to run-local values [\#634](https://github.com/operator-framework/operator-lifecycle-manager/pull/634) ([njhale](https://github.com/njhale))
- fix\(deploy\): add runlevel to openshift-operators [\#620](https://github.com/operator-framework/operator-lifecycle-manager/pull/620) ([ecordell](https://github.com/ecordell))
- fix\(olm\): don't annotate target namespace on copied CSVs [\#616](https://github.com/operator-framework/operator-lifecycle-manager/pull/616) ([jpeeler](https://github.com/jpeeler))
- fix\(e2e\): make operator group test more robust [\#603](https://github.com/operator-framework/operator-lifecycle-manager/pull/603) ([jpeeler](https://github.com/jpeeler))
- fix\(e2e\): fix CSV tests [\#599](https://github.com/operator-framework/operator-lifecycle-manager/pull/599) ([njhale](https://github.com/njhale))
- Fix a typo in documentation [\#596](https://github.com/operator-framework/operator-lifecycle-manager/pull/596) ([smanpathak](https://github.com/smanpathak))
- Fix `client-go` Dependency [\#592](https://github.com/operator-framework/operator-lifecycle-manager/pull/592) ([alecmerdler](https://github.com/alecmerdler))
- Fix Panic in PackageManifest Server [\#590](https://github.com/operator-framework/operator-lifecycle-manager/pull/590) ([alecmerdler](https://github.com/alecmerdler))
- fix\(annotations\): merge CSV and pod template annotations when installing deployments [\#585](https://github.com/operator-framework/operator-lifecycle-manager/pull/585) ([njhale](https://github.com/njhale))
- Add `packagemanifest:aggregated-apiserver-clusterrole` [\#583](https://github.com/operator-framework/operator-lifecycle-manager/pull/583) ([alecmerdler](https://github.com/alecmerdler))
- fix\(csv-requeue\): requeue on namespace all if all namespaces are watched [\#572](https://github.com/operator-framework/operator-lifecycle-manager/pull/572) ([njhale](https://github.com/njhale))
- Fix Go Modules  [\#561](https://github.com/operator-framework/operator-lifecycle-manager/pull/561) ([alecmerdler](https://github.com/alecmerdler))
- fix\(queueInformers\): use separate queue for each namespace [\#560](https://github.com/operator-framework/operator-lifecycle-manager/pull/560) ([njhale](https://github.com/njhale))
- fix\(olm\): set lister up for deployments [\#550](https://github.com/operator-framework/operator-lifecycle-manager/pull/550) ([jpeeler](https://github.com/jpeeler))
- Fix olm pod name so log to be written correctly to olm.log [\#549](https://github.com/operator-framework/operator-lifecycle-manager/pull/549) ([dinhxuanvu](https://github.com/dinhxuanvu))
- Fix template values for 'olm' parameters [\#537](https://github.com/operator-framework/operator-lifecycle-manager/pull/537) ([rhuss](https://github.com/rhuss))
- fix\(e2e\): switch to port 5443 for owned apiservice test [\#527](https://github.com/operator-framework/operator-lifecycle-manager/pull/527) ([njhale](https://github.com/njhale))
- fix\(package-server\): make secure port configurable and default to 5443 [\#524](https://github.com/operator-framework/operator-lifecycle-manager/pull/524) ([ecordell](https://github.com/ecordell))
- fix\(olm\): don't annotate namespaces on operator creation [\#523](https://github.com/operator-framework/operator-lifecycle-manager/pull/523) ([ecordell](https://github.com/ecordell))
- fix\(build\): add cleanup for package release files [\#517](https://github.com/operator-framework/operator-lifecycle-manager/pull/517) ([jpeeler](https://github.com/jpeeler))
- fix\(metrics\): use CRD client instead of k8s [\#515](https://github.com/operator-framework/operator-lifecycle-manager/pull/515) ([jpeeler](https://github.com/jpeeler))
- fix\(requirements\): add support for non resource url rules [\#514](https://github.com/operator-framework/operator-lifecycle-manager/pull/514) ([njhale](https://github.com/njhale))
- Rewrite Namespace when Fetching Global PackageManifests [\#513](https://github.com/operator-framework/operator-lifecycle-manager/pull/513) ([alecmerdler](https://github.com/alecmerdler))
- Small log statement fix with olm requirements [\#508](https://github.com/operator-framework/operator-lifecycle-manager/pull/508) ([eriknelson](https://github.com/eriknelson))
- fix\(requirements\): remove extra empty permission requirement statuses [\#506](https://github.com/operator-framework/operator-lifecycle-manager/pull/506) ([njhale](https://github.com/njhale))
- fix\(ci\): use deployment namespace for catalog\_namespace [\#504](https://github.com/operator-framework/operator-lifecycle-manager/pull/504) ([njhale](https://github.com/njhale))
- fix 30\_14-imagestream.yaml formatting [\#500](https://github.com/operator-framework/operator-lifecycle-manager/pull/500) ([mrogers950](https://github.com/mrogers950))
- Add missing binary to fix run-local-shift [\#497](https://github.com/operator-framework/operator-lifecycle-manager/pull/497) ([font](https://github.com/font))
- feat\(csv\): install owned APIServices [\#492](https://github.com/operator-framework/operator-lifecycle-manager/pull/492) ([njhale](https://github.com/njhale))
- fix\(build\): don't vendor [\#490](https://github.com/operator-framework/operator-lifecycle-manager/pull/490) ([ecordell](https://github.com/ecordell))
- fix\(deploy\): yaml error in imagereferences [\#486](https://github.com/operator-framework/operator-lifecycle-manager/pull/486) ([ecordell](https://github.com/ecordell))
- fix\(deploy\): only use replace on configmaps [\#483](https://github.com/operator-framework/operator-lifecycle-manager/pull/483) ([ecordell](https://github.com/ecordell))

**Closed issues:**

- Continuous Delivery via OLM [\#742](https://github.com/operator-framework/operator-lifecycle-manager/issues/742)
- Operator install plans fail w/repeat count regexp parsing error with OLM 0.8.1+ on OCP 3.11 [\#735](https://github.com/operator-framework/operator-lifecycle-manager/issues/735)
- Generated aggregated cluster roles contains group id in resource name [\#730](https://github.com/operator-framework/operator-lifecycle-manager/issues/730)
- package server panic when deploying operator source from operator-marketplace [\#728](https://github.com/operator-framework/operator-lifecycle-manager/issues/728)
- Help needed with CR display name [\#725](https://github.com/operator-framework/operator-lifecycle-manager/issues/725)
- OLM complains with "Policy rule not satisfied for service account" [\#724](https://github.com/operator-framework/operator-lifecycle-manager/issues/724)
- operator does not upgrade packagserver [\#706](https://github.com/operator-framework/operator-lifecycle-manager/issues/706)
- Unable to deploy OLM on minishift [\#705](https://github.com/operator-framework/operator-lifecycle-manager/issues/705)
- How to enable all workspaces so that OLM watches them? [\#698](https://github.com/operator-framework/operator-lifecycle-manager/issues/698)
- README links to CRDs, Descriptors, and Packages are broken [\#694](https://github.com/operator-framework/operator-lifecycle-manager/issues/694)
- MountVolume.SetUp failed for volume "config-volume" : secrets "alertmanager-alertmanager-main" not found [\#648](https://github.com/operator-framework/operator-lifecycle-manager/issues/648)
- Use CR definitions instead of configmap data [\#644](https://github.com/operator-framework/operator-lifecycle-manager/issues/644)
- `make run-local` for Minikube fails with "packageserver" deployment failure [\#642](https://github.com/operator-framework/operator-lifecycle-manager/issues/642)
- Question: instalingl the OLM via the CVO [\#628](https://github.com/operator-framework/operator-lifecycle-manager/issues/628)
- change catalog operator default namespace [\#627](https://github.com/operator-framework/operator-lifecycle-manager/issues/627)
- manifests: OLM is creating a namespace without run-level [\#619](https://github.com/operator-framework/operator-lifecycle-manager/issues/619)
- Non operator-sdk operators [\#610](https://github.com/operator-framework/operator-lifecycle-manager/issues/610)
- Unable to retrieve pull secret openshift-operator-lifecycle-manager/coreos-pull-secret for openshift-operator-lifecycle-manager/olm-operator... [\#607](https://github.com/operator-framework/operator-lifecycle-manager/issues/607)
- package-server pod keeps crashing [\#598](https://github.com/operator-framework/operator-lifecycle-manager/issues/598)
- OLM GUI does not have permission to list its OLM CRDs [\#597](https://github.com/operator-framework/operator-lifecycle-manager/issues/597)
- OLM compatibility with cluster monitoring Operator  [\#581](https://github.com/operator-framework/operator-lifecycle-manager/issues/581)
- ClusterRoleBinding against aggregated-apiserver-clusterrole without role manifest [\#577](https://github.com/operator-framework/operator-lifecycle-manager/issues/577)
- Failed to update catalog source `rh-operators` status [\#544](https://github.com/operator-framework/operator-lifecycle-manager/issues/544)
- Latest console image is broken [\#540](https://github.com/operator-framework/operator-lifecycle-manager/issues/540)
- Question: How to "enable" the OLM in the console for Minishift ? [\#538](https://github.com/operator-framework/operator-lifecycle-manager/issues/538)
- olm-operator local run expects `master` image tag which is unavailable [\#529](https://github.com/operator-framework/operator-lifecycle-manager/issues/529)
- CSV waits for wrong CRD version to be available [\#507](https://github.com/operator-framework/operator-lifecycle-manager/issues/507)
- Add support for specifying multiple CRDs in one yaml file [\#495](https://github.com/operator-framework/operator-lifecycle-manager/issues/495)
- make run-local-shift fails on minishift due to the lack of helm [\#488](https://github.com/operator-framework/operator-lifecycle-manager/issues/488)
- CSV support for ClusterRoles [\#473](https://github.com/operator-framework/operator-lifecycle-manager/issues/473)

**Other changes:**

- docs\(git\): add changelog [\#765](https://github.com/operator-framework/operator-lifecycle-manager/pull/765) ([njhale](https://github.com/njhale))
- chore\(manifests\): regenerate manifests to include new anyOf validation [\#744](https://github.com/operator-framework/operator-lifecycle-manager/pull/744) ([njhale](https://github.com/njhale))
- docs: update CSV link [\#713](https://github.com/operator-framework/operator-lifecycle-manager/pull/713) ([robszumski](https://github.com/robszumski))
- chore\(deploy\): use downstream image for openshift builds [\#693](https://github.com/operator-framework/operator-lifecycle-manager/pull/693) ([ecordell](https://github.com/ecordell))
- chore\(modules\): update operator-registry module to v1.0.6 [\#691](https://github.com/operator-framework/operator-lifecycle-manager/pull/691) ([njhale](https://github.com/njhale))
- Add godoc for InstallModeTypes [\#683](https://github.com/operator-framework/operator-lifecycle-manager/pull/683) ([pmorie](https://github.com/pmorie))
- chore\(deploy\): change 30 prefix to 50 [\#678](https://github.com/operator-framework/operator-lifecycle-manager/pull/678) ([ecordell](https://github.com/ecordell))
- Cut 0.8.1 [\#662](https://github.com/operator-framework/operator-lifecycle-manager/pull/662) ([ecordell](https://github.com/ecordell))
- Update metering InstallModes to support SingleNamespace [\#658](https://github.com/operator-framework/operator-lifecycle-manager/pull/658) ([chancez](https://github.com/chancez))
- chore\(ci\): remove ci checks for PRs [\#654](https://github.com/operator-framework/operator-lifecycle-manager/pull/654) ([ecordell](https://github.com/ecordell))
- Remove operatorsource installation [\#651](https://github.com/operator-framework/operator-lifecycle-manager/pull/651) ([kevinrizza](https://github.com/kevinrizza))
- update Service Catalog memory & cpu limits [\#649](https://github.com/operator-framework/operator-lifecycle-manager/pull/649) ([jboyd01](https://github.com/jboyd01))
- Add Metering Operator to catalog [\#647](https://github.com/operator-framework/operator-lifecycle-manager/pull/647) ([EmilyM1](https://github.com/EmilyM1))
- fix 1663113. Add component image ENV vars to cluster-logging-operator [\#645](https://github.com/operator-framework/operator-lifecycle-manager/pull/645) ([jcantrill](https://github.com/jcantrill))
- Updated MongoDB Operator to 0.6 [\#641](https://github.com/operator-framework/operator-lifecycle-manager/pull/641) ([rodrigovalin](https://github.com/rodrigovalin))
- chore\(fake\): add fake for registry client [\#630](https://github.com/operator-framework/operator-lifecycle-manager/pull/630) ([ecordell](https://github.com/ecordell))
- increase memory limits on all service catalog pods [\#629](https://github.com/operator-framework/operator-lifecycle-manager/pull/629) ([jboyd01](https://github.com/jboyd01))
- Install operatorsource crd and default cr [\#622](https://github.com/operator-framework/operator-lifecycle-manager/pull/622) ([kevinrizza](https://github.com/kevinrizza))
- Updated CSV marketplace manifests [\#621](https://github.com/operator-framework/operator-lifecycle-manager/pull/621) ([ecordell](https://github.com/ecordell))
- add rbac for servicebindings/finalizers [\#615](https://github.com/operator-framework/operator-lifecycle-manager/pull/615) ([jboyd01](https://github.com/jboyd01))
- Regen manifests [\#611](https://github.com/operator-framework/operator-lifecycle-manager/pull/611) ([ecordell](https://github.com/ecordell))
- Descheduler operator CRD, CSV [\#584](https://github.com/operator-framework/operator-lifecycle-manager/pull/584) ([ravisantoshgudimetla](https://github.com/ravisantoshgudimetla))
- chore\(docs\): fix markdown lint warnings [\#574](https://github.com/operator-framework/operator-lifecycle-manager/pull/574) ([jpeeler](https://github.com/jpeeler))
- docs\(arch\): add operator groups [\#573](https://github.com/operator-framework/operator-lifecycle-manager/pull/573) ([jpeeler](https://github.com/jpeeler))
- Creating csv, crd, and packages for clusterlogging and elasticsearch … [\#570](https://github.com/operator-framework/operator-lifecycle-manager/pull/570) ([jcantrill](https://github.com/jcantrill))
- Cut 0.8.0 [\#567](https://github.com/operator-framework/operator-lifecycle-manager/pull/567) ([ecordell](https://github.com/ecordell))
- chore\(build\): remove vendor commands from base dockerfile [\#566](https://github.com/operator-framework/operator-lifecycle-manager/pull/566) ([ecordell](https://github.com/ecordell))
- chore\(release\): bump version to 0.8.0 [\#565](https://github.com/operator-framework/operator-lifecycle-manager/pull/565) ([ecordell](https://github.com/ecordell))
- Service Catalog CSV: update resource limitations [\#562](https://github.com/operator-framework/operator-lifecycle-manager/pull/562) ([jboyd01](https://github.com/jboyd01))
- Update AMQ logo to new brand standard [\#547](https://github.com/operator-framework/operator-lifecycle-manager/pull/547) ([rhamilto](https://github.com/rhamilto))
- use OpenShift's ServiceCatalog build, update rbac + more [\#545](https://github.com/operator-framework/operator-lifecycle-manager/pull/545) ([jboyd01](https://github.com/jboyd01))
- Add Service to Owned Resources for Prometheus Operator [\#539](https://github.com/operator-framework/operator-lifecycle-manager/pull/539) ([alecmerdler](https://github.com/alecmerdler))
- Add `ConfigMap` as an Owned Resource for Prometheus [\#535](https://github.com/operator-framework/operator-lifecycle-manager/pull/535) ([alecmerdler](https://github.com/alecmerdler))
- chore\(release\): cut release 0.7.4 [\#534](https://github.com/operator-framework/operator-lifecycle-manager/pull/534) ([njhale](https://github.com/njhale))
- chore\(release\): bump version number to 0.7.4 [\#533](https://github.com/operator-framework/operator-lifecycle-manager/pull/533) ([njhale](https://github.com/njhale))
- \[Doc\] Add note about helm binary requirement [\#528](https://github.com/operator-framework/operator-lifecycle-manager/pull/528) ([aditya-konarde](https://github.com/aditya-konarde))
- chore\(package-server\): enable auth by default [\#526](https://github.com/operator-framework/operator-lifecycle-manager/pull/526) ([njhale](https://github.com/njhale))
- More Descriptors for Dynatrace Operator [\#522](https://github.com/operator-framework/operator-lifecycle-manager/pull/522) ([alecmerdler](https://github.com/alecmerdler))
- More Descriptors for Couchbase Operator [\#520](https://github.com/operator-framework/operator-lifecycle-manager/pull/520) ([alecmerdler](https://github.com/alecmerdler))
- Update OKD install instructions [\#519](https://github.com/operator-framework/operator-lifecycle-manager/pull/519) ([font](https://github.com/font))
- bump 0.7.3 [\#512](https://github.com/operator-framework/operator-lifecycle-manager/pull/512) ([ecordell](https://github.com/ecordell))
- chore\(deploy\): update release scripts to not use 3 different images [\#510](https://github.com/operator-framework/operator-lifecycle-manager/pull/510) ([ecordell](https://github.com/ecordell))
- chore\(deploy\): put all binaries in the same image [\#509](https://github.com/operator-framework/operator-lifecycle-manager/pull/509) ([ecordell](https://github.com/ecordell))
- chore\(deploy\): use runlevel label on namespace [\#503](https://github.com/operator-framework/operator-lifecycle-manager/pull/503) ([smarterclayton](https://github.com/smarterclayton))
- add example and additional info about optional CSV metadata  \(replace… [\#501](https://github.com/operator-framework/operator-lifecycle-manager/pull/501) ([madorn](https://github.com/madorn))
- Fix for Federation CSV [\#498](https://github.com/operator-framework/operator-lifecycle-manager/pull/498) ([alecmerdler](https://github.com/alecmerdler))
- Dropping label for origin releasepayload [\#496](https://github.com/operator-framework/operator-lifecycle-manager/pull/496) ([abhinavdahiya](https://github.com/abhinavdahiya))
- fix\(deploy\): add base images for ci-operator [\#493](https://github.com/operator-framework/operator-lifecycle-manager/pull/493) ([ecordell](https://github.com/ecordell))
- rh-operators: add FederationV2 v0.0.2 [\#491](https://github.com/operator-framework/operator-lifecycle-manager/pull/491) ([font](https://github.com/font))
- change go build to use 1.10 [\#489](https://github.com/operator-framework/operator-lifecycle-manager/pull/489) ([jpeeler](https://github.com/jpeeler))
- Revert "fix\(deploy\): remove package-server until ci-operator is outpu… [\#487](https://github.com/operator-framework/operator-lifecycle-manager/pull/487) ([ecordell](https://github.com/ecordell))
- re-cut 0.7.1 [\#484](https://github.com/operator-framework/operator-lifecycle-manager/pull/484) ([ecordell](https://github.com/ecordell))
- certified-operators: rectify form of business for Dynatrace [\#478](https://github.com/operator-framework/operator-lifecycle-manager/pull/478) ([baichinger](https://github.com/baichinger))
- Cut 0.7.1 [\#475](https://github.com/operator-framework/operator-lifecycle-manager/pull/475) ([ecordell](https://github.com/ecordell))

## [0.7.1](https://github.com/operator-framework/operator-lifecycle-manager/tree/0.7.1) (2018-09-19)
[Full Changelog](https://github.com/operator-framework/operator-lifecycle-manager/compare/0.7.0...0.7.1)

**Closed issues:**

- Tag "master" of quay.io/coreos/package-server does not exist [\#471](https://github.com/operator-framework/operator-lifecycle-manager/issues/471)

**Other changes:**

- feat\(ci\): push tags to quay [\#474](https://github.com/operator-framework/operator-lifecycle-manager/pull/474) ([ecordell](https://github.com/ecordell))

## [0.7.0](https://github.com/operator-framework/operator-lifecycle-manager/tree/0.7.0) (2018-09-19)
[Full Changelog](https://github.com/operator-framework/operator-lifecycle-manager/compare/v3.11.0...0.7.0)

**Closed issues:**

- minishift steps need to be updated for service catalog [\#469](https://github.com/operator-framework/operator-lifecycle-manager/issues/469)
- The `--service-catalog` clusterup option is invalid for OS 3.10+ [\#468](https://github.com/operator-framework/operator-lifecycle-manager/issues/468)
- `The ConfigMap "rh-operators" is invalid` while installing on upstream k8s [\#467](https://github.com/operator-framework/operator-lifecycle-manager/issues/467)

**Other changes:**

- 0.7.0 packages api [\#472](https://github.com/operator-framework/operator-lifecycle-manager/pull/472) ([ecordell](https://github.com/ecordell))
- Issue \#469 update the service catalog instruction for minishift. [\#470](https://github.com/operator-framework/operator-lifecycle-manager/pull/470) ([praveenkumar](https://github.com/praveenkumar))
- Documentation: Change to full path [\#466](https://github.com/operator-framework/operator-lifecycle-manager/pull/466) ([LiliC](https://github.com/LiliC))
- All Namespaces Support for PackageManifest API  [\#465](https://github.com/operator-framework/operator-lifecycle-manager/pull/465) ([alecmerdler](https://github.com/alecmerdler))
- Create OWNERS [\#464](https://github.com/operator-framework/operator-lifecycle-manager/pull/464) ([ecordell](https://github.com/ecordell))
- test\(e2e\): add OwnerReference GC behavior test [\#463](https://github.com/operator-framework/operator-lifecycle-manager/pull/463) ([njhale](https://github.com/njhale))
- Cut 0.7.0 [\#462](https://github.com/operator-framework/operator-lifecycle-manager/pull/462) ([ecordell](https://github.com/ecordell))
- List out options for Descriptors [\#461](https://github.com/operator-framework/operator-lifecycle-manager/pull/461) ([madorn](https://github.com/madorn))
- cut 0.7.0 images [\#460](https://github.com/operator-framework/operator-lifecycle-manager/pull/460) ([ecordell](https://github.com/ecordell))
- feat\(olm\): support depending on APIservices [\#459](https://github.com/operator-framework/operator-lifecycle-manager/pull/459) ([ecordell](https://github.com/ecordell))
- Improvements on the MongoDB Enterprise Operator CSV. [\#458](https://github.com/operator-framework/operator-lifecycle-manager/pull/458) ([rodrigovalin](https://github.com/rodrigovalin))
- \[WIP\] feat\(catalog\): add RBAC step resolution [\#457](https://github.com/operator-framework/operator-lifecycle-manager/pull/457) ([njhale](https://github.com/njhale))
- add metrics [\#452](https://github.com/operator-framework/operator-lifecycle-manager/pull/452) ([jpeeler](https://github.com/jpeeler))

## [v3.11.0](https://github.com/operator-framework/operator-lifecycle-manager/tree/v3.11.0) (2018-09-13)
[Full Changelog](https://github.com/operator-framework/operator-lifecycle-manager/compare/0.6.0...v3.11.0)

**Implemented enhancements:**

- Instructions for Running OLM UI [\#431](https://github.com/operator-framework/operator-lifecycle-manager/pull/431) ([alecmerdler](https://github.com/alecmerdler))
- Action Descriptors [\#426](https://github.com/operator-framework/operator-lifecycle-manager/pull/426) ([alecmerdler](https://github.com/alecmerdler))

**Fixed bugs:**

- `./scripts/run\_console\_local.sh` doesn't provide a usable console with `make run-local` or `make run-local-shift` [\#437](https://github.com/operator-framework/operator-lifecycle-manager/issues/437)

**Closed issues:**

- Can't deploy OLM onto OpenShift [\#436](https://github.com/operator-framework/operator-lifecycle-manager/issues/436)
- Creation of CRD defined in 05-catalogsource.crd.yaml fails [\#416](https://github.com/operator-framework/operator-lifecycle-manager/issues/416)

**Other changes:**

- fix\(vendor\): revendor dependencies [\#456](https://github.com/operator-framework/operator-lifecycle-manager/pull/456) ([njhale](https://github.com/njhale))
- fix\(vendor\): revendor dependencies [\#455](https://github.com/operator-framework/operator-lifecycle-manager/pull/455) ([njhale](https://github.com/njhale))
- feat\(olm\): attempt to cleanup namespace annotations on shutdown [\#454](https://github.com/operator-framework/operator-lifecycle-manager/pull/454) ([ecordell](https://github.com/ecordell))
- feat\(olm\): attempt to cleanup namespace annotations on shutdown [\#453](https://github.com/operator-framework/operator-lifecycle-manager/pull/453) ([ecordell](https://github.com/ecordell))
- \[WIP\] fix\(ci\): add pipeline queueing [\#451](https://github.com/operator-framework/operator-lifecycle-manager/pull/451) ([njhale](https://github.com/njhale))
- fix\(prometheus\): add securityContext to alertmanager example [\#450](https://github.com/operator-framework/operator-lifecycle-manager/pull/450) ([ecordell](https://github.com/ecordell))
- docs: install OLM with 'kubectl create -f' instead of 'kubectl apply -f' [\#449](https://github.com/operator-framework/operator-lifecycle-manager/pull/449) ([djwhatle](https://github.com/djwhatle))
- feat\(cmd\): add version flags  [\#448](https://github.com/operator-framework/operator-lifecycle-manager/pull/448) ([njhale](https://github.com/njhale))
- feat\(catalog\): add aggregated roles for each resolved CRD [\#447](https://github.com/operator-framework/operator-lifecycle-manager/pull/447) ([ecordell](https://github.com/ecordell))
- docs: add CSV guide [\#446](https://github.com/operator-framework/operator-lifecycle-manager/pull/446) ([robszumski](https://github.com/robszumski))
- feat\(run\_console\_local\): add docker pull for console image [\#445](https://github.com/operator-framework/operator-lifecycle-manager/pull/445) ([njhale](https://github.com/njhale))
- chore\(rbac\): add olm-specific ClusterRole [\#444](https://github.com/operator-framework/operator-lifecycle-manager/pull/444) ([ecordell](https://github.com/ecordell))
- Remove outdated install instructions [\#443](https://github.com/operator-framework/operator-lifecycle-manager/pull/443) ([ecordell](https://github.com/ecordell))
- chore\(deploy\): remove ansible scripts for install [\#442](https://github.com/operator-framework/operator-lifecycle-manager/pull/442) ([ecordell](https://github.com/ecordell))
- Fix Local Console Script with Minikube [\#441](https://github.com/operator-framework/operator-lifecycle-manager/pull/441) ([alecmerdler](https://github.com/alecmerdler))
- Add/update CSVs for RH and partners [\#440](https://github.com/operator-framework/operator-lifecycle-manager/pull/440) ([robszumski](https://github.com/robszumski))
- feat\(osbs\): add non-multistage dockerfile [\#439](https://github.com/operator-framework/operator-lifecycle-manager/pull/439) ([njhale](https://github.com/njhale))
- Remove broker files for repo migration [\#438](https://github.com/operator-framework/operator-lifecycle-manager/pull/438) ([jpeeler](https://github.com/jpeeler))
- Allow use of existing KUBECONFIG env var for e2e [\#435](https://github.com/operator-framework/operator-lifecycle-manager/pull/435) ([jpeeler](https://github.com/jpeeler))
- \[WIP\] Package Extension API Server [\#433](https://github.com/operator-framework/operator-lifecycle-manager/pull/433) ([njhale](https://github.com/njhale))
- Separate internal API client wrappers from generated external clients [\#432](https://github.com/operator-framework/operator-lifecycle-manager/pull/432) ([ecordell](https://github.com/ecordell))
- Catalog renaming OCS -\> rh-operators [\#429](https://github.com/operator-framework/operator-lifecycle-manager/pull/429) ([ecordell](https://github.com/ecordell))
- Red Hat CD Readiness [\#428](https://github.com/operator-framework/operator-lifecycle-manager/pull/428) ([njhale](https://github.com/njhale))
- test\(e2e\): add catalog loading between operator restart test [\#427](https://github.com/operator-framework/operator-lifecycle-manager/pull/427) ([njhale](https://github.com/njhale))
- updated prometheus csv according to the integration into openshift [\#425](https://github.com/operator-framework/operator-lifecycle-manager/pull/425) ([sichvoge](https://github.com/sichvoge))
- fix\(catalog\): add check for loaded catalogs [\#424](https://github.com/operator-framework/operator-lifecycle-manager/pull/424) ([njhale](https://github.com/njhale))
- feat\(subscription\): add dedicated currentCSV field to subscription [\#423](https://github.com/operator-framework/operator-lifecycle-manager/pull/423) ([njhale](https://github.com/njhale))
- fix\(operatorclient\): remove wait for deployment rollout [\#422](https://github.com/operator-framework/operator-lifecycle-manager/pull/422) ([njhale](https://github.com/njhale))
- fix\(e2e\): remove deployment cleanup [\#421](https://github.com/operator-framework/operator-lifecycle-manager/pull/421) ([njhale](https://github.com/njhale))
- Set Status on Subscription with Invalid Catalog Source [\#420](https://github.com/operator-framework/operator-lifecycle-manager/pull/420) ([alecmerdler](https://github.com/alecmerdler))
- feat\(catalog\): add catalog status block updates [\#419](https://github.com/operator-framework/operator-lifecycle-manager/pull/419) ([njhale](https://github.com/njhale))
- Deployment fixes  [\#418](https://github.com/operator-framework/operator-lifecycle-manager/pull/418) ([ecordell](https://github.com/ecordell))
- Fixes \#416 [\#417](https://github.com/operator-framework/operator-lifecycle-manager/pull/417) ([mvazquezc](https://github.com/mvazquezc))
- \[WIP\] feat\(catalog\): add namespace awareness to plan execution [\#415](https://github.com/operator-framework/operator-lifecycle-manager/pull/415) ([njhale](https://github.com/njhale))
- Make key resources linkable in philosophy doc [\#414](https://github.com/operator-framework/operator-lifecycle-manager/pull/414) ([pmorie](https://github.com/pmorie))
- Cut 0.6.0 [\#413](https://github.com/operator-framework/operator-lifecycle-manager/pull/413) ([ecordell](https://github.com/ecordell))
- \[WIP\] feat\(resolver\): add namespace and channel awareness [\#402](https://github.com/operator-framework/operator-lifecycle-manager/pull/402) ([njhale](https://github.com/njhale))

## [0.6.0](https://github.com/operator-framework/operator-lifecycle-manager/tree/0.6.0) (2018-08-07)
[Full Changelog](https://github.com/operator-framework/operator-lifecycle-manager/compare/0.5.0...0.6.0)

**Closed issues:**

- Attempting upstream installation against kube \>= 1.11 fails with validation errors [\#400](https://github.com/operator-framework/operator-lifecycle-manager/issues/400)
- make schema-check fails with missing vendored dependency [\#389](https://github.com/operator-framework/operator-lifecycle-manager/issues/389)

**Other changes:**

- chore\(vendor\): remove vendor directory [\#412](https://github.com/operator-framework/operator-lifecycle-manager/pull/412) ([ecordell](https://github.com/ecordell))
- fix\(e2e\) + fix\(csv upgrade\) + fix\(leak\) [\#411](https://github.com/operator-framework/operator-lifecycle-manager/pull/411) ([ecordell](https://github.com/ecordell))
- minor: broken link [\#408](https://github.com/operator-framework/operator-lifecycle-manager/pull/408) ([Jiri-Kremser](https://github.com/Jiri-Kremser))
- fix\(csv\): CSV update process optimization regression [\#407](https://github.com/operator-framework/operator-lifecycle-manager/pull/407) ([ecordell](https://github.com/ecordell))
- Use GroupVersionKind in Spec Descriptor for Selector [\#405](https://github.com/operator-framework/operator-lifecycle-manager/pull/405) ([alecmerdler](https://github.com/alecmerdler))
- Catalog Cleanup [\#404](https://github.com/operator-framework/operator-lifecycle-manager/pull/404) ([ecordell](https://github.com/ecordell))
- 1.11 updates [\#403](https://github.com/operator-framework/operator-lifecycle-manager/pull/403) ([ecordell](https://github.com/ecordell))
- test\(catalog\_versions\): add multi-catalogsource aware resolution tests [\#401](https://github.com/operator-framework/operator-lifecycle-manager/pull/401) ([njhale](https://github.com/njhale))
- Add CatalogSource Namespace To CRD Validation [\#399](https://github.com/operator-framework/operator-lifecycle-manager/pull/399) ([alecmerdler](https://github.com/alecmerdler))
- chore\(deps\): update k8s libs to 1.11 versions [\#398](https://github.com/operator-framework/operator-lifecycle-manager/pull/398) ([ecordell](https://github.com/ecordell))
- docs: add access control workflow [\#397](https://github.com/operator-framework/operator-lifecycle-manager/pull/397) ([robszumski](https://github.com/robszumski))
- test\(installplan\): multi source e2e [\#396](https://github.com/operator-framework/operator-lifecycle-manager/pull/396) ([njhale](https://github.com/njhale))
- chore\(ci\): update gitlab-ci.yml from jsonnet [\#395](https://github.com/operator-framework/operator-lifecycle-manager/pull/395) ([ecordell](https://github.com/ecordell))
- fix\(installplan\): type InstallPlan.Status.CatalogSources to \[\]string … [\#394](https://github.com/operator-framework/operator-lifecycle-manager/pull/394) ([njhale](https://github.com/njhale))
- Deploy CI to `operator-lifecycle-manager` Namespace [\#393](https://github.com/operator-framework/operator-lifecycle-manager/pull/393) ([alecmerdler](https://github.com/alecmerdler))
- Fix invalid `minishift start` option in build\_local\_shift.sh [\#392](https://github.com/operator-framework/operator-lifecycle-manager/pull/392) ([jsm84](https://github.com/jsm84))
- vendor: re-run `dep ensure` [\#390](https://github.com/operator-framework/operator-lifecycle-manager/pull/390) ([jzelinskie](https://github.com/jzelinskie))
- feat\(catalog\_resources\): add prometheus 0.22.1 [\#388](https://github.com/operator-framework/operator-lifecycle-manager/pull/388) ([ecordell](https://github.com/ecordell))
- feat\(catalog\): multiple CatalogSource resolution [\#386](https://github.com/operator-framework/operator-lifecycle-manager/pull/386) ([njhale](https://github.com/njhale))

## [0.5.0](https://github.com/operator-framework/operator-lifecycle-manager/tree/0.5.0) (2018-07-23)
[Full Changelog](https://github.com/operator-framework/operator-lifecycle-manager/compare/0.4.0...0.5.0)

**Implemented enhancements:**

- Separate Manifest Validator [\#365](https://github.com/operator-framework/operator-lifecycle-manager/pull/365) ([alecmerdler](https://github.com/alecmerdler))
- Manual Approval of Install Plans [\#347](https://github.com/operator-framework/operator-lifecycle-manager/pull/347) ([alecmerdler](https://github.com/alecmerdler))
- GitLab CI Fix  [\#341](https://github.com/operator-framework/operator-lifecycle-manager/pull/341) ([alecmerdler](https://github.com/alecmerdler))

**Fixed bugs:**

- Prevent ownership conflicts for CRDs [\#375](https://github.com/operator-framework/operator-lifecycle-manager/pull/375) ([ecordell](https://github.com/ecordell))
- Fix InstallPlanReference in Subscription Status [\#359](https://github.com/operator-framework/operator-lifecycle-manager/pull/359) ([ecordell](https://github.com/ecordell))
- Fix Subscriptions being Updated Without Changes [\#357](https://github.com/operator-framework/operator-lifecycle-manager/pull/357) ([alecmerdler](https://github.com/alecmerdler))
- Slack Webhook Rename [\#337](https://github.com/operator-framework/operator-lifecycle-manager/pull/337) ([alecmerdler](https://github.com/alecmerdler))
- Clarify Status Condition when Catalog Source Not Found [\#335](https://github.com/operator-framework/operator-lifecycle-manager/pull/335) ([alecmerdler](https://github.com/alecmerdler))

**Closed issues:**

- Typos in architecture doc [\#376](https://github.com/operator-framework/operator-lifecycle-manager/issues/376)
- make manifests error when rendering templates with helm [\#369](https://github.com/operator-framework/operator-lifecycle-manager/issues/369)
- make run-local missing charts [\#368](https://github.com/operator-framework/operator-lifecycle-manager/issues/368)
- make run-local is broken [\#366](https://github.com/operator-framework/operator-lifecycle-manager/issues/366)
- make build fails [\#360](https://github.com/operator-framework/operator-lifecycle-manager/issues/360)
- vendoring fails when run `make vendor` [\#350](https://github.com/operator-framework/operator-lifecycle-manager/issues/350)

**Other changes:**

- fix SingleSourceResolver to use plan namespace for resolved CSVs [\#387](https://github.com/operator-framework/operator-lifecycle-manager/pull/387) ([njhale](https://github.com/njhale))
- Add CatalogSource Name to InstallPlan Steps [\#385](https://github.com/operator-framework/operator-lifecycle-manager/pull/385) ([njhale](https://github.com/njhale))
- Fix OpenShift Deploy CI [\#384](https://github.com/operator-framework/operator-lifecycle-manager/pull/384) ([alecmerdler](https://github.com/alecmerdler))
- Deploy to OpenShift Cluster [\#383](https://github.com/operator-framework/operator-lifecycle-manager/pull/383) ([alecmerdler](https://github.com/alecmerdler))
- fix\(docs\): correct spelling of philosopy.md [\#382](https://github.com/operator-framework/operator-lifecycle-manager/pull/382) ([aravindhp](https://github.com/aravindhp))
- Cut 0.5.0 [\#381](https://github.com/operator-framework/operator-lifecycle-manager/pull/381) ([ecordell](https://github.com/ecordell))
- Add CatalogSource Namespace to Subscription Objects [\#380](https://github.com/operator-framework/operator-lifecycle-manager/pull/380) ([alecmerdler](https://github.com/alecmerdler))
- fix\(docs\): typos in architecture.md [\#377](https://github.com/operator-framework/operator-lifecycle-manager/pull/377) ([ecordell](https://github.com/ecordell))
- Fix a small typo [\#374](https://github.com/operator-framework/operator-lifecycle-manager/pull/374) ([fabiand](https://github.com/fabiand))
- fix\(servicebroker\): add main\_test.go to servicebroker cmd [\#372](https://github.com/operator-framework/operator-lifecycle-manager/pull/372) ([ecordell](https://github.com/ecordell))
- fix\(make\): fixes run-local and run-local-shift [\#371](https://github.com/operator-framework/operator-lifecycle-manager/pull/371) ([ecordell](https://github.com/ecordell))
- Remove tectonic-operators [\#370](https://github.com/operator-framework/operator-lifecycle-manager/pull/370) ([ecordell](https://github.com/ecordell))
- fix\(make\): set version var for run-local [\#367](https://github.com/operator-framework/operator-lifecycle-manager/pull/367) ([ecordell](https://github.com/ecordell))
- Resolve Install Plan before Requiring Approval [\#364](https://github.com/operator-framework/operator-lifecycle-manager/pull/364) ([alecmerdler](https://github.com/alecmerdler))
- readme: fix broken link to CSV example [\#363](https://github.com/operator-framework/operator-lifecycle-manager/pull/363) ([robszumski](https://github.com/robszumski))
- Fix memory usage in catalog operator [\#362](https://github.com/operator-framework/operator-lifecycle-manager/pull/362) ([ecordell](https://github.com/ecordell))
- Tests for Runaway Control Loops [\#361](https://github.com/operator-framework/operator-lifecycle-manager/pull/361) ([alecmerdler](https://github.com/alecmerdler))
- Fix the deploy to kubernetes command in install.md [\#358](https://github.com/operator-framework/operator-lifecycle-manager/pull/358) ([aravindhp](https://github.com/aravindhp))
- Ansible playbook [\#356](https://github.com/operator-framework/operator-lifecycle-manager/pull/356) ([ecordell](https://github.com/ecordell))
- Add metering to a separate, upstream-only catalog [\#354](https://github.com/operator-framework/operator-lifecycle-manager/pull/354) ([ecordell](https://github.com/ecordell))
- chore\(deps\): commit vendored dependencies  [\#352](https://github.com/operator-framework/operator-lifecycle-manager/pull/352) ([ecordell](https://github.com/ecordell))
- feat\(servicebroker\): list one serviceclass per package [\#349](https://github.com/operator-framework/operator-lifecycle-manager/pull/349) ([ericavonb](https://github.com/ericavonb))
- Add installPlanApproval to Subscription-v1 [\#348](https://github.com/operator-framework/operator-lifecycle-manager/pull/348) ([ecordell](https://github.com/ecordell))
- Strip Markdown Descriptions from OSB [\#346](https://github.com/operator-framework/operator-lifecycle-manager/pull/346) ([alecmerdler](https://github.com/alecmerdler))
- test validate service broker api version function [\#345](https://github.com/operator-framework/operator-lifecycle-manager/pull/345) ([ericavonb](https://github.com/ericavonb))
- OSB Rebase \(part 2\) [\#344](https://github.com/operator-framework/operator-lifecycle-manager/pull/344) ([ecordell](https://github.com/ecordell))
- Rebased OSB backbone [\#342](https://github.com/operator-framework/operator-lifecycle-manager/pull/342) ([ecordell](https://github.com/ecordell))
- Update manifests for 0.4.0 release [\#340](https://github.com/operator-framework/operator-lifecycle-manager/pull/340) ([ecordell](https://github.com/ecordell))


\* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*



\* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*
