/*
 *
 * Copyright 2019 gRPC authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

//go:generate ./regenerate.sh

package grpc_service_config_test

import (
	"testing"

	"github.com/golang/protobuf/jsonpb"
	wrapperspb "github.com/golang/protobuf/ptypes/wrappers"
	scpb "google.golang.org/grpc/internal/proto/grpc_service_config"
)

// TestXdsConfigMarshalToJSON is an example to print json format of xds_config.
func TestXdsConfigMarshalToJSON(t *testing.T) {
	c := &scpb.XdsConfig{
		ChildPolicy: []*scpb.LoadBalancingConfig{
			{Policy: &scpb.LoadBalancingConfig_Grpclb{
				Grpclb: &scpb.GrpcLbConfig{},
			}},
			{Policy: &scpb.LoadBalancingConfig_RoundRobin{
				RoundRobin: &scpb.RoundRobinConfig{},
			}},
		},
		FallbackPolicy: []*scpb.LoadBalancingConfig{
			{Policy: &scpb.LoadBalancingConfig_Grpclb{
				Grpclb: &scpb.GrpcLbConfig{},
			}},
			{Policy: &scpb.LoadBalancingConfig_PickFirst{
				PickFirst: &scpb.PickFirstConfig{},
			}},
		},
		EdsServiceName: "eds.service.name",
		LrsLoadReportingServerName: &wrapperspb.StringValue{
			Value: "lrs.server.name",
		},
	}
	j, err := (&jsonpb.Marshaler{}).MarshalToString(c)
	if err != nil {
		t.Fatalf("failed to marshal proto to json: %v", err)
	}
	t.Logf(j)
}
