// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.11.2
// source: google/cloud/datacatalog/v1/gcs_fileset_spec.proto

package datacatalog

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Describes a Cloud Storage fileset entry.
type GcsFilesetSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Patterns to identify a set of files in Google Cloud Storage. See [Cloud
	// Storage documentation](/storage/docs/gsutil/addlhelp/WildcardNames) for
	// more information. Note that bucket wildcards are currently not supported.
	//
	// Examples of valid file_patterns:
	//
	//  * `gs://bucket_name/dir/*`: matches all files within `bucket_name/dir`
	//                              directory.
	//  * `gs://bucket_name/dir/**`: matches all files in `bucket_name/dir`
	//                               spanning all subdirectories.
	//  * `gs://bucket_name/file*`: matches files prefixed by `file` in
	//                              `bucket_name`
	//  * `gs://bucket_name/??.txt`: matches files with two characters followed by
	//                               `.txt` in `bucket_name`
	//  * `gs://bucket_name/[aeiou].txt`: matches files that contain a single
	//                                    vowel character followed by `.txt` in
	//                                    `bucket_name`
	//  * `gs://bucket_name/[a-m].txt`: matches files that contain `a`, `b`, ...
	//                                  or `m` followed by `.txt` in `bucket_name`
	//  * `gs://bucket_name/a/*/b`: matches all files in `bucket_name` that match
	//                              `a/*/b` pattern, such as `a/c/b`, `a/d/b`
	//  * `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt`
	//
	// You can combine wildcards to provide more powerful matches, for example:
	//
	//  * `gs://bucket_name/[a-m]??.j*g`
	FilePatterns []string `protobuf:"bytes,1,rep,name=file_patterns,json=filePatterns,proto3" json:"file_patterns,omitempty"`
	// Output only. Sample files contained in this fileset, not all files
	// contained in this fileset are represented here.
	SampleGcsFileSpecs []*GcsFileSpec `protobuf:"bytes,2,rep,name=sample_gcs_file_specs,json=sampleGcsFileSpecs,proto3" json:"sample_gcs_file_specs,omitempty"`
}

func (x *GcsFilesetSpec) Reset() {
	*x = GcsFilesetSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_gcs_fileset_spec_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsFilesetSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsFilesetSpec) ProtoMessage() {}

func (x *GcsFilesetSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_gcs_fileset_spec_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsFilesetSpec.ProtoReflect.Descriptor instead.
func (*GcsFilesetSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_gcs_fileset_spec_proto_rawDescGZIP(), []int{0}
}

func (x *GcsFilesetSpec) GetFilePatterns() []string {
	if x != nil {
		return x.FilePatterns
	}
	return nil
}

func (x *GcsFilesetSpec) GetSampleGcsFileSpecs() []*GcsFileSpec {
	if x != nil {
		return x.SampleGcsFileSpecs
	}
	return nil
}

// Specifications of a single file in Cloud Storage.
type GcsFileSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The full file path. Example: `gs://bucket_name/a/b.txt`.
	FilePath string `protobuf:"bytes,1,opt,name=file_path,json=filePath,proto3" json:"file_path,omitempty"`
	// Output only. Timestamps about the Cloud Storage file.
	GcsTimestamps *SystemTimestamps `protobuf:"bytes,2,opt,name=gcs_timestamps,json=gcsTimestamps,proto3" json:"gcs_timestamps,omitempty"`
	// Output only. The size of the file, in bytes.
	SizeBytes int64 `protobuf:"varint,4,opt,name=size_bytes,json=sizeBytes,proto3" json:"size_bytes,omitempty"`
}

func (x *GcsFileSpec) Reset() {
	*x = GcsFileSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_gcs_fileset_spec_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsFileSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsFileSpec) ProtoMessage() {}

func (x *GcsFileSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_gcs_fileset_spec_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsFileSpec.ProtoReflect.Descriptor instead.
func (*GcsFileSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_gcs_fileset_spec_proto_rawDescGZIP(), []int{1}
}

func (x *GcsFileSpec) GetFilePath() string {
	if x != nil {
		return x.FilePath
	}
	return ""
}

func (x *GcsFileSpec) GetGcsTimestamps() *SystemTimestamps {
	if x != nil {
		return x.GcsTimestamps
	}
	return nil
}

func (x *GcsFileSpec) GetSizeBytes() int64 {
	if x != nil {
		return x.SizeBytes
	}
	return 0
}

var File_google_cloud_datacatalog_v1_gcs_fileset_spec_proto protoreflect.FileDescriptor

var file_google_cloud_datacatalog_v1_gcs_fileset_spec_proto_rawDesc = []byte{
	0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x67, 0x63,
	0x73, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x65, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76,
	0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x9c, 0x01, 0x0a, 0x0e, 0x47, 0x63, 0x73, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x65, 0x74, 0x53,
	0x70, 0x65, 0x63, 0x12, 0x28, 0x0a, 0x0d, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x74,
	0x65, 0x72, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0c, 0x66, 0x69, 0x6c, 0x65, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x73, 0x12, 0x60, 0x0a,
	0x15, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x67, 0x63, 0x73, 0x5f, 0x66, 0x69, 0x6c, 0x65,
	0x5f, 0x73, 0x70, 0x65, 0x63, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x63, 0x73, 0x46, 0x69,
	0x6c, 0x65, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x73, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x47, 0x63, 0x73, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x70, 0x65, 0x63, 0x73, 0x22,
	0xae, 0x01, 0x0a, 0x0b, 0x47, 0x63, 0x73, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12,
	0x20, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x50, 0x61, 0x74,
	0x68, 0x12, 0x59, 0x0a, 0x0e, 0x67, 0x63, 0x73, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x67,
	0x63, 0x73, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x73, 0x12, 0x22, 0x0a, 0x0a,
	0x73, 0x69, 0x7a, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x69, 0x7a, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73,
	0x42, 0xcb, 0x01, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x2e, 0x76, 0x31, 0x50, 0x01, 0x5a, 0x46, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f,
	0x76, 0x31, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0xf8, 0x01,
	0x01, 0xaa, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x56, 0x31, 0xca,
	0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44,
	0x61, 0x74, 0x61, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1e,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44,
	0x61, 0x74, 0x61, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_datacatalog_v1_gcs_fileset_spec_proto_rawDescOnce sync.Once
	file_google_cloud_datacatalog_v1_gcs_fileset_spec_proto_rawDescData = file_google_cloud_datacatalog_v1_gcs_fileset_spec_proto_rawDesc
)

func file_google_cloud_datacatalog_v1_gcs_fileset_spec_proto_rawDescGZIP() []byte {
	file_google_cloud_datacatalog_v1_gcs_fileset_spec_proto_rawDescOnce.Do(func() {
		file_google_cloud_datacatalog_v1_gcs_fileset_spec_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_datacatalog_v1_gcs_fileset_spec_proto_rawDescData)
	})
	return file_google_cloud_datacatalog_v1_gcs_fileset_spec_proto_rawDescData
}

var file_google_cloud_datacatalog_v1_gcs_fileset_spec_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_cloud_datacatalog_v1_gcs_fileset_spec_proto_goTypes = []interface{}{
	(*GcsFilesetSpec)(nil),   // 0: google.cloud.datacatalog.v1.GcsFilesetSpec
	(*GcsFileSpec)(nil),      // 1: google.cloud.datacatalog.v1.GcsFileSpec
	(*SystemTimestamps)(nil), // 2: google.cloud.datacatalog.v1.SystemTimestamps
}
var file_google_cloud_datacatalog_v1_gcs_fileset_spec_proto_depIdxs = []int32{
	1, // 0: google.cloud.datacatalog.v1.GcsFilesetSpec.sample_gcs_file_specs:type_name -> google.cloud.datacatalog.v1.GcsFileSpec
	2, // 1: google.cloud.datacatalog.v1.GcsFileSpec.gcs_timestamps:type_name -> google.cloud.datacatalog.v1.SystemTimestamps
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_google_cloud_datacatalog_v1_gcs_fileset_spec_proto_init() }
func file_google_cloud_datacatalog_v1_gcs_fileset_spec_proto_init() {
	if File_google_cloud_datacatalog_v1_gcs_fileset_spec_proto != nil {
		return
	}
	file_google_cloud_datacatalog_v1_timestamps_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_datacatalog_v1_gcs_fileset_spec_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcsFilesetSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_gcs_fileset_spec_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcsFileSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_datacatalog_v1_gcs_fileset_spec_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_datacatalog_v1_gcs_fileset_spec_proto_goTypes,
		DependencyIndexes: file_google_cloud_datacatalog_v1_gcs_fileset_spec_proto_depIdxs,
		MessageInfos:      file_google_cloud_datacatalog_v1_gcs_fileset_spec_proto_msgTypes,
	}.Build()
	File_google_cloud_datacatalog_v1_gcs_fileset_spec_proto = out.File
	file_google_cloud_datacatalog_v1_gcs_fileset_spec_proto_rawDesc = nil
	file_google_cloud_datacatalog_v1_gcs_fileset_spec_proto_goTypes = nil
	file_google_cloud_datacatalog_v1_gcs_fileset_spec_proto_depIdxs = nil
}
