// Copyright 2017 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// THIS FILE IS AUTOMATICALLY GENERATED.

package discovery_v1

import (
	"fmt"
	"github.com/googleapis/gnostic/compiler"
	"gopkg.in/yaml.v2"
	"regexp"
	"strings"
)

// Version returns the package name (and OpenAPI version).
func Version() string {
	return "discovery_v1"
}

// NewAnnotations creates an object of type Annotations if possible, returning an error if not.
func NewAnnotations(in interface{}, context *compiler.Context) (*Annotations, error) {
	errors := make([]error, 0)
	x := &Annotations{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"required"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// repeated string required = 1;
		v1 := compiler.MapValueForKey(m, "required")
		if v1 != nil {
			v, ok := v1.([]interface{})
			if ok {
				x.Required = compiler.ConvertInterfaceArrayToStringArray(v)
			} else {
				message := fmt.Sprintf("has unexpected value for required: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewAny creates an object of type Any if possible, returning an error if not.
func NewAny(in interface{}, context *compiler.Context) (*Any, error) {
	errors := make([]error, 0)
	x := &Any{}
	bytes, _ := yaml.Marshal(in)
	x.Yaml = string(bytes)
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewAuth creates an object of type Auth if possible, returning an error if not.
func NewAuth(in interface{}, context *compiler.Context) (*Auth, error) {
	errors := make([]error, 0)
	x := &Auth{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"oauth2"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// Oauth2 oauth2 = 1;
		v1 := compiler.MapValueForKey(m, "oauth2")
		if v1 != nil {
			var err error
			x.Oauth2, err = NewOauth2(v1, compiler.NewContext("oauth2", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewDocument creates an object of type Document if possible, returning an error if not.
func NewDocument(in interface{}, context *compiler.Context) (*Document, error) {
	errors := make([]error, 0)
	x := &Document{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"discoveryVersion", "kind"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"auth", "basePath", "baseUrl", "batchPath", "canonicalName", "description", "discoveryVersion", "documentationLink", "etag", "features", "fullyEncodeReservedExpansion", "icons", "id", "kind", "labels", "methods", "name", "ownerDomain", "ownerName", "packagePath", "parameters", "protocol", "resources", "revision", "rootUrl", "schemas", "servicePath", "title", "version", "version_module"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string kind = 1;
		v1 := compiler.MapValueForKey(m, "kind")
		if v1 != nil {
			x.Kind, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for kind: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string discovery_version = 2;
		v2 := compiler.MapValueForKey(m, "discoveryVersion")
		if v2 != nil {
			x.DiscoveryVersion, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for discoveryVersion: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string id = 3;
		v3 := compiler.MapValueForKey(m, "id")
		if v3 != nil {
			x.Id, ok = v3.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for id: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string name = 4;
		v4 := compiler.MapValueForKey(m, "name")
		if v4 != nil {
			x.Name, ok = v4.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v4, v4)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string version = 5;
		v5 := compiler.MapValueForKey(m, "version")
		if v5 != nil {
			x.Version, ok = v5.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for version: %+v (%T)", v5, v5)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string revision = 6;
		v6 := compiler.MapValueForKey(m, "revision")
		if v6 != nil {
			x.Revision, ok = v6.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for revision: %+v (%T)", v6, v6)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string title = 7;
		v7 := compiler.MapValueForKey(m, "title")
		if v7 != nil {
			x.Title, ok = v7.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for title: %+v (%T)", v7, v7)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 8;
		v8 := compiler.MapValueForKey(m, "description")
		if v8 != nil {
			x.Description, ok = v8.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v8, v8)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Icons icons = 9;
		v9 := compiler.MapValueForKey(m, "icons")
		if v9 != nil {
			var err error
			x.Icons, err = NewIcons(v9, compiler.NewContext("icons", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// string documentation_link = 10;
		v10 := compiler.MapValueForKey(m, "documentationLink")
		if v10 != nil {
			x.DocumentationLink, ok = v10.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for documentationLink: %+v (%T)", v10, v10)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated string labels = 11;
		v11 := compiler.MapValueForKey(m, "labels")
		if v11 != nil {
			v, ok := v11.([]interface{})
			if ok {
				x.Labels = compiler.ConvertInterfaceArrayToStringArray(v)
			} else {
				message := fmt.Sprintf("has unexpected value for labels: %+v (%T)", v11, v11)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string protocol = 12;
		v12 := compiler.MapValueForKey(m, "protocol")
		if v12 != nil {
			x.Protocol, ok = v12.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for protocol: %+v (%T)", v12, v12)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string base_url = 13;
		v13 := compiler.MapValueForKey(m, "baseUrl")
		if v13 != nil {
			x.BaseUrl, ok = v13.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for baseUrl: %+v (%T)", v13, v13)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string base_path = 14;
		v14 := compiler.MapValueForKey(m, "basePath")
		if v14 != nil {
			x.BasePath, ok = v14.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for basePath: %+v (%T)", v14, v14)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string root_url = 15;
		v15 := compiler.MapValueForKey(m, "rootUrl")
		if v15 != nil {
			x.RootUrl, ok = v15.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for rootUrl: %+v (%T)", v15, v15)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string service_path = 16;
		v16 := compiler.MapValueForKey(m, "servicePath")
		if v16 != nil {
			x.ServicePath, ok = v16.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for servicePath: %+v (%T)", v16, v16)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string batch_path = 17;
		v17 := compiler.MapValueForKey(m, "batchPath")
		if v17 != nil {
			x.BatchPath, ok = v17.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for batchPath: %+v (%T)", v17, v17)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Parameters parameters = 18;
		v18 := compiler.MapValueForKey(m, "parameters")
		if v18 != nil {
			var err error
			x.Parameters, err = NewParameters(v18, compiler.NewContext("parameters", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Auth auth = 19;
		v19 := compiler.MapValueForKey(m, "auth")
		if v19 != nil {
			var err error
			x.Auth, err = NewAuth(v19, compiler.NewContext("auth", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated string features = 20;
		v20 := compiler.MapValueForKey(m, "features")
		if v20 != nil {
			v, ok := v20.([]interface{})
			if ok {
				x.Features = compiler.ConvertInterfaceArrayToStringArray(v)
			} else {
				message := fmt.Sprintf("has unexpected value for features: %+v (%T)", v20, v20)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Schemas schemas = 21;
		v21 := compiler.MapValueForKey(m, "schemas")
		if v21 != nil {
			var err error
			x.Schemas, err = NewSchemas(v21, compiler.NewContext("schemas", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Methods methods = 22;
		v22 := compiler.MapValueForKey(m, "methods")
		if v22 != nil {
			var err error
			x.Methods, err = NewMethods(v22, compiler.NewContext("methods", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Resources resources = 23;
		v23 := compiler.MapValueForKey(m, "resources")
		if v23 != nil {
			var err error
			x.Resources, err = NewResources(v23, compiler.NewContext("resources", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// string etag = 24;
		v24 := compiler.MapValueForKey(m, "etag")
		if v24 != nil {
			x.Etag, ok = v24.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for etag: %+v (%T)", v24, v24)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string owner_domain = 25;
		v25 := compiler.MapValueForKey(m, "ownerDomain")
		if v25 != nil {
			x.OwnerDomain, ok = v25.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for ownerDomain: %+v (%T)", v25, v25)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string owner_name = 26;
		v26 := compiler.MapValueForKey(m, "ownerName")
		if v26 != nil {
			x.OwnerName, ok = v26.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for ownerName: %+v (%T)", v26, v26)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool version_module = 27;
		v27 := compiler.MapValueForKey(m, "version_module")
		if v27 != nil {
			x.VersionModule, ok = v27.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for version_module: %+v (%T)", v27, v27)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string canonical_name = 28;
		v28 := compiler.MapValueForKey(m, "canonicalName")
		if v28 != nil {
			x.CanonicalName, ok = v28.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for canonicalName: %+v (%T)", v28, v28)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool fully_encode_reserved_expansion = 29;
		v29 := compiler.MapValueForKey(m, "fullyEncodeReservedExpansion")
		if v29 != nil {
			x.FullyEncodeReservedExpansion, ok = v29.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for fullyEncodeReservedExpansion: %+v (%T)", v29, v29)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string package_path = 30;
		v30 := compiler.MapValueForKey(m, "packagePath")
		if v30 != nil {
			x.PackagePath, ok = v30.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for packagePath: %+v (%T)", v30, v30)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewIcons creates an object of type Icons if possible, returning an error if not.
func NewIcons(in interface{}, context *compiler.Context) (*Icons, error) {
	errors := make([]error, 0)
	x := &Icons{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		requiredKeys := []string{"x16", "x32"}
		missingKeys := compiler.MissingKeysInMap(m, requiredKeys)
		if len(missingKeys) > 0 {
			message := fmt.Sprintf("is missing required %s: %+v", compiler.PluralProperties(len(missingKeys)), strings.Join(missingKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		allowedKeys := []string{"x16", "x32"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string x16 = 1;
		v1 := compiler.MapValueForKey(m, "x16")
		if v1 != nil {
			x.X16, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for x16: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string x32 = 2;
		v2 := compiler.MapValueForKey(m, "x32")
		if v2 != nil {
			x.X32, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for x32: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewMediaUpload creates an object of type MediaUpload if possible, returning an error if not.
func NewMediaUpload(in interface{}, context *compiler.Context) (*MediaUpload, error) {
	errors := make([]error, 0)
	x := &MediaUpload{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"accept", "maxSize", "protocols", "supportsSubscription"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// repeated string accept = 1;
		v1 := compiler.MapValueForKey(m, "accept")
		if v1 != nil {
			v, ok := v1.([]interface{})
			if ok {
				x.Accept = compiler.ConvertInterfaceArrayToStringArray(v)
			} else {
				message := fmt.Sprintf("has unexpected value for accept: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string max_size = 2;
		v2 := compiler.MapValueForKey(m, "maxSize")
		if v2 != nil {
			x.MaxSize, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for maxSize: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Protocols protocols = 3;
		v3 := compiler.MapValueForKey(m, "protocols")
		if v3 != nil {
			var err error
			x.Protocols, err = NewProtocols(v3, compiler.NewContext("protocols", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// bool supports_subscription = 4;
		v4 := compiler.MapValueForKey(m, "supportsSubscription")
		if v4 != nil {
			x.SupportsSubscription, ok = v4.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for supportsSubscription: %+v (%T)", v4, v4)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewMethod creates an object of type Method if possible, returning an error if not.
func NewMethod(in interface{}, context *compiler.Context) (*Method, error) {
	errors := make([]error, 0)
	x := &Method{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"description", "etagRequired", "flatPath", "httpMethod", "id", "mediaUpload", "parameterOrder", "parameters", "path", "request", "response", "scopes", "supportsMediaDownload", "supportsMediaUpload", "supportsSubscription", "useMediaDownloadService"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string id = 1;
		v1 := compiler.MapValueForKey(m, "id")
		if v1 != nil {
			x.Id, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for id: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string path = 2;
		v2 := compiler.MapValueForKey(m, "path")
		if v2 != nil {
			x.Path, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for path: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string http_method = 3;
		v3 := compiler.MapValueForKey(m, "httpMethod")
		if v3 != nil {
			x.HttpMethod, ok = v3.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for httpMethod: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 4;
		v4 := compiler.MapValueForKey(m, "description")
		if v4 != nil {
			x.Description, ok = v4.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v4, v4)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Parameters parameters = 5;
		v5 := compiler.MapValueForKey(m, "parameters")
		if v5 != nil {
			var err error
			x.Parameters, err = NewParameters(v5, compiler.NewContext("parameters", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated string parameter_order = 6;
		v6 := compiler.MapValueForKey(m, "parameterOrder")
		if v6 != nil {
			v, ok := v6.([]interface{})
			if ok {
				x.ParameterOrder = compiler.ConvertInterfaceArrayToStringArray(v)
			} else {
				message := fmt.Sprintf("has unexpected value for parameterOrder: %+v (%T)", v6, v6)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Request request = 7;
		v7 := compiler.MapValueForKey(m, "request")
		if v7 != nil {
			var err error
			x.Request, err = NewRequest(v7, compiler.NewContext("request", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Response response = 8;
		v8 := compiler.MapValueForKey(m, "response")
		if v8 != nil {
			var err error
			x.Response, err = NewResponse(v8, compiler.NewContext("response", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// repeated string scopes = 9;
		v9 := compiler.MapValueForKey(m, "scopes")
		if v9 != nil {
			v, ok := v9.([]interface{})
			if ok {
				x.Scopes = compiler.ConvertInterfaceArrayToStringArray(v)
			} else {
				message := fmt.Sprintf("has unexpected value for scopes: %+v (%T)", v9, v9)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool supports_media_download = 10;
		v10 := compiler.MapValueForKey(m, "supportsMediaDownload")
		if v10 != nil {
			x.SupportsMediaDownload, ok = v10.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for supportsMediaDownload: %+v (%T)", v10, v10)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool supports_media_upload = 11;
		v11 := compiler.MapValueForKey(m, "supportsMediaUpload")
		if v11 != nil {
			x.SupportsMediaUpload, ok = v11.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for supportsMediaUpload: %+v (%T)", v11, v11)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool use_media_download_service = 12;
		v12 := compiler.MapValueForKey(m, "useMediaDownloadService")
		if v12 != nil {
			x.UseMediaDownloadService, ok = v12.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for useMediaDownloadService: %+v (%T)", v12, v12)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// MediaUpload media_upload = 13;
		v13 := compiler.MapValueForKey(m, "mediaUpload")
		if v13 != nil {
			var err error
			x.MediaUpload, err = NewMediaUpload(v13, compiler.NewContext("mediaUpload", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// bool supports_subscription = 14;
		v14 := compiler.MapValueForKey(m, "supportsSubscription")
		if v14 != nil {
			x.SupportsSubscription, ok = v14.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for supportsSubscription: %+v (%T)", v14, v14)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string flat_path = 15;
		v15 := compiler.MapValueForKey(m, "flatPath")
		if v15 != nil {
			x.FlatPath, ok = v15.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for flatPath: %+v (%T)", v15, v15)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool etag_required = 16;
		v16 := compiler.MapValueForKey(m, "etagRequired")
		if v16 != nil {
			x.EtagRequired, ok = v16.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for etagRequired: %+v (%T)", v16, v16)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewMethods creates an object of type Methods if possible, returning an error if not.
func NewMethods(in interface{}, context *compiler.Context) (*Methods, error) {
	errors := make([]error, 0)
	x := &Methods{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedMethod additional_properties = 1;
		// MAP: Method
		x.AdditionalProperties = make([]*NamedMethod, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedMethod{}
				pair.Name = k
				var err error
				pair.Value, err = NewMethod(v, compiler.NewContext(k, context))
				if err != nil {
					errors = append(errors, err)
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedMethod creates an object of type NamedMethod if possible, returning an error if not.
func NewNamedMethod(in interface{}, context *compiler.Context) (*NamedMethod, error) {
	errors := make([]error, 0)
	x := &NamedMethod{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Method value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewMethod(v2, compiler.NewContext("value", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedParameter creates an object of type NamedParameter if possible, returning an error if not.
func NewNamedParameter(in interface{}, context *compiler.Context) (*NamedParameter, error) {
	errors := make([]error, 0)
	x := &NamedParameter{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Parameter value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewParameter(v2, compiler.NewContext("value", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedResource creates an object of type NamedResource if possible, returning an error if not.
func NewNamedResource(in interface{}, context *compiler.Context) (*NamedResource, error) {
	errors := make([]error, 0)
	x := &NamedResource{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Resource value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewResource(v2, compiler.NewContext("value", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedSchema creates an object of type NamedSchema if possible, returning an error if not.
func NewNamedSchema(in interface{}, context *compiler.Context) (*NamedSchema, error) {
	errors := make([]error, 0)
	x := &NamedSchema{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Schema value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewSchema(v2, compiler.NewContext("value", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewNamedScope creates an object of type NamedScope if possible, returning an error if not.
func NewNamedScope(in interface{}, context *compiler.Context) (*NamedScope, error) {
	errors := make([]error, 0)
	x := &NamedScope{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"name", "value"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string name = 1;
		v1 := compiler.MapValueForKey(m, "name")
		if v1 != nil {
			x.Name, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for name: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Scope value = 2;
		v2 := compiler.MapValueForKey(m, "value")
		if v2 != nil {
			var err error
			x.Value, err = NewScope(v2, compiler.NewContext("value", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewOauth2 creates an object of type Oauth2 if possible, returning an error if not.
func NewOauth2(in interface{}, context *compiler.Context) (*Oauth2, error) {
	errors := make([]error, 0)
	x := &Oauth2{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"scopes"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// Scopes scopes = 1;
		v1 := compiler.MapValueForKey(m, "scopes")
		if v1 != nil {
			var err error
			x.Scopes, err = NewScopes(v1, compiler.NewContext("scopes", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewParameter creates an object of type Parameter if possible, returning an error if not.
func NewParameter(in interface{}, context *compiler.Context) (*Parameter, error) {
	errors := make([]error, 0)
	x := &Parameter{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"$ref", "additionalProperties", "annotations", "default", "description", "enum", "enumDescriptions", "format", "id", "items", "location", "maximum", "minimum", "pattern", "properties", "repeated", "required", "type"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string id = 1;
		v1 := compiler.MapValueForKey(m, "id")
		if v1 != nil {
			x.Id, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for id: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string type = 2;
		v2 := compiler.MapValueForKey(m, "type")
		if v2 != nil {
			x.Type, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for type: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string _ref = 3;
		v3 := compiler.MapValueForKey(m, "$ref")
		if v3 != nil {
			x.XRef, ok = v3.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for $ref: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 4;
		v4 := compiler.MapValueForKey(m, "description")
		if v4 != nil {
			x.Description, ok = v4.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v4, v4)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string default = 5;
		v5 := compiler.MapValueForKey(m, "default")
		if v5 != nil {
			x.Default, ok = v5.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for default: %+v (%T)", v5, v5)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool required = 6;
		v6 := compiler.MapValueForKey(m, "required")
		if v6 != nil {
			x.Required, ok = v6.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for required: %+v (%T)", v6, v6)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string format = 7;
		v7 := compiler.MapValueForKey(m, "format")
		if v7 != nil {
			x.Format, ok = v7.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for format: %+v (%T)", v7, v7)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string pattern = 8;
		v8 := compiler.MapValueForKey(m, "pattern")
		if v8 != nil {
			x.Pattern, ok = v8.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for pattern: %+v (%T)", v8, v8)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string minimum = 9;
		v9 := compiler.MapValueForKey(m, "minimum")
		if v9 != nil {
			x.Minimum, ok = v9.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for minimum: %+v (%T)", v9, v9)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string maximum = 10;
		v10 := compiler.MapValueForKey(m, "maximum")
		if v10 != nil {
			x.Maximum, ok = v10.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for maximum: %+v (%T)", v10, v10)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated string enum = 11;
		v11 := compiler.MapValueForKey(m, "enum")
		if v11 != nil {
			v, ok := v11.([]interface{})
			if ok {
				x.Enum = compiler.ConvertInterfaceArrayToStringArray(v)
			} else {
				message := fmt.Sprintf("has unexpected value for enum: %+v (%T)", v11, v11)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated string enum_descriptions = 12;
		v12 := compiler.MapValueForKey(m, "enumDescriptions")
		if v12 != nil {
			v, ok := v12.([]interface{})
			if ok {
				x.EnumDescriptions = compiler.ConvertInterfaceArrayToStringArray(v)
			} else {
				message := fmt.Sprintf("has unexpected value for enumDescriptions: %+v (%T)", v12, v12)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool repeated = 13;
		v13 := compiler.MapValueForKey(m, "repeated")
		if v13 != nil {
			x.Repeated, ok = v13.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for repeated: %+v (%T)", v13, v13)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string location = 14;
		v14 := compiler.MapValueForKey(m, "location")
		if v14 != nil {
			x.Location, ok = v14.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for location: %+v (%T)", v14, v14)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Schemas properties = 15;
		v15 := compiler.MapValueForKey(m, "properties")
		if v15 != nil {
			var err error
			x.Properties, err = NewSchemas(v15, compiler.NewContext("properties", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Schema additional_properties = 16;
		v16 := compiler.MapValueForKey(m, "additionalProperties")
		if v16 != nil {
			var err error
			x.AdditionalProperties, err = NewSchema(v16, compiler.NewContext("additionalProperties", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Schema items = 17;
		v17 := compiler.MapValueForKey(m, "items")
		if v17 != nil {
			var err error
			x.Items, err = NewSchema(v17, compiler.NewContext("items", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Annotations annotations = 18;
		v18 := compiler.MapValueForKey(m, "annotations")
		if v18 != nil {
			var err error
			x.Annotations, err = NewAnnotations(v18, compiler.NewContext("annotations", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewParameters creates an object of type Parameters if possible, returning an error if not.
func NewParameters(in interface{}, context *compiler.Context) (*Parameters, error) {
	errors := make([]error, 0)
	x := &Parameters{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedParameter additional_properties = 1;
		// MAP: Parameter
		x.AdditionalProperties = make([]*NamedParameter, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedParameter{}
				pair.Name = k
				var err error
				pair.Value, err = NewParameter(v, compiler.NewContext(k, context))
				if err != nil {
					errors = append(errors, err)
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewProtocols creates an object of type Protocols if possible, returning an error if not.
func NewProtocols(in interface{}, context *compiler.Context) (*Protocols, error) {
	errors := make([]error, 0)
	x := &Protocols{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"resumable", "simple"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// Simple simple = 1;
		v1 := compiler.MapValueForKey(m, "simple")
		if v1 != nil {
			var err error
			x.Simple, err = NewSimple(v1, compiler.NewContext("simple", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Resumable resumable = 2;
		v2 := compiler.MapValueForKey(m, "resumable")
		if v2 != nil {
			var err error
			x.Resumable, err = NewResumable(v2, compiler.NewContext("resumable", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewRequest creates an object of type Request if possible, returning an error if not.
func NewRequest(in interface{}, context *compiler.Context) (*Request, error) {
	errors := make([]error, 0)
	x := &Request{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"$ref", "parameterName"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string _ref = 1;
		v1 := compiler.MapValueForKey(m, "$ref")
		if v1 != nil {
			x.XRef, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for $ref: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string parameter_name = 2;
		v2 := compiler.MapValueForKey(m, "parameterName")
		if v2 != nil {
			x.ParameterName, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for parameterName: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewResource creates an object of type Resource if possible, returning an error if not.
func NewResource(in interface{}, context *compiler.Context) (*Resource, error) {
	errors := make([]error, 0)
	x := &Resource{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"methods", "resources"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// Methods methods = 1;
		v1 := compiler.MapValueForKey(m, "methods")
		if v1 != nil {
			var err error
			x.Methods, err = NewMethods(v1, compiler.NewContext("methods", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Resources resources = 2;
		v2 := compiler.MapValueForKey(m, "resources")
		if v2 != nil {
			var err error
			x.Resources, err = NewResources(v2, compiler.NewContext("resources", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewResources creates an object of type Resources if possible, returning an error if not.
func NewResources(in interface{}, context *compiler.Context) (*Resources, error) {
	errors := make([]error, 0)
	x := &Resources{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedResource additional_properties = 1;
		// MAP: Resource
		x.AdditionalProperties = make([]*NamedResource, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedResource{}
				pair.Name = k
				var err error
				pair.Value, err = NewResource(v, compiler.NewContext(k, context))
				if err != nil {
					errors = append(errors, err)
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewResponse creates an object of type Response if possible, returning an error if not.
func NewResponse(in interface{}, context *compiler.Context) (*Response, error) {
	errors := make([]error, 0)
	x := &Response{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"$ref"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string _ref = 1;
		v1 := compiler.MapValueForKey(m, "$ref")
		if v1 != nil {
			x.XRef, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for $ref: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewResumable creates an object of type Resumable if possible, returning an error if not.
func NewResumable(in interface{}, context *compiler.Context) (*Resumable, error) {
	errors := make([]error, 0)
	x := &Resumable{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"multipart", "path"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// bool multipart = 1;
		v1 := compiler.MapValueForKey(m, "multipart")
		if v1 != nil {
			x.Multipart, ok = v1.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for multipart: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string path = 2;
		v2 := compiler.MapValueForKey(m, "path")
		if v2 != nil {
			x.Path, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for path: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewSchema creates an object of type Schema if possible, returning an error if not.
func NewSchema(in interface{}, context *compiler.Context) (*Schema, error) {
	errors := make([]error, 0)
	x := &Schema{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"$ref", "additionalProperties", "annotations", "default", "description", "enum", "enumDescriptions", "format", "id", "items", "location", "maximum", "minimum", "pattern", "properties", "readOnly", "repeated", "required", "type"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string id = 1;
		v1 := compiler.MapValueForKey(m, "id")
		if v1 != nil {
			x.Id, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for id: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string type = 2;
		v2 := compiler.MapValueForKey(m, "type")
		if v2 != nil {
			x.Type, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for type: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string description = 3;
		v3 := compiler.MapValueForKey(m, "description")
		if v3 != nil {
			x.Description, ok = v3.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v3, v3)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string default = 4;
		v4 := compiler.MapValueForKey(m, "default")
		if v4 != nil {
			x.Default, ok = v4.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for default: %+v (%T)", v4, v4)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool required = 5;
		v5 := compiler.MapValueForKey(m, "required")
		if v5 != nil {
			x.Required, ok = v5.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for required: %+v (%T)", v5, v5)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string format = 6;
		v6 := compiler.MapValueForKey(m, "format")
		if v6 != nil {
			x.Format, ok = v6.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for format: %+v (%T)", v6, v6)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string pattern = 7;
		v7 := compiler.MapValueForKey(m, "pattern")
		if v7 != nil {
			x.Pattern, ok = v7.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for pattern: %+v (%T)", v7, v7)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string minimum = 8;
		v8 := compiler.MapValueForKey(m, "minimum")
		if v8 != nil {
			x.Minimum, ok = v8.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for minimum: %+v (%T)", v8, v8)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string maximum = 9;
		v9 := compiler.MapValueForKey(m, "maximum")
		if v9 != nil {
			x.Maximum, ok = v9.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for maximum: %+v (%T)", v9, v9)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated string enum = 10;
		v10 := compiler.MapValueForKey(m, "enum")
		if v10 != nil {
			v, ok := v10.([]interface{})
			if ok {
				x.Enum = compiler.ConvertInterfaceArrayToStringArray(v)
			} else {
				message := fmt.Sprintf("has unexpected value for enum: %+v (%T)", v10, v10)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// repeated string enum_descriptions = 11;
		v11 := compiler.MapValueForKey(m, "enumDescriptions")
		if v11 != nil {
			v, ok := v11.([]interface{})
			if ok {
				x.EnumDescriptions = compiler.ConvertInterfaceArrayToStringArray(v)
			} else {
				message := fmt.Sprintf("has unexpected value for enumDescriptions: %+v (%T)", v11, v11)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// bool repeated = 12;
		v12 := compiler.MapValueForKey(m, "repeated")
		if v12 != nil {
			x.Repeated, ok = v12.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for repeated: %+v (%T)", v12, v12)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string location = 13;
		v13 := compiler.MapValueForKey(m, "location")
		if v13 != nil {
			x.Location, ok = v13.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for location: %+v (%T)", v13, v13)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Schemas properties = 14;
		v14 := compiler.MapValueForKey(m, "properties")
		if v14 != nil {
			var err error
			x.Properties, err = NewSchemas(v14, compiler.NewContext("properties", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Schema additional_properties = 15;
		v15 := compiler.MapValueForKey(m, "additionalProperties")
		if v15 != nil {
			var err error
			x.AdditionalProperties, err = NewSchema(v15, compiler.NewContext("additionalProperties", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// Schema items = 16;
		v16 := compiler.MapValueForKey(m, "items")
		if v16 != nil {
			var err error
			x.Items, err = NewSchema(v16, compiler.NewContext("items", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// string _ref = 17;
		v17 := compiler.MapValueForKey(m, "$ref")
		if v17 != nil {
			x.XRef, ok = v17.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for $ref: %+v (%T)", v17, v17)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// Annotations annotations = 18;
		v18 := compiler.MapValueForKey(m, "annotations")
		if v18 != nil {
			var err error
			x.Annotations, err = NewAnnotations(v18, compiler.NewContext("annotations", context))
			if err != nil {
				errors = append(errors, err)
			}
		}
		// bool read_only = 19;
		v19 := compiler.MapValueForKey(m, "readOnly")
		if v19 != nil {
			x.ReadOnly, ok = v19.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for readOnly: %+v (%T)", v19, v19)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewSchemas creates an object of type Schemas if possible, returning an error if not.
func NewSchemas(in interface{}, context *compiler.Context) (*Schemas, error) {
	errors := make([]error, 0)
	x := &Schemas{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedSchema additional_properties = 1;
		// MAP: Schema
		x.AdditionalProperties = make([]*NamedSchema, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedSchema{}
				pair.Name = k
				var err error
				pair.Value, err = NewSchema(v, compiler.NewContext(k, context))
				if err != nil {
					errors = append(errors, err)
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewScope creates an object of type Scope if possible, returning an error if not.
func NewScope(in interface{}, context *compiler.Context) (*Scope, error) {
	errors := make([]error, 0)
	x := &Scope{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"description"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// string description = 1;
		v1 := compiler.MapValueForKey(m, "description")
		if v1 != nil {
			x.Description, ok = v1.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for description: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewScopes creates an object of type Scopes if possible, returning an error if not.
func NewScopes(in interface{}, context *compiler.Context) (*Scopes, error) {
	errors := make([]error, 0)
	x := &Scopes{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		// repeated NamedScope additional_properties = 1;
		// MAP: Scope
		x.AdditionalProperties = make([]*NamedScope, 0)
		for _, item := range m {
			k, ok := compiler.StringValue(item.Key)
			if ok {
				v := item.Value
				pair := &NamedScope{}
				pair.Name = k
				var err error
				pair.Value, err = NewScope(v, compiler.NewContext(k, context))
				if err != nil {
					errors = append(errors, err)
				}
				x.AdditionalProperties = append(x.AdditionalProperties, pair)
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewSimple creates an object of type Simple if possible, returning an error if not.
func NewSimple(in interface{}, context *compiler.Context) (*Simple, error) {
	errors := make([]error, 0)
	x := &Simple{}
	m, ok := compiler.UnpackMap(in)
	if !ok {
		message := fmt.Sprintf("has unexpected value: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		allowedKeys := []string{"multipart", "path"}
		var allowedPatterns []*regexp.Regexp
		invalidKeys := compiler.InvalidKeysInMap(m, allowedKeys, allowedPatterns)
		if len(invalidKeys) > 0 {
			message := fmt.Sprintf("has invalid %s: %+v", compiler.PluralProperties(len(invalidKeys)), strings.Join(invalidKeys, ", "))
			errors = append(errors, compiler.NewError(context, message))
		}
		// bool multipart = 1;
		v1 := compiler.MapValueForKey(m, "multipart")
		if v1 != nil {
			x.Multipart, ok = v1.(bool)
			if !ok {
				message := fmt.Sprintf("has unexpected value for multipart: %+v (%T)", v1, v1)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
		// string path = 2;
		v2 := compiler.MapValueForKey(m, "path")
		if v2 != nil {
			x.Path, ok = v2.(string)
			if !ok {
				message := fmt.Sprintf("has unexpected value for path: %+v (%T)", v2, v2)
				errors = append(errors, compiler.NewError(context, message))
			}
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// NewStringArray creates an object of type StringArray if possible, returning an error if not.
func NewStringArray(in interface{}, context *compiler.Context) (*StringArray, error) {
	errors := make([]error, 0)
	x := &StringArray{}
	a, ok := in.([]interface{})
	if !ok {
		message := fmt.Sprintf("has unexpected value for StringArray: %+v (%T)", in, in)
		errors = append(errors, compiler.NewError(context, message))
	} else {
		x.Value = make([]string, 0)
		for _, s := range a {
			x.Value = append(x.Value, s.(string))
		}
	}
	return x, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Annotations objects.
func (m *Annotations) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Any objects.
func (m *Any) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Auth objects.
func (m *Auth) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Oauth2 != nil {
		_, err := m.Oauth2.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Document objects.
func (m *Document) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Icons != nil {
		_, err := m.Icons.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Parameters != nil {
		_, err := m.Parameters.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Auth != nil {
		_, err := m.Auth.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Schemas != nil {
		_, err := m.Schemas.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Methods != nil {
		_, err := m.Methods.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Resources != nil {
		_, err := m.Resources.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Icons objects.
func (m *Icons) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside MediaUpload objects.
func (m *MediaUpload) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Protocols != nil {
		_, err := m.Protocols.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Method objects.
func (m *Method) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Parameters != nil {
		_, err := m.Parameters.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Request != nil {
		_, err := m.Request.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Response != nil {
		_, err := m.Response.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.MediaUpload != nil {
		_, err := m.MediaUpload.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Methods objects.
func (m *Methods) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedMethod objects.
func (m *NamedMethod) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedParameter objects.
func (m *NamedParameter) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedResource objects.
func (m *NamedResource) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedSchema objects.
func (m *NamedSchema) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside NamedScope objects.
func (m *NamedScope) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Value != nil {
		_, err := m.Value.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Oauth2 objects.
func (m *Oauth2) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Scopes != nil {
		_, err := m.Scopes.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Parameter objects.
func (m *Parameter) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.XRef != "" {
		info, err := compiler.ReadInfoForRef(root, m.XRef)
		if err != nil {
			return nil, err
		}
		if info != nil {
			replacement, err := NewParameter(info, nil)
			if err == nil {
				*m = *replacement
				return m.ResolveReferences(root)
			}
		}
		return info, nil
	}
	if m.Properties != nil {
		_, err := m.Properties.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.AdditionalProperties != nil {
		_, err := m.AdditionalProperties.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Items != nil {
		_, err := m.Items.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Annotations != nil {
		_, err := m.Annotations.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Parameters objects.
func (m *Parameters) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Protocols objects.
func (m *Protocols) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Simple != nil {
		_, err := m.Simple.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Resumable != nil {
		_, err := m.Resumable.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Request objects.
func (m *Request) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.XRef != "" {
		info, err := compiler.ReadInfoForRef(root, m.XRef)
		if err != nil {
			return nil, err
		}
		if info != nil {
			replacement, err := NewRequest(info, nil)
			if err == nil {
				*m = *replacement
				return m.ResolveReferences(root)
			}
		}
		return info, nil
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Resource objects.
func (m *Resource) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Methods != nil {
		_, err := m.Methods.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Resources != nil {
		_, err := m.Resources.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Resources objects.
func (m *Resources) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Response objects.
func (m *Response) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.XRef != "" {
		info, err := compiler.ReadInfoForRef(root, m.XRef)
		if err != nil {
			return nil, err
		}
		return info, nil
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Resumable objects.
func (m *Resumable) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Schema objects.
func (m *Schema) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	if m.Properties != nil {
		_, err := m.Properties.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.AdditionalProperties != nil {
		_, err := m.AdditionalProperties.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.Items != nil {
		_, err := m.Items.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	if m.XRef != "" {
		info, err := compiler.ReadInfoForRef(root, m.XRef)
		if err != nil {
			return nil, err
		}
		if info != nil {
			replacement, err := NewSchema(info, nil)
			if err == nil {
				*m = *replacement
				return m.ResolveReferences(root)
			}
		}
		return info, nil
	}
	if m.Annotations != nil {
		_, err := m.Annotations.ResolveReferences(root)
		if err != nil {
			errors = append(errors, err)
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Schemas objects.
func (m *Schemas) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Scope objects.
func (m *Scope) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Scopes objects.
func (m *Scopes) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	for _, item := range m.AdditionalProperties {
		if item != nil {
			_, err := item.ResolveReferences(root)
			if err != nil {
				errors = append(errors, err)
			}
		}
	}
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside Simple objects.
func (m *Simple) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ResolveReferences resolves references found inside StringArray objects.
func (m *StringArray) ResolveReferences(root string) (interface{}, error) {
	errors := make([]error, 0)
	return nil, compiler.NewErrorGroupOrNil(errors)
}

// ToRawInfo returns a description of Annotations suitable for JSON or YAML export.
func (m *Annotations) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if len(m.Required) != 0 {
		info = append(info, yaml.MapItem{"required", m.Required})
	}
	return info
}

// ToRawInfo returns a description of Any suitable for JSON or YAML export.
func (m *Any) ToRawInfo() interface{} {
	var err error
	var info1 []yaml.MapSlice
	err = yaml.Unmarshal([]byte(m.Yaml), &info1)
	if err == nil {
		return info1
	}
	var info2 yaml.MapSlice
	err = yaml.Unmarshal([]byte(m.Yaml), &info2)
	if err == nil {
		return info2
	}
	var info3 interface{}
	err = yaml.Unmarshal([]byte(m.Yaml), &info3)
	if err == nil {
		return info3
	}
	return nil
}

// ToRawInfo returns a description of Auth suitable for JSON or YAML export.
func (m *Auth) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Oauth2 != nil {
		info = append(info, yaml.MapItem{"oauth2", m.Oauth2.ToRawInfo()})
	}
	// &{Name:oauth2 Type:Oauth2 StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	return info
}

// ToRawInfo returns a description of Document suitable for JSON or YAML export.
func (m *Document) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Kind != "" {
		info = append(info, yaml.MapItem{"kind", m.Kind})
	}
	if m.DiscoveryVersion != "" {
		info = append(info, yaml.MapItem{"discoveryVersion", m.DiscoveryVersion})
	}
	if m.Id != "" {
		info = append(info, yaml.MapItem{"id", m.Id})
	}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	if m.Version != "" {
		info = append(info, yaml.MapItem{"version", m.Version})
	}
	if m.Revision != "" {
		info = append(info, yaml.MapItem{"revision", m.Revision})
	}
	if m.Title != "" {
		info = append(info, yaml.MapItem{"title", m.Title})
	}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.Icons != nil {
		info = append(info, yaml.MapItem{"icons", m.Icons.ToRawInfo()})
	}
	// &{Name:icons Type:Icons StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.DocumentationLink != "" {
		info = append(info, yaml.MapItem{"documentationLink", m.DocumentationLink})
	}
	if len(m.Labels) != 0 {
		info = append(info, yaml.MapItem{"labels", m.Labels})
	}
	if m.Protocol != "" {
		info = append(info, yaml.MapItem{"protocol", m.Protocol})
	}
	if m.BaseUrl != "" {
		info = append(info, yaml.MapItem{"baseUrl", m.BaseUrl})
	}
	if m.BasePath != "" {
		info = append(info, yaml.MapItem{"basePath", m.BasePath})
	}
	if m.RootUrl != "" {
		info = append(info, yaml.MapItem{"rootUrl", m.RootUrl})
	}
	if m.ServicePath != "" {
		info = append(info, yaml.MapItem{"servicePath", m.ServicePath})
	}
	if m.BatchPath != "" {
		info = append(info, yaml.MapItem{"batchPath", m.BatchPath})
	}
	if m.Parameters != nil {
		info = append(info, yaml.MapItem{"parameters", m.Parameters.ToRawInfo()})
	}
	// &{Name:parameters Type:Parameters StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Auth != nil {
		info = append(info, yaml.MapItem{"auth", m.Auth.ToRawInfo()})
	}
	// &{Name:auth Type:Auth StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if len(m.Features) != 0 {
		info = append(info, yaml.MapItem{"features", m.Features})
	}
	if m.Schemas != nil {
		info = append(info, yaml.MapItem{"schemas", m.Schemas.ToRawInfo()})
	}
	// &{Name:schemas Type:Schemas StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Methods != nil {
		info = append(info, yaml.MapItem{"methods", m.Methods.ToRawInfo()})
	}
	// &{Name:methods Type:Methods StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Resources != nil {
		info = append(info, yaml.MapItem{"resources", m.Resources.ToRawInfo()})
	}
	// &{Name:resources Type:Resources StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Etag != "" {
		info = append(info, yaml.MapItem{"etag", m.Etag})
	}
	if m.OwnerDomain != "" {
		info = append(info, yaml.MapItem{"ownerDomain", m.OwnerDomain})
	}
	if m.OwnerName != "" {
		info = append(info, yaml.MapItem{"ownerName", m.OwnerName})
	}
	if m.VersionModule != false {
		info = append(info, yaml.MapItem{"version_module", m.VersionModule})
	}
	if m.CanonicalName != "" {
		info = append(info, yaml.MapItem{"canonicalName", m.CanonicalName})
	}
	if m.FullyEncodeReservedExpansion != false {
		info = append(info, yaml.MapItem{"fullyEncodeReservedExpansion", m.FullyEncodeReservedExpansion})
	}
	if m.PackagePath != "" {
		info = append(info, yaml.MapItem{"packagePath", m.PackagePath})
	}
	return info
}

// ToRawInfo returns a description of Icons suitable for JSON or YAML export.
func (m *Icons) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.X16 != "" {
		info = append(info, yaml.MapItem{"x16", m.X16})
	}
	if m.X32 != "" {
		info = append(info, yaml.MapItem{"x32", m.X32})
	}
	return info
}

// ToRawInfo returns a description of MediaUpload suitable for JSON or YAML export.
func (m *MediaUpload) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if len(m.Accept) != 0 {
		info = append(info, yaml.MapItem{"accept", m.Accept})
	}
	if m.MaxSize != "" {
		info = append(info, yaml.MapItem{"maxSize", m.MaxSize})
	}
	if m.Protocols != nil {
		info = append(info, yaml.MapItem{"protocols", m.Protocols.ToRawInfo()})
	}
	// &{Name:protocols Type:Protocols StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.SupportsSubscription != false {
		info = append(info, yaml.MapItem{"supportsSubscription", m.SupportsSubscription})
	}
	return info
}

// ToRawInfo returns a description of Method suitable for JSON or YAML export.
func (m *Method) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Id != "" {
		info = append(info, yaml.MapItem{"id", m.Id})
	}
	if m.Path != "" {
		info = append(info, yaml.MapItem{"path", m.Path})
	}
	if m.HttpMethod != "" {
		info = append(info, yaml.MapItem{"httpMethod", m.HttpMethod})
	}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.Parameters != nil {
		info = append(info, yaml.MapItem{"parameters", m.Parameters.ToRawInfo()})
	}
	// &{Name:parameters Type:Parameters StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if len(m.ParameterOrder) != 0 {
		info = append(info, yaml.MapItem{"parameterOrder", m.ParameterOrder})
	}
	if m.Request != nil {
		info = append(info, yaml.MapItem{"request", m.Request.ToRawInfo()})
	}
	// &{Name:request Type:Request StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Response != nil {
		info = append(info, yaml.MapItem{"response", m.Response.ToRawInfo()})
	}
	// &{Name:response Type:Response StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if len(m.Scopes) != 0 {
		info = append(info, yaml.MapItem{"scopes", m.Scopes})
	}
	if m.SupportsMediaDownload != false {
		info = append(info, yaml.MapItem{"supportsMediaDownload", m.SupportsMediaDownload})
	}
	if m.SupportsMediaUpload != false {
		info = append(info, yaml.MapItem{"supportsMediaUpload", m.SupportsMediaUpload})
	}
	if m.UseMediaDownloadService != false {
		info = append(info, yaml.MapItem{"useMediaDownloadService", m.UseMediaDownloadService})
	}
	if m.MediaUpload != nil {
		info = append(info, yaml.MapItem{"mediaUpload", m.MediaUpload.ToRawInfo()})
	}
	// &{Name:mediaUpload Type:MediaUpload StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.SupportsSubscription != false {
		info = append(info, yaml.MapItem{"supportsSubscription", m.SupportsSubscription})
	}
	if m.FlatPath != "" {
		info = append(info, yaml.MapItem{"flatPath", m.FlatPath})
	}
	if m.EtagRequired != false {
		info = append(info, yaml.MapItem{"etagRequired", m.EtagRequired})
	}
	return info
}

// ToRawInfo returns a description of Methods suitable for JSON or YAML export.
func (m *Methods) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:additionalProperties Type:NamedMethod StringEnumValues:[] MapType:Method Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of NamedMethod suitable for JSON or YAML export.
func (m *NamedMethod) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	// &{Name:value Type:Method StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NamedParameter suitable for JSON or YAML export.
func (m *NamedParameter) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	// &{Name:value Type:Parameter StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NamedResource suitable for JSON or YAML export.
func (m *NamedResource) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	// &{Name:value Type:Resource StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NamedSchema suitable for JSON or YAML export.
func (m *NamedSchema) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	// &{Name:value Type:Schema StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of NamedScope suitable for JSON or YAML export.
func (m *NamedScope) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Name != "" {
		info = append(info, yaml.MapItem{"name", m.Name})
	}
	// &{Name:value Type:Scope StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:Mapped value}
	return info
}

// ToRawInfo returns a description of Oauth2 suitable for JSON or YAML export.
func (m *Oauth2) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Scopes != nil {
		info = append(info, yaml.MapItem{"scopes", m.Scopes.ToRawInfo()})
	}
	// &{Name:scopes Type:Scopes StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	return info
}

// ToRawInfo returns a description of Parameter suitable for JSON or YAML export.
func (m *Parameter) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Id != "" {
		info = append(info, yaml.MapItem{"id", m.Id})
	}
	if m.Type != "" {
		info = append(info, yaml.MapItem{"type", m.Type})
	}
	if m.XRef != "" {
		info = append(info, yaml.MapItem{"$ref", m.XRef})
	}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.Default != "" {
		info = append(info, yaml.MapItem{"default", m.Default})
	}
	if m.Required != false {
		info = append(info, yaml.MapItem{"required", m.Required})
	}
	if m.Format != "" {
		info = append(info, yaml.MapItem{"format", m.Format})
	}
	if m.Pattern != "" {
		info = append(info, yaml.MapItem{"pattern", m.Pattern})
	}
	if m.Minimum != "" {
		info = append(info, yaml.MapItem{"minimum", m.Minimum})
	}
	if m.Maximum != "" {
		info = append(info, yaml.MapItem{"maximum", m.Maximum})
	}
	if len(m.Enum) != 0 {
		info = append(info, yaml.MapItem{"enum", m.Enum})
	}
	if len(m.EnumDescriptions) != 0 {
		info = append(info, yaml.MapItem{"enumDescriptions", m.EnumDescriptions})
	}
	if m.Repeated != false {
		info = append(info, yaml.MapItem{"repeated", m.Repeated})
	}
	if m.Location != "" {
		info = append(info, yaml.MapItem{"location", m.Location})
	}
	if m.Properties != nil {
		info = append(info, yaml.MapItem{"properties", m.Properties.ToRawInfo()})
	}
	// &{Name:properties Type:Schemas StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.AdditionalProperties != nil {
		info = append(info, yaml.MapItem{"additionalProperties", m.AdditionalProperties.ToRawInfo()})
	}
	// &{Name:additionalProperties Type:Schema StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Items != nil {
		info = append(info, yaml.MapItem{"items", m.Items.ToRawInfo()})
	}
	// &{Name:items Type:Schema StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Annotations != nil {
		info = append(info, yaml.MapItem{"annotations", m.Annotations.ToRawInfo()})
	}
	// &{Name:annotations Type:Annotations StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	return info
}

// ToRawInfo returns a description of Parameters suitable for JSON or YAML export.
func (m *Parameters) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:additionalProperties Type:NamedParameter StringEnumValues:[] MapType:Parameter Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Protocols suitable for JSON or YAML export.
func (m *Protocols) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Simple != nil {
		info = append(info, yaml.MapItem{"simple", m.Simple.ToRawInfo()})
	}
	// &{Name:simple Type:Simple StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Resumable != nil {
		info = append(info, yaml.MapItem{"resumable", m.Resumable.ToRawInfo()})
	}
	// &{Name:resumable Type:Resumable StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	return info
}

// ToRawInfo returns a description of Request suitable for JSON or YAML export.
func (m *Request) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.XRef != "" {
		info = append(info, yaml.MapItem{"$ref", m.XRef})
	}
	if m.ParameterName != "" {
		info = append(info, yaml.MapItem{"parameterName", m.ParameterName})
	}
	return info
}

// ToRawInfo returns a description of Resource suitable for JSON or YAML export.
func (m *Resource) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Methods != nil {
		info = append(info, yaml.MapItem{"methods", m.Methods.ToRawInfo()})
	}
	// &{Name:methods Type:Methods StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Resources != nil {
		info = append(info, yaml.MapItem{"resources", m.Resources.ToRawInfo()})
	}
	// &{Name:resources Type:Resources StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	return info
}

// ToRawInfo returns a description of Resources suitable for JSON or YAML export.
func (m *Resources) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:additionalProperties Type:NamedResource StringEnumValues:[] MapType:Resource Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Response suitable for JSON or YAML export.
func (m *Response) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.XRef != "" {
		info = append(info, yaml.MapItem{"$ref", m.XRef})
	}
	return info
}

// ToRawInfo returns a description of Resumable suitable for JSON or YAML export.
func (m *Resumable) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Multipart != false {
		info = append(info, yaml.MapItem{"multipart", m.Multipart})
	}
	if m.Path != "" {
		info = append(info, yaml.MapItem{"path", m.Path})
	}
	return info
}

// ToRawInfo returns a description of Schema suitable for JSON or YAML export.
func (m *Schema) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Id != "" {
		info = append(info, yaml.MapItem{"id", m.Id})
	}
	if m.Type != "" {
		info = append(info, yaml.MapItem{"type", m.Type})
	}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	if m.Default != "" {
		info = append(info, yaml.MapItem{"default", m.Default})
	}
	if m.Required != false {
		info = append(info, yaml.MapItem{"required", m.Required})
	}
	if m.Format != "" {
		info = append(info, yaml.MapItem{"format", m.Format})
	}
	if m.Pattern != "" {
		info = append(info, yaml.MapItem{"pattern", m.Pattern})
	}
	if m.Minimum != "" {
		info = append(info, yaml.MapItem{"minimum", m.Minimum})
	}
	if m.Maximum != "" {
		info = append(info, yaml.MapItem{"maximum", m.Maximum})
	}
	if len(m.Enum) != 0 {
		info = append(info, yaml.MapItem{"enum", m.Enum})
	}
	if len(m.EnumDescriptions) != 0 {
		info = append(info, yaml.MapItem{"enumDescriptions", m.EnumDescriptions})
	}
	if m.Repeated != false {
		info = append(info, yaml.MapItem{"repeated", m.Repeated})
	}
	if m.Location != "" {
		info = append(info, yaml.MapItem{"location", m.Location})
	}
	if m.Properties != nil {
		info = append(info, yaml.MapItem{"properties", m.Properties.ToRawInfo()})
	}
	// &{Name:properties Type:Schemas StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.AdditionalProperties != nil {
		info = append(info, yaml.MapItem{"additionalProperties", m.AdditionalProperties.ToRawInfo()})
	}
	// &{Name:additionalProperties Type:Schema StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.Items != nil {
		info = append(info, yaml.MapItem{"items", m.Items.ToRawInfo()})
	}
	// &{Name:items Type:Schema StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.XRef != "" {
		info = append(info, yaml.MapItem{"$ref", m.XRef})
	}
	if m.Annotations != nil {
		info = append(info, yaml.MapItem{"annotations", m.Annotations.ToRawInfo()})
	}
	// &{Name:annotations Type:Annotations StringEnumValues:[] MapType: Repeated:false Pattern: Implicit:false Description:}
	if m.ReadOnly != false {
		info = append(info, yaml.MapItem{"readOnly", m.ReadOnly})
	}
	return info
}

// ToRawInfo returns a description of Schemas suitable for JSON or YAML export.
func (m *Schemas) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:additionalProperties Type:NamedSchema StringEnumValues:[] MapType:Schema Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Scope suitable for JSON or YAML export.
func (m *Scope) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Description != "" {
		info = append(info, yaml.MapItem{"description", m.Description})
	}
	return info
}

// ToRawInfo returns a description of Scopes suitable for JSON or YAML export.
func (m *Scopes) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.AdditionalProperties != nil {
		for _, item := range m.AdditionalProperties {
			info = append(info, yaml.MapItem{item.Name, item.Value.ToRawInfo()})
		}
	}
	// &{Name:additionalProperties Type:NamedScope StringEnumValues:[] MapType:Scope Repeated:true Pattern: Implicit:true Description:}
	return info
}

// ToRawInfo returns a description of Simple suitable for JSON or YAML export.
func (m *Simple) ToRawInfo() interface{} {
	info := yaml.MapSlice{}
	if m.Multipart != false {
		info = append(info, yaml.MapItem{"multipart", m.Multipart})
	}
	if m.Path != "" {
		info = append(info, yaml.MapItem{"path", m.Path})
	}
	return info
}

// ToRawInfo returns a description of StringArray suitable for JSON or YAML export.
func (m *StringArray) ToRawInfo() interface{} {
	return m.Value
}

var ()
