package v1

// This file contains a collection of methods that can be used from go-restful to
// generate Swagger API documentation for its models. Please read this PR for more
// information on the implementation: https://github.com/emicklei/go-restful/pull/215
//
// TODOs are ignored from the parser (e.g. TODO(andronat):... || TODO:...) if and only if
// they are on one line! For multiple line or blocks that you want to ignore use ---.
// Any context after a --- is ignored.
//
// Those methods can be generated by using hack/update-swagger-docs.sh

// AUTO-GENERATED FUNCTIONS START HERE
var map_DNSRecord = map[string]string{
	"":       "DNSRecord is a DNS record managed in the zones defined by dns.config.openshift.io/cluster .spec.publicZone and .spec.privateZone.\n\nCluster admin manipulation of this resource is not supported. This resource is only for internal communication of OpenShift operators.",
	"spec":   "spec is the specification of the desired behavior of the dnsecord.",
	"status": "status is the most recently observed status of the dnsRecord.",
}

func (DNSRecord) SwaggerDoc() map[string]string {
	return map_DNSRecord
}

var map_DNSRecordList = map[string]string{
	"": "DNSRecordList contains a list of dnsrecords.",
}

func (DNSRecordList) SwaggerDoc() map[string]string {
	return map_DNSRecordList
}

var map_DNSRecordSpec = map[string]string{
	"":           "DNSRecordSpec contains the details of a DNS record.",
	"dnsName":    "dnsName is the hostname of the DNS record",
	"targets":    "targets are record targets.",
	"recordType": "recordType is the DNS record type. For example, \"A\" or \"CNAME\".",
	"recordTTL":  "recordTTL is the record TTL in seconds. If zero, the default is 30.",
}

func (DNSRecordSpec) SwaggerDoc() map[string]string {
	return map_DNSRecordSpec
}

var map_DNSRecordStatus = map[string]string{
	"":                   "DNSRecordStatus is the most recently observed status of each record.",
	"zones":              "zones are the status of the record in each zone.",
	"observedGeneration": "observedGeneration is the most recently observed generation of the DNSRecord.  When the DNSRecord is updated, the controller updates the corresponding record in each managed zone.  If an update for a particular zone fails, that failure is recorded in the status condition for the zone so that the controller can determine that it needs to retry the update for that specific zone.",
}

func (DNSRecordStatus) SwaggerDoc() map[string]string {
	return map_DNSRecordStatus
}

var map_DNSZoneCondition = map[string]string{
	"": "DNSZoneCondition is just the standard condition fields.",
}

func (DNSZoneCondition) SwaggerDoc() map[string]string {
	return map_DNSZoneCondition
}

var map_DNSZoneStatus = map[string]string{
	"":           "DNSZoneStatus is the status of a record within a specific zone.",
	"dnsZone":    "dnsZone is the zone where the record is published.",
	"conditions": "conditions are any conditions associated with the record in the zone.\n\nIf publishing the record fails, the \"Failed\" condition will be set with a reason and message describing the cause of the failure.",
}

func (DNSZoneStatus) SwaggerDoc() map[string]string {
	return map_DNSZoneStatus
}

// AUTO-GENERATED FUNCTIONS END HERE
