#!/usr/bin/env bash
STARTTIME=$(date +%s)
source "$(dirname "${BASH_SOURCE}")/lib/init.sh"

# Update test names
go generate -mod vendor ./test/extended

# Update mirror mapping from upstream to quay
echo "# This file is generated by hack/update-generated-bindata.sh" > test/extended/util/image/zz_generated.txt
go run -mod vendor ./cmd/openshift-tests images --upstream --to-repository quay.io/openshift/community-e2e-images >> test/extended/util/image/zz_generated.txt

os::build::setup_env

OUTPUT_PARENT=${OUTPUT_ROOT:-$OS_ROOT}

# If you hit this, please reduce other tests instead of importing more
if [[ "$( cat "${OUTPUT_PARENT}/test/extended/testdata/bindata.go" | wc -c )" -gt 2500000 ]]; then
    echo "error: extended bindata is $( cat "${OUTPUT_PARENT}/test/extended/testdata/bindata.go" | wc -c ) bytes, reduce the size of the import" 1>&2
    exit 1
fi

ret=$?; ENDTIME=$(date +%s); echo "$0 took $(($ENDTIME - $STARTTIME)) seconds"; exit "$ret"
