/*
Copyright 2017 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by mockery v1.0.0
package testing

import container "k8s.io/kubernetes/pkg/kubelet/container"
import mock "github.com/stretchr/testify/mock"
import time "time"

// MockRuntimeCache is an autogenerated mock type for the RuntimeCache type
type MockRuntimeCache struct {
	mock.Mock
}

// ForceUpdateIfOlder provides a mock function with given fields: _a0
func (_m *MockRuntimeCache) ForceUpdateIfOlder(_a0 time.Time) error {
	ret := _m.Called(_a0)

	var r0 error
	if rf, ok := ret.Get(0).(func(time.Time) error); ok {
		r0 = rf(_a0)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// GetPods provides a mock function with given fields:
func (_m *MockRuntimeCache) GetPods() ([]*container.Pod, error) {
	ret := _m.Called()

	var r0 []*container.Pod
	if rf, ok := ret.Get(0).(func() []*container.Pod); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*container.Pod)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func() error); ok {
		r1 = rf()
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}
