/*
Copyright 2018 Red Hat, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// This file was automatically generated by informer-gen

package v1alpha2

import (
	idling_v1alpha2 "github.com/openshift/service-idler/pkg/apis/idling/v1alpha2"
	versioned "github.com/openshift/service-idler/pkg/client/clientset/versioned"
	internalinterfaces "github.com/openshift/service-idler/pkg/client/informers/externalversions/internalinterfaces"
	v1alpha2 "github.com/openshift/service-idler/pkg/client/listers/idling/v1alpha2"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
	time "time"
)

// IdlerInformer provides access to a shared informer and lister for
// Idlers.
type IdlerInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1alpha2.IdlerLister
}

type idlerInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewIdlerInformer constructs a new informer for Idler type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewIdlerInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredIdlerInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredIdlerInformer constructs a new informer for Idler type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredIdlerInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.IdlingV1alpha2().Idlers(namespace).List(options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.IdlingV1alpha2().Idlers(namespace).Watch(options)
			},
		},
		&idling_v1alpha2.Idler{},
		resyncPeriod,
		indexers,
	)
}

func (f *idlerInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredIdlerInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *idlerInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&idling_v1alpha2.Idler{}, f.defaultInformer)
}

func (f *idlerInformer) Lister() v1alpha2.IdlerLister {
	return v1alpha2.NewIdlerLister(f.Informer().GetIndexer())
}
