---
title: v0.18.0
weight: 999982000
---

## Modules

- Ensure that the following `require` and `replace` directives with these specific versions are present in your `go.mod` file:

```go
require (
	github.com/operator-framework/operator-sdk v0.18.0
	k8s.io/api v0.18.2
	k8s.io/apimachinery v0.18.2
	sigs.k8s.io/controller-runtime v0.6.0
)

replace (
	github.com/Azure/go-autorest => github.com/Azure/go-autorest v13.3.2+incompatible // Required by OLM
	k8s.io/client-go => k8s.io/client-go v0.18.2 // Required by prometheus-operator
)
```

## (Optional) Add livenessProbe check for Ansible-based operators

Existing operators will have a healthz endpoint without intervention, but to take advantage of it, a liveness probe should be manually added to the operator manifest. For example, the `deploy/operator.yaml` file would need to include:
```yaml
  livenessProbe:
    httpGet:
      path: /healthz
      port: 6789
    initialDelaySeconds: 5
    periodSeconds: 3
```

_See [#2936](https://github.com/operator-framework/operator-sdk/pull/2936) for more details._

## Remove the file `/bin/ao-logs` for Ansible based-operators

The `inotify-tools` as a dependency of Ansible based-operator images which was deprecated in the version `v0.16.0` was removed. This dependency was used to output the Ansible logs in a side-car container called `ansible`, which has no longer been scaffolded by default. In this way, if you have any customization using this dependency be aware that it is no longer in the Ansible based-operator image and then, feel free to remove this file `/bin/ao-logs` for your projects since it has no longer usage. For further information also see the section `Remove Ansible container sidecar` on the migration guide of the version `v0.16.0`.

_See [#2852](https://github.com/operator-framework/operator-sdk/pull/2852) for more details._

## Modify permissions on your bundle manifests directory

Run `chmod 0755 deploy/olm-catalog/<operator-name>/manifests` to update your operator's bundle directory permissions.

_See [#3129](https://github.com/operator-framework/operator-sdk/pull/3129) for more details._
## Default CRD version

The default CRD version was changed from `apiextensions.k8s.io/v1beta1`
to `apiextensions.k8s.io/v1` for commands that create or generate
CRDs. To migrate CRDs from `v1beta1` to `v1`, simply re-run
`operator-sdk generate crds`. To continue generating CRDs with
`apiextensions.k8s.io/v1beta1`, use `--crd-version=v1beta1`.

The following CRD versions are (or will be) compatible with the
following Kubernetes versions:

  - Kubernetes <= v1.15 - Only `apiextensions.k8s.io/v1beta1` supported
  - Kubernetes v1.16 through v1.18 - Both `apiextensions.k8s.io/v1beta1`
    and `apiextensions.k8s.io/v1` supported
  - Kubernetes >= v1.19 - Only `apiextensions.k8s.io/v1` supported

_See [#2874](https://github.com/operator-framework/operator-sdk/pull/2874) for more details._

## Helm-based operators should not use `k8s.io` API version suffix

Newly created Helm-based operators no longer use the `k8s.io` domain
suffix as a default API version because it is reserved. APIs and CRDs
using this domain [require API review][api-review] and approval.
Existing projects that do not have this approval should migrate to use
a new CRD API version suffix.

Make the following changes to migrate to a new group name:

  - `watches.yaml` - Update the `group` field.
  - `deploy/role.yaml` - Update the `apiGroups` field in the policy rule giving access to the CRD.
  - `deploy/crds/`
    - Update the `metadata.name` and `spec.group` fields in the CRD files.
    - Update the `apiVersion` field in the CR files.
    - Rename the CRD and CR files to reflect the new group name.

[api-review]: https://github.com/kubernetes/community/blob/81ec4af0ed02b4c5c0917a16563250b2f45250c2/sig-architecture/api-review-process.md#mandatory

_See [#2859](https://github.com/operator-framework/operator-sdk/pull/2859) for more details._

## Kubernetes client-go contexts

Operators using client-go directly and operators
that have generated clientsets will be required to
update many of their client-go function calls, which
have signature changes related to passing contexts
and options.

Users can use http://sigs.k8s.io/clientgofix to
rewrite method invocations to the new signatures.

_See [#2918](https://github.com/operator-framework/operator-sdk/pull/2918) for more details._

## Controller-runtime changes

There were various breaking changes in controller-runtime
v0.6.0.

  - Informers methods now require a context parameter
  - Owns, For, and Watches funtions now take variadic
    functional option arguments.

_See [#2918](https://github.com/operator-framework/operator-sdk/pull/2918) for more details._

## Helm operator no longer migrates v2 releases to v3

The deprecated support for Helm v2 releases has been removed. If
you require automigration of Helm v2 releases, continue using
v0.17.x.

This removal does NOT affect support for v2 Helm charts, which
are still supported by Helm v3.

_See [#2918](https://github.com/operator-framework/operator-sdk/pull/2918) for more details._

## Helm operator no longer supports deprecated UID-based release names


In v0.11.0, the Helm operator began using the CR name as the release
name while also maintaining backwards compatibility for legacy
UID-based release names. Continued support for the UID-based release
names has been removed.

Before upgrading to this release, delete and recreate custom resources
that are still using the deprecated UID-based release name. To determine
if you have any UID-based release names still in use, inspect the
`status.deployedRelease` field of your custom resources and look for
release names that end with a 25-character random string.

_See [#2918](https://github.com/operator-framework/operator-sdk/pull/2918) for more details._
