## v1.5.0

### Additions

- Added support for markers for files with the `yml` extension. More info: [kubernetes-sigs/kubebuilder#1907](https://github.com/kubernetes-sigs/kubebuilder/pull/1907). ([#4402](https://github.com/operator-framework/operator-sdk/pull/4402))
- (go/v3) Added the `--force` option to the `create webhook` command. More info: [kubernetes-sigs/kubebuilder#1903](https://github.com/kubernetes-sigs/kubebuilder/pull/1903). ([#4402](https://github.com/operator-framework/operator-sdk/pull/4402))
- (go/v3) Added `ErrorIfCRDPathMissing` config by default to controller's `suite_tests.go`. More info: [kubernetes-sigs/kubebuilder#1910](https://github.com/kubernetes-sigs/kubebuilder/pull/1910). ([#4402](https://github.com/operator-framework/operator-sdk/pull/4402))
- For Ansible-based operators, allow passing a `--graceful-shutdown-timeout` to configure the duration the manager should wait before stopping. ([#4571](https://github.com/operator-framework/operator-sdk/pull/4571))
- (go/v3) Create and bind to a non-default service account ([kubernetes-sigs/kubebuilder#2070](https://github.com/kubernetes-sigs/kubebuilder/pull/2070)). ([#4626](https://github.com/operator-framework/operator-sdk/pull/4626))

### Changes

- (go/v3) Upgraded the `sigs.k8s.io/kubebuilder-declarative-pattern` dependency used by `create api --pattern=addon`. More info: [kubernetes-sigs/kubebuilder#1946](https://github.com/kubernetes-sigs/kubebuilder/pull/1946). ([#4402](https://github.com/operator-framework/operator-sdk/pull/4402))
- (go/v2, go/v3) Added Makefile help. ([#4402](https://github.com/operator-framework/operator-sdk/pull/4402))
- (go/v3) Changed the manager pod template's security context `runAsUser: 65532` to `runAsNonRoot: true`. More info: [kubernetes-sigs/kubebuilder#1978](https://github.com/kubernetes-sigs/kubebuilder/pull/1978). ([#4402](https://github.com/operator-framework/operator-sdk/pull/4402))
- **Breaking change**: PROJECT config version 3-alpha has been upgraded to version 3. ([#4613](https://github.com/operator-framework/operator-sdk/pull/4613))
- Improved `generate bundle` and `generate packagemanifests` handling and help text for use outside of a project. ([#4514](https://github.com/operator-framework/operator-sdk/pull/4514))
- (go/v3) Pinned controller-runtime to v0.7.2. ([#4626](https://github.com/operator-framework/operator-sdk/pull/4626))
- For Ansible-based operators, change the level of the proxy skipping cache logs to debug level. ([#4511](https://github.com/operator-framework/operator-sdk/pull/4511))

### Bug Fixes

- For Go-based operators, fixed `create api --force` such that it actually overwrites all files. More info: [kubernetes-sigs/kubebuilder#1903](https://github.com/kubernetes-sigs/kubebuilder/pull/1903). ([#4402](https://github.com/operator-framework/operator-sdk/pull/4402))
- Upgraded the `gcr.io/kubebuilder/kube-rbac-proxy` image version from `0.5.0` to `0.8.0` to support rootless run mode. More info [kubernetes-sigs/kubebuilder#1955](https://github.com/kubernetes-sigs/kubebuilder/pull/1955). ([#4402](https://github.com/operator-framework/operator-sdk/pull/4402))
- (go/v3) Correctly named health/readiness endpoints as `healthz` and `readyz`, respectively. More info [kubernetes-sigs/kubebuilder#1910](https://github.com/kubernetes-sigs/kubebuilder/pull/1910). ([#4402](https://github.com/operator-framework/operator-sdk/pull/4402))
- (go/v3) Tolerate `.` directories when checking if dir is empty in `init`. More info: [kubernetes-sigs/kubebuilder#1944](https://github.com/kubernetes-sigs/kubebuilder/pull/1944). ([#4402](https://github.com/operator-framework/operator-sdk/pull/4402))
- Properly consider all Go files when generating a CSV's `spec.customresourcedefinitions.owned`. ([#4507](https://github.com/operator-framework/operator-sdk/pull/4507))
- Fixed samples kustomization.yaml generation on `operator-sdk init --plugins=helm --helm-chart=<chart>`, caused by out-of-order operations in plugin code. ([#4584](https://github.com/operator-framework/operator-sdk/pull/4584))
- Skip CSV definitions parsing in `generate kustomize manifests` if the APIs dir does not exist, as projects may use only required APIs. ([#4624](https://github.com/operator-framework/operator-sdk/pull/4624))
- Bump cryptography dependency in ansible-operator to `3.3.2`. This will fix a potential security bug related to update() calls. Ref: https://github.com/pyca/cryptography/blob/main/CHANGELOG.rst#332---2021-02-07. ([#4539](https://github.com/operator-framework/operator-sdk/pull/4539))
- Fixed ambiguous `--input-dir` and `--deploy-dir` flag semantics for `generate bundle`. ([#4514](https://github.com/operator-framework/operator-sdk/pull/4514))
- (ansible/v1, helm/v1) Upgraded the `gcr.io/kubebuilder/kube-rbac-proxy` image version from `0.5.0` to `0.8.0` to support rootless run mode. ([#4498](https://github.com/operator-framework/operator-sdk/pull/4498))
- For Ansible/Helm-based operators, fix swapped readinessProbe/livenessProbe in manager. ([#4546](https://github.com/operator-framework/operator-sdk/pull/4546))
