// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/openshift/api/apiserver/v1"
	"github.com/openshift/client-go/apiserver/clientset/versioned/scheme"
	rest "k8s.io/client-go/rest"
)

type ApiserverV1Interface interface {
	RESTClient() rest.Interface
	APIRequestCountsGetter
}

// ApiserverV1Client is used to interact with features provided by the apiserver.openshift.io group.
type ApiserverV1Client struct {
	restClient rest.Interface
}

func (c *ApiserverV1Client) APIRequestCounts() APIRequestCountInterface {
	return newAPIRequestCounts(c)
}

// NewForConfig creates a new ApiserverV1Client for the given config.
func NewForConfig(c *rest.Config) (*ApiserverV1Client, error) {
	config := *c
	if err := setConfigDefaults(&config); err != nil {
		return nil, err
	}
	client, err := rest.RESTClientFor(&config)
	if err != nil {
		return nil, err
	}
	return &ApiserverV1Client{client}, nil
}

// NewForConfigOrDie creates a new ApiserverV1Client for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *ApiserverV1Client {
	client, err := NewForConfig(c)
	if err != nil {
		panic(err)
	}
	return client
}

// New creates a new ApiserverV1Client for the given RESTClient.
func New(c rest.Interface) *ApiserverV1Client {
	return &ApiserverV1Client{c}
}

func setConfigDefaults(config *rest.Config) error {
	gv := v1.SchemeGroupVersion
	config.GroupVersion = &gv
	config.APIPath = "/apis"
	config.NegotiatedSerializer = scheme.Codecs.WithoutConversion()

	if config.UserAgent == "" {
		config.UserAgent = rest.DefaultKubernetesUserAgent()
	}

	return nil
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *ApiserverV1Client) RESTClient() rest.Interface {
	if c == nil {
		return nil
	}
	return c.restClient
}
