---
title: v1.6.1
weight: 998994000
---

## (ansible/v1, helm/v1) Optional: configure `ansible-operator` and `helm-operator` with a component config.

To add this option your project you will need to: 
- Create the file [config/default/manager_config_patch.yaml](https://github.com/operator-framework/operator-sdk/blob/2a1bd03/testdata/ansible/memcached-operator/config/default/manager_config_patch.yaml). 
- Create the file [config/manager/controller_manager_config.yaml](https://github.com/operator-framework/operator-sdk/blob/2a1bd03/testdata/ansible/memcached-operator/config/manager/controller_manager_config.yaml). 
- Update the `config/default/kustomization.yaml` by adding the following to `resources`:
  ```yaml
  resources:
  ...
  - manager_config_patch.yaml
  ```
- Update the `config/manager/kustomization.yaml` by adding:
```yaml
  generatorOptions:
    disableNameSuffixHash: true

  configMapGenerator:
  - files:
    - controller_manager_config.yaml
    name: manager-config
  apiVersion: kustomize.config.k8s.io/v1beta1
  kind: Kustomization
  images:
  - name: controller
    newName: quay.io/example/memcached-operator
    newTag: v0.0.1
```

_See [#4701](https://github.com/operator-framework/operator-sdk/pull/4701) for more details._

## (ansible/v1, helm/v1) Add Role rules for leader election.

Add the rule for the `apiGroups` `coordination.k8s.io` and the resource `leases` in config/rbac/leader_election_role.yaml:
```yaml
rules:
  - apiGroups:
      - ""
      - coordination.k8s.io
    resources:
      - configmaps
      - leases
```

_See [#4701](https://github.com/operator-framework/operator-sdk/pull/4701) for more details._

## (ansible/v1) Update Ansible collections

In your requirements.yml, change the `version` field for community.kubernetes to `1.2.1`, and the `version` field for `operator_sdk.util` to `0.2.0`.

_See [#4734](https://github.com/operator-framework/operator-sdk/pull/4734) for more details._

## (helm/v1) Replace deprecated leader election and metrics address flags

Replace deprecated flags `--enable-leader-election` and `--metrics-addr` with `--leader-elect` and `--metrics-bind-address`, respectively.

_See [#4654](https://github.com/operator-framework/operator-sdk/pull/4654) for more details._

## (helm/v1) Explicitly set `--health-probe-bind-address` in the manager's auth proxy patch.

Add the arg `--health-probe-bind-address=:8081` to the `config/default/manager_auth_proxy_patch.yaml`:
```yaml
spec:
  template:
    spec:
      containers:
      - name: manager
        args:
        - "--health-probe-bind-address=:8081"
        ...
```

_See [#4654](https://github.com/operator-framework/operator-sdk/pull/4654) for more details._

## (ansible/v1) Explicitly set `--health-probe-bind-address` in the manager's auth proxy patch.

Add the arg `--health-probe-bind-address=:6789` to the `config/default/manager_auth_proxy_patch.yaml`:
```yaml
spec:
  template:
    spec:
      containers:
      - name: manager
        args:
        - "--health-probe-bind-address=:6789"
        ...
```

_See [#4654](https://github.com/operator-framework/operator-sdk/pull/4654) for more details._

## (helm/v1, ansible/v1) Add `help` target to Makefile.

Ansible/Helm projects now provide a Makefile `help` target, similar to a `--help` flag. You can copy and paste this target from the relevant sample's Makefile ([helm](https://github.com/operator-framework/operator-sdk/blob/v1.5.0/testdata/helm/memcached-operator/Makefile), [ansible](https://github.com/operator-framework/operator-sdk/blob/v1.5.0/testdata/ansible/memcached-operator/Makefile)).

_See [#4660](https://github.com/operator-framework/operator-sdk/pull/4660) for more details._

## (ansible/v1, helm/v1) Add `securityContext`'s to your manager's Deployment.

In `config/manager/manager.yaml`, add the following security contexts:
```yaml
spec:
  ...
  template:
    ...
    spec:
      securityContext:
        runAsNonRoot: true
      containers:
      - name: manager
        securityContext:
          allowPrivilegeEscalation: false
```

_See [#4655](https://github.com/operator-framework/operator-sdk/pull/4655) for more details._

## (manifests/v2) Add a kustomize patch to remove the cert-manager volume/volumeMount from your CSV

OLM does [not yet support cert-manager](https://olm.operatorframework.io/docs/advanced-tasks/adding-admission-and-conversion-webhooks/#certificate-authority-requirements), so a JSON patch was added to remove this volume and mount such that OLM can itself create and manage certs for your Operator.
In `config/manifests/kustomization.yaml`, add the following:
```yaml
#patchesJson6902:
#- target:
#    group: apps
#    version: v1
#    kind: Deployment
#    name: controller-manager
#    namespace: system
#  patch: |-
#    # Remove the manager container's "cert" volumeMount, since OLM will create and mount a set of certs.
#    # Update the indices in this path if adding or removing containers/volumeMounts in the manager's Deployment.
#    - op: remove
#      path: /spec/template/spec/containers/1/volumeMounts/0
#    # Remove the "cert" volume, since OLM will create and mount a set of certs.
#    # Update the indices in this path if adding or removing volumes in the manager's Deployment.
#    - op: remove
#      path: /spec/template/spec/volumes/0
```

If you have configured your operator to use webhooks, add this YAML block uncommented.

_See [#4623](https://github.com/operator-framework/operator-sdk/pull/4623) for more details._

## (go/v2, go/v3, ansible/v1, helm/v1) Add scheme, token, and TLS config to the Prometheus `ServiceMonitor` metrics endpoint.

The `/metrics` endpoint, while specifying the `https` port on the manager Pod, was not actually configured to serve over https because no tlsConfig was set. Since kube-rbac-proxy secures this endpoint as a manager sidecar, using the service account token mounted into the Pod by default corrects this problem.
The changes should look like:
```diff
# config/prometheus/monitor.yaml
spec:
   endpoints:
     - path: /metrics
       port: https
+      scheme: https
+      bearerTokenFile: /var/run/secrets/kubernetes.io/serviceaccount/token
+      tlsConfig:
+        insecureSkipVerify: true
   selector:
     matchLabels:
       control-plane: controller-manager
```
**Note:** if you have removed kube-rbac-proxy from your project, make sure to secure the `/metrics` endpoint using a proper [TLS configuration](https://prometheus.io/docs/guides/tls-encryption/).

_See [#4680](https://github.com/operator-framework/operator-sdk/pull/4680) for more details._

## (go/v2, go/v3, ansible/v1, helm/v1) Add `opm` and `catalog-build` Makefile targets

The `opm` and `catalog-build` Makefile targets were added so operator developers who want to create their own catalogs for their operator or add their operator's bundle(s) to an existing catalog can do so. If this sounds like you, add the following lines to the bottom of your Makefile:
```make
.PHONY: opm
OPM = ./bin/opm
opm:
ifeq (,$(wildcard $(OPM)))
ifeq (,$(shell which opm 2>/dev/null))
	@{ \
	set -e ;\
	mkdir -p $(dir $(OPM)) ;\
	curl -sSLo $(OPM) https://github.com/operator-framework/operator-registry/releases/download/v1.15.1/$(OS)-$(ARCH)-opm ;\
	chmod +x $(OPM) ;\
	}
else 
OPM = $(shell which opm)
endif
endif
BUNDLE_IMGS ?= $(BUNDLE_IMG) 
CATALOG_IMG ?= $(IMAGE_TAG_BASE)-catalog:v$(VERSION) ifneq ($(origin CATALOG_BASE_IMG), undefined) FROM_INDEX_OPT := --from-index $(CATALOG_BASE_IMG) endif 
.PHONY: catalog-build
catalog-build: opm
	$(OPM) index add --container-tool docker --mode semver --tag $(CATALOG_IMG) --bundles $(BUNDLE_IMGS) $(FROM_INDEX_OPT)

.PHONY: catalog-push
catalog-push: ## Push the catalog image.
	$(MAKE) docker-push IMG=$(CATALOG_IMG)
```
If updating a Go operator project, additionally add the following Makefile variables:
```make
OS = $(shell go env GOOS)
ARCH = $(shell go env GOARCH)
```

_See [#4406](https://github.com/operator-framework/operator-sdk/pull/4406) for more details._

## (go/v2, go/v3, ansible/v1, helm/v1) Changed `BUNDLE_IMG` and added `IMAGE_TAG_BASE` Makefile variables

The following Makefile changes were made to allow `make bundle-build bundle-push catalog-build catalog-push` and encode image repo/namespace information in the Makefile by default:
```diff
+IMAGE_TAG_BASE ?= <registry>/<operator name>
+ 
-BUNDLE_IMG ?= controller-bundle:$(VERSION)
+BUNDLE_IMG ?= $(IMAGE_TAG_BASE)-bundle:v$(VERSION)
```

For example, if `IMAGE_TAG_BASE ?= foo/bar-operator` then running `make bundle-build bundle-push catalog-build catalog-push` would build `foo/bar-operator-bundle:v0.0.1` and `foo/bar-operator-catalog:v0.0.1` then push them to the `docker.io/foo` namespaced registry.

_See [#4406](https://github.com/operator-framework/operator-sdk/pull/4406) for more details._

## (ansible/v1, helm/v1) Add the `controller-manager` ServiceAccount to your project.

A non-default ServiceAccount `controller-manager` is scaffolded on `operator-sdk init`, to improve security for operators installed in shared namespaces. To add this ServiceAccount to your project, do the following:
```sh
# Create the ServiceAccount.
cat <<EOF > config/rbac/service_account.yaml apiVersion: v1 
kind: ServiceAccount
metadata:
  name: controller-manager
  namespace: system
EOF
# Add it to the list of RBAC resources.
echo "- service_account.yaml" >> config/rbac/kustomization.yaml
# Update all RoleBinding and ClusterRoleBinding subjects that reference the operator's ServiceAccount.
find config/rbac -name *_binding.yaml -exec sed -i -E 's/  name: default/  name: controller-manager/g' {} \; 
# Add the ServiceAccount name to the manager Deployment's spec.template.spec.serviceAccountName. 
sed -i -E 's/([ ]+)(terminationGracePeriodSeconds:)/\1serviceAccountName: controller-manager\n\1\2/g' config/manager/manager.yaml
```

The changes should look like: 

```diff 
# config/manager/manager.yaml
           requests:
             cpu: 100m
             memory: 20Mi
+      serviceAccountName: controller-manager
       terminationGracePeriodSeconds: 10
# config/rbac/auth_proxy_role_binding.yaml
   name: proxy-role
 subjects:
 - kind: ServiceAccount
-  name: default 
+  name: controller-manager
   namespace: system
# config/rbac/kustomization.yaml
 resources:
+- service_account.yaml
 - role.yaml
 - role_binding.yaml
 - leader_election_role.yaml
# config/rbac/leader_election_role_binding.yaml
   name: leader-election-role
 subjects:
 - kind: ServiceAccount
-  name: default
+  name: controller-manager
   namespace: system
# config/rbac/role_binding.yaml
   name: manager-role
 subjects:
 - kind: ServiceAccount
-  name: default 
+  name: controller-manager
   namespace: system
# config/rbac/service_account.yaml 
+apiVersion: v1 
+kind: ServiceAccount 
+metadata: 
+  name: controller-manager 
+  namespace: system
```

_See [#4653](https://github.com/operator-framework/operator-sdk/pull/4653) for more details._
