// Copyright 2021 The Operator-SDK Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package util

import (
	"path/filepath"
	"strings"
)

const (
	filePathSep  = string(filepath.Separator)
	javaPath     = "src" + filePathSep + "main" + filePathSep + "java"
	resourcePath = "src" + filePathSep + "main" + filePathSep + "resources"
)

func PrependJavaPath(filename string, pkg string) string {
	return javaPath + filePathSep + pkg + filePathSep + filename
}

func PrependResourcePath(filename string) string {
	return resourcePath + filePathSep + filename
}

func AsPath(s string) string {
	return strings.ReplaceAll(s, ".", filePathSep)
}
