// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeProvisionedProductInput struct {
	_ struct{} `type:"structure"`

	// The language code.
	//
	//    * en - English (default)
	//
	//    * jp - Japanese
	//
	//    * zh - Chinese
	AcceptLanguage *string `type:"string"`

	// The provisioned product identifier.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeProvisionedProductInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProvisionedProductInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeProvisionedProductInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeProvisionedProductOutput struct {
	_ struct{} `type:"structure"`

	// Any CloudWatch dashboards that were created when provisioning the product.
	CloudWatchDashboards []CloudWatchDashboard `type:"list"`

	// Information about the provisioned product.
	ProvisionedProductDetail *ProvisionedProductDetail `type:"structure"`
}

// String returns the string representation
func (s DescribeProvisionedProductOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeProvisionedProduct = "DescribeProvisionedProduct"

// DescribeProvisionedProductRequest returns a request value for making API operation for
// AWS Service Catalog.
//
// Gets information about the specified provisioned product.
//
//    // Example sending a request using DescribeProvisionedProductRequest.
//    req := client.DescribeProvisionedProductRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisionedProduct
func (c *Client) DescribeProvisionedProductRequest(input *DescribeProvisionedProductInput) DescribeProvisionedProductRequest {
	op := &aws.Operation{
		Name:       opDescribeProvisionedProduct,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeProvisionedProductInput{}
	}

	req := c.newRequest(op, input, &DescribeProvisionedProductOutput{})
	return DescribeProvisionedProductRequest{Request: req, Input: input, Copy: c.DescribeProvisionedProductRequest}
}

// DescribeProvisionedProductRequest is the request type for the
// DescribeProvisionedProduct API operation.
type DescribeProvisionedProductRequest struct {
	*aws.Request
	Input *DescribeProvisionedProductInput
	Copy  func(*DescribeProvisionedProductInput) DescribeProvisionedProductRequest
}

// Send marshals and sends the DescribeProvisionedProduct API request.
func (r DescribeProvisionedProductRequest) Send(ctx context.Context) (*DescribeProvisionedProductResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeProvisionedProductResponse{
		DescribeProvisionedProductOutput: r.Request.Data.(*DescribeProvisionedProductOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeProvisionedProductResponse is the response type for the
// DescribeProvisionedProduct API operation.
type DescribeProvisionedProductResponse struct {
	*DescribeProvisionedProductOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeProvisionedProduct request.
func (r *DescribeProvisionedProductResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
