// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package docdbiface provides an interface to enable mocking the Amazon DocumentDB with MongoDB compatibility service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package docdbiface

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/service/docdb"
)

// ClientAPI provides an interface to enable mocking the
// docdb.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon DocDB.
//    func myFunc(svc docdbiface.ClientAPI) bool {
//        // Make svc.AddTagsToResource request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := docdb.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        docdbiface.ClientPI
//    }
//    func (m *mockClientClient) AddTagsToResource(input *docdb.AddTagsToResourceInput) (*docdb.AddTagsToResourceOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	AddTagsToResourceRequest(*docdb.AddTagsToResourceInput) docdb.AddTagsToResourceRequest

	ApplyPendingMaintenanceActionRequest(*docdb.ApplyPendingMaintenanceActionInput) docdb.ApplyPendingMaintenanceActionRequest

	CopyDBClusterParameterGroupRequest(*docdb.CopyDBClusterParameterGroupInput) docdb.CopyDBClusterParameterGroupRequest

	CopyDBClusterSnapshotRequest(*docdb.CopyDBClusterSnapshotInput) docdb.CopyDBClusterSnapshotRequest

	CreateDBClusterRequest(*docdb.CreateDBClusterInput) docdb.CreateDBClusterRequest

	CreateDBClusterParameterGroupRequest(*docdb.CreateDBClusterParameterGroupInput) docdb.CreateDBClusterParameterGroupRequest

	CreateDBClusterSnapshotRequest(*docdb.CreateDBClusterSnapshotInput) docdb.CreateDBClusterSnapshotRequest

	CreateDBInstanceRequest(*docdb.CreateDBInstanceInput) docdb.CreateDBInstanceRequest

	CreateDBSubnetGroupRequest(*docdb.CreateDBSubnetGroupInput) docdb.CreateDBSubnetGroupRequest

	DeleteDBClusterRequest(*docdb.DeleteDBClusterInput) docdb.DeleteDBClusterRequest

	DeleteDBClusterParameterGroupRequest(*docdb.DeleteDBClusterParameterGroupInput) docdb.DeleteDBClusterParameterGroupRequest

	DeleteDBClusterSnapshotRequest(*docdb.DeleteDBClusterSnapshotInput) docdb.DeleteDBClusterSnapshotRequest

	DeleteDBInstanceRequest(*docdb.DeleteDBInstanceInput) docdb.DeleteDBInstanceRequest

	DeleteDBSubnetGroupRequest(*docdb.DeleteDBSubnetGroupInput) docdb.DeleteDBSubnetGroupRequest

	DescribeCertificatesRequest(*docdb.DescribeCertificatesInput) docdb.DescribeCertificatesRequest

	DescribeDBClusterParameterGroupsRequest(*docdb.DescribeDBClusterParameterGroupsInput) docdb.DescribeDBClusterParameterGroupsRequest

	DescribeDBClusterParametersRequest(*docdb.DescribeDBClusterParametersInput) docdb.DescribeDBClusterParametersRequest

	DescribeDBClusterSnapshotAttributesRequest(*docdb.DescribeDBClusterSnapshotAttributesInput) docdb.DescribeDBClusterSnapshotAttributesRequest

	DescribeDBClusterSnapshotsRequest(*docdb.DescribeDBClusterSnapshotsInput) docdb.DescribeDBClusterSnapshotsRequest

	DescribeDBClustersRequest(*docdb.DescribeDBClustersInput) docdb.DescribeDBClustersRequest

	DescribeDBEngineVersionsRequest(*docdb.DescribeDBEngineVersionsInput) docdb.DescribeDBEngineVersionsRequest

	DescribeDBInstancesRequest(*docdb.DescribeDBInstancesInput) docdb.DescribeDBInstancesRequest

	DescribeDBSubnetGroupsRequest(*docdb.DescribeDBSubnetGroupsInput) docdb.DescribeDBSubnetGroupsRequest

	DescribeEngineDefaultClusterParametersRequest(*docdb.DescribeEngineDefaultClusterParametersInput) docdb.DescribeEngineDefaultClusterParametersRequest

	DescribeEventCategoriesRequest(*docdb.DescribeEventCategoriesInput) docdb.DescribeEventCategoriesRequest

	DescribeEventsRequest(*docdb.DescribeEventsInput) docdb.DescribeEventsRequest

	DescribeOrderableDBInstanceOptionsRequest(*docdb.DescribeOrderableDBInstanceOptionsInput) docdb.DescribeOrderableDBInstanceOptionsRequest

	DescribePendingMaintenanceActionsRequest(*docdb.DescribePendingMaintenanceActionsInput) docdb.DescribePendingMaintenanceActionsRequest

	FailoverDBClusterRequest(*docdb.FailoverDBClusterInput) docdb.FailoverDBClusterRequest

	ListTagsForResourceRequest(*docdb.ListTagsForResourceInput) docdb.ListTagsForResourceRequest

	ModifyDBClusterRequest(*docdb.ModifyDBClusterInput) docdb.ModifyDBClusterRequest

	ModifyDBClusterParameterGroupRequest(*docdb.ModifyDBClusterParameterGroupInput) docdb.ModifyDBClusterParameterGroupRequest

	ModifyDBClusterSnapshotAttributeRequest(*docdb.ModifyDBClusterSnapshotAttributeInput) docdb.ModifyDBClusterSnapshotAttributeRequest

	ModifyDBInstanceRequest(*docdb.ModifyDBInstanceInput) docdb.ModifyDBInstanceRequest

	ModifyDBSubnetGroupRequest(*docdb.ModifyDBSubnetGroupInput) docdb.ModifyDBSubnetGroupRequest

	RebootDBInstanceRequest(*docdb.RebootDBInstanceInput) docdb.RebootDBInstanceRequest

	RemoveTagsFromResourceRequest(*docdb.RemoveTagsFromResourceInput) docdb.RemoveTagsFromResourceRequest

	ResetDBClusterParameterGroupRequest(*docdb.ResetDBClusterParameterGroupInput) docdb.ResetDBClusterParameterGroupRequest

	RestoreDBClusterFromSnapshotRequest(*docdb.RestoreDBClusterFromSnapshotInput) docdb.RestoreDBClusterFromSnapshotRequest

	RestoreDBClusterToPointInTimeRequest(*docdb.RestoreDBClusterToPointInTimeInput) docdb.RestoreDBClusterToPointInTimeRequest

	StartDBClusterRequest(*docdb.StartDBClusterInput) docdb.StartDBClusterRequest

	StopDBClusterRequest(*docdb.StopDBClusterInput) docdb.StopDBClusterRequest

	WaitUntilDBInstanceAvailable(context.Context, *docdb.DescribeDBInstancesInput, ...aws.WaiterOption) error

	WaitUntilDBInstanceDeleted(context.Context, *docdb.DescribeDBInstancesInput, ...aws.WaiterOption) error
}

var _ ClientAPI = (*docdb.Client)(nil)
