// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directoryservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteLogSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// Identifier of the directory whose log subscription you want to delete.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLogSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLogSubscriptionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteLogSubscriptionInput"}

	if s.DirectoryId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteLogSubscriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLogSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteLogSubscription = "DeleteLogSubscription"

// DeleteLogSubscriptionRequest returns a request value for making API operation for
// AWS Directory Service.
//
// Deletes the specified log subscription.
//
//    // Example sending a request using DeleteLogSubscriptionRequest.
//    req := client.DeleteLogSubscriptionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteLogSubscription
func (c *Client) DeleteLogSubscriptionRequest(input *DeleteLogSubscriptionInput) DeleteLogSubscriptionRequest {
	op := &aws.Operation{
		Name:       opDeleteLogSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLogSubscriptionInput{}
	}

	req := c.newRequest(op, input, &DeleteLogSubscriptionOutput{})
	return DeleteLogSubscriptionRequest{Request: req, Input: input, Copy: c.DeleteLogSubscriptionRequest}
}

// DeleteLogSubscriptionRequest is the request type for the
// DeleteLogSubscription API operation.
type DeleteLogSubscriptionRequest struct {
	*aws.Request
	Input *DeleteLogSubscriptionInput
	Copy  func(*DeleteLogSubscriptionInput) DeleteLogSubscriptionRequest
}

// Send marshals and sends the DeleteLogSubscription API request.
func (r DeleteLogSubscriptionRequest) Send(ctx context.Context) (*DeleteLogSubscriptionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteLogSubscriptionResponse{
		DeleteLogSubscriptionOutput: r.Request.Data.(*DeleteLogSubscriptionOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteLogSubscriptionResponse is the response type for the
// DeleteLogSubscription API operation.
type DeleteLogSubscriptionResponse struct {
	*DeleteLogSubscriptionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteLogSubscription request.
func (r *DeleteLogSubscriptionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
