// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package connectparticipant

import (
	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Connection credentials.
type ConnectionCredentials struct {
	_ struct{} `type:"structure"`

	// The connection token.
	ConnectionToken *string `min:"1" type:"string"`

	// The expiration of the token.
	//
	// It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example,
	// 2019-11-08T02:41:28.172Z.
	Expiry *string `type:"string"`
}

// String returns the string representation
func (s ConnectionCredentials) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ConnectionCredentials) MarshalFields(e protocol.FieldEncoder) error {
	if s.ConnectionToken != nil {
		v := *s.ConnectionToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConnectionToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Expiry != nil {
		v := *s.Expiry

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Expiry", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An item - message or event - that has been sent.
type Item struct {
	_ struct{} `type:"structure"`

	// The time when the message or event was sent.
	//
	// It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example,
	// 2019-11-08T02:41:28.172Z.
	AbsoluteTime *string `min:"1" type:"string"`

	// The content of the message or event.
	Content *string `min:"1" type:"string"`

	// The type of content of the item.
	ContentType *string `min:"1" type:"string"`

	// The chat display name of the sender.
	DisplayName *string `min:"1" type:"string"`

	// The ID of the item.
	Id *string `min:"1" type:"string"`

	// The ID of the sender in the session.
	ParticipantId *string `min:"1" type:"string"`

	// The role of the sender. For example, is it a customer, agent, or system.
	ParticipantRole ParticipantRole `type:"string" enum:"true"`

	// Type of the item: message or event.
	Type ChatItemType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Item) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Item) MarshalFields(e protocol.FieldEncoder) error {
	if s.AbsoluteTime != nil {
		v := *s.AbsoluteTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AbsoluteTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Content != nil {
		v := *s.Content

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Content", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ContentType != nil {
		v := *s.ContentType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContentType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DisplayName != nil {
		v := *s.DisplayName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DisplayName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ParticipantId != nil {
		v := *s.ParticipantId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ParticipantId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ParticipantRole) > 0 {
		v := s.ParticipantRole

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ParticipantRole", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// A filtering option for where to start. For example, if you sent 100 messages,
// start with message 50.
type StartPosition struct {
	_ struct{} `type:"structure"`

	// The time in ISO format where to start.
	//
	// It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example,
	// 2019-11-08T02:41:28.172Z.
	AbsoluteTime *string `min:"1" type:"string"`

	// The ID of the message or event where to start.
	Id *string `min:"1" type:"string"`

	// The start position of the most recent message where you want to start.
	MostRecent *int64 `type:"integer"`
}

// String returns the string representation
func (s StartPosition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartPosition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartPosition"}
	if s.AbsoluteTime != nil && len(*s.AbsoluteTime) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AbsoluteTime", 1))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StartPosition) MarshalFields(e protocol.FieldEncoder) error {
	if s.AbsoluteTime != nil {
		v := *s.AbsoluteTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AbsoluteTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MostRecent != nil {
		v := *s.MostRecent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MostRecent", protocol.Int64Value(v), metadata)
	}
	return nil
}

// The websocket for the participant's connection.
type Websocket struct {
	_ struct{} `type:"structure"`

	// The URL expiration timestamp in ISO date format.
	//
	// It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example,
	// 2019-11-08T02:41:28.172Z.
	ConnectionExpiry *string `type:"string"`

	// The URL of the websocket.
	Url *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Websocket) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Websocket) MarshalFields(e protocol.FieldEncoder) error {
	if s.ConnectionExpiry != nil {
		v := *s.ConnectionExpiry

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConnectionExpiry", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Url != nil {
		v := *s.Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
