// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the request to stop the user import job.
type StopUserImportJobInput struct {
	_ struct{} `type:"structure"`

	// The job ID for the user import job.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool that the users are being imported into.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopUserImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopUserImportJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopUserImportJobInput"}

	if s.JobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobId", 1))
	}

	if s.UserPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server to the request to stop the user import
// job.
type StopUserImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The job object that represents the user import job.
	UserImportJob *UserImportJobType `type:"structure"`
}

// String returns the string representation
func (s StopUserImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopUserImportJob = "StopUserImportJob"

// StopUserImportJobRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Stops the user import job.
//
//    // Example sending a request using StopUserImportJobRequest.
//    req := client.StopUserImportJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/StopUserImportJob
func (c *Client) StopUserImportJobRequest(input *StopUserImportJobInput) StopUserImportJobRequest {
	op := &aws.Operation{
		Name:       opStopUserImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopUserImportJobInput{}
	}

	req := c.newRequest(op, input, &StopUserImportJobOutput{})
	return StopUserImportJobRequest{Request: req, Input: input, Copy: c.StopUserImportJobRequest}
}

// StopUserImportJobRequest is the request type for the
// StopUserImportJob API operation.
type StopUserImportJobRequest struct {
	*aws.Request
	Input *StopUserImportJobInput
	Copy  func(*StopUserImportJobInput) StopUserImportJobRequest
}

// Send marshals and sends the StopUserImportJob API request.
func (r StopUserImportJobRequest) Send(ctx context.Context) (*StopUserImportJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopUserImportJobResponse{
		StopUserImportJobOutput: r.Request.Data.(*StopUserImportJobOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopUserImportJobResponse is the response type for the
// StopUserImportJob API operation.
type StopUserImportJobResponse struct {
	*StopUserImportJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopUserImportJob request.
func (r *StopUserImportJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
