---
title: v0.19.0
weight: 999981000
---

## Prevent mangling of Ansible variable names containing special words by the Ansible operator

Input variable names containing special words IP, HTTP, and URL were incorrectly converted to contiguous lowercase
snake case. [#3265](https://github.com/operator-framework/operator-sdk/pull/3265) fixes this issue, and the Ansible
operator now correctly wraps special words in underscores and lower-cases them within snake-cased variable names.
For example:

```
  egressIPs                    -->  egress_ips

  URLsegressIPsEgressHTTPs     -->  _urls_egress_ips_egress_https
```

Nothing needs to be changed in an existing project to fix this issue.

_See [#3265](https://github.com/operator-framework/operator-sdk/pull/3265) for more details._

## Migrating Go projects to the new Kubebuilder aligned project layout

See the [migration guide][migration-guide] that walks through an example of how
to migrate a Go based operator project from the old layout to the new layout.

_See [#3190](https://github.com/operator-framework/operator-sdk/pull/3190) for more details._

## Helm: rename condition reason `UpdateSuccessful` to `UpgradeSuccessful`

For Helm-based operators to be more aligned with Helm, the `UpdateSuccessful` condition
reason was renamed to `UpgradeSuccessful` for the `ReleaseFailed` condition.
Note that this is **NOT** a breaking change for Helm-based operators themselves.
However, any script or code that is depending on this condition reason must be updated
to use `UpgradeSuccessful` instead of `UpdateSuccessful`.

_See [#3345](https://github.com/operator-framework/operator-sdk/pull/3345) for more details._

## Helm: rename condition reason `UpdateError` to `UpgradeError`

For Helm-based operators to be more aligned with Helm, the `UpdateError` condition
reason was renamed to `UpgradeError` for the `ReleaseFailed` condition.
Note that this is **NOT** a breaking change for Helm-based operators themselves.
However, any script or code that is depending on this condition reason must be updated
to use `UpgradeError` instead of `UpdateError`.

_See [#3269](https://github.com/operator-framework/operator-sdk/pull/3269) for more details._

[migration-guide]: /docs/building-operators/golang/migration/
