/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by protoc-gen-go. DO NOT EDIT.
// source: konnectivity-client/proto/client/client.proto

package client

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type PacketType int32

const (
	PacketType_DIAL_REQ  PacketType = 0
	PacketType_DIAL_RSP  PacketType = 1
	PacketType_CLOSE_REQ PacketType = 2
	PacketType_CLOSE_RSP PacketType = 3
	PacketType_DATA      PacketType = 4
	PacketType_DIAL_CLS  PacketType = 5
)

var PacketType_name = map[int32]string{
	0: "DIAL_REQ",
	1: "DIAL_RSP",
	2: "CLOSE_REQ",
	3: "CLOSE_RSP",
	4: "DATA",
	5: "DIAL_CLS",
}

var PacketType_value = map[string]int32{
	"DIAL_REQ":  0,
	"DIAL_RSP":  1,
	"CLOSE_REQ": 2,
	"CLOSE_RSP": 3,
	"DATA":      4,
	"DIAL_CLS":  5,
}

func (x PacketType) String() string {
	return proto.EnumName(PacketType_name, int32(x))
}

func (PacketType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_fec4258d9ecd175d, []int{0}
}

type Error int32

const (
	Error_EOF Error = 0
)

var Error_name = map[int32]string{
	0: "EOF",
}

var Error_value = map[string]int32{
	"EOF": 0,
}

func (x Error) String() string {
	return proto.EnumName(Error_name, int32(x))
}

func (Error) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_fec4258d9ecd175d, []int{1}
}

type Packet struct {
	Type PacketType `protobuf:"varint,1,opt,name=type,proto3,enum=PacketType" json:"type,omitempty"`
	// Types that are valid to be assigned to Payload:
	//	*Packet_DialRequest
	//	*Packet_DialResponse
	//	*Packet_Data
	//	*Packet_CloseRequest
	//	*Packet_CloseResponse
	//	*Packet_CloseDial
	Payload              isPacket_Payload `protobuf_oneof:"payload"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Packet) Reset()         { *m = Packet{} }
func (m *Packet) String() string { return proto.CompactTextString(m) }
func (*Packet) ProtoMessage()    {}
func (*Packet) Descriptor() ([]byte, []int) {
	return fileDescriptor_fec4258d9ecd175d, []int{0}
}

func (m *Packet) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Packet.Unmarshal(m, b)
}
func (m *Packet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Packet.Marshal(b, m, deterministic)
}
func (m *Packet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Packet.Merge(m, src)
}
func (m *Packet) XXX_Size() int {
	return xxx_messageInfo_Packet.Size(m)
}
func (m *Packet) XXX_DiscardUnknown() {
	xxx_messageInfo_Packet.DiscardUnknown(m)
}

var xxx_messageInfo_Packet proto.InternalMessageInfo

func (m *Packet) GetType() PacketType {
	if m != nil {
		return m.Type
	}
	return PacketType_DIAL_REQ
}

type isPacket_Payload interface {
	isPacket_Payload()
}

type Packet_DialRequest struct {
	DialRequest *DialRequest `protobuf:"bytes,2,opt,name=dialRequest,proto3,oneof"`
}

type Packet_DialResponse struct {
	DialResponse *DialResponse `protobuf:"bytes,3,opt,name=dialResponse,proto3,oneof"`
}

type Packet_Data struct {
	Data *Data `protobuf:"bytes,4,opt,name=data,proto3,oneof"`
}

type Packet_CloseRequest struct {
	CloseRequest *CloseRequest `protobuf:"bytes,5,opt,name=closeRequest,proto3,oneof"`
}

type Packet_CloseResponse struct {
	CloseResponse *CloseResponse `protobuf:"bytes,6,opt,name=closeResponse,proto3,oneof"`
}

type Packet_CloseDial struct {
	CloseDial *CloseDial `protobuf:"bytes,7,opt,name=closeDial,proto3,oneof"`
}

func (*Packet_DialRequest) isPacket_Payload() {}

func (*Packet_DialResponse) isPacket_Payload() {}

func (*Packet_Data) isPacket_Payload() {}

func (*Packet_CloseRequest) isPacket_Payload() {}

func (*Packet_CloseResponse) isPacket_Payload() {}

func (*Packet_CloseDial) isPacket_Payload() {}

func (m *Packet) GetPayload() isPacket_Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *Packet) GetDialRequest() *DialRequest {
	if x, ok := m.GetPayload().(*Packet_DialRequest); ok {
		return x.DialRequest
	}
	return nil
}

func (m *Packet) GetDialResponse() *DialResponse {
	if x, ok := m.GetPayload().(*Packet_DialResponse); ok {
		return x.DialResponse
	}
	return nil
}

func (m *Packet) GetData() *Data {
	if x, ok := m.GetPayload().(*Packet_Data); ok {
		return x.Data
	}
	return nil
}

func (m *Packet) GetCloseRequest() *CloseRequest {
	if x, ok := m.GetPayload().(*Packet_CloseRequest); ok {
		return x.CloseRequest
	}
	return nil
}

func (m *Packet) GetCloseResponse() *CloseResponse {
	if x, ok := m.GetPayload().(*Packet_CloseResponse); ok {
		return x.CloseResponse
	}
	return nil
}

func (m *Packet) GetCloseDial() *CloseDial {
	if x, ok := m.GetPayload().(*Packet_CloseDial); ok {
		return x.CloseDial
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Packet) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Packet_DialRequest)(nil),
		(*Packet_DialResponse)(nil),
		(*Packet_Data)(nil),
		(*Packet_CloseRequest)(nil),
		(*Packet_CloseResponse)(nil),
		(*Packet_CloseDial)(nil),
	}
}

type DialRequest struct {
	// tcp or udp?
	Protocol string `protobuf:"bytes,1,opt,name=protocol,proto3" json:"protocol,omitempty"`
	// node:port
	Address string `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	// random id for client, maybe should be longer
	Random               int64    `protobuf:"varint,3,opt,name=random,proto3" json:"random,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DialRequest) Reset()         { *m = DialRequest{} }
func (m *DialRequest) String() string { return proto.CompactTextString(m) }
func (*DialRequest) ProtoMessage()    {}
func (*DialRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fec4258d9ecd175d, []int{1}
}

func (m *DialRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DialRequest.Unmarshal(m, b)
}
func (m *DialRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DialRequest.Marshal(b, m, deterministic)
}
func (m *DialRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DialRequest.Merge(m, src)
}
func (m *DialRequest) XXX_Size() int {
	return xxx_messageInfo_DialRequest.Size(m)
}
func (m *DialRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DialRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DialRequest proto.InternalMessageInfo

func (m *DialRequest) GetProtocol() string {
	if m != nil {
		return m.Protocol
	}
	return ""
}

func (m *DialRequest) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *DialRequest) GetRandom() int64 {
	if m != nil {
		return m.Random
	}
	return 0
}

type DialResponse struct {
	// error failed reason; enum?
	Error string `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	// connectID indicates the identifier of the connection
	ConnectID int64 `protobuf:"varint,2,opt,name=connectID,proto3" json:"connectID,omitempty"`
	// random copied from DialRequest
	Random               int64    `protobuf:"varint,3,opt,name=random,proto3" json:"random,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DialResponse) Reset()         { *m = DialResponse{} }
func (m *DialResponse) String() string { return proto.CompactTextString(m) }
func (*DialResponse) ProtoMessage()    {}
func (*DialResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_fec4258d9ecd175d, []int{2}
}

func (m *DialResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DialResponse.Unmarshal(m, b)
}
func (m *DialResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DialResponse.Marshal(b, m, deterministic)
}
func (m *DialResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DialResponse.Merge(m, src)
}
func (m *DialResponse) XXX_Size() int {
	return xxx_messageInfo_DialResponse.Size(m)
}
func (m *DialResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DialResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DialResponse proto.InternalMessageInfo

func (m *DialResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *DialResponse) GetConnectID() int64 {
	if m != nil {
		return m.ConnectID
	}
	return 0
}

func (m *DialResponse) GetRandom() int64 {
	if m != nil {
		return m.Random
	}
	return 0
}

type CloseRequest struct {
	// connectID of the stream to close
	ConnectID            int64    `protobuf:"varint,1,opt,name=connectID,proto3" json:"connectID,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CloseRequest) Reset()         { *m = CloseRequest{} }
func (m *CloseRequest) String() string { return proto.CompactTextString(m) }
func (*CloseRequest) ProtoMessage()    {}
func (*CloseRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fec4258d9ecd175d, []int{3}
}

func (m *CloseRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CloseRequest.Unmarshal(m, b)
}
func (m *CloseRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CloseRequest.Marshal(b, m, deterministic)
}
func (m *CloseRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloseRequest.Merge(m, src)
}
func (m *CloseRequest) XXX_Size() int {
	return xxx_messageInfo_CloseRequest.Size(m)
}
func (m *CloseRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CloseRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CloseRequest proto.InternalMessageInfo

func (m *CloseRequest) GetConnectID() int64 {
	if m != nil {
		return m.ConnectID
	}
	return 0
}

type CloseResponse struct {
	// error message
	Error string `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	// connectID indicates the identifier of the connection
	ConnectID            int64    `protobuf:"varint,2,opt,name=connectID,proto3" json:"connectID,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CloseResponse) Reset()         { *m = CloseResponse{} }
func (m *CloseResponse) String() string { return proto.CompactTextString(m) }
func (*CloseResponse) ProtoMessage()    {}
func (*CloseResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_fec4258d9ecd175d, []int{4}
}

func (m *CloseResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CloseResponse.Unmarshal(m, b)
}
func (m *CloseResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CloseResponse.Marshal(b, m, deterministic)
}
func (m *CloseResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloseResponse.Merge(m, src)
}
func (m *CloseResponse) XXX_Size() int {
	return xxx_messageInfo_CloseResponse.Size(m)
}
func (m *CloseResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CloseResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CloseResponse proto.InternalMessageInfo

func (m *CloseResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *CloseResponse) GetConnectID() int64 {
	if m != nil {
		return m.ConnectID
	}
	return 0
}

type CloseDial struct {
	// random id of the DialRequest
	Random               int64    `protobuf:"varint,1,opt,name=random,proto3" json:"random,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CloseDial) Reset()         { *m = CloseDial{} }
func (m *CloseDial) String() string { return proto.CompactTextString(m) }
func (*CloseDial) ProtoMessage()    {}
func (*CloseDial) Descriptor() ([]byte, []int) {
	return fileDescriptor_fec4258d9ecd175d, []int{5}
}

func (m *CloseDial) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CloseDial.Unmarshal(m, b)
}
func (m *CloseDial) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CloseDial.Marshal(b, m, deterministic)
}
func (m *CloseDial) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloseDial.Merge(m, src)
}
func (m *CloseDial) XXX_Size() int {
	return xxx_messageInfo_CloseDial.Size(m)
}
func (m *CloseDial) XXX_DiscardUnknown() {
	xxx_messageInfo_CloseDial.DiscardUnknown(m)
}

var xxx_messageInfo_CloseDial proto.InternalMessageInfo

func (m *CloseDial) GetRandom() int64 {
	if m != nil {
		return m.Random
	}
	return 0
}

type Data struct {
	// connectID to connect to
	ConnectID int64 `protobuf:"varint,1,opt,name=connectID,proto3" json:"connectID,omitempty"`
	// error message if error happens
	Error string `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// stream data
	Data                 []byte   `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Data) Reset()         { *m = Data{} }
func (m *Data) String() string { return proto.CompactTextString(m) }
func (*Data) ProtoMessage()    {}
func (*Data) Descriptor() ([]byte, []int) {
	return fileDescriptor_fec4258d9ecd175d, []int{6}
}

func (m *Data) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Data.Unmarshal(m, b)
}
func (m *Data) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Data.Marshal(b, m, deterministic)
}
func (m *Data) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Data.Merge(m, src)
}
func (m *Data) XXX_Size() int {
	return xxx_messageInfo_Data.Size(m)
}
func (m *Data) XXX_DiscardUnknown() {
	xxx_messageInfo_Data.DiscardUnknown(m)
}

var xxx_messageInfo_Data proto.InternalMessageInfo

func (m *Data) GetConnectID() int64 {
	if m != nil {
		return m.ConnectID
	}
	return 0
}

func (m *Data) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *Data) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func init() {
	proto.RegisterEnum("PacketType", PacketType_name, PacketType_value)
	proto.RegisterEnum("Error", Error_name, Error_value)
	proto.RegisterType((*Packet)(nil), "Packet")
	proto.RegisterType((*DialRequest)(nil), "DialRequest")
	proto.RegisterType((*DialResponse)(nil), "DialResponse")
	proto.RegisterType((*CloseRequest)(nil), "CloseRequest")
	proto.RegisterType((*CloseResponse)(nil), "CloseResponse")
	proto.RegisterType((*CloseDial)(nil), "CloseDial")
	proto.RegisterType((*Data)(nil), "Data")
}

func init() {
	proto.RegisterFile("konnectivity-client/proto/client/client.proto", fileDescriptor_fec4258d9ecd175d)
}

var fileDescriptor_fec4258d9ecd175d = []byte{
	// 505 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x53, 0x51, 0x8b, 0xd3, 0x40,
	0x18, 0x4c, 0xda, 0xa4, 0x6d, 0xbe, 0xa6, 0x47, 0x58, 0x44, 0xc2, 0x29, 0xdc, 0x11, 0x5f, 0x4a,
	0xb1, 0xe9, 0xd1, 0x03, 0xf1, 0xb5, 0xd7, 0xf4, 0xe8, 0x41, 0xf1, 0xea, 0xf6, 0x9e, 0x4e, 0x50,
	0xd6, 0x64, 0x91, 0xd0, 0x98, 0x8d, 0xbb, 0x6b, 0x35, 0x3f, 0xd3, 0x7f, 0x24, 0xd9, 0xa4, 0x4d,
	0x22, 0xa8, 0x70, 0x4f, 0xed, 0xcc, 0x7e, 0x33, 0x3b, 0x19, 0xbe, 0x85, 0xe9, 0x9e, 0xa5, 0x29,
	0x0d, 0x65, 0x7c, 0x88, 0x65, 0x3e, 0x0d, 0x93, 0x98, 0xa6, 0x72, 0x96, 0x71, 0x26, 0xd9, 0xac,
	0x02, 0xe5, 0x8f, 0xaf, 0x38, 0xef, 0x57, 0x07, 0x7a, 0x5b, 0x12, 0xee, 0xa9, 0x44, 0x17, 0x60,
	0xc8, 0x3c, 0xa3, 0xae, 0x7e, 0xa9, 0x8f, 0xcf, 0xe6, 0x43, 0xbf, 0xa4, 0x1f, 0xf2, 0x8c, 0x62,
	0x75, 0x80, 0xae, 0x60, 0x18, 0xc5, 0x24, 0xc1, 0xf4, 0xdb, 0x77, 0x2a, 0xa4, 0xdb, 0xb9, 0xd4,
	0xc7, 0xc3, 0xb9, 0xed, 0x07, 0x35, 0xb7, 0xd6, 0x70, 0x73, 0x04, 0x5d, 0x83, 0x5d, 0x42, 0x91,
	0xb1, 0x54, 0x50, 0xb7, 0xab, 0x24, 0xa3, 0x4a, 0x52, 0x92, 0x6b, 0x0d, 0xb7, 0x86, 0xd0, 0x0b,
	0x30, 0x22, 0x22, 0x89, 0x6b, 0xa8, 0x61, 0xd3, 0x0f, 0x88, 0x24, 0x6b, 0x0d, 0x2b, 0xb2, 0x70,
	0x0c, 0x13, 0x26, 0xe8, 0x31, 0x84, 0x59, 0x39, 0x2e, 0x1b, 0x64, 0xe1, 0xd8, 0x1c, 0x42, 0x6f,
	0x60, 0x54, 0xe1, 0x2a, 0x47, 0x4f, 0xa9, 0xce, 0x8e, 0xaa, 0x53, 0x90, 0xf6, 0x18, 0x9a, 0x80,
	0xa5, 0x88, 0x22, 0xae, 0xdb, 0x57, 0x1a, 0x28, 0x35, 0x05, 0xb3, 0xd6, 0x70, 0x7d, 0x7c, 0x63,
	0x41, 0x3f, 0x23, 0x79, 0xc2, 0x48, 0xe4, 0x7d, 0x80, 0x61, 0xa3, 0x13, 0x74, 0x0e, 0x03, 0xd5,
	0x75, 0xc8, 0x12, 0xd5, 0xad, 0x85, 0x4f, 0x18, 0xb9, 0xd0, 0x27, 0x51, 0xc4, 0xa9, 0x10, 0xaa,
	0x4e, 0x0b, 0x1f, 0x21, 0x7a, 0x0e, 0x3d, 0x4e, 0xd2, 0x88, 0x7d, 0x55, 0xa5, 0x75, 0x71, 0x85,
	0xbc, 0x47, 0xb0, 0x9b, 0xed, 0xa1, 0x67, 0x60, 0x52, 0xce, 0x19, 0xaf, 0xac, 0x4b, 0x80, 0x5e,
	0x82, 0x15, 0x96, 0x7b, 0x70, 0x17, 0x28, 0xe7, 0x2e, 0xae, 0x89, 0xbf, 0x7a, 0xbf, 0x06, 0xbb,
	0xd9, 0x63, 0xdb, 0x45, 0xff, 0xc3, 0xc5, 0x5b, 0xc2, 0xa8, 0xd5, 0xdf, 0x53, 0xa2, 0x78, 0xaf,
	0xc0, 0x3a, 0x15, 0xda, 0xc8, 0xa5, 0xb7, 0x72, 0xbd, 0x03, 0xa3, 0x58, 0x82, 0x7f, 0xe7, 0xa9,
	0xaf, 0xef, 0x34, 0xaf, 0x47, 0xd5, 0x36, 0x15, 0x5f, 0x6a, 0x97, 0x4b, 0x34, 0xf9, 0x08, 0x50,
	0x2f, 0x37, 0xb2, 0x61, 0x10, 0xdc, 0x2d, 0x36, 0x9f, 0xf0, 0xea, 0xbd, 0xa3, 0xd5, 0x68, 0xb7,
	0x75, 0x74, 0x34, 0x02, 0x6b, 0xb9, 0xb9, 0xdf, 0xad, 0xd4, 0x61, 0xa7, 0x01, 0x77, 0x5b, 0xa7,
	0x8b, 0x06, 0x60, 0x04, 0x8b, 0x87, 0x85, 0x63, 0x9c, 0x54, 0xcb, 0xcd, 0xce, 0x31, 0x27, 0x0e,
	0x98, 0x2b, 0x75, 0x79, 0x1f, 0xba, 0xab, 0xfb, 0x5b, 0x47, 0x9b, 0xcf, 0xc0, 0xde, 0x72, 0xf6,
	0x33, 0xdf, 0x51, 0x7e, 0x88, 0x43, 0x8a, 0x2e, 0xc0, 0x54, 0x18, 0xf5, 0xab, 0x67, 0x76, 0x7e,
	0xfc, 0xe3, 0x69, 0x63, 0xfd, 0x4a, 0xbf, 0xb9, 0x7d, 0x0c, 0x44, 0xfc, 0x45, 0xf8, 0xfb, 0xb7,
	0xc2, 0x8f, 0xd9, 0x8c, 0x64, 0xb1, 0xa0, 0xfc, 0x40, 0xf9, 0x34, 0xa5, 0xf2, 0x07, 0xe3, 0xfb,
	0x69, 0x56, 0xc8, 0x67, 0xff, 0x7b, 0xec, 0x9f, 0x7b, 0x0a, 0x5d, 0xff, 0x0e, 0x00, 0x00, 0xff,
	0xff, 0x38, 0x1b, 0xf6, 0x4f, 0x17, 0x04, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ProxyServiceClient is the client API for ProxyService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ProxyServiceClient interface {
	Proxy(ctx context.Context, opts ...grpc.CallOption) (ProxyService_ProxyClient, error)
}

type proxyServiceClient struct {
	cc *grpc.ClientConn
}

func NewProxyServiceClient(cc *grpc.ClientConn) ProxyServiceClient {
	return &proxyServiceClient{cc}
}

func (c *proxyServiceClient) Proxy(ctx context.Context, opts ...grpc.CallOption) (ProxyService_ProxyClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ProxyService_serviceDesc.Streams[0], "/ProxyService/Proxy", opts...)
	if err != nil {
		return nil, err
	}
	x := &proxyServiceProxyClient{stream}
	return x, nil
}

type ProxyService_ProxyClient interface {
	Send(*Packet) error
	Recv() (*Packet, error)
	grpc.ClientStream
}

type proxyServiceProxyClient struct {
	grpc.ClientStream
}

func (x *proxyServiceProxyClient) Send(m *Packet) error {
	return x.ClientStream.SendMsg(m)
}

func (x *proxyServiceProxyClient) Recv() (*Packet, error) {
	m := new(Packet)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// ProxyServiceServer is the server API for ProxyService service.
type ProxyServiceServer interface {
	Proxy(ProxyService_ProxyServer) error
}

// UnimplementedProxyServiceServer can be embedded to have forward compatible implementations.
type UnimplementedProxyServiceServer struct {
}

func (*UnimplementedProxyServiceServer) Proxy(srv ProxyService_ProxyServer) error {
	return status.Errorf(codes.Unimplemented, "method Proxy not implemented")
}

func RegisterProxyServiceServer(s *grpc.Server, srv ProxyServiceServer) {
	s.RegisterService(&_ProxyService_serviceDesc, srv)
}

func _ProxyService_Proxy_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ProxyServiceServer).Proxy(&proxyServiceProxyServer{stream})
}

type ProxyService_ProxyServer interface {
	Send(*Packet) error
	Recv() (*Packet, error)
	grpc.ServerStream
}

type proxyServiceProxyServer struct {
	grpc.ServerStream
}

func (x *proxyServiceProxyServer) Send(m *Packet) error {
	return x.ServerStream.SendMsg(m)
}

func (x *proxyServiceProxyServer) Recv() (*Packet, error) {
	m := new(Packet)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _ProxyService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "ProxyService",
	HandlerType: (*ProxyServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Proxy",
			Handler:       _ProxyService_Proxy_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "konnectivity-client/proto/client/client.proto",
}
