import * as React from 'react';
import { SecurityIcon } from '@patternfly/react-icons';
import * as classNames from 'classnames';
import { RowFunctionArgs, TableData } from '@console/internal/components/factory';
import { ExternalLink } from '@console/internal/components/utils';
import { priorityFor } from '../const';
import { Feature, Vulnerability } from '../types';

type ImageVulnerabilityRowProps = {
  vulnerability: Vulnerability;
  feature: Feature;
};

export const imageVulnerabilitiesTableColumnClasses = [
  '',
  '',
  classNames('pf-m-hidden', 'pf-m-visible-on-md'),
  classNames('pf-m-hidden', 'pf-m-visible-on-md'),
  classNames('pf-m-hidden', 'pf-m-visible-on-lg'),
];

const ImageVulnerabilityRow: React.FC<RowFunctionArgs<ImageVulnerabilityRowProps>> = (props) => {
  const {
    obj: { vulnerability, feature },
  } = props;
  return (
    <>
      <TableData className={imageVulnerabilitiesTableColumnClasses[0]}>
        <ExternalLink text={vulnerability.name} href={vulnerability.link} />
      </TableData>
      <TableData className={imageVulnerabilitiesTableColumnClasses[1]}>
        <SecurityIcon color={priorityFor(vulnerability.severity).color.value} />
        &nbsp;{vulnerability.severity}
      </TableData>
      <TableData className={imageVulnerabilitiesTableColumnClasses[2]}>{feature.name}</TableData>
      <TableData className={imageVulnerabilitiesTableColumnClasses[3]}>{feature.version}</TableData>
      <TableData className={imageVulnerabilitiesTableColumnClasses[4]}>
        {vulnerability.fixedby || '-'}
      </TableData>
    </>
  );
};

export default ImageVulnerabilityRow;
