# platform = multi_platform_ol,multi_platform_rhel,multi_platform_ubuntu,multi_platform_sle
# reboot = false
# strategy = restrict
# complexity = low
# disruption = low

{{{ bash_package_install("aide") }}}

{{% set auditfiles = [
      "/usr/sbin/auditctl",
      "/usr/sbin/auditd",
      "/usr/sbin/ausearch",
      "/usr/sbin/aureport",
      "/usr/sbin/autrace",
      "/usr/sbin/augenrules" ] %}}

{{% if 'rhel' not in product and product != 'ol8' %}}
{{% set auditfiles = auditfiles + ["/usr/sbin/audispd"] %}}
{{% endif %}}

{{% if product == 'ol8' %}}
{{% set auditfiles = auditfiles + ["/usr/sbin/rsyslogd"] %}}
{{% endif %}}

{{% if 'rhel' not in product and product != 'ol8' %}}
{{% set configString = 'p+i+n+u+g+s+b+acl+selinux+xattrs+sha512' %}}
{{% else %}}
{{% set configString = "p+i+n+u+g+s+b+acl+xattrs+sha512" %}}
{{% endif %}}

{{% for file in auditfiles %}}

if grep -i '^.*{{{file}}}.*$' {{{ aide_conf_path }}}; then
sed -i "s#.*{{{file}}}.*#{{{file}}} {{{ configString }}}#" {{{ aide_conf_path }}}
else
echo "{{{ file }}} {{{ configString }}}" >> {{{ aide_conf_path }}}
fi
{{% endfor %}}
