/*
Copyright 2021.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "github.com/openshift-kni/numaresources-operator/api/numaresourcesoperator/v1alpha1"
	scheme "github.com/openshift-kni/numaresources-operator/pkg/k8sclientset/generated/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// NUMAResourcesSchedulersGetter has a method to return a NUMAResourcesSchedulerInterface.
// A group's client should implement this interface.
type NUMAResourcesSchedulersGetter interface {
	NUMAResourcesSchedulers() NUMAResourcesSchedulerInterface
}

// NUMAResourcesSchedulerInterface has methods to work with NUMAResourcesScheduler resources.
type NUMAResourcesSchedulerInterface interface {
	Create(ctx context.Context, nUMAResourcesScheduler *v1alpha1.NUMAResourcesScheduler, opts v1.CreateOptions) (*v1alpha1.NUMAResourcesScheduler, error)
	Update(ctx context.Context, nUMAResourcesScheduler *v1alpha1.NUMAResourcesScheduler, opts v1.UpdateOptions) (*v1alpha1.NUMAResourcesScheduler, error)
	UpdateStatus(ctx context.Context, nUMAResourcesScheduler *v1alpha1.NUMAResourcesScheduler, opts v1.UpdateOptions) (*v1alpha1.NUMAResourcesScheduler, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.NUMAResourcesScheduler, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.NUMAResourcesSchedulerList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.NUMAResourcesScheduler, err error)
	NUMAResourcesSchedulerExpansion
}

// nUMAResourcesSchedulers implements NUMAResourcesSchedulerInterface
type nUMAResourcesSchedulers struct {
	client rest.Interface
}

// newNUMAResourcesSchedulers returns a NUMAResourcesSchedulers
func newNUMAResourcesSchedulers(c *NumaresourcesoperatorV1alpha1Client) *nUMAResourcesSchedulers {
	return &nUMAResourcesSchedulers{
		client: c.RESTClient(),
	}
}

// Get takes name of the nUMAResourcesScheduler, and returns the corresponding nUMAResourcesScheduler object, and an error if there is any.
func (c *nUMAResourcesSchedulers) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.NUMAResourcesScheduler, err error) {
	result = &v1alpha1.NUMAResourcesScheduler{}
	err = c.client.Get().
		Resource("numaresourcesschedulers").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of NUMAResourcesSchedulers that match those selectors.
func (c *nUMAResourcesSchedulers) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.NUMAResourcesSchedulerList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.NUMAResourcesSchedulerList{}
	err = c.client.Get().
		Resource("numaresourcesschedulers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested nUMAResourcesSchedulers.
func (c *nUMAResourcesSchedulers) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("numaresourcesschedulers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a nUMAResourcesScheduler and creates it.  Returns the server's representation of the nUMAResourcesScheduler, and an error, if there is any.
func (c *nUMAResourcesSchedulers) Create(ctx context.Context, nUMAResourcesScheduler *v1alpha1.NUMAResourcesScheduler, opts v1.CreateOptions) (result *v1alpha1.NUMAResourcesScheduler, err error) {
	result = &v1alpha1.NUMAResourcesScheduler{}
	err = c.client.Post().
		Resource("numaresourcesschedulers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(nUMAResourcesScheduler).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a nUMAResourcesScheduler and updates it. Returns the server's representation of the nUMAResourcesScheduler, and an error, if there is any.
func (c *nUMAResourcesSchedulers) Update(ctx context.Context, nUMAResourcesScheduler *v1alpha1.NUMAResourcesScheduler, opts v1.UpdateOptions) (result *v1alpha1.NUMAResourcesScheduler, err error) {
	result = &v1alpha1.NUMAResourcesScheduler{}
	err = c.client.Put().
		Resource("numaresourcesschedulers").
		Name(nUMAResourcesScheduler.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(nUMAResourcesScheduler).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *nUMAResourcesSchedulers) UpdateStatus(ctx context.Context, nUMAResourcesScheduler *v1alpha1.NUMAResourcesScheduler, opts v1.UpdateOptions) (result *v1alpha1.NUMAResourcesScheduler, err error) {
	result = &v1alpha1.NUMAResourcesScheduler{}
	err = c.client.Put().
		Resource("numaresourcesschedulers").
		Name(nUMAResourcesScheduler.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(nUMAResourcesScheduler).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the nUMAResourcesScheduler and deletes it. Returns an error if one occurs.
func (c *nUMAResourcesSchedulers) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("numaresourcesschedulers").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *nUMAResourcesSchedulers) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("numaresourcesschedulers").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched nUMAResourcesScheduler.
func (c *nUMAResourcesSchedulers) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.NUMAResourcesScheduler, err error) {
	result = &v1alpha1.NUMAResourcesScheduler{}
	err = c.client.Patch(pt).
		Resource("numaresourcesschedulers").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
