// Copyright 2021 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package compute provides access to the Compute Engine API.
//
// For product documentation, see: https://developers.google.com/compute/docs/reference/latest/
//
// Creating a client
//
// Usage example:
//
//   import "google.golang.org/api/compute/v0.alpha"
//   ...
//   ctx := context.Background()
//   computeService, err := compute.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate. To restrict scopes, use option.WithScopes:
//
//   computeService, err := compute.NewService(ctx, option.WithScopes(compute.DevstorageReadWriteScope))
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//   computeService, err := compute.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//   config := &oauth2.Config{...}
//   // ...
//   token, err := config.Exchange(ctx, ...)
//   computeService, err := compute.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package compute // import "google.golang.org/api/compute/v0.alpha"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "compute:alpha"
const apiName = "compute"
const apiVersion = "alpha"
const basePath = "https://compute.googleapis.com/compute/alpha/"
const mtlsBasePath = "https://compute.mtls.googleapis.com/compute/alpha/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud Platform data
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"

	// View and manage your Google Compute Engine resources
	ComputeScope = "https://www.googleapis.com/auth/compute"

	// View your Google Compute Engine resources
	ComputeReadonlyScope = "https://www.googleapis.com/auth/compute.readonly"

	// Manage your data and permissions in Google Cloud Storage
	DevstorageFullControlScope = "https://www.googleapis.com/auth/devstorage.full_control"

	// View your data in Google Cloud Storage
	DevstorageReadOnlyScope = "https://www.googleapis.com/auth/devstorage.read_only"

	// Manage your data in Google Cloud Storage
	DevstorageReadWriteScope = "https://www.googleapis.com/auth/devstorage.read_write"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := option.WithScopes(
		"https://www.googleapis.com/auth/cloud-platform",
		"https://www.googleapis.com/auth/compute",
		"https://www.googleapis.com/auth/compute.readonly",
		"https://www.googleapis.com/auth/devstorage.full_control",
		"https://www.googleapis.com/auth/devstorage.read_only",
		"https://www.googleapis.com/auth/devstorage.read_write",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.AcceleratorTypes = NewAcceleratorTypesService(s)
	s.Addresses = NewAddressesService(s)
	s.Autoscalers = NewAutoscalersService(s)
	s.BackendBuckets = NewBackendBucketsService(s)
	s.BackendServices = NewBackendServicesService(s)
	s.DiskTypes = NewDiskTypesService(s)
	s.Disks = NewDisksService(s)
	s.ExternalVpnGateways = NewExternalVpnGatewaysService(s)
	s.FirewallPolicies = NewFirewallPoliciesService(s)
	s.Firewalls = NewFirewallsService(s)
	s.ForwardingRules = NewForwardingRulesService(s)
	s.GlobalAddresses = NewGlobalAddressesService(s)
	s.GlobalForwardingRules = NewGlobalForwardingRulesService(s)
	s.GlobalNetworkEndpointGroups = NewGlobalNetworkEndpointGroupsService(s)
	s.GlobalOperations = NewGlobalOperationsService(s)
	s.GlobalOrganizationOperations = NewGlobalOrganizationOperationsService(s)
	s.GlobalPublicDelegatedPrefixes = NewGlobalPublicDelegatedPrefixesService(s)
	s.HealthChecks = NewHealthChecksService(s)
	s.HttpHealthChecks = NewHttpHealthChecksService(s)
	s.HttpsHealthChecks = NewHttpsHealthChecksService(s)
	s.ImageFamilyViews = NewImageFamilyViewsService(s)
	s.Images = NewImagesService(s)
	s.InstanceGroupManagers = NewInstanceGroupManagersService(s)
	s.InstanceGroups = NewInstanceGroupsService(s)
	s.InstanceTemplates = NewInstanceTemplatesService(s)
	s.Instances = NewInstancesService(s)
	s.InterconnectAttachments = NewInterconnectAttachmentsService(s)
	s.InterconnectLocations = NewInterconnectLocationsService(s)
	s.Interconnects = NewInterconnectsService(s)
	s.LicenseCodes = NewLicenseCodesService(s)
	s.Licenses = NewLicensesService(s)
	s.MachineImages = NewMachineImagesService(s)
	s.MachineTypes = NewMachineTypesService(s)
	s.NetworkEndpointGroups = NewNetworkEndpointGroupsService(s)
	s.NetworkFirewallPolicies = NewNetworkFirewallPoliciesService(s)
	s.Networks = NewNetworksService(s)
	s.NodeGroups = NewNodeGroupsService(s)
	s.NodeTemplates = NewNodeTemplatesService(s)
	s.NodeTypes = NewNodeTypesService(s)
	s.OrganizationSecurityPolicies = NewOrganizationSecurityPoliciesService(s)
	s.PacketMirrorings = NewPacketMirroringsService(s)
	s.Projects = NewProjectsService(s)
	s.PublicAdvertisedPrefixes = NewPublicAdvertisedPrefixesService(s)
	s.PublicDelegatedPrefixes = NewPublicDelegatedPrefixesService(s)
	s.RegionAutoscalers = NewRegionAutoscalersService(s)
	s.RegionBackendServices = NewRegionBackendServicesService(s)
	s.RegionCommitments = NewRegionCommitmentsService(s)
	s.RegionDiskTypes = NewRegionDiskTypesService(s)
	s.RegionDisks = NewRegionDisksService(s)
	s.RegionHealthCheckServices = NewRegionHealthCheckServicesService(s)
	s.RegionHealthChecks = NewRegionHealthChecksService(s)
	s.RegionInPlaceSnapshots = NewRegionInPlaceSnapshotsService(s)
	s.RegionInstanceGroupManagers = NewRegionInstanceGroupManagersService(s)
	s.RegionInstanceGroups = NewRegionInstanceGroupsService(s)
	s.RegionInstances = NewRegionInstancesService(s)
	s.RegionInstantSnapshots = NewRegionInstantSnapshotsService(s)
	s.RegionNetworkEndpointGroups = NewRegionNetworkEndpointGroupsService(s)
	s.RegionNetworkFirewallPolicies = NewRegionNetworkFirewallPoliciesService(s)
	s.RegionNotificationEndpoints = NewRegionNotificationEndpointsService(s)
	s.RegionOperations = NewRegionOperationsService(s)
	s.RegionSslCertificates = NewRegionSslCertificatesService(s)
	s.RegionTargetHttpProxies = NewRegionTargetHttpProxiesService(s)
	s.RegionTargetHttpsProxies = NewRegionTargetHttpsProxiesService(s)
	s.RegionUrlMaps = NewRegionUrlMapsService(s)
	s.Regions = NewRegionsService(s)
	s.Reservations = NewReservationsService(s)
	s.ResourcePolicies = NewResourcePoliciesService(s)
	s.Routers = NewRoutersService(s)
	s.Routes = NewRoutesService(s)
	s.SecurityPolicies = NewSecurityPoliciesService(s)
	s.ServiceAttachments = NewServiceAttachmentsService(s)
	s.Snapshots = NewSnapshotsService(s)
	s.SslCertificates = NewSslCertificatesService(s)
	s.SslPolicies = NewSslPoliciesService(s)
	s.Subnetworks = NewSubnetworksService(s)
	s.TargetGrpcProxies = NewTargetGrpcProxiesService(s)
	s.TargetHttpProxies = NewTargetHttpProxiesService(s)
	s.TargetHttpsProxies = NewTargetHttpsProxiesService(s)
	s.TargetInstances = NewTargetInstancesService(s)
	s.TargetPools = NewTargetPoolsService(s)
	s.TargetSslProxies = NewTargetSslProxiesService(s)
	s.TargetTcpProxies = NewTargetTcpProxiesService(s)
	s.TargetVpnGateways = NewTargetVpnGatewaysService(s)
	s.UrlMaps = NewUrlMapsService(s)
	s.VpnGateways = NewVpnGatewaysService(s)
	s.VpnTunnels = NewVpnTunnelsService(s)
	s.ZoneInPlaceSnapshots = NewZoneInPlaceSnapshotsService(s)
	s.ZoneInstantSnapshots = NewZoneInstantSnapshotsService(s)
	s.ZoneOperations = NewZoneOperationsService(s)
	s.Zones = NewZonesService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	AcceleratorTypes *AcceleratorTypesService

	Addresses *AddressesService

	Autoscalers *AutoscalersService

	BackendBuckets *BackendBucketsService

	BackendServices *BackendServicesService

	DiskTypes *DiskTypesService

	Disks *DisksService

	ExternalVpnGateways *ExternalVpnGatewaysService

	FirewallPolicies *FirewallPoliciesService

	Firewalls *FirewallsService

	ForwardingRules *ForwardingRulesService

	GlobalAddresses *GlobalAddressesService

	GlobalForwardingRules *GlobalForwardingRulesService

	GlobalNetworkEndpointGroups *GlobalNetworkEndpointGroupsService

	GlobalOperations *GlobalOperationsService

	GlobalOrganizationOperations *GlobalOrganizationOperationsService

	GlobalPublicDelegatedPrefixes *GlobalPublicDelegatedPrefixesService

	HealthChecks *HealthChecksService

	HttpHealthChecks *HttpHealthChecksService

	HttpsHealthChecks *HttpsHealthChecksService

	ImageFamilyViews *ImageFamilyViewsService

	Images *ImagesService

	InstanceGroupManagers *InstanceGroupManagersService

	InstanceGroups *InstanceGroupsService

	InstanceTemplates *InstanceTemplatesService

	Instances *InstancesService

	InterconnectAttachments *InterconnectAttachmentsService

	InterconnectLocations *InterconnectLocationsService

	Interconnects *InterconnectsService

	LicenseCodes *LicenseCodesService

	Licenses *LicensesService

	MachineImages *MachineImagesService

	MachineTypes *MachineTypesService

	NetworkEndpointGroups *NetworkEndpointGroupsService

	NetworkFirewallPolicies *NetworkFirewallPoliciesService

	Networks *NetworksService

	NodeGroups *NodeGroupsService

	NodeTemplates *NodeTemplatesService

	NodeTypes *NodeTypesService

	OrganizationSecurityPolicies *OrganizationSecurityPoliciesService

	PacketMirrorings *PacketMirroringsService

	Projects *ProjectsService

	PublicAdvertisedPrefixes *PublicAdvertisedPrefixesService

	PublicDelegatedPrefixes *PublicDelegatedPrefixesService

	RegionAutoscalers *RegionAutoscalersService

	RegionBackendServices *RegionBackendServicesService

	RegionCommitments *RegionCommitmentsService

	RegionDiskTypes *RegionDiskTypesService

	RegionDisks *RegionDisksService

	RegionHealthCheckServices *RegionHealthCheckServicesService

	RegionHealthChecks *RegionHealthChecksService

	RegionInPlaceSnapshots *RegionInPlaceSnapshotsService

	RegionInstanceGroupManagers *RegionInstanceGroupManagersService

	RegionInstanceGroups *RegionInstanceGroupsService

	RegionInstances *RegionInstancesService

	RegionInstantSnapshots *RegionInstantSnapshotsService

	RegionNetworkEndpointGroups *RegionNetworkEndpointGroupsService

	RegionNetworkFirewallPolicies *RegionNetworkFirewallPoliciesService

	RegionNotificationEndpoints *RegionNotificationEndpointsService

	RegionOperations *RegionOperationsService

	RegionSslCertificates *RegionSslCertificatesService

	RegionTargetHttpProxies *RegionTargetHttpProxiesService

	RegionTargetHttpsProxies *RegionTargetHttpsProxiesService

	RegionUrlMaps *RegionUrlMapsService

	Regions *RegionsService

	Reservations *ReservationsService

	ResourcePolicies *ResourcePoliciesService

	Routers *RoutersService

	Routes *RoutesService

	SecurityPolicies *SecurityPoliciesService

	ServiceAttachments *ServiceAttachmentsService

	Snapshots *SnapshotsService

	SslCertificates *SslCertificatesService

	SslPolicies *SslPoliciesService

	Subnetworks *SubnetworksService

	TargetGrpcProxies *TargetGrpcProxiesService

	TargetHttpProxies *TargetHttpProxiesService

	TargetHttpsProxies *TargetHttpsProxiesService

	TargetInstances *TargetInstancesService

	TargetPools *TargetPoolsService

	TargetSslProxies *TargetSslProxiesService

	TargetTcpProxies *TargetTcpProxiesService

	TargetVpnGateways *TargetVpnGatewaysService

	UrlMaps *UrlMapsService

	VpnGateways *VpnGatewaysService

	VpnTunnels *VpnTunnelsService

	ZoneInPlaceSnapshots *ZoneInPlaceSnapshotsService

	ZoneInstantSnapshots *ZoneInstantSnapshotsService

	ZoneOperations *ZoneOperationsService

	Zones *ZonesService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewAcceleratorTypesService(s *Service) *AcceleratorTypesService {
	rs := &AcceleratorTypesService{s: s}
	return rs
}

type AcceleratorTypesService struct {
	s *Service
}

func NewAddressesService(s *Service) *AddressesService {
	rs := &AddressesService{s: s}
	return rs
}

type AddressesService struct {
	s *Service
}

func NewAutoscalersService(s *Service) *AutoscalersService {
	rs := &AutoscalersService{s: s}
	return rs
}

type AutoscalersService struct {
	s *Service
}

func NewBackendBucketsService(s *Service) *BackendBucketsService {
	rs := &BackendBucketsService{s: s}
	return rs
}

type BackendBucketsService struct {
	s *Service
}

func NewBackendServicesService(s *Service) *BackendServicesService {
	rs := &BackendServicesService{s: s}
	return rs
}

type BackendServicesService struct {
	s *Service
}

func NewDiskTypesService(s *Service) *DiskTypesService {
	rs := &DiskTypesService{s: s}
	return rs
}

type DiskTypesService struct {
	s *Service
}

func NewDisksService(s *Service) *DisksService {
	rs := &DisksService{s: s}
	return rs
}

type DisksService struct {
	s *Service
}

func NewExternalVpnGatewaysService(s *Service) *ExternalVpnGatewaysService {
	rs := &ExternalVpnGatewaysService{s: s}
	return rs
}

type ExternalVpnGatewaysService struct {
	s *Service
}

func NewFirewallPoliciesService(s *Service) *FirewallPoliciesService {
	rs := &FirewallPoliciesService{s: s}
	return rs
}

type FirewallPoliciesService struct {
	s *Service
}

func NewFirewallsService(s *Service) *FirewallsService {
	rs := &FirewallsService{s: s}
	return rs
}

type FirewallsService struct {
	s *Service
}

func NewForwardingRulesService(s *Service) *ForwardingRulesService {
	rs := &ForwardingRulesService{s: s}
	return rs
}

type ForwardingRulesService struct {
	s *Service
}

func NewGlobalAddressesService(s *Service) *GlobalAddressesService {
	rs := &GlobalAddressesService{s: s}
	return rs
}

type GlobalAddressesService struct {
	s *Service
}

func NewGlobalForwardingRulesService(s *Service) *GlobalForwardingRulesService {
	rs := &GlobalForwardingRulesService{s: s}
	return rs
}

type GlobalForwardingRulesService struct {
	s *Service
}

func NewGlobalNetworkEndpointGroupsService(s *Service) *GlobalNetworkEndpointGroupsService {
	rs := &GlobalNetworkEndpointGroupsService{s: s}
	return rs
}

type GlobalNetworkEndpointGroupsService struct {
	s *Service
}

func NewGlobalOperationsService(s *Service) *GlobalOperationsService {
	rs := &GlobalOperationsService{s: s}
	return rs
}

type GlobalOperationsService struct {
	s *Service
}

func NewGlobalOrganizationOperationsService(s *Service) *GlobalOrganizationOperationsService {
	rs := &GlobalOrganizationOperationsService{s: s}
	return rs
}

type GlobalOrganizationOperationsService struct {
	s *Service
}

func NewGlobalPublicDelegatedPrefixesService(s *Service) *GlobalPublicDelegatedPrefixesService {
	rs := &GlobalPublicDelegatedPrefixesService{s: s}
	return rs
}

type GlobalPublicDelegatedPrefixesService struct {
	s *Service
}

func NewHealthChecksService(s *Service) *HealthChecksService {
	rs := &HealthChecksService{s: s}
	return rs
}

type HealthChecksService struct {
	s *Service
}

func NewHttpHealthChecksService(s *Service) *HttpHealthChecksService {
	rs := &HttpHealthChecksService{s: s}
	return rs
}

type HttpHealthChecksService struct {
	s *Service
}

func NewHttpsHealthChecksService(s *Service) *HttpsHealthChecksService {
	rs := &HttpsHealthChecksService{s: s}
	return rs
}

type HttpsHealthChecksService struct {
	s *Service
}

func NewImageFamilyViewsService(s *Service) *ImageFamilyViewsService {
	rs := &ImageFamilyViewsService{s: s}
	return rs
}

type ImageFamilyViewsService struct {
	s *Service
}

func NewImagesService(s *Service) *ImagesService {
	rs := &ImagesService{s: s}
	return rs
}

type ImagesService struct {
	s *Service
}

func NewInstanceGroupManagersService(s *Service) *InstanceGroupManagersService {
	rs := &InstanceGroupManagersService{s: s}
	return rs
}

type InstanceGroupManagersService struct {
	s *Service
}

func NewInstanceGroupsService(s *Service) *InstanceGroupsService {
	rs := &InstanceGroupsService{s: s}
	return rs
}

type InstanceGroupsService struct {
	s *Service
}

func NewInstanceTemplatesService(s *Service) *InstanceTemplatesService {
	rs := &InstanceTemplatesService{s: s}
	return rs
}

type InstanceTemplatesService struct {
	s *Service
}

func NewInstancesService(s *Service) *InstancesService {
	rs := &InstancesService{s: s}
	return rs
}

type InstancesService struct {
	s *Service
}

func NewInterconnectAttachmentsService(s *Service) *InterconnectAttachmentsService {
	rs := &InterconnectAttachmentsService{s: s}
	return rs
}

type InterconnectAttachmentsService struct {
	s *Service
}

func NewInterconnectLocationsService(s *Service) *InterconnectLocationsService {
	rs := &InterconnectLocationsService{s: s}
	return rs
}

type InterconnectLocationsService struct {
	s *Service
}

func NewInterconnectsService(s *Service) *InterconnectsService {
	rs := &InterconnectsService{s: s}
	return rs
}

type InterconnectsService struct {
	s *Service
}

func NewLicenseCodesService(s *Service) *LicenseCodesService {
	rs := &LicenseCodesService{s: s}
	return rs
}

type LicenseCodesService struct {
	s *Service
}

func NewLicensesService(s *Service) *LicensesService {
	rs := &LicensesService{s: s}
	return rs
}

type LicensesService struct {
	s *Service
}

func NewMachineImagesService(s *Service) *MachineImagesService {
	rs := &MachineImagesService{s: s}
	return rs
}

type MachineImagesService struct {
	s *Service
}

func NewMachineTypesService(s *Service) *MachineTypesService {
	rs := &MachineTypesService{s: s}
	return rs
}

type MachineTypesService struct {
	s *Service
}

func NewNetworkEndpointGroupsService(s *Service) *NetworkEndpointGroupsService {
	rs := &NetworkEndpointGroupsService{s: s}
	return rs
}

type NetworkEndpointGroupsService struct {
	s *Service
}

func NewNetworkFirewallPoliciesService(s *Service) *NetworkFirewallPoliciesService {
	rs := &NetworkFirewallPoliciesService{s: s}
	return rs
}

type NetworkFirewallPoliciesService struct {
	s *Service
}

func NewNetworksService(s *Service) *NetworksService {
	rs := &NetworksService{s: s}
	return rs
}

type NetworksService struct {
	s *Service
}

func NewNodeGroupsService(s *Service) *NodeGroupsService {
	rs := &NodeGroupsService{s: s}
	return rs
}

type NodeGroupsService struct {
	s *Service
}

func NewNodeTemplatesService(s *Service) *NodeTemplatesService {
	rs := &NodeTemplatesService{s: s}
	return rs
}

type NodeTemplatesService struct {
	s *Service
}

func NewNodeTypesService(s *Service) *NodeTypesService {
	rs := &NodeTypesService{s: s}
	return rs
}

type NodeTypesService struct {
	s *Service
}

func NewOrganizationSecurityPoliciesService(s *Service) *OrganizationSecurityPoliciesService {
	rs := &OrganizationSecurityPoliciesService{s: s}
	return rs
}

type OrganizationSecurityPoliciesService struct {
	s *Service
}

func NewPacketMirroringsService(s *Service) *PacketMirroringsService {
	rs := &PacketMirroringsService{s: s}
	return rs
}

type PacketMirroringsService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	return rs
}

type ProjectsService struct {
	s *Service
}

func NewPublicAdvertisedPrefixesService(s *Service) *PublicAdvertisedPrefixesService {
	rs := &PublicAdvertisedPrefixesService{s: s}
	return rs
}

type PublicAdvertisedPrefixesService struct {
	s *Service
}

func NewPublicDelegatedPrefixesService(s *Service) *PublicDelegatedPrefixesService {
	rs := &PublicDelegatedPrefixesService{s: s}
	return rs
}

type PublicDelegatedPrefixesService struct {
	s *Service
}

func NewRegionAutoscalersService(s *Service) *RegionAutoscalersService {
	rs := &RegionAutoscalersService{s: s}
	return rs
}

type RegionAutoscalersService struct {
	s *Service
}

func NewRegionBackendServicesService(s *Service) *RegionBackendServicesService {
	rs := &RegionBackendServicesService{s: s}
	return rs
}

type RegionBackendServicesService struct {
	s *Service
}

func NewRegionCommitmentsService(s *Service) *RegionCommitmentsService {
	rs := &RegionCommitmentsService{s: s}
	return rs
}

type RegionCommitmentsService struct {
	s *Service
}

func NewRegionDiskTypesService(s *Service) *RegionDiskTypesService {
	rs := &RegionDiskTypesService{s: s}
	return rs
}

type RegionDiskTypesService struct {
	s *Service
}

func NewRegionDisksService(s *Service) *RegionDisksService {
	rs := &RegionDisksService{s: s}
	return rs
}

type RegionDisksService struct {
	s *Service
}

func NewRegionHealthCheckServicesService(s *Service) *RegionHealthCheckServicesService {
	rs := &RegionHealthCheckServicesService{s: s}
	return rs
}

type RegionHealthCheckServicesService struct {
	s *Service
}

func NewRegionHealthChecksService(s *Service) *RegionHealthChecksService {
	rs := &RegionHealthChecksService{s: s}
	return rs
}

type RegionHealthChecksService struct {
	s *Service
}

func NewRegionInPlaceSnapshotsService(s *Service) *RegionInPlaceSnapshotsService {
	rs := &RegionInPlaceSnapshotsService{s: s}
	return rs
}

type RegionInPlaceSnapshotsService struct {
	s *Service
}

func NewRegionInstanceGroupManagersService(s *Service) *RegionInstanceGroupManagersService {
	rs := &RegionInstanceGroupManagersService{s: s}
	return rs
}

type RegionInstanceGroupManagersService struct {
	s *Service
}

func NewRegionInstanceGroupsService(s *Service) *RegionInstanceGroupsService {
	rs := &RegionInstanceGroupsService{s: s}
	return rs
}

type RegionInstanceGroupsService struct {
	s *Service
}

func NewRegionInstancesService(s *Service) *RegionInstancesService {
	rs := &RegionInstancesService{s: s}
	return rs
}

type RegionInstancesService struct {
	s *Service
}

func NewRegionInstantSnapshotsService(s *Service) *RegionInstantSnapshotsService {
	rs := &RegionInstantSnapshotsService{s: s}
	return rs
}

type RegionInstantSnapshotsService struct {
	s *Service
}

func NewRegionNetworkEndpointGroupsService(s *Service) *RegionNetworkEndpointGroupsService {
	rs := &RegionNetworkEndpointGroupsService{s: s}
	return rs
}

type RegionNetworkEndpointGroupsService struct {
	s *Service
}

func NewRegionNetworkFirewallPoliciesService(s *Service) *RegionNetworkFirewallPoliciesService {
	rs := &RegionNetworkFirewallPoliciesService{s: s}
	return rs
}

type RegionNetworkFirewallPoliciesService struct {
	s *Service
}

func NewRegionNotificationEndpointsService(s *Service) *RegionNotificationEndpointsService {
	rs := &RegionNotificationEndpointsService{s: s}
	return rs
}

type RegionNotificationEndpointsService struct {
	s *Service
}

func NewRegionOperationsService(s *Service) *RegionOperationsService {
	rs := &RegionOperationsService{s: s}
	return rs
}

type RegionOperationsService struct {
	s *Service
}

func NewRegionSslCertificatesService(s *Service) *RegionSslCertificatesService {
	rs := &RegionSslCertificatesService{s: s}
	return rs
}

type RegionSslCertificatesService struct {
	s *Service
}

func NewRegionTargetHttpProxiesService(s *Service) *RegionTargetHttpProxiesService {
	rs := &RegionTargetHttpProxiesService{s: s}
	return rs
}

type RegionTargetHttpProxiesService struct {
	s *Service
}

func NewRegionTargetHttpsProxiesService(s *Service) *RegionTargetHttpsProxiesService {
	rs := &RegionTargetHttpsProxiesService{s: s}
	return rs
}

type RegionTargetHttpsProxiesService struct {
	s *Service
}

func NewRegionUrlMapsService(s *Service) *RegionUrlMapsService {
	rs := &RegionUrlMapsService{s: s}
	return rs
}

type RegionUrlMapsService struct {
	s *Service
}

func NewRegionsService(s *Service) *RegionsService {
	rs := &RegionsService{s: s}
	return rs
}

type RegionsService struct {
	s *Service
}

func NewReservationsService(s *Service) *ReservationsService {
	rs := &ReservationsService{s: s}
	return rs
}

type ReservationsService struct {
	s *Service
}

func NewResourcePoliciesService(s *Service) *ResourcePoliciesService {
	rs := &ResourcePoliciesService{s: s}
	return rs
}

type ResourcePoliciesService struct {
	s *Service
}

func NewRoutersService(s *Service) *RoutersService {
	rs := &RoutersService{s: s}
	return rs
}

type RoutersService struct {
	s *Service
}

func NewRoutesService(s *Service) *RoutesService {
	rs := &RoutesService{s: s}
	return rs
}

type RoutesService struct {
	s *Service
}

func NewSecurityPoliciesService(s *Service) *SecurityPoliciesService {
	rs := &SecurityPoliciesService{s: s}
	return rs
}

type SecurityPoliciesService struct {
	s *Service
}

func NewServiceAttachmentsService(s *Service) *ServiceAttachmentsService {
	rs := &ServiceAttachmentsService{s: s}
	return rs
}

type ServiceAttachmentsService struct {
	s *Service
}

func NewSnapshotsService(s *Service) *SnapshotsService {
	rs := &SnapshotsService{s: s}
	return rs
}

type SnapshotsService struct {
	s *Service
}

func NewSslCertificatesService(s *Service) *SslCertificatesService {
	rs := &SslCertificatesService{s: s}
	return rs
}

type SslCertificatesService struct {
	s *Service
}

func NewSslPoliciesService(s *Service) *SslPoliciesService {
	rs := &SslPoliciesService{s: s}
	return rs
}

type SslPoliciesService struct {
	s *Service
}

func NewSubnetworksService(s *Service) *SubnetworksService {
	rs := &SubnetworksService{s: s}
	return rs
}

type SubnetworksService struct {
	s *Service
}

func NewTargetGrpcProxiesService(s *Service) *TargetGrpcProxiesService {
	rs := &TargetGrpcProxiesService{s: s}
	return rs
}

type TargetGrpcProxiesService struct {
	s *Service
}

func NewTargetHttpProxiesService(s *Service) *TargetHttpProxiesService {
	rs := &TargetHttpProxiesService{s: s}
	return rs
}

type TargetHttpProxiesService struct {
	s *Service
}

func NewTargetHttpsProxiesService(s *Service) *TargetHttpsProxiesService {
	rs := &TargetHttpsProxiesService{s: s}
	return rs
}

type TargetHttpsProxiesService struct {
	s *Service
}

func NewTargetInstancesService(s *Service) *TargetInstancesService {
	rs := &TargetInstancesService{s: s}
	return rs
}

type TargetInstancesService struct {
	s *Service
}

func NewTargetPoolsService(s *Service) *TargetPoolsService {
	rs := &TargetPoolsService{s: s}
	return rs
}

type TargetPoolsService struct {
	s *Service
}

func NewTargetSslProxiesService(s *Service) *TargetSslProxiesService {
	rs := &TargetSslProxiesService{s: s}
	return rs
}

type TargetSslProxiesService struct {
	s *Service
}

func NewTargetTcpProxiesService(s *Service) *TargetTcpProxiesService {
	rs := &TargetTcpProxiesService{s: s}
	return rs
}

type TargetTcpProxiesService struct {
	s *Service
}

func NewTargetVpnGatewaysService(s *Service) *TargetVpnGatewaysService {
	rs := &TargetVpnGatewaysService{s: s}
	return rs
}

type TargetVpnGatewaysService struct {
	s *Service
}

func NewUrlMapsService(s *Service) *UrlMapsService {
	rs := &UrlMapsService{s: s}
	return rs
}

type UrlMapsService struct {
	s *Service
}

func NewVpnGatewaysService(s *Service) *VpnGatewaysService {
	rs := &VpnGatewaysService{s: s}
	return rs
}

type VpnGatewaysService struct {
	s *Service
}

func NewVpnTunnelsService(s *Service) *VpnTunnelsService {
	rs := &VpnTunnelsService{s: s}
	return rs
}

type VpnTunnelsService struct {
	s *Service
}

func NewZoneInPlaceSnapshotsService(s *Service) *ZoneInPlaceSnapshotsService {
	rs := &ZoneInPlaceSnapshotsService{s: s}
	return rs
}

type ZoneInPlaceSnapshotsService struct {
	s *Service
}

func NewZoneInstantSnapshotsService(s *Service) *ZoneInstantSnapshotsService {
	rs := &ZoneInstantSnapshotsService{s: s}
	return rs
}

type ZoneInstantSnapshotsService struct {
	s *Service
}

func NewZoneOperationsService(s *Service) *ZoneOperationsService {
	rs := &ZoneOperationsService{s: s}
	return rs
}

type ZoneOperationsService struct {
	s *Service
}

func NewZonesService(s *Service) *ZonesService {
	rs := &ZonesService{s: s}
	return rs
}

type ZonesService struct {
	s *Service
}

// AcceleratorConfig: A specification of the type and number of
// accelerator cards attached to the instance.
type AcceleratorConfig struct {
	// AcceleratorCount: The number of the guest accelerator cards exposed
	// to this instance.
	AcceleratorCount int64 `json:"acceleratorCount,omitempty"`

	// AcceleratorType: Full or partial URL of the accelerator type resource
	// to attach to this instance. For example:
	// projects/my-project/zones/us-central1-c/acceleratorTypes/nvidia-tesla-
	// p100 If you are creating an instance template, specify only the
	// accelerator name. See GPUs on Compute Engine for a full list of
	// accelerator types.
	AcceleratorType string `json:"acceleratorType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AcceleratorCount") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AcceleratorCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AcceleratorConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AcceleratorConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AcceleratorType: Represents an Accelerator Type resource.
//
// Google Cloud Platform provides graphics processing units
// (accelerators) that you can add to VM instances to improve or
// accelerate performance when working with intensive workloads. For
// more information, read GPUs on Compute Engine. (== resource_for
// {$api_version}.acceleratorTypes ==)
type AcceleratorType struct {
	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Deprecated -- [Output Only] The deprecation status associated with
	// this accelerator type.
	Deprecated *DeprecationStatus `json:"deprecated,omitempty"`

	// Description: [Output Only] An optional textual description of the
	// resource.
	Description string `json:"description,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// Kind: [Output Only] The type of the resource. Always
	// compute#acceleratorType for accelerator types.
	Kind string `json:"kind,omitempty"`

	// MaximumCardsPerInstance: [Output Only] Maximum number of accelerator
	// cards allowed per instance.
	MaximumCardsPerInstance int64 `json:"maximumCardsPerInstance,omitempty"`

	// Name: [Output Only] Name of the resource.
	Name string `json:"name,omitempty"`

	// SelfLink: [Output Only] Server-defined, fully qualified URL for this
	// resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource's
	// resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// Zone: [Output Only] The name of the zone where the accelerator type
	// resides, such as us-central1-a. You must specify this field as part
	// of the HTTP request URL. It is not settable as a field in the request
	// body.
	Zone string `json:"zone,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreationTimestamp")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreationTimestamp") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AcceleratorType) MarshalJSON() ([]byte, error) {
	type NoMethod AcceleratorType
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AcceleratorTypeAggregatedList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of AcceleratorTypesScopedList resources.
	Items map[string]AcceleratorTypesScopedList `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#acceleratorTypeAggregatedList for aggregated lists of
	// accelerator types.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Unreachables: [Output Only] Unreachable resources.
	Unreachables []string `json:"unreachables,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *AcceleratorTypeAggregatedListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AcceleratorTypeAggregatedList) MarshalJSON() ([]byte, error) {
	type NoMethod AcceleratorTypeAggregatedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AcceleratorTypeAggregatedListWarning: [Output Only] Informational
// warning message.
type AcceleratorTypeAggregatedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*AcceleratorTypeAggregatedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AcceleratorTypeAggregatedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod AcceleratorTypeAggregatedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AcceleratorTypeAggregatedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AcceleratorTypeAggregatedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod AcceleratorTypeAggregatedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AcceleratorTypeList: Contains a list of accelerator types.
type AcceleratorTypeList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of AcceleratorType resources.
	Items []*AcceleratorType `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#acceleratorTypeList for lists of accelerator types.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *AcceleratorTypeListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AcceleratorTypeList) MarshalJSON() ([]byte, error) {
	type NoMethod AcceleratorTypeList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AcceleratorTypeListWarning: [Output Only] Informational warning
// message.
type AcceleratorTypeListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*AcceleratorTypeListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AcceleratorTypeListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod AcceleratorTypeListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AcceleratorTypeListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AcceleratorTypeListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod AcceleratorTypeListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AcceleratorTypesScopedList struct {
	// AcceleratorTypes: [Output Only] A list of accelerator types contained
	// in this scope.
	AcceleratorTypes []*AcceleratorType `json:"acceleratorTypes,omitempty"`

	// Warning: [Output Only] An informational warning that appears when the
	// accelerator types list is empty.
	Warning *AcceleratorTypesScopedListWarning `json:"warning,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AcceleratorTypes") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AcceleratorTypes") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AcceleratorTypesScopedList) MarshalJSON() ([]byte, error) {
	type NoMethod AcceleratorTypesScopedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AcceleratorTypesScopedListWarning: [Output Only] An informational
// warning that appears when the accelerator types list is empty.
type AcceleratorTypesScopedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*AcceleratorTypesScopedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AcceleratorTypesScopedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod AcceleratorTypesScopedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AcceleratorTypesScopedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AcceleratorTypesScopedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod AcceleratorTypesScopedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AccessConfig: An access configuration attached to an instance's
// network interface. Only one access config per instance is supported.
type AccessConfig struct {
	// ExternalIpv6: [Output Only] The first IPv6 address of the external
	// IPv6 range associated with this instance, prefix length is stored in
	// externalIpv6PrefixLength in ipv6AccessConfig. The field is output
	// only, an IPv6 address from a subnetwork associated with the instance
	// will be allocated dynamically.
	ExternalIpv6 string `json:"externalIpv6,omitempty"`

	// ExternalIpv6PrefixLength: [Output Only] The prefix length of the
	// external IPv6 range.
	ExternalIpv6PrefixLength int64 `json:"externalIpv6PrefixLength,omitempty"`

	// Kind: [Output Only] Type of the resource. Always compute#accessConfig
	// for access configs.
	Kind string `json:"kind,omitempty"`

	// Name: The name of this access configuration. The default and
	// recommended name is External NAT, but you can use any arbitrary
	// string, such as My external IP or Network Access.
	Name string `json:"name,omitempty"`

	// NatIP: An external IP address associated with this instance. Specify
	// an unused static external IP address available to the project or
	// leave this field undefined to use an IP from a shared ephemeral IP
	// address pool. If you specify a static external IP address, it must
	// live in the same region as the zone of the instance.
	NatIP string `json:"natIP,omitempty"`

	// NetworkTier: This signifies the networking tier used for configuring
	// this access configuration and can only take the following values:
	// PREMIUM, STANDARD.
	//
	// If an AccessConfig is specified without a valid external IP address,
	// an ephemeral IP will be created with this networkTier.
	//
	// If an AccessConfig with a valid external IP address is specified, it
	// must match that of the networkTier associated with the Address
	// resource owning that IP.
	//
	// Possible values:
	//   "FIXED_STANDARD"
	//   "PREMIUM"
	//   "SELECT"
	//   "STANDARD"
	//   "STANDARD_OVERRIDES_FIXED_STANDARD"
	NetworkTier string `json:"networkTier,omitempty"`

	// PublicDnsName: [Output Only] The public DNS domain name for the
	// instance.
	PublicDnsName string `json:"publicDnsName,omitempty"`

	// PublicPtrDomainName: The DNS domain name for the public PTR record.
	// You can set this field only if the `setPublicPtr` field is enabled.
	PublicPtrDomainName string `json:"publicPtrDomainName,omitempty"`

	// SetPublicDns: Specifies whether a public DNS 'A' record should be
	// created for the external IP address of this access configuration.
	SetPublicDns bool `json:"setPublicDns,omitempty"`

	// SetPublicPtr: Specifies whether a public DNS 'PTR' record should be
	// created to map the external IP address of the instance to a DNS
	// domain name.
	SetPublicPtr bool `json:"setPublicPtr,omitempty"`

	// Type: The type of configuration. The default and only option is
	// ONE_TO_ONE_NAT.
	//
	// Possible values:
	//   "DIRECT_IPV6"
	//   "ONE_TO_ONE_NAT" (default)
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExternalIpv6") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExternalIpv6") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccessConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AccessConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Address: Use global external addresses for GFE-based external HTTP(S)
// load balancers in Premium Tier.
//
// Use global internal addresses for reserved peering network
// range.
//
// Use regional external addresses for the following resources:
//
// - External IP addresses for VM instances - Regional external
// forwarding rules - Cloud NAT external IP addresses - GFE based LBs in
// Standard Tier - Network LBs in Premium or Standard Tier - Cloud VPN
// gateways (both Classic and HA)
//
// Use regional internal IP addresses for subnet IP ranges (primary and
// secondary). This includes:
//
// - Internal IP addresses for VM instances - Alias IP ranges of VM
// instances (/32 only) - Regional internal forwarding rules - Internal
// TCP/UDP load balancer addresses - Internal HTTP(S) load balancer
// addresses - Cloud DNS inbound forwarding IP addresses
//
// For more information, read reserved IP address.
//
// (== resource_for {$api_version}.addresses ==) (== resource_for
// {$api_version}.globalAddresses ==)
type Address struct {
	// Address: The static IP address represented by this resource.
	Address string `json:"address,omitempty"`

	// AddressType: The type of address to reserve, either INTERNAL or
	// EXTERNAL. If unspecified, defaults to EXTERNAL.
	//
	// Possible values:
	//   "DNS_FORWARDING"
	//   "EXTERNAL"
	//   "INTERNAL"
	//   "UNSPECIFIED_TYPE"
	AddressType string `json:"addressType,omitempty"`

	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Description: An optional description of this resource. Provide this
	// field when you create the resource.
	Description string `json:"description,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// IpVersion: The IP version that will be used by this address. Valid
	// options are IPV4 or IPV6. This can only be specified for a global
	// address.
	//
	// Possible values:
	//   "IPV4"
	//   "IPV6"
	//   "UNSPECIFIED_VERSION"
	IpVersion string `json:"ipVersion,omitempty"`

	// Kind: [Output Only] Type of the resource. Always compute#address for
	// addresses.
	Kind string `json:"kind,omitempty"`

	// LabelFingerprint: A fingerprint for the labels being applied to this
	// Address, which is essentially a hash of the labels set used for
	// optimistic locking. The fingerprint is initially generated by Compute
	// Engine and changes after every request to modify or update labels.
	// You must always provide an up-to-date fingerprint hash in order to
	// update or change labels, otherwise the request will fail with error
	// 412 conditionNotMet.
	//
	// To see the latest fingerprint, make a get() request to retrieve an
	// Address.
	LabelFingerprint string `json:"labelFingerprint,omitempty"`

	// Labels: Labels for this resource. These can only be added or modified
	// by the setLabels method. Each label key/value pair must comply with
	// RFC1035. Label values may be empty.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Name of the resource. Provided by the client when the resource
	// is created. The name must be 1-63 characters long, and comply with
	// RFC1035. Specifically, the name must be 1-63 characters long and
	// match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first
	// character must be a lowercase letter, and all following characters
	// (except for the last character) must be a dash, lowercase letter, or
	// digit. The last character must be a lowercase letter or digit.
	Name string `json:"name,omitempty"`

	// Network: The URL of the network in which to reserve the address. This
	// field can only be used with INTERNAL type with the VPC_PEERING
	// purpose.
	Network string `json:"network,omitempty"`

	// NetworkTier: This signifies the networking tier used for configuring
	// this address and can only take the following values: PREMIUM or
	// STANDARD. Global forwarding rules can only be Premium Tier. Regional
	// forwarding rules can be either Premium or Standard Tier. Standard
	// Tier addresses applied to regional forwarding rules can be used with
	// any external load balancer. Regional forwarding rules in Premium Tier
	// can only be used with a network load balancer.
	//
	// If this field is not specified, it is assumed to be PREMIUM.
	//
	// Possible values:
	//   "FIXED_STANDARD"
	//   "PREMIUM"
	//   "SELECT"
	//   "STANDARD"
	//   "STANDARD_OVERRIDES_FIXED_STANDARD"
	NetworkTier string `json:"networkTier,omitempty"`

	// PrefixLength: The prefix length if the resource represents an IP
	// range.
	PrefixLength int64 `json:"prefixLength,omitempty"`

	// Purpose: The purpose of this resource, which can be one of the
	// following values:
	// - `GCE_ENDPOINT` for addresses that are used by VM instances, alias
	// IP ranges, internal load balancers, and similar resources.
	// - `DNS_RESOLVER` for a DNS resolver address in a subnetwork
	// - `VPC_PEERING` for addresses that are reserved for VPC peer
	// networks.
	// - `NAT_AUTO` for addresses that are external IP addresses
	// automatically reserved for Cloud NAT.
	// - `IPSEC_INTERCONNECT` for addresses created from a private IP range
	// that are reserved for a VLAN attachment in an IPsec-encrypted Cloud
	// Interconnect configuration. These addresses are regional resources.
	//
	// Possible values:
	//   "DNS_RESOLVER"
	//   "GCE_ENDPOINT"
	//   "IPSEC_INTERCONNECT"
	//   "NAT_AUTO"
	//   "PRIVATE_SERVICE_CONNECT"
	//   "PSC_PRODUCER_NAT_RANGE"
	//   "SHARED_LOADBALANCER_VIP"
	//   "VPC_PEERING"
	Purpose string `json:"purpose,omitempty"`

	// Region: [Output Only] The URL of the region where a regional address
	// resides. For regional addresses, you must specify the region as a
	// path parameter in the HTTP request URL. This field is not applicable
	// to global addresses.
	Region string `json:"region,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// Status: [Output Only] The status of the address, which can be one of
	// RESERVING, RESERVED, or IN_USE. An address that is RESERVING is
	// currently in the process of being reserved. A RESERVED address is
	// currently reserved and available to use. An IN_USE address is
	// currently being used by another resource and is not available.
	//
	// Possible values:
	//   "IN_USE"
	//   "RESERVED"
	//   "RESERVING"
	Status string `json:"status,omitempty"`

	// Subnetwork: The URL of the subnetwork in which to reserve the
	// address. If an IP address is specified, it must be within the
	// subnetwork's IP range. This field can only be used with INTERNAL type
	// with a GCE_ENDPOINT or DNS_RESOLVER purpose.
	Subnetwork string `json:"subnetwork,omitempty"`

	// Users: [Output Only] The URLs of the resources that are using this
	// address.
	Users []string `json:"users,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Address") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Address") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Address) MarshalJSON() ([]byte, error) {
	type NoMethod Address
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AddressAggregatedList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of AddressesScopedList resources.
	Items map[string]AddressesScopedList `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#addressAggregatedList for aggregated lists of addresses.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Unreachables: [Output Only] Unreachable resources.
	Unreachables []string `json:"unreachables,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *AddressAggregatedListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AddressAggregatedList) MarshalJSON() ([]byte, error) {
	type NoMethod AddressAggregatedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AddressAggregatedListWarning: [Output Only] Informational warning
// message.
type AddressAggregatedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*AddressAggregatedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AddressAggregatedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod AddressAggregatedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AddressAggregatedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AddressAggregatedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod AddressAggregatedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AddressList: Contains a list of addresses.
type AddressList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of Address resources.
	Items []*Address `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always compute#addressList for
	// lists of addresses.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *AddressListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AddressList) MarshalJSON() ([]byte, error) {
	type NoMethod AddressList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AddressListWarning: [Output Only] Informational warning message.
type AddressListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*AddressListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AddressListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod AddressListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AddressListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AddressListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod AddressListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AddressesScopedList struct {
	// Addresses: [Output Only] A list of addresses contained in this scope.
	Addresses []*Address `json:"addresses,omitempty"`

	// Warning: [Output Only] Informational warning which replaces the list
	// of addresses when the list is empty.
	Warning *AddressesScopedListWarning `json:"warning,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Addresses") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Addresses") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AddressesScopedList) MarshalJSON() ([]byte, error) {
	type NoMethod AddressesScopedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AddressesScopedListWarning: [Output Only] Informational warning which
// replaces the list of addresses when the list is empty.
type AddressesScopedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*AddressesScopedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AddressesScopedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod AddressesScopedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AddressesScopedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AddressesScopedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod AddressesScopedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AdvancedMachineFeatures: Specifies options for controlling advanced
// machine features. Options that would traditionally be configured in a
// BIOS belong here. Features that require operating system support may
// have corresponding entries in the GuestOsFeatures of an Image (e.g.,
// whether or not the OS in the Image supports nested virtualization
// being enabled or disabled).
type AdvancedMachineFeatures struct {
	// EnableNestedVirtualization: Whether to enable nested virtualization
	// or not (default is false).
	EnableNestedVirtualization bool `json:"enableNestedVirtualization,omitempty"`

	// ThreadsPerCore: The number of threads per physical core. To disable
	// simultaneous multithreading (SMT) set this to 1. If unset, the
	// maximum number of threads supported per core by the underlying
	// processor is assumed.
	ThreadsPerCore int64 `json:"threadsPerCore,omitempty"`

	// VisibleCoreCount: The number of physical cores to expose to an
	// instance. Multiply by the number of threads per core to compute the
	// total number of virtual CPUs to expose to the instance. If unset, the
	// number of cores is inferred from the instance's nominal CPU count and
	// the underlying platform's SMT width.
	VisibleCoreCount int64 `json:"visibleCoreCount,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "EnableNestedVirtualization") to unconditionally include in API
	// requests. By default, fields with empty values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "EnableNestedVirtualization") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AdvancedMachineFeatures) MarshalJSON() ([]byte, error) {
	type NoMethod AdvancedMachineFeatures
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AliasIpRange: An alias IP range attached to an instance's network
// interface.
type AliasIpRange struct {
	// IpCidrRange: The IP alias ranges to allocate for this interface. This
	// IP CIDR range must belong to the specified subnetwork and cannot
	// contain IP addresses reserved by system or used by other network
	// interfaces. This range may be a single IP address (such as 10.2.3.4),
	// a netmask (such as /24) or a CIDR-formatted string (such as
	// 10.1.2.0/24).
	IpCidrRange string `json:"ipCidrRange,omitempty"`

	// SubnetworkRangeName: The name of a subnetwork secondary IP range from
	// which to allocate an IP alias range. If not specified, the primary
	// range of the subnetwork is used.
	SubnetworkRangeName string `json:"subnetworkRangeName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IpCidrRange") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IpCidrRange") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AliasIpRange) MarshalJSON() ([]byte, error) {
	type NoMethod AliasIpRange
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AllocationShareSettings struct {
	// Projects: A List of Project names to specify consumer projects for
	// this shared-reservation. This is only valid when share_type's value
	// is SPECIFIC_PROJECTS.
	Projects []string `json:"projects,omitempty"`

	// ShareType: Type of sharing for this shared-reservation
	//
	// Possible values:
	//   "ORGANIZATION"
	//   "SHARE_TYPE_UNSPECIFIED"
	//   "SPECIFIC_PROJECTS"
	ShareType string `json:"shareType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Projects") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Projects") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AllocationShareSettings) MarshalJSON() ([]byte, error) {
	type NoMethod AllocationShareSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk struct {
	// DiskSizeGb: Specifies the size of the disk in base-2 GB.
	DiskSizeGb int64 `json:"diskSizeGb,omitempty,string"`

	// Interface: Specifies the disk interface to use for attaching this
	// disk, which is either SCSI or NVME. The default is SCSI. For
	// performance characteristics of SCSI over NVMe, see Local SSD
	// performance.
	//
	// Possible values:
	//   "NVDIMM"
	//   "NVME"
	//   "SCSI"
	Interface string `json:"interface,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DiskSizeGb") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DiskSizeGb") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk) MarshalJSON() ([]byte, error) {
	type NoMethod AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AllocationSpecificSKUAllocationReservedInstanceProperties: Properties
// of the SKU instances being reserved. Next ID: 9
type AllocationSpecificSKUAllocationReservedInstanceProperties struct {
	// GuestAccelerators: Specifies accelerator type and count.
	GuestAccelerators []*AcceleratorConfig `json:"guestAccelerators,omitempty"`

	// LocalSsds: Specifies amount of local ssd to reserve with each
	// instance. The type of disk is local-ssd.
	LocalSsds []*AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk `json:"localSsds,omitempty"`

	// LocationHint: An opaque location hint used to place the allocation
	// close to other resources. This field is for use by internal tools
	// that use the public API.
	LocationHint string `json:"locationHint,omitempty"`

	// MachineType: Specifies type of machine (name only) which has fixed
	// number of vCPUs and fixed amount of memory. This also includes
	// specifying custom machine type following
	// custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY pattern.
	MachineType string `json:"machineType,omitempty"`

	// MaintenanceFreezeDurationHours: Specifies the number of hours after
	// reservation creation where instances using the reservation won't be
	// scheduled for maintenance.
	MaintenanceFreezeDurationHours int64 `json:"maintenanceFreezeDurationHours,omitempty"`

	// MaintenanceInterval: Specifies whether this VM may be a stable fleet
	// VM. Setting this to "Periodic" designates this VM as a Stable Fleet
	// VM.
	//
	// See go/stable-fleet-ug for more details.
	//
	// Possible values:
	//   "PERIODIC"
	MaintenanceInterval string `json:"maintenanceInterval,omitempty"`

	// MinCpuPlatform: Minimum cpu platform the reservation.
	MinCpuPlatform string `json:"minCpuPlatform,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GuestAccelerators")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GuestAccelerators") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AllocationSpecificSKUAllocationReservedInstanceProperties) MarshalJSON() ([]byte, error) {
	type NoMethod AllocationSpecificSKUAllocationReservedInstanceProperties
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AllocationSpecificSKUReservation: This reservation type allows to pre
// allocate specific instance configuration.
type AllocationSpecificSKUReservation struct {
	// Count: Specifies the number of resources that are allocated.
	Count int64 `json:"count,omitempty,string"`

	// InUseCount: [Output Only] Indicates how many instances are in use.
	InUseCount int64 `json:"inUseCount,omitempty,string"`

	// InstanceProperties: The instance properties for the reservation.
	InstanceProperties *AllocationSpecificSKUAllocationReservedInstanceProperties `json:"instanceProperties,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Count") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AllocationSpecificSKUReservation) MarshalJSON() ([]byte, error) {
	type NoMethod AllocationSpecificSKUReservation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Any: `Any` contains an arbitrary serialized protocol buffer message
// along with a URL that describes the type of the serialized
// message.
//
// Protobuf library provides support to pack/unpack Any values in the
// form of utility functions or additional generated methods of the Any
// type.
//
// Example 1: Pack and unpack a message in C++.
//
// Foo foo = ...; Any any; any.PackFrom(foo); ... if
// (any.UnpackTo(&foo)) { ... }
//
// Example 2: Pack and unpack a message in Java.
//
// Foo foo = ...; Any any = Any.pack(foo); ... if (any.is(Foo.class)) {
// foo = any.unpack(Foo.class); }
//
// Example 3: Pack and unpack a message in Python.
//
// foo = Foo(...) any = Any() any.Pack(foo) ... if
// any.Is(Foo.DESCRIPTOR): any.Unpack(foo) ...
//
// Example 4: Pack and unpack a message in Go
//
// foo := &pb.Foo{...} any, err := anypb.New(foo) if err != nil { ... }
// ... foo := &pb.Foo{} if err := any.UnmarshalTo(foo); err != nil { ...
// }
//
// The pack methods provided by protobuf library will by default use
// 'type.googleapis.com/full.type.name' as the type URL and the unpack
// methods only use the fully qualified type name after the last '/' in
// the type URL, for example "foo.bar.com/x/y.z" will yield type name
// "y.z".
//
//
//
// JSON ==== The JSON representation of an `Any` value uses the regular
// representation of the deserialized, embedded message, with an
// additional field `@type` which contains the type URL.
// Example:
//
// package google.profile; message Person { string first_name = 1;
// string last_name = 2; }
//
// { "@type": "type.googleapis.com/google.profile.Person", "firstName":
// , "lastName":  }
//
// If the embedded message type is well-known and has a custom JSON
// representation, that representation will be embedded adding a field
// `value` which holds the custom JSON in addition to the `@type` field.
// Example (for message [google.protobuf.Duration][]):
//
// { "@type": "type.googleapis.com/google.protobuf.Duration", "value":
// "1.212s" }
type Any struct {
	// TypeUrl: A URL/resource name that uniquely identifies the type of the
	// serialized protocol buffer message. This string must contain at least
	// one "/" character. The last segment of the URL's path must represent
	// the fully qualified name of the type (as in
	// `path/google.protobuf.Duration`). The name should be in a canonical
	// form (e.g., leading "." is not accepted).
	//
	// In practice, teams usually precompile into the binary all types that
	// they expect it to use in the context of Any. However, for URLs which
	// use the scheme `http`, `https`, or no scheme, one can optionally set
	// up a type server that maps type URLs to message definitions as
	// follows:
	//
	// * If no scheme is provided, `https` is assumed. * An HTTP GET on the
	// URL must yield a [google.protobuf.Type][] value in binary format, or
	// produce an error. * Applications are allowed to cache lookup results
	// based on the URL, or have them precompiled into a binary to avoid any
	// lookup. Therefore, binary compatibility needs to be preserved on
	// changes to types. (Use versioned type names to manage breaking
	// changes.)
	//
	// Note: this functionality is not currently available in the official
	// protobuf release, and it is not used for type URLs beginning with
	// type.googleapis.com.
	//
	// Schemes other than `http`, `https` (or the empty scheme) might be
	// used with implementation specific semantics.
	TypeUrl string `json:"typeUrl,omitempty"`

	// Value: Must be a valid serialized protocol buffer of the above
	// specified type.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "TypeUrl") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TypeUrl") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Any) MarshalJSON() ([]byte, error) {
	type NoMethod Any
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AttachedDisk: An instance-attached disk resource.
type AttachedDisk struct {
	// AutoDelete: Specifies whether the disk will be auto-deleted when the
	// instance is deleted (but not when the disk is detached from the
	// instance).
	AutoDelete bool `json:"autoDelete,omitempty"`

	// Boot: Indicates that this is a boot disk. The virtual machine will
	// use the first partition of the disk for its root filesystem.
	Boot bool `json:"boot,omitempty"`

	// DeviceName: Specifies a unique device name of your choice that is
	// reflected into the /dev/disk/by-id/google-* tree of a Linux operating
	// system running within the instance. This name can be used to
	// reference the device for mounting, resizing, and so on, from within
	// the instance.
	//
	// If not specified, the server chooses a default device name to apply
	// to this disk, in the form persistent-disk-x, where x is a number
	// assigned by Google Compute Engine. This field is only applicable for
	// persistent disks.
	DeviceName string `json:"deviceName,omitempty"`

	// DiskEncryptionKey: Encrypts or decrypts a disk using a
	// customer-supplied encryption key.
	//
	// If you are creating a new disk, this field encrypts the new disk
	// using an encryption key that you provide. If you are attaching an
	// existing disk that is already encrypted, this field decrypts the disk
	// using the customer-supplied encryption key.
	//
	// If you encrypt a disk using a customer-supplied key, you must provide
	// the same key again when you attempt to use this resource at a later
	// time. For example, you must provide the key when you create a
	// snapshot or an image from the disk or when you attach the disk to a
	// virtual machine instance.
	//
	// If you do not provide an encryption key, then the disk will be
	// encrypted using an automatically generated key and you do not need to
	// provide a key to use the disk later.
	//
	// Instance templates do not store customer-supplied encryption keys, so
	// you cannot use your own keys to encrypt disks in a managed instance
	// group.
	DiskEncryptionKey *CustomerEncryptionKey `json:"diskEncryptionKey,omitempty"`

	// DiskSizeGb: The size of the disk in GB.
	DiskSizeGb int64 `json:"diskSizeGb,omitempty,string"`

	// ForceAttach: [Input Only] Whether to force attach the regional disk
	// even if it's currently attached to another instance. If you try to
	// force attach a zonal disk to an instance, you will receive an error.
	ForceAttach bool `json:"forceAttach,omitempty"`

	// GuestOsFeatures: A list of features to enable on the guest operating
	// system. Applicable only for bootable images. Read  Enabling guest
	// operating system features to see a list of available options.
	GuestOsFeatures []*GuestOsFeature `json:"guestOsFeatures,omitempty"`

	// Index: [Output Only] A zero-based index to this disk, where 0 is
	// reserved for the boot disk. If you have many disks attached to an
	// instance, each disk would have a unique index number.
	Index int64 `json:"index,omitempty"`

	// InitializeParams: [Input Only] Specifies the parameters for a new
	// disk that will be created alongside the new instance. Use
	// initialization parameters to create boot disks or local SSDs attached
	// to the new instance.
	//
	// This property is mutually exclusive with the source property; you can
	// only define one or the other, but not both.
	InitializeParams *AttachedDiskInitializeParams `json:"initializeParams,omitempty"`

	// Interface: Specifies the disk interface to use for attaching this
	// disk, which is either SCSI or NVME. The default is SCSI. Persistent
	// disks must always use SCSI and the request will fail if you attempt
	// to attach a persistent disk in any other format than SCSI. Local SSDs
	// can use either NVME or SCSI. For performance characteristics of SCSI
	// over NVMe, see Local SSD performance.
	//
	// Possible values:
	//   "NVDIMM"
	//   "NVME"
	//   "SCSI"
	Interface string `json:"interface,omitempty"`

	// Kind: [Output Only] Type of the resource. Always compute#attachedDisk
	// for attached disks.
	Kind string `json:"kind,omitempty"`

	// Licenses: [Output Only] Any valid publicly visible licenses.
	Licenses []string `json:"licenses,omitempty"`

	// Mode: The mode in which to attach this disk, either READ_WRITE or
	// READ_ONLY. If not specified, the default is to attach the disk in
	// READ_WRITE mode.
	//
	// Possible values:
	//   "READ_ONLY"
	//   "READ_WRITE"
	Mode string `json:"mode,omitempty"`

	// SavedState: For LocalSSD disks on VM Instances in STOPPED or
	// SUSPENDED state, this field is set to PRESERVED if the LocalSSD data
	// has been saved to a persistent location by customer request. (see the
	// discard_local_ssd option on Stop/Suspend). Read-only in the api.
	//
	// Possible values:
	//   "DISK_SAVED_STATE_UNSPECIFIED"
	//   "PRESERVED"
	SavedState string `json:"savedState,omitempty"`

	// ShieldedInstanceInitialState: [Output Only] shielded vm initial state
	// stored on disk
	ShieldedInstanceInitialState *InitialStateConfig `json:"shieldedInstanceInitialState,omitempty"`

	// Source: Specifies a valid partial or full URL to an existing
	// Persistent Disk resource. When creating a new instance, one of
	// initializeParams.sourceImage or initializeParams.sourceSnapshot or
	// disks.source is required except for local SSD.
	//
	// If desired, you can also attach existing non-root persistent disks
	// using this property. This field is only applicable for persistent
	// disks.
	//
	// Note that for InstanceTemplate, specify the disk name, not the URL
	// for the disk.
	Source string `json:"source,omitempty"`

	// Type: Specifies the type of the disk, either SCRATCH or PERSISTENT.
	// If not specified, the default is PERSISTENT.
	//
	// Possible values:
	//   "PERSISTENT"
	//   "SCRATCH"
	Type string `json:"type,omitempty"`

	// UserLicenses: [Output Only] A list of user provided licenses. It
	// represents a list of URLs to the license resource. Unlike regular
	// licenses, user provided licenses can be modified after the disk is
	// created.
	UserLicenses []string `json:"userLicenses,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AutoDelete") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AutoDelete") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AttachedDisk) MarshalJSON() ([]byte, error) {
	type NoMethod AttachedDisk
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AttachedDiskInitializeParams: [Input Only] Specifies the parameters
// for a new disk that will be created alongside the new instance. Use
// initialization parameters to create boot disks or local SSDs attached
// to the new instance.
//
// This property is mutually exclusive with the source property; you can
// only define one or the other, but not both.
type AttachedDiskInitializeParams struct {
	// Description: An optional description. Provide this property when
	// creating the disk.
	Description string `json:"description,omitempty"`

	// DiskName: Specifies the disk name. If not specified, the default is
	// to use the name of the instance. If a disk with the same name already
	// exists in the given region, the existing disk is attached to the new
	// instance and the new disk is not created.
	DiskName string `json:"diskName,omitempty"`

	// DiskSizeGb: Specifies the size of the disk in base-2 GB. The size
	// must be at least 10 GB. If you specify a sourceImage, which is
	// required for boot disks, the default size is the size of the
	// sourceImage. If you do not specify a sourceImage, the default disk
	// size is 500 GB.
	DiskSizeGb int64 `json:"diskSizeGb,omitempty,string"`

	// DiskType: Specifies the disk type to use to create the instance. If
	// not specified, the default is pd-standard, specified using the full
	// URL. For
	// example:
	// https://www.googleapis.com/compute/v1/projects/project/zones/zone/diskTypes/pd-standard
	//
	//
	// Other values include pd-ssd and local-ssd. If you define this field,
	// you can provide either the full or partial URL. For example, the
	// following are valid values:
	// -
	// https://www.googleapis.com/compute/v1/projects/project/zones/zone/diskTypes/diskType
	//
	// - projects/project/zones/zone/diskTypes/diskType
	// - zones/zone/diskTypes/diskType  Note that for InstanceTemplate, this
	// is the name of the disk type, not URL.
	DiskType string `json:"diskType,omitempty"`

	// GuestOsFeatures: A list of features to enable on the guest operating
	// system. Applicable only for bootable images. Read  Enabling guest
	// operating system features to see a list of available options.
	//
	// Guest OS features are applied by merging
	// initializeParams.guestOsFeatures and disks.guestOsFeatures
	GuestOsFeatures []*GuestOsFeature `json:"guestOsFeatures,omitempty"`

	// Labels: Labels to apply to this disk. These can be later modified by
	// the disks.setLabels method. This field is only applicable for
	// persistent disks.
	Labels map[string]string `json:"labels,omitempty"`

	// MultiWriter: Indicates whether or not the disk can be read/write
	// attached to more than one instance.
	MultiWriter bool `json:"multiWriter,omitempty"`

	// OnUpdateAction: Specifies which action to take on instance update
	// with this disk. Default is to use the existing disk.
	//
	// Possible values:
	//   "RECREATE_DISK"
	//   "RECREATE_DISK_IF_SOURCE_CHANGED"
	//   "USE_EXISTING_DISK"
	OnUpdateAction string `json:"onUpdateAction,omitempty"`

	// ProvisionedIops: Indicates how many IOPS must be provisioned for the
	// disk.
	ProvisionedIops int64 `json:"provisionedIops,omitempty,string"`

	// ReplicaZones: URLs of the zones where the disk should be replicated
	// to. Only applicable for regional resources.
	ReplicaZones []string `json:"replicaZones,omitempty"`

	// ResourcePolicies: Resource policies applied to this disk for
	// automatic snapshot creations. Specified using the full or partial
	// URL. For instance template, specify only the resource policy name.
	ResourcePolicies []string `json:"resourcePolicies,omitempty"`

	// SourceImage: The source image to create this disk. When creating a
	// new instance, one of initializeParams.sourceImage or
	// initializeParams.sourceSnapshot or disks.source is required except
	// for local SSD.
	//
	// To create a disk with one of the public operating system images,
	// specify the image by its family name. For example, specify
	// family/debian-9 to use the latest Debian 9
	// image:
	// projects/debian-cloud/global/images/family/debian-9
	//
	//
	// Alternatively, use a specific version of a public operating system
	// image:
	// projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD
	//
	//
	// To create a disk with a custom image that you created, specify the
	// image name in the following
	// format:
	// global/images/my-custom-image
	//
	//
	// You can also specify a custom image by its image family, which
	// returns the latest version of the image in that family. Replace the
	// image name with
	// family/family-name:
	// global/images/family/my-image-family
	//
	//
	// If the source image is deleted later, this field will not be set.
	SourceImage string `json:"sourceImage,omitempty"`

	// SourceImageEncryptionKey: The customer-supplied encryption key of the
	// source image. Required if the source image is protected by a
	// customer-supplied encryption key.
	//
	// Instance templates do not store customer-supplied encryption keys, so
	// you cannot create disks for instances in a managed instance group if
	// the source images are encrypted with your own keys.
	SourceImageEncryptionKey *CustomerEncryptionKey `json:"sourceImageEncryptionKey,omitempty"`

	// SourceSnapshot: The source snapshot to create this disk. When
	// creating a new instance, one of initializeParams.sourceSnapshot or
	// initializeParams.sourceImage or disks.source is required except for
	// local SSD.
	//
	// To create a disk with a snapshot that you created, specify the
	// snapshot name in the following
	// format:
	// global/snapshots/my-backup
	//
	//
	// If the source snapshot is deleted later, this field will not be set.
	SourceSnapshot string `json:"sourceSnapshot,omitempty"`

	// SourceSnapshotEncryptionKey: The customer-supplied encryption key of
	// the source snapshot.
	SourceSnapshotEncryptionKey *CustomerEncryptionKey `json:"sourceSnapshotEncryptionKey,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AttachedDiskInitializeParams) MarshalJSON() ([]byte, error) {
	type NoMethod AttachedDiskInitializeParams
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AuditConfig: Specifies the audit configuration for a service. The
// configuration determines which permission types are logged, and what
// identities, if any, are exempted from logging. An AuditConfig must
// have one or more AuditLogConfigs.
//
// If there are AuditConfigs for both `allServices` and a specific
// service, the union of the two AuditConfigs is used for that service:
// the log_types specified in each AuditConfig are enabled, and the
// exempted_members in each AuditLogConfig are exempted.
//
// Example Policy with multiple AuditConfigs:
//
// { "audit_configs": [ { "service": "allServices", "audit_log_configs":
// [ { "log_type": "DATA_READ", "exempted_members": [
// "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, {
// "log_type": "ADMIN_READ" } ] }, { "service":
// "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type":
// "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [
// "user:aliya@example.com" ] } ] } ] }
//
// For sampleservice, this policy enables DATA_READ, DATA_WRITE and
// ADMIN_READ logging. It also exempts jose@example.com from DATA_READ
// logging, and aliya@example.com from DATA_WRITE logging.
type AuditConfig struct {
	// AuditLogConfigs: The configuration for logging of each type of
	// permission.
	AuditLogConfigs []*AuditLogConfig `json:"auditLogConfigs,omitempty"`

	ExemptedMembers []string `json:"exemptedMembers,omitempty"`

	// Service: Specifies a service that will be enabled for audit logging.
	// For example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
	// `allServices` is a special value that covers all services.
	Service string `json:"service,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AuditLogConfigs") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AuditLogConfigs") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AuditConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuditConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AuditLogConfig: Provides the configuration for logging a type of
// permissions. Example:
//
// { "audit_log_configs": [ { "log_type": "DATA_READ",
// "exempted_members": [ "user:jose@example.com" ] }, { "log_type":
// "DATA_WRITE" } ] }
//
// This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting
// jose@example.com from DATA_READ logging.
type AuditLogConfig struct {
	// ExemptedMembers: Specifies the identities that do not cause logging
	// for this type of permission. Follows the same format of
	// [Binding.members][].
	ExemptedMembers []string `json:"exemptedMembers,omitempty"`

	IgnoreChildExemptions bool `json:"ignoreChildExemptions,omitempty"`

	// LogType: The log type that this config enables.
	//
	// Possible values:
	//   "ADMIN_READ"
	//   "DATA_READ"
	//   "DATA_WRITE"
	//   "LOG_TYPE_UNSPECIFIED"
	LogType string `json:"logType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExemptedMembers") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExemptedMembers") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AuditLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuditLogConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AuthenticationPolicy: [Deprecated] The authentication settings for
// the backend service. The authentication settings for the backend
// service.
type AuthenticationPolicy struct {
	// Origins: List of authentication methods that can be used for origin
	// authentication. Similar to peers, these will be evaluated in order
	// the first valid one will be used to set origin identity. If none of
	// these methods pass, the request will be rejected with authentication
	// failed error (401). Leave the list empty if origin authentication is
	// not required.
	Origins []*OriginAuthenticationMethod `json:"origins,omitempty"`

	// Peers: List of authentication methods that can be used for peer
	// authentication. They will be evaluated in order the first valid one
	// will be used to set peer identity. If none of these methods pass, the
	// request will be rejected with authentication failed error (401).
	// Leave the list empty if peer authentication is not required.
	Peers []*PeerAuthenticationMethod `json:"peers,omitempty"`

	// PrincipalBinding: Define whether peer or origin identity should be
	// used for principal. Default value is USE_PEER. If peer (or origin)
	// identity is not available, either because peer/origin authentication
	// is not defined, or failed, principal will be left unset. In other
	// words, binding rule does not affect the decision to accept or reject
	// request. This field can be set to one of the following: USE_PEER:
	// Principal will be set to the identity from peer authentication.
	// USE_ORIGIN: Principal will be set to the identity from origin
	// authentication.
	//
	// Possible values:
	//   "INVALID"
	//   "USE_ORIGIN"
	//   "USE_PEER"
	PrincipalBinding string `json:"principalBinding,omitempty"`

	// ServerTlsContext: Configures the mechanism to obtain server-side
	// security certificates and identity information.
	ServerTlsContext *TlsContext `json:"serverTlsContext,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Origins") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Origins") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AuthenticationPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod AuthenticationPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AuthorizationConfig: [Deprecated] Authorization configuration
// provides service-level and method-level access control for a service.
// control for a service.
type AuthorizationConfig struct {
	// Policies: List of RbacPolicies.
	Policies []*RbacPolicy `json:"policies,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Policies") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Policies") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AuthorizationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuthorizationConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AuthorizationLoggingOptions: Authorization-related information used
// by Cloud Audit Logging.
type AuthorizationLoggingOptions struct {
	// PermissionType: The type of the permission that was checked.
	//
	// Possible values:
	//   "ADMIN_READ"
	//   "ADMIN_WRITE"
	//   "DATA_READ"
	//   "DATA_WRITE"
	//   "PERMISSION_TYPE_UNSPECIFIED"
	PermissionType string `json:"permissionType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PermissionType") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PermissionType") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AuthorizationLoggingOptions) MarshalJSON() ([]byte, error) {
	type NoMethod AuthorizationLoggingOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Autoscaler: Represents an Autoscaler resource.
//
// Google Compute Engine has two Autoscaler resources:
//
// * Zonal (/compute/docs/reference/rest/{$api_version}/autoscalers) *
// Regional
// (/compute/docs/reference/rest/{$api_version}/regionAutoscalers)
//
// Use autoscalers to automatically add or delete instances from a
// managed instance group according to your defined autoscaling policy.
// For more information, read Autoscaling Groups of Instances.
//
// For zonal managed instance groups resource, use the autoscaler
// resource.
//
// For regional managed instance groups, use the regionAutoscalers
// resource. (== resource_for {$api_version}.autoscalers ==) (==
// resource_for {$api_version}.regionAutoscalers ==)
type Autoscaler struct {
	// AutoscalingPolicy: The configuration parameters for the autoscaling
	// algorithm. You can define one or more of the policies for an
	// autoscaler: cpuUtilization, customMetricUtilizations, and
	// loadBalancingUtilization.
	//
	// If none of these are specified, the default will be to autoscale
	// based on cpuUtilization to 0.6 or 60%.
	AutoscalingPolicy *AutoscalingPolicy `json:"autoscalingPolicy,omitempty"`

	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// Kind: [Output Only] Type of the resource. Always compute#autoscaler
	// for autoscalers.
	Kind string `json:"kind,omitempty"`

	// Name: Name of the resource. Provided by the client when the resource
	// is created. The name must be 1-63 characters long, and comply with
	// RFC1035. Specifically, the name must be 1-63 characters long and
	// match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means
	// the first character must be a lowercase letter, and all following
	// characters must be a dash, lowercase letter, or digit, except the
	// last character, which cannot be a dash.
	Name string `json:"name,omitempty"`

	// RecommendedSize: [Output Only] Target recommended MIG size (number of
	// instances) computed by autoscaler. Autoscaler calculates the
	// recommended MIG size even when the autoscaling policy mode is
	// different from ON. This field is empty when autoscaler is not
	// connected to an existing managed instance group or autoscaler did not
	// generate its prediction.
	RecommendedSize int64 `json:"recommendedSize,omitempty"`

	// Region: [Output Only] URL of the region where the instance group
	// resides (for autoscalers living in regional scope).
	Region string `json:"region,omitempty"`

	// ScalingScheduleStatus: [Output Only] Status information of existing
	// scaling schedules.
	ScalingScheduleStatus map[string]ScalingScheduleStatus `json:"scalingScheduleStatus,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// Status: [Output Only] The status of the autoscaler configuration.
	// Current set of possible values:
	// - PENDING: Autoscaler backend hasn't read new/updated configuration.
	//
	// - DELETING: Configuration is being deleted.
	// - ACTIVE: Configuration is acknowledged to be effective. Some
	// warnings might be present in the statusDetails field.
	// - ERROR: Configuration has errors. Actionable for users. Details are
	// present in the statusDetails field.  New values might be added in the
	// future.
	//
	// Possible values:
	//   "ACTIVE"
	//   "DELETING"
	//   "ERROR"
	//   "PENDING"
	Status string `json:"status,omitempty"`

	// StatusDetails: [Output Only] Human-readable details about the current
	// state of the autoscaler. Read the documentation for Commonly returned
	// status messages for examples of status messages you might encounter.
	StatusDetails []*AutoscalerStatusDetails `json:"statusDetails,omitempty"`

	// Target: URL of the managed instance group that this autoscaler will
	// scale. This field is required when creating an autoscaler.
	Target string `json:"target,omitempty"`

	// Zone: [Output Only] URL of the zone where the instance group resides
	// (for autoscalers living in zonal scope).
	Zone string `json:"zone,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AutoscalingPolicy")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AutoscalingPolicy") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Autoscaler) MarshalJSON() ([]byte, error) {
	type NoMethod Autoscaler
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AutoscalerAggregatedList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of AutoscalersScopedList resources.
	Items map[string]AutoscalersScopedList `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#autoscalerAggregatedList for aggregated lists of autoscalers.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Unreachables: [Output Only] Unreachable resources.
	Unreachables []string `json:"unreachables,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *AutoscalerAggregatedListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalerAggregatedList) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalerAggregatedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AutoscalerAggregatedListWarning: [Output Only] Informational warning
// message.
type AutoscalerAggregatedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*AutoscalerAggregatedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalerAggregatedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalerAggregatedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AutoscalerAggregatedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalerAggregatedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalerAggregatedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AutoscalerList: Contains a list of Autoscaler resources.
type AutoscalerList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of Autoscaler resources.
	Items []*Autoscaler `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always compute#autoscalerList
	// for lists of autoscalers.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *AutoscalerListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalerList) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalerList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AutoscalerListWarning: [Output Only] Informational warning message.
type AutoscalerListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*AutoscalerListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalerListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalerListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AutoscalerListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalerListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalerListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AutoscalerStatusDetails struct {
	// Message: The status message.
	Message string `json:"message,omitempty"`

	// Type: The type of error, warning, or notice returned. Current set of
	// possible values:
	// - ALL_INSTANCES_UNHEALTHY (WARNING): All instances in the instance
	// group are unhealthy (not in RUNNING state).
	// - BACKEND_SERVICE_DOES_NOT_EXIST (ERROR): There is no backend service
	// attached to the instance group.
	// - CAPPED_AT_MAX_NUM_REPLICAS (WARNING): Autoscaler recommends a size
	// greater than maxNumReplicas.
	// - CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE (WARNING): The custom metric
	// samples are not exported often enough to be a credible base for
	// autoscaling.
	// - CUSTOM_METRIC_INVALID (ERROR): The custom metric that was specified
	// does not exist or does not have the necessary labels.
	// - MIN_EQUALS_MAX (WARNING): The minNumReplicas is equal to
	// maxNumReplicas. This means the autoscaler cannot add or remove
	// instances from the instance group.
	// - MISSING_CUSTOM_METRIC_DATA_POINTS (WARNING): The autoscaler did not
	// receive any data from the custom metric configured for autoscaling.
	//
	// - MISSING_LOAD_BALANCING_DATA_POINTS (WARNING): The autoscaler is
	// configured to scale based on a load balancing signal but the instance
	// group has not received any requests from the load balancer.
	// - MODE_OFF (WARNING): Autoscaling is turned off. The number of
	// instances in the group won't change automatically. The autoscaling
	// configuration is preserved.
	// - MODE_ONLY_UP (WARNING): Autoscaling is in the "Autoscale only out"
	// mode. The autoscaler can add instances but not remove any.
	// - MORE_THAN_ONE_BACKEND_SERVICE (ERROR): The instance group cannot be
	// autoscaled because it has more than one backend service attached to
	// it.
	// - NOT_ENOUGH_QUOTA_AVAILABLE (ERROR): There is insufficient quota for
	// the necessary resources, such as CPU or number of instances.
	// - REGION_RESOURCE_STOCKOUT (ERROR): Shown only for regional
	// autoscalers: there is a resource stockout in the chosen region.
	// - SCALING_TARGET_DOES_NOT_EXIST (ERROR): The target to be scaled does
	// not exist.
	// - UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION (ERROR):
	// Autoscaling does not work with an HTTP/S load balancer that has been
	// configured for maxRate.
	// - ZONE_RESOURCE_STOCKOUT (ERROR): For zonal autoscalers: there is a
	// resource stockout in the chosen zone. For regional autoscalers: in at
	// least one of the zones you're using there is a resource stockout.
	// New values might be added in the future. Some of the values might not
	// be available in all API versions.
	//
	// Possible values:
	//   "ALL_INSTANCES_UNHEALTHY"
	//   "BACKEND_SERVICE_DOES_NOT_EXIST"
	//   "CAPPED_AT_MAX_NUM_REPLICAS"
	//   "CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE"
	//   "CUSTOM_METRIC_INVALID"
	//   "MIN_EQUALS_MAX"
	//   "MISSING_CUSTOM_METRIC_DATA_POINTS"
	//   "MISSING_LOAD_BALANCING_DATA_POINTS"
	//   "MODE_OFF"
	//   "MODE_ONLY_SCALE_OUT"
	//   "MODE_ONLY_UP"
	//   "MORE_THAN_ONE_BACKEND_SERVICE"
	//   "NOT_ENOUGH_QUOTA_AVAILABLE"
	//   "REGION_RESOURCE_STOCKOUT"
	//   "SCALING_TARGET_DOES_NOT_EXIST"
	//   "SCHEDULED_INSTANCES_GREATER_THAN_AUTOSCALER_MAX"
	//   "SCHEDULED_INSTANCES_LESS_THAN_AUTOSCALER_MIN"
	//   "UNKNOWN"
	//   "UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION"
	//   "ZONE_RESOURCE_STOCKOUT"
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Message") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Message") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalerStatusDetails) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalerStatusDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AutoscalersScopedList struct {
	// Autoscalers: [Output Only] A list of autoscalers contained in this
	// scope.
	Autoscalers []*Autoscaler `json:"autoscalers,omitempty"`

	// Warning: [Output Only] Informational warning which replaces the list
	// of autoscalers when the list is empty.
	Warning *AutoscalersScopedListWarning `json:"warning,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Autoscalers") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Autoscalers") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalersScopedList) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalersScopedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AutoscalersScopedListWarning: [Output Only] Informational warning
// which replaces the list of autoscalers when the list is empty.
type AutoscalersScopedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*AutoscalersScopedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalersScopedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalersScopedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AutoscalersScopedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalersScopedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalersScopedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AutoscalingPolicy: Cloud Autoscaler policy.
type AutoscalingPolicy struct {
	// CoolDownPeriodSec: The number of seconds that the autoscaler waits
	// before it starts collecting information from a new instance. This
	// prevents the autoscaler from collecting information when the instance
	// is initializing, during which the collected usage would not be
	// reliable. The default time autoscaler waits is 60 seconds.
	//
	// Virtual machine initialization times might vary because of numerous
	// factors. We recommend that you test how long an instance may take to
	// initialize. To do this, create an instance and time the startup
	// process.
	CoolDownPeriodSec int64 `json:"coolDownPeriodSec,omitempty"`

	// CpuUtilization: Defines the CPU utilization policy that allows the
	// autoscaler to scale based on the average CPU utilization of a managed
	// instance group.
	CpuUtilization *AutoscalingPolicyCpuUtilization `json:"cpuUtilization,omitempty"`

	// CustomMetricUtilizations: Configuration parameters of autoscaling
	// based on a custom metric.
	CustomMetricUtilizations []*AutoscalingPolicyCustomMetricUtilization `json:"customMetricUtilizations,omitempty"`

	// LoadBalancingUtilization: Configuration parameters of autoscaling
	// based on load balancer.
	LoadBalancingUtilization *AutoscalingPolicyLoadBalancingUtilization `json:"loadBalancingUtilization,omitempty"`

	// MaxNumReplicas: The maximum number of instances that the autoscaler
	// can scale out to. This is required when creating or updating an
	// autoscaler. The maximum number of replicas must not be lower than
	// minimal number of replicas.
	MaxNumReplicas int64 `json:"maxNumReplicas,omitempty"`

	// MinNumReplicas: The minimum number of replicas that the autoscaler
	// can scale in to. This cannot be less than 0. If not provided,
	// autoscaler chooses a default value depending on maximum number of
	// instances allowed.
	MinNumReplicas int64 `json:"minNumReplicas,omitempty"`

	// Mode: Defines operating mode for this policy.
	//
	// Possible values:
	//   "OFF"
	//   "ON"
	//   "ONLY_SCALE_OUT"
	//   "ONLY_UP"
	Mode string `json:"mode,omitempty"`

	ScaleDownControl *AutoscalingPolicyScaleDownControl `json:"scaleDownControl,omitempty"`

	ScaleInControl *AutoscalingPolicyScaleInControl `json:"scaleInControl,omitempty"`

	// ScalingSchedules: Scaling schedules defined for an autoscaler.
	// Multiple schedules can be set on an autoscaler, and they can overlap.
	// During overlapping periods the greatest min_required_replicas of all
	// scaling schedules is applied. Up to 128 scaling schedules are
	// allowed.
	ScalingSchedules map[string]AutoscalingPolicyScalingSchedule `json:"scalingSchedules,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CoolDownPeriodSec")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CoolDownPeriodSec") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalingPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalingPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AutoscalingPolicyCpuUtilization: CPU utilization policy.
type AutoscalingPolicyCpuUtilization struct {
	// PredictiveMethod: Indicates whether predictive autoscaling based on
	// CPU metric is enabled. Valid values are:
	//
	// * NONE (default). No predictive method is used. The autoscaler scales
	// the group to meet current demand based on real-time metrics. *
	// OPTIMIZE_AVAILABILITY. Predictive autoscaling improves availability
	// by monitoring daily and weekly load patterns and scaling out ahead of
	// anticipated demand.
	//
	// Possible values:
	//   "NONE"
	//   "OPTIMIZE_AVAILABILITY"
	//   "PREDICTIVE_METHOD_UNSPECIFIED"
	//   "STANDARD"
	PredictiveMethod string `json:"predictiveMethod,omitempty"`

	// UtilizationTarget: The target CPU utilization that the autoscaler
	// maintains. Must be a float value in the range (0, 1]. If not
	// specified, the default is 0.6.
	//
	// If the CPU level is below the target utilization, the autoscaler
	// scales in the number of instances until it reaches the minimum number
	// of instances you specified or until the average CPU of your instances
	// reaches the target utilization.
	//
	// If the average CPU is above the target utilization, the autoscaler
	// scales out until it reaches the maximum number of instances you
	// specified or until the average utilization reaches the target
	// utilization.
	UtilizationTarget float64 `json:"utilizationTarget,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PredictiveMethod") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PredictiveMethod") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalingPolicyCpuUtilization) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalingPolicyCpuUtilization
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *AutoscalingPolicyCpuUtilization) UnmarshalJSON(data []byte) error {
	type NoMethod AutoscalingPolicyCpuUtilization
	var s1 struct {
		UtilizationTarget gensupport.JSONFloat64 `json:"utilizationTarget"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.UtilizationTarget = float64(s1.UtilizationTarget)
	return nil
}

// AutoscalingPolicyCustomMetricUtilization: Custom utilization metric
// policy.
type AutoscalingPolicyCustomMetricUtilization struct {
	// Filter: A filter string, compatible with a Stackdriver Monitoring
	// filter string for TimeSeries.list API call. This filter is used to
	// select a specific TimeSeries for the purpose of autoscaling and to
	// determine whether the metric is exporting per-instance or per-group
	// data.
	//
	// For the filter to be valid for autoscaling purposes, the following
	// rules apply:
	// - You can only use the AND operator for joining selectors.
	// - You can only use direct equality comparison operator (=) without
	// any functions for each selector.
	// - You can specify the metric in both the filter string and in the
	// metric field. However, if specified in both places, the metric must
	// be identical.
	// - The monitored resource type determines what kind of values are
	// expected for the metric. If it is a gce_instance, the autoscaler
	// expects the metric to include a separate TimeSeries for each instance
	// in a group. In such a case, you cannot filter on resource labels.
	// If the resource type is any other value, the autoscaler expects this
	// metric to contain values that apply to the entire autoscaled instance
	// group and resource label filtering can be performed to point
	// autoscaler at the correct TimeSeries to scale upon. This is called a
	// per-group metric for the purpose of autoscaling.
	//
	// If not specified, the type defaults to gce_instance.
	//
	// Try to provide a filter that is selective enough to pick just one
	// TimeSeries for the autoscaled group or for each of the instances (if
	// you are using gce_instance resource type). If multiple TimeSeries are
	// returned upon the query execution, the autoscaler will sum their
	// respective values to obtain its scaling value.
	Filter string `json:"filter,omitempty"`

	// Metric: The identifier (type) of the Stackdriver Monitoring metric.
	// The metric cannot have negative values.
	//
	// The metric must have a value type of INT64 or DOUBLE.
	Metric string `json:"metric,omitempty"`

	// SingleInstanceAssignment: If scaling is based on a per-group metric
	// value that represents the total amount of work to be done or resource
	// usage, set this value to an amount assigned for a single instance of
	// the scaled group. Autoscaler keeps the number of instances
	// proportional to the value of this metric. The metric itself does not
	// change value due to group resizing.
	//
	// A good metric to use with the target is for example
	// pubsub.googleapis.com/subscription/num_undelivered_messages or a
	// custom metric exporting the total number of requests coming to your
	// instances.
	//
	// A bad example would be a metric exporting an average or median
	// latency, since this value can't include a chunk assignable to a
	// single instance, it could be better used with utilization_target
	// instead.
	SingleInstanceAssignment float64 `json:"singleInstanceAssignment,omitempty"`

	// UtilizationTarget: The target value of the metric that autoscaler
	// maintains. This must be a positive value. A utilization metric scales
	// number of virtual machines handling requests to increase or decrease
	// proportionally to the metric.
	//
	// For example, a good metric to use as a utilization_target is
	// https://www.googleapis.com/compute/v1/instance/network/received_bytes_count.
	// The autoscaler works to keep this value constant for each of the
	// instances.
	UtilizationTarget float64 `json:"utilizationTarget,omitempty"`

	// UtilizationTargetType: Defines how target utilization value is
	// expressed for a Stackdriver Monitoring metric. Either GAUGE,
	// DELTA_PER_SECOND, or DELTA_PER_MINUTE.
	//
	// Possible values:
	//   "DELTA_PER_MINUTE"
	//   "DELTA_PER_SECOND"
	//   "GAUGE"
	UtilizationTargetType string `json:"utilizationTargetType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Filter") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalingPolicyCustomMetricUtilization) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalingPolicyCustomMetricUtilization
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *AutoscalingPolicyCustomMetricUtilization) UnmarshalJSON(data []byte) error {
	type NoMethod AutoscalingPolicyCustomMetricUtilization
	var s1 struct {
		SingleInstanceAssignment gensupport.JSONFloat64 `json:"singleInstanceAssignment"`
		UtilizationTarget        gensupport.JSONFloat64 `json:"utilizationTarget"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SingleInstanceAssignment = float64(s1.SingleInstanceAssignment)
	s.UtilizationTarget = float64(s1.UtilizationTarget)
	return nil
}

// AutoscalingPolicyLoadBalancingUtilization: Configuration parameters
// of autoscaling based on load balancing.
type AutoscalingPolicyLoadBalancingUtilization struct {
	// UtilizationTarget: Fraction of backend capacity utilization (set in
	// HTTP(S) load balancing configuration) that the autoscaler maintains.
	// Must be a positive float value. If not defined, the default is 0.8.
	UtilizationTarget float64 `json:"utilizationTarget,omitempty"`

	// ForceSendFields is a list of field names (e.g. "UtilizationTarget")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "UtilizationTarget") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalingPolicyLoadBalancingUtilization) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalingPolicyLoadBalancingUtilization
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *AutoscalingPolicyLoadBalancingUtilization) UnmarshalJSON(data []byte) error {
	type NoMethod AutoscalingPolicyLoadBalancingUtilization
	var s1 struct {
		UtilizationTarget gensupport.JSONFloat64 `json:"utilizationTarget"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.UtilizationTarget = float64(s1.UtilizationTarget)
	return nil
}

// AutoscalingPolicyScaleDownControl: Configuration that allows for
// slower scale in so that even if Autoscaler recommends an abrupt scale
// in of a MIG, it will be throttled as specified by the parameters
// below.
type AutoscalingPolicyScaleDownControl struct {
	// MaxScaledDownReplicas: Maximum allowed number (or %) of VMs that can
	// be deducted from the peak recommendation during the window autoscaler
	// looks at when computing recommendations. Possibly all these VMs can
	// be deleted at once so user service needs to be prepared to lose that
	// many VMs in one step.
	MaxScaledDownReplicas *FixedOrPercent `json:"maxScaledDownReplicas,omitempty"`

	// TimeWindowSec: How far back autoscaling looks when computing
	// recommendations to include directives regarding slower scale in, as
	// described above.
	TimeWindowSec int64 `json:"timeWindowSec,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "MaxScaledDownReplicas") to unconditionally include in API requests.
	// By default, fields with empty values are omitted from API requests.
	// However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MaxScaledDownReplicas") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalingPolicyScaleDownControl) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalingPolicyScaleDownControl
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AutoscalingPolicyScaleInControl: Configuration that allows for slower
// scale in so that even if Autoscaler recommends an abrupt scale in of
// a MIG, it will be throttled as specified by the parameters below.
type AutoscalingPolicyScaleInControl struct {
	// MaxScaledInReplicas: Maximum allowed number (or %) of VMs that can be
	// deducted from the peak recommendation during the window autoscaler
	// looks at when computing recommendations. Possibly all these VMs can
	// be deleted at once so user service needs to be prepared to lose that
	// many VMs in one step.
	MaxScaledInReplicas *FixedOrPercent `json:"maxScaledInReplicas,omitempty"`

	// TimeWindowSec: How far back autoscaling looks when computing
	// recommendations to include directives regarding slower scale in, as
	// described above.
	TimeWindowSec int64 `json:"timeWindowSec,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MaxScaledInReplicas")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MaxScaledInReplicas") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalingPolicyScaleInControl) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalingPolicyScaleInControl
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AutoscalingPolicyScalingSchedule: Scaling based on user-defined
// schedule. The message describes a single scaling schedule. A scaling
// schedule changes the minimum number of VM instances an autoscaler can
// recommend, which can trigger scaling out.
type AutoscalingPolicyScalingSchedule struct {
	// Description: A description of a scaling schedule.
	Description string `json:"description,omitempty"`

	// Disabled: A boolean value that specifies whether a scaling schedule
	// can influence autoscaler recommendations. If set to true, then a
	// scaling schedule has no effect. This field is optional, and its value
	// is false by default.
	Disabled bool `json:"disabled,omitempty"`

	// DurationSec: The duration of time intervals, in seconds, for which
	// this scaling schedule is to run. The minimum allowed value is 300.
	// This field is required.
	DurationSec int64 `json:"durationSec,omitempty"`

	// MinRequiredReplicas: The minimum number of VM instances that the
	// autoscaler will recommend in time intervals starting according to
	// schedule. This field is required.
	MinRequiredReplicas int64 `json:"minRequiredReplicas,omitempty"`

	// Schedule: The start timestamps of time intervals when this scaling
	// schedule is to provide a scaling signal. This field uses the extended
	// cron format (with an optional year field). The expression can
	// describe a single timestamp if the optional year is set, in which
	// case the scaling schedule runs once. The schedule is interpreted with
	// respect to time_zone. This field is required. Note: These timestamps
	// only describe when autoscaler starts providing the scaling signal.
	// The VMs need additional time to become serving.
	Schedule string `json:"schedule,omitempty"`

	// TimeZone: The time zone to use when interpreting the schedule. The
	// value of this field must be a time zone name from the tz database:
	// http://en.wikipedia.org/wiki/Tz_database. This field is assigned a
	// default value of ?UTC? if left empty.
	TimeZone string `json:"timeZone,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AutoscalingPolicyScalingSchedule) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalingPolicyScalingSchedule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Backend: Message containing information of one individual backend.
type Backend struct {
	// BalancingMode: Specifies how to determine whether the backend of a
	// load balancer can handle additional traffic or is fully loaded. For
	// usage guidelines, see  Connection balancing mode.
	//
	// Possible values:
	//   "CONNECTION"
	//   "RATE"
	//   "UTILIZATION"
	BalancingMode string `json:"balancingMode,omitempty"`

	// CapacityScaler: A multiplier applied to the backend's target capacity
	// of its balancing mode. The default value is 1, which means the group
	// serves up to 100% of its configured capacity (depending on
	// balancingMode). A setting of 0 means the group is completely drained,
	// offering 0% of its available capacity. The valid ranges are 0.0 and
	// [0.1,1.0]. You cannot configure a setting larger than 0 and smaller
	// than 0.1. You cannot configure a setting of 0 when there is only one
	// backend attached to the backend service.
	//
	// Not supported by:
	//
	// - Internal TCP/UDP Load Balancing - Network Load Balancing
	CapacityScaler float64 `json:"capacityScaler,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// Failover: This field designates whether this is a failover backend.
	// More than one failover backend can be configured for a given
	// BackendService.
	Failover bool `json:"failover,omitempty"`

	// Group: The fully-qualified URL of an instance group or network
	// endpoint group (NEG) resource. The type of backend that a backend
	// service supports depends on the backend service's
	// loadBalancingScheme.
	//
	//
	// - When the loadBalancingScheme for the backend service is EXTERNAL
	// (except Network Load Balancing),  INTERNAL_SELF_MANAGED, or
	// INTERNAL_MANAGED , the backend can be either an instance group or a
	// NEG. The backends on the backend service must be either all instance
	// groups or all NEGs. You cannot mix instance group and NEG backends on
	// the same backend service.
	//
	//
	// - When the loadBalancingScheme for the backend service is EXTERNAL
	// for Network Load Balancing or INTERNAL for Internal TCP/UDP Load
	// Balancing, the backend must be an instance group. NEGs are not
	// supported.
	//
	// For regional services, the backend must be in the same region as the
	// backend service.
	//
	// You must use the fully-qualified URL (starting with
	// https://www.googleapis.com/) to specify the instance group or NEG.
	// Partial URLs are not supported.
	Group string `json:"group,omitempty"`

	// MaxConnections: Defines a target maximum number of simultaneous
	// connections. For usage guidelines, see Connection balancing mode and
	// Utilization balancing mode. Not available if the backend's
	// balancingMode is RATE. Not supported by:
	//
	// - Internal TCP/UDP Load Balancing - Network Load Balancing
	MaxConnections int64 `json:"maxConnections,omitempty"`

	// MaxConnectionsPerEndpoint: Defines a target maximum number of
	// simultaneous connections. For usage guidelines, see Connection
	// balancing mode and Utilization balancing mode.
	//
	// Not available if the backend's balancingMode is RATE. Not supported
	// by:
	//
	// - Internal TCP/UDP Load Balancing - Network Load Balancing.
	MaxConnectionsPerEndpoint int64 `json:"maxConnectionsPerEndpoint,omitempty"`

	// MaxConnectionsPerInstance: Defines a target maximum number of
	// simultaneous connections. For usage guidelines, see Connection
	// balancing mode and Utilization balancing mode.
	//
	// Not available if the backend's balancingMode is RATE. Not supported
	// by:
	//
	// - Internal TCP/UDP Load Balancing - Network Load Balancing.
	MaxConnectionsPerInstance int64 `json:"maxConnectionsPerInstance,omitempty"`

	// MaxRate: Defines a maximum number of HTTP requests per second (RPS).
	// For usage guidelines, see Rate balancing mode and Utilization
	// balancing mode.
	//
	// Not available if the backend's balancingMode is CONNECTION.
	MaxRate int64 `json:"maxRate,omitempty"`

	// MaxRatePerEndpoint: Defines a maximum target for requests per second
	// (RPS). For usage guidelines, see Rate balancing mode and Utilization
	// balancing mode.
	//
	// Not available if the backend's balancingMode is CONNECTION.
	MaxRatePerEndpoint float64 `json:"maxRatePerEndpoint,omitempty"`

	// MaxRatePerInstance: Defines a maximum target for requests per second
	// (RPS). For usage guidelines, see Rate balancing mode and Utilization
	// balancing mode.
	//
	// Not available if the backend's balancingMode is CONNECTION.
	MaxRatePerInstance float64 `json:"maxRatePerInstance,omitempty"`

	MaxUtilization float64 `json:"maxUtilization,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BalancingMode") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BalancingMode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Backend) MarshalJSON() ([]byte, error) {
	type NoMethod Backend
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *Backend) UnmarshalJSON(data []byte) error {
	type NoMethod Backend
	var s1 struct {
		CapacityScaler     gensupport.JSONFloat64 `json:"capacityScaler"`
		MaxRatePerEndpoint gensupport.JSONFloat64 `json:"maxRatePerEndpoint"`
		MaxRatePerInstance gensupport.JSONFloat64 `json:"maxRatePerInstance"`
		MaxUtilization     gensupport.JSONFloat64 `json:"maxUtilization"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CapacityScaler = float64(s1.CapacityScaler)
	s.MaxRatePerEndpoint = float64(s1.MaxRatePerEndpoint)
	s.MaxRatePerInstance = float64(s1.MaxRatePerInstance)
	s.MaxUtilization = float64(s1.MaxUtilization)
	return nil
}

// BackendBucket: Represents a Cloud Storage Bucket resource.
//
// This Cloud Storage bucket resource is referenced by a URL map of a
// load balancer. For more information, read Backend Buckets.
type BackendBucket struct {
	// BucketName: Cloud Storage bucket name.
	BucketName string `json:"bucketName,omitempty"`

	// CdnPolicy: Cloud CDN configuration for this BackendBucket.
	CdnPolicy *BackendBucketCdnPolicy `json:"cdnPolicy,omitempty"`

	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// CustomResponseHeaders: Headers that the HTTP/S load balancer should
	// add to proxied responses.
	CustomResponseHeaders []string `json:"customResponseHeaders,omitempty"`

	// Description: An optional textual description of the resource;
	// provided by the client when the resource is created.
	Description string `json:"description,omitempty"`

	// EdgeSecurityPolicy: [Output Only] The resource URL for the edge
	// security policy associated with this backend bucket.
	EdgeSecurityPolicy string `json:"edgeSecurityPolicy,omitempty"`

	// EnableCdn: If true, enable Cloud CDN for this BackendBucket.
	EnableCdn bool `json:"enableCdn,omitempty"`

	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id uint64 `json:"id,omitempty,string"`

	// Kind: Type of the resource.
	Kind string `json:"kind,omitempty"`

	// Name: Name of the resource. Provided by the client when the resource
	// is created. The name must be 1-63 characters long, and comply with
	// RFC1035. Specifically, the name must be 1-63 characters long and
	// match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means
	// the first character must be a lowercase letter, and all following
	// characters must be a dash, lowercase letter, or digit, except the
	// last character, which cannot be a dash.
	Name string `json:"name,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "BucketName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BucketName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendBucket) MarshalJSON() ([]byte, error) {
	type NoMethod BackendBucket
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendBucketCdnPolicy: Message containing Cloud CDN configuration
// for a backend bucket.
type BackendBucketCdnPolicy struct {
	// BypassCacheOnRequestHeaders: Bypass the cache when the specified
	// request headers are matched - e.g. Pragma or Authorization headers.
	// Up to 5 headers can be specified. The cache is bypassed for all
	// cdnPolicy.cacheMode settings.
	BypassCacheOnRequestHeaders []*BackendBucketCdnPolicyBypassCacheOnRequestHeader `json:"bypassCacheOnRequestHeaders,omitempty"`

	// CacheMode: Specifies the cache setting for all responses from this
	// backend. The possible values are:
	//
	// USE_ORIGIN_HEADERS Requires the origin to set valid caching headers
	// to cache content. Responses without these headers will not be cached
	// at Google's edge, and will require a full trip to the origin on every
	// request, potentially impacting performance and increasing load on the
	// origin server.
	//
	// FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store"
	// or "no-cache" directives in Cache-Control response headers. Warning:
	// this may result in Cloud CDN caching private, per-user (user
	// identifiable) content.
	//
	// CACHE_ALL_STATIC Automatically cache static content, including common
	// image formats, media (video and audio), and web assets (JavaScript
	// and CSS). Requests and responses that are marked as uncacheable, as
	// well as dynamic content (including HTML), will not be cached.
	//
	// Possible values:
	//   "CACHE_ALL_STATIC"
	//   "FORCE_CACHE_ALL"
	//   "INVALID_CACHE_MODE"
	//   "USE_ORIGIN_HEADERS"
	CacheMode string `json:"cacheMode,omitempty"`

	// ClientTtl: Specifies a separate client (e.g. browser client) maximum
	// TTL. This is used to clamp the max-age (or Expires) value sent to the
	// client. With FORCE_CACHE_ALL, the lesser of client_ttl and
	// default_ttl is used for the response max-age directive, along with a
	// "public" directive. For cacheable content in CACHE_ALL_STATIC mode,
	// client_ttl clamps the max-age from the origin (if specified), or else
	// sets the response max-age directive to the lesser of the client_ttl
	// and default_ttl, and also ensures a "public" cache-control directive
	// is present. If a client TTL is not specified, a default value (1
	// hour) will be used. The maximum allowed value is 86400s (1 day).
	ClientTtl int64 `json:"clientTtl,omitempty"`

	// DefaultTtl: Specifies the default TTL for cached content served by
	// this origin for responses that do not have an existing valid TTL
	// (max-age or s-max-age). Setting a TTL of "0" means "always
	// revalidate". The value of defaultTTL cannot be set to a value greater
	// than that of maxTTL, but can be equal. When the cacheMode is set to
	// FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all
	// responses. The maximum allowed value is 31,622,400s (1 year), noting
	// that infrequently accessed objects may be evicted from the cache
	// before the defined TTL.
	DefaultTtl int64 `json:"defaultTtl,omitempty"`

	// MaxTtl: Specifies the maximum allowed TTL for cached content served
	// by this origin. Cache directives that attempt to set a max-age or
	// s-maxage higher than this, or an Expires header more than maxTTL
	// seconds in the future will be capped at the value of maxTTL, as if it
	// were the value of an s-maxage Cache-Control directive. Headers sent
	// to the client will not be modified. Setting a TTL of "0" means
	// "always revalidate". The maximum allowed value is 31,622,400s (1
	// year), noting that infrequently accessed objects may be evicted from
	// the cache before the defined TTL.
	MaxTtl int64 `json:"maxTtl,omitempty"`

	// NegativeCaching: Negative caching allows per-status code TTLs to be
	// set, in order to apply fine-grained caching for common errors or
	// redirects. This can reduce the load on your origin and improve
	// end-user experience by reducing response latency. When the cache mode
	// is set to CACHE_ALL_STATIC or USE_ORIGIN_HEADERS, negative caching
	// applies to responses with the specified response code that lack any
	// Cache-Control, Expires, or Pragma: no-cache directives. When the
	// cache mode is set to FORCE_CACHE_ALL, negative caching applies to all
	// responses with the specified response code, and override any caching
	// headers. By default, Cloud CDN will apply the following default TTLs
	// to these status codes: HTTP 300 (Multiple Choice), 301, 308
	// (Permanent Redirects): 10m HTTP 404 (Not Found), 410 (Gone), 451
	// (Unavailable For Legal Reasons): 120s HTTP 405 (Method Not Found),
	// 421 (Misdirected Request), 501 (Not Implemented): 60s. These defaults
	// can be overridden in negative_caching_policy.
	NegativeCaching bool `json:"negativeCaching,omitempty"`

	// NegativeCachingPolicy: Sets a cache TTL for the specified HTTP status
	// code. negative_caching must be enabled to configure
	// negative_caching_policy. Omitting the policy and leaving
	// negative_caching enabled will use Cloud CDN's default cache TTLs.
	// Note that when specifying an explicit negative_caching_policy, you
	// should take care to specify a cache TTL for all response codes that
	// you wish to cache. Cloud CDN will not apply any default negative
	// caching when a policy exists.
	NegativeCachingPolicy []*BackendBucketCdnPolicyNegativeCachingPolicy `json:"negativeCachingPolicy,omitempty"`

	// RequestCoalescing: If true then Cloud CDN will combine multiple
	// concurrent cache fill requests into a small number of requests to the
	// origin.
	RequestCoalescing bool `json:"requestCoalescing,omitempty"`

	// ServeWhileStale: Serve existing content from the cache (if available)
	// when revalidating content with the origin, or when an error is
	// encountered when refreshing the cache. This setting defines the
	// default "max-stale" duration for any cached responses that do not
	// specify a max-stale directive. Stale responses that exceed the TTL
	// configured here will not be served. The default limit (max-stale) is
	// 86400s (1 day), which will allow stale content to be served up to
	// this limit beyond the max-age (or s-max-age) of a cached response.
	// The maximum allowed value is 604800 (1 week). Set this to zero (0) to
	// disable serve-while-stale.
	ServeWhileStale int64 `json:"serveWhileStale,omitempty"`

	// SignedUrlCacheMaxAgeSec: Maximum number of seconds the response to a
	// signed URL request will be considered fresh. After this time period,
	// the response will be revalidated before being served. Defaults to 1hr
	// (3600s). When serving responses to signed URL requests, Cloud CDN
	// will internally behave as though all responses from this backend had
	// a "Cache-Control: public, max-age=[TTL]" header, regardless of any
	// existing Cache-Control header. The actual headers served in responses
	// will not be altered.
	SignedUrlCacheMaxAgeSec int64 `json:"signedUrlCacheMaxAgeSec,omitempty,string"`

	// SignedUrlKeyNames: [Output Only] Names of the keys for signing
	// request URLs.
	SignedUrlKeyNames []string `json:"signedUrlKeyNames,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "BypassCacheOnRequestHeaders") to unconditionally include in API
	// requests. By default, fields with empty values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "BypassCacheOnRequestHeaders") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendBucketCdnPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod BackendBucketCdnPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendBucketCdnPolicyBypassCacheOnRequestHeader: Bypass the cache
// when the specified request headers are present, e.g. Pragma or
// Authorization headers. Values are case insensitive. The presence of
// such a header overrides the cache_mode setting.
type BackendBucketCdnPolicyBypassCacheOnRequestHeader struct {
	// HeaderName: The header field name to match on when bypassing cache.
	// Values are case-insensitive.
	HeaderName string `json:"headerName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HeaderName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HeaderName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendBucketCdnPolicyBypassCacheOnRequestHeader) MarshalJSON() ([]byte, error) {
	type NoMethod BackendBucketCdnPolicyBypassCacheOnRequestHeader
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendBucketCdnPolicyNegativeCachingPolicy: Specify CDN TTLs for
// response error codes.
type BackendBucketCdnPolicyNegativeCachingPolicy struct {
	// Code: The HTTP status code to define a TTL against. Only HTTP status
	// codes 300, 301, 302, 307, 308, 404, 405, 410, 421, 451 and 501 are
	// can be specified as values, and you cannot specify a status code more
	// than once.
	Code int64 `json:"code,omitempty"`

	// Ttl: The TTL (in seconds) for which to cache responses with the
	// corresponding status code. The maximum allowed value is 1800s (30
	// minutes), noting that infrequently accessed objects may be evicted
	// from the cache before the defined TTL.
	Ttl int64 `json:"ttl,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendBucketCdnPolicyNegativeCachingPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod BackendBucketCdnPolicyNegativeCachingPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendBucketList: Contains a list of BackendBucket resources.
type BackendBucketList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of BackendBucket resources.
	Items []*BackendBucket `json:"items,omitempty"`

	// Kind: Type of resource.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *BackendBucketListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendBucketList) MarshalJSON() ([]byte, error) {
	type NoMethod BackendBucketList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendBucketListWarning: [Output Only] Informational warning
// message.
type BackendBucketListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*BackendBucketListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendBucketListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod BackendBucketListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type BackendBucketListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendBucketListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod BackendBucketListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendService: Represents a Backend Service resource.
//
// A backend service defines how Google Cloud load balancers distribute
// traffic. The backend service configuration contains a set of values,
// such as the protocol used to connect to backends, various
// distribution and session settings, health checks, and timeouts. These
// settings provide fine-grained control over how your load balancer
// behaves. Most of the settings have default values that allow for easy
// configuration if you need to get started quickly.
//
// Backend services in Google Compute Engine can be either regionally or
// globally scoped.
//
// * Global
// (/compute/docs/reference/rest/{$api_version}/backendServices) *
// Regional
// (/compute/docs/reference/rest/{$api_version}/regionBackendServices)
//
// For more information, see Backend Services.
//
// (== resource_for {$api_version}.backendService ==)
type BackendService struct {
	// AffinityCookieTtlSec: Lifetime of cookies in seconds. Only applicable
	// if the loadBalancingScheme is EXTERNAL, INTERNAL_SELF_MANAGED, or
	// INTERNAL_MANAGED, the protocol is HTTP or HTTPS, and the
	// sessionAffinity is GENERATED_COOKIE, or HTTP_COOKIE.
	//
	// If set to 0, the cookie is non-persistent and lasts only until the
	// end of the browser session (or equivalent). The maximum allowed value
	// is one day (86,400).
	//
	// Not supported when the backend service is referenced by a URL map
	// that is bound to target gRPC proxy that has validateForProxyless
	// field set to true.
	AffinityCookieTtlSec int64 `json:"affinityCookieTtlSec,omitempty"`

	// Backends: The list of backends that serve this BackendService.
	Backends []*Backend `json:"backends,omitempty"`

	// CdnPolicy: Cloud CDN configuration for this BackendService. Only
	// available for  external HTTP(S) Load Balancing.
	CdnPolicy *BackendServiceCdnPolicy `json:"cdnPolicy,omitempty"`

	// CircuitBreakers: Settings controlling the volume of connections to a
	// backend service. If not set, this feature is considered
	// disabled.
	//
	// This field is applicable to either:
	// - A regional backend service with the service_protocol set to HTTP,
	// HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
	//
	// - A global backend service with the load_balancing_scheme set to
	// INTERNAL_SELF_MANAGED.
	//
	// Not supported when the backend service is referenced by a URL map
	// that is bound to target gRPC proxy that has validateForProxyless
	// field set to true.
	CircuitBreakers *CircuitBreakers `json:"circuitBreakers,omitempty"`

	ConnectionDraining *ConnectionDraining `json:"connectionDraining,omitempty"`

	ConnectionTrackingPolicy *BackendServiceConnectionTrackingPolicy `json:"connectionTrackingPolicy,omitempty"`

	// ConsistentHash: Consistent Hash-based load balancing can be used to
	// provide soft session affinity based on HTTP headers, cookies or other
	// properties. This load balancing policy is applicable only for HTTP
	// connections. The affinity to a particular destination host will be
	// lost when one or more hosts are added/removed from the destination
	// service. This field specifies parameters that control consistent
	// hashing. This field is only applicable when localityLbPolicy is set
	// to MAGLEV or RING_HASH.
	//
	// This field is applicable to either:
	// - A regional backend service with the service_protocol set to HTTP,
	// HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
	//
	// - A global backend service with the load_balancing_scheme set to
	// INTERNAL_SELF_MANAGED.
	//
	// Not supported when the backend service is referenced by a URL map
	// that is bound to target gRPC proxy that has validateForProxyless
	// field set to true.
	ConsistentHash *ConsistentHashLoadBalancerSettings `json:"consistentHash,omitempty"`

	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// CustomRequestHeaders: Headers that the HTTP/S load balancer should
	// add to proxied requests.
	CustomRequestHeaders []string `json:"customRequestHeaders,omitempty"`

	// CustomResponseHeaders: Headers that the HTTP/S load balancer should
	// add to proxied responses.
	CustomResponseHeaders []string `json:"customResponseHeaders,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// EdgeSecurityPolicy: [Output Only] The resource URL for the edge
	// security policy associated with this backend service.
	EdgeSecurityPolicy string `json:"edgeSecurityPolicy,omitempty"`

	// EnableCDN: If true, enables Cloud CDN for the backend service. Only
	// applicable if the loadBalancingScheme is EXTERNAL and the protocol is
	// HTTP or HTTPS.
	EnableCDN bool `json:"enableCDN,omitempty"`

	// FailoverPolicy: Applicable only to Failover for Internal TCP/UDP Load
	// Balancing and Network Load Balancing. Requires at least one backend
	// instance group to be defined as a backup (failover) backend.
	FailoverPolicy *BackendServiceFailoverPolicy `json:"failoverPolicy,omitempty"`

	// Fingerprint: Fingerprint of this resource. A hash of the contents
	// stored in this object. This field is used in optimistic locking. This
	// field will be ignored when inserting a BackendService. An up-to-date
	// fingerprint must be provided in order to update the BackendService,
	// otherwise the request will fail with error 412 conditionNotMet.
	//
	// To see the latest fingerprint, make a get() request to retrieve a
	// BackendService.
	Fingerprint string `json:"fingerprint,omitempty"`

	// HealthChecks: The list of URLs to the healthChecks, httpHealthChecks
	// (legacy), or httpsHealthChecks (legacy) resource for health checking
	// this backend service. Not all backend services support legacy health
	// checks. See  Load balancer guide. Currently, at most one health check
	// can be specified for each backend service. Backend services with
	// instance group or zonal NEG backends must have a health check.
	// Backend services with internet or serverless NEG backends must not
	// have a health check.
	HealthChecks []string `json:"healthChecks,omitempty"`

	// Iap: The configurations for Identity-Aware Proxy on this resource.
	// Not available for Internal TCP/UDP Load Balancing and Network Load
	// Balancing.
	Iap *BackendServiceIAP `json:"iap,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// Kind: [Output Only] Type of resource. Always compute#backendService
	// for backend services.
	Kind string `json:"kind,omitempty"`

	// LoadBalancingScheme: Specifies the load balancer type. Choose
	// EXTERNAL for external HTTP(S), SSL Proxy, TCP Proxy and Network Load
	// Balancing. Choose  INTERNAL for Internal TCP/UDP Load Balancing.
	// Choose  INTERNAL_MANAGED for Internal HTTP(S) Load Balancing.
	// INTERNAL_SELF_MANAGED for Traffic Director. A backend service created
	// for one type of load balancer cannot be used with another. For more
	// information, refer to Choosing a load balancer.
	//
	// Possible values:
	//   "EXTERNAL"
	//   "EXTERNAL_MANAGED"
	//   "INTERNAL"
	//   "INTERNAL_MANAGED"
	//   "INTERNAL_SELF_MANAGED"
	//   "INVALID_LOAD_BALANCING_SCHEME"
	LoadBalancingScheme string `json:"loadBalancingScheme,omitempty"`

	// LocalityLbPolicy: The load balancing algorithm used within the scope
	// of the locality. The possible values are:
	// - ROUND_ROBIN: This is a simple policy in which each healthy backend
	// is selected in round robin order. This is the default.
	// - LEAST_REQUEST: An O(1) algorithm which selects two random healthy
	// hosts and picks the host which has fewer active requests.
	// - RING_HASH: The ring/modulo hash load balancer implements consistent
	// hashing to backends. The algorithm has the property that the
	// addition/removal of a host from a set of N hosts only affects 1/N of
	// the requests.
	// - RANDOM: The load balancer selects a random healthy host.
	// - ORIGINAL_DESTINATION: Backend host is selected based on the client
	// connection metadata, i.e., connections are opened to the same address
	// as the destination address of the incoming connection before the
	// connection was redirected to the load balancer.
	// - MAGLEV: used as a drop in replacement for the ring hash load
	// balancer. Maglev is not as stable as ring hash but has faster table
	// lookup build times and host selection times. For more information
	// about Maglev, see https://ai.google/research/pubs/pub44824
	//
	// This field is applicable to either:
	// - A regional backend service with the service_protocol set to HTTP,
	// HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
	//
	// - A global backend service with the load_balancing_scheme set to
	// INTERNAL_SELF_MANAGED.
	//
	// If sessionAffinity is not NONE, and this field is not set to MAGLEV
	// or RING_HASH, session affinity settings will not take effect.
	//
	// Only the default ROUND_ROBIN policy is supported when the backend
	// service is referenced by a URL map that is bound to target gRPC proxy
	// that has validateForProxyless field set to true.
	//
	// Possible values:
	//   "INVALID_LB_POLICY"
	//   "LEAST_REQUEST"
	//   "MAGLEV"
	//   "ORIGINAL_DESTINATION"
	//   "RANDOM"
	//   "RING_HASH"
	//   "ROUND_ROBIN"
	LocalityLbPolicy string `json:"localityLbPolicy,omitempty"`

	// LogConfig: This field denotes the logging options for the load
	// balancer traffic served by this backend service. If logging is
	// enabled, logs will be exported to Stackdriver.
	LogConfig *BackendServiceLogConfig `json:"logConfig,omitempty"`

	// MaxStreamDuration: Specifies the default maximum duration (timeout)
	// for streams to this service. Duration is computed from the beginning
	// of the stream until the response has been completely processed,
	// including all retries. A stream that does not complete in this
	// duration is closed.
	// If not specified, there will be no timeout limit, i.e. the maximum
	// duration is infinite.
	// This field is only allowed when the loadBalancingScheme of the
	// backend service is INTERNAL_SELF_MANAGED.
	MaxStreamDuration *Duration `json:"maxStreamDuration,omitempty"`

	// Name: Name of the resource. Provided by the client when the resource
	// is created. The name must be 1-63 characters long, and comply with
	// RFC1035. Specifically, the name must be 1-63 characters long and
	// match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means
	// the first character must be a lowercase letter, and all following
	// characters must be a dash, lowercase letter, or digit, except the
	// last character, which cannot be a dash.
	Name string `json:"name,omitempty"`

	// Network: The URL of the network to which this backend service
	// belongs. This field can only be specified when the load balancing
	// scheme is set to INTERNAL.
	Network string `json:"network,omitempty"`

	// OutlierDetection: Settings controlling the eviction of unhealthy
	// hosts from the load balancing pool for the backend service. If not
	// set, this feature is considered disabled.
	//
	// This field is applicable to either:
	// - A regional backend service with the service_protocol set to HTTP,
	// HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
	//
	// - A global backend service with the load_balancing_scheme set to
	// INTERNAL_SELF_MANAGED.
	//
	// Not supported when the backend service is referenced by a URL map
	// that is bound to target gRPC proxy that has validateForProxyless
	// field set to true.
	OutlierDetection *OutlierDetection `json:"outlierDetection,omitempty"`

	// Port: Deprecated in favor of portName. The TCP port to connect on the
	// backend. The default value is 80.
	//
	// Backend services for Internal TCP/UDP Load Balancing and Network Load
	// Balancing require you omit port.
	Port int64 `json:"port,omitempty"`

	// PortName: A named port on a backend instance group representing the
	// port for communication to the backend VMs in that group. Required
	// when the loadBalancingScheme is EXTERNAL (except Network Load
	// Balancing), INTERNAL_MANAGED, or  INTERNAL_SELF_MANAGED and the
	// backends are instance groups. The named port must be defined on each
	// backend instance group. This parameter has no meaning if the backends
	// are NEGs.
	//
	//
	//
	// Backend services for Internal TCP/UDP Load Balancing and Network Load
	// Balancing require you omit port_name.
	PortName string `json:"portName,omitempty"`

	// Protocol: The protocol this BackendService uses to communicate with
	// backends.
	//
	// Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC.
	// depending on the chosen load balancer or Traffic Director
	// configuration. Refer to the documentation for the load balancer or
	// for Traffic Director for more information.
	//
	// Must be set to GRPC when the backend service is referenced by a URL
	// map that is bound to target gRPC proxy.
	//
	// Possible values:
	//   "ALL"
	//   "GRPC"
	//   "HTTP"
	//   "HTTP2"
	//   "HTTPS"
	//   "SSL"
	//   "TCP"
	//   "UDP"
	Protocol string `json:"protocol,omitempty"`

	// Region: [Output Only] URL of the region where the regional backend
	// service resides. This field is not applicable to global backend
	// services. You must specify this field as part of the HTTP request
	// URL. It is not settable as a field in the request body.
	Region string `json:"region,omitempty"`

	// SecurityPolicy: [Output Only] The resource URL for the security
	// policy associated with this backend service.
	SecurityPolicy string `json:"securityPolicy,omitempty"`

	// SecuritySettings: This field specifies the security policy that
	// applies to this backend service. This field is applicable to either:
	//
	// - A regional backend service with the service_protocol set to HTTP,
	// HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
	//
	// - A global backend service with the load_balancing_scheme set to
	// INTERNAL_SELF_MANAGED.
	SecuritySettings *SecuritySettings `json:"securitySettings,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// SessionAffinity: Type of session affinity to use. The default is
	// NONE.
	//
	// When the loadBalancingScheme is EXTERNAL: * For Network Load
	// Balancing, the possible values are NONE, CLIENT_IP, CLIENT_IP_PROTO,
	// or CLIENT_IP_PORT_PROTO. * For all other load balancers that use
	// loadBalancingScheme=EXTERNAL, the possible values are NONE,
	// CLIENT_IP, or GENERATED_COOKIE. * You can use GENERATED_COOKIE if the
	// protocol is HTTP, HTTP2, or HTTPS.
	//
	// When the loadBalancingScheme is INTERNAL, possible values are NONE,
	// CLIENT_IP, CLIENT_IP_PROTO, or CLIENT_IP_PORT_PROTO.
	//
	// When the loadBalancingScheme is INTERNAL_SELF_MANAGED, or
	// INTERNAL_MANAGED, possible values are NONE, CLIENT_IP,
	// GENERATED_COOKIE, HEADER_FIELD, or HTTP_COOKIE.
	//
	// Not supported when the backend service is referenced by a URL map
	// that is bound to target gRPC proxy that has validateForProxyless
	// field set to true.
	//
	// Possible values:
	//   "CLIENT_IP"
	//   "CLIENT_IP_NO_DESTINATION"
	//   "CLIENT_IP_PORT_PROTO"
	//   "CLIENT_IP_PROTO"
	//   "GENERATED_COOKIE"
	//   "HEADER_FIELD"
	//   "HTTP_COOKIE"
	//   "NONE"
	SessionAffinity string `json:"sessionAffinity,omitempty"`

	Subsetting *Subsetting `json:"subsetting,omitempty"`

	// TimeoutSec: The backend service timeout has a different meaning
	// depending on the type of load balancer. For more information see,
	// Backend service settings The default is 30 seconds. The full range of
	// timeout values allowed is 1 - 2,147,483,647 seconds.
	TimeoutSec int64 `json:"timeoutSec,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "AffinityCookieTtlSec") to unconditionally include in API requests.
	// By default, fields with empty values are omitted from API requests.
	// However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AffinityCookieTtlSec") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BackendService) MarshalJSON() ([]byte, error) {
	type NoMethod BackendService
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendServiceAggregatedList: Contains a list of
// BackendServicesScopedList.
type BackendServiceAggregatedList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of BackendServicesScopedList resources.
	Items map[string]BackendServicesScopedList `json:"items,omitempty"`

	// Kind: Type of resource.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Unreachables: [Output Only] Unreachable resources.
	Unreachables []string `json:"unreachables,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *BackendServiceAggregatedListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceAggregatedList) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceAggregatedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendServiceAggregatedListWarning: [Output Only] Informational
// warning message.
type BackendServiceAggregatedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*BackendServiceAggregatedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceAggregatedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceAggregatedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type BackendServiceAggregatedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceAggregatedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceAggregatedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendServiceCdnPolicy: Message containing Cloud CDN configuration
// for a backend service.
type BackendServiceCdnPolicy struct {
	// BypassCacheOnRequestHeaders: Bypass the cache when the specified
	// request headers are matched - e.g. Pragma or Authorization headers.
	// Up to 5 headers can be specified. The cache is bypassed for all
	// cdnPolicy.cacheMode settings.
	BypassCacheOnRequestHeaders []*BackendServiceCdnPolicyBypassCacheOnRequestHeader `json:"bypassCacheOnRequestHeaders,omitempty"`

	// CacheKeyPolicy: The CacheKeyPolicy for this CdnPolicy.
	CacheKeyPolicy *CacheKeyPolicy `json:"cacheKeyPolicy,omitempty"`

	// CacheMode: Specifies the cache setting for all responses from this
	// backend. The possible values are:
	//
	// USE_ORIGIN_HEADERS Requires the origin to set valid caching headers
	// to cache content. Responses without these headers will not be cached
	// at Google's edge, and will require a full trip to the origin on every
	// request, potentially impacting performance and increasing load on the
	// origin server.
	//
	// FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store"
	// or "no-cache" directives in Cache-Control response headers. Warning:
	// this may result in Cloud CDN caching private, per-user (user
	// identifiable) content.
	//
	// CACHE_ALL_STATIC Automatically cache static content, including common
	// image formats, media (video and audio), and web assets (JavaScript
	// and CSS). Requests and responses that are marked as uncacheable, as
	// well as dynamic content (including HTML), will not be cached.
	//
	// Possible values:
	//   "CACHE_ALL_STATIC"
	//   "FORCE_CACHE_ALL"
	//   "INVALID_CACHE_MODE"
	//   "USE_ORIGIN_HEADERS"
	CacheMode string `json:"cacheMode,omitempty"`

	// ClientTtl: Specifies a separate client (e.g. browser client) maximum
	// TTL. This is used to clamp the max-age (or Expires) value sent to the
	// client. With FORCE_CACHE_ALL, the lesser of client_ttl and
	// default_ttl is used for the response max-age directive, along with a
	// "public" directive. For cacheable content in CACHE_ALL_STATIC mode,
	// client_ttl clamps the max-age from the origin (if specified), or else
	// sets the response max-age directive to the lesser of the client_ttl
	// and default_ttl, and also ensures a "public" cache-control directive
	// is present. If a client TTL is not specified, a default value (1
	// hour) will be used. The maximum allowed value is 86400s (1 day).
	ClientTtl int64 `json:"clientTtl,omitempty"`

	// DefaultTtl: Specifies the default TTL for cached content served by
	// this origin for responses that do not have an existing valid TTL
	// (max-age or s-max-age). Setting a TTL of "0" means "always
	// revalidate". The value of defaultTTL cannot be set to a value greater
	// than that of maxTTL, but can be equal. When the cacheMode is set to
	// FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all
	// responses. The maximum allowed value is 31,622,400s (1 year), noting
	// that infrequently accessed objects may be evicted from the cache
	// before the defined TTL.
	DefaultTtl int64 `json:"defaultTtl,omitempty"`

	// MaxTtl: Specifies the maximum allowed TTL for cached content served
	// by this origin. Cache directives that attempt to set a max-age or
	// s-maxage higher than this, or an Expires header more than maxTTL
	// seconds in the future will be capped at the value of maxTTL, as if it
	// were the value of an s-maxage Cache-Control directive. Headers sent
	// to the client will not be modified. Setting a TTL of "0" means
	// "always revalidate". The maximum allowed value is 31,622,400s (1
	// year), noting that infrequently accessed objects may be evicted from
	// the cache before the defined TTL.
	MaxTtl int64 `json:"maxTtl,omitempty"`

	// NegativeCaching: Negative caching allows per-status code TTLs to be
	// set, in order to apply fine-grained caching for common errors or
	// redirects. This can reduce the load on your origin and improve
	// end-user experience by reducing response latency. When the cache mode
	// is set to CACHE_ALL_STATIC or USE_ORIGIN_HEADERS, negative caching
	// applies to responses with the specified response code that lack any
	// Cache-Control, Expires, or Pragma: no-cache directives. When the
	// cache mode is set to FORCE_CACHE_ALL, negative caching applies to all
	// responses with the specified response code, and override any caching
	// headers. By default, Cloud CDN will apply the following default TTLs
	// to these status codes: HTTP 300 (Multiple Choice), 301, 308
	// (Permanent Redirects): 10m HTTP 404 (Not Found), 410 (Gone), 451
	// (Unavailable For Legal Reasons): 120s HTTP 405 (Method Not Found),
	// 421 (Misdirected Request), 501 (Not Implemented): 60s. These defaults
	// can be overridden in negative_caching_policy.
	NegativeCaching bool `json:"negativeCaching,omitempty"`

	// NegativeCachingPolicy: Sets a cache TTL for the specified HTTP status
	// code. negative_caching must be enabled to configure
	// negative_caching_policy. Omitting the policy and leaving
	// negative_caching enabled will use Cloud CDN's default cache TTLs.
	// Note that when specifying an explicit negative_caching_policy, you
	// should take care to specify a cache TTL for all response codes that
	// you wish to cache. Cloud CDN will not apply any default negative
	// caching when a policy exists.
	NegativeCachingPolicy []*BackendServiceCdnPolicyNegativeCachingPolicy `json:"negativeCachingPolicy,omitempty"`

	// RequestCoalescing: If true then Cloud CDN will combine multiple
	// concurrent cache fill requests into a small number of requests to the
	// origin.
	RequestCoalescing bool `json:"requestCoalescing,omitempty"`

	// ServeWhileStale: Serve existing content from the cache (if available)
	// when revalidating content with the origin, or when an error is
	// encountered when refreshing the cache. This setting defines the
	// default "max-stale" duration for any cached responses that do not
	// specify a max-stale directive. Stale responses that exceed the TTL
	// configured here will not be served. The default limit (max-stale) is
	// 86400s (1 day), which will allow stale content to be served up to
	// this limit beyond the max-age (or s-max-age) of a cached response.
	// The maximum allowed value is 604800 (1 week). Set this to zero (0) to
	// disable serve-while-stale.
	ServeWhileStale int64 `json:"serveWhileStale,omitempty"`

	// SignedUrlCacheMaxAgeSec: Maximum number of seconds the response to a
	// signed URL request will be considered fresh. After this time period,
	// the response will be revalidated before being served. Defaults to 1hr
	// (3600s). When serving responses to signed URL requests, Cloud CDN
	// will internally behave as though all responses from this backend had
	// a "Cache-Control: public, max-age=[TTL]" header, regardless of any
	// existing Cache-Control header. The actual headers served in responses
	// will not be altered.
	SignedUrlCacheMaxAgeSec int64 `json:"signedUrlCacheMaxAgeSec,omitempty,string"`

	// SignedUrlKeyNames: [Output Only] Names of the keys for signing
	// request URLs.
	SignedUrlKeyNames []string `json:"signedUrlKeyNames,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "BypassCacheOnRequestHeaders") to unconditionally include in API
	// requests. By default, fields with empty values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "BypassCacheOnRequestHeaders") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceCdnPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceCdnPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendServiceCdnPolicyBypassCacheOnRequestHeader: Bypass the cache
// when the specified request headers are present, e.g. Pragma or
// Authorization headers. Values are case insensitive. The presence of
// such a header overrides the cache_mode setting.
type BackendServiceCdnPolicyBypassCacheOnRequestHeader struct {
	// HeaderName: The header field name to match on when bypassing cache.
	// Values are case-insensitive.
	HeaderName string `json:"headerName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HeaderName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HeaderName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceCdnPolicyBypassCacheOnRequestHeader) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceCdnPolicyBypassCacheOnRequestHeader
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendServiceCdnPolicyNegativeCachingPolicy: Specify CDN TTLs for
// response error codes.
type BackendServiceCdnPolicyNegativeCachingPolicy struct {
	// Code: The HTTP status code to define a TTL against. Only HTTP status
	// codes 300, 301, 302, 307, 308, 404, 405, 410, 421, 451 and 501 are
	// can be specified as values, and you cannot specify a status code more
	// than once.
	Code int64 `json:"code,omitempty"`

	// Ttl: The TTL (in seconds) for which to cache responses with the
	// corresponding status code. The maximum allowed value is 1800s (30
	// minutes), noting that infrequently accessed objects may be evicted
	// from the cache before the defined TTL.
	Ttl int64 `json:"ttl,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceCdnPolicyNegativeCachingPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceCdnPolicyNegativeCachingPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendServiceConnectionTrackingPolicy: Connection Tracking
// configuration for this BackendService.
type BackendServiceConnectionTrackingPolicy struct {
	// ConnectionPersistenceOnUnhealthyBackends: Specifies connection
	// persistence when backends are unhealthy. The default value is
	// DEFAULT_FOR_PROTOCOL.
	//
	// If set to DEFAULT_FOR_PROTOCOL, the existing connections persist on
	// unhealthy backends only for connection-oriented protocols (TCP and
	// SCTP) and only if the Tracking Mode is PER_CONNECTION (default
	// tracking mode) or the Session Affinity is configured for 5-tuple.
	// They do not persist for UDP.
	//
	// If set to NEVER_PERSIST, after a backend becomes unhealthy, the
	// existing connections on the unhealthy backend are never persisted on
	// the unhealthy backend. They are always diverted to newly selected
	// healthy backends (unless all backends are unhealthy).
	//
	// If set to ALWAYS_PERSIST, existing connections always persist on
	// unhealthy backends regardless of protocol and session affinity. It is
	// generally not recommended to use this mode overriding the default.
	//
	// Possible values:
	//   "ALWAYS_PERSIST"
	//   "DEFAULT_FOR_PROTOCOL"
	//   "NEVER_PERSIST"
	ConnectionPersistenceOnUnhealthyBackends string `json:"connectionPersistenceOnUnhealthyBackends,omitempty"`

	// IdleTimeoutSec: Specifies how long to keep a Connection Tracking
	// entry while there is no matching traffic (in seconds).
	//
	// For L4 ILB the minimum(default) is 10 minutes and maximum is 16
	// hours.
	//
	// For NLB the minimum(default) is 60 seconds and the maximum is 16
	// hours.
	//
	// This field will be supported only if the Connection Tracking key is
	// less than 5-tuple.
	IdleTimeoutSec int64 `json:"idleTimeoutSec,omitempty"`

	// TrackingMode: Specifies the key used for connection tracking. There
	// are two options:
	//
	// PER_CONNECTION: This is the default mode. The Connection Tracking is
	// performed as per the Connection Key (default Hash Method) for the
	// specific protocol.
	//
	// PER_SESSION: The Connection Tracking is performed as per the
	// configured Session Affinity. It matches the configured Session
	// Affinity.
	//
	// Possible values:
	//   "INVALID_TRACKING_MODE"
	//   "PER_CONNECTION"
	//   "PER_SESSION"
	TrackingMode string `json:"trackingMode,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ConnectionPersistenceOnUnhealthyBackends") to unconditionally
	// include in API requests. By default, fields with empty values are
	// omitted from API requests. However, any non-pointer, non-interface
	// field appearing in ForceSendFields will be sent to the server
	// regardless of whether the field is empty or not. This may be used to
	// include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "ConnectionPersistenceOnUnhealthyBackends") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceConnectionTrackingPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceConnectionTrackingPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendServiceFailoverPolicy: Applicable only to Failover for
// Internal TCP/UDP Load Balancing and Network Load Balancing. On
// failover or failback, this field indicates whether connection
// draining will be honored. GCP has a fixed connection draining timeout
// of 10 minutes. A setting of true terminates existing TCP connections
// to the active pool during failover and failback, immediately draining
// traffic. A setting of false allows existing TCP connections to
// persist, even on VMs no longer in the active pool, for up to the
// duration of the connection draining timeout (10 minutes).
type BackendServiceFailoverPolicy struct {
	// DisableConnectionDrainOnFailover: This can be set to true only if the
	// protocol is TCP.
	//
	// The default is false.
	DisableConnectionDrainOnFailover bool `json:"disableConnectionDrainOnFailover,omitempty"`

	// DropTrafficIfUnhealthy: Applicable only to Failover for Internal
	// TCP/UDP Load Balancing and Network Load Balancing, If set to true,
	// connections to the load balancer are dropped when all primary and all
	// backup backend VMs are unhealthy.If set to false, connections are
	// distributed among all primary VMs when all primary and all backup
	// backend VMs are unhealthy. The default is false.
	DropTrafficIfUnhealthy bool `json:"dropTrafficIfUnhealthy,omitempty"`

	// FailoverRatio: Applicable only to Failover for Internal TCP/UDP Load
	// Balancing and Network Load Balancing. The value of the field must be
	// in the range [0, 1]. If the value is 0, the load balancer performs a
	// failover when the number of healthy primary VMs equals zero. For all
	// other values, the load balancer performs a failover when the total
	// number of healthy primary VMs is less than this ratio.
	FailoverRatio float64 `json:"failoverRatio,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "DisableConnectionDrainOnFailover") to unconditionally include in API
	// requests. By default, fields with empty values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "DisableConnectionDrainOnFailover") to include in API requests with
	// the JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceFailoverPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceFailoverPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *BackendServiceFailoverPolicy) UnmarshalJSON(data []byte) error {
	type NoMethod BackendServiceFailoverPolicy
	var s1 struct {
		FailoverRatio gensupport.JSONFloat64 `json:"failoverRatio"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.FailoverRatio = float64(s1.FailoverRatio)
	return nil
}

type BackendServiceGroupHealth struct {
	// Annotations: Metadata defined as annotations on the network endpoint
	// group.
	Annotations map[string]string `json:"annotations,omitempty"`

	// HealthStatus: Health state of the backend instances or endpoints in
	// requested instance or network endpoint group, determined based on
	// configured health checks.
	HealthStatus []*HealthStatus `json:"healthStatus,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#backendServiceGroupHealth for the health of backend services.
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Annotations") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceGroupHealth) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceGroupHealth
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendServiceIAP: Identity-Aware Proxy
type BackendServiceIAP struct {
	// Enabled: Whether the serving infrastructure will authenticate and
	// authorize all incoming requests. If true, the oauth2ClientId and
	// oauth2ClientSecret fields must be non-empty.
	Enabled bool `json:"enabled,omitempty"`

	// Oauth2ClientId: OAuth2 client ID to use for the authentication flow.
	Oauth2ClientId string `json:"oauth2ClientId,omitempty"`

	// Oauth2ClientInfo: [Input Only] OAuth client info required to generate
	// client id to be used for IAP.
	Oauth2ClientInfo *BackendServiceIAPOAuth2ClientInfo `json:"oauth2ClientInfo,omitempty"`

	// Oauth2ClientSecret: OAuth2 client secret to use for the
	// authentication flow. For security reasons, this value cannot be
	// retrieved via the API. Instead, the SHA-256 hash of the value is
	// returned in the oauth2ClientSecretSha256 field.
	Oauth2ClientSecret string `json:"oauth2ClientSecret,omitempty"`

	// Oauth2ClientSecretSha256: [Output Only] SHA256 hash value for the
	// field oauth2_client_secret above.
	Oauth2ClientSecretSha256 string `json:"oauth2ClientSecretSha256,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enabled") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceIAP) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceIAP
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type BackendServiceIAPOAuth2ClientInfo struct {
	// ApplicationName: Application name to be used in OAuth consent screen.
	ApplicationName string `json:"applicationName,omitempty"`

	// ClientName: Name of the client to be generated. Optional - If not
	// provided, the name will be autogenerated by the backend.
	ClientName string `json:"clientName,omitempty"`

	// DeveloperEmailAddress: Developer's information to be used in OAuth
	// consent screen.
	DeveloperEmailAddress string `json:"developerEmailAddress,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ApplicationName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApplicationName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceIAPOAuth2ClientInfo) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceIAPOAuth2ClientInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendServiceList: Contains a list of BackendService resources.
type BackendServiceList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of BackendService resources.
	Items []*BackendService `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#backendServiceList for lists of backend services.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *BackendServiceListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceList) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendServiceListWarning: [Output Only] Informational warning
// message.
type BackendServiceListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*BackendServiceListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type BackendServiceListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendServiceLogConfig: The available logging options for the load
// balancer traffic served by this backend service.
type BackendServiceLogConfig struct {
	// Enable: This field denotes whether to enable logging for the load
	// balancer traffic served by this backend service.
	Enable bool `json:"enable,omitempty"`

	// SampleRate: This field can only be specified if logging is enabled
	// for this backend service. The value of the field must be in [0, 1].
	// This configures the sampling rate of requests to the load balancer
	// where 1.0 means all logged requests are reported and 0.0 means no
	// logged requests are reported. The default value is 1.0.
	SampleRate float64 `json:"sampleRate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enable") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enable") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceLogConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *BackendServiceLogConfig) UnmarshalJSON(data []byte) error {
	type NoMethod BackendServiceLogConfig
	var s1 struct {
		SampleRate gensupport.JSONFloat64 `json:"sampleRate"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SampleRate = float64(s1.SampleRate)
	return nil
}

type BackendServiceReference struct {
	BackendService string `json:"backendService,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BackendService") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BackendService") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BackendServiceReference) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServiceReference
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type BackendServicesScopedList struct {
	// BackendServices: A list of BackendServices contained in this scope.
	BackendServices []*BackendService `json:"backendServices,omitempty"`

	// Warning: Informational warning which replaces the list of backend
	// services when the list is empty.
	Warning *BackendServicesScopedListWarning `json:"warning,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BackendServices") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BackendServices") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BackendServicesScopedList) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServicesScopedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BackendServicesScopedListWarning: Informational warning which
// replaces the list of backend services when the list is empty.
type BackendServicesScopedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*BackendServicesScopedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServicesScopedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServicesScopedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type BackendServicesScopedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BackendServicesScopedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod BackendServicesScopedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type BfdPacket struct {
	// AuthenticationPresent: The Authentication Present bit of the BFD
	// packet. This is specified in section 4.1 of RFC5880
	AuthenticationPresent bool `json:"authenticationPresent,omitempty"`

	// ControlPlaneIndependent: The Control Plane Independent bit of the BFD
	// packet. This is specified in section 4.1 of RFC5880
	ControlPlaneIndependent bool `json:"controlPlaneIndependent,omitempty"`

	// Demand: The demand bit of the BFD packet. This is specified in
	// section 4.1 of RFC5880
	Demand bool `json:"demand,omitempty"`

	// Diagnostic: The diagnostic code specifies the local system's reason
	// for the last change in session state. This allows remote systems to
	// determine the reason that the previous session failed, for example.
	// These diagnostic codes are specified in section 4.1 of RFC5880
	//
	// Possible values:
	//   "ADMINISTRATIVELY_DOWN"
	//   "CONCATENATED_PATH_DOWN"
	//   "CONTROL_DETECTION_TIME_EXPIRED"
	//   "DIAGNOSTIC_UNSPECIFIED"
	//   "ECHO_FUNCTION_FAILED"
	//   "FORWARDING_PLANE_RESET"
	//   "NEIGHBOR_SIGNALED_SESSION_DOWN"
	//   "NO_DIAGNOSTIC"
	//   "PATH_DOWN"
	//   "REVERSE_CONCATENATED_PATH_DOWN"
	Diagnostic string `json:"diagnostic,omitempty"`

	// Final: The Final bit of the BFD packet. This is specified in section
	// 4.1 of RFC5880
	Final bool `json:"final,omitempty"`

	// Length: The length of the BFD Control packet in bytes. This is
	// specified in section 4.1 of RFC5880
	Length int64 `json:"length,omitempty"`

	// MinEchoRxIntervalMs: The Required Min Echo RX Interval value in the
	// BFD packet. This is specified in section 4.1 of RFC5880
	MinEchoRxIntervalMs int64 `json:"minEchoRxIntervalMs,omitempty"`

	// MinRxIntervalMs: The Required Min RX Interval value in the BFD
	// packet. This is specified in section 4.1 of RFC5880
	MinRxIntervalMs int64 `json:"minRxIntervalMs,omitempty"`

	// MinTxIntervalMs: The Desired Min TX Interval value in the BFD packet.
	// This is specified in section 4.1 of RFC5880
	MinTxIntervalMs int64 `json:"minTxIntervalMs,omitempty"`

	// Multiplier: The detection time multiplier of the BFD packet. This is
	// specified in section 4.1 of RFC5880
	Multiplier int64 `json:"multiplier,omitempty"`

	// Multipoint: The multipoint bit of the BFD packet. This is specified
	// in section 4.1 of RFC5880
	Multipoint bool `json:"multipoint,omitempty"`

	// MyDiscriminator: The My Discriminator value in the BFD packet. This
	// is specified in section 4.1 of RFC5880
	MyDiscriminator int64 `json:"myDiscriminator,omitempty"`

	// Poll: The Poll bit of the BFD packet. This is specified in section
	// 4.1 of RFC5880
	Poll bool `json:"poll,omitempty"`

	// State: The current BFD session state as seen by the transmitting
	// system. These states are specified in section 4.1 of RFC5880
	//
	// Possible values:
	//   "ADMIN_DOWN"
	//   "DOWN"
	//   "INIT"
	//   "STATE_UNSPECIFIED"
	//   "UP"
	State string `json:"state,omitempty"`

	// Version: The version number of the BFD protocol, as specified in
	// section 4.1 of RFC5880.
	Version int64 `json:"version,omitempty"`

	// YourDiscriminator: The Your Discriminator value in the BFD packet.
	// This is specified in section 4.1 of RFC5880
	YourDiscriminator int64 `json:"yourDiscriminator,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AuthenticationPresent") to unconditionally include in API requests.
	// By default, fields with empty values are omitted from API requests.
	// However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AuthenticationPresent") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *BfdPacket) MarshalJSON() ([]byte, error) {
	type NoMethod BfdPacket
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BfdStatus: Next free: 15
type BfdStatus struct {
	// BfdSessionInitializationMode: The BFD session initialization mode for
	// this BGP peer. If set to ACTIVE, the Cloud Router will initiate the
	// BFD session for this BGP peer. If set to PASSIVE, the Cloud Router
	// will wait for the peer router to initiate the BFD session for this
	// BGP peer. If set to DISABLED, BFD is disabled for this BGP peer.
	//
	// Possible values:
	//   "ACTIVE"
	//   "DISABLED"
	//   "PASSIVE"
	BfdSessionInitializationMode string `json:"bfdSessionInitializationMode,omitempty"`

	// ConfigUpdateTimestampMicros: Unix timestamp of the most recent config
	// update.
	ConfigUpdateTimestampMicros int64 `json:"configUpdateTimestampMicros,omitempty,string"`

	// ControlPacketCounts: Control packet counts for the current BFD
	// session.
	ControlPacketCounts *BfdStatusPacketCounts `json:"controlPacketCounts,omitempty"`

	// ControlPacketIntervals: Inter-packet time interval statistics for
	// control packets.
	ControlPacketIntervals []*PacketIntervals `json:"controlPacketIntervals,omitempty"`

	// EchoPacketCounts: Echo packet counts for the current BFD session.
	EchoPacketCounts *BfdStatusPacketCounts `json:"echoPacketCounts,omitempty"`

	// EchoPacketIntervals: Inter-packet time interval statistics for echo
	// packets.
	EchoPacketIntervals []*PacketIntervals `json:"echoPacketIntervals,omitempty"`

	// LocalDiagnostic: The diagnostic code specifies the local system's
	// reason for the last change in session state. This allows remote
	// systems to determine the reason that the previous session failed, for
	// example. These diagnostic codes are specified in section 4.1 of
	// RFC5880
	//
	// Possible values:
	//   "ADMINISTRATIVELY_DOWN"
	//   "CONCATENATED_PATH_DOWN"
	//   "CONTROL_DETECTION_TIME_EXPIRED"
	//   "DIAGNOSTIC_UNSPECIFIED"
	//   "ECHO_FUNCTION_FAILED"
	//   "FORWARDING_PLANE_RESET"
	//   "NEIGHBOR_SIGNALED_SESSION_DOWN"
	//   "NO_DIAGNOSTIC"
	//   "PATH_DOWN"
	//   "REVERSE_CONCATENATED_PATH_DOWN"
	LocalDiagnostic string `json:"localDiagnostic,omitempty"`

	// LocalState: The current BFD session state as seen by the transmitting
	// system. These states are specified in section 4.1 of RFC5880
	//
	// Possible values:
	//   "ADMIN_DOWN"
	//   "DOWN"
	//   "INIT"
	//   "STATE_UNSPECIFIED"
	//   "UP"
	LocalState string `json:"localState,omitempty"`

	// NegotiatedLocalControlTxIntervalMs: Negotiated transmit interval for
	// control packets.
	NegotiatedLocalControlTxIntervalMs int64 `json:"negotiatedLocalControlTxIntervalMs,omitempty"`

	// NegotiatedLocalEchoTxIntervalMs: Negotiated transmit interval for
	// echo packets.
	NegotiatedLocalEchoTxIntervalMs int64 `json:"negotiatedLocalEchoTxIntervalMs,omitempty"`

	// RxPacket: The most recent Rx control packet for this BFD session.
	RxPacket *BfdPacket `json:"rxPacket,omitempty"`

	// TxPacket: The most recent Tx control packet for this BFD session.
	TxPacket *BfdPacket `json:"txPacket,omitempty"`

	// UptimeMs: Session uptime in milliseconds. Value will be 0 if session
	// is not up.
	UptimeMs int64 `json:"uptimeMs,omitempty,string"`

	// UsingEchoMode: Indicates if echo mode is currently being used.
	UsingEchoMode bool `json:"usingEchoMode,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "BfdSessionInitializationMode") to unconditionally include in API
	// requests. By default, fields with empty values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "BfdSessionInitializationMode") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BfdStatus) MarshalJSON() ([]byte, error) {
	type NoMethod BfdStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type BfdStatusPacketCounts struct {
	// NumRx: Number of packets received since the beginning of the current
	// BFD session.
	NumRx int64 `json:"numRx,omitempty"`

	// NumRxRejected: Number of packets received that were rejected because
	// of errors since the beginning of the current BFD session.
	NumRxRejected int64 `json:"numRxRejected,omitempty"`

	// NumRxSuccessful: Number of packets received that were successfully
	// processed since the beginning of the current BFD session.
	NumRxSuccessful int64 `json:"numRxSuccessful,omitempty"`

	// NumTx: Number of packets transmitted since the beginning of the
	// current BFD session.
	NumTx int64 `json:"numTx,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NumRx") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NumRx") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BfdStatusPacketCounts) MarshalJSON() ([]byte, error) {
	type NoMethod BfdStatusPacketCounts
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Binding: Associates `members` with a `role`.
type Binding struct {
	BindingId string `json:"bindingId,omitempty"`

	// Condition: The condition that is associated with this binding.
	//
	// If the condition evaluates to `true`, then this binding applies to
	// the current request.
	//
	// If the condition evaluates to `false`, then this binding does not
	// apply to the current request. However, a different role binding might
	// grant the same role to one or more of the members in this
	// binding.
	//
	// To learn which resources support conditions in their IAM policies,
	// see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *Expr `json:"condition,omitempty"`

	// Members: Specifies the identities requesting access for a Cloud
	// Platform resource. `members` can have the following values:
	//
	// * `allUsers`: A special identifier that represents anyone who is on
	// the internet; with or without a Google account.
	//
	// * `allAuthenticatedUsers`: A special identifier that represents
	// anyone who is authenticated with a Google account or a service
	// account.
	//
	// * `user:{emailid}`: An email address that represents a specific
	// Google account. For example, `alice@example.com` .
	//
	//
	//
	// * `serviceAccount:{emailid}`: An email address that represents a
	// service account. For example,
	// `my-other-app@appspot.gserviceaccount.com`.
	//
	// * `group:{emailid}`: An email address that represents a Google group.
	// For example, `admins@example.com`.
	//
	// * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a user that has been recently
	// deleted. For example, `alice@example.com?uid=123456789012345678901`.
	// If the user is recovered, this value reverts to `user:{emailid}` and
	// the recovered user retains the role in the binding.
	//
	// * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
	// (plus unique identifier) representing a service account that has been
	// recently deleted. For example,
	// `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`.
	// If the service account is undeleted, this value reverts to
	// `serviceAccount:{emailid}` and the undeleted service account retains
	// the role in the binding.
	//
	// * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a Google group that has been recently
	// deleted. For example, `admins@example.com?uid=123456789012345678901`.
	// If the group is recovered, this value reverts to `group:{emailid}`
	// and the recovered group retains the role in the binding.
	//
	//
	//
	// * `domain:{domain}`: The G Suite domain (primary) that represents all
	// the users of that domain. For example, `google.com` or `example.com`.
	Members []string `json:"members,omitempty"`

	// Role: Role that is assigned to `members`. For example,
	// `roles/viewer`, `roles/editor`, or `roles/owner`.
	Role string `json:"role,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BindingId") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BindingId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Binding) MarshalJSON() ([]byte, error) {
	type NoMethod Binding
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type BulkInsertInstanceResource struct {
	// Count: The maximum number of instances to create.
	Count int64 `json:"count,omitempty,string"`

	// Instance: The instance defining the VM instances to be created.
	Instance *Instance `json:"instance,omitempty"`

	// InstanceProperties: The instance properties defining the VM instances
	// to be created. Required if sourceInstanceTemplate is not provided.
	InstanceProperties *InstanceProperties `json:"instanceProperties,omitempty"`

	LocationPolicy *LocationPolicy `json:"locationPolicy,omitempty"`

	// MinCount: The minimum number of instances to create. If no min_count
	// is specified then count is used as the default value. If min_count
	// instances cannot be created, then no instances will be created.
	MinCount int64 `json:"minCount,omitempty,string"`

	// NamePattern: The string pattern used for the names of the VMs. Either
	// name_pattern or predefined_names must be set. The pattern should
	// contain one consecutive sequence of placeholder hash characters (#)
	// with each character corresponding to one digit of the generated
	// instance name. Example: name_pattern of inst-#### will generate
	// instance names like inst-0001, inst-0002, ... . If there already
	// exist instance(s) whose names match the name pattern in the same
	// project and zone, then the generated instance numbers will start
	// after the biggest existing number. For example, if there exists an
	// instance with name inst-0050, then instance names generated using the
	// pattern inst-#### will be inst-0051, inst-0052, etc. The name pattern
	// placeholder #...# can contain up to 18 characters.
	NamePattern string `json:"namePattern,omitempty"`

	// PerInstanceProperties: Per-instance properties to be set on
	// individual instances. Keys of this map specify requested instance
	// names. Can be empty if name_pattern is used.
	PerInstanceProperties map[string]BulkInsertInstanceResourcePerInstanceProperties `json:"perInstanceProperties,omitempty"`

	// PredefinedNames: List of predefined names. The number of names
	// provided must be equal to count.
	PredefinedNames []string `json:"predefinedNames,omitempty"`

	// SourceInstanceTemplate: Specifies the instance template from which to
	// create instances. You may combine sourceInstanceTemplate with
	// instanceProperties to override specific values from an existing
	// instance template. Bulk API follows the semantics of JSON Merge Patch
	// described by RFC 7396.
	//
	// It can be a full or partial URL. For example, the following are all
	// valid URLs to an instance template:
	// -
	// https://www.googleapis.com/compute/v1/projects/project/global/instanceTemplates/instanceTemplate
	//
	// - projects/project/global/instanceTemplates/instanceTemplate
	// - global/instanceTemplates/instanceTemplate
	//
	// This field is optional.
	SourceInstanceTemplate string `json:"sourceInstanceTemplate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Count") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BulkInsertInstanceResource) MarshalJSON() ([]byte, error) {
	type NoMethod BulkInsertInstanceResource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BulkInsertInstanceResourcePerInstanceProperties: Per-instance
// properties to be set on individual instances. To be extended in the
// future.
type BulkInsertInstanceResourcePerInstanceProperties struct {
	// Name: This field is only temporary. It will be removed. Do not use
	// it.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BulkInsertInstanceResourcePerInstanceProperties) MarshalJSON() ([]byte, error) {
	type NoMethod BulkInsertInstanceResourcePerInstanceProperties
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CacheInvalidationRule struct {
	// Host: If set, this invalidation rule will only apply to requests with
	// a Host header matching host.
	Host string `json:"host,omitempty"`

	Path string `json:"path,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Host") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Host") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CacheInvalidationRule) MarshalJSON() ([]byte, error) {
	type NoMethod CacheInvalidationRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CacheKeyPolicy: Message containing what to include in the cache key
// for a request for Cloud CDN.
type CacheKeyPolicy struct {
	// IncludeHost: If true, requests to different hosts will be cached
	// separately.
	IncludeHost bool `json:"includeHost,omitempty"`

	// IncludeProtocol: If true, http and https requests will be cached
	// separately.
	IncludeProtocol bool `json:"includeProtocol,omitempty"`

	// IncludeQueryString: If true, include query string parameters in the
	// cache key according to query_string_whitelist and
	// query_string_blacklist. If neither is set, the entire query string
	// will be included. If false, the query string will be excluded from
	// the cache key entirely.
	IncludeQueryString bool `json:"includeQueryString,omitempty"`

	// QueryStringBlacklist: Names of query string parameters to exclude in
	// cache keys. All other parameters will be included. Either specify
	// query_string_whitelist or query_string_blacklist, not both. '&' and
	// '=' will be percent encoded and not treated as delimiters.
	QueryStringBlacklist []string `json:"queryStringBlacklist,omitempty"`

	// QueryStringWhitelist: Names of query string parameters to include in
	// cache keys. All other parameters will be excluded. Either specify
	// query_string_whitelist or query_string_blacklist, not both. '&' and
	// '=' will be percent encoded and not treated as delimiters.
	QueryStringWhitelist []string `json:"queryStringWhitelist,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IncludeHost") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IncludeHost") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CacheKeyPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod CacheKeyPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CallCredentials: [Deprecated] gRPC call credentials to access the SDS
// server. gRPC call credentials to access the SDS server.
type CallCredentials struct {
	// CallCredentialType: The type of call credentials to use for GRPC
	// requests to the SDS server. This field can be set to one of the
	// following:
	// - GCE_VM: The local GCE VM service account credentials are used to
	// access the SDS server.
	// - FROM_PLUGIN: Custom authenticator credentials are used to access
	// the SDS server.
	//
	// Possible values:
	//   "FROM_PLUGIN"
	//   "GCE_VM"
	//   "INVALID"
	CallCredentialType string `json:"callCredentialType,omitempty"`

	// FromPlugin: Custom authenticator credentials. Valid if
	// callCredentialType is FROM_PLUGIN.
	FromPlugin *MetadataCredentialsFromPlugin `json:"fromPlugin,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CallCredentialType")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CallCredentialType") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *CallCredentials) MarshalJSON() ([]byte, error) {
	type NoMethod CallCredentials
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ChannelCredentials: [Deprecated] gRPC channel credentials to access
// the SDS server. gRPC channel credentials to access the SDS server.
type ChannelCredentials struct {
	// Certificates: The call credentials to access the SDS server.
	Certificates *TlsCertificatePaths `json:"certificates,omitempty"`

	// ChannelCredentialType: The channel credentials to access the SDS
	// server. This field can be set to one of the following: CERTIFICATES:
	// Use TLS certificates to access the SDS server. GCE_VM: Use local GCE
	// VM credentials to access the SDS server.
	//
	// Possible values:
	//   "CERTIFICATES"
	//   "GCE_VM"
	//   "INVALID"
	ChannelCredentialType string `json:"channelCredentialType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Certificates") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Certificates") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ChannelCredentials) MarshalJSON() ([]byte, error) {
	type NoMethod ChannelCredentials
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CircuitBreakers: Settings controlling the volume of connections to a
// backend service.
type CircuitBreakers struct {
	// ConnectTimeout: The timeout for new network connections to hosts.
	ConnectTimeout *Duration `json:"connectTimeout,omitempty"`

	// MaxConnections: The maximum number of connections to the backend
	// service. If not specified, there is no limit.
	MaxConnections int64 `json:"maxConnections,omitempty"`

	// MaxPendingRequests: The maximum number of pending requests allowed to
	// the backend service. If not specified, there is no limit.
	MaxPendingRequests int64 `json:"maxPendingRequests,omitempty"`

	// MaxRequests: The maximum number of parallel requests that allowed to
	// the backend service. If not specified, there is no limit.
	MaxRequests int64 `json:"maxRequests,omitempty"`

	// MaxRequestsPerConnection: Maximum requests for a single connection to
	// the backend service. This parameter is respected by both the HTTP/1.1
	// and HTTP/2 implementations. If not specified, there is no limit.
	// Setting this parameter to 1 will effectively disable keep alive.
	MaxRequestsPerConnection int64 `json:"maxRequestsPerConnection,omitempty"`

	// MaxRetries: The maximum number of parallel retries allowed to the
	// backend cluster. If not specified, the default is 1.
	MaxRetries int64 `json:"maxRetries,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConnectTimeout") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConnectTimeout") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *CircuitBreakers) MarshalJSON() ([]byte, error) {
	type NoMethod CircuitBreakers
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ClientTlsSettings: [Deprecated] The client side authentication
// settings for connection originating from the backend service. the
// backend service.
type ClientTlsSettings struct {
	// ClientTlsContext: Configures the mechanism to obtain client-side
	// security certificates and identity information. This field is only
	// applicable when mode is set to MUTUAL.
	ClientTlsContext *TlsContext `json:"clientTlsContext,omitempty"`

	// Mode: Indicates whether connections to this port should be secured
	// using TLS. The value of this field determines how TLS is enforced.
	// This can be set to one of the following values: DISABLE: Do not setup
	// a TLS connection to the backends. SIMPLE: Originate a TLS connection
	// to the backends. MUTUAL: Secure connections to the backends using
	// mutual TLS by presenting client certificates for authentication.
	//
	// Possible values:
	//   "DISABLE"
	//   "INVALID"
	//   "MUTUAL"
	//   "SIMPLE"
	Mode string `json:"mode,omitempty"`

	// Sni: SNI string to present to the server during TLS handshake. This
	// field is applicable only when mode is SIMPLE or MUTUAL.
	Sni string `json:"sni,omitempty"`

	// SubjectAltNames: A list of alternate names to verify the subject
	// identity in the certificate.If specified, the proxy will verify that
	// the server certificate's subject alt name matches one of the
	// specified values. This field is applicable only when mode is SIMPLE
	// or MUTUAL.
	SubjectAltNames []string `json:"subjectAltNames,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ClientTlsContext") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ClientTlsContext") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ClientTlsSettings) MarshalJSON() ([]byte, error) {
	type NoMethod ClientTlsSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Commitment: Represents a regional Commitment resource.
//
// Creating a commitment resource means that you are purchasing a
// committed use contract with an explicit start and end time. You can
// create commitments based on vCPUs and memory usage and receive
// discounted rates. For full details, read Signing Up for Committed Use
// Discounts. (== resource_for {$api_version}.regionCommitments ==)
type Commitment struct {
	// Category: The category of the commitment. Category MACHINE specifies
	// commitments composed of machine resources such as VCPU or MEMORY,
	// listed in resources. Category LICENSE specifies commitments composed
	// of software licenses, listed in licenseResources. Note that only
	// MACHINE commitments should have a Type specified.
	//
	// Possible values:
	//   "CATEGORY_UNSPECIFIED"
	//   "LICENSE"
	//   "MACHINE"
	Category string `json:"category,omitempty"`

	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// EndTimestamp: [Output Only] Commitment end time in RFC3339 text
	// format.
	EndTimestamp string `json:"endTimestamp,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// Kind: [Output Only] Type of the resource. Always compute#commitment
	// for commitments.
	Kind string `json:"kind,omitempty"`

	// LicenseResource: The license specification required as part of a
	// license commitment.
	LicenseResource *LicenseResourceCommitment `json:"licenseResource,omitempty"`

	// Name: Name of the resource. Provided by the client when the resource
	// is created. The name must be 1-63 characters long, and comply with
	// RFC1035. Specifically, the name must be 1-63 characters long and
	// match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means
	// the first character must be a lowercase letter, and all following
	// characters must be a dash, lowercase letter, or digit, except the
	// last character, which cannot be a dash.
	Name string `json:"name,omitempty"`

	// Plan: The plan for this commitment, which determines duration and
	// discount rate. The currently supported plans are TWELVE_MONTH (1
	// year), and THIRTY_SIX_MONTH (3 years).
	//
	// Possible values:
	//   "INVALID"
	//   "THIRTY_SIX_MONTH"
	//   "TWELVE_MONTH"
	Plan string `json:"plan,omitempty"`

	// Region: [Output Only] URL of the region where this commitment may be
	// used.
	Region string `json:"region,omitempty"`

	// Reservations: List of reservations in this commitment.
	Reservations []*Reservation `json:"reservations,omitempty"`

	// Resources: A list of commitment amounts for particular resources.
	// Note that VCPU and MEMORY resource commitments must occur together.
	Resources []*ResourceCommitment `json:"resources,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// StartTimestamp: [Output Only] Commitment start time in RFC3339 text
	// format.
	StartTimestamp string `json:"startTimestamp,omitempty"`

	// Status: [Output Only] Status of the commitment with regards to
	// eventual expiration (each commitment has an end date defined). One of
	// the following values: NOT_YET_ACTIVE, ACTIVE, EXPIRED.
	//
	// Possible values:
	//   "ACTIVE"
	//   "CREATING"
	//   "EXPIRED"
	//   "NOT_YET_ACTIVE"
	Status string `json:"status,omitempty"`

	// StatusMessage: [Output Only] An optional, human-readable explanation
	// of the status.
	StatusMessage string `json:"statusMessage,omitempty"`

	// Type: The type of commitment, which affects the discount rate and the
	// eligible resources. Type MEMORY_OPTIMIZED specifies a commitment that
	// will only apply to memory optimized machines. Type
	// ACCELERATOR_OPTIMIZED specifies a commitment that will only apply to
	// accelerator optimized machines.
	//
	// Possible values:
	//   "ACCELERATOR_OPTIMIZED"
	//   "COMPUTE_OPTIMIZED"
	//   "COMPUTE_OPTIMIZED_C2D"
	//   "GENERAL_PURPOSE"
	//   "GENERAL_PURPOSE_E2"
	//   "GENERAL_PURPOSE_N2"
	//   "GENERAL_PURPOSE_N2D"
	//   "MEMORY_OPTIMIZED"
	//   "MEMORY_OPTIMIZED_REGIONAL_EXTENSION"
	//   "TYPE_UNSPECIFIED"
	Type string `json:"type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Category") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Category") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Commitment) MarshalJSON() ([]byte, error) {
	type NoMethod Commitment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CommitmentAggregatedList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of CommitmentsScopedList resources.
	Items map[string]CommitmentsScopedList `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#commitmentAggregatedList for aggregated lists of commitments.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Unreachables: [Output Only] Unreachable resources.
	Unreachables []string `json:"unreachables,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *CommitmentAggregatedListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CommitmentAggregatedList) MarshalJSON() ([]byte, error) {
	type NoMethod CommitmentAggregatedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CommitmentAggregatedListWarning: [Output Only] Informational warning
// message.
type CommitmentAggregatedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*CommitmentAggregatedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CommitmentAggregatedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod CommitmentAggregatedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CommitmentAggregatedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CommitmentAggregatedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod CommitmentAggregatedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CommitmentList: Contains a list of Commitment resources.
type CommitmentList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of Commitment resources.
	Items []*Commitment `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always compute#commitmentList
	// for lists of commitments.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *CommitmentListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CommitmentList) MarshalJSON() ([]byte, error) {
	type NoMethod CommitmentList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CommitmentListWarning: [Output Only] Informational warning message.
type CommitmentListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*CommitmentListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CommitmentListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod CommitmentListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CommitmentListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CommitmentListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod CommitmentListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CommitmentsScopedList struct {
	// Commitments: [Output Only] A list of commitments contained in this
	// scope.
	Commitments []*Commitment `json:"commitments,omitempty"`

	// Warning: [Output Only] Informational warning which replaces the list
	// of commitments when the list is empty.
	Warning *CommitmentsScopedListWarning `json:"warning,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Commitments") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Commitments") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CommitmentsScopedList) MarshalJSON() ([]byte, error) {
	type NoMethod CommitmentsScopedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CommitmentsScopedListWarning: [Output Only] Informational warning
// which replaces the list of commitments when the list is empty.
type CommitmentsScopedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*CommitmentsScopedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CommitmentsScopedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod CommitmentsScopedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CommitmentsScopedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CommitmentsScopedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod CommitmentsScopedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Condition: A condition to be met.
type Condition struct {
	// Iam: Trusted attributes supplied by the IAM system.
	//
	// Possible values:
	//   "APPROVER"
	//   "ATTRIBUTION"
	//   "AUTHORITY"
	//   "CREDENTIALS_TYPE"
	//   "CREDS_ASSERTION"
	//   "JUSTIFICATION_TYPE"
	//   "NO_ATTR"
	//   "SECURITY_REALM"
	Iam string `json:"iam,omitempty"`

	// Op: An operator to apply the subject with.
	//
	// Possible values:
	//   "DISCHARGED"
	//   "EQUALS"
	//   "IN"
	//   "NOT_EQUALS"
	//   "NOT_IN"
	//   "NO_OP"
	Op string `json:"op,omitempty"`

	// Svc: Trusted attributes discharged by the service.
	Svc string `json:"svc,omitempty"`

	// Sys: Trusted attributes supplied by any service that owns resources
	// and uses the IAM system for access control.
	//
	// Possible values:
	//   "IP"
	//   "NAME"
	//   "NO_ATTR"
	//   "REGION"
	//   "SERVICE"
	Sys string `json:"sys,omitempty"`

	// Values: The objects of the condition.
	Values []string `json:"values,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Iam") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Iam") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Condition) MarshalJSON() ([]byte, error) {
	type NoMethod Condition
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ConfidentialInstanceConfig: A set of Confidential Instance options.
type ConfidentialInstanceConfig struct {
	// EnableConfidentialCompute: Defines whether the instance should have
	// confidential compute enabled.
	EnableConfidentialCompute bool `json:"enableConfidentialCompute,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "EnableConfidentialCompute") to unconditionally include in API
	// requests. By default, fields with empty values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "EnableConfidentialCompute") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ConfidentialInstanceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ConfidentialInstanceConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ConnectionDraining: Message containing connection draining
// configuration.
type ConnectionDraining struct {
	// DrainingTimeoutSec: Configures a duration timeout for existing
	// requests on a removed backend instance. For supported load balancers
	// and protocols, as described in Enabling connection draining.
	DrainingTimeoutSec int64 `json:"drainingTimeoutSec,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DrainingTimeoutSec")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DrainingTimeoutSec") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ConnectionDraining) MarshalJSON() ([]byte, error) {
	type NoMethod ConnectionDraining
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ConsistentHashLoadBalancerSettings: This message defines settings for
// a consistent hash style load balancer.
type ConsistentHashLoadBalancerSettings struct {
	// HttpCookie: Hash is based on HTTP Cookie. This field describes a HTTP
	// cookie that will be used as the hash key for the consistent hash load
	// balancer. If the cookie is not present, it will be generated. This
	// field is applicable if the sessionAffinity is set to HTTP_COOKIE.
	HttpCookie *ConsistentHashLoadBalancerSettingsHttpCookie `json:"httpCookie,omitempty"`

	// HttpHeaderName: The hash based on the value of the specified header
	// field. This field is applicable if the sessionAffinity is set to
	// HEADER_FIELD.
	HttpHeaderName string `json:"httpHeaderName,omitempty"`

	// MinimumRingSize: The minimum number of virtual nodes to use for the
	// hash ring. Defaults to 1024. Larger ring sizes result in more
	// granular load distributions. If the number of hosts in the load
	// balancing pool is larger than the ring size, each host will be
	// assigned a single virtual node.
	MinimumRingSize int64 `json:"minimumRingSize,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "HttpCookie") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HttpCookie") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ConsistentHashLoadBalancerSettings) MarshalJSON() ([]byte, error) {
	type NoMethod ConsistentHashLoadBalancerSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ConsistentHashLoadBalancerSettingsHttpCookie: The information about
// the HTTP Cookie on which the hash function is based for load
// balancing policies that use a consistent hash.
type ConsistentHashLoadBalancerSettingsHttpCookie struct {
	// Name: Name of the cookie.
	Name string `json:"name,omitempty"`

	// Path: Path to set for the cookie.
	Path string `json:"path,omitempty"`

	// Ttl: Lifetime of the cookie.
	Ttl *Duration `json:"ttl,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ConsistentHashLoadBalancerSettingsHttpCookie) MarshalJSON() ([]byte, error) {
	type NoMethod ConsistentHashLoadBalancerSettingsHttpCookie
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CorsPolicy: The specification for allowing client side cross-origin
// requests. Please see W3C Recommendation for Cross Origin Resource
// Sharing
type CorsPolicy struct {
	// AllowCredentials: In response to a preflight request, setting this to
	// true indicates that the actual request can include user credentials.
	// This translates to the Access-Control-Allow-Credentials
	// header.
	// Default is false.
	AllowCredentials bool `json:"allowCredentials,omitempty"`

	// AllowHeaders: Specifies the content for the
	// Access-Control-Allow-Headers header.
	AllowHeaders []string `json:"allowHeaders,omitempty"`

	// AllowMethods: Specifies the content for the
	// Access-Control-Allow-Methods header.
	AllowMethods []string `json:"allowMethods,omitempty"`

	// AllowOriginRegexes: Specifies the regualar expression patterns that
	// match allowed origins. For regular expression grammar please see
	// github.com/google/re2/wiki/Syntax
	// An origin is allowed if it matches either an item in allowOrigins or
	// an item in allowOriginRegexes.
	AllowOriginRegexes []string `json:"allowOriginRegexes,omitempty"`

	// AllowOrigins: Specifies the list of origins that will be allowed to
	// do CORS requests.
	// An origin is allowed if it matches either an item in allowOrigins or
	// an item in allowOriginRegexes.
	AllowOrigins []string `json:"allowOrigins,omitempty"`

	// Disabled: If true, specifies the CORS policy is disabled. The default
	// value of false, which indicates that the CORS policy is in effect.
	Disabled bool `json:"disabled,omitempty"`

	// ExposeHeaders: Specifies the content for the
	// Access-Control-Expose-Headers header.
	ExposeHeaders []string `json:"exposeHeaders,omitempty"`

	// MaxAge: Specifies how long results of a preflight request can be
	// cached in seconds. This translates to the Access-Control-Max-Age
	// header.
	MaxAge int64 `json:"maxAge,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AllowCredentials") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllowCredentials") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *CorsPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod CorsPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CustomerEncryptionKey struct {
	// KmsKeyName: The name of the encryption key that is stored in Google
	// Cloud KMS.
	KmsKeyName string `json:"kmsKeyName,omitempty"`

	// KmsKeyServiceAccount: The service account being used for the
	// encryption request for the given KMS key. If absent, the Compute
	// Engine default service account is used.
	KmsKeyServiceAccount string `json:"kmsKeyServiceAccount,omitempty"`

	// RawKey: Specifies a 256-bit customer-supplied encryption key, encoded
	// in RFC 4648 base64 to either encrypt or decrypt this resource.
	RawKey string `json:"rawKey,omitempty"`

	// RsaEncryptedKey: Specifies an RFC 4648 base64 encoded, RSA-wrapped
	// 2048-bit customer-supplied encryption key to either encrypt or
	// decrypt this resource.
	//
	// The key must meet the following requirements before you can provide
	// it to Compute Engine:
	// - The key is wrapped using a RSA public key certificate provided by
	// Google.
	// - After being wrapped, the key must be encoded in RFC 4648 base64
	// encoding.  Gets the RSA public key certificate provided by Google
	// at:
	// https://cloud-certs.storage.googleapis.com/google-cloud-csek-ingress.pem
	RsaEncryptedKey string `json:"rsaEncryptedKey,omitempty"`

	// Sha256: [Output only] The RFC 4648 base64 encoded SHA-256 hash of the
	// customer-supplied encryption key that protects this resource.
	Sha256 string `json:"sha256,omitempty"`

	// ForceSendFields is a list of field names (e.g. "KmsKeyName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "KmsKeyName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CustomerEncryptionKey) MarshalJSON() ([]byte, error) {
	type NoMethod CustomerEncryptionKey
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type CustomerEncryptionKeyProtectedDisk struct {
	// DiskEncryptionKey: Decrypts data associated with the disk with a
	// customer-supplied encryption key.
	DiskEncryptionKey *CustomerEncryptionKey `json:"diskEncryptionKey,omitempty"`

	// Source: Specifies a valid partial or full URL to an existing
	// Persistent Disk resource. This field is only applicable for
	// persistent disks.
	Source string `json:"source,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DiskEncryptionKey")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DiskEncryptionKey") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *CustomerEncryptionKeyProtectedDisk) MarshalJSON() ([]byte, error) {
	type NoMethod CustomerEncryptionKeyProtectedDisk
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DeprecationStatus: Deprecation status for a public resource.
type DeprecationStatus struct {
	// Deleted: An optional RFC3339 timestamp on or after which the state of
	// this resource is intended to change to DELETED. This is only
	// informational and the status will not change unless the client
	// explicitly changes it.
	Deleted string `json:"deleted,omitempty"`

	// Deprecated -- An optional RFC3339 timestamp on or after which the
	// state of this resource is intended to change to DEPRECATED. This is
	// only informational and the status will not change unless the client
	// explicitly changes it.
	Deprecated string `json:"deprecated,omitempty"`

	// Obsolete: An optional RFC3339 timestamp on or after which the state
	// of this resource is intended to change to OBSOLETE. This is only
	// informational and the status will not change unless the client
	// explicitly changes it.
	Obsolete string `json:"obsolete,omitempty"`

	// Replacement: The URL of the suggested replacement for a deprecated
	// resource. The suggested replacement resource must be the same kind of
	// resource as the deprecated resource.
	Replacement string `json:"replacement,omitempty"`

	// State: The deprecation state of this resource. This can be ACTIVE,
	// DEPRECATED, OBSOLETE, or DELETED. Operations which communicate the
	// end of life date for an image, can use ACTIVE. Operations which
	// create a new resource using a DEPRECATED resource will return
	// successfully, but with a warning indicating the deprecated resource
	// and recommending its replacement. Operations which use OBSOLETE or
	// DELETED resources will be rejected and result in an error.
	//
	// Possible values:
	//   "ACTIVE"
	//   "DELETED"
	//   "DEPRECATED"
	//   "OBSOLETE"
	State string `json:"state,omitempty"`

	// StateOverride: The rollout policy of this deprecation. This policy is
	// only enforced by image family views. The rollout policy restricts the
	// zones where the associated resource is considered in a deprecated
	// state. When the rollout policy does not include the user specified
	// zone, or if the zone is rolled out, the associated resource is
	// considered in a deprecated state.
	StateOverride *RolloutPolicy `json:"stateOverride,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Deleted") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Deleted") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DeprecationStatus) MarshalJSON() ([]byte, error) {
	type NoMethod DeprecationStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Disk: Represents a Persistent Disk resource.
//
// Google Compute Engine has two Disk resources:
//
// * Zonal (/compute/docs/reference/rest/{$api_version}/disks) *
// Regional
// (/compute/docs/reference/rest/{$api_version}/regionDisks)
//
// Persistent disks are required for running your VM instances. Create
// both boot and non-boot (data) persistent disks. For more information,
// read Persistent Disks. For more storage options, read Storage
// options.
//
// The disks resource represents a zonal persistent disk. For more
// information, read Zonal persistent disks.
//
// The regionDisks resource represents a regional persistent disk. For
// more information, read  Regional resources. (== resource_for
// {$api_version}.disks ==) (== resource_for {$api_version}.regionDisks
// ==)
type Disk struct {
	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// DiskEncryptionKey: Encrypts the disk using a customer-supplied
	// encryption key.
	//
	// After you encrypt a disk with a customer-supplied key, you must
	// provide the same key if you use the disk later (e.g. to create a disk
	// snapshot, to create a disk image, to create a machine image, or to
	// attach the disk to a virtual machine).
	//
	// Customer-supplied encryption keys do not protect access to metadata
	// of the disk.
	//
	// If you do not provide an encryption key when creating the disk, then
	// the disk will be encrypted using an automatically generated key and
	// you do not need to provide a key to use the disk later.
	DiskEncryptionKey *CustomerEncryptionKey `json:"diskEncryptionKey,omitempty"`

	// EraseWindowsVssSignature: Specifies whether the disk restored from a
	// source snapshot should erase Windows specific VSS signature.
	EraseWindowsVssSignature bool `json:"eraseWindowsVssSignature,omitempty"`

	// GuestOsFeatures: A list of features to enable on the guest operating
	// system. Applicable only for bootable images. Read  Enabling guest
	// operating system features to see a list of available options.
	GuestOsFeatures []*GuestOsFeature `json:"guestOsFeatures,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// Interface: Specifies the disk interface to use for attaching this
	// disk, which is either SCSI or NVME. The default is SCSI.
	//
	// Possible values:
	//   "NVME"
	//   "SCSI"
	//   "UNSPECIFIED"
	Interface string `json:"interface,omitempty"`

	// Kind: [Output Only] Type of the resource. Always compute#disk for
	// disks.
	Kind string `json:"kind,omitempty"`

	// LabelFingerprint: A fingerprint for the labels being applied to this
	// disk, which is essentially a hash of the labels set used for
	// optimistic locking. The fingerprint is initially generated by Compute
	// Engine and changes after every request to modify or update labels.
	// You must always provide an up-to-date fingerprint hash in order to
	// update or change labels, otherwise the request will fail with error
	// 412 conditionNotMet.
	//
	// To see the latest fingerprint, make a get() request to retrieve a
	// disk.
	LabelFingerprint string `json:"labelFingerprint,omitempty"`

	// Labels: Labels to apply to this disk. These can be later modified by
	// the setLabels method.
	Labels map[string]string `json:"labels,omitempty"`

	// LastAttachTimestamp: [Output Only] Last attach timestamp in RFC3339
	// text format.
	LastAttachTimestamp string `json:"lastAttachTimestamp,omitempty"`

	// LastDetachTimestamp: [Output Only] Last detach timestamp in RFC3339
	// text format.
	LastDetachTimestamp string `json:"lastDetachTimestamp,omitempty"`

	// LicenseCodes: Integer license codes indicating which licenses are
	// attached to this disk.
	LicenseCodes googleapi.Int64s `json:"licenseCodes,omitempty"`

	// Licenses: A list of publicly visible licenses. Reserved for Google's
	// use.
	Licenses []string `json:"licenses,omitempty"`

	// LocationHint: An opaque location hint used to place the disk close to
	// other resources. This field is for use by internal tools that use the
	// public API.
	LocationHint string `json:"locationHint,omitempty"`

	// MultiWriter: Indicates whether or not the disk can be read/write
	// attached to more than one instance.
	MultiWriter bool `json:"multiWriter,omitempty"`

	// Name: Name of the resource. Provided by the client when the resource
	// is created. The name must be 1-63 characters long, and comply with
	// RFC1035. Specifically, the name must be 1-63 characters long and
	// match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means
	// the first character must be a lowercase letter, and all following
	// characters must be a dash, lowercase letter, or digit, except the
	// last character, which cannot be a dash.
	Name string `json:"name,omitempty"`

	// Options: Internal use only.
	Options string `json:"options,omitempty"`

	// PhysicalBlockSizeBytes: Physical block size of the persistent disk,
	// in bytes. If not present in a request, a default value is used. The
	// currently supported size is 4096, other sizes may be added in the
	// future. If an unsupported value is requested, the error message will
	// list the supported values for the caller's project.
	PhysicalBlockSizeBytes int64 `json:"physicalBlockSizeBytes,omitempty,string"`

	// ProvisionedIops: Indicates how many IOPS must be provisioned for the
	// disk.
	ProvisionedIops int64 `json:"provisionedIops,omitempty,string"`

	// Region: [Output Only] URL of the region where the disk resides. Only
	// applicable for regional resources. You must specify this field as
	// part of the HTTP request URL. It is not settable as a field in the
	// request body.
	Region string `json:"region,omitempty"`

	// ReplicaZones: URLs of the zones where the disk should be replicated
	// to. Only applicable for regional resources.
	ReplicaZones []string `json:"replicaZones,omitempty"`

	// ResourcePolicies: Resource policies applied to this disk for
	// automatic snapshot creations.
	ResourcePolicies []string `json:"resourcePolicies,omitempty"`

	// SatisfiesPzs: [Output Only] Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`

	// SelfLink: [Output Only] Server-defined fully-qualified URL for this
	// resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource's
	// resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// SizeGb: Size, in GB, of the persistent disk. You can specify this
	// field when creating a persistent disk using the sourceImage,
	// sourceSnapshot, or sourceDisk parameter, or specify it alone to
	// create an empty persistent disk.
	//
	// If you specify this field along with a source, the value of sizeGb
	// must not be less than the size of the source. Acceptable values are 1
	// to 65536, inclusive.
	SizeGb int64 `json:"sizeGb,omitempty,string"`

	// SourceDisk: The source disk used to create this disk. You can provide
	// this as a partial or full URL to the resource. For example, the
	// following are valid values:
	// -
	// https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk
	//
	// -
	// https://www.googleapis.com/compute/v1/projects/project/regions/region/disks/disk
	//
	// - projects/project/zones/zone/disks/disk
	// - projects/project/regions/region/disks/disk
	// - zones/zone/disks/disk
	// - regions/region/disks/disk
	SourceDisk string `json:"sourceDisk,omitempty"`

	// SourceDiskId: [Output Only] The unique ID of the disk used to create
	// this disk. This value identifies the exact disk that was used to
	// create this persistent disk. For example, if you created the
	// persistent disk from a disk that was later deleted and recreated
	// under the same name, the source disk ID would identify the exact
	// version of the disk that was used.
	SourceDiskId string `json:"sourceDiskId,omitempty"`

	// SourceImage: The source image used to create this disk. If the source
	// image is deleted, this field will not be set.
	//
	// To create a disk with one of the public operating system images,
	// specify the image by its family name. For example, specify
	// family/debian-9 to use the latest Debian 9
	// image:
	// projects/debian-cloud/global/images/family/debian-9
	//
	//
	// Alternatively, use a specific version of a public operating system
	// image:
	// projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD
	//
	//
	// To create a disk with a custom image that you created, specify the
	// image name in the following
	// format:
	// global/images/my-custom-image
	//
	//
	// You can also specify a custom image by its image family, which
	// returns the latest version of the image in that family. Replace the
	// image name with
	// family/family-name:
	// global/images/family/my-image-family
	SourceImage string `json:"sourceImage,omitempty"`

	// SourceImageEncryptionKey: The customer-supplied encryption key of the
	// source image. Required if the source image is protected by a
	// customer-supplied encryption key.
	SourceImageEncryptionKey *CustomerEncryptionKey `json:"sourceImageEncryptionKey,omitempty"`

	// SourceImageId: [Output Only] The ID value of the image used to create
	// this disk. This value identifies the exact image that was used to
	// create this persistent disk. For example, if you created the
	// persistent disk from an image that was later deleted and recreated
	// under the same name, the source image ID would identify the exact
	// version of the image that was used.
	SourceImageId string `json:"sourceImageId,omitempty"`

	// SourceInPlaceSnapshot: [Deprecated] The source in-place snapshot used
	// to create this disk. You can provide this as a partial or full URL to
	// the resource. For example, the following are valid values:
	// -
	// https://www.googleapis.com/compute/v1/projects/project/global/inPlaceSnapshots/inPlaceSnapshots
	//
	// - projects/project/global/inPlaceSnapshots/inPlaceSnapshots
	// - global/inPlaceSnapshots/inPlaceSnapshots
	SourceInPlaceSnapshot string `json:"sourceInPlaceSnapshot,omitempty"`

	// SourceInPlaceSnapshotId: [Deprecated] [Output Only] The unique ID of
	// the in-place snapshot used to create this disk. This value identifies
	// the exact in-place snapshot that was used to create this persistent
	// disk. For example, if you created the persistent disk from an
	// in-place snapshot that was later deleted and recreated under the same
	// name, the source in-place snapshot ID would identify the exact
	// version of the in-place snapshot that was used.
	SourceInPlaceSnapshotId string `json:"sourceInPlaceSnapshotId,omitempty"`

	// SourceInstantSnapshot: The source instant snapshot used to create
	// this disk. You can provide this as a partial or full URL to the
	// resource. For example, the following are valid values:
	// -
	// https://www.googleapis.com/compute/v1/projects/project/zones/zone/instantSnapshots/instantSnapshot
	//
	// - projects/project/zones/zone/instantSnapshots/instantSnapshot
	// - zones/zone/instantSnapshots/instantSnapshot
	SourceInstantSnapshot string `json:"sourceInstantSnapshot,omitempty"`

	// SourceInstantSnapshotId: [Output Only] The unique ID of the instant
	// snapshot used to create this disk. This value identifies the exact
	// instant snapshot that was used to create this persistent disk. For
	// example, if you created the persistent disk from an instant snapshot
	// that was later deleted and recreated under the same name, the source
	// instant snapshot ID would identify the exact version of the instant
	// snapshot that was used.
	SourceInstantSnapshotId string `json:"sourceInstantSnapshotId,omitempty"`

	// SourceSnapshot: The source snapshot used to create this disk. You can
	// provide this as a partial or full URL to the resource. For example,
	// the following are valid values:
	// -
	// https://www.googleapis.com/compute/v1/projects/project/global/snapshots/snapshot
	//
	// - projects/project/global/snapshots/snapshot
	// - global/snapshots/snapshot
	SourceSnapshot string `json:"sourceSnapshot,omitempty"`

	// SourceSnapshotEncryptionKey: The customer-supplied encryption key of
	// the source snapshot. Required if the source snapshot is protected by
	// a customer-supplied encryption key.
	SourceSnapshotEncryptionKey *CustomerEncryptionKey `json:"sourceSnapshotEncryptionKey,omitempty"`

	// SourceSnapshotId: [Output Only] The unique ID of the snapshot used to
	// create this disk. This value identifies the exact snapshot that was
	// used to create this persistent disk. For example, if you created the
	// persistent disk from a snapshot that was later deleted and recreated
	// under the same name, the source snapshot ID would identify the exact
	// version of the snapshot that was used.
	SourceSnapshotId string `json:"sourceSnapshotId,omitempty"`

	// SourceStorageObject: The full Google Cloud Storage URI where the disk
	// image is stored. This file must be a gzip-compressed tarball whose
	// name ends in .tar.gz or virtual machine disk whose name ends in vmdk.
	// Valid URIs may start with gs:// or https://storage.googleapis.com/.
	// This flag is not optimized for creating multiple disks from a source
	// storage object. To create many disks from a source storage object,
	// use gcloud compute images import instead.
	SourceStorageObject string `json:"sourceStorageObject,omitempty"`

	// Status: [Output Only] The status of disk creation.
	// - CREATING: Disk is provisioning.
	// - RESTORING: Source data is being copied into the disk.
	// - FAILED: Disk creation failed.
	// - READY: Disk is ready for use.
	// - DELETING: Disk is deleting.
	//
	// Possible values:
	//   "CREATING"
	//   "DELETING"
	//   "FAILED"
	//   "READY"
	//   "RESTORING"
	Status string `json:"status,omitempty"`

	// StorageType: [Deprecated] Storage type of the persistent disk.
	//
	// Possible values:
	//   "HDD"
	//   "SSD"
	StorageType string `json:"storageType,omitempty"`

	// Type: URL of the disk type resource describing which disk type to use
	// to create the disk. Provide this when creating the disk. For example:
	// projects/project/zones/zone/diskTypes/pd-standard  or pd-ssd
	Type string `json:"type,omitempty"`

	// UserLicenses: A list of publicly visible user-licenses. Unlike
	// regular licenses, user provided licenses can be modified after the
	// disk is created. This includes a list of URLs to the license
	// resource. For example, to provide a debian
	// license:
	// https://www.googleapis.com/compute/v1/projects/debian-cloud/global/licenses/debian-9-stretch
	UserLicenses []string `json:"userLicenses,omitempty"`

	// Users: [Output Only] Links to the users of the disk (attached
	// instances) in form: projects/project/zones/zone/instances/instance
	Users []string `json:"users,omitempty"`

	// Zone: [Output Only] URL of the zone where the disk resides. You must
	// specify this field as part of the HTTP request URL. It is not
	// settable as a field in the request body.
	Zone string `json:"zone,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreationTimestamp")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreationTimestamp") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Disk) MarshalJSON() ([]byte, error) {
	type NoMethod Disk
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DiskAggregatedList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of DisksScopedList resources.
	Items map[string]DisksScopedList `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#diskAggregatedList for aggregated lists of persistent disks.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Unreachables: [Output Only] Unreachable resources.
	Unreachables []string `json:"unreachables,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *DiskAggregatedListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskAggregatedList) MarshalJSON() ([]byte, error) {
	type NoMethod DiskAggregatedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DiskAggregatedListWarning: [Output Only] Informational warning
// message.
type DiskAggregatedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*DiskAggregatedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskAggregatedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod DiskAggregatedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DiskAggregatedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskAggregatedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod DiskAggregatedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DiskInstantiationConfig: A specification of the desired way to
// instantiate a disk in the instance template when its created from a
// source instance.
type DiskInstantiationConfig struct {
	// AutoDelete: Specifies whether the disk will be auto-deleted when the
	// instance is deleted (but not when the disk is detached from the
	// instance).
	AutoDelete bool `json:"autoDelete,omitempty"`

	// CustomImage: The custom source image to be used to restore this disk
	// when instantiating this instance template.
	CustomImage string `json:"customImage,omitempty"`

	// DeviceName: Specifies the device name of the disk to which the
	// configurations apply to.
	DeviceName string `json:"deviceName,omitempty"`

	// InstantiateFrom: Specifies whether to include the disk and what image
	// to use. Possible values are:
	// - source-image: to use the same image that was used to create the
	// source instance's corresponding disk. Applicable to the boot disk and
	// additional read-write disks.
	// - source-image-family: to use the same image family that was used to
	// create the source instance's corresponding disk. Applicable to the
	// boot disk and additional read-write disks.
	// - custom-image: to use a user-provided image url for disk creation.
	// Applicable to the boot disk and additional read-write disks.
	// - attach-read-only: to attach a read-only disk. Applicable to
	// read-only disks.
	// - do-not-include: to exclude a disk from the template. Applicable to
	// additional read-write disks, local SSDs, and read-only disks.
	//
	// Possible values:
	//   "ATTACH_READ_ONLY"
	//   "BLANK"
	//   "CUSTOM_IMAGE"
	//   "DEFAULT"
	//   "DO_NOT_INCLUDE"
	//   "SOURCE_IMAGE"
	//   "SOURCE_IMAGE_FAMILY"
	InstantiateFrom string `json:"instantiateFrom,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AutoDelete") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AutoDelete") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskInstantiationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DiskInstantiationConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DiskList: A list of Disk resources.
type DiskList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of Disk resources.
	Items []*Disk `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always compute#diskList for
	// lists of disks.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *DiskListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskList) MarshalJSON() ([]byte, error) {
	type NoMethod DiskList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DiskListWarning: [Output Only] Informational warning message.
type DiskListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*DiskListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod DiskListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DiskListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod DiskListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DiskMoveRequest struct {
	// DestinationZone: The URL of the destination zone to move the disk.
	// This can be a full or partial URL. For example, the following are all
	// valid URLs to a zone:
	// - https://www.googleapis.com/compute/v1/projects/project/zones/zone
	//
	// - projects/project/zones/zone
	// - zones/zone
	DestinationZone string `json:"destinationZone,omitempty"`

	// TargetDisk: The URL of the target disk to move. This can be a full or
	// partial URL. For example, the following are all valid URLs to a disk:
	//
	// -
	// https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk
	//
	// - projects/project/zones/zone/disks/disk
	// - zones/zone/disks/disk
	TargetDisk string `json:"targetDisk,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DestinationZone") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DestinationZone") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DiskMoveRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DiskMoveRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DiskType: Represents a Disk Type resource.
//
// Google Compute Engine has two Disk Type resources:
//
// * Regional
// (/compute/docs/reference/rest/{$api_version}/regionDiskTypes) * Zonal
// (/compute/docs/reference/rest/{$api_version}/diskTypes)
//
// You can choose from a variety of disk types based on your needs. For
// more information, read Storage options.
//
// The diskTypes resource represents disk types for a zonal persistent
// disk. For more information, read Zonal persistent disks.
//
// The regionDiskTypes resource represents disk types for a regional
// persistent disk. For more information, read Regional persistent
// disks. (== resource_for {$api_version}.diskTypes ==) (== resource_for
// {$api_version}.regionDiskTypes ==)
type DiskType struct {
	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// DefaultDiskSizeGb: [Output Only] Server-defined default disk size in
	// GB.
	DefaultDiskSizeGb int64 `json:"defaultDiskSizeGb,omitempty,string"`

	// Deprecated -- [Output Only] The deprecation status associated with
	// this disk type.
	Deprecated *DeprecationStatus `json:"deprecated,omitempty"`

	// Description: [Output Only] An optional description of this resource.
	Description string `json:"description,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// Kind: [Output Only] Type of the resource. Always compute#diskType for
	// disk types.
	Kind string `json:"kind,omitempty"`

	// Name: [Output Only] Name of the resource.
	Name string `json:"name,omitempty"`

	// Region: [Output Only] URL of the region where the disk type resides.
	// Only applicable for regional resources. You must specify this field
	// as part of the HTTP request URL. It is not settable as a field in the
	// request body.
	Region string `json:"region,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// ValidDiskSize: [Output Only] An optional textual description of the
	// valid disk size, such as "10GB-10TB".
	ValidDiskSize string `json:"validDiskSize,omitempty"`

	// Zone: [Output Only] URL of the zone where the disk type resides. You
	// must specify this field as part of the HTTP request URL. It is not
	// settable as a field in the request body.
	Zone string `json:"zone,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreationTimestamp")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreationTimestamp") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DiskType) MarshalJSON() ([]byte, error) {
	type NoMethod DiskType
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DiskTypeAggregatedList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of DiskTypesScopedList resources.
	Items map[string]DiskTypesScopedList `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#diskTypeAggregatedList.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Unreachables: [Output Only] Unreachable resources.
	Unreachables []string `json:"unreachables,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *DiskTypeAggregatedListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskTypeAggregatedList) MarshalJSON() ([]byte, error) {
	type NoMethod DiskTypeAggregatedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DiskTypeAggregatedListWarning: [Output Only] Informational warning
// message.
type DiskTypeAggregatedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*DiskTypeAggregatedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskTypeAggregatedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod DiskTypeAggregatedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DiskTypeAggregatedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskTypeAggregatedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod DiskTypeAggregatedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DiskTypeList: Contains a list of disk types.
type DiskTypeList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of DiskType resources.
	Items []*DiskType `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always compute#diskTypeList for
	// disk types.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *DiskTypeListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskTypeList) MarshalJSON() ([]byte, error) {
	type NoMethod DiskTypeList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DiskTypeListWarning: [Output Only] Informational warning message.
type DiskTypeListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*DiskTypeListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskTypeListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod DiskTypeListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DiskTypeListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskTypeListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod DiskTypeListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DiskTypesScopedList struct {
	// DiskTypes: [Output Only] A list of disk types contained in this
	// scope.
	DiskTypes []*DiskType `json:"diskTypes,omitempty"`

	// Warning: [Output Only] Informational warning which replaces the list
	// of disk types when the list is empty.
	Warning *DiskTypesScopedListWarning `json:"warning,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DiskTypes") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DiskTypes") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskTypesScopedList) MarshalJSON() ([]byte, error) {
	type NoMethod DiskTypesScopedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DiskTypesScopedListWarning: [Output Only] Informational warning which
// replaces the list of disk types when the list is empty.
type DiskTypesScopedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*DiskTypesScopedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskTypesScopedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod DiskTypesScopedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DiskTypesScopedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiskTypesScopedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod DiskTypesScopedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DisksAddResourcePoliciesRequest struct {
	// ResourcePolicies: Resource policies to be added to this disk.
	// Currently you can only specify one policy here.
	ResourcePolicies []string `json:"resourcePolicies,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResourcePolicies") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResourcePolicies") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DisksAddResourcePoliciesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DisksAddResourcePoliciesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DisksRemoveResourcePoliciesRequest struct {
	// ResourcePolicies: Resource policies to be removed from this disk.
	ResourcePolicies []string `json:"resourcePolicies,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResourcePolicies") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResourcePolicies") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DisksRemoveResourcePoliciesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DisksRemoveResourcePoliciesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DisksResizeRequest struct {
	// SizeGb: The new size of the persistent disk, which is specified in
	// GB.
	SizeGb int64 `json:"sizeGb,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "SizeGb") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SizeGb") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DisksResizeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DisksResizeRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DisksScopedList struct {
	// Disks: [Output Only] A list of disks contained in this scope.
	Disks []*Disk `json:"disks,omitempty"`

	// Warning: [Output Only] Informational warning which replaces the list
	// of disks when the list is empty.
	Warning *DisksScopedListWarning `json:"warning,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Disks") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Disks") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DisksScopedList) MarshalJSON() ([]byte, error) {
	type NoMethod DisksScopedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DisksScopedListWarning: [Output Only] Informational warning which
// replaces the list of disks when the list is empty.
type DisksScopedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*DisksScopedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DisksScopedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod DisksScopedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DisksScopedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DisksScopedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod DisksScopedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DisplayDevice: A set of Display Device options
type DisplayDevice struct {
	// EnableDisplay: Defines whether the instance has Display enabled.
	EnableDisplay bool `json:"enableDisplay,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EnableDisplay") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EnableDisplay") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DisplayDevice) MarshalJSON() ([]byte, error) {
	type NoMethod DisplayDevice
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DistributionPolicy struct {
	// TargetShape: The distribution shape to which the group converges
	// either proactively or on resize events (depending on the value set in
	// updatePolicy.instanceRedistributionType).
	//
	// Possible values:
	//   "ANY"
	//   "BALANCED"
	//   "EVEN"
	TargetShape string `json:"targetShape,omitempty"`

	// Zones: Zones where the regional managed instance group will create
	// and manage its instances.
	Zones []*DistributionPolicyZoneConfiguration `json:"zones,omitempty"`

	// ForceSendFields is a list of field names (e.g. "TargetShape") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TargetShape") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DistributionPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod DistributionPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type DistributionPolicyZoneConfiguration struct {
	// Zone: The URL of the zone. The zone must exist in the region where
	// the managed instance group is located.
	Zone string `json:"zone,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Zone") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Zone") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DistributionPolicyZoneConfiguration) MarshalJSON() ([]byte, error) {
	type NoMethod DistributionPolicyZoneConfiguration
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Duration: A Duration represents a fixed-length span of time
// represented as a count of seconds and fractions of seconds at
// nanosecond resolution. It is independent of any calendar and concepts
// like "day" or "month". Range is approximately 10,000 years.
type Duration struct {
	// Nanos: Span of time that's a fraction of a second at nanosecond
	// resolution. Durations less than one second are represented with a 0
	// `seconds` field and a positive `nanos` field. Must be from 0 to
	// 999,999,999 inclusive.
	Nanos int64 `json:"nanos,omitempty"`

	// Seconds: Span of time at a resolution of a second. Must be from 0 to
	// 315,576,000,000 inclusive. Note: these bounds are computed from: 60
	// sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
	Seconds int64 `json:"seconds,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Nanos") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Nanos") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Duration) MarshalJSON() ([]byte, error) {
	type NoMethod Duration
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ExchangedPeeringRoute struct {
	// DestRange: The destination range of the route.
	DestRange string `json:"destRange,omitempty"`

	// Imported: True if the peering route has been imported from a peer.
	// The actual import happens if the field
	// networkPeering.importCustomRoutes is true for this network, and
	// networkPeering.exportCustomRoutes is true for the peer network, and
	// the import does not result in a route conflict.
	Imported bool `json:"imported,omitempty"`

	// NextHopRegion: The region of peering route next hop, only applies to
	// dynamic routes.
	NextHopRegion string `json:"nextHopRegion,omitempty"`

	// Priority: The priority of the peering route.
	Priority int64 `json:"priority,omitempty"`

	// Type: The type of the peering route.
	//
	// Possible values:
	//   "DYNAMIC_PEERING_ROUTE"
	//   "STATIC_PEERING_ROUTE"
	//   "SUBNET_PEERING_ROUTE"
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DestRange") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DestRange") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExchangedPeeringRoute) MarshalJSON() ([]byte, error) {
	type NoMethod ExchangedPeeringRoute
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ExchangedPeeringRoutesList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of ExchangedPeeringRoute resources.
	Items []*ExchangedPeeringRoute `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#exchangedPeeringRoutesList for exchanged peering routes
	// lists.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *ExchangedPeeringRoutesListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExchangedPeeringRoutesList) MarshalJSON() ([]byte, error) {
	type NoMethod ExchangedPeeringRoutesList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExchangedPeeringRoutesListWarning: [Output Only] Informational
// warning message.
type ExchangedPeeringRoutesListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*ExchangedPeeringRoutesListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExchangedPeeringRoutesListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod ExchangedPeeringRoutesListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ExchangedPeeringRoutesListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExchangedPeeringRoutesListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod ExchangedPeeringRoutesListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Expr: Represents a textual expression in the Common Expression
// Language (CEL) syntax. CEL is a C-like expression language. The
// syntax and semantics of CEL are documented at
// https://github.com/google/cel-spec.
//
// Example (Comparison):
//
// title: "Summary size limit" description: "Determines if a summary is
// less than 100 chars" expression: "document.summary.size() <
// 100"
//
// Example (Equality):
//
// title: "Requestor is owner" description: "Determines if requestor is
// the document owner" expression: "document.owner ==
// request.auth.claims.email"
//
// Example (Logic):
//
// title: "Public documents" description: "Determine whether the
// document should be publicly visible" expression: "document.type !=
// 'private' && document.type != 'internal'"
//
// Example (Data Manipulation):
//
// title: "Notification string" description: "Create a notification
// string with a timestamp." expression: "'New message received at ' +
// string(document.create_time)"
//
// The exact variables and functions that may be referenced within an
// expression are determined by the service that evaluates it. See the
// service documentation for additional information.
type Expr struct {
	// Description: Optional. Description of the expression. This is a
	// longer text which describes the expression, e.g. when hovered over it
	// in a UI.
	Description string `json:"description,omitempty"`

	// Expression: Textual representation of an expression in Common
	// Expression Language syntax.
	Expression string `json:"expression,omitempty"`

	// Location: Optional. String indicating the location of the expression
	// for error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`

	// Title: Optional. Title for the expression, i.e. a short string
	// describing its purpose. This can be used e.g. in UIs which allow to
	// enter the expression.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Expr) MarshalJSON() ([]byte, error) {
	type NoMethod Expr
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExternalVpnGateway: Represents an external VPN gateway.
//
// External VPN gateway is the on-premises VPN gateway(s) or another
// cloud provider's VPN gateway that connects to your Google Cloud VPN
// gateway.
//
// To create a highly available VPN from Google Cloud Platform to your
// VPN gateway or another cloud provider's VPN gateway, you must create
// a external VPN gateway resource with information about the other
// gateway.
//
// For more information about using external VPN gateways, see  Creating
// an HA VPN gateway and tunnel pair to a peer VPN. (== resource_for
// {$api_version}.externalVpnGateways ==)
type ExternalVpnGateway struct {
	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id *uint64 `json:"id,omitempty,string"`

	// Interfaces: List of interfaces for this external VPN gateway.
	Interfaces []*ExternalVpnGatewayInterface `json:"interfaces,omitempty"`

	// Kind: [Output Only] Type of the resource. Always
	// compute#externalVpnGateway for externalVpnGateways.
	Kind string `json:"kind,omitempty"`

	// LabelFingerprint: A fingerprint for the labels being applied to this
	// ExternalVpnGateway, which is essentially a hash of the labels set
	// used for optimistic locking. The fingerprint is initially generated
	// by Compute Engine and changes after every request to modify or update
	// labels. You must always provide an up-to-date fingerprint hash in
	// order to update or change labels, otherwise the request will fail
	// with error 412 conditionNotMet.
	//
	// To see the latest fingerprint, make a get() request to retrieve an
	// ExternalVpnGateway.
	LabelFingerprint string `json:"labelFingerprint,omitempty"`

	// Labels: Labels for this resource. These can only be added or modified
	// by the setLabels method. Each label key/value pair must comply with
	// RFC1035. Label values may be empty.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Name of the resource. Provided by the client when the resource
	// is created. The name must be 1-63 characters long, and comply with
	// RFC1035. Specifically, the name must be 1-63 characters long and
	// match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means
	// the first character must be a lowercase letter, and all following
	// characters must be a dash, lowercase letter, or digit, except the
	// last character, which cannot be a dash.
	Name string `json:"name,omitempty"`

	// RedundancyType: Indicates the user-supplied redundancy type of this
	// external VPN gateway.
	//
	// Possible values:
	//   "FOUR_IPS_REDUNDANCY"
	//   "SINGLE_IP_INTERNALLY_REDUNDANT"
	//   "TWO_IPS_REDUNDANCY"
	RedundancyType string `json:"redundancyType,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreationTimestamp")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreationTimestamp") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ExternalVpnGateway) MarshalJSON() ([]byte, error) {
	type NoMethod ExternalVpnGateway
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExternalVpnGatewayInterface: The interface for the external VPN
// gateway.
type ExternalVpnGatewayInterface struct {
	// Id: The numeric ID of this interface. The allowed input values for
	// this id for different redundancy types of external VPN gateway:
	// SINGLE_IP_INTERNALLY_REDUNDANT - 0 TWO_IPS_REDUNDANCY - 0, 1
	// FOUR_IPS_REDUNDANCY - 0, 1, 2, 3
	Id int64 `json:"id,omitempty"`

	// IpAddress: IP address of the interface in the external VPN gateway.
	// Only IPv4 is supported. This IP address can be either from your
	// on-premise gateway or another Cloud provider's VPN gateway, it cannot
	// be an IP address from Google Compute Engine.
	IpAddress string `json:"ipAddress,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExternalVpnGatewayInterface) MarshalJSON() ([]byte, error) {
	type NoMethod ExternalVpnGatewayInterface
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExternalVpnGatewayList: Response to the list request, and contains a
// list of externalVpnGateways.
type ExternalVpnGatewayList struct {
	Etag string `json:"etag,omitempty"`

	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of ExternalVpnGateway resources.
	Items []*ExternalVpnGateway `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#externalVpnGatewayList  for lists of externalVpnGateways.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *ExternalVpnGatewayListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Etag") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Etag") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExternalVpnGatewayList) MarshalJSON() ([]byte, error) {
	type NoMethod ExternalVpnGatewayList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExternalVpnGatewayListWarning: [Output Only] Informational warning
// message.
type ExternalVpnGatewayListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*ExternalVpnGatewayListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExternalVpnGatewayListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod ExternalVpnGatewayListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ExternalVpnGatewayListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExternalVpnGatewayListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod ExternalVpnGatewayListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type FileContentBuffer struct {
	// Content: The raw content in the secure keys file.
	Content string `json:"content,omitempty"`

	// FileType: The file type of source file.
	//
	// Possible values:
	//   "BIN"
	//   "UNDEFINED"
	//   "X509"
	FileType string `json:"fileType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Content") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Content") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FileContentBuffer) MarshalJSON() ([]byte, error) {
	type NoMethod FileContentBuffer
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Firewall: Represents a Firewall Rule resource.
//
// Firewall rules allow or deny ingress traffic to, and egress traffic
// from your instances. For more information, read Firewall rules.
type Firewall struct {
	// Allowed: The list of ALLOW rules specified by this firewall. Each
	// rule specifies a protocol and port-range tuple that describes a
	// permitted connection.
	Allowed []*FirewallAllowed `json:"allowed,omitempty"`

	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Denied: The list of DENY rules specified by this firewall. Each rule
	// specifies a protocol and port-range tuple that describes a denied
	// connection.
	Denied []*FirewallDenied `json:"denied,omitempty"`

	// Description: An optional description of this resource. Provide this
	// field when you create the resource.
	Description string `json:"description,omitempty"`

	// DestinationRanges: If destination ranges are specified, the firewall
	// rule applies only to traffic that has destination IP address in these
	// ranges. These ranges must be expressed in CIDR format. Only IPv4 is
	// supported.
	DestinationRanges []string `json:"destinationRanges,omitempty"`

	// Direction: Direction of traffic to which this firewall applies,
	// either `INGRESS` or `EGRESS`. The default is `INGRESS`. For `INGRESS`
	// traffic, you cannot specify the destinationRanges field, and for
	// `EGRESS` traffic, you cannot specify the sourceRanges or sourceTags
	// fields.
	//
	// Possible values:
	//   "EGRESS"
	//   "INGRESS"
	Direction string `json:"direction,omitempty"`

	// Disabled: Denotes whether the firewall rule is disabled. When set to
	// true, the firewall rule is not enforced and the network behaves as if
	// it did not exist. If this is unspecified, the firewall rule will be
	// enabled.
	Disabled bool `json:"disabled,omitempty"`

	// EnableLogging: Deprecated in favor of enable in LogConfig. This field
	// denotes whether to enable logging for a particular firewall rule. If
	// logging is enabled, logs will be exported t Cloud Logging.
	EnableLogging bool `json:"enableLogging,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// Kind: [Output Only] Type of the resource. Always compute#firewall for
	// firewall rules.
	Kind string `json:"kind,omitempty"`

	// LogConfig: This field denotes the logging options for a particular
	// firewall rule. If logging is enabled, logs will be exported to Cloud
	// Logging.
	LogConfig *FirewallLogConfig `json:"logConfig,omitempty"`

	// Name: Name of the resource; provided by the client when the resource
	// is created. The name must be 1-63 characters long, and comply with
	// RFC1035. Specifically, the name must be 1-63 characters long and
	// match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?. The first
	// character must be a lowercase letter, and all following characters
	// (except for the last character) must be a dash, lowercase letter, or
	// digit. The last character must be a lowercase letter or digit.
	Name string `json:"name,omitempty"`

	// Network: URL of the network resource for this firewall rule. If not
	// specified when creating a firewall rule, the default network is
	// used:
	// global/networks/default
	// If you choose to specify this field, you can specify the network as a
	// full or partial URL. For example, the following are all valid URLs:
	//
	// -
	// https://www.googleapis.com/compute/v1/projects/myproject/global/networks/my-network
	//
	// - projects/myproject/global/networks/my-network
	// - global/networks/default
	Network string `json:"network,omitempty"`

	// Priority: Priority for this rule. This is an integer between `0` and
	// `65535`, both inclusive. The default value is `1000`. Relative
	// priorities determine which rule takes effect if multiple rules apply.
	// Lower values indicate higher priority. For example, a rule with
	// priority `0` has higher precedence than a rule with priority `1`.
	// DENY rules take precedence over ALLOW rules if they have equal
	// priority. Note that VPC networks have implied rules with a priority
	// of `65535`. To avoid conflicts with the implied rules, use a priority
	// number less than `65535`.
	Priority int64 `json:"priority,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// SourceRanges: If source ranges are specified, the firewall rule
	// applies only to traffic that has a source IP address in these ranges.
	// These ranges must be expressed in CIDR format. One or both of
	// sourceRanges and sourceTags may be set. If both fields are set, the
	// rule applies to traffic that has a source IP address within
	// sourceRanges OR a source IP from a resource with a matching tag
	// listed in the sourceTags field. The connection does not need to match
	// both fields for the rule to apply. Only IPv4 is supported.
	SourceRanges []string `json:"sourceRanges,omitempty"`

	// SourceServiceAccounts: If source service accounts are specified, the
	// firewall rules apply only to traffic originating from an instance
	// with a service account in this list. Source service accounts cannot
	// be used to control traffic to an instance's external IP address
	// because service accounts are associated with an instance, not an IP
	// address. sourceRanges can be set at the same time as
	// sourceServiceAccounts. If both are set, the firewall applies to
	// traffic that has a source IP address within the sourceRanges OR a
	// source IP that belongs to an instance with service account listed in
	// sourceServiceAccount. The connection does not need to match both
	// fields for the firewall to apply. sourceServiceAccounts cannot be
	// used at the same time as sourceTags or targetTags.
	SourceServiceAccounts []string `json:"sourceServiceAccounts,omitempty"`

	// SourceTags: If source tags are specified, the firewall rule applies
	// only to traffic with source IPs that match the primary network
	// interfaces of VM instances that have the tag and are in the same VPC
	// network. Source tags cannot be used to control traffic to an
	// instance's external IP address, it only applies to traffic between
	// instances in the same virtual network. Because tags are associated
	// with instances, not IP addresses. One or both of sourceRanges and
	// sourceTags may be set. If both fields are set, the firewall applies
	// to traffic that has a source IP address within sourceRanges OR a
	// source IP from a resource with a matching tag listed in the
	// sourceTags field. The connection does not need to match both fields
	// for the firewall to apply.
	SourceTags []string `json:"sourceTags,omitempty"`

	// TargetServiceAccounts: A list of service accounts indicating sets of
	// instances located in the network that may make network connections as
	// specified in allowed[]. targetServiceAccounts cannot be used at the
	// same time as targetTags or sourceTags. If neither
	// targetServiceAccounts nor targetTags are specified, the firewall rule
	// applies to all instances on the specified network.
	TargetServiceAccounts []string `json:"targetServiceAccounts,omitempty"`

	// TargetTags: A list of tags that controls which instances the firewall
	// rule applies to. If targetTags are specified, then the firewall rule
	// applies only to instances in the VPC network that have one of those
	// tags. If no targetTags are specified, the firewall rule applies to
	// all instances on the specified network.
	TargetTags []string `json:"targetTags,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Allowed") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Allowed") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Firewall) MarshalJSON() ([]byte, error) {
	type NoMethod Firewall
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type FirewallAllowed struct {
	// IPProtocol: The IP protocol to which this rule applies. The protocol
	// type is required when creating a firewall rule. This value can either
	// be one of the following well known protocol strings (tcp, udp, icmp,
	// esp, ah, ipip, sctp) or the IP protocol number.
	IPProtocol string `json:"IPProtocol,omitempty"`

	// Ports: An optional list of ports to which this rule applies. This
	// field is only applicable for the UDP or TCP protocol. Each entry must
	// be either an integer or a range. If not specified, this rule applies
	// to connections through any port.
	//
	// Example inputs include: ["22"], ["80","443"], and ["12345-12349"].
	Ports []string `json:"ports,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IPProtocol") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IPProtocol") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirewallAllowed) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallAllowed
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type FirewallDenied struct {
	// IPProtocol: The IP protocol to which this rule applies. The protocol
	// type is required when creating a firewall rule. This value can either
	// be one of the following well known protocol strings (tcp, udp, icmp,
	// esp, ah, ipip, sctp) or the IP protocol number.
	IPProtocol string `json:"IPProtocol,omitempty"`

	// Ports: An optional list of ports to which this rule applies. This
	// field is only applicable for the UDP or TCP protocol. Each entry must
	// be either an integer or a range. If not specified, this rule applies
	// to connections through any port.
	//
	// Example inputs include: ["22"], ["80","443"], and ["12345-12349"].
	Ports []string `json:"ports,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IPProtocol") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IPProtocol") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirewallDenied) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallDenied
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FirewallList: Contains a list of firewalls.
type FirewallList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of Firewall resources.
	Items []*Firewall `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always compute#firewallList for
	// lists of firewalls.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *FirewallListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirewallList) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FirewallListWarning: [Output Only] Informational warning message.
type FirewallListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*FirewallListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirewallListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type FirewallListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirewallListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FirewallLogConfig: The available logging options for a firewall rule.
type FirewallLogConfig struct {
	// Enable: This field denotes whether to enable logging for a particular
	// firewall rule.
	Enable bool `json:"enable,omitempty"`

	// Metadata: This field can only be specified for a particular firewall
	// rule if logging is enabled for that rule. This field denotes whether
	// to include or exclude metadata for firewall logs.
	//
	// Possible values:
	//   "EXCLUDE_ALL_METADATA"
	//   "INCLUDE_ALL_METADATA"
	Metadata string `json:"metadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enable") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enable") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirewallLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallLogConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type FirewallPoliciesListAssociationsResponse struct {
	// Associations: A list of associations.
	Associations []*FirewallPolicyAssociation `json:"associations,omitempty"`

	// Kind: [Output Only] Type of firewallPolicy associations. Always
	// compute#FirewallPoliciesListAssociations for lists of firewallPolicy
	// associations.
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Associations") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Associations") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirewallPoliciesListAssociationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallPoliciesListAssociationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FirewallPolicy: Represents a Firewall Policy resource. (==
// resource_for {$api_version}.firewallPolicies ==)
type FirewallPolicy struct {
	// Associations: A list of associations that belong to this firewall
	// policy.
	Associations []*FirewallPolicyAssociation `json:"associations,omitempty"`

	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// DisplayName: Depreacted, please use short name instead. User-provided
	// name of the Organization firewall plicy. The name should be unique in
	// the organization in which the firewall policy is created. The name
	// must be 1-63 characters long, and comply with RFC1035. Specifically,
	// the name must be 1-63 characters long and match the regular
	// expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
	// character must be a lowercase letter, and all following characters
	// must be a dash, lowercase letter, or digit, except the last
	// character, which cannot be a dash.
	DisplayName string `json:"displayName,omitempty"`

	// Fingerprint: Specifies a fingerprint for this resource, which is
	// essentially a hash of the metadata's contents and used for optimistic
	// locking. The fingerprint is initially generated by Compute Engine and
	// changes after every request to modify or update metadata. You must
	// always provide an up-to-date fingerprint hash in order to update or
	// change metadata, otherwise the request will fail with error 412
	// conditionNotMet.
	//
	// To see the latest fingerprint, make get() request to the firewall
	// policy.
	Fingerprint string `json:"fingerprint,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// Kind: [Output only] Type of the resource. Always
	// compute#firewallPolicyfor firewall policies
	Kind string `json:"kind,omitempty"`

	// Name: [Output Only] Name of the resource. It is a numeric ID
	// allocated by GCP which uniquely identifies the Firewall Policy.
	Name string `json:"name,omitempty"`

	// Parent: [Output Only] The parent of the firewall policy.
	Parent string `json:"parent,omitempty"`

	// Region: [Output Only] URL of the region where the regional firewall
	// policy resides. This field is not applicable to global firewall
	// policies. You must specify this field as part of the HTTP request
	// URL. It is not settable as a field in the request body.
	Region string `json:"region,omitempty"`

	// RuleTupleCount: [Output Only] Total count of all firewall policy rule
	// tuples. A firewall policy can not exceed a set number of tuples.
	RuleTupleCount int64 `json:"ruleTupleCount,omitempty"`

	// Rules: A list of rules that belong to this policy. There must always
	// be a default rule (rule with priority 2147483647 and match "*"). If
	// no rules are provided when creating a firewall policy, a default rule
	// with action "allow" will be added.
	Rules []*FirewallPolicyRule `json:"rules,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// ShortName: User-provided name of the Organization firewall plicy. The
	// name should be unique in the organization in which the firewall
	// policy is created. The name must be 1-63 characters long, and comply
	// with RFC1035. Specifically, the name must be 1-63 characters long and
	// match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means
	// the first character must be a lowercase letter, and all following
	// characters must be a dash, lowercase letter, or digit, except the
	// last character, which cannot be a dash.
	ShortName string `json:"shortName,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Associations") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Associations") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirewallPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type FirewallPolicyAssociation struct {
	// AttachmentTarget: The target that the firewall policy is attached to.
	AttachmentTarget string `json:"attachmentTarget,omitempty"`

	// DisplayName: [Output Only] Deprecated, please use short name instead.
	// The display name of the firewall policy of the association.
	DisplayName string `json:"displayName,omitempty"`

	// FirewallPolicyId: [Output Only] The firewall policy ID of the
	// association.
	FirewallPolicyId string `json:"firewallPolicyId,omitempty"`

	// Name: The name for an association.
	Name string `json:"name,omitempty"`

	// ShortName: [Output Only] The short name of the firewall policy of the
	// association.
	ShortName string `json:"shortName,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AttachmentTarget") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttachmentTarget") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *FirewallPolicyAssociation) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallPolicyAssociation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type FirewallPolicyList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of FirewallPolicy resources.
	Items []*FirewallPolicy `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#firewallPolicyList for listsof FirewallPolicies
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *FirewallPolicyListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirewallPolicyList) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallPolicyList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FirewallPolicyListWarning: [Output Only] Informational warning
// message.
type FirewallPolicyListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*FirewallPolicyListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirewallPolicyListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallPolicyListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type FirewallPolicyListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirewallPolicyListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallPolicyListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FirewallPolicyRule: Represents a rule that describes one or more
// match conditions along with the action to be taken when traffic
// matches this condition (allow or deny).
type FirewallPolicyRule struct {
	// Action: The Action to perform when the client connection triggers the
	// rule. Can currently be either "allow" or "deny()" where valid values
	// for status are 403, 404, and 502.
	Action string `json:"action,omitempty"`

	// Description: An optional description for this resource.
	Description string `json:"description,omitempty"`

	// Direction: The direction in which this rule applies.
	//
	// Possible values:
	//   "EGRESS"
	//   "INGRESS"
	Direction string `json:"direction,omitempty"`

	// Disabled: Denotes whether the firewall policy rule is disabled. When
	// set to true, the firewall policy rule is not enforced and traffic
	// behaves as if it did not exist. If this is unspecified, the firewall
	// policy rule will be enabled.
	Disabled bool `json:"disabled,omitempty"`

	// EnableLogging: Denotes whether to enable logging for a particular
	// rule. If logging is enabled, logs will be exported to the configured
	// export destination in Stackdriver. Logs may be exported to BigQuery
	// or Pub/Sub. Note: you cannot enable logging on "goto_next" rules.
	EnableLogging bool `json:"enableLogging,omitempty"`

	// Kind: [Output only] Type of the resource. Always
	// compute#firewallPolicyRule for firewall policy rules
	Kind string `json:"kind,omitempty"`

	// Match: A match condition that incoming traffic is evaluated against.
	// If it evaluates to true, the corresponding 'action' is enforced.
	Match *FirewallPolicyRuleMatcher `json:"match,omitempty"`

	// Priority: An integer indicating the priority of a rule in the list.
	// The priority must be a positive value between 0 and 2147483647. Rules
	// are evaluated from highest to lowest priority where 0 is the highest
	// priority and 2147483647 is the lowest prority.
	Priority int64 `json:"priority,omitempty"`

	// RuleTupleCount: [Output Only] Calculation of the complexity of a
	// single firewall policy rule.
	RuleTupleCount int64 `json:"ruleTupleCount,omitempty"`

	// TargetResources: A list of network resource URLs to which this rule
	// applies. This field allows you to control which network's VMs get
	// this rule. If this field is left blank, all VMs within the
	// organization will receive the rule.
	TargetResources []string `json:"targetResources,omitempty"`

	// TargetSecureLabels: A list of secure labels that controls which
	// instances the firewall rule applies to. If targetSecureLabel are
	// specified, then the firewall rule applies only to instances in the
	// VPC network that have one of those secure labels. targetSecureLabel
	// may not be set at the same time as targetServiceAccounts. If neither
	// targetServiceAccounts nor targetSecureLabel are specified, the
	// firewall rule applies to all instances on the specified network.
	// Maximum number of target label values allowed is 256.
	TargetSecureLabels []string `json:"targetSecureLabels,omitempty"`

	// TargetSecureTags: A list of secure tags that controls which instances
	// the firewall rule applies to. If targetSecureTag are specified, then
	// the firewall rule applies only to instances in the VPC network that
	// have one of those EFFECTIVE secure tags, if all the target_secure_tag
	// are in INEFFECTIVE state, then this rule will be ignored.
	// targetSecureTag may not be set at the same time as
	// targetServiceAccounts. If neither targetServiceAccounts nor
	// targetSecureTag are specified, the firewall rule applies to all
	// instances on the specified network. Maximum number of target label
	// tags allowed is 256.
	TargetSecureTags []*FirewallPolicyRuleSecureTag `json:"targetSecureTags,omitempty"`

	// TargetServiceAccounts: A list of service accounts indicating the sets
	// of instances that are applied with this rule.
	TargetServiceAccounts []string `json:"targetServiceAccounts,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Action") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirewallPolicyRule) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallPolicyRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FirewallPolicyRuleMatcher: Represents a match condition that incoming
// traffic is evaluated against. Exactly one field must be specified.
type FirewallPolicyRuleMatcher struct {
	// DestIpRanges: CIDR IP address range. Maximum number of destination
	// CIDR IP ranges allowed is 256.
	DestIpRanges []string `json:"destIpRanges,omitempty"`

	// Layer4Configs: Pairs of IP protocols and ports that the rule should
	// match.
	Layer4Configs []*FirewallPolicyRuleMatcherLayer4Config `json:"layer4Configs,omitempty"`

	// SrcIpRanges: CIDR IP address range. Maximum number of source CIDR IP
	// ranges allowed is 256.
	SrcIpRanges []string `json:"srcIpRanges,omitempty"`

	// SrcSecureLabels: List of firewall label values, which should be
	// matched at the source of the traffic. Maximum number of source label
	// values allowed is 256.
	SrcSecureLabels []string `json:"srcSecureLabels,omitempty"`

	// SrcSecureTags: List of secure tag values, which should be matched at
	// the source of the traffic. For INGRESS rule, if all the srcSecureTag
	// are INEFFECTIVE, and there is no srcIpRange, this rule will be
	// ignored. Maximum number of source tag values allowed is 256.
	SrcSecureTags []*FirewallPolicyRuleSecureTag `json:"srcSecureTags,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DestIpRanges") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DestIpRanges") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirewallPolicyRuleMatcher) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallPolicyRuleMatcher
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type FirewallPolicyRuleMatcherLayer4Config struct {
	// IpProtocol: The IP protocol to which this rule applies. The protocol
	// type is required when creating a firewall rule. This value can either
	// be one of the following well known protocol strings (tcp, udp, icmp,
	// esp, ah, ipip, sctp), or the IP protocol number.
	IpProtocol string `json:"ipProtocol,omitempty"`

	// Ports: An optional list of ports to which this rule applies. This
	// field is only applicable for UDP or TCP protocol. Each entry must be
	// either an integer or a range. If not specified, this rule applies to
	// connections through any port.
	//
	// Example inputs include: ["22"], ["80","443"], and ["12345-12349"].
	Ports []string `json:"ports,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IpProtocol") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IpProtocol") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirewallPolicyRuleMatcherLayer4Config) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallPolicyRuleMatcherLayer4Config
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type FirewallPolicyRuleSecureTag struct {
	// Name: Name of the secure tag, created with TagManager's TagValue API.
	Name string `json:"name,omitempty"`

	// State: [Output Only] State of the secure tag, either `EFFECTIVE` or
	// `INEFFECTIVE`. A secure tag is `INEFFECTIVE` when it is deleted or
	// its network is deleted.
	//
	// Possible values:
	//   "EFFECTIVE"
	//   "INEFFECTIVE"
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirewallPolicyRuleSecureTag) MarshalJSON() ([]byte, error) {
	type NoMethod FirewallPolicyRuleSecureTag
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FixedOrPercent: Encapsulates numeric value that can be either
// absolute or relative.
type FixedOrPercent struct {
	// Calculated: [Output Only] Absolute value of VM instances calculated
	// based on the specific mode.
	//
	//
	// - If the value is fixed, then the calculated value is equal to the
	// fixed value.
	// - If the value is a percent, then the calculated value is percent/100
	// * targetSize. For example, the calculated value of a 80% of a managed
	// instance group with 150 instances would be (80/100 * 150) = 120 VM
	// instances. If there is a remainder, the number is rounded up.
	Calculated int64 `json:"calculated,omitempty"`

	// Fixed: Specifies a fixed number of VM instances. This must be a
	// positive integer.
	Fixed int64 `json:"fixed,omitempty"`

	// Percent: Specifies a percentage of instances between 0 to 100%,
	// inclusive. For example, specify 80 for 80%.
	Percent int64 `json:"percent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Calculated") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Calculated") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FixedOrPercent) MarshalJSON() ([]byte, error) {
	type NoMethod FixedOrPercent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ForwardingRule: Represents a Forwarding Rule resource.
//
// Forwarding rule resources in GCP can be either regional or global in
// scope:
//
// * Global
// (/compute/docs/reference/rest/{$api_version}/globalForwardingRules) *
// Regional
// (/compute/docs/reference/rest/{$api_version}/forwardingRules)
//
// A forwarding rule and its corresponding IP address represent the
// frontend configuration of a Google Cloud Platform load balancer.
// Forwarding rules can also reference target instances and Cloud VPN
// Classic gateways (targetVpnGateway).
//
// For more information, read Forwarding rule concepts and Using
// protocol forwarding.
//
// (== resource_for {$api_version}.forwardingRules ==) (== resource_for
// {$api_version}.globalForwardingRules ==) (== resource_for
// {$api_version}.regionForwardingRules ==)
type ForwardingRule struct {
	// IPAddress: IP address that this forwarding rule serves. When a client
	// sends traffic to this IP address, the forwarding rule directs the
	// traffic to the target that you specify in the forwarding rule.
	//
	// If you don't specify a reserved IP address, an ephemeral IP address
	// is assigned. Methods for specifying an IP address:
	//
	// * IPv4 dotted decimal, as in `100.1.2.3` * Full URL, as in
	// https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name
	// * Partial URL or by name, as in:
	// - projects/project_id/regions/region/addresses/address-name
	// - regions/region/addresses/address-name
	// - global/addresses/address-name
	// - address-name
	//
	// The loadBalancingScheme and the forwarding rule's target determine
	// the type of IP address that you can use. For detailed information,
	// refer to IP address specifications
	// (/load-balancing/docs/forwarding-rule-concepts#ip_address_specificatio
	// ns).
	//
	// Must be set to `0.0.0.0` when the target is targetGrpcProxy that has
	// validateForProxyless field set to true.
	//
	// For Private Service Connect forwarding rules that forward traffic to
	// Google APIs, IP address must be provided.
	IPAddress string `json:"IPAddress,omitempty"`

	// IPProtocol: The IP protocol to which this rule applies.
	//
	// For protocol forwarding, valid options are TCP, UDP, ESP, AH, SCTP
	// and ICMP.
	//
	// The valid IP protocols are different for different load balancing
	// products:
	// - Internal TCP/UDP Load Balancing: The load balancing scheme is
	// INTERNAL, and one of TCP, UDP or ALL is valid.
	// - Traffic Director: The load balancing scheme is
	// INTERNAL_SELF_MANAGED, and only TCP is valid.
	// - Internal HTTP(S) Load Balancing: The load balancing scheme is
	// INTERNAL_MANAGED, and only TCP is valid.
	// - HTTP(S), SSL Proxy, and TCP Proxy Load Balancing: The load
	// balancing scheme is EXTERNAL and only TCP is valid.
	// - Network Load Balancing: The load balancing scheme is EXTERNAL, and
	// one of TCP or UDP is valid.
	//
	// Possible values:
	//   "AH"
	//   "ALL"
	//   "ESP"
	//   "ICMP"
	//   "SCTP"
	//   "TCP"
	//   "UDP"
	IPProtocol string `json:"IPProtocol,omitempty"`

	// AllPorts: This field is used along with the backend_service field for
	// internal load balancing or with the target field for internal
	// TargetInstance. This field cannot be used with port or portRange
	// fields.
	//
	// When the load balancing scheme is INTERNAL and protocol is TCP/UDP,
	// specify this field to allow packets addressed to any ports will be
	// forwarded to the backends configured with this forwarding rule.
	AllPorts bool `json:"allPorts,omitempty"`

	// AllowGlobalAccess: This field is used along with the backend_service
	// field for internal load balancing or with the target field for
	// internal TargetInstance. If the field is set to TRUE, clients can
	// access ILB from all regions. Otherwise only allows access from
	// clients in the same region as the internal load balancer.
	AllowGlobalAccess bool `json:"allowGlobalAccess,omitempty"`

	// BackendService: Identifies the backend service to which the
	// forwarding rule sends traffic. Required for Internal TCP/UDP Load
	// Balancing and Network Load Balancing; must be omitted for all other
	// load balancer types.
	BackendService string `json:"backendService,omitempty"`

	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// Fingerprint: Fingerprint of this resource. A hash of the contents
	// stored in this object. This field is used in optimistic locking. This
	// field will be ignored when inserting a ForwardingRule. Include the
	// fingerprint in patch request to ensure that you do not overwrite
	// changes that were applied from another concurrent request.
	//
	// To see the latest fingerprint, make a get() request to retrieve a
	// ForwardingRule.
	Fingerprint string `json:"fingerprint,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// IpVersion: The IP Version that will be used by this forwarding rule.
	// Valid options are IPV4 or IPV6. This can only be specified for an
	// external global forwarding rule.
	//
	// Possible values:
	//   "IPV4"
	//   "IPV6"
	//   "UNSPECIFIED_VERSION"
	IpVersion string `json:"ipVersion,omitempty"`

	// IsMirroringCollector: Indicates whether or not this load balancer can
	// be used as a collector for packet mirroring. To prevent mirroring
	// loops, instances behind this load balancer will not have their
	// traffic mirrored even if a PacketMirroring rule applies to them. This
	// can only be set to true for load balancers that have their
	// loadBalancingScheme set to INTERNAL.
	IsMirroringCollector bool `json:"isMirroringCollector,omitempty"`

	// Kind: [Output Only] Type of the resource. Always
	// compute#forwardingRule for Forwarding Rule resources.
	Kind string `json:"kind,omitempty"`

	// LabelFingerprint: A fingerprint for the labels being applied to this
	// resource, which is essentially a hash of the labels set used for
	// optimistic locking. The fingerprint is initially generated by Compute
	// Engine and changes after every request to modify or update labels.
	// You must always provide an up-to-date fingerprint hash in order to
	// update or change labels, otherwise the request will fail with error
	// 412 conditionNotMet.
	//
	// To see the latest fingerprint, make a get() request to retrieve a
	// ForwardingRule.
	LabelFingerprint string `json:"labelFingerprint,omitempty"`

	// Labels: Labels for this resource. These can only be added or modified
	// by the setLabels method. Each label key/value pair must comply with
	// RFC1035. Label values may be empty.
	Labels map[string]string `json:"labels,omitempty"`

	// LoadBalancingScheme: Specifies the forwarding rule type.
	//
	//
	// - EXTERNAL is used for:
	// - Classic Cloud VPN gateways
	// - Protocol forwarding to VMs from an external IP address
	// - HTTP(S), SSL Proxy, TCP Proxy, and Network Load Balancing
	// - INTERNAL is used for:
	// - Protocol forwarding to VMs from an internal IP address
	// - Internal TCP/UDP Load Balancing
	// - INTERNAL_MANAGED is used for:
	// - Internal HTTP(S) Load Balancing
	// - INTERNAL_SELF_MANAGED is used for:
	// - Traffic Director
	//
	// For more information about forwarding rules, refer to Forwarding rule
	// concepts.
	//
	// Possible values:
	//   "EXTERNAL"
	//   "EXTERNAL_MANAGED"
	//   "INTERNAL"
	//   "INTERNAL_MANAGED"
	//   "INTERNAL_SELF_MANAGED"
	//   "INVALID"
	LoadBalancingScheme string `json:"loadBalancingScheme,omitempty"`

	// MetadataFilters: Opaque filter criteria used by Loadbalancer to
	// restrict routing configuration to a limited set of xDS compliant
	// clients. In their xDS requests to Loadbalancer, xDS clients present
	// node metadata. When there is a match, the relevant configuration is
	// made available to those proxies. Otherwise, all the resources (e.g.
	// TargetHttpProxy, UrlMap) referenced by the ForwardingRule will not be
	// visible to those proxies.
	// For each metadataFilter in this list, if its filterMatchCriteria is
	// set to MATCH_ANY, at least one of the filterLabels must match the
	// corresponding label provided in the metadata. If its
	// filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels
	// must match with corresponding labels provided in the metadata. If
	// multiple metadataFilters are specified, all of them need to be
	// satisfied in order to be considered a match.
	// metadataFilters specified here will be applifed before those
	// specified in the UrlMap that this ForwardingRule
	// references.
	// metadataFilters only applies to Loadbalancers that have their
	// loadBalancingScheme set to INTERNAL_SELF_MANAGED.
	MetadataFilters []*MetadataFilter `json:"metadataFilters,omitempty"`

	// Name: Name of the resource; provided by the client when the resource
	// is created. The name must be 1-63 characters long, and comply with
	// RFC1035. Specifically, the name must be 1-63 characters long and
	// match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means
	// the first character must be a lowercase letter, and all following
	// characters must be a dash, lowercase letter, or digit, except the
	// last character, which cannot be a dash.
	Name string `json:"name,omitempty"`

	// Network: This field is not used for external load balancing.
	//
	// For Internal TCP/UDP Load Balancing, this field identifies the
	// network that the load balanced IP should belong to for this
	// Forwarding Rule. If this field is not specified, the default network
	// will be used.
	//
	// For Private Service Connect forwarding rules that forward traffic to
	// Google APIs, a network must be provided.
	Network string `json:"network,omitempty"`

	// NetworkTier: This signifies the networking tier used for configuring
	// this load balancer and can only take the following values: PREMIUM,
	// STANDARD.
	//
	// For regional ForwardingRule, the valid values are PREMIUM and
	// STANDARD. For GlobalForwardingRule, the valid value is PREMIUM.
	//
	// If this field is not specified, it is assumed to be PREMIUM. If
	// IPAddress is specified, this value must be equal to the networkTier
	// of the Address.
	//
	// Possible values:
	//   "FIXED_STANDARD"
	//   "PREMIUM"
	//   "SELECT"
	//   "STANDARD"
	//   "STANDARD_OVERRIDES_FIXED_STANDARD"
	NetworkTier string `json:"networkTier,omitempty"`

	// PortRange: This field can be used only if: * Load balancing scheme is
	// one of EXTERNAL,  INTERNAL_SELF_MANAGED or INTERNAL_MANAGED, and *
	// IPProtocol is one of TCP, UDP, or SCTP.
	//
	// Packets addressed to ports in the specified range will be forwarded
	// to target or  backend_service. You can only use one of ports,
	// port_range, or allPorts. The three are mutually exclusive. Forwarding
	// rules with the same [IPAddress, IPProtocol] pair must have disjoint
	// port ranges.
	//
	// Some types of forwarding target have constraints on the acceptable
	// ports:
	// - TargetHttpProxy: 80, 8080
	// - TargetHttpsProxy: 443
	// - TargetGrpcProxy: no constraints
	// - TargetTcpProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993,
	// 995, 1688, 1883, 5222
	// - TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993,
	// 995, 1688, 1883, 5222
	// - TargetVpnGateway: 500, 4500
	PortRange string `json:"portRange,omitempty"`

	// Ports: The ports field is only supported when the forwarding rule
	// references a backend_service directly. Supported load balancing
	// products are Internal TCP/UDP Load Balancing and Network Load
	// Balancing. Only packets addressed to the specified list of ports are
	// forwarded to backends.
	//
	// You can only use one of ports and port_range, or allPorts. The three
	// are mutually exclusive.
	//
	// You can specify a list of up to five ports, which can be
	// non-contiguous.
	//
	// For Internal TCP/UDP Load Balancing, if you specify allPorts, you
	// should not specify ports.
	//
	// For more information, see Port specifications
	// (/load-balancing/docs/forwarding-rule-concepts#port_specifications).
	Ports []string `json:"ports,omitempty"`

	// PscConnectionId: [Output Only] The PSC connection id of the PSC
	// Forwarding Rule.
	PscConnectionId uint64 `json:"pscConnectionId,omitempty,string"`

	// Region: [Output Only] URL of the region where the regional forwarding
	// rule resides. This field is not applicable to global forwarding
	// rules. You must specify this field as part of the HTTP request URL.
	// It is not settable as a field in the request body.
	Region string `json:"region,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// ServiceDirectoryRegistrations: Service Directory resources to
	// register this forwarding rule with. Currently, only supports a single
	// Service Directory resource.
	//
	// It is only supported for Internal TCP/UDP Load Balancing and Internal
	// HTTP(S) Load Balancing.
	ServiceDirectoryRegistrations []*ForwardingRuleServiceDirectoryRegistration `json:"serviceDirectoryRegistrations,omitempty"`

	// ServiceLabel: An optional prefix to the service name for this
	// Forwarding Rule. If specified, the prefix is the first label of the
	// fully qualified service name.
	//
	// The label must be 1-63 characters long, and comply with RFC1035.
	// Specifically, the label must be 1-63 characters long and match the
	// regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
	// character must be a lowercase letter, and all following characters
	// must be a dash, lowercase letter, or digit, except the last
	// character, which cannot be a dash.
	//
	// This field is only used for internal load balancing.
	ServiceLabel string `json:"serviceLabel,omitempty"`

	// ServiceName: [Output Only] The internal fully qualified service name
	// for this Forwarding Rule.
	//
	// This field is only used for internal load balancing.
	ServiceName string `json:"serviceName,omitempty"`

	// Subnetwork: This field is only used for internal load balancing.
	//
	// For internal load balancing, this field identifies the subnetwork
	// that the load balanced IP should belong to for this Forwarding
	// Rule.
	//
	// If the network specified is in auto subnet mode, this field is
	// optional. However, if the network is in custom subnet mode, a
	// subnetwork must be specified.
	Subnetwork string `json:"subnetwork,omitempty"`

	Target string `json:"target,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "IPAddress") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IPAddress") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ForwardingRule) MarshalJSON() ([]byte, error) {
	type NoMethod ForwardingRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ForwardingRuleAggregatedList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of ForwardingRulesScopedList resources.
	Items map[string]ForwardingRulesScopedList `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#forwardingRuleAggregatedList for lists of forwarding rules.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Unreachables: [Output Only] Unreachable resources.
	Unreachables []string `json:"unreachables,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *ForwardingRuleAggregatedListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ForwardingRuleAggregatedList) MarshalJSON() ([]byte, error) {
	type NoMethod ForwardingRuleAggregatedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ForwardingRuleAggregatedListWarning: [Output Only] Informational
// warning message.
type ForwardingRuleAggregatedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*ForwardingRuleAggregatedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ForwardingRuleAggregatedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod ForwardingRuleAggregatedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ForwardingRuleAggregatedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ForwardingRuleAggregatedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod ForwardingRuleAggregatedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ForwardingRuleList: Contains a list of ForwardingRule resources.
type ForwardingRuleList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of ForwardingRule resources.
	Items []*ForwardingRule `json:"items,omitempty"`

	// Kind: Type of resource.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *ForwardingRuleListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ForwardingRuleList) MarshalJSON() ([]byte, error) {
	type NoMethod ForwardingRuleList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ForwardingRuleListWarning: [Output Only] Informational warning
// message.
type ForwardingRuleListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*ForwardingRuleListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ForwardingRuleListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod ForwardingRuleListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ForwardingRuleListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ForwardingRuleListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod ForwardingRuleListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ForwardingRuleReference struct {
	ForwardingRule string `json:"forwardingRule,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ForwardingRule") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ForwardingRule") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ForwardingRuleReference) MarshalJSON() ([]byte, error) {
	type NoMethod ForwardingRuleReference
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ForwardingRuleServiceDirectoryRegistration: Describes the
// auto-registration of the Forwarding Rule to Service Directory. The
// region and project of the Service Directory resource generated from
// this registration will be the same as this Forwarding Rule.
type ForwardingRuleServiceDirectoryRegistration struct {
	// Namespace: Service Directory namespace to register the forwarding
	// rule under.
	Namespace string `json:"namespace,omitempty"`

	// Service: Service Directory service to register the forwarding rule
	// under.
	Service string `json:"service,omitempty"`

	// ServiceDirectoryRegion: [Optional] Service Directory region to
	// register this global forwarding rule under. Default to "us-central1".
	// Only used for PSC for Google APIs. All PSC for Google APIs Forwarding
	// Rules on the same network should use the same Service Directory
	// region.
	ServiceDirectoryRegion string `json:"serviceDirectoryRegion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Namespace") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Namespace") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ForwardingRuleServiceDirectoryRegistration) MarshalJSON() ([]byte, error) {
	type NoMethod ForwardingRuleServiceDirectoryRegistration
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ForwardingRulesScopedList struct {
	// ForwardingRules: A list of forwarding rules contained in this scope.
	ForwardingRules []*ForwardingRule `json:"forwardingRules,omitempty"`

	// Warning: Informational warning which replaces the list of forwarding
	// rules when the list is empty.
	Warning *ForwardingRulesScopedListWarning `json:"warning,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ForwardingRules") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ForwardingRules") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ForwardingRulesScopedList) MarshalJSON() ([]byte, error) {
	type NoMethod ForwardingRulesScopedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ForwardingRulesScopedListWarning: Informational warning which
// replaces the list of forwarding rules when the list is empty.
type ForwardingRulesScopedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*ForwardingRulesScopedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ForwardingRulesScopedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod ForwardingRulesScopedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ForwardingRulesScopedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ForwardingRulesScopedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod ForwardingRulesScopedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GRPCHealthCheck struct {
	// GrpcServiceName: The gRPC service name for the health check. This
	// field is optional. The value of grpc_service_name has the following
	// meanings by convention:
	// - Empty service_name means the overall status of all services at the
	// backend.
	// - Non-empty service_name means the health of that gRPC service, as
	// defined by the owner of the service.
	// The grpc_service_name can only be ASCII.
	GrpcServiceName string `json:"grpcServiceName,omitempty"`

	// Port: The port number for the health check request. Must be specified
	// if port_name and port_specification are not set or if
	// port_specification is USE_FIXED_PORT. Valid values are 1 through
	// 65535.
	Port int64 `json:"port,omitempty"`

	// PortName: Port name as defined in InstanceGroup#NamedPort#name. If
	// both port and port_name are defined, port takes precedence. The
	// port_name should conform to RFC1035.
	PortName string `json:"portName,omitempty"`

	// PortSpecification: Specifies how port is selected for health
	// checking, can be one of following values:
	// USE_FIXED_PORT: The port number in port is used for health
	// checking.
	// USE_NAMED_PORT: The portName is used for health
	// checking.
	// USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for
	// each network endpoint is used for health checking. For other
	// backends, the port or named port specified in the Backend Service is
	// used for health checking.
	//
	//
	// If not specified, gRPC health check follows behavior specified in
	// port and portName fields.
	//
	// Possible values:
	//   "USE_FIXED_PORT"
	//   "USE_NAMED_PORT"
	//   "USE_SERVING_PORT"
	PortSpecification string `json:"portSpecification,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GrpcServiceName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GrpcServiceName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GRPCHealthCheck) MarshalJSON() ([]byte, error) {
	type NoMethod GRPCHealthCheck
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GetOwnerInstanceResponse struct {
	// Instance: Full instance resource URL.
	Instance string `json:"instance,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Instance") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Instance") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GetOwnerInstanceResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GetOwnerInstanceResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GlobalNetworkEndpointGroupsAttachEndpointsRequest struct {
	// NetworkEndpoints: The list of network endpoints to be attached.
	NetworkEndpoints []*NetworkEndpoint `json:"networkEndpoints,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NetworkEndpoints") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NetworkEndpoints") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GlobalNetworkEndpointGroupsAttachEndpointsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GlobalNetworkEndpointGroupsAttachEndpointsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GlobalNetworkEndpointGroupsDetachEndpointsRequest struct {
	// NetworkEndpoints: The list of network endpoints to be detached.
	NetworkEndpoints []*NetworkEndpoint `json:"networkEndpoints,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NetworkEndpoints") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NetworkEndpoints") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GlobalNetworkEndpointGroupsDetachEndpointsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GlobalNetworkEndpointGroupsDetachEndpointsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GlobalOrganizationSetPolicyRequest struct {
	// Bindings: Flatten Policy to create a backward compatible wire-format.
	// Deprecated. Use 'policy' to specify bindings.
	Bindings []*Binding `json:"bindings,omitempty"`

	// Etag: Flatten Policy to create a backward compatible wire-format.
	// Deprecated. Use 'policy' to specify the etag.
	Etag string `json:"etag,omitempty"`

	// Policy: REQUIRED: The complete policy to be applied to the
	// 'resource'. The size of the policy is limited to a few 10s of KB. An
	// empty policy is in general a valid policy but certain services (like
	// Projects) might reject them.
	Policy *Policy `json:"policy,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Bindings") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Bindings") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GlobalOrganizationSetPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GlobalOrganizationSetPolicyRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GlobalSetLabelsRequest struct {
	// LabelFingerprint: The fingerprint of the previous set of labels for
	// this resource, used to detect conflicts. The fingerprint is initially
	// generated by Compute Engine and changes after every request to modify
	// or update labels. You must always provide an up-to-date fingerprint
	// hash when updating or changing labels, otherwise the request will
	// fail with error 412 conditionNotMet. Make a get() request to the
	// resource to get the latest fingerprint.
	LabelFingerprint string `json:"labelFingerprint,omitempty"`

	// Labels: A list of labels to apply for this resource. Each label key &
	// value must comply with RFC1035. Specifically, the name must be 1-63
	// characters long and match the regular expression
	// `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be
	// a lowercase letter, and all following characters must be a dash,
	// lowercase letter, or digit, except the last character, which cannot
	// be a dash. For example, "webserver-frontend": "images". A label value
	// can also be empty (e.g. "my-label": "").
	Labels map[string]string `json:"labels,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LabelFingerprint") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LabelFingerprint") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GlobalSetLabelsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GlobalSetLabelsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GlobalSetPolicyRequest struct {
	// Bindings: Flatten Policy to create a backward compatible wire-format.
	// Deprecated. Use 'policy' to specify bindings.
	Bindings []*Binding `json:"bindings,omitempty"`

	// Etag: Flatten Policy to create a backward compatible wire-format.
	// Deprecated. Use 'policy' to specify the etag.
	Etag string `json:"etag,omitempty"`

	// Policy: REQUIRED: The complete policy to be applied to the
	// 'resource'. The size of the policy is limited to a few 10s of KB. An
	// empty policy is in general a valid policy but certain services (like
	// Projects) might reject them.
	Policy *Policy `json:"policy,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Bindings") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Bindings") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GlobalSetPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GlobalSetPolicyRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GrpcServiceConfig: [Deprecated] gRPC config to access the SDS server.
// gRPC config to access the SDS server.
type GrpcServiceConfig struct {
	// CallCredentials: The call credentials to access the SDS server.
	CallCredentials *CallCredentials `json:"callCredentials,omitempty"`

	// ChannelCredentials: The channel credentials to access the SDS server.
	ChannelCredentials *ChannelCredentials `json:"channelCredentials,omitempty"`

	// TargetUri: The target URI of the SDS server.
	TargetUri string `json:"targetUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CallCredentials") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CallCredentials") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GrpcServiceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GrpcServiceConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GuestAttributes: A guest attributes entry.
type GuestAttributes struct {
	// Kind: [Output Only] Type of the resource. Always
	// compute#guestAttributes for guest attributes entry.
	Kind string `json:"kind,omitempty"`

	// QueryPath: The path to be queried. This can be the default namespace
	// ('/') or a nested namespace ('/\/') or a specified key ('/\/\')
	QueryPath string `json:"queryPath,omitempty"`

	// QueryValue: [Output Only] The value of the requested queried path.
	QueryValue *GuestAttributesValue `json:"queryValue,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// VariableKey: The key to search for.
	VariableKey string `json:"variableKey,omitempty"`

	// VariableValue: [Output Only] The value found for the requested key.
	VariableValue string `json:"variableValue,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Kind") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Kind") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GuestAttributes) MarshalJSON() ([]byte, error) {
	type NoMethod GuestAttributes
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GuestAttributesEntry: A guest attributes namespace/key/value entry.
type GuestAttributesEntry struct {
	// Key: Key for the guest attribute entry.
	Key string `json:"key,omitempty"`

	// Namespace: Namespace for the guest attribute entry.
	Namespace string `json:"namespace,omitempty"`

	// Value: Value for the guest attribute entry.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GuestAttributesEntry) MarshalJSON() ([]byte, error) {
	type NoMethod GuestAttributesEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GuestAttributesValue: Array of guest attribute namespace/key/value
// tuples.
type GuestAttributesValue struct {
	Items []*GuestAttributesEntry `json:"items,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Items") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GuestAttributesValue) MarshalJSON() ([]byte, error) {
	type NoMethod GuestAttributesValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GuestOsFeature: Guest OS features.
type GuestOsFeature struct {
	// Type: The ID of a supported feature. Read  Enabling guest operating
	// system features to see a list of available options.
	//
	// Possible values:
	//   "BARE_METAL_LINUX_COMPATIBLE"
	//   "FEATURE_TYPE_UNSPECIFIED"
	//   "GVNIC"
	//   "MULTI_IP_SUBNET"
	//   "SECURE_BOOT"
	//   "SEV_CAPABLE"
	//   "UEFI_COMPATIBLE"
	//   "VIRTIO_SCSI_MULTIQUEUE"
	//   "WINDOWS"
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Type") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Type") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GuestOsFeature) MarshalJSON() ([]byte, error) {
	type NoMethod GuestOsFeature
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HTTP2HealthCheck struct {
	// Host: The value of the host header in the HTTP/2 health check
	// request. If left empty (default value), the IP on behalf of which
	// this health check is performed will be used.
	Host string `json:"host,omitempty"`

	// Port: The TCP port number for the health check request. The default
	// value is 443. Valid values are 1 through 65535.
	Port int64 `json:"port,omitempty"`

	// PortName: Port name as defined in InstanceGroup#NamedPort#name. If
	// both port and port_name are defined, port takes precedence.
	PortName string `json:"portName,omitempty"`

	// PortSpecification: Specifies how port is selected for health
	// checking, can be one of following values:
	// USE_FIXED_PORT: The port number in port is used for health
	// checking.
	// USE_NAMED_PORT: The portName is used for health
	// checking.
	// USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for
	// each network endpoint is used for health checking. For other
	// backends, the port or named port specified in the Backend Service is
	// used for health checking.
	//
	//
	// If not specified, HTTP2 health check follows behavior specified in
	// port and portName fields.
	//
	// Possible values:
	//   "USE_FIXED_PORT"
	//   "USE_NAMED_PORT"
	//   "USE_SERVING_PORT"
	PortSpecification string `json:"portSpecification,omitempty"`

	// ProxyHeader: Specifies the type of proxy header to append before
	// sending data to the backend, either NONE or PROXY_V1. The default is
	// NONE.
	//
	// Possible values:
	//   "NONE"
	//   "PROXY_V1"
	ProxyHeader string `json:"proxyHeader,omitempty"`

	// RequestPath: The request path of the HTTP/2 health check request. The
	// default value is /.
	RequestPath string `json:"requestPath,omitempty"`

	// Response: The string to match anywhere in the first 1024 bytes of the
	// response body. If left empty (the default value), the status code
	// determines health. The response data can only be ASCII.
	Response string `json:"response,omitempty"`

	// WeightReportMode: Weight report mode. used for weighted Load
	// Balancing.
	//
	// Possible values:
	//   "DISABLE"
	//   "DRY_RUN"
	//   "ENABLE"
	WeightReportMode string `json:"weightReportMode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Host") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Host") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HTTP2HealthCheck) MarshalJSON() ([]byte, error) {
	type NoMethod HTTP2HealthCheck
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HTTPHealthCheck struct {
	// Host: The value of the host header in the HTTP health check request.
	// If left empty (default value), the IP on behalf of which this health
	// check is performed will be used.
	Host string `json:"host,omitempty"`

	// Port: The TCP port number for the health check request. The default
	// value is 80. Valid values are 1 through 65535.
	Port int64 `json:"port,omitempty"`

	// PortName: Port name as defined in InstanceGroup#NamedPort#name. If
	// both port and port_name are defined, port takes precedence.
	PortName string `json:"portName,omitempty"`

	// PortSpecification: Specifies how port is selected for health
	// checking, can be one of following values:
	// USE_FIXED_PORT: The port number in port is used for health
	// checking.
	// USE_NAMED_PORT: The portName is used for health
	// checking.
	// USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for
	// each network endpoint is used for health checking. For other
	// backends, the port or named port specified in the Backend Service is
	// used for health checking.
	//
	//
	// If not specified, HTTP health check follows behavior specified in
	// port and portName fields.
	//
	// Possible values:
	//   "USE_FIXED_PORT"
	//   "USE_NAMED_PORT"
	//   "USE_SERVING_PORT"
	PortSpecification string `json:"portSpecification,omitempty"`

	// ProxyHeader: Specifies the type of proxy header to append before
	// sending data to the backend, either NONE or PROXY_V1. The default is
	// NONE.
	//
	// Possible values:
	//   "NONE"
	//   "PROXY_V1"
	ProxyHeader string `json:"proxyHeader,omitempty"`

	// RequestPath: The request path of the HTTP health check request. The
	// default value is /.
	RequestPath string `json:"requestPath,omitempty"`

	// Response: The string to match anywhere in the first 1024 bytes of the
	// response body. If left empty (the default value), the status code
	// determines health. The response data can only be ASCII.
	Response string `json:"response,omitempty"`

	// WeightReportMode: Weight report mode. used for weighted Load
	// Balancing.
	//
	// Possible values:
	//   "DISABLE"
	//   "DRY_RUN"
	//   "ENABLE"
	WeightReportMode string `json:"weightReportMode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Host") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Host") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HTTPHealthCheck) MarshalJSON() ([]byte, error) {
	type NoMethod HTTPHealthCheck
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HTTPSHealthCheck struct {
	// Host: The value of the host header in the HTTPS health check request.
	// If left empty (default value), the IP on behalf of which this health
	// check is performed will be used.
	Host string `json:"host,omitempty"`

	// Port: The TCP port number for the health check request. The default
	// value is 443. Valid values are 1 through 65535.
	Port int64 `json:"port,omitempty"`

	// PortName: Port name as defined in InstanceGroup#NamedPort#name. If
	// both port and port_name are defined, port takes precedence.
	PortName string `json:"portName,omitempty"`

	// PortSpecification: Specifies how port is selected for health
	// checking, can be one of following values:
	// USE_FIXED_PORT: The port number in port is used for health
	// checking.
	// USE_NAMED_PORT: The portName is used for health
	// checking.
	// USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for
	// each network endpoint is used for health checking. For other
	// backends, the port or named port specified in the Backend Service is
	// used for health checking.
	//
	//
	// If not specified, HTTPS health check follows behavior specified in
	// port and portName fields.
	//
	// Possible values:
	//   "USE_FIXED_PORT"
	//   "USE_NAMED_PORT"
	//   "USE_SERVING_PORT"
	PortSpecification string `json:"portSpecification,omitempty"`

	// ProxyHeader: Specifies the type of proxy header to append before
	// sending data to the backend, either NONE or PROXY_V1. The default is
	// NONE.
	//
	// Possible values:
	//   "NONE"
	//   "PROXY_V1"
	ProxyHeader string `json:"proxyHeader,omitempty"`

	// RequestPath: The request path of the HTTPS health check request. The
	// default value is /.
	RequestPath string `json:"requestPath,omitempty"`

	// Response: The string to match anywhere in the first 1024 bytes of the
	// response body. If left empty (the default value), the status code
	// determines health. The response data can only be ASCII.
	Response string `json:"response,omitempty"`

	// WeightReportMode: Weight report mode. used for weighted Load
	// Balancing.
	//
	// Possible values:
	//   "DISABLE"
	//   "DRY_RUN"
	//   "ENABLE"
	WeightReportMode string `json:"weightReportMode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Host") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Host") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HTTPSHealthCheck) MarshalJSON() ([]byte, error) {
	type NoMethod HTTPSHealthCheck
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HealthCheck: Represents a Health Check resource.
//
// Google Compute Engine has two Health Check resources:
//
// * Global (/compute/docs/reference/rest/{$api_version}/healthChecks) *
// Regional
// (/compute/docs/reference/rest/{$api_version}/regionHealthChecks)
//
// Internal HTTP(S) load balancers must use regional health checks
// (`compute.v1.regionHealthChecks`).
//
// Traffic Director must use global health checks
// (`compute.v1.HealthChecks`).
//
// Internal TCP/UDP load balancers can use either regional or global
// health checks (`compute.v1.regionHealthChecks` or
// `compute.v1.HealthChecks`).
//
// External HTTP(S), TCP proxy, and SSL proxy load balancers as well as
// managed instance group auto-healing must use global health checks
// (`compute.v1.HealthChecks`).
//
// Network load balancers must use legacy HTTP health checks
// (httpHealthChecks).
//
// For more information, see Health checks overview.
type HealthCheck struct {
	// CheckIntervalSec: How often (in seconds) to send a health check. The
	// default value is 5 seconds.
	CheckIntervalSec int64 `json:"checkIntervalSec,omitempty"`

	// CreationTimestamp: [Output Only] Creation timestamp in 3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	GrpcHealthCheck *GRPCHealthCheck `json:"grpcHealthCheck,omitempty"`

	// HealthyThreshold: A so-far unhealthy instance will be marked healthy
	// after this many consecutive successes. The default value is 2.
	HealthyThreshold int64 `json:"healthyThreshold,omitempty"`

	Http2HealthCheck *HTTP2HealthCheck `json:"http2HealthCheck,omitempty"`

	HttpHealthCheck *HTTPHealthCheck `json:"httpHealthCheck,omitempty"`

	HttpsHealthCheck *HTTPSHealthCheck `json:"httpsHealthCheck,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// Kind: Type of the resource.
	Kind string `json:"kind,omitempty"`

	// LogConfig: Configure logging on this health check.
	LogConfig *HealthCheckLogConfig `json:"logConfig,omitempty"`

	// Name: Name of the resource. Provided by the client when the resource
	// is created. The name must be 1-63 characters long, and comply with
	// RFC1035. For example, a name that is 1-63 characters long, matches
	// the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`, and otherwise
	// complies with RFC1035. This regular expression describes a name where
	// the first character is a lowercase letter, and all following
	// characters are a dash, lowercase letter, or digit, except the last
	// character, which isn't a dash.
	Name string `json:"name,omitempty"`

	// Region: [Output Only] Region where the health check resides. Not
	// applicable to global health checks.
	Region string `json:"region,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	SslHealthCheck *SSLHealthCheck `json:"sslHealthCheck,omitempty"`

	TcpHealthCheck *TCPHealthCheck `json:"tcpHealthCheck,omitempty"`

	// TimeoutSec: How long (in seconds) to wait before claiming failure.
	// The default value is 5 seconds. It is invalid for timeoutSec to have
	// greater value than checkIntervalSec.
	TimeoutSec int64 `json:"timeoutSec,omitempty"`

	// Type: Specifies the type of the healthCheck, either TCP, SSL, HTTP,
	// HTTPS or HTTP2. If not specified, the default is TCP. Exactly one of
	// the protocol-specific health check field must be specified, which
	// must match type field.
	//
	// Possible values:
	//   "GRPC"
	//   "HTTP"
	//   "HTTP2"
	//   "HTTPS"
	//   "INVALID"
	//   "SSL"
	//   "TCP"
	//   "UDP"
	Type string `json:"type,omitempty"`

	UdpHealthCheck *UDPHealthCheck `json:"udpHealthCheck,omitempty"`

	// UnhealthyThreshold: A so-far healthy instance will be marked
	// unhealthy after this many consecutive failures. The default value is
	// 2.
	UnhealthyThreshold int64 `json:"unhealthyThreshold,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CheckIntervalSec") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CheckIntervalSec") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheck) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheck
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HealthCheckList: Contains a list of HealthCheck resources.
type HealthCheckList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of HealthCheck resources.
	Items []*HealthCheck `json:"items,omitempty"`

	// Kind: Type of resource.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *HealthCheckListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckList) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HealthCheckListWarning: [Output Only] Informational warning message.
type HealthCheckListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*HealthCheckListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HealthCheckListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HealthCheckLogConfig: Configuration of logging on a health check. If
// logging is enabled, logs will be exported to Stackdriver.
type HealthCheckLogConfig struct {
	// Enable: Indicates whether or not to export logs. This is false by
	// default, which means no health check logging will be done.
	Enable bool `json:"enable,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enable") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enable") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckLogConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HealthCheckReference: A full or valid partial URL to a health check.
// For example, the following are valid URLs:
// -
// https://www.googleapis.com/compute/beta/projects/project-id/global/httpHealthChecks/health-check
//
// - projects/project-id/global/httpHealthChecks/health-check
// - global/httpHealthChecks/health-check
type HealthCheckReference struct {
	HealthCheck string `json:"healthCheck,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HealthCheck") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HealthCheck") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckReference) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckReference
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HealthCheckService: Represents a Health-Check as a Service
// resource.
//
// (== resource_for {$api_version}.regionHealthCheckServices ==)
type HealthCheckService struct {
	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// Fingerprint: Fingerprint of this resource. A hash of the contents
	// stored in this object. This field is used in optimistic locking. This
	// field will be ignored when inserting a HealthCheckService. An
	// up-to-date fingerprint must be provided in order to patch/update the
	// HealthCheckService; Otherwise, the request will fail with error 412
	// conditionNotMet. To see the latest fingerprint, make a get() request
	// to retrieve the HealthCheckService.
	Fingerprint string `json:"fingerprint,omitempty"`

	// HealthChecks: List of URLs to the HealthCheck resources. Must have at
	// least one HealthCheck, and not more than 10. HealthCheck resources
	// must have portSpecification=USE_SERVING_PORT. For regional
	// HealthCheckService, the HealthCheck must be regional and in the same
	// region. For global HealthCheckService, HealthCheck must be global.
	// Mix of regional and global HealthChecks is not supported. Multiple
	// regional HealthChecks must belong to the same region. Regional
	// HealthChecks</code? must belong to the same region as zones of NEGs.
	HealthChecks []string `json:"healthChecks,omitempty"`

	// HealthStatusAggregationPolicy: Optional. Policy for how the results
	// from multiple health checks for the same endpoint are aggregated.
	// Defaults to NO_AGGREGATION if unspecified.
	// - NO_AGGREGATION. An EndpointHealth message is returned for each
	// backend in the health check service.
	// - AND. If any backend's health check reports UNHEALTHY, then
	// UNHEALTHY is the HealthState of the entire health check service. If
	// all backend's are healthy, the HealthState of the health check
	// service is HEALTHY. .
	//
	// Possible values:
	//   "AND"
	//   "NO_AGGREGATION"
	HealthStatusAggregationPolicy string `json:"healthStatusAggregationPolicy,omitempty"`

	// HealthStatusAggregationStrategy: This field is deprecated. Use
	// health_status_aggregation_policy instead.
	//
	// Policy for how the results from multiple health checks for the same
	// endpoint are aggregated.
	// - NO_AGGREGATION. An EndpointHealth message is returned for each
	// backend in the health check service.
	// - AND. If any backend's health check reports UNHEALTHY, then
	// UNHEALTHY is the HealthState of the entire health check service. If
	// all backend's are healthy, the HealthState of the health check
	// service is HEALTHY. .
	//
	// Possible values:
	//   "AND"
	//   "NO_AGGREGATION"
	HealthStatusAggregationStrategy string `json:"healthStatusAggregationStrategy,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// Kind: [Output only] Type of the resource. Always
	// compute#healthCheckServicefor health check services.
	Kind string `json:"kind,omitempty"`

	// Name: Name of the resource. The name must be 1-63 characters long,
	// and comply with RFC1035. Specifically, the name must be 1-63
	// characters long and match the regular expression
	// `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be
	// a lowercase letter, and all following characters must be a dash,
	// lowercase letter, or digit, except the last character, which cannot
	// be a dash.
	Name string `json:"name,omitempty"`

	// NetworkEndpointGroups: List of URLs to the NetworkEndpointGroup
	// resources. Must not have more than 100. For regional
	// HealthCheckService, NEGs must be in zones in the region of the
	// HealthCheckService.
	NetworkEndpointGroups []string `json:"networkEndpointGroups,omitempty"`

	// NotificationEndpoints: List of URLs to the NotificationEndpoint
	// resources. Must not have more than 10. A list of endpoints for
	// receiving notifications of change in health status. For regional
	// HealthCheckService, NotificationEndpoint must be regional and in the
	// same region. For global HealthCheckService, NotificationEndpoint must
	// be global.
	NotificationEndpoints []string `json:"notificationEndpoints,omitempty"`

	// Region: [Output Only] URL of the region where the health check
	// service resides. This field is not applicable to global health check
	// services. You must specify this field as part of the HTTP request
	// URL. It is not settable as a field in the request body.
	Region string `json:"region,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL with id for the
	// resource.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreationTimestamp")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreationTimestamp") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckService) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckService
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HealthCheckServiceAggregatedList: Contains a list of
// HealthCheckServicesScopedList.
type HealthCheckServiceAggregatedList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of HealthCheckServicesScopedList resources.
	Items map[string]HealthCheckServicesScopedList `json:"items,omitempty"`

	// Kind: Type of resource.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Unreachables: [Output Only] Unreachable resources.
	Unreachables []string `json:"unreachables,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *HealthCheckServiceAggregatedListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckServiceAggregatedList) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckServiceAggregatedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HealthCheckServiceAggregatedListWarning: [Output Only] Informational
// warning message.
type HealthCheckServiceAggregatedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*HealthCheckServiceAggregatedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckServiceAggregatedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckServiceAggregatedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HealthCheckServiceAggregatedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckServiceAggregatedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckServiceAggregatedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HealthCheckServiceReference: A full or valid partial URL to a health
// check service. For example, the following are valid URLs:
// -
// https://www.googleapis.com/compute/beta/projects/project-id/regions/us-west1/healthCheckServices/health-check-service
//
// -
// projects/project-id/regions/us-west1/healthCheckServices/health-check-
// service
// - regions/us-west1/healthCheckServices/health-check-service
type HealthCheckServiceReference struct {
	HealthCheckService string `json:"healthCheckService,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HealthCheckService")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HealthCheckService") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckServiceReference) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckServiceReference
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HealthCheckServicesList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of HealthCheckService resources.
	Items []*HealthCheckService `json:"items,omitempty"`

	// Kind: [Output Only] Type of the resource. Always
	// compute#healthCheckServicesList for lists of HealthCheckServices.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *HealthCheckServicesListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckServicesList) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckServicesList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HealthCheckServicesListWarning: [Output Only] Informational warning
// message.
type HealthCheckServicesListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*HealthCheckServicesListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckServicesListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckServicesListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HealthCheckServicesListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckServicesListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckServicesListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HealthCheckServicesScopedList struct {
	// Resources: A list of HealthCheckServices contained in this scope.
	Resources []*HealthCheckService `json:"resources,omitempty"`

	// Warning: Informational warning which replaces the list of backend
	// services when the list is empty.
	Warning *HealthCheckServicesScopedListWarning `json:"warning,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Resources") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Resources") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckServicesScopedList) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckServicesScopedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HealthCheckServicesScopedListWarning: Informational warning which
// replaces the list of backend services when the list is empty.
type HealthCheckServicesScopedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*HealthCheckServicesScopedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckServicesScopedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckServicesScopedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HealthCheckServicesScopedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthCheckServicesScopedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod HealthCheckServicesScopedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HealthChecksAggregatedList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of HealthChecksScopedList resources.
	Items map[string]HealthChecksScopedList `json:"items,omitempty"`

	// Kind: Type of resource.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Unreachables: [Output Only] Unreachable resources.
	Unreachables []string `json:"unreachables,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *HealthChecksAggregatedListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthChecksAggregatedList) MarshalJSON() ([]byte, error) {
	type NoMethod HealthChecksAggregatedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HealthChecksAggregatedListWarning: [Output Only] Informational
// warning message.
type HealthChecksAggregatedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*HealthChecksAggregatedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthChecksAggregatedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod HealthChecksAggregatedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HealthChecksAggregatedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthChecksAggregatedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod HealthChecksAggregatedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HealthChecksScopedList struct {
	// HealthChecks: A list of HealthChecks contained in this scope.
	HealthChecks []*HealthCheck `json:"healthChecks,omitempty"`

	// Warning: Informational warning which replaces the list of backend
	// services when the list is empty.
	Warning *HealthChecksScopedListWarning `json:"warning,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HealthChecks") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HealthChecks") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthChecksScopedList) MarshalJSON() ([]byte, error) {
	type NoMethod HealthChecksScopedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HealthChecksScopedListWarning: Informational warning which replaces
// the list of backend services when the list is empty.
type HealthChecksScopedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*HealthChecksScopedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthChecksScopedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod HealthChecksScopedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HealthChecksScopedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthChecksScopedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod HealthChecksScopedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HealthStatus struct {
	// Annotations: Metadata defined as annotations for network endpoint.
	Annotations map[string]string `json:"annotations,omitempty"`

	// ForwardingRule: URL of the forwarding rule associated with the health
	// status of the instance.
	ForwardingRule string `json:"forwardingRule,omitempty"`

	// ForwardingRuleIp: A forwarding rule IP address assigned to this
	// instance.
	ForwardingRuleIp string `json:"forwardingRuleIp,omitempty"`

	// HealthState: Health state of the instance.
	//
	// Possible values:
	//   "HEALTHY"
	//   "UNHEALTHY"
	HealthState string `json:"healthState,omitempty"`

	// Instance: URL of the instance resource.
	Instance string `json:"instance,omitempty"`

	// IpAddress: For target pool based Network Load Balancing, it indicates
	// the forwarding rule's IP address assigned to this instance. For other
	// types of load balancing, the field indicates VM internal ip.
	IpAddress string `json:"ipAddress,omitempty"`

	// Port: The named port of the instance group, not necessarily the port
	// that is health-checked.
	Port int64 `json:"port,omitempty"`

	Weight string `json:"weight,omitempty"`

	// Possible values:
	//   "INVALID_WEIGHT"
	//   "MISSING_WEIGHT"
	//   "UNAVAILABLE_WEIGHT"
	//   "WEIGHT_NONE"
	WeightError string `json:"weightError,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Annotations") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HealthStatus) MarshalJSON() ([]byte, error) {
	type NoMethod HealthStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HealthStatusForNetworkEndpoint struct {
	// BackendService: URL of the backend service associated with the health
	// state of the network endpoint.
	BackendService *BackendServiceReference `json:"backendService,omitempty"`

	// ForwardingRule: URL of the forwarding rule associated with the health
	// state of the network endpoint.
	ForwardingRule *ForwardingRuleReference `json:"forwardingRule,omitempty"`

	// HealthCheck: URL of the health check associated with the health state
	// of the network endpoint.
	HealthCheck *HealthCheckReference `json:"healthCheck,omitempty"`

	// HealthCheckService: URL of the health check service associated with
	// the health state of the network endpoint.
	HealthCheckService *HealthCheckServiceReference `json:"healthCheckService,omitempty"`

	// HealthState: Health state of the network endpoint determined based on
	// the health checks configured.
	//
	// Possible values:
	//   "DRAINING"
	//   "HEALTHY"
	//   "UNHEALTHY"
	//   "UNKNOWN"
	HealthState string `json:"healthState,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BackendService") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BackendService") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *HealthStatusForNetworkEndpoint) MarshalJSON() ([]byte, error) {
	type NoMethod HealthStatusForNetworkEndpoint
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HostRule: UrlMaps A host-matching rule for a URL. If matched, will
// use the named PathMatcher to select the BackendService.
type HostRule struct {
	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// Hosts: The list of host patterns to match. They must be valid
	// hostnames with optional port numbers in the format host:port. *
	// matches any string of ([a-z0-9-.]*). In that case, * must be the
	// first character and must be followed in the pattern by either - or
	// ..
	// * based matching is not supported when the URL map is bound to target
	// gRPC proxy that has validateForProxyless field set to true.
	Hosts []string `json:"hosts,omitempty"`

	// PathMatcher: The name of the PathMatcher to use to match the path
	// portion of the URL if the hostRule matches the URL's host portion.
	PathMatcher string `json:"pathMatcher,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HostRule) MarshalJSON() ([]byte, error) {
	type NoMethod HostRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpFaultAbort: Specification for how requests are aborted as part of
// fault injection.
type HttpFaultAbort struct {
	// HttpStatus: The HTTP status code used to abort the request.
	// The value must be between 200 and 599 inclusive.
	HttpStatus int64 `json:"httpStatus,omitempty"`

	// Percentage: The percentage of traffic
	// (connections/operations/requests) which will be aborted as part of
	// fault injection.
	// The value must be between 0.0 and 100.0 inclusive.
	Percentage float64 `json:"percentage,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HttpStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HttpStatus") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpFaultAbort) MarshalJSON() ([]byte, error) {
	type NoMethod HttpFaultAbort
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *HttpFaultAbort) UnmarshalJSON(data []byte) error {
	type NoMethod HttpFaultAbort
	var s1 struct {
		Percentage gensupport.JSONFloat64 `json:"percentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Percentage = float64(s1.Percentage)
	return nil
}

// HttpFaultDelay: Specifies the delay introduced by Loadbalancer before
// forwarding the request to the backend service as part of fault
// injection.
type HttpFaultDelay struct {
	// FixedDelay: Specifies the value of the fixed delay interval.
	FixedDelay *Duration `json:"fixedDelay,omitempty"`

	// Percentage: The percentage of traffic
	// (connections/operations/requests) on which delay will be introduced
	// as part of fault injection.
	// The value must be between 0.0 and 100.0 inclusive.
	Percentage float64 `json:"percentage,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FixedDelay") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FixedDelay") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpFaultDelay) MarshalJSON() ([]byte, error) {
	type NoMethod HttpFaultDelay
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *HttpFaultDelay) UnmarshalJSON(data []byte) error {
	type NoMethod HttpFaultDelay
	var s1 struct {
		Percentage gensupport.JSONFloat64 `json:"percentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Percentage = float64(s1.Percentage)
	return nil
}

// HttpFaultInjection: The specification for fault injection introduced
// into traffic to test the resiliency of clients to backend service
// failure. As part of fault injection, when clients send requests to a
// backend service, delays can be introduced by Loadbalancer on a
// percentage of requests before sending those request to the backend
// service. Similarly requests from clients can be aborted by the
// Loadbalancer for a percentage of requests.
type HttpFaultInjection struct {
	// Abort: The specification for how client requests are aborted as part
	// of fault injection.
	Abort *HttpFaultAbort `json:"abort,omitempty"`

	// Delay: The specification for how client requests are delayed as part
	// of fault injection, before being sent to a backend service.
	Delay *HttpFaultDelay `json:"delay,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Abort") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Abort") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpFaultInjection) MarshalJSON() ([]byte, error) {
	type NoMethod HttpFaultInjection
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpFilterConfig: HttpFilterConfiguration supplies additional
// contextual settings for networkservices.HttpFilter resources enabled
// by Traffic Director.
type HttpFilterConfig struct {
	// Config: The configuration needed to enable the
	// networkservices.HttpFilter resource. The configuration must be YAML
	// formatted and only contain fields defined in the protobuf identified
	// in configTypeUrl
	Config string `json:"config,omitempty"`

	// ConfigTypeUrl: The fully qualified versioned proto3 type url of the
	// protobuf that the filter expects for its contextual settings, for
	// example: type.googleapis.com/google.protobuf.Struct
	ConfigTypeUrl string `json:"configTypeUrl,omitempty"`

	// FilterName: Name of the networkservices.HttpFilter resource this
	// configuration belongs to. This name must be known to the xDS client.
	// Example: envoy.wasm
	FilterName string `json:"filterName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Config") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpFilterConfig) MarshalJSON() ([]byte, error) {
	type NoMethod HttpFilterConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpHeaderAction: The request and response header transformations
// that take effect before the request is passed along to the selected
// backendService.
type HttpHeaderAction struct {
	// RequestHeadersToAdd: Headers to add to a matching request prior to
	// forwarding the request to the backendService.
	RequestHeadersToAdd []*HttpHeaderOption `json:"requestHeadersToAdd,omitempty"`

	// RequestHeadersToRemove: A list of header names for headers that need
	// to be removed from the request prior to forwarding the request to the
	// backendService.
	RequestHeadersToRemove []string `json:"requestHeadersToRemove,omitempty"`

	// ResponseHeadersToAdd: Headers to add the response prior to sending
	// the response back to the client.
	ResponseHeadersToAdd []*HttpHeaderOption `json:"responseHeadersToAdd,omitempty"`

	// ResponseHeadersToRemove: A list of header names for headers that need
	// to be removed from the response prior to sending the response back to
	// the client.
	ResponseHeadersToRemove []string `json:"responseHeadersToRemove,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RequestHeadersToAdd")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RequestHeadersToAdd") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *HttpHeaderAction) MarshalJSON() ([]byte, error) {
	type NoMethod HttpHeaderAction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpHeaderMatch: matchRule criteria for request header matches.
type HttpHeaderMatch struct {
	// ExactMatch: The value should exactly match contents of
	// exactMatch.
	// Only one of exactMatch, prefixMatch, suffixMatch, regexMatch,
	// presentMatch or rangeMatch must be set.
	ExactMatch string `json:"exactMatch,omitempty"`

	// HeaderName: The name of the HTTP header to match.
	// For matching against the HTTP request's authority, use a headerMatch
	// with the header name ":authority".
	// For matching a request's method, use the headerName ":method".
	// When the URL map is bound to target gRPC proxy that has
	// validateForProxyless field set to true, only non-binary
	// user-specified custom metadata and the `content-type` header are
	// supported. The following transport-level headers cannot be used in
	// header matching rules: `:authority`, `:method`, `:path`, `:scheme`,
	// `user-agent`, `accept-encoding`, `content-encoding`,
	// `grpc-accept-encoding`, `grpc-encoding`,
	// `grpc-previous-rpc-attempts`, `grpc-tags-bin`, `grpc-timeout` and
	// `grpc-trace-bin.
	HeaderName string `json:"headerName,omitempty"`

	// InvertMatch: If set to false, the headerMatch is considered a match
	// if the match criteria above are met. If set to true, the headerMatch
	// is considered a match if the match criteria above are NOT met.
	// The default setting is false.
	InvertMatch bool `json:"invertMatch,omitempty"`

	// PrefixMatch: The value of the header must start with the contents of
	// prefixMatch.
	// Only one of exactMatch, prefixMatch, suffixMatch, regexMatch,
	// presentMatch or rangeMatch must be set.
	PrefixMatch string `json:"prefixMatch,omitempty"`

	// PresentMatch: A header with the contents of headerName must exist.
	// The match takes place whether or not the request's header has a
	// value.
	// Only one of exactMatch, prefixMatch, suffixMatch, regexMatch,
	// presentMatch or rangeMatch must be set.
	PresentMatch bool `json:"presentMatch,omitempty"`

	// RangeMatch: The header value must be an integer and its value must be
	// in the range specified in rangeMatch. If the header does not contain
	// an integer, number or is empty, the match fails.
	// For example for a range [-5, 0]
	// - -3 will match.
	// - 0 will not match.
	// - 0.25 will not match.
	// - -3someString will not match.
	// Only one of exactMatch, prefixMatch, suffixMatch, regexMatch,
	// presentMatch or rangeMatch must be set.
	// Note that rangeMatch is not supported for Loadbalancers that have
	// their loadBalancingScheme set to EXTERNAL.
	RangeMatch *Int64RangeMatch `json:"rangeMatch,omitempty"`

	// RegexMatch: The value of the header must match the regular expression
	// specified in regexMatch. For regular expression grammar, please see:
	// github.com/google/re2/wiki/Syntax
	// For matching against a port specified in the HTTP request, use a
	// headerMatch with headerName set to PORT and a regular expression that
	// satisfies the RFC2616 Host header's port specifier.
	// Only one of exactMatch, prefixMatch, suffixMatch, regexMatch,
	// presentMatch or rangeMatch must be set.
	// Note that regexMatch only applies to Loadbalancers that have their
	// loadBalancingScheme set to INTERNAL_SELF_MANAGED.
	RegexMatch string `json:"regexMatch,omitempty"`

	// SuffixMatch: The value of the header must end with the contents of
	// suffixMatch.
	// Only one of exactMatch, prefixMatch, suffixMatch, regexMatch,
	// presentMatch or rangeMatch must be set.
	SuffixMatch string `json:"suffixMatch,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExactMatch") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExactMatch") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpHeaderMatch) MarshalJSON() ([]byte, error) {
	type NoMethod HttpHeaderMatch
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpHeaderOption: Specification determining how headers are added to
// requests or responses.
type HttpHeaderOption struct {
	// HeaderName: The name of the header.
	HeaderName string `json:"headerName,omitempty"`

	// HeaderValue: The value of the header to add.
	HeaderValue string `json:"headerValue,omitempty"`

	// Replace: If false, headerValue is appended to any values that already
	// exist for the header. If true, headerValue is set for the header,
	// discarding any values that were set for that header.
	// The default value is false.
	Replace bool `json:"replace,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HeaderName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HeaderName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpHeaderOption) MarshalJSON() ([]byte, error) {
	type NoMethod HttpHeaderOption
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpHealthCheck: Represents a legacy HTTP Health Check
// resource.
//
// Legacy health checks are required by network load balancers. For more
// information, read Health Check Concepts.
type HttpHealthCheck struct {
	// CheckIntervalSec: How often (in seconds) to send a health check. The
	// default value is 5 seconds.
	CheckIntervalSec int64 `json:"checkIntervalSec,omitempty"`

	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// HealthyThreshold: A so-far unhealthy instance will be marked healthy
	// after this many consecutive successes. The default value is 2.
	HealthyThreshold int64 `json:"healthyThreshold,omitempty"`

	// Host: The value of the host header in the HTTP health check request.
	// If left empty (default value), the public IP on behalf of which this
	// health check is performed will be used.
	Host string `json:"host,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// Kind: [Output Only] Type of the resource. Always
	// compute#httpHealthCheck for HTTP health checks.
	Kind string `json:"kind,omitempty"`

	// Name: Name of the resource. Provided by the client when the resource
	// is created. The name must be 1-63 characters long, and comply with
	// RFC1035. Specifically, the name must be 1-63 characters long and
	// match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means
	// the first character must be a lowercase letter, and all following
	// characters must be a dash, lowercase letter, or digit, except the
	// last character, which cannot be a dash.
	Name string `json:"name,omitempty"`

	// Port: The TCP port number for the HTTP health check request. The
	// default value is 80.
	Port int64 `json:"port,omitempty"`

	// RequestPath: The request path of the HTTP health check request. The
	// default value is /. This field does not support query parameters.
	RequestPath string `json:"requestPath,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// TimeoutSec: How long (in seconds) to wait before claiming failure.
	// The default value is 5 seconds. It is invalid for timeoutSec to have
	// greater value than checkIntervalSec.
	TimeoutSec int64 `json:"timeoutSec,omitempty"`

	// UnhealthyThreshold: A so-far healthy instance will be marked
	// unhealthy after this many consecutive failures. The default value is
	// 2.
	UnhealthyThreshold int64 `json:"unhealthyThreshold,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CheckIntervalSec") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CheckIntervalSec") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *HttpHealthCheck) MarshalJSON() ([]byte, error) {
	type NoMethod HttpHealthCheck
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpHealthCheckList: Contains a list of HttpHealthCheck resources.
type HttpHealthCheckList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of HttpHealthCheck resources.
	Items []*HttpHealthCheck `json:"items,omitempty"`

	// Kind: Type of resource.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *HttpHealthCheckListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpHealthCheckList) MarshalJSON() ([]byte, error) {
	type NoMethod HttpHealthCheckList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpHealthCheckListWarning: [Output Only] Informational warning
// message.
type HttpHealthCheckListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*HttpHealthCheckListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpHealthCheckListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod HttpHealthCheckListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HttpHealthCheckListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpHealthCheckListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod HttpHealthCheckListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpQueryParameterMatch: HttpRouteRuleMatch criteria for a request's
// query parameter.
type HttpQueryParameterMatch struct {
	// ExactMatch: The queryParameterMatch matches if the value of the
	// parameter exactly matches the contents of exactMatch.
	// Only one of presentMatch, exactMatch or regexMatch must be set.
	ExactMatch string `json:"exactMatch,omitempty"`

	// Name: The name of the query parameter to match. The query parameter
	// must exist in the request, in the absence of which the request match
	// fails.
	Name string `json:"name,omitempty"`

	// PresentMatch: Specifies that the queryParameterMatch matches if the
	// request contains the query parameter, irrespective of whether the
	// parameter has a value or not.
	// Only one of presentMatch, exactMatch or regexMatch must be set.
	PresentMatch bool `json:"presentMatch,omitempty"`

	// RegexMatch: The queryParameterMatch matches if the value of the
	// parameter matches the regular expression specified by regexMatch. For
	// the regular expression grammar, please see
	// github.com/google/re2/wiki/Syntax
	// Only one of presentMatch, exactMatch or regexMatch must be set.
	// Note that regexMatch only applies when the loadBalancingScheme is set
	// to INTERNAL_SELF_MANAGED.
	RegexMatch string `json:"regexMatch,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExactMatch") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExactMatch") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpQueryParameterMatch) MarshalJSON() ([]byte, error) {
	type NoMethod HttpQueryParameterMatch
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpRedirectAction: Specifies settings for an HTTP redirect.
type HttpRedirectAction struct {
	// HostRedirect: The host that will be used in the redirect response
	// instead of the one that was supplied in the request.
	// The value must be between 1 and 255 characters.
	HostRedirect string `json:"hostRedirect,omitempty"`

	// HttpsRedirect: If set to true, the URL scheme in the redirected
	// request is set to https. If set to false, the URL scheme of the
	// redirected request will remain the same as that of the request.
	// This must only be set for UrlMaps used in TargetHttpProxys. Setting
	// this true for TargetHttpsProxy is not permitted.
	// The default is set to false.
	HttpsRedirect bool `json:"httpsRedirect,omitempty"`

	// PathRedirect: The path that will be used in the redirect response
	// instead of the one that was supplied in the request.
	// pathRedirect cannot be supplied together with prefixRedirect. Supply
	// one alone or neither. If neither is supplied, the path of the
	// original request will be used for the redirect.
	// The value must be between 1 and 1024 characters.
	PathRedirect string `json:"pathRedirect,omitempty"`

	// PrefixRedirect: The prefix that replaces the prefixMatch specified in
	// the HttpRouteRuleMatch, retaining the remaining portion of the URL
	// before redirecting the request.
	// prefixRedirect cannot be supplied together with pathRedirect. Supply
	// one alone or neither. If neither is supplied, the path of the
	// original request will be used for the redirect.
	// The value must be between 1 and 1024 characters.
	PrefixRedirect string `json:"prefixRedirect,omitempty"`

	// RedirectResponseCode: The HTTP Status code to use for this
	// RedirectAction.
	// Supported values are:
	// - MOVED_PERMANENTLY_DEFAULT, which is the default value and
	// corresponds to 301.
	// - FOUND, which corresponds to 302.
	// - SEE_OTHER which corresponds to 303.
	// - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the
	// request method will be retained.
	// - PERMANENT_REDIRECT, which corresponds to 308. In this case, the
	// request method will be retained.
	//
	// Possible values:
	//   "FOUND"
	//   "MOVED_PERMANENTLY_DEFAULT"
	//   "PERMANENT_REDIRECT"
	//   "SEE_OTHER"
	//   "TEMPORARY_REDIRECT"
	RedirectResponseCode string `json:"redirectResponseCode,omitempty"`

	// StripQuery: If set to true, any accompanying query portion of the
	// original URL is removed prior to redirecting the request. If set to
	// false, the query portion of the original URL is retained.
	// The default is set to false.
	StripQuery bool `json:"stripQuery,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HostRedirect") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HostRedirect") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpRedirectAction) MarshalJSON() ([]byte, error) {
	type NoMethod HttpRedirectAction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpRetryPolicy: The retry policy associates with HttpRouteRule
type HttpRetryPolicy struct {
	// NumRetries: Specifies the allowed number retries. This number must be
	// > 0. If not specified, defaults to 1.
	NumRetries int64 `json:"numRetries,omitempty"`

	// PerTryTimeout: Specifies a non-zero timeout per retry attempt.
	// If not specified, will use the timeout set in HttpRouteAction. If
	// timeout in HttpRouteAction is not set, will use the largest timeout
	// among all backend services associated with the route.
	PerTryTimeout *Duration `json:"perTryTimeout,omitempty"`

	// RetryConditions: Specfies one or more conditions when this retry rule
	// applies. Valid values are:
	// - 5xx: Loadbalancer will attempt a retry if the backend service
	// responds with any 5xx response code, or if the backend service does
	// not respond at all, example: disconnects, reset, read timeout,
	// connection failure, and refused streams.
	// - gateway-error: Similar to 5xx, but only applies to response codes
	// 502, 503 or 504.
	// -
	// - connect-failure: Loadbalancer will retry on failures connecting to
	// backend services, for example due to connection timeouts.
	// - retriable-4xx: Loadbalancer will retry for retriable 4xx response
	// codes. Currently the only retriable error supported is 409.
	// - refused-stream:Loadbalancer will retry if the backend service
	// resets the stream with a REFUSED_STREAM error code. This reset type
	// indicates that it is safe to retry.
	// - cancelledLoadbalancer will retry if the gRPC status code in the
	// response header is set to cancelled
	// - deadline-exceeded: Loadbalancer will retry if the gRPC status code
	// in the response header is set to deadline-exceeded
	// - resource-exhausted: Loadbalancer will retry if the gRPC status code
	// in the response header is set to resource-exhausted
	// - unavailable: Loadbalancer will retry if the gRPC status code in the
	// response header is set to unavailable
	RetryConditions []string `json:"retryConditions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NumRetries") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NumRetries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpRetryPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod HttpRetryPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HttpRouteAction struct {
	// CorsPolicy: The specification for allowing client side cross-origin
	// requests. Please see W3C Recommendation for Cross Origin Resource
	// Sharing
	// Not supported when the URL map is bound to target gRPC proxy.
	CorsPolicy *CorsPolicy `json:"corsPolicy,omitempty"`

	// FaultInjectionPolicy: The specification for fault injection
	// introduced into traffic to test the resiliency of clients to backend
	// service failure. As part of fault injection, when clients send
	// requests to a backend service, delays can be introduced by
	// Loadbalancer on a percentage of requests before sending those request
	// to the backend service. Similarly requests from clients can be
	// aborted by the Loadbalancer for a percentage of requests.
	// timeout and retry_policy will be ignored by clients that are
	// configured with a fault_injection_policy.
	// Not supported when the URL map is bound to target gRPC proxy that has
	// validateForProxyless field set to true.
	FaultInjectionPolicy *HttpFaultInjection `json:"faultInjectionPolicy,omitempty"`

	// MaxStreamDuration: Specifies the maximum duration (timeout) for
	// streams on the selected route. Unlike the timeout field where the
	// timeout duration starts from the time the request has been fully
	// processed (i.e. end-of-stream), the duration in this field is
	// computed from the beginning of the stream until the response has been
	// completely processed, including all retries. A stream that does not
	// complete in this duration is closed.
	// If not specified, will use the largest maxStreamDuration among all
	// backend services associated with the route.
	// This field is only allowed if the Url map is used with backend
	// services with loadBalancingScheme set to INTERNAL_SELF_MANAGED.
	MaxStreamDuration *Duration `json:"maxStreamDuration,omitempty"`

	// RequestMirrorPolicy: Specifies the policy on how requests intended
	// for the route's backends are shadowed to a separate mirrored backend
	// service. Loadbalancer does not wait for responses from the shadow
	// service. Prior to sending traffic to the shadow service, the host /
	// authority header is suffixed with -shadow.
	// Not supported when the URL map is bound to target gRPC proxy that has
	// validateForProxyless field set to true.
	RequestMirrorPolicy *RequestMirrorPolicy `json:"requestMirrorPolicy,omitempty"`

	// RetryPolicy: Specifies the retry policy associated with this
	// route.
	// Not supported when the URL map is bound to target gRPC proxy that has
	// validateForProxyless field set to true.
	RetryPolicy *HttpRetryPolicy `json:"retryPolicy,omitempty"`

	// Timeout: Specifies the timeout for the selected route. Timeout is
	// computed from the time the request has been fully processed (i.e.
	// end-of-stream) up until the response has been completely processed.
	// Timeout includes all retries.
	// If not specified, will use the largest timeout among all backend
	// services associated with the route.
	// Not supported when the URL map is bound to target gRPC proxy that has
	// validateForProxyless field set to true.
	Timeout *Duration `json:"timeout,omitempty"`

	// UrlRewrite: The spec to modify the URL of the request, prior to
	// forwarding the request to the matched service.
	// urlRewrite is the only action supported in UrlMaps for external
	// HTTP(S) load balancers.
	// Not supported when the URL map is bound to target gRPC proxy that has
	// validateForProxyless field set to true.
	UrlRewrite *UrlRewrite `json:"urlRewrite,omitempty"`

	// WeightedBackendServices: A list of weighted backend services to send
	// traffic to when a route match occurs. The weights determine the
	// fraction of traffic that flows to their corresponding backend
	// service. If all traffic needs to go to a single backend service,
	// there must be one  weightedBackendService with weight set to a
	// non-zero number.
	// Once a backendService is identified and before forwarding the request
	// to the backend service, advanced routing actions such as URL rewrites
	// and header transformations are applied depending on additional
	// settings specified in this HttpRouteAction.
	WeightedBackendServices []*WeightedBackendService `json:"weightedBackendServices,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CorsPolicy") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CorsPolicy") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpRouteAction) MarshalJSON() ([]byte, error) {
	type NoMethod HttpRouteAction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpRouteRule: An HttpRouteRule specifies how to match an HTTP
// request and the corresponding routing action that load balancing
// proxies will perform.
type HttpRouteRule struct {
	// Description: The short description conveying the intent of this
	// routeRule.
	// The description can have a maximum length of 1024 characters.
	Description string `json:"description,omitempty"`

	// HeaderAction: Specifies changes to request and response headers that
	// need to take effect for the selected backendService.
	// The headerAction specified here are applied before the matching
	// pathMatchers[].headerAction and after
	// pathMatchers[].routeRules[].routeAction.weightedBackendService.backend
	// ServiceWeightAction[].headerAction
	// Note that headerAction is not supported for Loadbalancers that have
	// their loadBalancingScheme set to EXTERNAL.
	// Not supported when the URL map is bound to target gRPC proxy that has
	// validateForProxyless field set to true.
	HeaderAction *HttpHeaderAction `json:"headerAction,omitempty"`

	// HttpFilterConfigs: Outbound route specific configuration for
	// networkservices.HttpFilter resources enabled by Traffic Director.
	// httpFilterConfigs only applies for Loadbalancers with
	// loadBalancingScheme set to INTERNAL_SELF_MANAGED. See ForwardingRule
	// for more details.
	// Not supported when the URL map is bound to target gRPC proxy that has
	// validateForProxyless field set to true.
	HttpFilterConfigs []*HttpFilterConfig `json:"httpFilterConfigs,omitempty"`

	// HttpFilterMetadata: Outbound route specific metadata supplied to
	// networkservices.HttpFilter resources enabled by Traffic Director.
	// httpFilterMetadata only applies for Loadbalancers with
	// loadBalancingScheme set to INTERNAL_SELF_MANAGED. See ForwardingRule
	// for more details.
	// The only configTypeUrl supported is
	// type.googleapis.com/google.protobuf.Struct
	// Not supported when the URL map is bound to target gRPC proxy that has
	// validateForProxyless field set to true.
	HttpFilterMetadata []*HttpFilterConfig `json:"httpFilterMetadata,omitempty"`

	// MatchRules: The list of criteria for matching attributes of a request
	// to this routeRule. This list has OR semantics: the request matches
	// this routeRule when any of the matchRules are satisfied. However
	// predicates within a given matchRule have AND semantics. All
	// predicates within a matchRule must match for the request to match the
	// rule.
	MatchRules []*HttpRouteRuleMatch `json:"matchRules,omitempty"`

	// Priority: For routeRules within a given pathMatcher, priority
	// determines the order in which load balancer will interpret
	// routeRules. RouteRules are evaluated in order of priority, from the
	// lowest to highest number. The priority of a rule decreases as its
	// number increases (1, 2, 3, N+1). The first rule that matches the
	// request is applied.
	// You cannot configure two or more routeRules with the same priority.
	// Priority for each rule must be set to a number between 0 and
	// 2147483647 inclusive.
	// Priority numbers can have gaps, which enable you to add or remove
	// rules in the future without affecting the rest of the rules. For
	// example, 1, 2, 3, 4, 5, 9, 12, 16 is a valid series of priority
	// numbers to which you could add rules numbered from 6 to 8, 10 to 11,
	// and 13 to 15 in the future without any impact on existing rules.
	Priority int64 `json:"priority,omitempty"`

	// RouteAction: In response to a matching matchRule, the load balancer
	// performs advanced routing actions like URL rewrites, header
	// transformations, etc. prior to forwarding the request to the selected
	// backend. If  routeAction specifies any  weightedBackendServices,
	// service must not be set. Conversely if service is set, routeAction
	// cannot contain any  weightedBackendServices.
	// Only one of urlRedirect, service or
	// routeAction.weightedBackendService must be set.
	// UrlMaps for external HTTP(S) load balancers support only the
	// urlRewrite action within a routeRule's routeAction.
	RouteAction *HttpRouteAction `json:"routeAction,omitempty"`

	// Service: The full or partial URL of the backend service resource to
	// which traffic is directed if this rule is matched. If routeAction is
	// additionally specified, advanced routing actions like URL Rewrites,
	// etc. take effect prior to sending the request to the backend.
	// However, if service is specified, routeAction cannot contain any
	// weightedBackendService s. Conversely, if routeAction specifies any
	// weightedBackendServices, service must not be specified.
	// Only one of urlRedirect, service or
	// routeAction.weightedBackendService must be set.
	Service string `json:"service,omitempty"`

	// UrlRedirect: When this rule is matched, the request is redirected to
	// a URL specified by urlRedirect.
	// If urlRedirect is specified, service or routeAction must not be
	// set.
	// Not supported when the URL map is bound to target gRPC proxy.
	UrlRedirect *HttpRedirectAction `json:"urlRedirect,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpRouteRule) MarshalJSON() ([]byte, error) {
	type NoMethod HttpRouteRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpRouteRuleMatch: HttpRouteRuleMatch specifies a set of criteria
// for matching requests to an HttpRouteRule. All specified criteria
// must be satisfied for a match to occur.
type HttpRouteRuleMatch struct {
	// FullPathMatch: For satisfying the matchRule condition, the path of
	// the request must exactly match the value specified in fullPathMatch
	// after removing any query parameters and anchor that may be part of
	// the original URL.
	// fullPathMatch must be between 1 and 1024 characters.
	// Only one of prefixMatch, fullPathMatch or regexMatch must be
	// specified.
	FullPathMatch string `json:"fullPathMatch,omitempty"`

	// HeaderMatches: Specifies a list of header match criteria, all of
	// which must match corresponding headers in the request.
	HeaderMatches []*HttpHeaderMatch `json:"headerMatches,omitempty"`

	// IgnoreCase: Specifies that prefixMatch and fullPathMatch matches are
	// case sensitive.
	// The default value is false.
	// ignoreCase must not be used with regexMatch.
	// Not supported when the URL map is bound to target gRPC proxy.
	IgnoreCase bool `json:"ignoreCase,omitempty"`

	// MetadataFilters: Opaque filter criteria used by Loadbalancer to
	// restrict routing configuration to a limited set of xDS compliant
	// clients. In their xDS requests to Loadbalancer, xDS clients present
	// node metadata. When there is a match, the relevant routing
	// configuration is made available to those proxies.
	// For each metadataFilter in this list, if its filterMatchCriteria is
	// set to MATCH_ANY, at least one of the filterLabels must match the
	// corresponding label provided in the metadata. If its
	// filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels
	// must match with corresponding labels provided in the metadata. If
	// multiple metadataFilters are specified, all of them need to be
	// satisfied in order to be considered a match.
	// metadataFilters specified here will be applied after those specified
	// in ForwardingRule that refers to the UrlMap this HttpRouteRuleMatch
	// belongs to.
	// metadataFilters only applies to Loadbalancers that have their
	// loadBalancingScheme set to INTERNAL_SELF_MANAGED.
	// Not supported when the URL map is bound to target gRPC proxy that has
	// validateForProxyless field set to true.
	MetadataFilters []*MetadataFilter `json:"metadataFilters,omitempty"`

	// PrefixMatch: For satisfying the matchRule condition, the request's
	// path must begin with the specified prefixMatch. prefixMatch must
	// begin with a /.
	// The value must be between 1 and 1024 characters.
	// Only one of prefixMatch, fullPathMatch or regexMatch must be
	// specified.
	PrefixMatch string `json:"prefixMatch,omitempty"`

	// QueryParameterMatches: Specifies a list of query parameter match
	// criteria, all of which must match corresponding query parameters in
	// the request.
	// Not supported when the URL map is bound to target gRPC proxy.
	QueryParameterMatches []*HttpQueryParameterMatch `json:"queryParameterMatches,omitempty"`

	// RegexMatch: For satisfying the matchRule condition, the path of the
	// request must satisfy the regular expression specified in regexMatch
	// after removing any query parameters and anchor supplied with the
	// original URL. For regular expression grammar please see
	// github.com/google/re2/wiki/Syntax
	// Only one of prefixMatch, fullPathMatch or regexMatch must be
	// specified.
	// Note that regexMatch only applies to Loadbalancers that have their
	// loadBalancingScheme set to INTERNAL_SELF_MANAGED.
	RegexMatch string `json:"regexMatch,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FullPathMatch") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FullPathMatch") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpRouteRuleMatch) MarshalJSON() ([]byte, error) {
	type NoMethod HttpRouteRuleMatch
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpsHealthCheck: Represents a legacy HTTPS Health Check
// resource.
//
// Legacy health checks are required by network load balancers. For more
// information, read Health Check Concepts.
type HttpsHealthCheck struct {
	// CheckIntervalSec: How often (in seconds) to send a health check. The
	// default value is 5 seconds.
	CheckIntervalSec int64 `json:"checkIntervalSec,omitempty"`

	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// HealthyThreshold: A so-far unhealthy instance will be marked healthy
	// after this many consecutive successes. The default value is 2.
	HealthyThreshold int64 `json:"healthyThreshold,omitempty"`

	// Host: The value of the host header in the HTTPS health check request.
	// If left empty (default value), the public IP on behalf of which this
	// health check is performed will be used.
	Host string `json:"host,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// Kind: Type of the resource.
	Kind string `json:"kind,omitempty"`

	// Name: Name of the resource. Provided by the client when the resource
	// is created. The name must be 1-63 characters long, and comply with
	// RFC1035. Specifically, the name must be 1-63 characters long and
	// match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means
	// the first character must be a lowercase letter, and all following
	// characters must be a dash, lowercase letter, or digit, except the
	// last character, which cannot be a dash.
	Name string `json:"name,omitempty"`

	// Port: The TCP port number for the HTTPS health check request. The
	// default value is 443.
	Port int64 `json:"port,omitempty"`

	// RequestPath: The request path of the HTTPS health check request. The
	// default value is "/".
	RequestPath string `json:"requestPath,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// TimeoutSec: How long (in seconds) to wait before claiming failure.
	// The default value is 5 seconds. It is invalid for timeoutSec to have
	// a greater value than checkIntervalSec.
	TimeoutSec int64 `json:"timeoutSec,omitempty"`

	// UnhealthyThreshold: A so-far healthy instance will be marked
	// unhealthy after this many consecutive failures. The default value is
	// 2.
	UnhealthyThreshold int64 `json:"unhealthyThreshold,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CheckIntervalSec") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CheckIntervalSec") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *HttpsHealthCheck) MarshalJSON() ([]byte, error) {
	type NoMethod HttpsHealthCheck
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpsHealthCheckList: Contains a list of HttpsHealthCheck resources.
type HttpsHealthCheckList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of HttpsHealthCheck resources.
	Items []*HttpsHealthCheck `json:"items,omitempty"`

	// Kind: Type of resource.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *HttpsHealthCheckListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpsHealthCheckList) MarshalJSON() ([]byte, error) {
	type NoMethod HttpsHealthCheckList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HttpsHealthCheckListWarning: [Output Only] Informational warning
// message.
type HttpsHealthCheckListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*HttpsHealthCheckListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpsHealthCheckListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod HttpsHealthCheckListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type HttpsHealthCheckListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HttpsHealthCheckListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod HttpsHealthCheckListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Image: Represents an Image resource.
//
// You can use images to create boot disks for your VM instances. For
// more information, read Images. (== resource_for {$api_version}.images
// ==)
type Image struct {
	// ArchiveSizeBytes: Size of the image tar.gz archive stored in Google
	// Cloud Storage (in bytes).
	ArchiveSizeBytes int64 `json:"archiveSizeBytes,omitempty,string"`

	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Deprecated -- The deprecation status associated with this image.
	Deprecated *DeprecationStatus `json:"deprecated,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// DiskSizeGb: Size of the image when restored onto a persistent disk
	// (in GB).
	DiskSizeGb int64 `json:"diskSizeGb,omitempty,string"`

	// Family: The name of the image family to which this image belongs. You
	// can create disks by specifying an image family instead of a specific
	// image name. The image family always returns its latest image that is
	// not deprecated. The name of the image family must comply with
	// RFC1035.
	Family string `json:"family,omitempty"`

	// GuestOsFeatures: A list of features to enable on the guest operating
	// system. Applicable only for bootable images. Read  Enabling guest
	// operating system features to see a list of available options.
	GuestOsFeatures []*GuestOsFeature `json:"guestOsFeatures,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// ImageEncryptionKey: Encrypts the image using a customer-supplied
	// encryption key.
	//
	// After you encrypt an image with a customer-supplied key, you must
	// provide the same key if you use the image later (e.g. to create a
	// disk from the image).
	//
	// Customer-supplied encryption keys do not protect access to metadata
	// of the disk.
	//
	// If you do not provide an encryption key when creating the image, then
	// the disk will be encrypted using an automatically generated key and
	// you do not need to provide a key to use the image later.
	ImageEncryptionKey *CustomerEncryptionKey `json:"imageEncryptionKey,omitempty"`

	// Kind: [Output Only] Type of the resource. Always compute#image for
	// images.
	Kind string `json:"kind,omitempty"`

	// LabelFingerprint: A fingerprint for the labels being applied to this
	// image, which is essentially a hash of the labels used for optimistic
	// locking. The fingerprint is initially generated by Compute Engine and
	// changes after every request to modify or update labels. You must
	// always provide an up-to-date fingerprint hash in order to update or
	// change labels, otherwise the request will fail with error 412
	// conditionNotMet.
	//
	// To see the latest fingerprint, make a get() request to retrieve an
	// image.
	LabelFingerprint string `json:"labelFingerprint,omitempty"`

	// Labels: Labels to apply to this image. These can be later modified by
	// the setLabels method.
	Labels map[string]string `json:"labels,omitempty"`

	// LicenseCodes: Integer license codes indicating which licenses are
	// attached to this image.
	LicenseCodes googleapi.Int64s `json:"licenseCodes,omitempty"`

	// Licenses: Any applicable license URI.
	Licenses []string `json:"licenses,omitempty"`

	// Name: Name of the resource; provided by the client when the resource
	// is created. The name must be 1-63 characters long, and comply with
	// RFC1035. Specifically, the name must be 1-63 characters long and
	// match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means
	// the first character must be a lowercase letter, and all following
	// characters must be a dash, lowercase letter, or digit, except the
	// last character, which cannot be a dash.
	Name string `json:"name,omitempty"`

	// RawDisk: The parameters of the raw disk image.
	RawDisk *ImageRawDisk `json:"rawDisk,omitempty"`

	// RolloutOverride: A rollout policy to apply to this image. When
	// specified, the rollout policy overrides per-zone references to the
	// image via the associated image family. The rollout policy restricts
	// the zones where this image is accessible when using a zonal image
	// family reference. When the rollout policy does not include the user
	// specified zone, or if the zone is rolled out, this image is
	// accessible.
	RolloutOverride *RolloutPolicy `json:"rolloutOverride,omitempty"`

	// SatisfiesPzs: [Output Only] Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource's
	// resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// ShieldedInstanceInitialState: Set the secure boot keys of shielded
	// instance.
	ShieldedInstanceInitialState *InitialStateConfig `json:"shieldedInstanceInitialState,omitempty"`

	// SourceDisk: URL of the source disk used to create this image. This
	// can be a full or valid partial URL. You must provide either this
	// property or the rawDisk.source property but not both to create an
	// image. For example, the following are valid values:
	// -
	// https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk
	//
	// - projects/project/zones/zone/disks/disk
	// - zones/zone/disks/disk
	SourceDisk string `json:"sourceDisk,omitempty"`

	// SourceDiskEncryptionKey: The customer-supplied encryption key of the
	// source disk. Required if the source disk is protected by a
	// customer-supplied encryption key.
	SourceDiskEncryptionKey *CustomerEncryptionKey `json:"sourceDiskEncryptionKey,omitempty"`

	// SourceDiskId: [Output Only] The ID value of the disk used to create
	// this image. This value may be used to determine whether the image was
	// taken from the current or a previous instance of a given disk name.
	SourceDiskId string `json:"sourceDiskId,omitempty"`

	// SourceImage: URL of the source image used to create this image.
	//
	// In order to create an image, you must provide the full or partial URL
	// of one of the following:
	// - The selfLink URL
	// - This property
	// - The rawDisk.source URL
	// - The sourceDisk URL
	SourceImage string `json:"sourceImage,omitempty"`

	// SourceImageEncryptionKey: The customer-supplied encryption key of the
	// source image. Required if the source image is protected by a
	// customer-supplied encryption key.
	SourceImageEncryptionKey *CustomerEncryptionKey `json:"sourceImageEncryptionKey,omitempty"`

	// SourceImageId: [Output Only] The ID value of the image used to create
	// this image. This value may be used to determine whether the image was
	// taken from the current or a previous instance of a given image name.
	SourceImageId string `json:"sourceImageId,omitempty"`

	// SourceSnapshot: URL of the source snapshot used to create this
	// image.
	//
	// In order to create an image, you must provide the full or partial URL
	// of one of the following:
	// - The selfLink URL
	// - This property
	// - The sourceImage URL
	// - The rawDisk.source URL
	// - The sourceDisk URL
	SourceSnapshot string `json:"sourceSnapshot,omitempty"`

	// SourceSnapshotEncryptionKey: The customer-supplied encryption key of
	// the source snapshot. Required if the source snapshot is protected by
	// a customer-supplied encryption key.
	SourceSnapshotEncryptionKey *CustomerEncryptionKey `json:"sourceSnapshotEncryptionKey,omitempty"`

	// SourceSnapshotId: [Output Only] The ID value of the snapshot used to
	// create this image. This value may be used to determine whether the
	// snapshot was taken from the current or a previous instance of a given
	// snapshot name.
	SourceSnapshotId string `json:"sourceSnapshotId,omitempty"`

	// SourceType: The type of the image used to create this disk. The
	// default and only value is RAW
	//
	// Possible values:
	//   "RAW" (default)
	SourceType string `json:"sourceType,omitempty"`

	// Status: [Output Only] The status of the image. An image can be used
	// to create other resources, such as instances, only after the image
	// has been successfully created and the status is set to READY.
	// Possible values are FAILED, PENDING, or READY.
	//
	// Possible values:
	//   "DELETING"
	//   "FAILED"
	//   "PENDING"
	//   "READY"
	Status string `json:"status,omitempty"`

	// StorageLocations: Cloud Storage bucket storage location of the image
	// (regional or multi-regional).
	StorageLocations []string `json:"storageLocations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ArchiveSizeBytes") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ArchiveSizeBytes") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Image) MarshalJSON() ([]byte, error) {
	type NoMethod Image
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ImageRawDisk: The parameters of the raw disk image.
type ImageRawDisk struct {
	// ContainerType: The format used to encode and transmit the block
	// device, which should be TAR. This is just a container and
	// transmission format and not a runtime format. Provided by the client
	// when the disk image is created.
	//
	// Possible values:
	//   "TAR"
	ContainerType string `json:"containerType,omitempty"`

	// Sha1Checksum: [Deprecated] This field is deprecated. An optional SHA1
	// checksum of the disk image before unpackaging provided by the client
	// when the disk image is created.
	Sha1Checksum string `json:"sha1Checksum,omitempty"`

	// Source: The full Google Cloud Storage URL where the disk image is
	// stored. You must provide either this property or the sourceDisk
	// property but not both.
	Source string `json:"source,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContainerType") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContainerType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ImageRawDisk) MarshalJSON() ([]byte, error) {
	type NoMethod ImageRawDisk
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ImageFamilyView struct {
	// Image: The latest image that is part of the specified image family in
	// the requested location, and that is not deprecated.
	Image *Image `json:"image,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Image") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Image") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ImageFamilyView) MarshalJSON() ([]byte, error) {
	type NoMethod ImageFamilyView
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ImageList: Contains a list of images.
type ImageList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of Image resources.
	Items []*Image `json:"items,omitempty"`

	// Kind: Type of resource.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *ImageListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ImageList) MarshalJSON() ([]byte, error) {
	type NoMethod ImageList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ImageListWarning: [Output Only] Informational warning message.
type ImageListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*ImageListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ImageListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod ImageListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ImageListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ImageListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod ImageListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InPlaceSnapshot: Represents a InPlaceSnapshot resource.
//
// You can use in-place snapshots to create disk rollback points
// quickly.. (== resource_for {$api_version}.inPlaceSnapshots ==)
type InPlaceSnapshot struct {
	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// DiskSizeGb: [Output Only] Size of the source disk, specified in GB.
	DiskSizeGb int64 `json:"diskSizeGb,omitempty,string"`

	// GuestFlush: Specifies to create an application consistent in-place
	// snapshot by informing the OS to prepare for the snapshot process.
	// Currently only supported on Windows instances using the Volume Shadow
	// Copy Service (VSS).
	GuestFlush bool `json:"guestFlush,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// Kind: [Output Only] Type of the resource. Always
	// compute#inPlaceSnapshot for InPlaceSnapshot resources.
	Kind string `json:"kind,omitempty"`

	// LabelFingerprint: A fingerprint for the labels being applied to this
	// InPlaceSnapshot, which is essentially a hash of the labels set used
	// for optimistic locking. The fingerprint is initially generated by
	// Compute Engine and changes after every request to modify or update
	// labels. You must always provide an up-to-date fingerprint hash in
	// order to update or change labels, otherwise the request will fail
	// with error 412 conditionNotMet.
	//
	// To see the latest fingerprint, make a get() request to retrieve a
	// InPlaceSnapshot.
	LabelFingerprint string `json:"labelFingerprint,omitempty"`

	// Labels: Labels to apply to this InPlaceSnapshot. These can be later
	// modified by the setLabels method. Label values may be empty.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Name of the resource; provided by the client when the resource
	// is created. The name must be 1-63 characters long, and comply with
	// RFC1035. Specifically, the name must be 1-63 characters long and
	// match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means
	// the first character must be a lowercase letter, and all following
	// characters must be a dash, lowercase letter, or digit, except the
	// last character, which cannot be a dash.
	Name string `json:"name,omitempty"`

	// Region: [Output Only] URL of the region where the in-place snapshot
	// resides. You must specify this field as part of the HTTP request URL.
	// It is not settable as a field in the request body.
	Region string `json:"region,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource's
	// resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// SourceDisk: URL of the source disk used to create this in-place
	// snapshot. Note that the source disk must be in the same zone/region
	// as the in-place snapshot to be created. This can be a full or valid
	// partial URL. For example, the following are valid values:
	// -
	// https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk
	//
	// - projects/project/zones/zone/disks/disk
	// - zones/zone/disks/disk
	SourceDisk string `json:"sourceDisk,omitempty"`

	// SourceDiskId: [Output Only] The ID value of the disk used to create
	// this InPlaceSnapshot. This value may be used to determine whether the
	// InPlaceSnapshot was taken from the current or a previous instance of
	// a given disk name.
	SourceDiskId string `json:"sourceDiskId,omitempty"`

	// Status: [Output Only] The status of the inPlaceSnapshot. This can be
	// CREATING, DELETING, FAILED, or READY.
	//
	// Possible values:
	//   "CREATING"
	//   "DELETING"
	//   "FAILED"
	//   "READY"
	Status string `json:"status,omitempty"`

	// Zone: [Output Only] URL of the zone where the in-place snapshot
	// resides. You must specify this field as part of the HTTP request URL.
	// It is not settable as a field in the request body.
	Zone string `json:"zone,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreationTimestamp")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreationTimestamp") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InPlaceSnapshot) MarshalJSON() ([]byte, error) {
	type NoMethod InPlaceSnapshot
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InPlaceSnapshotList: Contains a list of InPlaceSnapshot resources.
type InPlaceSnapshotList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of InPlaceSnapshot resources.
	Items []*InPlaceSnapshot `json:"items,omitempty"`

	// Kind: Type of resource.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *InPlaceSnapshotListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InPlaceSnapshotList) MarshalJSON() ([]byte, error) {
	type NoMethod InPlaceSnapshotList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InPlaceSnapshotListWarning: [Output Only] Informational warning
// message.
type InPlaceSnapshotListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*InPlaceSnapshotListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InPlaceSnapshotListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod InPlaceSnapshotListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InPlaceSnapshotListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InPlaceSnapshotListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod InPlaceSnapshotListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InitialStateConfig: Initial State for shielded instance, these are
// public keys which are safe to store in public
type InitialStateConfig struct {
	// Dbs: The Key Database (db).
	Dbs []*FileContentBuffer `json:"dbs,omitempty"`

	// Dbxs: The forbidden key database (dbx).
	Dbxs []*FileContentBuffer `json:"dbxs,omitempty"`

	// Keks: The Key Exchange Key (KEK).
	Keks []*FileContentBuffer `json:"keks,omitempty"`

	// Pk: The Platform Key (PK).
	Pk *FileContentBuffer `json:"pk,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dbs") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dbs") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InitialStateConfig) MarshalJSON() ([]byte, error) {
	type NoMethod InitialStateConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Instance: Represents an Instance resource.
//
// An instance is a virtual machine that is hosted on Google Cloud
// Platform. For more information, read Virtual Machine Instances. (==
// resource_for {$api_version}.instances ==)
type Instance struct {
	// AdvancedMachineFeatures: Controls for advanced machine-related
	// behavior features.
	AdvancedMachineFeatures *AdvancedMachineFeatures `json:"advancedMachineFeatures,omitempty"`

	// CanIpForward: Allows this instance to send and receive packets with
	// non-matching destination or source IPs. This is required if you plan
	// to use this instance to forward routes. For more information, see
	// Enabling IP Forwarding.
	CanIpForward bool `json:"canIpForward,omitempty"`

	ConfidentialInstanceConfig *ConfidentialInstanceConfig `json:"confidentialInstanceConfig,omitempty"`

	// CpuPlatform: [Output Only] The CPU platform used by this instance.
	CpuPlatform string `json:"cpuPlatform,omitempty"`

	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// DeletionProtection: Whether the resource should be protected against
	// deletion.
	DeletionProtection bool `json:"deletionProtection,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// Disks: Array of disks associated with this instance. Persistent disks
	// must be created before you can assign them.
	Disks []*AttachedDisk `json:"disks,omitempty"`

	// DisplayDevice: Enables display device for the instance.
	DisplayDevice *DisplayDevice `json:"displayDevice,omitempty"`

	// EraseWindowsVssSignature: Specifies whether the disks restored from
	// source snapshots or source machine image should erase Windows
	// specific VSS signature.
	EraseWindowsVssSignature bool `json:"eraseWindowsVssSignature,omitempty"`

	// Fingerprint: Specifies a fingerprint for this resource, which is
	// essentially a hash of the instance's contents and used for optimistic
	// locking. The fingerprint is initially generated by Compute Engine and
	// changes after every request to modify or update the instance. You
	// must always provide an up-to-date fingerprint hash in order to update
	// the instance.
	//
	// To see the latest fingerprint, make get() request to the instance.
	Fingerprint string `json:"fingerprint,omitempty"`

	// GuestAccelerators: A list of the type and count of accelerator cards
	// attached to the instance.
	GuestAccelerators []*AcceleratorConfig `json:"guestAccelerators,omitempty"`

	// Hostname: Specifies the hostname of the instance. The specified
	// hostname must be RFC1035 compliant. If hostname is not specified, the
	// default hostname is [INSTANCE_NAME].c.[PROJECT_ID].internal when
	// using the global DNS, and
	// [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal DNS.
	Hostname string `json:"hostname,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// InstanceEncryptionKey: Encrypts or decrypts data for an instance with
	// a customer-supplied encryption key.
	//
	// If you are creating a new instance, this field encrypts the local SSD
	// and in-memory contents of the instance using a key that you
	// provide.
	//
	// If you are restarting an instance protected with a customer-supplied
	// encryption key, you must provide the correct key in order to
	// successfully restart the instance.
	//
	// If you do not provide an encryption key when creating the instance,
	// then the local SSD and in-memory contents will be encrypted using an
	// automatically generated key and you do not need to provide a key to
	// start the instance later.
	//
	// Instance templates do not store customer-supplied encryption keys, so
	// you cannot use your own keys to encrypt local SSDs and in-memory
	// content in a managed instance group.
	InstanceEncryptionKey *CustomerEncryptionKey `json:"instanceEncryptionKey,omitempty"`

	// Kind: [Output Only] Type of the resource. Always compute#instance for
	// instances.
	Kind string `json:"kind,omitempty"`

	// LabelFingerprint: A fingerprint for this request, which is
	// essentially a hash of the label's contents and used for optimistic
	// locking. The fingerprint is initially generated by Compute Engine and
	// changes after every request to modify or update labels. You must
	// always provide an up-to-date fingerprint hash in order to update or
	// change labels.
	//
	// To see the latest fingerprint, make get() request to the instance.
	LabelFingerprint string `json:"labelFingerprint,omitempty"`

	// Labels: Labels to apply to this instance. These can be later modified
	// by the setLabels method.
	Labels map[string]string `json:"labels,omitempty"`

	// LastStartTimestamp: [Output Only] Last start timestamp in RFC3339
	// text format.
	LastStartTimestamp string `json:"lastStartTimestamp,omitempty"`

	// LastStopTimestamp: [Output Only] Last stop timestamp in RFC3339 text
	// format.
	LastStopTimestamp string `json:"lastStopTimestamp,omitempty"`

	// LastSuspendedTimestamp: [Output Only] Last suspended timestamp in
	// RFC3339 text format.
	LastSuspendedTimestamp string `json:"lastSuspendedTimestamp,omitempty"`

	// MachineType: Full or partial URL of the machine type resource to use
	// for this instance, in the format:
	// zones/zone/machineTypes/machine-type. This is provided by the client
	// when the instance is created. For example, the following is a valid
	// partial url to a predefined machine
	// type:
	// zones/us-central1-f/machineTypes/n1-standard-1
	//
	//
	// To create a custom machine type, provide a URL to a machine type in
	// the following format, where CPUS is 1 or an even number up to 32 (2,
	// 4, 6, ... 24, etc), and MEMORY is the total memory for this instance.
	// Memory must be a multiple of 256 MB and must be supplied in MB (e.g.
	// 5 GB of memory is 5120
	// MB):
	// zones/zone/machineTypes/custom-CPUS-MEMORY
	//
	//
	// For example: zones/us-central1-f/machineTypes/custom-4-5120
	//
	// For a full list of restrictions, read the Specifications for custom
	// machine types.
	MachineType string `json:"machineType,omitempty"`

	// Metadata: The metadata key/value pairs assigned to this instance.
	// This includes custom metadata and predefined keys.
	Metadata *Metadata `json:"metadata,omitempty"`

	// MinCpuPlatform: Specifies a minimum CPU platform for the VM instance.
	// Applicable values are the friendly names of CPU platforms, such as
	// minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy
	// Bridge".
	MinCpuPlatform string `json:"minCpuPlatform,omitempty"`

	// Name: The name of the resource, provided by the client when initially
	// creating the resource. The resource name must be 1-63 characters
	// long, and comply with RFC1035. Specifically, the name must be 1-63
	// characters long and match the regular expression
	// `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be
	// a lowercase letter, and all following characters must be a dash,
	// lowercase letter, or digit, except the last character, which cannot
	// be a dash.
	Name string `json:"name,omitempty"`

	// NetworkInterfaces: An array of network configurations for this
	// instance. These specify how interfaces are configured to interact
	// with other network services, such as connecting to the internet.
	// Multiple interfaces are supported per instance.
	NetworkInterfaces []*NetworkInterface `json:"networkInterfaces,omitempty"`

	NetworkPerformanceConfig *NetworkPerformanceConfig `json:"networkPerformanceConfig,omitempty"`

	// PostKeyRevocationActionType: PostKeyRevocationActionType of the
	// instance.
	//
	// Possible values:
	//   "NOOP"
	//   "POST_KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED"
	//   "SHUTDOWN"
	PostKeyRevocationActionType string `json:"postKeyRevocationActionType,omitempty"`

	// PreservedStateSizeGb: Total amount of preserved state for SUSPENDED
	// instances. Read-only in the api.
	PreservedStateSizeGb int64 `json:"preservedStateSizeGb,omitempty,string"`

	// PrivateIpv6GoogleAccess: The private IPv6 google access type for the
	// VM. If not specified, use  INHERIT_FROM_SUBNETWORK as default.
	//
	// Possible values:
	//   "ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE"
	//   "ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE"
	//   "INHERIT_FROM_SUBNETWORK"
	PrivateIpv6GoogleAccess string `json:"privateIpv6GoogleAccess,omitempty"`

	// ReservationAffinity: Specifies the reservations that this instance
	// can consume from.
	ReservationAffinity *ReservationAffinity `json:"reservationAffinity,omitempty"`

	// ResourcePolicies: Resource policies applied to this instance.
	ResourcePolicies []string `json:"resourcePolicies,omitempty"`

	// ResourceStatus: [Output Only] Specifies values set for instance
	// attributes as compared to the values requested by user in the
	// corresponding input only field.
	ResourceStatus *ResourceStatus `json:"resourceStatus,omitempty"`

	// SatisfiesPzs: [Output Only] Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`

	// Scheduling: Sets the scheduling options for this instance.
	Scheduling *Scheduling `json:"scheduling,omitempty"`

	// SecureLabels: Secure labels to apply to this instance. These can be
	// later modified by the update method. Maximum number of secure labels
	// allowed is 300.
	SecureLabels []string `json:"secureLabels,omitempty"`

	// SecureTags: Secure tags to apply to this instance. These can be later
	// modified by the update method. Maximum number of secure tags allowed
	// is 300.
	SecureTags []string `json:"secureTags,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// ServiceAccounts: A list of service accounts, with their specified
	// scopes, authorized for this instance. Only one service account per VM
	// instance is supported.
	//
	// Service accounts generate access tokens that can be accessed through
	// the metadata server and used to authenticate applications on the
	// instance. See Service Accounts for more information.
	ServiceAccounts []*ServiceAccount `json:"serviceAccounts,omitempty"`

	ShieldedInstanceConfig *ShieldedInstanceConfig `json:"shieldedInstanceConfig,omitempty"`

	ShieldedInstanceIntegrityPolicy *ShieldedInstanceIntegrityPolicy `json:"shieldedInstanceIntegrityPolicy,omitempty"`

	// ShieldedVmConfig: Deprecating, please use shielded_instance_config.
	ShieldedVmConfig *ShieldedVmConfig `json:"shieldedVmConfig,omitempty"`

	// ShieldedVmIntegrityPolicy: Deprecating, please use
	// shielded_instance_integrity_policy.
	ShieldedVmIntegrityPolicy *ShieldedVmIntegrityPolicy `json:"shieldedVmIntegrityPolicy,omitempty"`

	// SourceMachineImage: Source machine image
	SourceMachineImage string `json:"sourceMachineImage,omitempty"`

	// SourceMachineImageEncryptionKey: Source machine image encryption key
	// when creating an instance from a machine image.
	SourceMachineImageEncryptionKey *CustomerEncryptionKey `json:"sourceMachineImageEncryptionKey,omitempty"`

	// StartRestricted: [Output Only] Whether a VM has been restricted for
	// start because Compute Engine has detected suspicious activity.
	StartRestricted bool `json:"startRestricted,omitempty"`

	// Status: [Output Only] The status of the instance. One of the
	// following values: PROVISIONING, STAGING, RUNNING, STOPPING,
	// SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more
	// information about the status of the instance, see  Instance life
	// cycle.
	//
	// Possible values:
	//   "DEPROVISIONING"
	//   "PROVISIONING"
	//   "REPAIRING"
	//   "RUNNING"
	//   "STAGING"
	//   "STOPPED"
	//   "STOPPING"
	//   "SUSPENDED"
	//   "SUSPENDING"
	//   "TERMINATED"
	Status string `json:"status,omitempty"`

	// StatusMessage: [Output Only] An optional, human-readable explanation
	// of the status.
	StatusMessage string `json:"statusMessage,omitempty"`

	// Tags: Tags to apply to this instance. Tags are used to identify valid
	// sources or targets for network firewalls and are specified by the
	// client during instance creation. The tags can be later modified by
	// the setTags method. Each tag within the list must comply with
	// RFC1035. Multiple tags can be specified via the 'tags.items' field.
	Tags *Tags `json:"tags,omitempty"`

	// UpcomingMaintenance: [Output Only] Specifies upcoming maintenance for
	// the instance.
	UpcomingMaintenance *UpcomingMaintenance `json:"upcomingMaintenance,omitempty"`

	// Zone: [Output Only] URL of the zone where the instance resides. You
	// must specify this field as part of the HTTP request URL. It is not
	// settable as a field in the request body.
	Zone string `json:"zone,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "AdvancedMachineFeatures") to unconditionally include in API
	// requests. By default, fields with empty values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdvancedMachineFeatures")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Instance) MarshalJSON() ([]byte, error) {
	type NoMethod Instance
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceAggregatedList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: An object that contains a list of instances scoped by zone.
	Items map[string]InstancesScopedList `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#instanceAggregatedList for aggregated lists of Instance
	// resources.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Unreachables: [Output Only] Unreachable resources.
	Unreachables []string `json:"unreachables,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *InstanceAggregatedListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceAggregatedList) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceAggregatedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceAggregatedListWarning: [Output Only] Informational warning
// message.
type InstanceAggregatedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*InstanceAggregatedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceAggregatedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceAggregatedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceAggregatedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceAggregatedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceAggregatedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceGroup: Represents an Instance Group resource.
//
// Instance Groups can be used to configure a target for load
// balancing.
//
// Instance groups can either be managed or unmanaged.
//
// To create  managed instance groups, use the instanceGroupManager or
// regionInstanceGroupManager resource instead.
//
// Use zonal unmanaged instance groups if you need to apply load
// balancing to groups of heterogeneous instances or if you need to
// manage the instances yourself. You cannot create regional unmanaged
// instance groups.
//
// For more information, read Instance groups.
//
// (== resource_for {$api_version}.instanceGroups ==) (== resource_for
// {$api_version}.regionInstanceGroups ==)
type InstanceGroup struct {
	// CreationTimestamp: [Output Only] The creation timestamp for this
	// instance group in RFC3339 text format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// Fingerprint: [Output Only] The fingerprint of the named ports. The
	// system uses this fingerprint to detect conflicts when multiple users
	// change the named ports concurrently.
	Fingerprint string `json:"fingerprint,omitempty"`

	// Id: [Output Only] A unique identifier for this instance group,
	// generated by the server.
	Id uint64 `json:"id,omitempty,string"`

	// Kind: [Output Only] The resource type, which is always
	// compute#instanceGroup for instance groups.
	Kind string `json:"kind,omitempty"`

	// Name: The name of the instance group. The name must be 1-63
	// characters long, and comply with RFC1035.
	Name string `json:"name,omitempty"`

	// NamedPorts: Assigns a name to a port number. For example: {name:
	// "http", port: 80}
	//
	// This allows the system to reference ports by the assigned name
	// instead of a port number. Named ports can also contain multiple
	// ports. For example: [{name: "http", port: 80},{name: "http", port:
	// 8080}]
	//
	// Named ports apply to all instances in this instance group.
	NamedPorts []*NamedPort `json:"namedPorts,omitempty"`

	// Network: [Output Only] The URL of the network to which all instances
	// in the instance group belong. If your instance has multiple network
	// interfaces, then the network and subnetwork fields only refer to the
	// network and subnet used by your primary interface (nic0).
	Network string `json:"network,omitempty"`

	// Region: [Output Only] The URL of the region where the instance group
	// is located (for regional resources).
	Region string `json:"region,omitempty"`

	// SelfLink: [Output Only] The URL for this instance group. The server
	// generates this URL.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// Size: [Output Only] The total number of instances in the instance
	// group.
	Size int64 `json:"size,omitempty"`

	// Subnetwork: [Output Only] The URL of the subnetwork to which all
	// instances in the instance group belong. If your instance has multiple
	// network interfaces, then the network and subnetwork fields only refer
	// to the network and subnet used by your primary interface (nic0).
	Subnetwork string `json:"subnetwork,omitempty"`

	// Zone: [Output Only] The URL of the zone where the instance group is
	// located (for zonal resources).
	Zone string `json:"zone,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreationTimestamp")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreationTimestamp") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroup) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupAggregatedList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of InstanceGroupsScopedList resources.
	Items map[string]InstanceGroupsScopedList `json:"items,omitempty"`

	// Kind: [Output Only] The resource type, which is always
	// compute#instanceGroupAggregatedList for aggregated lists of instance
	// groups.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Unreachables: [Output Only] Unreachable resources.
	Unreachables []string `json:"unreachables,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *InstanceGroupAggregatedListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupAggregatedList) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupAggregatedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceGroupAggregatedListWarning: [Output Only] Informational
// warning message.
type InstanceGroupAggregatedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*InstanceGroupAggregatedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupAggregatedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupAggregatedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupAggregatedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupAggregatedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupAggregatedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceGroupList: A list of InstanceGroup resources.
type InstanceGroupList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of InstanceGroup resources.
	Items []*InstanceGroup `json:"items,omitempty"`

	// Kind: [Output Only] The resource type, which is always
	// compute#instanceGroupList for instance group lists.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *InstanceGroupListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupList) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceGroupListWarning: [Output Only] Informational warning
// message.
type InstanceGroupListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*InstanceGroupListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceGroupManager: Represents a Managed Instance Group
// resource.
//
// An instance group is a collection of VM instances that you can manage
// as a single entity. For more information, read Instance groups.
//
// For zonal Managed Instance Group, use the instanceGroupManagers
// resource.
//
// For regional Managed Instance Group, use the
// regionInstanceGroupManagers resource. (== resource_for
// {$api_version}.instanceGroupManagers ==) (== resource_for
// {$api_version}.regionInstanceGroupManagers ==)
type InstanceGroupManager struct {
	// AutoHealingPolicies: The autohealing policy for this managed instance
	// group. You can specify only one value.
	AutoHealingPolicies []*InstanceGroupManagerAutoHealingPolicy `json:"autoHealingPolicies,omitempty"`

	// BaseInstanceName: The base instance name to use for instances in this
	// group. The value must be 1-58 characters long. Instances are named by
	// appending a hyphen and a random four-character string to the base
	// instance name. The base instance name must comply with RFC1035.
	BaseInstanceName string `json:"baseInstanceName,omitempty"`

	// CreationTimestamp: [Output Only] The creation timestamp for this
	// managed instance group in RFC3339 text format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// CurrentActions: [Output Only] The list of instance actions and the
	// number of instances in this managed instance group that are scheduled
	// for each of those actions.
	CurrentActions *InstanceGroupManagerActionsSummary `json:"currentActions,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// DistributionPolicy: Policy specifying the intended distribution of
	// managed instances across zones in a regional managed instance group.
	DistributionPolicy *DistributionPolicy `json:"distributionPolicy,omitempty"`

	// FailoverAction: The action to perform in case of zone failure. Only
	// one value is supported, NO_FAILOVER. The default is NO_FAILOVER.
	//
	// Possible values:
	//   "NO_FAILOVER"
	//   "UNKNOWN"
	FailoverAction string `json:"failoverAction,omitempty"`

	// Fingerprint: Fingerprint of this resource. This field may be used in
	// optimistic locking. It will be ignored when inserting an
	// InstanceGroupManager. An up-to-date fingerprint must be provided in
	// order to update the InstanceGroupManager, otherwise the request will
	// fail with error 412 conditionNotMet.
	//
	// To see the latest fingerprint, make a get() request to retrieve an
	// InstanceGroupManager.
	Fingerprint string `json:"fingerprint,omitempty"`

	// Id: [Output Only] A unique identifier for this resource type. The
	// server generates this identifier.
	Id uint64 `json:"id,omitempty,string"`

	// InstanceGroup: [Output Only] The URL of the Instance Group resource.
	InstanceGroup string `json:"instanceGroup,omitempty"`

	// InstanceLifecyclePolicy: Instance lifecycle policy for this Instance
	// Group Manager.
	InstanceLifecyclePolicy *InstanceGroupManagerInstanceLifecyclePolicy `json:"instanceLifecyclePolicy,omitempty"`

	// InstanceTemplate: The URL of the instance template that is specified
	// for this managed instance group. The group uses this template to
	// create all new instances in the managed instance group. The templates
	// for existing instances in the group do not change unless you run
	// recreateInstances, run applyUpdatesToInstances, or set the group's
	// updatePolicy.type to PROACTIVE.
	InstanceTemplate string `json:"instanceTemplate,omitempty"`

	// Kind: [Output Only] The resource type, which is always
	// compute#instanceGroupManager for managed instance groups.
	Kind string `json:"kind,omitempty"`

	// Name: The name of the managed instance group. The name must be 1-63
	// characters long, and comply with RFC1035.
	Name string `json:"name,omitempty"`

	// NamedPorts: Named ports configured for the Instance Groups
	// complementary to this Instance Group Manager.
	NamedPorts []*NamedPort `json:"namedPorts,omitempty"`

	// Region: [Output Only] The URL of the region where the managed
	// instance group resides (for regional resources).
	Region string `json:"region,omitempty"`

	// SelfLink: [Output Only] The URL for this managed instance group. The
	// server defines this URL.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// ServiceAccount: The service account to be used as credentials for all
	// operations performed by the managed instance group on instances. The
	// service accounts needs all permissions required to create and delete
	// instances. By default, the service account
	// {projectNumber}@cloudservices.gserviceaccount.com is used.
	ServiceAccount string `json:"serviceAccount,omitempty"`

	// StatefulPolicy: Stateful configuration for this Instanced Group
	// Manager
	StatefulPolicy *StatefulPolicy `json:"statefulPolicy,omitempty"`

	// Status: [Output Only] The status of this managed instance group.
	Status *InstanceGroupManagerStatus `json:"status,omitempty"`

	// TargetPools: The URLs for all TargetPool resources to which instances
	// in the instanceGroup field are added. The target pools automatically
	// apply to all of the instances in the managed instance group.
	TargetPools []string `json:"targetPools,omitempty"`

	// TargetSize: The target number of running instances for this managed
	// instance group. You can reduce this number by using the
	// instanceGroupManager deleteInstances or abandonInstances methods.
	// Resizing the group also changes this number.
	TargetSize int64 `json:"targetSize,omitempty"`

	// TargetStoppedSize: The target number of stopped instances for this
	// managed instance group. This number changes when you:
	// - Stop instance using the stopInstances method or start instances
	// using the startInstances method.
	// - Manually change the targetStoppedSize using the update method.
	TargetStoppedSize int64 `json:"targetStoppedSize,omitempty"`

	// TargetSuspendedSize: The target number of suspended instances for
	// this managed instance group. This number changes when you:
	// - Suspend instance using the suspendInstances method or resume
	// instances using the resumeInstances method.
	// - Manually change the targetSuspendedSize using the update method.
	TargetSuspendedSize int64 `json:"targetSuspendedSize,omitempty"`

	// UpdatePolicy: The update policy for this managed instance group.
	UpdatePolicy *InstanceGroupManagerUpdatePolicy `json:"updatePolicy,omitempty"`

	// Versions: Specifies the instance templates used by this managed
	// instance group to create instances.
	//
	// Each version is defined by an instanceTemplate and a name. Every
	// version can appear at most once per instance group. This field
	// overrides the top-level instanceTemplate field. Read more about the
	// relationships between these fields. Exactly one version must leave
	// the targetSize field unset. That version will be applied to all
	// remaining instances. For more information, read about canary updates.
	Versions []*InstanceGroupManagerVersion `json:"versions,omitempty"`

	// Zone: [Output Only] The URL of a zone where the managed instance
	// group is located (for zonal resources).
	Zone string `json:"zone,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AutoHealingPolicies")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AutoHealingPolicies") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManager) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManager
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupManagerActionsSummary struct {
	// Abandoning: [Output Only] The total number of instances in the
	// managed instance group that are scheduled to be abandoned. Abandoning
	// an instance removes it from the managed instance group without
	// deleting it.
	Abandoning int64 `json:"abandoning,omitempty"`

	// Creating: [Output Only] The number of instances in the managed
	// instance group that are scheduled to be created or are currently
	// being created. If the group fails to create any of these instances,
	// it tries again until it creates the instance successfully.
	//
	// If you have disabled creation retries, this field will not be
	// populated; instead, the creatingWithoutRetries field will be
	// populated.
	Creating int64 `json:"creating,omitempty"`

	// CreatingWithoutRetries: [Output Only] The number of instances that
	// the managed instance group will attempt to create. The group attempts
	// to create each instance only once. If the group fails to create any
	// of these instances, it decreases the group's targetSize value
	// accordingly.
	CreatingWithoutRetries int64 `json:"creatingWithoutRetries,omitempty"`

	// Deleting: [Output Only] The number of instances in the managed
	// instance group that are scheduled to be deleted or are currently
	// being deleted.
	Deleting int64 `json:"deleting,omitempty"`

	// None: [Output Only] The number of instances in the managed instance
	// group that are running and have no scheduled actions.
	None int64 `json:"none,omitempty"`

	// Recreating: [Output Only] The number of instances in the managed
	// instance group that are scheduled to be recreated or are currently
	// being being recreated. Recreating an instance deletes the existing
	// root persistent disk and creates a new disk from the image that is
	// defined in the instance template.
	Recreating int64 `json:"recreating,omitempty"`

	// Refreshing: [Output Only] The number of instances in the managed
	// instance group that are being reconfigured with properties that do
	// not require a restart or a recreate action. For example, setting or
	// removing target pools for the instance.
	Refreshing int64 `json:"refreshing,omitempty"`

	// Restarting: [Output Only] The number of instances in the managed
	// instance group that are scheduled to be restarted or are currently
	// being restarted.
	Restarting int64 `json:"restarting,omitempty"`

	// Resuming: [Output Only] The number of instances in the managed
	// instance group that are scheduled to be resumed or are currently
	// being resumed.
	Resuming int64 `json:"resuming,omitempty"`

	// Starting: [Output Only] The number of instances in the managed
	// instance group that are scheduled to be started or are currently
	// being started.
	Starting int64 `json:"starting,omitempty"`

	// Stopping: [Output Only] The number of instances in the managed
	// instance group that are scheduled to be stopped or are currently
	// being stopped.
	Stopping int64 `json:"stopping,omitempty"`

	// Suspending: [Output Only] The number of instances in the managed
	// instance group that are scheduled to be suspended or are currently
	// being suspended.
	Suspending int64 `json:"suspending,omitempty"`

	// Verifying: [Output Only] The number of instances in the managed
	// instance group that are being verified. See the
	// managedInstances[].currentAction property in the listManagedInstances
	// method documentation.
	Verifying int64 `json:"verifying,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Abandoning") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Abandoning") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagerActionsSummary) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagerActionsSummary
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupManagerAggregatedList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of InstanceGroupManagersScopedList resources.
	Items map[string]InstanceGroupManagersScopedList `json:"items,omitempty"`

	// Kind: [Output Only] The resource type, which is always
	// compute#instanceGroupManagerAggregatedList for an aggregated list of
	// managed instance groups.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Unreachables: [Output Only] Unreachable resources.
	Unreachables []string `json:"unreachables,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *InstanceGroupManagerAggregatedListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagerAggregatedList) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagerAggregatedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceGroupManagerAggregatedListWarning: [Output Only]
// Informational warning message.
type InstanceGroupManagerAggregatedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*InstanceGroupManagerAggregatedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagerAggregatedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagerAggregatedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupManagerAggregatedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagerAggregatedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagerAggregatedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupManagerAutoHealingPolicy struct {
	// HealthCheck: The URL for the health check that signals autohealing.
	HealthCheck string `json:"healthCheck,omitempty"`

	// InitialDelaySec: The number of seconds that the managed instance
	// group waits before it applies autohealing policies to new instances
	// or recently recreated instances. This initial delay allows instances
	// to initialize and run their startup scripts before the instance group
	// determines that they are UNHEALTHY. This prevents the managed
	// instance group from recreating its instances prematurely. This value
	// must be from range [0, 3600].
	InitialDelaySec int64 `json:"initialDelaySec,omitempty"`

	// MaxUnavailable: Maximum number of instances that can be unavailable
	// when autohealing. When 'percent' is used, the value is rounded UP.
	// The instance is considered available if all of the following
	// conditions are satisfied: 1. Instance's status is RUNNING. 2.
	// Instance's currentAction is NONE (in particular its liveness health
	// check result was observed to be HEALTHY at least once as it passed
	// VERIFYING). 3. There is no outgoing action on an instance triggered
	// by IGM.
	//
	// By default, number of concurrently autohealed instances is smaller
	// than the managed instance group target size. However, if a zonal
	// managed instance group has only one instance, or a regional managed
	// instance group has only one instance per zone, autohealing will
	// recreate these instances when they become unhealthy.
	MaxUnavailable *FixedOrPercent `json:"maxUnavailable,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HealthCheck") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HealthCheck") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagerAutoHealingPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagerAutoHealingPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupManagerInstanceLifecyclePolicy struct {
	// MetadataBasedReadinessSignal: The configuration for metadata based
	// readiness signal sent by the instance during initialization when
	// stopping / suspending an instance. The Instance Group Manager will
	// wait for a signal that indicates successful initialization before
	// stopping / suspending an instance.
	//
	// If a successful readiness signal is not sent before timeout, the
	// corresponding instance will not be stopped / suspended. Instead, an
	// error will be visible in the lastAttempt.errors field of the managed
	// instance in the listmanagedinstances method.
	//
	// If metadataBasedReadinessSignal.timeoutSec is unset, the Instance
	// Group Manager will directly proceed to suspend / stop instances,
	// skipping initialization on them.
	MetadataBasedReadinessSignal *InstanceGroupManagerInstanceLifecyclePolicyMetadataBasedReadinessSignal `json:"metadataBasedReadinessSignal,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "MetadataBasedReadinessSignal") to unconditionally include in API
	// requests. By default, fields with empty values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "MetadataBasedReadinessSignal") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagerInstanceLifecyclePolicy) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagerInstanceLifecyclePolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupManagerInstanceLifecyclePolicyMetadataBasedReadinessSignal struct {
	// TimeoutSec: The number of seconds to wait for a readiness signal
	// during initialization before timing out.
	TimeoutSec int64 `json:"timeoutSec,omitempty"`

	// ForceSendFields is a list of field names (e.g. "TimeoutSec") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TimeoutSec") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagerInstanceLifecyclePolicyMetadataBasedReadinessSignal) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagerInstanceLifecyclePolicyMetadataBasedReadinessSignal
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceGroupManagerList: [Output Only] A list of managed instance
// groups.
type InstanceGroupManagerList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of InstanceGroupManager resources.
	Items []*InstanceGroupManager `json:"items,omitempty"`

	// Kind: [Output Only] The resource type, which is always
	// compute#instanceGroupManagerList for a list of managed instance
	// groups.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *InstanceGroupManagerListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagerList) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagerList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceGroupManagerListWarning: [Output Only] Informational warning
// message.
type InstanceGroupManagerListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*InstanceGroupManagerListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagerListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagerListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupManagerListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagerListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagerListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupManagerStatus struct {
	// Autoscaler: [Output Only] The URL of the Autoscaler that targets this
	// instance group manager.
	Autoscaler string `json:"autoscaler,omitempty"`

	// IsStable: [Output Only] A bit indicating whether the managed instance
	// group is in a stable state. A stable state means that: none of the
	// instances in the managed instance group is currently undergoing any
	// type of change (for example, creation, restart, or deletion); no
	// future changes are scheduled for instances in the managed instance
	// group; and the managed instance group itself is not being modified.
	IsStable bool `json:"isStable,omitempty"`

	// Stateful: [Output Only] Stateful status of the given Instance Group
	// Manager.
	Stateful *InstanceGroupManagerStatusStateful `json:"stateful,omitempty"`

	// VersionTarget: [Output Only] A status of consistency of Instances'
	// versions with their target version specified by version field on
	// Instance Group Manager.
	VersionTarget *InstanceGroupManagerStatusVersionTarget `json:"versionTarget,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Autoscaler") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Autoscaler") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagerStatus) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagerStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupManagerStatusStateful struct {
	// HasStatefulConfig: [Output Only] A bit indicating whether the managed
	// instance group has stateful configuration, that is, if you have
	// configured any items in a stateful policy or in per-instance configs.
	// The group might report that it has no stateful config even when there
	// is still some preserved state on a managed instance, for example, if
	// you have deleted all PICs but not yet applied those deletions.
	HasStatefulConfig bool `json:"hasStatefulConfig,omitempty"`

	// IsStateful: [Output Only] A bit indicating whether the managed
	// instance group has stateful configuration, that is, if you have
	// configured any items in a stateful policy or in per-instance configs.
	// The group might report that it has no stateful config even when there
	// is still some preserved state on a managed instance, for example, if
	// you have deleted all PICs but not yet applied those deletions. This
	// field is deprecated in favor of has_stateful_config.
	IsStateful bool `json:"isStateful,omitempty"`

	// PerInstanceConfigs: [Output Only] Status of per-instance configs on
	// the instance.
	PerInstanceConfigs *InstanceGroupManagerStatusStatefulPerInstanceConfigs `json:"perInstanceConfigs,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HasStatefulConfig")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HasStatefulConfig") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagerStatusStateful) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagerStatusStateful
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupManagerStatusStatefulPerInstanceConfigs struct {
	// AllEffective: A bit indicating if all of the group's per-instance
	// configs (listed in the output of a listPerInstanceConfigs API call)
	// have status EFFECTIVE or there are no per-instance-configs.
	AllEffective bool `json:"allEffective,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AllEffective") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllEffective") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagerStatusStatefulPerInstanceConfigs) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagerStatusStatefulPerInstanceConfigs
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupManagerStatusVersionTarget struct {
	// IsReached: [Output Only] A bit indicating whether version target has
	// been reached in this managed instance group, i.e. all instances are
	// in their target version. Instances' target version are specified by
	// version field on Instance Group Manager.
	IsReached bool `json:"isReached,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IsReached") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IsReached") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagerStatusVersionTarget) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagerStatusVersionTarget
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupManagerUpdatePolicy struct {
	// InstanceRedistributionType: The  instance redistribution policy for
	// regional managed instance groups. Valid values are:
	// - PROACTIVE (default): The group attempts to maintain an even
	// distribution of VM instances across zones in the region.
	// - NONE: For non-autoscaled groups, proactive redistribution is
	// disabled.
	//
	// Possible values:
	//   "NONE"
	//   "PROACTIVE"
	InstanceRedistributionType string `json:"instanceRedistributionType,omitempty"`

	// MaxSurge: The maximum number of instances that can be created above
	// the specified targetSize during the update process. This value can be
	// either a fixed number or, if the group has 10 or more instances, a
	// percentage. If you set a percentage, the number of instances is
	// rounded up if necessary. The default value for maxSurge is a fixed
	// value equal to the number of zones in which the managed instance
	// group operates.
	//
	// At least one of either maxSurge or maxUnavailable must be greater
	// than 0. Learn more about maxSurge.
	MaxSurge *FixedOrPercent `json:"maxSurge,omitempty"`

	// MaxUnavailable: The maximum number of instances that can be
	// unavailable during the update process. An instance is considered
	// available if all of the following conditions are satisfied:
	//
	//
	// - The instance's status is RUNNING.
	// - If there is a health check on the instance group, the instance's
	// health check status must be HEALTHY at least once. If there is no
	// health check on the group, then the instance only needs to have a
	// status of RUNNING to be considered available.  This value can be
	// either a fixed number or, if the group has 10 or more instances, a
	// percentage. If you set a percentage, the number of instances is
	// rounded up if necessary. The default value for maxUnavailable is a
	// fixed value equal to the number of zones in which the managed
	// instance group operates.
	//
	// At least one of either maxSurge or maxUnavailable must be greater
	// than 0. Learn more about maxUnavailable.
	MaxUnavailable *FixedOrPercent `json:"maxUnavailable,omitempty"`

	// MinReadySec: Minimum number of seconds to wait for after a newly
	// created instance becomes available. This value must be from range [0,
	// 3600].
	MinReadySec int64 `json:"minReadySec,omitempty"`

	// MinimalAction: Minimal action to be taken on an instance. You can
	// specify either RESTART to restart existing instances or REPLACE to
	// delete and create new instances from the target template. If you
	// specify a RESTART, the Updater will attempt to perform that action
	// only. However, if the Updater determines that the minimal action you
	// specify is not enough to perform the update, it might perform a more
	// disruptive action.
	//
	// Possible values:
	//   "NONE"
	//   "REFRESH"
	//   "REPLACE"
	//   "RESTART"
	MinimalAction string `json:"minimalAction,omitempty"`

	// MostDisruptiveAllowedAction: Most disruptive action that is allowed
	// to be taken on an instance. You can specify either NONE to forbid any
	// actions, REFRESH to allow actions that do not need instance restart,
	// RESTART to allow actions that can be applied without instance
	// replacing or REPLACE to allow all possible actions. If the Updater
	// determines that the minimal update action needed is more disruptive
	// than most disruptive allowed action you specify it will not perform
	// the update at all.
	//
	// Possible values:
	//   "NONE"
	//   "REFRESH"
	//   "REPLACE"
	//   "RESTART"
	MostDisruptiveAllowedAction string `json:"mostDisruptiveAllowedAction,omitempty"`

	// ReplacementMethod: What action should be used to replace instances.
	// See minimal_action.REPLACE
	//
	// Possible values:
	//   "RECREATE"
	//   "SUBSTITUTE"
	ReplacementMethod string `json:"replacementMethod,omitempty"`

	// Type: The type of update process. You can specify either PROACTIVE so
	// that the instance group manager proactively executes actions in order
	// to bring instances to their target versions or OPPORTUNISTIC so that
	// no action is proactively executed but the update will be performed as
	// part of other actions (for example, resizes or recreateInstances
	// calls).
	//
	// Possible values:
	//   "OPPORTUNISTIC"
	//   "PROACTIVE"
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "InstanceRedistributionType") to unconditionally include in API
	// requests. By default, fields with empty values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "InstanceRedistributionType") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagerUpdatePolicy) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagerUpdatePolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupManagerVersion struct {
	// InstanceTemplate: The URL of the instance template that is specified
	// for this managed instance group. The group uses this template to
	// create new instances in the managed instance group until the
	// `targetSize` for this version is reached. The templates for existing
	// instances in the group do not change unless you run
	// recreateInstances, run applyUpdatesToInstances, or set the group's
	// updatePolicy.type to PROACTIVE; in those cases, existing instances
	// are updated until the `targetSize` for this version is reached.
	InstanceTemplate string `json:"instanceTemplate,omitempty"`

	// Name: Name of the version. Unique among all versions in the scope of
	// this managed instance group.
	Name string `json:"name,omitempty"`

	// Tag: Tag describing the version. Used to trigger rollout of a target
	// version even if instance_template remains unchanged. Deprecated in
	// favor of 'name'.
	Tag string `json:"tag,omitempty"`

	// TargetSize: Specifies the intended number of instances to be created
	// from the instanceTemplate. The final number of instances created from
	// the template will be equal to:
	// - If expressed as a fixed number, the minimum of either
	// targetSize.fixed or instanceGroupManager.targetSize is used.
	// - if expressed as a percent, the targetSize would be
	// (targetSize.percent/100 * InstanceGroupManager.targetSize) If there
	// is a remainder, the number is rounded up.  If unset, this version
	// will update any remaining instances not updated by another version.
	// Read Starting a canary update for more information.
	TargetSize *FixedOrPercent `json:"targetSize,omitempty"`

	// ForceSendFields is a list of field names (e.g. "InstanceTemplate") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InstanceTemplate") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagerVersion) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagerVersion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupManagersAbandonInstancesRequest struct {
	// Instances: The URLs of one or more instances to abandon. This can be
	// a full URL or a partial URL, such as
	// zones/[ZONE]/instances/[INSTANCE_NAME].
	Instances []string `json:"instances,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Instances") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Instances") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagersAbandonInstancesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagersAbandonInstancesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceGroupManagersApplyUpdatesRequest:
// InstanceGroupManagers.applyUpdatesToInstances
type InstanceGroupManagersApplyUpdatesRequest struct {
	// AllInstances: Flag to update all instances instead of specified list
	// of ?instances?. If the flag is set to true then the instances may not
	// be specified in the request.
	AllInstances bool `json:"allInstances,omitempty"`

	// Instances: The list of URLs of one or more instances for which you
	// want to apply updates. Each URL can be a full URL or a partial URL,
	// such as zones/[ZONE]/instances/[INSTANCE_NAME].
	Instances []string `json:"instances,omitempty"`

	// MaximalAction: The maximal action that should be performed on the
	// instances. By default REPLACE. This field is deprecated, please use
	// most_disruptive_allowed_action.
	//
	// Possible values:
	//   "NONE"
	//   "REFRESH"
	//   "REPLACE"
	//   "RESTART"
	MaximalAction string `json:"maximalAction,omitempty"`

	// MinimalAction: The minimal action that you want to perform on each
	// instance during the update:
	// - REPLACE: At minimum, delete the instance and create it again.
	// - RESTART: Stop the instance and start it again.
	// - REFRESH: Do not stop the instance.
	// - NONE: Do not disrupt the instance at all.  By default, the minimum
	// action is NONE. If your update requires a more disruptive action than
	// you set with this flag, the necessary action is performed to execute
	// the update.
	//
	// Possible values:
	//   "NONE"
	//   "REFRESH"
	//   "REPLACE"
	//   "RESTART"
	MinimalAction string `json:"minimalAction,omitempty"`

	// MostDisruptiveAllowedAction: The most disruptive action that you want
	// to perform on each instance during the update:
	// - REPLACE: Delete the instance and create it again.
	// - RESTART: Stop the instance and start it again.
	// - REFRESH: Do not stop the instance.
	// - NONE: Do not disrupt the instance at all.  By default, the most
	// disruptive allowed action is REPLACE. If your update requires a more
	// disruptive action than you set with this flag, the update request
	// will fail.
	//
	// Possible values:
	//   "NONE"
	//   "REFRESH"
	//   "REPLACE"
	//   "RESTART"
	MostDisruptiveAllowedAction string `json:"mostDisruptiveAllowedAction,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AllInstances") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllInstances") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagersApplyUpdatesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagersApplyUpdatesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceGroupManagersCreateInstancesRequest:
// InstanceGroupManagers.createInstances
type InstanceGroupManagersCreateInstancesRequest struct {
	// Instances: [Required] List of specifications of per-instance configs.
	Instances []*PerInstanceConfig `json:"instances,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Instances") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Instances") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagersCreateInstancesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagersCreateInstancesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupManagersDeleteInstancesRequest struct {
	// Instances: The URLs of one or more instances to delete. This can be a
	// full URL or a partial URL, such as
	// zones/[ZONE]/instances/[INSTANCE_NAME].
	Instances []string `json:"instances,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Instances") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Instances") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagersDeleteInstancesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagersDeleteInstancesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceGroupManagersDeletePerInstanceConfigsReq:
// InstanceGroupManagers.deletePerInstanceConfigs
type InstanceGroupManagersDeletePerInstanceConfigsReq struct {
	// Names: The list of instance names for which we want to delete
	// per-instance configs on this managed instance group.
	Names []string `json:"names,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Names") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Names") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagersDeletePerInstanceConfigsReq) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagersDeletePerInstanceConfigsReq
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupManagersListErrorsResponse struct {
	// Items: [Output Only] The list of errors of the managed instance
	// group.
	Items []*InstanceManagedByIgmError `json:"items,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Items") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagersListErrorsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagersListErrorsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupManagersListManagedInstancesResponse struct {
	// ManagedInstances: [Output Only] The list of instances in the managed
	// instance group.
	ManagedInstances []*ManagedInstance `json:"managedInstances,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ManagedInstances") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ManagedInstances") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagersListManagedInstancesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagersListManagedInstancesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupManagersListPerInstanceConfigsResp struct {
	// Items: [Output Only] The list of PerInstanceConfig.
	Items []*PerInstanceConfig `json:"items,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *InstanceGroupManagersListPerInstanceConfigsRespWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Items") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagersListPerInstanceConfigsResp) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagersListPerInstanceConfigsResp
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceGroupManagersListPerInstanceConfigsRespWarning: [Output Only]
// Informational warning message.
type InstanceGroupManagersListPerInstanceConfigsRespWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*InstanceGroupManagersListPerInstanceConfigsRespWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagersListPerInstanceConfigsRespWarning) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagersListPerInstanceConfigsRespWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupManagersListPerInstanceConfigsRespWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagersListPerInstanceConfigsRespWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagersListPerInstanceConfigsRespWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceGroupManagersPatchPerInstanceConfigsReq:
// InstanceGroupManagers.patchPerInstanceConfigs
type InstanceGroupManagersPatchPerInstanceConfigsReq struct {
	// PerInstanceConfigs: The list of per-instance configs to insert or
	// patch on this managed instance group.
	PerInstanceConfigs []*PerInstanceConfig `json:"perInstanceConfigs,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PerInstanceConfigs")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PerInstanceConfigs") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagersPatchPerInstanceConfigsReq) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagersPatchPerInstanceConfigsReq
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupManagersRecreateInstancesRequest struct {
	// Instances: The URLs of one or more instances to recreate. This can be
	// a full URL or a partial URL, such as
	// zones/[ZONE]/instances/[INSTANCE_NAME].
	Instances []string `json:"instances,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Instances") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Instances") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagersRecreateInstancesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagersRecreateInstancesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupManagersResizeAdvancedRequest struct {
	// NoCreationRetries: If this flag is true, the managed instance group
	// attempts to create all instances initiated by this resize request
	// only once. If there is an error during creation, the managed instance
	// group does not retry create this instance, and we will decrease the
	// targetSize of the request instead. If the flag is false, the group
	// attempts to recreate each instance continuously until it
	// succeeds.
	//
	// This flag matters only in the first attempt of creation of an
	// instance. After an instance is successfully created while this flag
	// is enabled, the instance behaves the same way as all the other
	// instances created with a regular resize request. In particular, if a
	// running instance dies unexpectedly at a later time and needs to be
	// recreated, this mode does not affect the recreation behavior in that
	// scenario.
	//
	// This flag is applicable only to the current resize request. It does
	// not influence other resize requests in any way.
	//
	// You can see which instances is being creating in which mode by
	// calling the get or listManagedInstances API.
	NoCreationRetries bool `json:"noCreationRetries,omitempty"`

	// TargetSize: The number of running instances that the managed instance
	// group should maintain at any given time. The group automatically adds
	// or removes instances to maintain the number of instances specified by
	// this parameter.
	TargetSize int64 `json:"targetSize,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NoCreationRetries")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NoCreationRetries") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagersResizeAdvancedRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagersResizeAdvancedRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupManagersResumeInstancesRequest struct {
	// Instances: The URLs of one or more instances to resume. This can be a
	// full URL or a partial URL, such as
	// zones/[ZONE]/instances/[INSTANCE_NAME].
	Instances []string `json:"instances,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Instances") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Instances") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagersResumeInstancesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagersResumeInstancesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupManagersScopedList struct {
	// InstanceGroupManagers: [Output Only] The list of managed instance
	// groups that are contained in the specified project and zone.
	InstanceGroupManagers []*InstanceGroupManager `json:"instanceGroupManagers,omitempty"`

	// Warning: [Output Only] The warning that replaces the list of managed
	// instance groups when the list is empty.
	Warning *InstanceGroupManagersScopedListWarning `json:"warning,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "InstanceGroupManagers") to unconditionally include in API requests.
	// By default, fields with empty values are omitted from API requests.
	// However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InstanceGroupManagers") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagersScopedList) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagersScopedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceGroupManagersScopedListWarning: [Output Only] The warning
// that replaces the list of managed instance groups when the list is
// empty.
type InstanceGroupManagersScopedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*InstanceGroupManagersScopedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagersScopedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagersScopedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupManagersScopedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagersScopedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagersScopedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupManagersSetAutoHealingRequest struct {
	AutoHealingPolicies []*InstanceGroupManagerAutoHealingPolicy `json:"autoHealingPolicies,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AutoHealingPolicies")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AutoHealingPolicies") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagersSetAutoHealingRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagersSetAutoHealingRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupManagersSetInstanceTemplateRequest struct {
	// InstanceTemplate: The URL of the instance template that is specified
	// for this managed instance group. The group uses this template to
	// create all new instances in the managed instance group. The templates
	// for existing instances in the group do not change unless you run
	// recreateInstances, run applyUpdatesToInstances, or set the group's
	// updatePolicy.type to PROACTIVE.
	InstanceTemplate string `json:"instanceTemplate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "InstanceTemplate") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InstanceTemplate") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagersSetInstanceTemplateRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagersSetInstanceTemplateRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupManagersSetTargetPoolsRequest struct {
	// Fingerprint: The fingerprint of the target pools information. Use
	// this optional property to prevent conflicts when multiple users
	// change the target pools settings concurrently. Obtain the fingerprint
	// with the instanceGroupManagers.get method. Then, include the
	// fingerprint in your request to ensure that you do not overwrite
	// changes that were applied from another concurrent request.
	Fingerprint string `json:"fingerprint,omitempty"`

	// TargetPools: The list of target pool URLs that instances in this
	// managed instance group belong to. The managed instance group applies
	// these target pools to all of the instances in the group. Existing
	// instances and new instances in the group all receive these target
	// pool settings.
	TargetPools []string `json:"targetPools,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Fingerprint") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Fingerprint") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagersSetTargetPoolsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagersSetTargetPoolsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupManagersStartInstancesRequest struct {
	// Instances: The URLs of one or more instances to start. This can be a
	// full URL or a partial URL, such as
	// zones/[ZONE]/instances/[INSTANCE_NAME].
	Instances []string `json:"instances,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Instances") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Instances") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagersStartInstancesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagersStartInstancesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupManagersStopInstancesRequest struct {
	// ForceStop: If this flag is set to true, the Instance Group Manager
	// will proceed to stop the instances, skipping initialization on them.
	ForceStop bool `json:"forceStop,omitempty"`

	// Instances: The URLs of one or more instances to stop. This can be a
	// full URL or a partial URL, such as
	// zones/[ZONE]/instances/[INSTANCE_NAME].
	Instances []string `json:"instances,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ForceStop") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ForceStop") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagersStopInstancesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagersStopInstancesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupManagersSuspendInstancesRequest struct {
	// ForceSuspend: If this flag is set to true, the Instance Group Manager
	// will proceed to suspend the instances, skipping initialization on
	// them.
	ForceSuspend bool `json:"forceSuspend,omitempty"`

	// Instances: The URLs of one or more instances to suspend. This can be
	// a full URL or a partial URL, such as
	// zones/[ZONE]/instances/[INSTANCE_NAME].
	Instances []string `json:"instances,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ForceSuspend") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ForceSuspend") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagersSuspendInstancesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagersSuspendInstancesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceGroupManagersUpdatePerInstanceConfigsReq:
// InstanceGroupManagers.updatePerInstanceConfigs
type InstanceGroupManagersUpdatePerInstanceConfigsReq struct {
	// PerInstanceConfigs: The list of per-instance configs to insert or
	// patch on this managed instance group.
	PerInstanceConfigs []*PerInstanceConfig `json:"perInstanceConfigs,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PerInstanceConfigs")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PerInstanceConfigs") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupManagersUpdatePerInstanceConfigsReq) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupManagersUpdatePerInstanceConfigsReq
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupsAddInstancesRequest struct {
	// Instances: The list of instances to add to the instance group.
	Instances []*InstanceReference `json:"instances,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Instances") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Instances") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupsAddInstancesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupsAddInstancesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupsListInstances struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of InstanceWithNamedPorts resources.
	Items []*InstanceWithNamedPorts `json:"items,omitempty"`

	// Kind: [Output Only] The resource type, which is always
	// compute#instanceGroupsListInstances for the list of instances in the
	// specified instance group.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *InstanceGroupsListInstancesWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupsListInstances) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupsListInstances
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceGroupsListInstancesWarning: [Output Only] Informational
// warning message.
type InstanceGroupsListInstancesWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*InstanceGroupsListInstancesWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupsListInstancesWarning) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupsListInstancesWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupsListInstancesWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupsListInstancesWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupsListInstancesWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupsListInstancesRequest struct {
	// InstanceState: A filter for the state of the instances in the
	// instance group. Valid options are ALL or RUNNING. If you do not
	// specify this parameter the list includes all instances regardless of
	// their state.
	//
	// Possible values:
	//   "ALL"
	//   "RUNNING"
	InstanceState string `json:"instanceState,omitempty"`

	// ForceSendFields is a list of field names (e.g. "InstanceState") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InstanceState") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupsListInstancesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupsListInstancesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupsRemoveInstancesRequest struct {
	// Instances: The list of instances to remove from the instance group.
	Instances []*InstanceReference `json:"instances,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Instances") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Instances") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupsRemoveInstancesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupsRemoveInstancesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupsScopedList struct {
	// InstanceGroups: [Output Only] The list of instance groups that are
	// contained in this scope.
	InstanceGroups []*InstanceGroup `json:"instanceGroups,omitempty"`

	// Warning: [Output Only] An informational warning that replaces the
	// list of instance groups when the list is empty.
	Warning *InstanceGroupsScopedListWarning `json:"warning,omitempty"`

	// ForceSendFields is a list of field names (e.g. "InstanceGroups") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InstanceGroups") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupsScopedList) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupsScopedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceGroupsScopedListWarning: [Output Only] An informational
// warning that replaces the list of instance groups when the list is
// empty.
type InstanceGroupsScopedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*InstanceGroupsScopedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupsScopedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupsScopedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupsScopedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupsScopedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupsScopedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceGroupsSetNamedPortsRequest struct {
	// Fingerprint: The fingerprint of the named ports information for this
	// instance group. Use this optional property to prevent conflicts when
	// multiple users change the named ports settings concurrently. Obtain
	// the fingerprint with the instanceGroups.get method. Then, include the
	// fingerprint in your request to ensure that you do not overwrite
	// changes that were applied from another concurrent request. A request
	// with an incorrect fingerprint will fail with error 412
	// conditionNotMet.
	Fingerprint string `json:"fingerprint,omitempty"`

	// NamedPorts: The list of named ports to set for this instance group.
	NamedPorts []*NamedPort `json:"namedPorts,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Fingerprint") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Fingerprint") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceGroupsSetNamedPortsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupsSetNamedPortsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceList: Contains a list of instances.
type InstanceList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of Instance resources.
	Items []*Instance `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always compute#instanceList for
	// lists of Instance resources.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *InstanceListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceList) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceListWarning: [Output Only] Informational warning message.
type InstanceListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*InstanceListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceListReferrers: Contains a list of instance referrers.
type InstanceListReferrers struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of Reference resources.
	Items []*Reference `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#instanceListReferrers for lists of Instance referrers.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *InstanceListReferrersWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceListReferrers) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceListReferrers
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceListReferrersWarning: [Output Only] Informational warning
// message.
type InstanceListReferrersWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*InstanceListReferrersWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceListReferrersWarning) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceListReferrersWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceListReferrersWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceListReferrersWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceListReferrersWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceManagedByIgmError struct {
	// Error: [Output Only] Contents of the error.
	Error *InstanceManagedByIgmErrorManagedInstanceError `json:"error,omitempty"`

	// InstanceActionDetails: [Output Only] Details of the instance action
	// that triggered this error. May be null, if the error was not caused
	// by an action on an instance. This field is optional.
	InstanceActionDetails *InstanceManagedByIgmErrorInstanceActionDetails `json:"instanceActionDetails,omitempty"`

	// Timestamp: [Output Only] The time that this error occurred. This
	// value is in RFC3339 text format.
	Timestamp string `json:"timestamp,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Error") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Error") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceManagedByIgmError) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceManagedByIgmError
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceManagedByIgmErrorInstanceActionDetails struct {
	// Action: [Output Only] Action that managed instance group was
	// executing on the instance when the error occurred. Possible values:
	//
	// Possible values:
	//   "ABANDONING"
	//   "CREATING"
	//   "CREATING_WITHOUT_RETRIES"
	//   "DELETING"
	//   "NONE"
	//   "RECREATING"
	//   "REFRESHING"
	//   "RESTARTING"
	//   "RESUMING"
	//   "STARTING"
	//   "STOPPING"
	//   "SUSPENDING"
	//   "VERIFYING"
	Action string `json:"action,omitempty"`

	// Instance: [Output Only] The URL of the instance. The URL can be set
	// even if the instance has not yet been created.
	Instance string `json:"instance,omitempty"`

	// Version: [Output Only] Version this instance was created from, or was
	// being created from, but the creation failed. Corresponds to one of
	// the versions that were set on the Instance Group Manager resource at
	// the time this instance was being created.
	Version *ManagedInstanceVersion `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Action") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceManagedByIgmErrorInstanceActionDetails) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceManagedByIgmErrorInstanceActionDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceManagedByIgmErrorManagedInstanceError struct {
	// Code: [Output Only] Error code.
	Code string `json:"code,omitempty"`

	// Message: [Output Only] Error message.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceManagedByIgmErrorManagedInstanceError) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceManagedByIgmErrorManagedInstanceError
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceMoveRequest struct {
	// DestinationZone: The URL of the destination zone to move the
	// instance. This can be a full or partial URL. For example, the
	// following are all valid URLs to a zone:
	// - https://www.googleapis.com/compute/v1/projects/project/zones/zone
	//
	// - projects/project/zones/zone
	// - zones/zone
	DestinationZone string `json:"destinationZone,omitempty"`

	// TargetInstance: The URL of the target instance to move. This can be a
	// full or partial URL. For example, the following are all valid URLs to
	// an instance:
	// -
	// https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance
	//
	// - projects/project/zones/zone/instances/instance
	// - zones/zone/instances/instance
	TargetInstance string `json:"targetInstance,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DestinationZone") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DestinationZone") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InstanceMoveRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceMoveRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceProperties struct {
	// AdvancedMachineFeatures: Controls for advanced machine-related
	// behavior features.
	AdvancedMachineFeatures *AdvancedMachineFeatures `json:"advancedMachineFeatures,omitempty"`

	// CanIpForward: Enables instances created based on these properties to
	// send packets with source IP addresses other than their own and
	// receive packets with destination IP addresses other than their own.
	// If these instances will be used as an IP gateway or it will be set as
	// the next-hop in a Route resource, specify true. If unsure, leave this
	// set to false. See the Enable IP forwarding documentation for more
	// information.
	CanIpForward bool `json:"canIpForward,omitempty"`

	// ConfidentialInstanceConfig: Specifies the Confidential Instance
	// options.
	ConfidentialInstanceConfig *ConfidentialInstanceConfig `json:"confidentialInstanceConfig,omitempty"`

	// Description: An optional text description for the instances that are
	// created from these properties.
	Description string `json:"description,omitempty"`

	// Disks: An array of disks that are associated with the instances that
	// are created from these properties.
	Disks []*AttachedDisk `json:"disks,omitempty"`

	// DisplayDevice: Display Device properties to enable support for remote
	// display products like: Teradici, VNC and TeamViewer
	DisplayDevice *DisplayDevice `json:"displayDevice,omitempty"`

	// GuestAccelerators: A list of guest accelerator cards' type and count
	// to use for instances created from these properties.
	GuestAccelerators []*AcceleratorConfig `json:"guestAccelerators,omitempty"`

	// Labels: Labels to apply to instances that are created from these
	// properties.
	Labels map[string]string `json:"labels,omitempty"`

	// MachineType: The machine type to use for instances that are created
	// from these properties.
	MachineType string `json:"machineType,omitempty"`

	// Metadata: The metadata key/value pairs to assign to instances that
	// are created from these properties. These pairs can consist of custom
	// metadata or predefined keys. See Project and instance metadata for
	// more information.
	Metadata *Metadata `json:"metadata,omitempty"`

	// MinCpuPlatform: Minimum cpu/platform to be used by instances. The
	// instance may be scheduled on the specified or newer cpu/platform.
	// Applicable values are the friendly names of CPU platforms, such as
	// minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy
	// Bridge". For more information, read Specifying a Minimum CPU
	// Platform.
	MinCpuPlatform string `json:"minCpuPlatform,omitempty"`

	// NetworkInterfaces: An array of network access configurations for this
	// interface.
	NetworkInterfaces []*NetworkInterface `json:"networkInterfaces,omitempty"`

	NetworkPerformanceConfig *NetworkPerformanceConfig `json:"networkPerformanceConfig,omitempty"`

	// PostKeyRevocationActionType: PostKeyRevocationActionType of the
	// instance.
	//
	// Possible values:
	//   "NOOP"
	//   "POST_KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED"
	//   "SHUTDOWN"
	PostKeyRevocationActionType string `json:"postKeyRevocationActionType,omitempty"`

	// PrivateIpv6GoogleAccess: The private IPv6 google access type for VMs.
	// If not specified, use  INHERIT_FROM_SUBNETWORK as default.
	//
	// Possible values:
	//   "ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE"
	//   "ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE"
	//   "INHERIT_FROM_SUBNETWORK"
	PrivateIpv6GoogleAccess string `json:"privateIpv6GoogleAccess,omitempty"`

	// ReservationAffinity: Specifies the reservations that instances can
	// consume from.
	ReservationAffinity *ReservationAffinity `json:"reservationAffinity,omitempty"`

	// ResourcePolicies: Resource policies (names, not ULRs) applied to
	// instances created from these properties.
	ResourcePolicies []string `json:"resourcePolicies,omitempty"`

	// Scheduling: Specifies the scheduling options for the instances that
	// are created from these properties.
	Scheduling *Scheduling `json:"scheduling,omitempty"`

	// ServiceAccounts: A list of service accounts with specified scopes.
	// Access tokens for these service accounts are available to the
	// instances that are created from these properties. Use metadata
	// queries to obtain the access tokens for these instances.
	ServiceAccounts []*ServiceAccount `json:"serviceAccounts,omitempty"`

	ShieldedInstanceConfig *ShieldedInstanceConfig `json:"shieldedInstanceConfig,omitempty"`

	// ShieldedVmConfig: Specifies the Shielded VM options for the instances
	// that are created from these properties.
	ShieldedVmConfig *ShieldedVmConfig `json:"shieldedVmConfig,omitempty"`

	// Tags: A list of tags to apply to the instances that are created from
	// these properties. The tags identify valid sources or targets for
	// network firewalls. The setTags method can modify this list of tags.
	// Each tag within the list must comply with RFC1035.
	Tags *Tags `json:"tags,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AdvancedMachineFeatures") to unconditionally include in API
	// requests. By default, fields with empty values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdvancedMachineFeatures")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InstanceProperties) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceProperties
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceReference struct {
	// Instance: The URL for a specific instance.
	Instance string `json:"instance,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Instance") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Instance") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceReference) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceReference
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceTemplate: Represents an Instance Template resource.
//
// You can use instance templates to create VM instances and managed
// instance groups. For more information, read Instance Templates. (==
// resource_for {$api_version}.instanceTemplates ==)
type InstanceTemplate struct {
	// CreationTimestamp: [Output Only] The creation timestamp for this
	// instance template in RFC3339 text format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// Id: [Output Only] A unique identifier for this instance template. The
	// server defines this identifier.
	Id uint64 `json:"id,omitempty,string"`

	// Kind: [Output Only] The resource type, which is always
	// compute#instanceTemplate for instance templates.
	Kind string `json:"kind,omitempty"`

	// Name: Name of the resource; provided by the client when the resource
	// is created. The name must be 1-63 characters long, and comply with
	// RFC1035. Specifically, the name must be 1-63 characters long and
	// match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means
	// the first character must be a lowercase letter, and all following
	// characters must be a dash, lowercase letter, or digit, except the
	// last character, which cannot be a dash.
	Name string `json:"name,omitempty"`

	// Properties: The instance properties for this instance template.
	Properties *InstanceProperties `json:"properties,omitempty"`

	// SelfLink: [Output Only] The URL for this instance template. The
	// server defines this URL.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// SourceInstance: The source instance used to create the template. You
	// can provide this as a partial or full URL to the resource. For
	// example, the following are valid values:
	// -
	// https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance
	//
	// - projects/project/zones/zone/instances/instance
	SourceInstance string `json:"sourceInstance,omitempty"`

	// SourceInstanceParams: The source instance params to use to create
	// this instance template.
	SourceInstanceParams *SourceInstanceParams `json:"sourceInstanceParams,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreationTimestamp")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreationTimestamp") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InstanceTemplate) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceTemplate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceTemplateList: A list of instance templates.
type InstanceTemplateList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of InstanceTemplate resources.
	Items []*InstanceTemplate `json:"items,omitempty"`

	// Kind: [Output Only] The resource type, which is always
	// compute#instanceTemplatesListResponse for instance template lists.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *InstanceTemplateListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceTemplateList) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceTemplateList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceTemplateListWarning: [Output Only] Informational warning
// message.
type InstanceTemplateListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*InstanceTemplateListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceTemplateListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceTemplateListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceTemplateListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceTemplateListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceTemplateListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstanceWithNamedPorts struct {
	// Instance: [Output Only] The URL of the instance.
	Instance string `json:"instance,omitempty"`

	// NamedPorts: [Output Only] The named ports that belong to this
	// instance group.
	NamedPorts []*NamedPort `json:"namedPorts,omitempty"`

	// Status: [Output Only] The status of the instance.
	//
	// Possible values:
	//   "DEPROVISIONING"
	//   "PROVISIONING"
	//   "REPAIRING"
	//   "RUNNING"
	//   "STAGING"
	//   "STOPPED"
	//   "STOPPING"
	//   "SUSPENDED"
	//   "SUSPENDING"
	//   "TERMINATED"
	Status string `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Instance") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Instance") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceWithNamedPorts) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceWithNamedPorts
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstancesAddResourcePoliciesRequest struct {
	// ResourcePolicies: Resource policies to be added to this instance.
	ResourcePolicies []string `json:"resourcePolicies,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResourcePolicies") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResourcePolicies") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InstancesAddResourcePoliciesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesAddResourcePoliciesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstancesGetEffectiveFirewallsResponse struct {
	// FirewallPolicys: Effective firewalls from firewall policies.
	FirewallPolicys []*InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy `json:"firewallPolicys,omitempty"`

	// Firewalls: Effective firewalls on the instance.
	Firewalls []*Firewall `json:"firewalls,omitempty"`

	// OrganizationFirewalls: Effective firewalls from organization
	// policies.
	OrganizationFirewalls []*InstancesGetEffectiveFirewallsResponseOrganizationFirewallPolicy `json:"organizationFirewalls,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "FirewallPolicys") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FirewallPolicys") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InstancesGetEffectiveFirewallsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesGetEffectiveFirewallsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy struct {
	// DisplayName: [Output Only] Deprecated, please use short name instead.
	// The display name of the firewall policy.
	DisplayName string `json:"displayName,omitempty"`

	// Name: [Output Only] The name of the firewall policy.
	Name string `json:"name,omitempty"`

	// Rules: The rules that apply to the network.
	Rules []*FirewallPolicyRule `json:"rules,omitempty"`

	// ShortName: [Output Only] The short name of the firewall policy.
	ShortName string `json:"shortName,omitempty"`

	// Type: [Output Only] The type of the firewall policy.
	//
	// Possible values:
	//   "HIERARCHY"
	//   "NETWORK"
	//   "UNSPECIFIED"
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstancesGetEffectiveFirewallsResponseOrganizationFirewallPolicy: A
// pruned SecurityPolicy containing ID and any applicable firewall
// rules.
type InstancesGetEffectiveFirewallsResponseOrganizationFirewallPolicy struct {
	// Id: The unique identifier for the security policy. This identifier is
	// defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// Rules: The rules that apply to the network.
	Rules []*SecurityPolicyRule `json:"rules,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstancesGetEffectiveFirewallsResponseOrganizationFirewallPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesGetEffectiveFirewallsResponseOrganizationFirewallPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstancesRemoveResourcePoliciesRequest struct {
	// ResourcePolicies: Resource policies to be removed from this instance.
	ResourcePolicies []string `json:"resourcePolicies,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResourcePolicies") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResourcePolicies") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InstancesRemoveResourcePoliciesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesRemoveResourcePoliciesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstancesResumeRequest struct {
	// Disks: Array of disks associated with this instance that are
	// protected with a customer-supplied encryption key.
	//
	// In order to resume the instance, the disk url and its corresponding
	// key must be provided.
	//
	// If the disk is not protected with a customer-supplied encryption key
	// it should not be specified.
	Disks []*CustomerEncryptionKeyProtectedDisk `json:"disks,omitempty"`

	// InstanceEncryptionKey: Decrypts data associated with an instance that
	// is protected with a customer-supplied encryption key.
	//
	// If the instance you are starting is protected with a
	// customer-supplied encryption key, the correct key must be provided
	// otherwise the instance resume will not succeed.
	InstanceEncryptionKey *CustomerEncryptionKey `json:"instanceEncryptionKey,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Disks") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Disks") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstancesResumeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesResumeRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstancesScopedList struct {
	// Instances: [Output Only] A list of instances contained in this scope.
	Instances []*Instance `json:"instances,omitempty"`

	// Warning: [Output Only] Informational warning which replaces the list
	// of instances when the list is empty.
	Warning *InstancesScopedListWarning `json:"warning,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Instances") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Instances") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstancesScopedList) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesScopedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstancesScopedListWarning: [Output Only] Informational warning which
// replaces the list of instances when the list is empty.
type InstancesScopedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*InstancesScopedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstancesScopedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesScopedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstancesScopedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstancesScopedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesScopedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstancesSetLabelsRequest struct {
	// LabelFingerprint: Fingerprint of the previous set of labels for this
	// resource, used to prevent conflicts. Provide the latest fingerprint
	// value when making a request to add or change labels.
	LabelFingerprint string `json:"labelFingerprint,omitempty"`

	Labels map[string]string `json:"labels,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LabelFingerprint") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LabelFingerprint") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InstancesSetLabelsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesSetLabelsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstancesSetMachineResourcesRequest struct {
	// GuestAccelerators: A list of the type and count of accelerator cards
	// attached to the instance.
	GuestAccelerators []*AcceleratorConfig `json:"guestAccelerators,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GuestAccelerators")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GuestAccelerators") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InstancesSetMachineResourcesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesSetMachineResourcesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstancesSetMachineTypeRequest struct {
	// MachineType: Full or partial URL of the machine type resource. See
	// Machine Types for a full list of machine types. For example:
	// zones/us-central1-f/machineTypes/n1-standard-1
	MachineType string `json:"machineType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MachineType") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MachineType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstancesSetMachineTypeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesSetMachineTypeRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstancesSetMinCpuPlatformRequest struct {
	// MinCpuPlatform: Minimum cpu/platform this instance should be started
	// at.
	MinCpuPlatform string `json:"minCpuPlatform,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MinCpuPlatform") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MinCpuPlatform") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InstancesSetMinCpuPlatformRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesSetMinCpuPlatformRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstancesSetNameRequest struct {
	// CurrentName: The current name of this resource, used to prevent
	// conflicts. Provide the latest name when making a request to change
	// name.
	CurrentName string `json:"currentName,omitempty"`

	// Name: The name to be applied to the instance. Needs to be RFC 1035
	// compliant.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CurrentName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CurrentName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstancesSetNameRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesSetNameRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstancesSetServiceAccountRequest struct {
	// Email: Email address of the service account.
	Email string `json:"email,omitempty"`

	// Scopes: The list of scopes to be made available for this service
	// account.
	Scopes []string `json:"scopes,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Email") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstancesSetServiceAccountRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesSetServiceAccountRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstancesStartWithEncryptionKeyRequest struct {
	// Disks: Array of disks associated with this instance that are
	// protected with a customer-supplied encryption key.
	//
	// In order to start the instance, the disk url and its corresponding
	// key must be provided.
	//
	// If the disk is not protected with a customer-supplied encryption key
	// it should not be specified.
	Disks []*CustomerEncryptionKeyProtectedDisk `json:"disks,omitempty"`

	// InstanceEncryptionKey: Decrypts data associated with an instance that
	// is protected with a customer-supplied encryption key.
	//
	// If the instance you are starting is protected with a
	// customer-supplied encryption key, the correct key must be provided
	// otherwise the instance start will not succeed.
	InstanceEncryptionKey *CustomerEncryptionKey `json:"instanceEncryptionKey,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Disks") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Disks") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstancesStartWithEncryptionKeyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesStartWithEncryptionKeyRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstantSnapshot: Represents a InstantSnapshot resource.
//
// You can use instant snapshots to create disk rollback points
// quickly.. (== resource_for {$api_version}.instantSnapshots ==)
type InstantSnapshot struct {
	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// DiskSizeGb: [Output Only] Size of the source disk, specified in GB.
	DiskSizeGb int64 `json:"diskSizeGb,omitempty,string"`

	// GuestFlush: Whether to attempt an application consistent instant
	// snapshot by informing the OS to prepare for the snapshot process.
	// Currently only supported on Windows instances using the Volume Shadow
	// Copy Service (VSS).
	GuestFlush bool `json:"guestFlush,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// Kind: [Output Only] Type of the resource. Always
	// compute#instantSnapshot for InstantSnapshot resources.
	Kind string `json:"kind,omitempty"`

	// LabelFingerprint: A fingerprint for the labels being applied to this
	// InstantSnapshot, which is essentially a hash of the labels set used
	// for optimistic locking. The fingerprint is initially generated by
	// Compute Engine and changes after every request to modify or update
	// labels. You must always provide an up-to-date fingerprint hash in
	// order to update or change labels, otherwise the request will fail
	// with error 412 conditionNotMet.
	//
	// To see the latest fingerprint, make a get() request to retrieve a
	// InstantSnapshot.
	LabelFingerprint string `json:"labelFingerprint,omitempty"`

	// Labels: Labels to apply to this InstantSnapshot. These can be later
	// modified by the setLabels method. Label values may be empty.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Name of the resource; provided by the client when the resource
	// is created. The name must be 1-63 characters long, and comply with
	// RFC1035. Specifically, the name must be 1-63 characters long and
	// match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means
	// the first character must be a lowercase letter, and all following
	// characters must be a dash, lowercase letter, or digit, except the
	// last character, which cannot be a dash.
	Name string `json:"name,omitempty"`

	// Region: [Output Only] URL of the region where the instant snapshot
	// resides. You must specify this field as part of the HTTP request URL.
	// It is not settable as a field in the request body.
	Region string `json:"region,omitempty"`

	// SatisfiesPzs: [Output Only] Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource's
	// resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// SourceDisk: URL of the source disk used to create this instant
	// snapshot. Note that the source disk must be in the same zone/region
	// as the instant snapshot to be created. This can be a full or valid
	// partial URL. For example, the following are valid values:
	// -
	// https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk
	//
	// -
	// https://www.googleapis.com/compute/v1/projects/project/regions/region/disks/disk
	//
	// - projects/project/zones/zone/disks/disk
	// - projects/project/regions/region/disks/disk
	// - zones/zone/disks/disk
	// - regions/region/disks/disk
	SourceDisk string `json:"sourceDisk,omitempty"`

	// SourceDiskId: [Output Only] The ID value of the disk used to create
	// this InstantSnapshot. This value may be used to determine whether the
	// InstantSnapshot was taken from the current or a previous instance of
	// a given disk name.
	SourceDiskId string `json:"sourceDiskId,omitempty"`

	// Status: [Output Only] The status of the instantSnapshot. This can be
	// CREATING, DELETING, FAILED, or READY.
	//
	// Possible values:
	//   "CREATING"
	//   "DELETING"
	//   "FAILED"
	//   "READY"
	Status string `json:"status,omitempty"`

	// Zone: [Output Only] URL of the zone where the instant snapshot
	// resides. You must specify this field as part of the HTTP request URL.
	// It is not settable as a field in the request body.
	Zone string `json:"zone,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreationTimestamp")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreationTimestamp") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InstantSnapshot) MarshalJSON() ([]byte, error) {
	type NoMethod InstantSnapshot
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstantSnapshotExportParams struct {
	// BaseInstantSnapshot: An optional base instant snapshot that this
	// resource is compared against. If not specified, all blocks of this
	// resource are exported. The base instant snapshot and this resource
	// must be created from the same disk. The base instant snapshot must be
	// created earlier in time than this resource.
	BaseInstantSnapshot string `json:"baseInstantSnapshot,omitempty"`

	// BucketName: The name of an existing bucket in Cloud Storage where the
	// changed blocks will be stored. The Google Service Account must have
	// read and write access to this bucket. The bucket has to be in the
	// same region as this resource.
	BucketName string `json:"bucketName,omitempty"`

	// EncryptionKey: Encryption key used to encrypt the instant snapshot.
	EncryptionKey *CustomerEncryptionKey `json:"encryptionKey,omitempty"`

	// ObjectName: Name of the output Bigstore object storing the changed
	// blocks. Object name must be less than 1024 bytes in length.
	ObjectName string `json:"objectName,omitempty"`

	// OutputType: The format of the output file.
	//
	// Possible values:
	//   "INVALID"
	//   "METADATA_AND_DATA"
	//   "METADATA_ONLY"
	OutputType string `json:"outputType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BaseInstantSnapshot")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BaseInstantSnapshot") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InstantSnapshotExportParams) MarshalJSON() ([]byte, error) {
	type NoMethod InstantSnapshotExportParams
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstantSnapshotList: Contains a list of InstantSnapshot resources.
type InstantSnapshotList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of InstantSnapshot resources.
	Items []*InstantSnapshot `json:"items,omitempty"`

	// Kind: Type of resource.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *InstantSnapshotListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstantSnapshotList) MarshalJSON() ([]byte, error) {
	type NoMethod InstantSnapshotList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstantSnapshotListWarning: [Output Only] Informational warning
// message.
type InstantSnapshotListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*InstantSnapshotListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstantSnapshotListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod InstantSnapshotListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InstantSnapshotListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstantSnapshotListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod InstantSnapshotListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Int64RangeMatch: HttpRouteRuleMatch criteria for field values that
// must stay within the specified integer range.
type Int64RangeMatch struct {
	// RangeEnd: The end of the range (exclusive) in signed long integer
	// format.
	RangeEnd int64 `json:"rangeEnd,omitempty,string"`

	// RangeStart: The start of the range (inclusive) in signed long integer
	// format.
	RangeStart int64 `json:"rangeStart,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "RangeEnd") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RangeEnd") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Int64RangeMatch) MarshalJSON() ([]byte, error) {
	type NoMethod Int64RangeMatch
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Interconnect: Represents an Interconnect resource.
//
// An Interconnect resource is a dedicated connection between the GCP
// network and your on-premises network. For more information, read the
// Dedicated Interconnect Overview. (== resource_for
// {$api_version}.interconnects ==)
type Interconnect struct {
	// AdminEnabled: Administrative status of the interconnect. When this is
	// set to true, the Interconnect is functional and can carry traffic.
	// When set to false, no packets can be carried over the interconnect
	// and no BGP routes are exchanged over it. By default, the status is
	// set to true.
	AdminEnabled bool `json:"adminEnabled,omitempty"`

	// CircuitInfos: [Output Only] A list of CircuitInfo objects, that
	// describe the individual circuits in this LAG.
	CircuitInfos []*InterconnectCircuitInfo `json:"circuitInfos,omitempty"`

	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// CustomerName: Customer name, to put in the Letter of Authorization as
	// the party authorized to request a crossconnect.
	CustomerName string `json:"customerName,omitempty"`

	// Description: An optional description of this resource. Provide this
	// property when you create the resource.
	Description string `json:"description,omitempty"`

	// ExpectedOutages: [Output Only] A list of outages expected for this
	// Interconnect.
	ExpectedOutages []*InterconnectOutageNotification `json:"expectedOutages,omitempty"`

	// GoogleIpAddress: [Output Only] IP address configured on the Google
	// side of the Interconnect link. This can be used only for ping tests.
	GoogleIpAddress string `json:"googleIpAddress,omitempty"`

	// GoogleReferenceId: [Output Only] Google reference ID to be used when
	// raising support tickets with Google or otherwise to debug backend
	// connectivity issues.
	GoogleReferenceId string `json:"googleReferenceId,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// InterconnectAttachments: [Output Only] A list of the URLs of all
	// InterconnectAttachments configured to use this Interconnect.
	InterconnectAttachments []string `json:"interconnectAttachments,omitempty"`

	// InterconnectType: Type of interconnect, which can take one of the
	// following values:
	// - PARTNER: A partner-managed interconnection shared between customers
	// though a partner.
	// - DEDICATED: A dedicated physical interconnection with the customer.
	// Note that a value IT_PRIVATE has been deprecated in favor of
	// DEDICATED.
	//
	// Possible values:
	//   "DEDICATED"
	//   "IT_PRIVATE"
	//   "PARTNER"
	InterconnectType string `json:"interconnectType,omitempty"`

	// Kind: [Output Only] Type of the resource. Always compute#interconnect
	// for interconnects.
	Kind string `json:"kind,omitempty"`

	// LabelFingerprint: A fingerprint for the labels being applied to this
	// Interconnect, which is essentially a hash of the labels set used for
	// optimistic locking. The fingerprint is initially generated by Compute
	// Engine and changes after every request to modify or update labels.
	// You must always provide an up-to-date fingerprint hash in order to
	// update or change labels, otherwise the request will fail with error
	// 412 conditionNotMet.
	//
	// To see the latest fingerprint, make a get() request to retrieve an
	// Interconnect.
	LabelFingerprint string `json:"labelFingerprint,omitempty"`

	// Labels: Labels for this resource. These can only be added or modified
	// by the setLabels method. Each label key/value pair must comply with
	// RFC1035. Label values may be empty.
	Labels map[string]string `json:"labels,omitempty"`

	// LinkType: Type of link requested, which can take one of the following
	// values:
	// - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics
	// - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. Note
	// that this field indicates the speed of each of the links in the
	// bundle, not the speed of the entire bundle.
	//
	// Possible values:
	//   "LINK_TYPE_ETHERNET_100G_LR"
	//   "LINK_TYPE_ETHERNET_10G_LR"
	LinkType string `json:"linkType,omitempty"`

	// Location: URL of the InterconnectLocation object that represents
	// where this connection is to be provisioned.
	Location string `json:"location,omitempty"`

	// Name: Name of the resource. Provided by the client when the resource
	// is created. The name must be 1-63 characters long, and comply with
	// RFC1035. Specifically, the name must be 1-63 characters long and
	// match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means
	// the first character must be a lowercase letter, and all following
	// characters must be a dash, lowercase letter, or digit, except the
	// last character, which cannot be a dash.
	Name string `json:"name,omitempty"`

	// NocContactEmail: Email address to contact the customer NOC for
	// operations and maintenance notifications regarding this Interconnect.
	// If specified, this will be used for notifications in addition to all
	// other forms described, such as Stackdriver logs alerting and Cloud
	// Notifications.
	NocContactEmail string `json:"nocContactEmail,omitempty"`

	// OperationalStatus: [Output Only] The current status of this
	// Interconnect's functionality, which can take one of the following
	// values:
	// - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to
	// use. Attachments may be provisioned on this Interconnect.
	// - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No
	// attachments may be provisioned on this Interconnect.
	// - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal
	// maintenance. No attachments may be provisioned or updated on this
	// Interconnect.
	//
	// Possible values:
	//   "OS_ACTIVE"
	//   "OS_UNPROVISIONED"
	OperationalStatus string `json:"operationalStatus,omitempty"`

	// PeerIpAddress: [Output Only] IP address configured on the customer
	// side of the Interconnect link. The customer should configure this IP
	// address during turnup when prompted by Google NOC. This can be used
	// only for ping tests.
	PeerIpAddress string `json:"peerIpAddress,omitempty"`

	// ProvisionedLinkCount: [Output Only] Number of links actually
	// provisioned in this interconnect.
	ProvisionedLinkCount int64 `json:"provisionedLinkCount,omitempty"`

	// RequestedLinkCount: Target number of physical links in the link
	// bundle, as requested by the customer.
	RequestedLinkCount int64 `json:"requestedLinkCount,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// State: [Output Only] The current state of Interconnect functionality,
	// which can take one of the following values:
	// - ACTIVE: The Interconnect is valid, turned up and ready to use.
	// Attachments may be provisioned on this Interconnect.
	// - UNPROVISIONED: The Interconnect has not completed turnup. No
	// attachments may be provisioned on this Interconnect.
	// - UNDER_MAINTENANCE: The Interconnect is undergoing internal
	// maintenance. No attachments may be provisioned or updated on this
	// Interconnect.
	//
	// Possible values:
	//   "ACTIVE"
	//   "UNPROVISIONED"
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AdminEnabled") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdminEnabled") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Interconnect) MarshalJSON() ([]byte, error) {
	type NoMethod Interconnect
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InterconnectAttachment: Represents an Interconnect Attachment (VLAN)
// resource.
//
// You can use Interconnect attachments (VLANS) to connect your Virtual
// Private Cloud networks to your on-premises networks through an
// Interconnect. For more information, read  Creating VLAN Attachments.
// (== resource_for {$api_version}.interconnectAttachments ==)
type InterconnectAttachment struct {
	// AdminEnabled: Determines whether this Attachment will carry packets.
	// Not present for PARTNER_PROVIDER.
	AdminEnabled bool `json:"adminEnabled,omitempty"`

	// Bandwidth: Provisioned bandwidth capacity for the interconnect
	// attachment. For attachments of type DEDICATED, the user can set the
	// bandwidth. For attachments of type PARTNER, the Google Partner that
	// is operating the interconnect must set the bandwidth. Output only for
	// PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can
	// take one of the following values:
	// - BPS_50M: 50 Mbit/s
	// - BPS_100M: 100 Mbit/s
	// - BPS_200M: 200 Mbit/s
	// - BPS_300M: 300 Mbit/s
	// - BPS_400M: 400 Mbit/s
	// - BPS_500M: 500 Mbit/s
	// - BPS_1G: 1 Gbit/s
	// - BPS_2G: 2 Gbit/s
	// - BPS_5G: 5 Gbit/s
	// - BPS_10G: 10 Gbit/s
	// - BPS_20G: 20 Gbit/s
	// - BPS_50G: 50 Gbit/s
	//
	// Possible values:
	//   "BPS_100M"
	//   "BPS_10G"
	//   "BPS_1G"
	//   "BPS_200M"
	//   "BPS_20G"
	//   "BPS_2G"
	//   "BPS_300M"
	//   "BPS_400M"
	//   "BPS_500M"
	//   "BPS_50G"
	//   "BPS_50M"
	//   "BPS_5G"
	Bandwidth string `json:"bandwidth,omitempty"`

	// CandidateSubnets: Up to 16 candidate prefixes that can be used to
	// restrict the allocation of cloudRouterIpAddress and
	// customerRouterIpAddress for this attachment. All prefixes must be
	// within link-local address space (169.254.0.0/16) and must be /29 or
	// shorter (/28, /27, etc). Google will attempt to select an unused /29
	// from the supplied candidate prefix(es). The request will fail if all
	// possible /29s are in use on Google's edge. If not supplied, Google
	// will randomly select an unused /29 from all of link-local space.
	CandidateSubnets []string `json:"candidateSubnets,omitempty"`

	// CloudRouterIpAddress: [Output Only] IPv4 address + prefix length to
	// be configured on Cloud Router Interface for this interconnect
	// attachment.
	CloudRouterIpAddress string `json:"cloudRouterIpAddress,omitempty"`

	// CreationTimestamp: [Output Only] Creation timestamp in RFC3339 text
	// format.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// CustomerRouterIpAddress: [Output Only] IPv4 address + prefix length
	// to be configured on the customer router subinterface for this
	// interconnect attachment.
	CustomerRouterIpAddress string `json:"customerRouterIpAddress,omitempty"`

	// DataplaneVersion: [Output Only] Dataplane version for this
	// InterconnectAttachment.
	DataplaneVersion int64 `json:"dataplaneVersion,omitempty"`

	// Description: An optional description of this resource.
	Description string `json:"description,omitempty"`

	// EdgeAvailabilityDomain: Desired availability domain for the
	// attachment. Only available for type PARTNER, at creation time, and
	// can take one of the following values:
	// - AVAILABILITY_DOMAIN_ANY
	// - AVAILABILITY_DOMAIN_1
	// - AVAILABILITY_DOMAIN_2 For improved reliability, customers should
	// configure a pair of attachments, one per availability domain. The
	// selected availability domain will be provided to the Partner via the
	// pairing key, so that the provisioned circuit will lie in the
	// specified domain. If not specified, the value will default to
	// AVAILABILITY_DOMAIN_ANY.
	//
	// Possible values:
	//   "AVAILABILITY_DOMAIN_1"
	//   "AVAILABILITY_DOMAIN_2"
	//   "AVAILABILITY_DOMAIN_ANY"
	EdgeAvailabilityDomain string `json:"edgeAvailabilityDomain,omitempty"`

	// Encryption: Indicates the user-supplied encryption option of this
	// interconnect attachment:
	// - NONE is the default value, which means that the attachment carries
	// unencrypted traffic. VMs can send traffic to, or receive traffic
	// from, this type of attachment.
	// - IPSEC indicates that the attachment carries only traffic encrypted
	// by an IPsec device such as an HA VPN gateway. VMs cannot directly
	// send traffic to, or receive traffic from, such an attachment. To use
	// IPsec-encrypted Cloud Interconnect, create the attachment using this
	// option.
	//
	// Possible values:
	//   "IPSEC"
	//   "NONE"
	Encryption string `json:"encryption,omitempty"`

	// GoogleReferenceId: [Output Only] Google reference ID, to be used when
	// raising support tickets with Google or otherwise to debug backend
	// connectivity issues. [Deprecated] This field is not used.
	GoogleReferenceId string `json:"googleReferenceId,omitempty"`

	// Id: [Output Only] The unique identifier for the resource. This
	// identifier is defined by the server.
	Id uint64 `json:"id,omitempty,string"`

	// Interconnect: URL of the underlying Interconnect object that this
	// attachment's traffic will traverse through.
	Interconnect string `json:"interconnect,omitempty"`

	// IpsecInternalAddresses: URL of addresses that have been reserved for
	// the interconnect attachment, Used only for interconnect attachment
	// that has the encryption option as IPSEC. The addresses must be RFC
	// 1918 IP address ranges. When creating HA VPN gateway over the
	// interconnect attachment, if the attachment is configured to use an
	// RFC 1918 IP address, then the VPN gateway?s IP address will be
	// allocated from the IP address range specified here. For example, if
	// the HA VPN gateway?s interface 0 is paired to this interconnect
	// attachment, then an RFC 1918 IP address for the VPN gateway interface
	// 0 will be allocated from the IP address specified for this
	// interconnect attachment. If this field is not specified for
	// interconnect attachment that has encryption option as IPSEC, later on
	// when creating HA VPN gateway on this interconnect attachment, the HA
	// VPN gateway's IP address will be allocated from regional external IP
	// address pool.
	IpsecInternalAddresses []string `json:"ipsecInternalAddresses,omitempty"`

	// Kind: [Output Only] Type of the resource. Always
	// compute#interconnectAttachment for interconnect attachments.
	Kind string `json:"kind,omitempty"`

	// LabelFingerprint: A fingerprint for the labels being applied to this
	// InterconnectAttachment, which is essentially a hash of the labels set
	// used for optimistic locking. The fingerprint is initially generated
	// by Compute Engine and changes after every request to modify or update
	// labels. You must always provide an up-to-date fingerprint hash in
	// order to update or change labels, otherwise the request will fail
	// with error 412 conditionNotMet.
	//
	// To see the latest fingerprint, make a get() request to retrieve an
	// InterconnectAttachment.
	LabelFingerprint string `json:"labelFingerprint,omitempty"`

	// Labels: Labels for this resource. These can only be added or modified
	// by the setLabels method. Each label key/value pair must comply with
	// RFC1035. Label values may be empty.
	Labels map[string]string `json:"labels,omitempty"`

	// Mtu: Maximum Transmission Unit (MTU), in bytes, of packets passing
	// through this interconnect attachment. Only 1440 and 1500 are allowed.
	// If not specified, the value will default to 1440.
	Mtu int64 `json:"mtu,omitempty"`

	// Name: Name of the resource. Provided by the client when the resource
	// is created. The name must be 1-63 characters long, and comply with
	// RFC1035. Specifically, the name must be 1-63 characters long and
	// match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means
	// the first character must be a lowercase letter, and all following
	// characters must be a dash, lowercase letter, or digit, except the
	// last character, which cannot be a dash.
	Name string `json:"name,omitempty"`

	// OperationalStatus: [Output Only] The current status of whether or not
	// this interconnect attachment is functional, which can take one of the
	// following values:
	// - OS_ACTIVE: The attachment has been turned up and is ready to use.
	//
	// - OS_UNPROVISIONED: The attachment is not ready to use yet, because
	// turnup is not complete.
	//
	// Possible values:
	//   "OS_ACTIVE"
	//   "OS_UNPROVISIONED"
	OperationalStatus string `json:"operationalStatus,omitempty"`

	// PairingKey: [Output only for type PARTNER. Input only for
	// PARTNER_PROVIDER. Not present for DEDICATED]. The opaque identifier
	// of an PARTNER attachment used to initiate provisioning with a
	// selected partner. Of the form "XXXXX/region/domain"
	PairingKey string `json:"pairingKey,omitempty"`

	// PartnerAsn: Optional BGP ASN for the router supplied by a Layer 3
	// Partner if they configured BGP on behalf of the customer. Output only
	// for PARTNER type, input only for PARTNER_PROVIDER, not available for
	// DEDICATED.
	PartnerAsn int64 `json:"partnerAsn,omitempty,string"`

	// PartnerMetadata: Informational metadata about Partner attachments
	// from Partners to display to customers. Output only for for PARTNER
	// type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
	PartnerMetadata *InterconnectAttachmentPartnerMetadata `json:"partnerMetadata,omitempty"`

	// PrivateInterconnectInfo: [Output Only] Information specific to an
	// InterconnectAttachment. This property is populated if the
	// interconnect that this is attached to is of type DEDICATED.
	PrivateInterconnectInfo *InterconnectAttachmentPrivateInfo `json:"privateInterconnectInfo,omitempty"`

	// Region: [Output Only] URL of the region where the regional
	// interconnect attachment resides. You must specify this field as part
	// of the HTTP request URL. It is not settable as a field in the request
	// body.
	Region string `json:"region,omitempty"`

	// Router: URL of the Cloud Router to be used for dynamic routing. This
	// router must be in the same region as this InterconnectAttachment. The
	// InterconnectAttachment will automatically connect the Interconnect to
	// the network & region within which the Cloud Router is configured.
	Router string `json:"router,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for the resource.
	SelfLink string `json:"selfLink,omitempty"`

	// SelfLinkWithId: [Output Only] Server-defined URL for this resource
	// with the resource id.
	SelfLinkWithId string `json:"selfLinkWithId,omitempty"`

	// State: [Output Only] The current state of this attachment's
	// functionality. Enum values ACTIVE and UNPROVISIONED are shared by
	// DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect
	// attachments, while enum values PENDING_PARTNER,
	// PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only
	// PARTNER and PARTNER_PROVIDER interconnect attachments. This state can
	// take one of the following values:
	// - ACTIVE: The attachment has been turned up and is ready to use.
	// - UNPROVISIONED: The attachment is not ready to use yet, because
	// turnup is not complete.
	// - PENDING_PARTNER: A newly-created PARTNER attachment that has not
	// yet been configured on the Partner side.
	// - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of
	// provisioning after a PARTNER_PROVIDER attachment was created that
	// references it.
	// - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is
	// waiting for a customer to activate it.
	// - DEFUNCT: The attachment was deleted externally and is no longer
	// functional. This could be because the associated Interconnect was
	// removed, or because the other side of a Partner attachment was
	// deleted.
	//
	// Possible values:
	//   "ACTIVE"
	//   "DEFUNCT"
	//   "PARTNER_REQUEST_RECEIVED"
	//   "PENDING_CUSTOMER"
	//   "PENDING_PARTNER"
	//   "STATE_UNSPECIFIED"
	//   "UNPROVISIONED"
	State string `json:"state,omitempty"`

	// Type: The type of interconnect attachment this is, which can take one
	// of the following values:
	// - DEDICATED: an attachment to a Dedicated Interconnect.
	// - PARTNER: an attachment to a Partner Interconnect, created by the
	// customer.
	// - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created
	// by the partner.
	//
	// Possible values:
	//   "DEDICATED"
	//   "PARTNER"
	//   "PARTNER_PROVIDER"
	Type string `json:"type,omitempty"`

	// VlanTag8021q: The IEEE 802.1Q VLAN tag for this attachment, in the
	// range 2-4094. Only specified at creation time.
	VlanTag8021q int64 `json:"vlanTag8021q,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AdminEnabled") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdminEnabled") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InterconnectAttachment) MarshalJSON() ([]byte, error) {
	type NoMethod InterconnectAttachment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InterconnectAttachmentAggregatedList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of InterconnectAttachmentsScopedList resources.
	Items map[string]InterconnectAttachmentsScopedList `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#interconnectAttachmentAggregatedList for aggregated lists of
	// interconnect attachments.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Unreachables: [Output Only] Unreachable resources.
	Unreachables []string `json:"unreachables,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *InterconnectAttachmentAggregatedListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InterconnectAttachmentAggregatedList) MarshalJSON() ([]byte, error) {
	type NoMethod InterconnectAttachmentAggregatedList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InterconnectAttachmentAggregatedListWarning: [Output Only]
// Informational warning message.
type InterconnectAttachmentAggregatedListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*InterconnectAttachmentAggregatedListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InterconnectAttachmentAggregatedListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod InterconnectAttachmentAggregatedListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InterconnectAttachmentAggregatedListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InterconnectAttachmentAggregatedListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod InterconnectAttachmentAggregatedListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InterconnectAttachmentList: Response to the list request, and
// contains a list of interconnect attachments.
type InterconnectAttachmentList struct {
	// Id: [Output Only] Unique identifier for the resource; defined by the
	// server.
	Id string `json:"id,omitempty"`

	// Items: A list of InterconnectAttachment resources.
	Items []*InterconnectAttachment `json:"items,omitempty"`

	// Kind: [Output Only] Type of resource. Always
	// compute#interconnectAttachmentList for lists of interconnect
	// attachments.
	Kind string `json:"kind,omitempty"`

	// NextPageToken: [Output Only] This token allows you to get the next
	// page of results for list requests. If the number of results is larger
	// than maxResults, use the nextPageToken as a value for the query
	// parameter pageToken in the next list request. Subsequent list
	// requests will have their own nextPageToken to continue paging through
	// the results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SelfLink: [Output Only] Server-defined URL for this resource.
	SelfLink string `json:"selfLink,omitempty"`

	// Warning: [Output Only] Informational warning message.
	Warning *InterconnectAttachmentListWarning `json:"warning,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InterconnectAttachmentList) MarshalJSON() ([]byte, error) {
	type NoMethod InterconnectAttachmentList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InterconnectAttachmentListWarning: [Output Only] Informational
// warning message.
type InterconnectAttachmentListWarning struct {
	// Code: [Output Only] A warning code, if applicable. For example,
	// Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in
	// the response.
	//
	// Possible values:
	//   "CLEANUP_FAILED"
	//   "DEPRECATED_RESOURCE_USED"
	//   "DEPRECATED_TYPE_USED"
	//   "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"
	//   "EXPERIMENTAL_TYPE_USED"
	//   "EXTERNAL_API_WARNING"
	//   "FIELD_VALUE_OVERRIDEN"
	//   "INJECTED_KERNELS_DEPRECATED"
	//   "LARGE_DEPLOYMENT_WARNING"
	//   "MISSING_TYPE_DEPENDENCY"
	//   "NEXT_HOP_ADDRESS_NOT_ASSIGNED"
	//   "NEXT_HOP_CANNOT_IP_FORWARD"
	//   "NEXT_HOP_INSTANCE_NOT_FOUND"
	//   "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"
	//   "NEXT_HOP_NOT_RUNNING"
	//   "NOT_CRITICAL_ERROR"
	//   "NO_RESULTS_ON_PAGE"
	//   "PARTIAL_SUCCESS"
	//   "REQUIRED_TOS_AGREEMENT"
	//   "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"
	//   "RESOURCE_NOT_DELETED"
	//   "SCHEMA_VALIDATION_IGNORED"
	//   "SINGLE_INSTANCE_PROPERTY_TEMPLATE"
	//   "UNDECLARED_PROPERTIES"
	//   "UNREACHABLE"
	Code string `json:"code,omitempty"`

	// Data: [Output Only] Metadata about this warning in key: value format.
	// For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*InterconnectAttachmentListWarningData `json:"data,omitempty"`

	// Message: [Output Only] A human-readable description of the warning
	// code.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InterconnectAttachmentListWarning) MarshalJSON() ([]byte, error) {
	type NoMethod InterconnectAttachmentListWarning
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type InterconnectAttachmentListWarningData struct {
	// Key: [Output Only] A key that provides more detail on the warning
	// being returned. For example, for warnings where there are no results
	// in a list request for a particular zone, this key might be scope and
	// the key value might be the zone name. Other examples might be a key
	// indicating a deprecated resource and a suggested replacement, or a
	// warning about invalid network settings (for example, if an instance
	// attempts to perform IP forwarding but is not enabled for IP
	// forwarding).
	Key string `json:"key,omitempty"`

	// Value: [Output Only] A warning data value corresponding to the key.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InterconnectAttachmentListWarningData) MarshalJSON() ([]byte, error) {
	type NoMethod InterconnectAttachmentListWarningData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InterconnectAttachmentPartnerMetadata: Informational metadata about
// Partner attachments from Partners to display to customers. These
// fields are propagated from PARTNER_PROVIDER attachments to their
// corresponding PARTNER attachments.
type InterconnectAttachmentPartnerMetadata struct {
	// InterconnectName: Plain text name of the Interconnect this attachment
	// is connected to, as displayed in the Partner's portal. For instance
	// "Chicago 1". This value may be validated to match approved Partner
	// values.
	InterconnectName string `json:"interconnectName,omitempty"`

	// PartnerName: Plain text name of the Partner providing this
	// attachment. This value may be validated to match approved Partner
	// values.
	PartnerName string `json:"partnerName,omitempty"`

	// PortalUrl: URL of the Partner's portal for this Attachment. Partners
	// may customise this to be a deep link to the specific resource on the
	// Partner portal. This value may be validated to match approved Partner
	// values.
	PortalUrl string `json:"portalUrl,omitempty"`

	// ForceSendFields is a list of field names (e.g. "InterconnectName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InterconnectName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InterconnectAttachmentPartnerMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod InterconnectAttachmentPartnerMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJ