// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0-devel
// 	protoc        v3.13.0
// source: google/cloud/resourcesettings/v1/resource_settings.proto

package resourcesettings

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// The data type for setting values of this setting. See [Value][google.cloud.resourcesettings.v1.Value] for more
// details on the available data types.
type Setting_DataType int32

const (
	// Unspecified data type.
	Setting_DATA_TYPE_UNSPECIFIED Setting_DataType = 0
	// A boolean setting.
	Setting_BOOLEAN Setting_DataType = 1
	// A string setting.
	Setting_STRING Setting_DataType = 2
	// A string set setting.
	Setting_STRING_SET Setting_DataType = 3
	// A Enum setting
	Setting_ENUM_VALUE Setting_DataType = 4
)

// Enum value maps for Setting_DataType.
var (
	Setting_DataType_name = map[int32]string{
		0: "DATA_TYPE_UNSPECIFIED",
		1: "BOOLEAN",
		2: "STRING",
		3: "STRING_SET",
		4: "ENUM_VALUE",
	}
	Setting_DataType_value = map[string]int32{
		"DATA_TYPE_UNSPECIFIED": 0,
		"BOOLEAN":               1,
		"STRING":                2,
		"STRING_SET":            3,
		"ENUM_VALUE":            4,
	}
)

func (x Setting_DataType) Enum() *Setting_DataType {
	p := new(Setting_DataType)
	*p = x
	return p
}

func (x Setting_DataType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Setting_DataType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_resourcesettings_v1_resource_settings_proto_enumTypes[0].Descriptor()
}

func (Setting_DataType) Type() protoreflect.EnumType {
	return &file_google_cloud_resourcesettings_v1_resource_settings_proto_enumTypes[0]
}

func (x Setting_DataType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Setting_DataType.Descriptor instead.
func (Setting_DataType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescGZIP(), []int{1, 0}
}

// The instantiation of a setting. Every setting value is parented by its
// corresponding setting.
type SettingValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the setting value. Must be in one of the following
	// forms:
	//
	// * `projects/{project_number}/settings/{setting_name}/value`
	// * `folders/{folder_id}/settings/{setting_name}/value`
	// * `organizations/{organization_id}/settings/{setting_name}/value`
	//
	// For example, "/projects/123/settings/gcp-enableMyFeature/value"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The value of the setting. The data type of [Value][google.cloud.resourcesettings.v1.Value] must always be
	// consistent with the data type defined by the parent setting.
	Value *Value `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// A fingerprint used for optimistic concurrency. See
	// [UpdateSettingValue][google.cloud.resourcesettings.v1.ResourceSettingsService.UpdateSettingValue] for more
	// details.
	Etag string `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
	// Output only. A flag indicating that this setting value cannot be modified.
	// This flag is inherited from its parent setting and is for
	// convenience purposes. See [Setting.read_only][google.cloud.resourcesettings.v1.Setting.read_only] for more details.
	ReadOnly bool `protobuf:"varint,4,opt,name=read_only,json=readOnly,proto3" json:"read_only,omitempty"`
	// Output only. The timestamp indicating when the setting value was last
	// updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *SettingValue) Reset() {
	*x = SettingValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SettingValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SettingValue) ProtoMessage() {}

func (x *SettingValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SettingValue.ProtoReflect.Descriptor instead.
func (*SettingValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescGZIP(), []int{0}
}

func (x *SettingValue) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SettingValue) GetValue() *Value {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *SettingValue) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *SettingValue) GetReadOnly() bool {
	if x != nil {
		return x.ReadOnly
	}
	return false
}

func (x *SettingValue) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// The schema for setting values. At a given Cloud resource, a setting can
// parent at most one setting value.
type Setting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the setting. Must be in one of the following forms:
	//
	// * `projects/{project_number}/settings/{setting_name}`
	// * `folders/{folder_id}/settings/{setting_name}`
	// * `organizations/{organization_id}/settings/{setting_name}`
	//
	// For example, "/projects/123/settings/gcp-enableMyFeature"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The human readable name for this setting.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// A detailed description of what this setting does.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// A flag indicating that values of this setting cannot be modified (see
	// documentation of the specific setting for updates and reasons).
	ReadOnly bool `protobuf:"varint,4,opt,name=read_only,json=readOnly,proto3" json:"read_only,omitempty"`
	// The data type for this setting.
	DataType Setting_DataType `protobuf:"varint,5,opt,name=data_type,json=dataType,proto3,enum=google.cloud.resourcesettings.v1.Setting_DataType" json:"data_type,omitempty"`
	// The value received by
	// [LookupEffectiveSettingValue][google.cloud.resourcesettings.v1.ResourceSettingsService.LookupEffectiveSettingValue]
	// if no setting value is explicitly set.
	//
	// Note: not all settings have a default value.
	DefaultValue *Value `protobuf:"bytes,6,opt,name=default_value,json=defaultValue,proto3" json:"default_value,omitempty"`
}

func (x *Setting) Reset() {
	*x = Setting{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Setting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Setting) ProtoMessage() {}

func (x *Setting) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Setting.ProtoReflect.Descriptor instead.
func (*Setting) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescGZIP(), []int{1}
}

func (x *Setting) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Setting) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Setting) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Setting) GetReadOnly() bool {
	if x != nil {
		return x.ReadOnly
	}
	return false
}

func (x *Setting) GetDataType() Setting_DataType {
	if x != nil {
		return x.DataType
	}
	return Setting_DATA_TYPE_UNSPECIFIED
}

func (x *Setting) GetDefaultValue() *Value {
	if x != nil {
		return x.DefaultValue
	}
	return nil
}

// The data in a setting value.
type Value struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Selects the data type and associated value.
	//
	// Types that are assignable to Value:
	//	*Value_BooleanValue
	//	*Value_StringValue
	//	*Value_StringSetValue
	//	*Value_EnumValue_
	Value isValue_Value `protobuf_oneof:"value"`
}

func (x *Value) Reset() {
	*x = Value{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Value) ProtoMessage() {}

func (x *Value) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Value.ProtoReflect.Descriptor instead.
func (*Value) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescGZIP(), []int{2}
}

func (m *Value) GetValue() isValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *Value) GetBooleanValue() bool {
	if x, ok := x.GetValue().(*Value_BooleanValue); ok {
		return x.BooleanValue
	}
	return false
}

func (x *Value) GetStringValue() string {
	if x, ok := x.GetValue().(*Value_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (x *Value) GetStringSetValue() *Value_StringSet {
	if x, ok := x.GetValue().(*Value_StringSetValue); ok {
		return x.StringSetValue
	}
	return nil
}

func (x *Value) GetEnumValue() *Value_EnumValue {
	if x, ok := x.GetValue().(*Value_EnumValue_); ok {
		return x.EnumValue
	}
	return nil
}

type isValue_Value interface {
	isValue_Value()
}

type Value_BooleanValue struct {
	// Defines this value as being a boolean value.
	BooleanValue bool `protobuf:"varint,1,opt,name=boolean_value,json=booleanValue,proto3,oneof"`
}

type Value_StringValue struct {
	// Defines this value as being a string value.
	StringValue string `protobuf:"bytes,2,opt,name=string_value,json=stringValue,proto3,oneof"`
}

type Value_StringSetValue struct {
	// Defines this value as being a StringSet.
	StringSetValue *Value_StringSet `protobuf:"bytes,3,opt,name=string_set_value,json=stringSetValue,proto3,oneof"`
}

type Value_EnumValue_ struct {
	// Defines this value as being a Enum.
	EnumValue *Value_EnumValue `protobuf:"bytes,4,opt,name=enum_value,json=enumValue,proto3,oneof"`
}

func (*Value_BooleanValue) isValue_Value() {}

func (*Value_StringValue) isValue_Value() {}

func (*Value_StringSetValue) isValue_Value() {}

func (*Value_EnumValue_) isValue_Value() {}

// The request for ListSettings.
type ListSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Cloud resource that parents the setting. Must be in one of the
	// following forms:
	//
	// * `projects/{project_number}`
	// * `projects/{project_id}`
	// * `folders/{folder_id}`
	// * `organizations/{organization_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Unused. The size of the page to be returned.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Unused. A page token used to retrieve the next page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListSettingsRequest) Reset() {
	*x = ListSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSettingsRequest) ProtoMessage() {}

func (x *ListSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSettingsRequest.ProtoReflect.Descriptor instead.
func (*ListSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescGZIP(), []int{3}
}

func (x *ListSettingsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSettingsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSettingsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response from ListSettings.
type ListSettingsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of settings that are available at the specified Cloud resource.
	Settings []*Setting `protobuf:"bytes,1,rep,name=settings,proto3" json:"settings,omitempty"`
	// Unused. A page token used to retrieve the next page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSettingsResponse) Reset() {
	*x = ListSettingsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSettingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSettingsResponse) ProtoMessage() {}

func (x *ListSettingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSettingsResponse.ProtoReflect.Descriptor instead.
func (*ListSettingsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescGZIP(), []int{4}
}

func (x *ListSettingsResponse) GetSettings() []*Setting {
	if x != nil {
		return x.Settings
	}
	return nil
}

func (x *ListSettingsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for SearchSettingValues.
type SearchSettingValuesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Cloud resource that parents the setting. Must be in one of the
	// following forms:
	//
	// * `projects/{project_number}`
	// * `projects/{project_id}`
	// * `folders/{folder_id}`
	// * `organizations/{organization_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Unused. The size of the page to be returned.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Unused. A page token used to retrieve the next page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *SearchSettingValuesRequest) Reset() {
	*x = SearchSettingValuesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchSettingValuesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchSettingValuesRequest) ProtoMessage() {}

func (x *SearchSettingValuesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchSettingValuesRequest.ProtoReflect.Descriptor instead.
func (*SearchSettingValuesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescGZIP(), []int{5}
}

func (x *SearchSettingValuesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *SearchSettingValuesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchSettingValuesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response from SearchSettingValues.
type SearchSettingValuesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// All setting values that exist on the specified Cloud resource.
	SettingValues []*SettingValue `protobuf:"bytes,1,rep,name=setting_values,json=settingValues,proto3" json:"setting_values,omitempty"`
	// Unused. A page token used to retrieve the next page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchSettingValuesResponse) Reset() {
	*x = SearchSettingValuesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchSettingValuesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchSettingValuesResponse) ProtoMessage() {}

func (x *SearchSettingValuesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchSettingValuesResponse.ProtoReflect.Descriptor instead.
func (*SearchSettingValuesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescGZIP(), []int{6}
}

func (x *SearchSettingValuesResponse) GetSettingValues() []*SettingValue {
	if x != nil {
		return x.SettingValues
	}
	return nil
}

func (x *SearchSettingValuesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for GetSettingValue.
type GetSettingValueRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the setting value to get. See [SettingValue][google.cloud.resourcesettings.v1.SettingValue] for naming
	// requirements.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSettingValueRequest) Reset() {
	*x = GetSettingValueRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSettingValueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSettingValueRequest) ProtoMessage() {}

func (x *GetSettingValueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSettingValueRequest.ProtoReflect.Descriptor instead.
func (*GetSettingValueRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescGZIP(), []int{7}
}

func (x *GetSettingValueRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for LookupEffectiveSettingValue.
type LookupEffectiveSettingValueRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The setting value for which an effective value will be evaluated.
	// See [SettingValue][google.cloud.resourcesettings.v1.SettingValue] for naming requirements.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *LookupEffectiveSettingValueRequest) Reset() {
	*x = LookupEffectiveSettingValueRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LookupEffectiveSettingValueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LookupEffectiveSettingValueRequest) ProtoMessage() {}

func (x *LookupEffectiveSettingValueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LookupEffectiveSettingValueRequest.ProtoReflect.Descriptor instead.
func (*LookupEffectiveSettingValueRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescGZIP(), []int{8}
}

func (x *LookupEffectiveSettingValueRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for CreateSettingValue.
type CreateSettingValueRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the setting for which a value should be created.
	// See [Setting][google.cloud.resourcesettings.v1.Setting] for naming requirements.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The setting value to create. See [SettingValue][google.cloud.resourcesettings.v1.SettingValue] for field requirements.
	SettingValue *SettingValue `protobuf:"bytes,2,opt,name=setting_value,json=settingValue,proto3" json:"setting_value,omitempty"`
}

func (x *CreateSettingValueRequest) Reset() {
	*x = CreateSettingValueRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSettingValueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSettingValueRequest) ProtoMessage() {}

func (x *CreateSettingValueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSettingValueRequest.ProtoReflect.Descriptor instead.
func (*CreateSettingValueRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescGZIP(), []int{9}
}

func (x *CreateSettingValueRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSettingValueRequest) GetSettingValue() *SettingValue {
	if x != nil {
		return x.SettingValue
	}
	return nil
}

// The request for UpdateSettingValue.
type UpdateSettingValueRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The setting value to update. See [SettingValue][google.cloud.resourcesettings.v1.SettingValue] for field requirements.
	SettingValue *SettingValue `protobuf:"bytes,1,opt,name=setting_value,json=settingValue,proto3" json:"setting_value,omitempty"`
}

func (x *UpdateSettingValueRequest) Reset() {
	*x = UpdateSettingValueRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSettingValueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSettingValueRequest) ProtoMessage() {}

func (x *UpdateSettingValueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSettingValueRequest.ProtoReflect.Descriptor instead.
func (*UpdateSettingValueRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescGZIP(), []int{10}
}

func (x *UpdateSettingValueRequest) GetSettingValue() *SettingValue {
	if x != nil {
		return x.SettingValue
	}
	return nil
}

// The request for DeleteSettingValue.
type DeleteSettingValueRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the setting value to delete. See [SettingValue][google.cloud.resourcesettings.v1.SettingValue] for naming
	// requirements.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteSettingValueRequest) Reset() {
	*x = DeleteSettingValueRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSettingValueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSettingValueRequest) ProtoMessage() {}

func (x *DeleteSettingValueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSettingValueRequest.ProtoReflect.Descriptor instead.
func (*DeleteSettingValueRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescGZIP(), []int{11}
}

func (x *DeleteSettingValueRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A string set value that can hold a set of strings. The maximum length of
// each string is 60 characters and there can be a maximum of 50 strings in
// the string set.
type Value_StringSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The strings in the set
	Values []string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *Value_StringSet) Reset() {
	*x = Value_StringSet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Value_StringSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Value_StringSet) ProtoMessage() {}

func (x *Value_StringSet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Value_StringSet.ProtoReflect.Descriptor instead.
func (*Value_StringSet) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescGZIP(), []int{2, 0}
}

func (x *Value_StringSet) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

// A enum value that can hold any enum type setting values.
// Each enum type is represented by a number, this representation
// is stored in the definitions.
type Value_EnumValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Value_EnumValue) Reset() {
	*x = Value_EnumValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Value_EnumValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Value_EnumValue) ProtoMessage() {}

func (x *Value_EnumValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Value_EnumValue.ProtoReflect.Descriptor instead.
func (*Value_EnumValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescGZIP(), []int{2, 1}
}

func (x *Value_EnumValue) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

var File_google_cloud_resourcesettings_v1_resource_settings_proto protoreflect.FileDescriptor

var file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDesc = []byte{
	0x0a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f,
	0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb3, 0x03,
	0x0a, 0x0c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x3d, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x20, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6f, 0x6e,
	0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x72,
	0x65, 0x61, 0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x3a, 0xd7, 0x01, 0xea, 0x41, 0xd3, 0x01,
	0x0a, 0x2c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x37,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x7d, 0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x7d, 0x2f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2e, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73,
	0x2f, 0x7b, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x7d, 0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x7d, 0x2f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x3a, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x7d, 0x2f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x22, 0xc1, 0x04, 0x0a, 0x07, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64,
	0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x72, 0x65, 0x61,
	0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x4f, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x64, 0x61,
	0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4c, 0x0a, 0x0d, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x22, 0x5e, 0x0a, 0x08, 0x44, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x19, 0x0a, 0x15, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x42,
	0x4f, 0x4f, 0x4c, 0x45, 0x41, 0x4e, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x52, 0x49,
	0x4e, 0x47, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x54, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x53,
	0x45, 0x54, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x45, 0x4e, 0x55, 0x4d, 0x5f, 0x56, 0x41, 0x4c,
	0x55, 0x45, 0x10, 0x04, 0x3a, 0xc0, 0x01, 0xea, 0x41, 0xbc, 0x01, 0x0a, 0x27, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x12, 0x31, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x7d, 0x2f,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x7d, 0x12, 0x28, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73,
	0x2f, 0x7b, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x7d, 0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x7d, 0x12, 0x34, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x7d, 0x22, 0xd7, 0x02, 0x0a, 0x05, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x25, 0x0a, 0x0d, 0x62, 0x6f, 0x6f, 0x6c, 0x65, 0x61, 0x6e, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0c, 0x62, 0x6f, 0x6f, 0x6c,
	0x65, 0x61, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x73, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00,
	0x52, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x5d, 0x0a,
	0x10, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x48, 0x00, 0x52, 0x0e, 0x73, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x52, 0x0a, 0x0a,
	0x65, 0x6e, 0x75, 0x6d, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x45, 0x6e, 0x75, 0x6d, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x09, 0x65, 0x6e, 0x75, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x1a, 0x23, 0x0a, 0x09, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x12, 0x16, 0x0a,
	0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0x21, 0x0a, 0x09, 0x45, 0x6e, 0x75, 0x6d, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x22, 0x74, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x09, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x03,
	0x0a, 0x01, 0x2a, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x85, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x45, 0x0a, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x08, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x75, 0x0a, 0x1a, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x9c, 0x01, 0x0a, 0x1b, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x55, 0x0a, 0x0e, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x62, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x48, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x3d, 0x0a, 0x22, 0x4c, 0x6f, 0x6f,
	0x6b, 0x75, 0x70, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbe, 0x01, 0x0a, 0x19, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x58, 0x0a, 0x0d, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x75, 0x0a, 0x19, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x58, 0x0a, 0x0d, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0c, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x22, 0x65, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x32, 0xb7, 0x11, 0x0a, 0x17, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x12, 0xfc, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x7d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6e, 0x12, 0x25, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x5a, 0x21, 0x12, 0x1f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x5a, 0x22, 0x12, 0x20, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x9f, 0x02, 0x0a, 0x13, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x8a, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x83,
	0x01, 0x12, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5a,
	0x28, 0x12, 0x26, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5a, 0x29, 0x12, 0x27, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x3a, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x12, 0x8c, 0x02, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x22, 0x8e, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x80, 0x01, 0x12, 0x2b, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x2f, 0x2a, 0x2f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x7d, 0x5a, 0x27, 0x12, 0x25, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x7d, 0x5a, 0x28, 0x12, 0x26, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x7d, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0xdc, 0x02, 0x0a, 0x1b, 0x4c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x45, 0x66,
	0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x45, 0x66, 0x66,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xc6, 0x01, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0xbf, 0x01, 0x12, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x7d,
	0x3a, 0x6c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x5a, 0x3c, 0x12, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x7d, 0x3a, 0x6c,
	0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x5a, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x7d, 0x3a, 0x6c, 0x6f,
	0x6f, 0x6b, 0x75, 0x70, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0xd5, 0x02, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xd1, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xb3, 0x01,
	0x22, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x0d, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5a, 0x38,
	0x22, 0x27, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x0d, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5a, 0x39, 0x22, 0x28, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x0d, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0xda, 0x41, 0x14, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0xe2, 0x02, 0x0a, 0x12, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xde,
	0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xd7, 0x01, 0x32, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x7d, 0x3a, 0x0d, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x5a, 0x44, 0x32, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x2f, 0x2a, 0x2f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x7d, 0x3a, 0x0d, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5a, 0x45, 0x32, 0x34, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x7d,
	0x3a, 0x0d, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0xfa, 0x01, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x8e, 0x01, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x80, 0x01, 0x2a, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x7d, 0x5a, 0x27, 0x2a, 0x25, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x7d, 0x5a, 0x28, 0x2a, 0x26, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0x53, 0xca, 0x41,
	0x1f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x42, 0x94, 0x01, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x15, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x50, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61,
	0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x2f, 0x76, 0x31, 0x3b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0xf8, 0x01, 0x01, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescOnce sync.Once
	file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescData = file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDesc
)

func file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescGZIP() []byte {
	file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescOnce.Do(func() {
		file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescData)
	})
	return file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescData
}

var file_google_cloud_resourcesettings_v1_resource_settings_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_google_cloud_resourcesettings_v1_resource_settings_proto_goTypes = []interface{}{
	(Setting_DataType)(0),                      // 0: google.cloud.resourcesettings.v1.Setting.DataType
	(*SettingValue)(nil),                       // 1: google.cloud.resourcesettings.v1.SettingValue
	(*Setting)(nil),                            // 2: google.cloud.resourcesettings.v1.Setting
	(*Value)(nil),                              // 3: google.cloud.resourcesettings.v1.Value
	(*ListSettingsRequest)(nil),                // 4: google.cloud.resourcesettings.v1.ListSettingsRequest
	(*ListSettingsResponse)(nil),               // 5: google.cloud.resourcesettings.v1.ListSettingsResponse
	(*SearchSettingValuesRequest)(nil),         // 6: google.cloud.resourcesettings.v1.SearchSettingValuesRequest
	(*SearchSettingValuesResponse)(nil),        // 7: google.cloud.resourcesettings.v1.SearchSettingValuesResponse
	(*GetSettingValueRequest)(nil),             // 8: google.cloud.resourcesettings.v1.GetSettingValueRequest
	(*LookupEffectiveSettingValueRequest)(nil), // 9: google.cloud.resourcesettings.v1.LookupEffectiveSettingValueRequest
	(*CreateSettingValueRequest)(nil),          // 10: google.cloud.resourcesettings.v1.CreateSettingValueRequest
	(*UpdateSettingValueRequest)(nil),          // 11: google.cloud.resourcesettings.v1.UpdateSettingValueRequest
	(*DeleteSettingValueRequest)(nil),          // 12: google.cloud.resourcesettings.v1.DeleteSettingValueRequest
	(*Value_StringSet)(nil),                    // 13: google.cloud.resourcesettings.v1.Value.StringSet
	(*Value_EnumValue)(nil),                    // 14: google.cloud.resourcesettings.v1.Value.EnumValue
	(*timestamppb.Timestamp)(nil),              // 15: google.protobuf.Timestamp
	(*emptypb.Empty)(nil),                      // 16: google.protobuf.Empty
}
var file_google_cloud_resourcesettings_v1_resource_settings_proto_depIdxs = []int32{
	3,  // 0: google.cloud.resourcesettings.v1.SettingValue.value:type_name -> google.cloud.resourcesettings.v1.Value
	15, // 1: google.cloud.resourcesettings.v1.SettingValue.update_time:type_name -> google.protobuf.Timestamp
	0,  // 2: google.cloud.resourcesettings.v1.Setting.data_type:type_name -> google.cloud.resourcesettings.v1.Setting.DataType
	3,  // 3: google.cloud.resourcesettings.v1.Setting.default_value:type_name -> google.cloud.resourcesettings.v1.Value
	13, // 4: google.cloud.resourcesettings.v1.Value.string_set_value:type_name -> google.cloud.resourcesettings.v1.Value.StringSet
	14, // 5: google.cloud.resourcesettings.v1.Value.enum_value:type_name -> google.cloud.resourcesettings.v1.Value.EnumValue
	2,  // 6: google.cloud.resourcesettings.v1.ListSettingsResponse.settings:type_name -> google.cloud.resourcesettings.v1.Setting
	1,  // 7: google.cloud.resourcesettings.v1.SearchSettingValuesResponse.setting_values:type_name -> google.cloud.resourcesettings.v1.SettingValue
	1,  // 8: google.cloud.resourcesettings.v1.CreateSettingValueRequest.setting_value:type_name -> google.cloud.resourcesettings.v1.SettingValue
	1,  // 9: google.cloud.resourcesettings.v1.UpdateSettingValueRequest.setting_value:type_name -> google.cloud.resourcesettings.v1.SettingValue
	4,  // 10: google.cloud.resourcesettings.v1.ResourceSettingsService.ListSettings:input_type -> google.cloud.resourcesettings.v1.ListSettingsRequest
	6,  // 11: google.cloud.resourcesettings.v1.ResourceSettingsService.SearchSettingValues:input_type -> google.cloud.resourcesettings.v1.SearchSettingValuesRequest
	8,  // 12: google.cloud.resourcesettings.v1.ResourceSettingsService.GetSettingValue:input_type -> google.cloud.resourcesettings.v1.GetSettingValueRequest
	9,  // 13: google.cloud.resourcesettings.v1.ResourceSettingsService.LookupEffectiveSettingValue:input_type -> google.cloud.resourcesettings.v1.LookupEffectiveSettingValueRequest
	10, // 14: google.cloud.resourcesettings.v1.ResourceSettingsService.CreateSettingValue:input_type -> google.cloud.resourcesettings.v1.CreateSettingValueRequest
	11, // 15: google.cloud.resourcesettings.v1.ResourceSettingsService.UpdateSettingValue:input_type -> google.cloud.resourcesettings.v1.UpdateSettingValueRequest
	12, // 16: google.cloud.resourcesettings.v1.ResourceSettingsService.DeleteSettingValue:input_type -> google.cloud.resourcesettings.v1.DeleteSettingValueRequest
	5,  // 17: google.cloud.resourcesettings.v1.ResourceSettingsService.ListSettings:output_type -> google.cloud.resourcesettings.v1.ListSettingsResponse
	7,  // 18: google.cloud.resourcesettings.v1.ResourceSettingsService.SearchSettingValues:output_type -> google.cloud.resourcesettings.v1.SearchSettingValuesResponse
	1,  // 19: google.cloud.resourcesettings.v1.ResourceSettingsService.GetSettingValue:output_type -> google.cloud.resourcesettings.v1.SettingValue
	1,  // 20: google.cloud.resourcesettings.v1.ResourceSettingsService.LookupEffectiveSettingValue:output_type -> google.cloud.resourcesettings.v1.SettingValue
	1,  // 21: google.cloud.resourcesettings.v1.ResourceSettingsService.CreateSettingValue:output_type -> google.cloud.resourcesettings.v1.SettingValue
	1,  // 22: google.cloud.resourcesettings.v1.ResourceSettingsService.UpdateSettingValue:output_type -> google.cloud.resourcesettings.v1.SettingValue
	16, // 23: google.cloud.resourcesettings.v1.ResourceSettingsService.DeleteSettingValue:output_type -> google.protobuf.Empty
	17, // [17:24] is the sub-list for method output_type
	10, // [10:17] is the sub-list for method input_type
	10, // [10:10] is the sub-list for extension type_name
	10, // [10:10] is the sub-list for extension extendee
	0,  // [0:10] is the sub-list for field type_name
}

func init() { file_google_cloud_resourcesettings_v1_resource_settings_proto_init() }
func file_google_cloud_resourcesettings_v1_resource_settings_proto_init() {
	if File_google_cloud_resourcesettings_v1_resource_settings_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SettingValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Setting); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Value); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSettingsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchSettingValuesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchSettingValuesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSettingValueRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LookupEffectiveSettingValueRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSettingValueRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSettingValueRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSettingValueRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Value_StringSet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Value_EnumValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*Value_BooleanValue)(nil),
		(*Value_StringValue)(nil),
		(*Value_StringSetValue)(nil),
		(*Value_EnumValue_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_resourcesettings_v1_resource_settings_proto_goTypes,
		DependencyIndexes: file_google_cloud_resourcesettings_v1_resource_settings_proto_depIdxs,
		EnumInfos:         file_google_cloud_resourcesettings_v1_resource_settings_proto_enumTypes,
		MessageInfos:      file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes,
	}.Build()
	File_google_cloud_resourcesettings_v1_resource_settings_proto = out.File
	file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDesc = nil
	file_google_cloud_resourcesettings_v1_resource_settings_proto_goTypes = nil
	file_google_cloud_resourcesettings_v1_resource_settings_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ResourceSettingsServiceClient is the client API for ResourceSettingsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ResourceSettingsServiceClient interface {
	// Lists all the settings that are available on the Cloud resource `parent`.
	ListSettings(ctx context.Context, in *ListSettingsRequest, opts ...grpc.CallOption) (*ListSettingsResponse, error)
	// Searches for all setting values that exist on the resource `parent`. The
	// setting values are not limited to those of a particular setting.
	SearchSettingValues(ctx context.Context, in *SearchSettingValuesRequest, opts ...grpc.CallOption) (*SearchSettingValuesResponse, error)
	// Gets a setting value.
	//
	// Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
	// setting value does not exist.
	GetSettingValue(ctx context.Context, in *GetSettingValueRequest, opts ...grpc.CallOption) (*SettingValue, error)
	// Computes the effective setting value of a setting at the Cloud resource
	// `parent`. The effective setting value is the calculated setting value at a
	// Cloud resource and evaluates to one of the following options in the given
	// order (the next option is used if the previous one does not exist):
	//
	// 1. the setting value on the given resource
	// 2. the setting value on the given resource's nearest ancestor
	// 3. the setting's default value
	// 4. an empty setting value, defined as a `SettingValue` with all fields
	// unset
	//
	// Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
	// setting does not exist.
	LookupEffectiveSettingValue(ctx context.Context, in *LookupEffectiveSettingValueRequest, opts ...grpc.CallOption) (*SettingValue, error)
	// Creates a setting value.
	//
	// Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
	// setting does not exist.
	// Returns a `google.rpc.Status` with `google.rpc.Code.ALREADY_EXISTS` if the
	// setting value already exists on the given Cloud resource.
	// Returns a `google.rpc.Status` with `google.rpc.Code.FAILED_PRECONDITION` if
	// the setting is flagged as read only.
	CreateSettingValue(ctx context.Context, in *CreateSettingValueRequest, opts ...grpc.CallOption) (*SettingValue, error)
	// Updates a setting value.
	//
	// Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
	// setting or the setting value does not exist.
	// Returns a `google.rpc.Status` with `google.rpc.Code.FAILED_PRECONDITION` if
	// the setting is flagged as read only.
	// Returns a `google.rpc.Status` with `google.rpc.Code.ABORTED` if the etag
	// supplied in the request does not match the persisted etag of the setting
	// value.
	//
	// Note: the supplied setting value will perform a full overwrite of all
	// fields.
	UpdateSettingValue(ctx context.Context, in *UpdateSettingValueRequest, opts ...grpc.CallOption) (*SettingValue, error)
	// Deletes a setting value. If the setting value does not exist, the operation
	// is a no-op.
	//
	// Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
	// setting or the setting value does not exist. The setting value will not
	// exist if a prior call to `DeleteSettingValue` for the setting value already
	// returned a success code.
	// Returns a `google.rpc.Status` with `google.rpc.Code.FAILED_PRECONDITION` if
	// the setting is flagged as read only.
	DeleteSettingValue(ctx context.Context, in *DeleteSettingValueRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type resourceSettingsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewResourceSettingsServiceClient(cc grpc.ClientConnInterface) ResourceSettingsServiceClient {
	return &resourceSettingsServiceClient{cc}
}

func (c *resourceSettingsServiceClient) ListSettings(ctx context.Context, in *ListSettingsRequest, opts ...grpc.CallOption) (*ListSettingsResponse, error) {
	out := new(ListSettingsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcesettings.v1.ResourceSettingsService/ListSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceSettingsServiceClient) SearchSettingValues(ctx context.Context, in *SearchSettingValuesRequest, opts ...grpc.CallOption) (*SearchSettingValuesResponse, error) {
	out := new(SearchSettingValuesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcesettings.v1.ResourceSettingsService/SearchSettingValues", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceSettingsServiceClient) GetSettingValue(ctx context.Context, in *GetSettingValueRequest, opts ...grpc.CallOption) (*SettingValue, error) {
	out := new(SettingValue)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcesettings.v1.ResourceSettingsService/GetSettingValue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceSettingsServiceClient) LookupEffectiveSettingValue(ctx context.Context, in *LookupEffectiveSettingValueRequest, opts ...grpc.CallOption) (*SettingValue, error) {
	out := new(SettingValue)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcesettings.v1.ResourceSettingsService/LookupEffectiveSettingValue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceSettingsServiceClient) CreateSettingValue(ctx context.Context, in *CreateSettingValueRequest, opts ...grpc.CallOption) (*SettingValue, error) {
	out := new(SettingValue)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcesettings.v1.ResourceSettingsService/CreateSettingValue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceSettingsServiceClient) UpdateSettingValue(ctx context.Context, in *UpdateSettingValueRequest, opts ...grpc.CallOption) (*SettingValue, error) {
	out := new(SettingValue)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcesettings.v1.ResourceSettingsService/UpdateSettingValue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceSettingsServiceClient) DeleteSettingValue(ctx context.Context, in *DeleteSettingValueRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcesettings.v1.ResourceSettingsService/DeleteSettingValue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ResourceSettingsServiceServer is the server API for ResourceSettingsService service.
type ResourceSettingsServiceServer interface {
	// Lists all the settings that are available on the Cloud resource `parent`.
	ListSettings(context.Context, *ListSettingsRequest) (*ListSettingsResponse, error)
	// Searches for all setting values that exist on the resource `parent`. The
	// setting values are not limited to those of a particular setting.
	SearchSettingValues(context.Context, *SearchSettingValuesRequest) (*SearchSettingValuesResponse, error)
	// Gets a setting value.
	//
	// Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
	// setting value does not exist.
	GetSettingValue(context.Context, *GetSettingValueRequest) (*SettingValue, error)
	// Computes the effective setting value of a setting at the Cloud resource
	// `parent`. The effective setting value is the calculated setting value at a
	// Cloud resource and evaluates to one of the following options in the given
	// order (the next option is used if the previous one does not exist):
	//
	// 1. the setting value on the given resource
	// 2. the setting value on the given resource's nearest ancestor
	// 3. the setting's default value
	// 4. an empty setting value, defined as a `SettingValue` with all fields
	// unset
	//
	// Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
	// setting does not exist.
	LookupEffectiveSettingValue(context.Context, *LookupEffectiveSettingValueRequest) (*SettingValue, error)
	// Creates a setting value.
	//
	// Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
	// setting does not exist.
	// Returns a `google.rpc.Status` with `google.rpc.Code.ALREADY_EXISTS` if the
	// setting value already exists on the given Cloud resource.
	// Returns a `google.rpc.Status` with `google.rpc.Code.FAILED_PRECONDITION` if
	// the setting is flagged as read only.
	CreateSettingValue(context.Context, *CreateSettingValueRequest) (*SettingValue, error)
	// Updates a setting value.
	//
	// Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
	// setting or the setting value does not exist.
	// Returns a `google.rpc.Status` with `google.rpc.Code.FAILED_PRECONDITION` if
	// the setting is flagged as read only.
	// Returns a `google.rpc.Status` with `google.rpc.Code.ABORTED` if the etag
	// supplied in the request does not match the persisted etag of the setting
	// value.
	//
	// Note: the supplied setting value will perform a full overwrite of all
	// fields.
	UpdateSettingValue(context.Context, *UpdateSettingValueRequest) (*SettingValue, error)
	// Deletes a setting value. If the setting value does not exist, the operation
	// is a no-op.
	//
	// Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
	// setting or the setting value does not exist. The setting value will not
	// exist if a prior call to `DeleteSettingValue` for the setting value already
	// returned a success code.
	// Returns a `google.rpc.Status` with `google.rpc.Code.FAILED_PRECONDITION` if
	// the setting is flagged as read only.
	DeleteSettingValue(context.Context, *DeleteSettingValueRequest) (*emptypb.Empty, error)
}

// UnimplementedResourceSettingsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedResourceSettingsServiceServer struct {
}

func (*UnimplementedResourceSettingsServiceServer) ListSettings(context.Context, *ListSettingsRequest) (*ListSettingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSettings not implemented")
}
func (*UnimplementedResourceSettingsServiceServer) SearchSettingValues(context.Context, *SearchSettingValuesRequest) (*SearchSettingValuesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchSettingValues not implemented")
}
func (*UnimplementedResourceSettingsServiceServer) GetSettingValue(context.Context, *GetSettingValueRequest) (*SettingValue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSettingValue not implemented")
}
func (*UnimplementedResourceSettingsServiceServer) LookupEffectiveSettingValue(context.Context, *LookupEffectiveSettingValueRequest) (*SettingValue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LookupEffectiveSettingValue not implemented")
}
func (*UnimplementedResourceSettingsServiceServer) CreateSettingValue(context.Context, *CreateSettingValueRequest) (*SettingValue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSettingValue not implemented")
}
func (*UnimplementedResourceSettingsServiceServer) UpdateSettingValue(context.Context, *UpdateSettingValueRequest) (*SettingValue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSettingValue not implemented")
}
func (*UnimplementedResourceSettingsServiceServer) DeleteSettingValue(context.Context, *DeleteSettingValueRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSettingValue not implemented")
}

func RegisterResourceSettingsServiceServer(s *grpc.Server, srv ResourceSettingsServiceServer) {
	s.RegisterService(&_ResourceSettingsService_serviceDesc, srv)
}

func _ResourceSettingsService_ListSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceSettingsServiceServer).ListSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcesettings.v1.ResourceSettingsService/ListSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceSettingsServiceServer).ListSettings(ctx, req.(*ListSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceSettingsService_SearchSettingValues_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchSettingValuesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceSettingsServiceServer).SearchSettingValues(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcesettings.v1.ResourceSettingsService/SearchSettingValues",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceSettingsServiceServer).SearchSettingValues(ctx, req.(*SearchSettingValuesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceSettingsService_GetSettingValue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSettingValueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceSettingsServiceServer).GetSettingValue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcesettings.v1.ResourceSettingsService/GetSettingValue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceSettingsServiceServer).GetSettingValue(ctx, req.(*GetSettingValueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceSettingsService_LookupEffectiveSettingValue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LookupEffectiveSettingValueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceSettingsServiceServer).LookupEffectiveSettingValue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcesettings.v1.ResourceSettingsService/LookupEffectiveSettingValue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceSettingsServiceServer).LookupEffectiveSettingValue(ctx, req.(*LookupEffectiveSettingValueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceSettingsService_CreateSettingValue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSettingValueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceSettingsServiceServer).CreateSettingValue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcesettings.v1.ResourceSettingsService/CreateSettingValue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceSettingsServiceServer).CreateSettingValue(ctx, req.(*CreateSettingValueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceSettingsService_UpdateSettingValue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSettingValueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceSettingsServiceServer).UpdateSettingValue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcesettings.v1.ResourceSettingsService/UpdateSettingValue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceSettingsServiceServer).UpdateSettingValue(ctx, req.(*UpdateSettingValueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceSettingsService_DeleteSettingValue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSettingValueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceSettingsServiceServer).DeleteSettingValue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcesettings.v1.ResourceSettingsService/DeleteSettingValue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceSettingsServiceServer).DeleteSettingValue(ctx, req.(*DeleteSettingValueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ResourceSettingsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.resourcesettings.v1.ResourceSettingsService",
	HandlerType: (*ResourceSettingsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListSettings",
			Handler:    _ResourceSettingsService_ListSettings_Handler,
		},
		{
			MethodName: "SearchSettingValues",
			Handler:    _ResourceSettingsService_SearchSettingValues_Handler,
		},
		{
			MethodName: "GetSettingValue",
			Handler:    _ResourceSettingsService_GetSettingValue_Handler,
		},
		{
			MethodName: "LookupEffectiveSettingValue",
			Handler:    _ResourceSettingsService_LookupEffectiveSettingValue_Handler,
		},
		{
			MethodName: "CreateSettingValue",
			Handler:    _ResourceSettingsService_CreateSettingValue_Handler,
		},
		{
			MethodName: "UpdateSettingValue",
			Handler:    _ResourceSettingsService_UpdateSettingValue_Handler,
		},
		{
			MethodName: "DeleteSettingValue",
			Handler:    _ResourceSettingsService_DeleteSettingValue_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/resourcesettings/v1/resource_settings.proto",
}
