// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/videointelligence/v1beta1/video_intelligence.proto

package videointelligence

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Video annotation feature.
type Feature int32

const (
	// Unspecified.
	Feature_FEATURE_UNSPECIFIED Feature = 0
	// Label detection. Detect objects, such as dog or flower.
	Feature_LABEL_DETECTION Feature = 1
	// Human face detection and tracking.
	Feature_FACE_DETECTION Feature = 2
	// Shot change detection.
	Feature_SHOT_CHANGE_DETECTION Feature = 3
	// Safe search detection.
	Feature_SAFE_SEARCH_DETECTION Feature = 4
)

var Feature_name = map[int32]string{
	0: "FEATURE_UNSPECIFIED",
	1: "LABEL_DETECTION",
	2: "FACE_DETECTION",
	3: "SHOT_CHANGE_DETECTION",
	4: "SAFE_SEARCH_DETECTION",
}

var Feature_value = map[string]int32{
	"FEATURE_UNSPECIFIED":   0,
	"LABEL_DETECTION":       1,
	"FACE_DETECTION":        2,
	"SHOT_CHANGE_DETECTION": 3,
	"SAFE_SEARCH_DETECTION": 4,
}

func (x Feature) String() string {
	return proto.EnumName(Feature_name, int32(x))
}

func (Feature) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{0}
}

// Label level (scope).
type LabelLevel int32

const (
	// Unspecified.
	LabelLevel_LABEL_LEVEL_UNSPECIFIED LabelLevel = 0
	// Video-level. Corresponds to the whole video.
	LabelLevel_VIDEO_LEVEL LabelLevel = 1
	// Segment-level. Corresponds to one of `AnnotateSpec.segments`.
	LabelLevel_SEGMENT_LEVEL LabelLevel = 2
	// Shot-level. Corresponds to a single shot (i.e. a series of frames
	// without a major camera position or background change).
	LabelLevel_SHOT_LEVEL LabelLevel = 3
	// Frame-level. Corresponds to a single video frame.
	LabelLevel_FRAME_LEVEL LabelLevel = 4
)

var LabelLevel_name = map[int32]string{
	0: "LABEL_LEVEL_UNSPECIFIED",
	1: "VIDEO_LEVEL",
	2: "SEGMENT_LEVEL",
	3: "SHOT_LEVEL",
	4: "FRAME_LEVEL",
}

var LabelLevel_value = map[string]int32{
	"LABEL_LEVEL_UNSPECIFIED": 0,
	"VIDEO_LEVEL":             1,
	"SEGMENT_LEVEL":           2,
	"SHOT_LEVEL":              3,
	"FRAME_LEVEL":             4,
}

func (x LabelLevel) String() string {
	return proto.EnumName(LabelLevel_name, int32(x))
}

func (LabelLevel) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{1}
}

// Label detection mode.
type LabelDetectionMode int32

const (
	// Unspecified.
	LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED LabelDetectionMode = 0
	// Detect shot-level labels.
	LabelDetectionMode_SHOT_MODE LabelDetectionMode = 1
	// Detect frame-level labels.
	LabelDetectionMode_FRAME_MODE LabelDetectionMode = 2
	// Detect both shot-level and frame-level labels.
	LabelDetectionMode_SHOT_AND_FRAME_MODE LabelDetectionMode = 3
)

var LabelDetectionMode_name = map[int32]string{
	0: "LABEL_DETECTION_MODE_UNSPECIFIED",
	1: "SHOT_MODE",
	2: "FRAME_MODE",
	3: "SHOT_AND_FRAME_MODE",
}

var LabelDetectionMode_value = map[string]int32{
	"LABEL_DETECTION_MODE_UNSPECIFIED": 0,
	"SHOT_MODE":                        1,
	"FRAME_MODE":                       2,
	"SHOT_AND_FRAME_MODE":              3,
}

func (x LabelDetectionMode) String() string {
	return proto.EnumName(LabelDetectionMode_name, int32(x))
}

func (LabelDetectionMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{2}
}

// Bucketized representation of likelihood.
type Likelihood int32

const (
	// Unknown likelihood.
	Likelihood_UNKNOWN Likelihood = 0
	// Very unlikely.
	Likelihood_VERY_UNLIKELY Likelihood = 1
	// Unlikely.
	Likelihood_UNLIKELY Likelihood = 2
	// Possible.
	Likelihood_POSSIBLE Likelihood = 3
	// Likely.
	Likelihood_LIKELY Likelihood = 4
	// Very likely.
	Likelihood_VERY_LIKELY Likelihood = 5
)

var Likelihood_name = map[int32]string{
	0: "UNKNOWN",
	1: "VERY_UNLIKELY",
	2: "UNLIKELY",
	3: "POSSIBLE",
	4: "LIKELY",
	5: "VERY_LIKELY",
}

var Likelihood_value = map[string]int32{
	"UNKNOWN":       0,
	"VERY_UNLIKELY": 1,
	"UNLIKELY":      2,
	"POSSIBLE":      3,
	"LIKELY":        4,
	"VERY_LIKELY":   5,
}

func (x Likelihood) String() string {
	return proto.EnumName(Likelihood_name, int32(x))
}

func (Likelihood) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{3}
}

// Video annotation request.
type AnnotateVideoRequest struct {
	// Input video location. Currently, only
	// [Google Cloud Storage](https://cloud.google.com/storage/) URIs are
	// supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
	// more information, see [Request URIs](/storage/docs/reference-uris). A video
	// URI may include wildcards in `object-id`, and thus identify multiple
	// videos. Supported wildcards: '*' to match 0 or more characters;
	// '?' to match 1 character. If unset, the input video should be embedded
	// in the request as `input_content`. If set, `input_content` should be unset.
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// The video data bytes. Encoding: base64. If unset, the input video(s)
	// should be specified via `input_uri`. If set, `input_uri` should be unset.
	InputContent string `protobuf:"bytes,6,opt,name=input_content,json=inputContent,proto3" json:"input_content,omitempty"`
	// Requested video annotation features.
	Features []Feature `protobuf:"varint,2,rep,packed,name=features,proto3,enum=google.cloud.videointelligence.v1beta1.Feature" json:"features,omitempty"`
	// Additional video context and/or feature-specific parameters.
	VideoContext *VideoContext `protobuf:"bytes,3,opt,name=video_context,json=videoContext,proto3" json:"video_context,omitempty"`
	// Optional location where the output (in JSON format) should be stored.
	// Currently, only [Google Cloud Storage](https://cloud.google.com/storage/)
	// URIs are supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
	// more information, see [Request URIs](/storage/docs/reference-uris).
	OutputUri string `protobuf:"bytes,4,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
	// Optional cloud region where annotation should take place. Supported cloud
	// regions: `us-east1`, `us-west1`, `europe-west1`, `asia-east1`. If no region
	// is specified, a region will be determined based on video file location.
	LocationId           string   `protobuf:"bytes,5,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AnnotateVideoRequest) Reset()         { *m = AnnotateVideoRequest{} }
func (m *AnnotateVideoRequest) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoRequest) ProtoMessage()    {}
func (*AnnotateVideoRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{0}
}

func (m *AnnotateVideoRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoRequest.Unmarshal(m, b)
}
func (m *AnnotateVideoRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoRequest.Marshal(b, m, deterministic)
}
func (m *AnnotateVideoRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoRequest.Merge(m, src)
}
func (m *AnnotateVideoRequest) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoRequest.Size(m)
}
func (m *AnnotateVideoRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoRequest proto.InternalMessageInfo

func (m *AnnotateVideoRequest) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetInputContent() string {
	if m != nil {
		return m.InputContent
	}
	return ""
}

func (m *AnnotateVideoRequest) GetFeatures() []Feature {
	if m != nil {
		return m.Features
	}
	return nil
}

func (m *AnnotateVideoRequest) GetVideoContext() *VideoContext {
	if m != nil {
		return m.VideoContext
	}
	return nil
}

func (m *AnnotateVideoRequest) GetOutputUri() string {
	if m != nil {
		return m.OutputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetLocationId() string {
	if m != nil {
		return m.LocationId
	}
	return ""
}

// Video context and/or feature-specific parameters.
type VideoContext struct {
	// Video segments to annotate. The segments may overlap and are not required
	// to be contiguous or span the whole video. If unspecified, each video
	// is treated as a single segment.
	Segments []*VideoSegment `protobuf:"bytes,1,rep,name=segments,proto3" json:"segments,omitempty"`
	// If label detection has been requested, what labels should be detected
	// in addition to video-level labels or segment-level labels. If unspecified,
	// defaults to `SHOT_MODE`.
	LabelDetectionMode LabelDetectionMode `protobuf:"varint,2,opt,name=label_detection_mode,json=labelDetectionMode,proto3,enum=google.cloud.videointelligence.v1beta1.LabelDetectionMode" json:"label_detection_mode,omitempty"`
	// Whether the video has been shot from a stationary (i.e. non-moving) camera.
	// When set to true, might improve detection accuracy for moving objects.
	StationaryCamera bool `protobuf:"varint,3,opt,name=stationary_camera,json=stationaryCamera,proto3" json:"stationary_camera,omitempty"`
	// Model to use for label detection.
	// Supported values: "latest" and "stable" (the default).
	LabelDetectionModel string `protobuf:"bytes,4,opt,name=label_detection_model,json=labelDetectionModel,proto3" json:"label_detection_model,omitempty"`
	// Model to use for face detection.
	// Supported values: "latest" and "stable" (the default).
	FaceDetectionModel string `protobuf:"bytes,5,opt,name=face_detection_model,json=faceDetectionModel,proto3" json:"face_detection_model,omitempty"`
	// Model to use for shot change detection.
	// Supported values: "latest" and "stable" (the default).
	ShotChangeDetectionModel string `protobuf:"bytes,6,opt,name=shot_change_detection_model,json=shotChangeDetectionModel,proto3" json:"shot_change_detection_model,omitempty"`
	// Model to use for safe search detection.
	// Supported values: "latest" and "stable" (the default).
	SafeSearchDetectionModel string   `protobuf:"bytes,7,opt,name=safe_search_detection_model,json=safeSearchDetectionModel,proto3" json:"safe_search_detection_model,omitempty"`
	XXX_NoUnkeyedLiteral     struct{} `json:"-"`
	XXX_unrecognized         []byte   `json:"-"`
	XXX_sizecache            int32    `json:"-"`
}

func (m *VideoContext) Reset()         { *m = VideoContext{} }
func (m *VideoContext) String() string { return proto.CompactTextString(m) }
func (*VideoContext) ProtoMessage()    {}
func (*VideoContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{1}
}

func (m *VideoContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoContext.Unmarshal(m, b)
}
func (m *VideoContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoContext.Marshal(b, m, deterministic)
}
func (m *VideoContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoContext.Merge(m, src)
}
func (m *VideoContext) XXX_Size() int {
	return xxx_messageInfo_VideoContext.Size(m)
}
func (m *VideoContext) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoContext.DiscardUnknown(m)
}

var xxx_messageInfo_VideoContext proto.InternalMessageInfo

func (m *VideoContext) GetSegments() []*VideoSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *VideoContext) GetLabelDetectionMode() LabelDetectionMode {
	if m != nil {
		return m.LabelDetectionMode
	}
	return LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED
}

func (m *VideoContext) GetStationaryCamera() bool {
	if m != nil {
		return m.StationaryCamera
	}
	return false
}

func (m *VideoContext) GetLabelDetectionModel() string {
	if m != nil {
		return m.LabelDetectionModel
	}
	return ""
}

func (m *VideoContext) GetFaceDetectionModel() string {
	if m != nil {
		return m.FaceDetectionModel
	}
	return ""
}

func (m *VideoContext) GetShotChangeDetectionModel() string {
	if m != nil {
		return m.ShotChangeDetectionModel
	}
	return ""
}

func (m *VideoContext) GetSafeSearchDetectionModel() string {
	if m != nil {
		return m.SafeSearchDetectionModel
	}
	return ""
}

// Video segment.
type VideoSegment struct {
	// Start offset in microseconds (inclusive). Unset means 0.
	StartTimeOffset int64 `protobuf:"varint,1,opt,name=start_time_offset,json=startTimeOffset,proto3" json:"start_time_offset,omitempty"`
	// End offset in microseconds (inclusive). Unset means 0.
	EndTimeOffset        int64    `protobuf:"varint,2,opt,name=end_time_offset,json=endTimeOffset,proto3" json:"end_time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VideoSegment) Reset()         { *m = VideoSegment{} }
func (m *VideoSegment) String() string { return proto.CompactTextString(m) }
func (*VideoSegment) ProtoMessage()    {}
func (*VideoSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{2}
}

func (m *VideoSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoSegment.Unmarshal(m, b)
}
func (m *VideoSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoSegment.Marshal(b, m, deterministic)
}
func (m *VideoSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoSegment.Merge(m, src)
}
func (m *VideoSegment) XXX_Size() int {
	return xxx_messageInfo_VideoSegment.Size(m)
}
func (m *VideoSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoSegment.DiscardUnknown(m)
}

var xxx_messageInfo_VideoSegment proto.InternalMessageInfo

func (m *VideoSegment) GetStartTimeOffset() int64 {
	if m != nil {
		return m.StartTimeOffset
	}
	return 0
}

func (m *VideoSegment) GetEndTimeOffset() int64 {
	if m != nil {
		return m.EndTimeOffset
	}
	return 0
}

// Label location.
type LabelLocation struct {
	// Video segment. Set to [-1, -1] for video-level labels.
	// Set to [timestamp, timestamp] for frame-level labels.
	// Otherwise, corresponds to one of `AnnotateSpec.segments`
	// (if specified) or to shot boundaries (if requested).
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Label level.
	Level                LabelLevel `protobuf:"varint,3,opt,name=level,proto3,enum=google.cloud.videointelligence.v1beta1.LabelLevel" json:"level,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *LabelLocation) Reset()         { *m = LabelLocation{} }
func (m *LabelLocation) String() string { return proto.CompactTextString(m) }
func (*LabelLocation) ProtoMessage()    {}
func (*LabelLocation) Descriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{3}
}

func (m *LabelLocation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelLocation.Unmarshal(m, b)
}
func (m *LabelLocation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelLocation.Marshal(b, m, deterministic)
}
func (m *LabelLocation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelLocation.Merge(m, src)
}
func (m *LabelLocation) XXX_Size() int {
	return xxx_messageInfo_LabelLocation.Size(m)
}
func (m *LabelLocation) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelLocation.DiscardUnknown(m)
}

var xxx_messageInfo_LabelLocation proto.InternalMessageInfo

func (m *LabelLocation) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

func (m *LabelLocation) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *LabelLocation) GetLevel() LabelLevel {
	if m != nil {
		return m.Level
	}
	return LabelLevel_LABEL_LEVEL_UNSPECIFIED
}

// Label annotation.
type LabelAnnotation struct {
	// Textual description, e.g. `Fixed-gear bicycle`.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// Language code for `description` in BCP-47 format.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Where the label was detected and with what confidence.
	Locations            []*LabelLocation `protobuf:"bytes,3,rep,name=locations,proto3" json:"locations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *LabelAnnotation) Reset()         { *m = LabelAnnotation{} }
func (m *LabelAnnotation) String() string { return proto.CompactTextString(m) }
func (*LabelAnnotation) ProtoMessage()    {}
func (*LabelAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{4}
}

func (m *LabelAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelAnnotation.Unmarshal(m, b)
}
func (m *LabelAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelAnnotation.Marshal(b, m, deterministic)
}
func (m *LabelAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelAnnotation.Merge(m, src)
}
func (m *LabelAnnotation) XXX_Size() int {
	return xxx_messageInfo_LabelAnnotation.Size(m)
}
func (m *LabelAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_LabelAnnotation proto.InternalMessageInfo

func (m *LabelAnnotation) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *LabelAnnotation) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *LabelAnnotation) GetLocations() []*LabelLocation {
	if m != nil {
		return m.Locations
	}
	return nil
}

// Safe search annotation (based on per-frame visual signals only).
// If no unsafe content has been detected in a frame, no annotations
// are present for that frame. If only some types of unsafe content
// have been detected in a frame, the likelihood is set to `UNKNOWN`
// for all other types of unsafe content.
type SafeSearchAnnotation struct {
	// Likelihood of adult content.
	Adult Likelihood `protobuf:"varint,1,opt,name=adult,proto3,enum=google.cloud.videointelligence.v1beta1.Likelihood" json:"adult,omitempty"`
	// Likelihood that an obvious modification was made to the original
	// version to make it appear funny or offensive.
	Spoof Likelihood `protobuf:"varint,2,opt,name=spoof,proto3,enum=google.cloud.videointelligence.v1beta1.Likelihood" json:"spoof,omitempty"`
	// Likelihood of medical content.
	Medical Likelihood `protobuf:"varint,3,opt,name=medical,proto3,enum=google.cloud.videointelligence.v1beta1.Likelihood" json:"medical,omitempty"`
	// Likelihood of violent content.
	Violent Likelihood `protobuf:"varint,4,opt,name=violent,proto3,enum=google.cloud.videointelligence.v1beta1.Likelihood" json:"violent,omitempty"`
	// Likelihood of racy content.
	Racy Likelihood `protobuf:"varint,5,opt,name=racy,proto3,enum=google.cloud.videointelligence.v1beta1.Likelihood" json:"racy,omitempty"`
	// Video time offset in microseconds.
	TimeOffset           int64    `protobuf:"varint,6,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SafeSearchAnnotation) Reset()         { *m = SafeSearchAnnotation{} }
func (m *SafeSearchAnnotation) String() string { return proto.CompactTextString(m) }
func (*SafeSearchAnnotation) ProtoMessage()    {}
func (*SafeSearchAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{5}
}

func (m *SafeSearchAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SafeSearchAnnotation.Unmarshal(m, b)
}
func (m *SafeSearchAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SafeSearchAnnotation.Marshal(b, m, deterministic)
}
func (m *SafeSearchAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SafeSearchAnnotation.Merge(m, src)
}
func (m *SafeSearchAnnotation) XXX_Size() int {
	return xxx_messageInfo_SafeSearchAnnotation.Size(m)
}
func (m *SafeSearchAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_SafeSearchAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_SafeSearchAnnotation proto.InternalMessageInfo

func (m *SafeSearchAnnotation) GetAdult() Likelihood {
	if m != nil {
		return m.Adult
	}
	return Likelihood_UNKNOWN
}

func (m *SafeSearchAnnotation) GetSpoof() Likelihood {
	if m != nil {
		return m.Spoof
	}
	return Likelihood_UNKNOWN
}

func (m *SafeSearchAnnotation) GetMedical() Likelihood {
	if m != nil {
		return m.Medical
	}
	return Likelihood_UNKNOWN
}

func (m *SafeSearchAnnotation) GetViolent() Likelihood {
	if m != nil {
		return m.Violent
	}
	return Likelihood_UNKNOWN
}

func (m *SafeSearchAnnotation) GetRacy() Likelihood {
	if m != nil {
		return m.Racy
	}
	return Likelihood_UNKNOWN
}

func (m *SafeSearchAnnotation) GetTimeOffset() int64 {
	if m != nil {
		return m.TimeOffset
	}
	return 0
}

// Bounding box.
type BoundingBox struct {
	// Left X coordinate.
	Left int32 `protobuf:"varint,1,opt,name=left,proto3" json:"left,omitempty"`
	// Right X coordinate.
	Right int32 `protobuf:"varint,2,opt,name=right,proto3" json:"right,omitempty"`
	// Bottom Y coordinate.
	Bottom int32 `protobuf:"varint,3,opt,name=bottom,proto3" json:"bottom,omitempty"`
	// Top Y coordinate.
	Top                  int32    `protobuf:"varint,4,opt,name=top,proto3" json:"top,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BoundingBox) Reset()         { *m = BoundingBox{} }
func (m *BoundingBox) String() string { return proto.CompactTextString(m) }
func (*BoundingBox) ProtoMessage()    {}
func (*BoundingBox) Descriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{6}
}

func (m *BoundingBox) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BoundingBox.Unmarshal(m, b)
}
func (m *BoundingBox) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BoundingBox.Marshal(b, m, deterministic)
}
func (m *BoundingBox) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BoundingBox.Merge(m, src)
}
func (m *BoundingBox) XXX_Size() int {
	return xxx_messageInfo_BoundingBox.Size(m)
}
func (m *BoundingBox) XXX_DiscardUnknown() {
	xxx_messageInfo_BoundingBox.DiscardUnknown(m)
}

var xxx_messageInfo_BoundingBox proto.InternalMessageInfo

func (m *BoundingBox) GetLeft() int32 {
	if m != nil {
		return m.Left
	}
	return 0
}

func (m *BoundingBox) GetRight() int32 {
	if m != nil {
		return m.Right
	}
	return 0
}

func (m *BoundingBox) GetBottom() int32 {
	if m != nil {
		return m.Bottom
	}
	return 0
}

func (m *BoundingBox) GetTop() int32 {
	if m != nil {
		return m.Top
	}
	return 0
}

// Face location.
type FaceLocation struct {
	// Bounding box in a frame.
	BoundingBox *BoundingBox `protobuf:"bytes,1,opt,name=bounding_box,json=boundingBox,proto3" json:"bounding_box,omitempty"`
	// Video time offset in microseconds.
	TimeOffset           int64    `protobuf:"varint,2,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FaceLocation) Reset()         { *m = FaceLocation{} }
func (m *FaceLocation) String() string { return proto.CompactTextString(m) }
func (*FaceLocation) ProtoMessage()    {}
func (*FaceLocation) Descriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{7}
}

func (m *FaceLocation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaceLocation.Unmarshal(m, b)
}
func (m *FaceLocation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaceLocation.Marshal(b, m, deterministic)
}
func (m *FaceLocation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaceLocation.Merge(m, src)
}
func (m *FaceLocation) XXX_Size() int {
	return xxx_messageInfo_FaceLocation.Size(m)
}
func (m *FaceLocation) XXX_DiscardUnknown() {
	xxx_messageInfo_FaceLocation.DiscardUnknown(m)
}

var xxx_messageInfo_FaceLocation proto.InternalMessageInfo

func (m *FaceLocation) GetBoundingBox() *BoundingBox {
	if m != nil {
		return m.BoundingBox
	}
	return nil
}

func (m *FaceLocation) GetTimeOffset() int64 {
	if m != nil {
		return m.TimeOffset
	}
	return 0
}

// Face annotation.
type FaceAnnotation struct {
	// Thumbnail of a representative face view (in JPEG format). Encoding: base64.
	Thumbnail string `protobuf:"bytes,1,opt,name=thumbnail,proto3" json:"thumbnail,omitempty"`
	// All locations where a face was detected.
	// Faces are detected and tracked on a per-video basis
	// (as opposed to across multiple videos).
	Segments []*VideoSegment `protobuf:"bytes,2,rep,name=segments,proto3" json:"segments,omitempty"`
	// Face locations at one frame per second.
	Locations            []*FaceLocation `protobuf:"bytes,3,rep,name=locations,proto3" json:"locations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *FaceAnnotation) Reset()         { *m = FaceAnnotation{} }
func (m *FaceAnnotation) String() string { return proto.CompactTextString(m) }
func (*FaceAnnotation) ProtoMessage()    {}
func (*FaceAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{8}
}

func (m *FaceAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaceAnnotation.Unmarshal(m, b)
}
func (m *FaceAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaceAnnotation.Marshal(b, m, deterministic)
}
func (m *FaceAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaceAnnotation.Merge(m, src)
}
func (m *FaceAnnotation) XXX_Size() int {
	return xxx_messageInfo_FaceAnnotation.Size(m)
}
func (m *FaceAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_FaceAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_FaceAnnotation proto.InternalMessageInfo

func (m *FaceAnnotation) GetThumbnail() string {
	if m != nil {
		return m.Thumbnail
	}
	return ""
}

func (m *FaceAnnotation) GetSegments() []*VideoSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *FaceAnnotation) GetLocations() []*FaceLocation {
	if m != nil {
		return m.Locations
	}
	return nil
}

// Annotation results for a single video.
type VideoAnnotationResults struct {
	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Label annotations. There is exactly one element for each unique label.
	LabelAnnotations []*LabelAnnotation `protobuf:"bytes,2,rep,name=label_annotations,json=labelAnnotations,proto3" json:"label_annotations,omitempty"`
	// Face annotations. There is exactly one element for each unique face.
	FaceAnnotations []*FaceAnnotation `protobuf:"bytes,3,rep,name=face_annotations,json=faceAnnotations,proto3" json:"face_annotations,omitempty"`
	// Shot annotations. Each shot is represented as a video segment.
	ShotAnnotations []*VideoSegment `protobuf:"bytes,4,rep,name=shot_annotations,json=shotAnnotations,proto3" json:"shot_annotations,omitempty"`
	// Safe search annotations.
	SafeSearchAnnotations []*SafeSearchAnnotation `protobuf:"bytes,6,rep,name=safe_search_annotations,json=safeSearchAnnotations,proto3" json:"safe_search_annotations,omitempty"`
	// If set, indicates an error. Note that for a single `AnnotateVideoRequest`
	// some videos may succeed and some may fail.
	Error                *status.Status `protobuf:"bytes,5,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *VideoAnnotationResults) Reset()         { *m = VideoAnnotationResults{} }
func (m *VideoAnnotationResults) String() string { return proto.CompactTextString(m) }
func (*VideoAnnotationResults) ProtoMessage()    {}
func (*VideoAnnotationResults) Descriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{9}
}

func (m *VideoAnnotationResults) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoAnnotationResults.Unmarshal(m, b)
}
func (m *VideoAnnotationResults) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoAnnotationResults.Marshal(b, m, deterministic)
}
func (m *VideoAnnotationResults) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoAnnotationResults.Merge(m, src)
}
func (m *VideoAnnotationResults) XXX_Size() int {
	return xxx_messageInfo_VideoAnnotationResults.Size(m)
}
func (m *VideoAnnotationResults) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoAnnotationResults.DiscardUnknown(m)
}

var xxx_messageInfo_VideoAnnotationResults proto.InternalMessageInfo

func (m *VideoAnnotationResults) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationResults) GetLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.LabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetFaceAnnotations() []*FaceAnnotation {
	if m != nil {
		return m.FaceAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotAnnotations() []*VideoSegment {
	if m != nil {
		return m.ShotAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetSafeSearchAnnotations() []*SafeSearchAnnotation {
	if m != nil {
		return m.SafeSearchAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetError() *status.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

// Video annotation response. Included in the `response`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoResponse struct {
	// Annotation results for all videos specified in `AnnotateVideoRequest`.
	AnnotationResults    []*VideoAnnotationResults `protobuf:"bytes,1,rep,name=annotation_results,json=annotationResults,proto3" json:"annotation_results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *AnnotateVideoResponse) Reset()         { *m = AnnotateVideoResponse{} }
func (m *AnnotateVideoResponse) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoResponse) ProtoMessage()    {}
func (*AnnotateVideoResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{10}
}

func (m *AnnotateVideoResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoResponse.Unmarshal(m, b)
}
func (m *AnnotateVideoResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoResponse.Marshal(b, m, deterministic)
}
func (m *AnnotateVideoResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoResponse.Merge(m, src)
}
func (m *AnnotateVideoResponse) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoResponse.Size(m)
}
func (m *AnnotateVideoResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoResponse proto.InternalMessageInfo

func (m *AnnotateVideoResponse) GetAnnotationResults() []*VideoAnnotationResults {
	if m != nil {
		return m.AnnotationResults
	}
	return nil
}

// Annotation progress for a single video.
type VideoAnnotationProgress struct {
	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Approximate percentage processed thus far.
	// Guaranteed to be 100 when fully processed.
	ProgressPercent int32 `protobuf:"varint,2,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// Time when the request was received.
	StartTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Time of the most recent update.
	UpdateTime           *timestamp.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *VideoAnnotationProgress) Reset()         { *m = VideoAnnotationProgress{} }
func (m *VideoAnnotationProgress) String() string { return proto.CompactTextString(m) }
func (*VideoAnnotationProgress) ProtoMessage()    {}
func (*VideoAnnotationProgress) Descriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{11}
}

func (m *VideoAnnotationProgress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoAnnotationProgress.Unmarshal(m, b)
}
func (m *VideoAnnotationProgress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoAnnotationProgress.Marshal(b, m, deterministic)
}
func (m *VideoAnnotationProgress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoAnnotationProgress.Merge(m, src)
}
func (m *VideoAnnotationProgress) XXX_Size() int {
	return xxx_messageInfo_VideoAnnotationProgress.Size(m)
}
func (m *VideoAnnotationProgress) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoAnnotationProgress.DiscardUnknown(m)
}

var xxx_messageInfo_VideoAnnotationProgress proto.InternalMessageInfo

func (m *VideoAnnotationProgress) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationProgress) GetProgressPercent() int32 {
	if m != nil {
		return m.ProgressPercent
	}
	return 0
}

func (m *VideoAnnotationProgress) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *VideoAnnotationProgress) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// Video annotation progress. Included in the `metadata`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoProgress struct {
	// Progress metadata for all videos specified in `AnnotateVideoRequest`.
	AnnotationProgress   []*VideoAnnotationProgress `protobuf:"bytes,1,rep,name=annotation_progress,json=annotationProgress,proto3" json:"annotation_progress,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *AnnotateVideoProgress) Reset()         { *m = AnnotateVideoProgress{} }
func (m *AnnotateVideoProgress) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoProgress) ProtoMessage()    {}
func (*AnnotateVideoProgress) Descriptor() ([]byte, []int) {
	return fileDescriptor_bda050609d2e9d85, []int{12}
}

func (m *AnnotateVideoProgress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoProgress.Unmarshal(m, b)
}
func (m *AnnotateVideoProgress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoProgress.Marshal(b, m, deterministic)
}
func (m *AnnotateVideoProgress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoProgress.Merge(m, src)
}
func (m *AnnotateVideoProgress) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoProgress.Size(m)
}
func (m *AnnotateVideoProgress) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoProgress.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoProgress proto.InternalMessageInfo

func (m *AnnotateVideoProgress) GetAnnotationProgress() []*VideoAnnotationProgress {
	if m != nil {
		return m.AnnotationProgress
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.videointelligence.v1beta1.Feature", Feature_name, Feature_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1beta1.LabelLevel", LabelLevel_name, LabelLevel_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1beta1.LabelDetectionMode", LabelDetectionMode_name, LabelDetectionMode_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1beta1.Likelihood", Likelihood_name, Likelihood_value)
	proto.RegisterType((*AnnotateVideoRequest)(nil), "google.cloud.videointelligence.v1beta1.AnnotateVideoRequest")
	proto.RegisterType((*VideoContext)(nil), "google.cloud.videointelligence.v1beta1.VideoContext")
	proto.RegisterType((*VideoSegment)(nil), "google.cloud.videointelligence.v1beta1.VideoSegment")
	proto.RegisterType((*LabelLocation)(nil), "google.cloud.videointelligence.v1beta1.LabelLocation")
	proto.RegisterType((*LabelAnnotation)(nil), "google.cloud.videointelligence.v1beta1.LabelAnnotation")
	proto.RegisterType((*SafeSearchAnnotation)(nil), "google.cloud.videointelligence.v1beta1.SafeSearchAnnotation")
	proto.RegisterType((*BoundingBox)(nil), "google.cloud.videointelligence.v1beta1.BoundingBox")
	proto.RegisterType((*FaceLocation)(nil), "google.cloud.videointelligence.v1beta1.FaceLocation")
	proto.RegisterType((*FaceAnnotation)(nil), "google.cloud.videointelligence.v1beta1.FaceAnnotation")
	proto.RegisterType((*VideoAnnotationResults)(nil), "google.cloud.videointelligence.v1beta1.VideoAnnotationResults")
	proto.RegisterType((*AnnotateVideoResponse)(nil), "google.cloud.videointelligence.v1beta1.AnnotateVideoResponse")
	proto.RegisterType((*VideoAnnotationProgress)(nil), "google.cloud.videointelligence.v1beta1.VideoAnnotationProgress")
	proto.RegisterType((*AnnotateVideoProgress)(nil), "google.cloud.videointelligence.v1beta1.AnnotateVideoProgress")
}

func init() {
	proto.RegisterFile("google/cloud/videointelligence/v1beta1/video_intelligence.proto", fileDescriptor_bda050609d2e9d85)
}

var fileDescriptor_bda050609d2e9d85 = []byte{
	// 1520 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x58, 0xcb, 0x6f, 0x1b, 0xd5,
	0x1a, 0xef, 0xf8, 0x91, 0xc4, 0x9f, 0x93, 0xd8, 0x39, 0x49, 0x1a, 0xdf, 0xb4, 0xb9, 0x8d, 0xdc,
	0xab, 0x2a, 0x37, 0x57, 0xb2, 0x6f, 0x5d, 0x1e, 0xa2, 0x05, 0x2a, 0xc7, 0x19, 0x37, 0x56, 0x1d,
	0x3b, 0x1a, 0x27, 0xa9, 0x8a, 0x2a, 0x8d, 0xc6, 0x33, 0xc7, 0xce, 0x88, 0xf1, 0x9c, 0x61, 0xe6,
	0x4c, 0xd4, 0x2e, 0x61, 0x01, 0x62, 0x89, 0xf8, 0x2f, 0x90, 0x80, 0x7f, 0x81, 0x2d, 0x6c, 0x61,
	0xc3, 0x8a, 0x0d, 0x7f, 0x04, 0x3b, 0xd0, 0x79, 0x8c, 0x3d, 0xb6, 0x03, 0xb5, 0x03, 0x3b, 0x9f,
	0xef, 0xf1, 0xfb, 0xde, 0xe7, 0x7c, 0x63, 0x78, 0xdc, 0x27, 0xa4, 0xef, 0xe0, 0xb2, 0xe9, 0x90,
	0xd0, 0x2a, 0x5f, 0xda, 0x16, 0x26, 0xb6, 0x4b, 0xb1, 0xe3, 0xd8, 0x7d, 0xec, 0x9a, 0xb8, 0x7c,
	0x79, 0xbf, 0x8b, 0xa9, 0x71, 0x5f, 0x70, 0xf4, 0x38, 0xab, 0xe4, 0xf9, 0x84, 0x12, 0x74, 0x4f,
	0x00, 0x94, 0x38, 0x40, 0x69, 0x0a, 0xa0, 0x24, 0x01, 0xb6, 0x6f, 0x4b, 0x43, 0x86, 0x67, 0x97,
	0x0d, 0xd7, 0x25, 0xd4, 0xa0, 0x36, 0x71, 0x03, 0x81, 0xb2, 0x7d, 0x57, 0x72, 0x1d, 0xe2, 0xf6,
	0xfd, 0xd0, 0x75, 0x6d, 0xb7, 0x5f, 0x26, 0x1e, 0xf6, 0xc7, 0x84, 0xee, 0x48, 0x21, 0x7e, 0xea,
	0x86, 0xbd, 0x32, 0xb5, 0x07, 0x38, 0xa0, 0xc6, 0xc0, 0x93, 0x02, 0x5b, 0x52, 0xc0, 0xf7, 0xcc,
	0x72, 0x40, 0x0d, 0x1a, 0x4a, 0xcd, 0xe2, 0x77, 0x09, 0xd8, 0xa8, 0x0a, 0xa3, 0xf8, 0x9c, 0xb9,
	0xa8, 0xe1, 0x8f, 0x42, 0x1c, 0x50, 0x74, 0x0b, 0x32, 0xb6, 0xeb, 0x85, 0x54, 0x0f, 0x7d, 0xbb,
	0xa0, 0xec, 0x2a, 0x7b, 0x19, 0x6d, 0x89, 0x13, 0xce, 0x7c, 0x1b, 0xdd, 0x85, 0x15, 0xc1, 0x34,
	0x89, 0x4b, 0xb1, 0x4b, 0x0b, 0x0b, 0x5c, 0x60, 0x99, 0x13, 0x6b, 0x82, 0x86, 0x9e, 0xc2, 0x52,
	0x0f, 0x1b, 0x34, 0xf4, 0x71, 0x50, 0x48, 0xec, 0x26, 0xf7, 0x56, 0x2b, 0xe5, 0xd2, 0x6c, 0x29,
	0x29, 0xd5, 0x85, 0x9e, 0x36, 0x04, 0x40, 0xcf, 0x61, 0x45, 0x24, 0x9a, 0x5b, 0x7c, 0x49, 0x0b,
	0xc9, 0x5d, 0x65, 0x2f, 0x5b, 0x79, 0x63, 0x56, 0x44, 0x1e, 0x5b, 0x4d, 0xe8, 0x6a, 0xcb, 0x97,
	0xb1, 0x13, 0xda, 0x01, 0x20, 0x21, 0x8d, 0x42, 0x4d, 0xf1, 0x48, 0x32, 0x82, 0xc2, 0x62, 0xbd,
	0x03, 0x59, 0x87, 0x98, 0x3c, 0xdd, 0xba, 0x6d, 0x15, 0xd2, 0x9c, 0x0f, 0x11, 0xa9, 0x61, 0x15,
	0x7f, 0x49, 0xc2, 0x72, 0x1c, 0x1e, 0x9d, 0xc0, 0x52, 0x80, 0xfb, 0x03, 0xec, 0xd2, 0xa0, 0xa0,
	0xec, 0x26, 0xe7, 0x76, 0xb3, 0x23, 0x94, 0xb5, 0x21, 0x0a, 0x72, 0x60, 0xc3, 0x31, 0xba, 0xd8,
	0xd1, 0x2d, 0x4c, 0xb1, 0xc9, 0x5d, 0x19, 0x10, 0x0b, 0x17, 0x12, 0xbb, 0xca, 0xde, 0x6a, 0xe5,
	0xe1, 0xac, 0xe8, 0x4d, 0x86, 0x71, 0x18, 0x41, 0x1c, 0x13, 0x0b, 0x6b, 0xc8, 0x99, 0xa2, 0xa1,
	0xff, 0xc1, 0x5a, 0x20, 0x9a, 0xd0, 0xf0, 0x5f, 0xe9, 0xa6, 0x31, 0xc0, 0xbe, 0xc1, 0xf3, 0xbd,
	0xa4, 0xe5, 0x47, 0x8c, 0x1a, 0xa7, 0xa3, 0x0a, 0x6c, 0x5e, 0xe5, 0x9a, 0x23, 0x13, 0xb9, 0x3e,
	0x8d, 0xef, 0xa0, 0xff, 0xc3, 0x46, 0xcf, 0x30, 0xf1, 0x94, 0x8a, 0xc8, 0x2d, 0x62, 0xbc, 0x09,
	0x8d, 0xf7, 0xe0, 0x56, 0x70, 0x41, 0xa8, 0x6e, 0x5e, 0x18, 0x6e, 0x7f, 0x5a, 0x51, 0xb4, 0x5f,
	0x81, 0x89, 0xd4, 0xb8, 0xc4, 0x15, 0xea, 0x46, 0x0f, 0xeb, 0x01, 0x36, 0x7c, 0xf3, 0x62, 0x4a,
	0x7d, 0x51, 0xaa, 0x1b, 0x3d, 0xdc, 0xe1, 0x12, 0xe3, 0xea, 0xc5, 0xae, 0x2c, 0xb0, 0x2c, 0x0c,
	0xda, 0xe7, 0x09, 0xf2, 0xa9, 0xce, 0xc6, 0x4c, 0x27, 0xbd, 0x5e, 0x80, 0x29, 0x9f, 0x91, 0xa4,
	0x96, 0xe3, 0x8c, 0x53, 0x7b, 0x80, 0xdb, 0x9c, 0x8c, 0xee, 0x41, 0x0e, 0xbb, 0xd6, 0x98, 0x64,
	0x82, 0x4b, 0xae, 0x60, 0xd7, 0x1a, 0xc9, 0x15, 0xbf, 0x57, 0x60, 0x85, 0xd7, 0xa7, 0x29, 0x3b,
	0x0b, 0xb5, 0x60, 0x51, 0x36, 0x00, 0xc7, 0xbe, 0x6e, 0x17, 0x45, 0x20, 0xe8, 0xdf, 0x00, 0x26,
	0x71, 0x7b, 0xb6, 0xc5, 0x64, 0xb9, 0x13, 0x09, 0x2d, 0x46, 0x41, 0x47, 0x90, 0x76, 0xf0, 0x25,
	0x76, 0x78, 0xa9, 0x57, 0x2b, 0x95, 0xb9, 0xba, 0xaa, 0xc9, 0x34, 0x35, 0x01, 0x50, 0xfc, 0x5a,
	0x81, 0x1c, 0xa7, 0x56, 0x87, 0xd7, 0x19, 0xda, 0x85, 0xac, 0x85, 0x03, 0xd3, 0xb7, 0x3d, 0x76,
	0x94, 0x37, 0x4a, 0x9c, 0xc4, 0x2e, 0x15, 0xc7, 0x70, 0xfb, 0xa1, 0xd1, 0xc7, 0xba, 0x19, 0x75,
	0x77, 0x46, 0x5b, 0x8e, 0x88, 0x35, 0xd6, 0x9b, 0x1d, 0xc8, 0x44, 0xa3, 0x17, 0x14, 0x92, 0x7c,
	0xb8, 0xde, 0x9c, 0xcf, 0x51, 0xa9, 0xad, 0x8d, 0x70, 0x8a, 0xdf, 0x26, 0x61, 0xa3, 0x33, 0x2c,
	0x7e, 0xcc, 0xe9, 0x23, 0x48, 0x1b, 0x56, 0xe8, 0x88, 0x02, 0xcc, 0x93, 0x12, 0xfb, 0x43, 0xec,
	0xd8, 0x17, 0x84, 0x58, 0x9a, 0x00, 0x60, 0x48, 0x81, 0x47, 0x48, 0x4f, 0x8e, 0xec, 0xb5, 0x90,
	0x38, 0x00, 0x6a, 0xc2, 0xe2, 0x00, 0x5b, 0xb6, 0x69, 0xcc, 0x5f, 0xa8, 0x11, 0x56, 0x04, 0xc1,
	0xd0, 0x2e, 0x6d, 0xe2, 0xb0, 0x26, 0x4b, 0x5d, 0x1f, 0x4d, 0x42, 0xa0, 0x3a, 0xa4, 0x7c, 0xc3,
	0x7c, 0xc5, 0x07, 0xf9, 0x7a, 0x50, 0x5c, 0x9f, 0xdd, 0xb9, 0xf1, 0x81, 0x59, 0xe0, 0x03, 0x03,
	0x74, 0x34, 0x2d, 0x06, 0x64, 0x0f, 0x48, 0xe8, 0x5a, 0xb6, 0xdb, 0x3f, 0x20, 0x2f, 0x11, 0x82,
	0x94, 0x83, 0x7b, 0xa2, 0x4c, 0x69, 0x8d, 0xff, 0x46, 0x1b, 0x90, 0xf6, 0xed, 0xfe, 0x85, 0x18,
	0xb7, 0xb4, 0x26, 0x0e, 0xe8, 0x26, 0x2c, 0x74, 0x09, 0xa5, 0x64, 0xc0, 0x93, 0x97, 0xd6, 0xe4,
	0x09, 0xe5, 0x21, 0x49, 0x89, 0xc7, 0x73, 0x90, 0xd6, 0xd8, 0xcf, 0xe2, 0x67, 0x0a, 0x2c, 0xd7,
	0x0d, 0x13, 0x0f, 0xe7, 0xf1, 0x1c, 0x96, 0xbb, 0xd2, 0xa6, 0xde, 0x25, 0x2f, 0xe5, 0x50, 0x3e,
	0x98, 0x35, 0xc8, 0x98, 0xbf, 0x5a, 0xb6, 0x1b, 0x73, 0x7e, 0x22, 0xd8, 0xc4, 0x54, 0xb0, 0x3f,
	0x29, 0xb0, 0xca, 0x3c, 0x89, 0x35, 0xe6, 0x6d, 0xc8, 0xd0, 0x8b, 0x70, 0xd0, 0x75, 0x0d, 0xdb,
	0x91, 0xb3, 0x34, 0x22, 0x8c, 0x3d, 0x40, 0x89, 0x7f, 0xe4, 0x01, 0xd2, 0xa6, 0xc7, 0x6e, 0x66,
	0xc8, 0x78, 0x12, 0xe3, 0x53, 0xf7, 0x7b, 0x12, 0x6e, 0x72, 0x73, 0xa3, 0xb8, 0x34, 0x1c, 0x84,
	0x0e, 0x0d, 0xfe, 0x7a, 0xf9, 0xb0, 0x60, 0x4d, 0xbc, 0x38, 0xb1, 0x65, 0x49, 0x86, 0xf9, 0xf6,
	0x5c, 0x57, 0x41, 0xcc, 0x6e, 0xde, 0x19, 0x27, 0x04, 0xc8, 0x80, 0x3c, 0x7f, 0xa3, 0xe2, 0x46,
	0x44, 0xe0, 0x6f, 0xcd, 0x13, 0x78, 0xcc, 0x46, 0xae, 0x37, 0x76, 0x0e, 0x90, 0x0e, 0x79, 0xfe,
	0xa8, 0xc5, 0x4d, 0xa4, 0xfe, 0x46, 0xb9, 0x72, 0x0c, 0x2d, 0x6e, 0x80, 0xc2, 0x56, 0xfc, 0xd9,
	0x8b, 0xdb, 0x59, 0xe0, 0x76, 0xde, 0x9d, 0xd5, 0xce, 0x55, 0xb7, 0xa3, 0xb6, 0x19, 0x5c, 0x41,
	0x0d, 0xd0, 0x1e, 0xa4, 0xb1, 0xef, 0x13, 0x9f, 0xdf, 0x02, 0xd9, 0x0a, 0x8a, 0x6c, 0xf8, 0x9e,
	0x59, 0xea, 0xf0, 0xdd, 0x53, 0x13, 0x02, 0xc5, 0x4f, 0x15, 0xd8, 0x9c, 0x58, 0x3e, 0x03, 0x8f,
	0xb8, 0x01, 0x46, 0x03, 0x40, 0x23, 0x6f, 0x75, 0x5f, 0xb4, 0x85, 0x5c, 0xa6, 0xde, 0x9f, 0x2b,
	0x39, 0x53, 0xcd, 0xa5, 0xad, 0x19, 0x93, 0xa4, 0xe2, 0xcf, 0x0a, 0x6c, 0x4d, 0x48, 0x9f, 0xf8,
	0xa4, 0xef, 0xe3, 0xe0, 0x35, 0xbd, 0xf8, 0x5f, 0xc8, 0x7b, 0x52, 0x50, 0xf7, 0xb0, 0x6f, 0xb2,
	0x7b, 0x54, 0xdc, 0x37, 0xb9, 0x88, 0x7e, 0x22, 0xc8, 0xe8, 0x1d, 0x80, 0xd1, 0xd2, 0x20, 0xd7,
	0xd7, 0xed, 0x28, 0x94, 0x68, 0x71, 0x2f, 0x9d, 0x46, 0x8b, 0xbb, 0x96, 0x19, 0x6e, 0x12, 0xe8,
	0x11, 0x64, 0x43, 0xcf, 0x32, 0x28, 0x16, 0xba, 0xa9, 0xd7, 0xea, 0x82, 0x10, 0x67, 0x84, 0xe2,
	0xe7, 0x93, 0x49, 0x1e, 0x46, 0xe6, 0xc1, 0x7a, 0x2c, 0xc9, 0x91, 0xbf, 0x32, 0xcb, 0x8f, 0xaf,
	0x99, 0xe5, 0x08, 0x5d, 0x8b, 0x15, 0x30, 0xa2, 0xed, 0x7f, 0xac, 0xc0, 0xa2, 0xdc, 0xed, 0xd1,
	0x16, 0xac, 0xd7, 0xd5, 0xea, 0xe9, 0x99, 0xa6, 0xea, 0x67, 0xad, 0xce, 0x89, 0x5a, 0x6b, 0xd4,
	0x1b, 0xea, 0x61, 0xfe, 0x06, 0x5a, 0x87, 0x5c, 0xb3, 0x7a, 0xa0, 0x36, 0xf5, 0x43, 0xf5, 0x54,
	0xad, 0x9d, 0x36, 0xda, 0xad, 0xbc, 0x82, 0x10, 0xac, 0xd6, 0xab, 0x35, 0x35, 0x46, 0x4b, 0xa0,
	0x7f, 0xc1, 0x66, 0xe7, 0xa8, 0x7d, 0xaa, 0xd7, 0x8e, 0xaa, 0xad, 0x27, 0x71, 0x56, 0x92, 0xb3,
	0xaa, 0x75, 0x55, 0xef, 0xa8, 0x55, 0xad, 0x76, 0x14, 0x63, 0xa5, 0xf6, 0x5d, 0x80, 0xd1, 0xc6,
	0x82, 0x6e, 0xc1, 0x96, 0x30, 0xd6, 0x54, 0xcf, 0xd5, 0xe6, 0x84, 0x27, 0x39, 0xc8, 0x9e, 0x37,
	0x0e, 0xd5, 0xb6, 0x60, 0xe6, 0x15, 0xb4, 0x06, 0x2b, 0x1d, 0xf5, 0xc9, 0xb1, 0xda, 0x3a, 0x95,
	0xa4, 0x04, 0x5a, 0x05, 0xe0, 0x4e, 0x88, 0x73, 0x92, 0xe9, 0xd4, 0xb5, 0xea, 0xb1, 0x2a, 0x09,
	0xa9, 0x7d, 0x1f, 0xd0, 0xf4, 0xde, 0x8d, 0xfe, 0x03, 0xbb, 0x13, 0x41, 0xea, 0xc7, 0xed, 0xc3,
	0xc9, 0x54, 0xac, 0x40, 0x86, 0x83, 0x33, 0x56, 0x5e, 0x61, 0xb6, 0x04, 0x36, 0x3f, 0x27, 0x58,
	0x0a, 0x39, 0xbb, 0xda, 0x3a, 0xd4, 0x63, 0x8c, 0xe4, 0x3e, 0x06, 0x18, 0xbd, 0xa9, 0x28, 0x0b,
	0x8b, 0x67, 0xad, 0xa7, 0xad, 0xf6, 0xb3, 0x56, 0xfe, 0x06, 0x0b, 0xe1, 0x5c, 0xd5, 0x9e, 0xeb,
	0x67, 0xad, 0x66, 0xe3, 0xa9, 0xda, 0x7c, 0x9e, 0x57, 0xd0, 0x32, 0x2c, 0x0d, 0x4f, 0x09, 0x76,
	0x3a, 0x69, 0x77, 0x3a, 0x8d, 0x83, 0xa6, 0x9a, 0x4f, 0x22, 0x80, 0x05, 0xc9, 0x49, 0xf1, 0x74,
	0x30, 0x55, 0x49, 0x48, 0x57, 0xbe, 0x51, 0xa0, 0xc0, 0xcb, 0xdf, 0x88, 0x35, 0x46, 0x07, 0xfb,
	0x97, 0xb6, 0x89, 0xd1, 0x17, 0x0a, 0xac, 0x8c, 0xf5, 0x1d, 0x9a, 0xf9, 0xb6, 0xb9, 0xea, 0x83,
	0x74, 0x7b, 0x27, 0xd2, 0x8e, 0x7d, 0x09, 0x97, 0xda, 0xd1, 0x97, 0x70, 0xf1, 0xee, 0x27, 0x3f,
	0xfe, 0xfa, 0x65, 0x62, 0xa7, 0x58, 0x18, 0xff, 0x30, 0x0f, 0x1e, 0xca, 0x36, 0xc4, 0x0f, 0x95,
	0xfd, 0x83, 0xdf, 0x14, 0xd8, 0x37, 0xc9, 0x60, 0x46, 0x3f, 0x0e, 0x76, 0xfe, 0x2c, 0xb8, 0x13,
	0x36, 0x72, 0x27, 0xca, 0x07, 0xcf, 0x24, 0x50, 0x9f, 0xb0, 0x25, 0xb5, 0x44, 0xfc, 0x7e, 0xb9,
	0x8f, 0x5d, 0x3e, 0x90, 0x65, 0xc1, 0x32, 0x3c, 0x3b, 0x78, 0xdd, 0x5f, 0x08, 0x8f, 0xa6, 0x38,
	0x5f, 0x25, 0xee, 0x3d, 0x11, 0xc8, 0x35, 0xee, 0xe2, 0x94, 0x1f, 0xa5, 0xf3, 0xfb, 0x07, 0x4c,
	0xf5, 0x87, 0x48, 0xf0, 0x05, 0x17, 0x7c, 0x31, 0x25, 0xf8, 0xe2, 0x5c, 0xd8, 0xe8, 0x2e, 0x70,
	0xaf, 0x1e, 0xfc, 0x11, 0x00, 0x00, 0xff, 0xff, 0xba, 0xc2, 0xb0, 0xa0, 0xd7, 0x10, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// VideoIntelligenceServiceClient is the client API for VideoIntelligenceService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type VideoIntelligenceServiceClient interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type videoIntelligenceServiceClient struct {
	cc *grpc.ClientConn
}

func NewVideoIntelligenceServiceClient(cc *grpc.ClientConn) VideoIntelligenceServiceClient {
	return &videoIntelligenceServiceClient{cc}
}

func (c *videoIntelligenceServiceClient) AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.videointelligence.v1beta1.VideoIntelligenceService/AnnotateVideo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VideoIntelligenceServiceServer is the server API for VideoIntelligenceService service.
type VideoIntelligenceServiceServer interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(context.Context, *AnnotateVideoRequest) (*longrunning.Operation, error)
}

func RegisterVideoIntelligenceServiceServer(s *grpc.Server, srv VideoIntelligenceServiceServer) {
	s.RegisterService(&_VideoIntelligenceService_serviceDesc, srv)
}

func _VideoIntelligenceService_AnnotateVideo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnnotateVideoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.videointelligence.v1beta1.VideoIntelligenceService/AnnotateVideo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, req.(*AnnotateVideoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VideoIntelligenceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.videointelligence.v1beta1.VideoIntelligenceService",
	HandlerType: (*VideoIntelligenceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AnnotateVideo",
			Handler:    _VideoIntelligenceService_AnnotateVideo_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/videointelligence/v1beta1/video_intelligence.proto",
}
