// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/ml/v1/job_service.proto

package ml

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	_ "google.golang.org/genproto/googleapis/api/serviceconfig"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A scale tier is an abstract representation of the resources Cloud ML
// will allocate to a training job. When selecting a scale tier for your
// training job, you should consider the size of your training dataset and
// the complexity of your model. As the tiers increase, virtual machines are
// added to handle your job, and the individual machines in the cluster
// generally have more memory and greater processing power than they do at
// lower tiers. The number of training units charged per hour of processing
// increases as tiers get more advanced. Refer to the
// [pricing guide](/ml/pricing) for more details. Note that in addition to
// incurring costs, your use of training resources is constrained by the
// [quota policy](/ml/quota).
type TrainingInput_ScaleTier int32

const (
	// A single worker instance. This tier is suitable for learning how to use
	// Cloud ML, and for experimenting with new models using small datasets.
	TrainingInput_BASIC TrainingInput_ScaleTier = 0
	// Many workers and a few parameter servers.
	TrainingInput_STANDARD_1 TrainingInput_ScaleTier = 1
	// A large number of workers with many parameter servers.
	TrainingInput_PREMIUM_1 TrainingInput_ScaleTier = 3
	// A single worker instance [with a GPU](ml/docs/how-tos/using-gpus).
	TrainingInput_BASIC_GPU TrainingInput_ScaleTier = 6
	// The CUSTOM tier is not a set tier, but rather enables you to use your
	// own cluster specification. When you use this tier, set values to
	// configure your processing cluster according to these guidelines:
	//
	// *   You _must_ set `TrainingInput.masterType` to specify the type
	//     of machine to use for your master node. This is the only required
	//     setting.
	//
	// *   You _may_ set `TrainingInput.workerCount` to specify the number of
	//     workers to use. If you specify one or more workers, you _must_ also
	//     set `TrainingInput.workerType` to specify the type of machine to use
	//     for your worker nodes.
	//
	// *   You _may_ set `TrainingInput.parameterServerCount` to specify the
	//     number of parameter servers to use. If you specify one or more
	//     parameter servers, you _must_ also set
	//     `TrainingInput.parameterServerType` to specify the type of machine to
	//     use for your parameter servers.
	//
	// Note that all of your workers must use the same machine type, which can
	// be different from your parameter server type and master type. Your
	// parameter servers must likewise use the same machine type, which can be
	// different from your worker type and master type.
	TrainingInput_CUSTOM TrainingInput_ScaleTier = 5
)

var TrainingInput_ScaleTier_name = map[int32]string{
	0: "BASIC",
	1: "STANDARD_1",
	3: "PREMIUM_1",
	6: "BASIC_GPU",
	5: "CUSTOM",
}

var TrainingInput_ScaleTier_value = map[string]int32{
	"BASIC":      0,
	"STANDARD_1": 1,
	"PREMIUM_1":  3,
	"BASIC_GPU":  6,
	"CUSTOM":     5,
}

func (x TrainingInput_ScaleTier) String() string {
	return proto.EnumName(TrainingInput_ScaleTier_name, int32(x))
}

func (TrainingInput_ScaleTier) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a9e7ba15cb43988d, []int{0, 0}
}

// The available types of optimization goals.
type HyperparameterSpec_GoalType int32

const (
	// Goal Type will default to maximize.
	HyperparameterSpec_GOAL_TYPE_UNSPECIFIED HyperparameterSpec_GoalType = 0
	// Maximize the goal metric.
	HyperparameterSpec_MAXIMIZE HyperparameterSpec_GoalType = 1
	// Minimize the goal metric.
	HyperparameterSpec_MINIMIZE HyperparameterSpec_GoalType = 2
)

var HyperparameterSpec_GoalType_name = map[int32]string{
	0: "GOAL_TYPE_UNSPECIFIED",
	1: "MAXIMIZE",
	2: "MINIMIZE",
}

var HyperparameterSpec_GoalType_value = map[string]int32{
	"GOAL_TYPE_UNSPECIFIED": 0,
	"MAXIMIZE":              1,
	"MINIMIZE":              2,
}

func (x HyperparameterSpec_GoalType) String() string {
	return proto.EnumName(HyperparameterSpec_GoalType_name, int32(x))
}

func (HyperparameterSpec_GoalType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a9e7ba15cb43988d, []int{1, 0}
}

// The type of the parameter.
type ParameterSpec_ParameterType int32

const (
	// You must specify a valid type. Using this unspecified type will result in
	// an error.
	ParameterSpec_PARAMETER_TYPE_UNSPECIFIED ParameterSpec_ParameterType = 0
	// Type for real-valued parameters.
	ParameterSpec_DOUBLE ParameterSpec_ParameterType = 1
	// Type for integral parameters.
	ParameterSpec_INTEGER ParameterSpec_ParameterType = 2
	// The parameter is categorical, with a value chosen from the categories
	// field.
	ParameterSpec_CATEGORICAL ParameterSpec_ParameterType = 3
	// The parameter is real valued, with a fixed set of feasible points. If
	// `type==DISCRETE`, feasible_points must be provided, and
	// {`min_value`, `max_value`} will be ignored.
	ParameterSpec_DISCRETE ParameterSpec_ParameterType = 4
)

var ParameterSpec_ParameterType_name = map[int32]string{
	0: "PARAMETER_TYPE_UNSPECIFIED",
	1: "DOUBLE",
	2: "INTEGER",
	3: "CATEGORICAL",
	4: "DISCRETE",
}

var ParameterSpec_ParameterType_value = map[string]int32{
	"PARAMETER_TYPE_UNSPECIFIED": 0,
	"DOUBLE":                     1,
	"INTEGER":                    2,
	"CATEGORICAL":                3,
	"DISCRETE":                   4,
}

func (x ParameterSpec_ParameterType) String() string {
	return proto.EnumName(ParameterSpec_ParameterType_name, int32(x))
}

func (ParameterSpec_ParameterType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a9e7ba15cb43988d, []int{2, 0}
}

// The type of scaling that should be applied to this parameter.
type ParameterSpec_ScaleType int32

const (
	// By default, no scaling is applied.
	ParameterSpec_NONE ParameterSpec_ScaleType = 0
	// Scales the feasible space to (0, 1) linearly.
	ParameterSpec_UNIT_LINEAR_SCALE ParameterSpec_ScaleType = 1
	// Scales the feasible space logarithmically to (0, 1). The entire feasible
	// space must be strictly positive.
	ParameterSpec_UNIT_LOG_SCALE ParameterSpec_ScaleType = 2
	// Scales the feasible space "reverse" logarithmically to (0, 1). The result
	// is that values close to the top of the feasible space are spread out more
	// than points near the bottom. The entire feasible space must be strictly
	// positive.
	ParameterSpec_UNIT_REVERSE_LOG_SCALE ParameterSpec_ScaleType = 3
)

var ParameterSpec_ScaleType_name = map[int32]string{
	0: "NONE",
	1: "UNIT_LINEAR_SCALE",
	2: "UNIT_LOG_SCALE",
	3: "UNIT_REVERSE_LOG_SCALE",
}

var ParameterSpec_ScaleType_value = map[string]int32{
	"NONE":                   0,
	"UNIT_LINEAR_SCALE":      1,
	"UNIT_LOG_SCALE":         2,
	"UNIT_REVERSE_LOG_SCALE": 3,
}

func (x ParameterSpec_ScaleType) String() string {
	return proto.EnumName(ParameterSpec_ScaleType_name, int32(x))
}

func (ParameterSpec_ScaleType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a9e7ba15cb43988d, []int{2, 1}
}

// The format used to separate data instances in the source files.
type PredictionInput_DataFormat int32

const (
	// Unspecified format.
	PredictionInput_DATA_FORMAT_UNSPECIFIED PredictionInput_DataFormat = 0
	// The source file is a text file with instances separated by the
	// new-line character.
	PredictionInput_TEXT PredictionInput_DataFormat = 1
	// The source file is a TFRecord file.
	PredictionInput_TF_RECORD PredictionInput_DataFormat = 2
	// The source file is a GZIP-compressed TFRecord file.
	PredictionInput_TF_RECORD_GZIP PredictionInput_DataFormat = 3
)

var PredictionInput_DataFormat_name = map[int32]string{
	0: "DATA_FORMAT_UNSPECIFIED",
	1: "TEXT",
	2: "TF_RECORD",
	3: "TF_RECORD_GZIP",
}

var PredictionInput_DataFormat_value = map[string]int32{
	"DATA_FORMAT_UNSPECIFIED": 0,
	"TEXT":                    1,
	"TF_RECORD":               2,
	"TF_RECORD_GZIP":          3,
}

func (x PredictionInput_DataFormat) String() string {
	return proto.EnumName(PredictionInput_DataFormat_name, int32(x))
}

func (PredictionInput_DataFormat) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a9e7ba15cb43988d, []int{5, 0}
}

// Describes the job state.
type Job_State int32

const (
	// The job state is unspecified.
	Job_STATE_UNSPECIFIED Job_State = 0
	// The job has been just created and processing has not yet begun.
	Job_QUEUED Job_State = 1
	// The service is preparing to run the job.
	Job_PREPARING Job_State = 2
	// The job is in progress.
	Job_RUNNING Job_State = 3
	// The job completed successfully.
	Job_SUCCEEDED Job_State = 4
	// The job failed.
	// `error_message` should contain the details of the failure.
	Job_FAILED Job_State = 5
	// The job is being cancelled.
	// `error_message` should describe the reason for the cancellation.
	Job_CANCELLING Job_State = 6
	// The job has been cancelled.
	// `error_message` should describe the reason for the cancellation.
	Job_CANCELLED Job_State = 7
)

var Job_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "QUEUED",
	2: "PREPARING",
	3: "RUNNING",
	4: "SUCCEEDED",
	5: "FAILED",
	6: "CANCELLING",
	7: "CANCELLED",
}

var Job_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"QUEUED":            1,
	"PREPARING":         2,
	"RUNNING":           3,
	"SUCCEEDED":         4,
	"FAILED":            5,
	"CANCELLING":        6,
	"CANCELLED":         7,
}

func (x Job_State) String() string {
	return proto.EnumName(Job_State_name, int32(x))
}

func (Job_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a9e7ba15cb43988d, []int{7, 0}
}

// Represents input parameters for a training job.
type TrainingInput struct {
	// Required. Specifies the machine types, the number of replicas for workers
	// and parameter servers.
	ScaleTier TrainingInput_ScaleTier `protobuf:"varint,1,opt,name=scale_tier,json=scaleTier,proto3,enum=google.cloud.ml.v1.TrainingInput_ScaleTier" json:"scale_tier,omitempty"`
	// Optional. Specifies the type of virtual machine to use for your training
	// job's master worker.
	//
	// The following types are supported:
	//
	// <dl>
	//   <dt>standard</dt>
	//   <dd>
	//   A basic machine configuration suitable for training simple models with
	//   small to moderate datasets.
	//   </dd>
	//   <dt>large_model</dt>
	//   <dd>
	//   A machine with a lot of memory, specially suited for parameter servers
	//   when your model is large (having many hidden layers or layers with very
	//   large numbers of nodes).
	//   </dd>
	//   <dt>complex_model_s</dt>
	//   <dd>
	//   A machine suitable for the master and workers of the cluster when your
	//   model requires more computation than the standard machine can handle
	//   satisfactorily.
	//   </dd>
	//   <dt>complex_model_m</dt>
	//   <dd>
	//   A machine with roughly twice the number of cores and roughly double the
	//   memory of <code suppresswarning="true">complex_model_s</code>.
	//   </dd>
	//   <dt>complex_model_l</dt>
	//   <dd>
	//   A machine with roughly twice the number of cores and roughly double the
	//   memory of <code suppresswarning="true">complex_model_m</code>.
	//   </dd>
	//   <dt>standard_gpu</dt>
	//   <dd>
	//   A machine equivalent to <code suppresswarning="true">standard</code> that
	//   also includes a
	//   <a href="ml/docs/how-tos/using-gpus">
	//   GPU that you can use in your trainer</a>.
	//   </dd>
	//   <dt>complex_model_m_gpu</dt>
	//   <dd>
	//   A machine equivalent to
	//   <code suppresswarning="true">coplex_model_m</code> that also includes
	//   four GPUs.
	//   </dd>
	// </dl>
	//
	// You must set this value when `scaleTier` is set to `CUSTOM`.
	MasterType string `protobuf:"bytes,2,opt,name=master_type,json=masterType,proto3" json:"master_type,omitempty"`
	// Optional. Specifies the type of virtual machine to use for your training
	// job's worker nodes.
	//
	// The supported values are the same as those described in the entry for
	// `masterType`.
	//
	// This value must be present when `scaleTier` is set to `CUSTOM` and
	// `workerCount` is greater than zero.
	WorkerType string `protobuf:"bytes,3,opt,name=worker_type,json=workerType,proto3" json:"worker_type,omitempty"`
	// Optional. Specifies the type of virtual machine to use for your training
	// job's parameter server.
	//
	// The supported values are the same as those described in the entry for
	// `master_type`.
	//
	// This value must be present when `scaleTier` is set to `CUSTOM` and
	// `parameter_server_count` is greater than zero.
	ParameterServerType string `protobuf:"bytes,4,opt,name=parameter_server_type,json=parameterServerType,proto3" json:"parameter_server_type,omitempty"`
	// Optional. The number of worker replicas to use for the training job. Each
	// replica in the cluster will be of the type specified in `worker_type`.
	//
	// This value can only be used when `scale_tier` is set to `CUSTOM`. If you
	// set this value, you must also set `worker_type`.
	WorkerCount int64 `protobuf:"varint,5,opt,name=worker_count,json=workerCount,proto3" json:"worker_count,omitempty"`
	// Optional. The number of parameter server replicas to use for the training
	// job. Each replica in the cluster will be of the type specified in
	// `parameter_server_type`.
	//
	// This value can only be used when `scale_tier` is set to `CUSTOM`.If you
	// set this value, you must also set `parameter_server_type`.
	ParameterServerCount int64 `protobuf:"varint,6,opt,name=parameter_server_count,json=parameterServerCount,proto3" json:"parameter_server_count,omitempty"`
	// Required. The Google Cloud Storage location of the packages with
	// the training program and any additional dependencies.
	PackageUris []string `protobuf:"bytes,7,rep,name=package_uris,json=packageUris,proto3" json:"package_uris,omitempty"`
	// Required. The Python module name to run after installing the packages.
	PythonModule string `protobuf:"bytes,8,opt,name=python_module,json=pythonModule,proto3" json:"python_module,omitempty"`
	// Optional. Command line arguments to pass to the program.
	Args []string `protobuf:"bytes,10,rep,name=args,proto3" json:"args,omitempty"`
	// Optional. The set of Hyperparameters to tune.
	Hyperparameters *HyperparameterSpec `protobuf:"bytes,12,opt,name=hyperparameters,proto3" json:"hyperparameters,omitempty"`
	// Required. The Google Compute Engine region to run the training job in.
	Region string `protobuf:"bytes,14,opt,name=region,proto3" json:"region,omitempty"`
	// Optional. A Google Cloud Storage path in which to store training outputs
	// and other data needed for training. This path is passed to your TensorFlow
	// program as the 'job_dir' command-line argument. The benefit of specifying
	// this field is that Cloud ML validates the path for use in training.
	JobDir string `protobuf:"bytes,16,opt,name=job_dir,json=jobDir,proto3" json:"job_dir,omitempty"`
	// Optional. The Google Cloud ML runtime version to use for training.  If not
	// set, Google Cloud ML will choose the latest stable version.
	RuntimeVersion       string   `protobuf:"bytes,15,opt,name=runtime_version,json=runtimeVersion,proto3" json:"runtime_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TrainingInput) Reset()         { *m = TrainingInput{} }
func (m *TrainingInput) String() string { return proto.CompactTextString(m) }
func (*TrainingInput) ProtoMessage()    {}
func (*TrainingInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_a9e7ba15cb43988d, []int{0}
}

func (m *TrainingInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TrainingInput.Unmarshal(m, b)
}
func (m *TrainingInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TrainingInput.Marshal(b, m, deterministic)
}
func (m *TrainingInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TrainingInput.Merge(m, src)
}
func (m *TrainingInput) XXX_Size() int {
	return xxx_messageInfo_TrainingInput.Size(m)
}
func (m *TrainingInput) XXX_DiscardUnknown() {
	xxx_messageInfo_TrainingInput.DiscardUnknown(m)
}

var xxx_messageInfo_TrainingInput proto.InternalMessageInfo

func (m *TrainingInput) GetScaleTier() TrainingInput_ScaleTier {
	if m != nil {
		return m.ScaleTier
	}
	return TrainingInput_BASIC
}

func (m *TrainingInput) GetMasterType() string {
	if m != nil {
		return m.MasterType
	}
	return ""
}

func (m *TrainingInput) GetWorkerType() string {
	if m != nil {
		return m.WorkerType
	}
	return ""
}

func (m *TrainingInput) GetParameterServerType() string {
	if m != nil {
		return m.ParameterServerType
	}
	return ""
}

func (m *TrainingInput) GetWorkerCount() int64 {
	if m != nil {
		return m.WorkerCount
	}
	return 0
}

func (m *TrainingInput) GetParameterServerCount() int64 {
	if m != nil {
		return m.ParameterServerCount
	}
	return 0
}

func (m *TrainingInput) GetPackageUris() []string {
	if m != nil {
		return m.PackageUris
	}
	return nil
}

func (m *TrainingInput) GetPythonModule() string {
	if m != nil {
		return m.PythonModule
	}
	return ""
}

func (m *TrainingInput) GetArgs() []string {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *TrainingInput) GetHyperparameters() *HyperparameterSpec {
	if m != nil {
		return m.Hyperparameters
	}
	return nil
}

func (m *TrainingInput) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *TrainingInput) GetJobDir() string {
	if m != nil {
		return m.JobDir
	}
	return ""
}

func (m *TrainingInput) GetRuntimeVersion() string {
	if m != nil {
		return m.RuntimeVersion
	}
	return ""
}

// Represents a set of hyperparameters to optimize.
type HyperparameterSpec struct {
	// Required. The type of goal to use for tuning. Available types are
	// `MAXIMIZE` and `MINIMIZE`.
	//
	// Defaults to `MAXIMIZE`.
	Goal HyperparameterSpec_GoalType `protobuf:"varint,1,opt,name=goal,proto3,enum=google.cloud.ml.v1.HyperparameterSpec_GoalType" json:"goal,omitempty"`
	// Required. The set of parameters to tune.
	Params []*ParameterSpec `protobuf:"bytes,2,rep,name=params,proto3" json:"params,omitempty"`
	// Optional. How many training trials should be attempted to optimize
	// the specified hyperparameters.
	//
	// Defaults to one.
	MaxTrials int32 `protobuf:"varint,3,opt,name=max_trials,json=maxTrials,proto3" json:"max_trials,omitempty"`
	// Optional. The number of training trials to run concurrently.
	// You can reduce the time it takes to perform hyperparameter tuning by adding
	// trials in parallel. However, each trail only benefits from the information
	// gained in completed trials. That means that a trial does not get access to
	// the results of trials running at the same time, which could reduce the
	// quality of the overall optimization.
	//
	// Each trial will use the same scale tier and machine types.
	//
	// Defaults to one.
	MaxParallelTrials int32 `protobuf:"varint,4,opt,name=max_parallel_trials,json=maxParallelTrials,proto3" json:"max_parallel_trials,omitempty"`
	// Optional. The Tensorflow summary tag name to use for optimizing trials. For
	// current versions of Tensorflow, this tag name should exactly match what is
	// shown in Tensorboard, including all scopes.  For versions of Tensorflow
	// prior to 0.12, this should be only the tag passed to tf.Summary.
	// By default, "training/hptuning/metric" will be used.
	HyperparameterMetricTag string   `protobuf:"bytes,5,opt,name=hyperparameter_metric_tag,json=hyperparameterMetricTag,proto3" json:"hyperparameter_metric_tag,omitempty"`
	XXX_NoUnkeyedLiteral    struct{} `json:"-"`
	XXX_unrecognized        []byte   `json:"-"`
	XXX_sizecache           int32    `json:"-"`
}

func (m *HyperparameterSpec) Reset()         { *m = HyperparameterSpec{} }
func (m *HyperparameterSpec) String() string { return proto.CompactTextString(m) }
func (*HyperparameterSpec) ProtoMessage()    {}
func (*HyperparameterSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_a9e7ba15cb43988d, []int{1}
}

func (m *HyperparameterSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HyperparameterSpec.Unmarshal(m, b)
}
func (m *HyperparameterSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HyperparameterSpec.Marshal(b, m, deterministic)
}
func (m *HyperparameterSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HyperparameterSpec.Merge(m, src)
}
func (m *HyperparameterSpec) XXX_Size() int {
	return xxx_messageInfo_HyperparameterSpec.Size(m)
}
func (m *HyperparameterSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_HyperparameterSpec.DiscardUnknown(m)
}

var xxx_messageInfo_HyperparameterSpec proto.InternalMessageInfo

func (m *HyperparameterSpec) GetGoal() HyperparameterSpec_GoalType {
	if m != nil {
		return m.Goal
	}
	return HyperparameterSpec_GOAL_TYPE_UNSPECIFIED
}

func (m *HyperparameterSpec) GetParams() []*ParameterSpec {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *HyperparameterSpec) GetMaxTrials() int32 {
	if m != nil {
		return m.MaxTrials
	}
	return 0
}

func (m *HyperparameterSpec) GetMaxParallelTrials() int32 {
	if m != nil {
		return m.MaxParallelTrials
	}
	return 0
}

func (m *HyperparameterSpec) GetHyperparameterMetricTag() string {
	if m != nil {
		return m.HyperparameterMetricTag
	}
	return ""
}

// Represents a single hyperparameter to optimize.
type ParameterSpec struct {
	// Required. The parameter name must be unique amongst all ParameterConfigs in
	// a HyperparameterSpec message. E.g., "learning_rate".
	ParameterName string `protobuf:"bytes,1,opt,name=parameter_name,json=parameterName,proto3" json:"parameter_name,omitempty"`
	// Required. The type of the parameter.
	Type ParameterSpec_ParameterType `protobuf:"varint,4,opt,name=type,proto3,enum=google.cloud.ml.v1.ParameterSpec_ParameterType" json:"type,omitempty"`
	// Required if type is `DOUBLE` or `INTEGER`. This field
	// should be unset if type is `CATEGORICAL`. This value should be integers if
	// type is INTEGER.
	MinValue float64 `protobuf:"fixed64,2,opt,name=min_value,json=minValue,proto3" json:"min_value,omitempty"`
	// Required if typeis `DOUBLE` or `INTEGER`. This field
	// should be unset if type is `CATEGORICAL`. This value should be integers if
	// type is `INTEGER`.
	MaxValue float64 `protobuf:"fixed64,3,opt,name=max_value,json=maxValue,proto3" json:"max_value,omitempty"`
	// Required if type is `CATEGORICAL`. The list of possible categories.
	CategoricalValues []string `protobuf:"bytes,5,rep,name=categorical_values,json=categoricalValues,proto3" json:"categorical_values,omitempty"`
	// Required if type is `DISCRETE`.
	// A list of feasible points.
	// The list should be in strictly increasing order. For instance, this
	// parameter might have possible settings of 1.5, 2.5, and 4.0. This list
	// should not contain more than 1,000 values.
	DiscreteValues []float64 `protobuf:"fixed64,6,rep,packed,name=discrete_values,json=discreteValues,proto3" json:"discrete_values,omitempty"`
	// Optional. How the parameter should be scaled to the hypercube.
	// Leave unset for categorical parameters.
	// Some kind of scaling is strongly recommended for real or integral
	// parameters (e.g., `UNIT_LINEAR_SCALE`).
	ScaleType            ParameterSpec_ScaleType `protobuf:"varint,7,opt,name=scale_type,json=scaleType,proto3,enum=google.cloud.ml.v1.ParameterSpec_ScaleType" json:"scale_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *ParameterSpec) Reset()         { *m = ParameterSpec{} }
func (m *ParameterSpec) String() string { return proto.CompactTextString(m) }
func (*ParameterSpec) ProtoMessage()    {}
func (*ParameterSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_a9e7ba15cb43988d, []int{2}
}

func (m *ParameterSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ParameterSpec.Unmarshal(m, b)
}
func (m *ParameterSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ParameterSpec.Marshal(b, m, deterministic)
}
func (m *ParameterSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ParameterSpec.Merge(m, src)
}
func (m *ParameterSpec) XXX_Size() int {
	return xxx_messageInfo_ParameterSpec.Size(m)
}
func (m *ParameterSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ParameterSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ParameterSpec proto.InternalMessageInfo

func (m *ParameterSpec) GetParameterName() string {
	if m != nil {
		return m.ParameterName
	}
	return ""
}

func (m *ParameterSpec) GetType() ParameterSpec_ParameterType {
	if m != nil {
		return m.Type
	}
	return ParameterSpec_PARAMETER_TYPE_UNSPECIFIED
}

func (m *ParameterSpec) GetMinValue() float64 {
	if m != nil {
		return m.MinValue
	}
	return 0
}

func (m *ParameterSpec) GetMaxValue() float64 {
	if m != nil {
		return m.MaxValue
	}
	return 0
}

func (m *ParameterSpec) GetCategoricalValues() []string {
	if m != nil {
		return m.CategoricalValues
	}
	return nil
}

func (m *ParameterSpec) GetDiscreteValues() []float64 {
	if m != nil {
		return m.DiscreteValues
	}
	return nil
}

func (m *ParameterSpec) GetScaleType() ParameterSpec_ScaleType {
	if m != nil {
		return m.ScaleType
	}
	return ParameterSpec_NONE
}

// Represents the result of a single hyperparameter tuning trial from a
// training job. The TrainingOutput object that is returned on successful
// completion of a training job with hyperparameter tuning includes a list
// of HyperparameterOutput objects, one for each successful trial.
type HyperparameterOutput struct {
	// The trial id for these results.
	TrialId string `protobuf:"bytes,1,opt,name=trial_id,json=trialId,proto3" json:"trial_id,omitempty"`
	// The hyperparameters given to this trial.
	Hyperparameters map[string]string `protobuf:"bytes,2,rep,name=hyperparameters,proto3" json:"hyperparameters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The final objective metric seen for this trial.
	FinalMetric *HyperparameterOutput_HyperparameterMetric `protobuf:"bytes,3,opt,name=final_metric,json=finalMetric,proto3" json:"final_metric,omitempty"`
	// All recorded object metrics for this trial.
	AllMetrics           []*HyperparameterOutput_HyperparameterMetric `protobuf:"bytes,4,rep,name=all_metrics,json=allMetrics,proto3" json:"all_metrics,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                     `json:"-"`
	XXX_unrecognized     []byte                                       `json:"-"`
	XXX_sizecache        int32                                        `json:"-"`
}

func (m *HyperparameterOutput) Reset()         { *m = HyperparameterOutput{} }
func (m *HyperparameterOutput) String() string { return proto.CompactTextString(m) }
func (*HyperparameterOutput) ProtoMessage()    {}
func (*HyperparameterOutput) Descriptor() ([]byte, []int) {
	return fileDescriptor_a9e7ba15cb43988d, []int{3}
}

func (m *HyperparameterOutput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HyperparameterOutput.Unmarshal(m, b)
}
func (m *HyperparameterOutput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HyperparameterOutput.Marshal(b, m, deterministic)
}
func (m *HyperparameterOutput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HyperparameterOutput.Merge(m, src)
}
func (m *HyperparameterOutput) XXX_Size() int {
	return xxx_messageInfo_HyperparameterOutput.Size(m)
}
func (m *HyperparameterOutput) XXX_DiscardUnknown() {
	xxx_messageInfo_HyperparameterOutput.DiscardUnknown(m)
}

var xxx_messageInfo_HyperparameterOutput proto.InternalMessageInfo

func (m *HyperparameterOutput) GetTrialId() string {
	if m != nil {
		return m.TrialId
	}
	return ""
}

func (m *HyperparameterOutput) GetHyperparameters() map[string]string {
	if m != nil {
		return m.Hyperparameters
	}
	return nil
}

func (m *HyperparameterOutput) GetFinalMetric() *HyperparameterOutput_HyperparameterMetric {
	if m != nil {
		return m.FinalMetric
	}
	return nil
}

func (m *HyperparameterOutput) GetAllMetrics() []*HyperparameterOutput_HyperparameterMetric {
	if m != nil {
		return m.AllMetrics
	}
	return nil
}

// An observed value of a metric.
type HyperparameterOutput_HyperparameterMetric struct {
	// The global training step for this metric.
	TrainingStep int64 `protobuf:"varint,1,opt,name=training_step,json=trainingStep,proto3" json:"training_step,omitempty"`
	// The objective value at this training step.
	ObjectiveValue       float64  `protobuf:"fixed64,2,opt,name=objective_value,json=objectiveValue,proto3" json:"objective_value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HyperparameterOutput_HyperparameterMetric) Reset() {
	*m = HyperparameterOutput_HyperparameterMetric{}
}
func (m *HyperparameterOutput_HyperparameterMetric) String() string { return proto.CompactTextString(m) }
func (*HyperparameterOutput_HyperparameterMetric) ProtoMessage()    {}
func (*HyperparameterOutput_HyperparameterMetric) Descriptor() ([]byte, []int) {
	return fileDescriptor_a9e7ba15cb43988d, []int{3, 0}
}

func (m *HyperparameterOutput_HyperparameterMetric) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HyperparameterOutput_HyperparameterMetric.Unmarshal(m, b)
}
func (m *HyperparameterOutput_HyperparameterMetric) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HyperparameterOutput_HyperparameterMetric.Marshal(b, m, deterministic)
}
func (m *HyperparameterOutput_HyperparameterMetric) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HyperparameterOutput_HyperparameterMetric.Merge(m, src)
}
func (m *HyperparameterOutput_HyperparameterMetric) XXX_Size() int {
	return xxx_messageInfo_HyperparameterOutput_HyperparameterMetric.Size(m)
}
func (m *HyperparameterOutput_HyperparameterMetric) XXX_DiscardUnknown() {
	xxx_messageInfo_HyperparameterOutput_HyperparameterMetric.DiscardUnknown(m)
}

var xxx_messageInfo_HyperparameterOutput_HyperparameterMetric proto.InternalMessageInfo

func (m *HyperparameterOutput_HyperparameterMetric) GetTrainingStep() int64 {
	if m != nil {
		return m.TrainingStep
	}
	return 0
}

func (m *HyperparameterOutput_HyperparameterMetric) GetObjectiveValue() float64 {
	if m != nil {
		return m.ObjectiveValue
	}
	return 0
}

// Represents results of a training job. Output only.
type TrainingOutput struct {
	// The number of hyperparameter tuning trials that completed successfully.
	// Only set for hyperparameter tuning jobs.
	CompletedTrialCount int64 `protobuf:"varint,1,opt,name=completed_trial_count,json=completedTrialCount,proto3" json:"completed_trial_count,omitempty"`
	// Results for individual Hyperparameter trials.
	// Only set for hyperparameter tuning jobs.
	Trials []*HyperparameterOutput `protobuf:"bytes,2,rep,name=trials,proto3" json:"trials,omitempty"`
	// The amount of ML units consumed by the job.
	ConsumedMlUnits float64 `protobuf:"fixed64,3,opt,name=consumed_ml_units,json=consumedMlUnits,proto3" json:"consumed_ml_units,omitempty"`
	// Whether this job is a hyperparameter tuning job.
	IsHyperparameterTuningJob bool     `protobuf:"varint,4,opt,name=is_hyperparameter_tuning_job,json=isHyperparameterTuningJob,proto3" json:"is_hyperparameter_tuning_job,omitempty"`
	XXX_NoUnkeyedLiteral      struct{} `json:"-"`
	XXX_unrecognized          []byte   `json:"-"`
	XXX_sizecache             int32    `json:"-"`
}

func (m *TrainingOutput) Reset()         { *m = TrainingOutput{} }
func (m *TrainingOutput) String() string { return proto.CompactTextString(m) }
func (*TrainingOutput) ProtoMessage()    {}
func (*TrainingOutput) Descriptor() ([]byte, []int) {
	return fileDescriptor_a9e7ba15cb43988d, []int{4}
}

func (m *TrainingOutput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TrainingOutput.Unmarshal(m, b)
}
func (m *TrainingOutput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TrainingOutput.Marshal(b, m, deterministic)
}
func (m *TrainingOutput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TrainingOutput.Merge(m, src)
}
func (m *TrainingOutput) XXX_Size() int {
	return xxx_messageInfo_TrainingOutput.Size(m)
}
func (m *TrainingOutput) XXX_DiscardUnknown() {
	xxx_messageInfo_TrainingOutput.DiscardUnknown(m)
}

var xxx_messageInfo_TrainingOutput proto.InternalMessageInfo

func (m *TrainingOutput) GetCompletedTrialCount() int64 {
	if m != nil {
		return m.CompletedTrialCount
	}
	return 0
}

func (m *TrainingOutput) GetTrials() []*HyperparameterOutput {
	if m != nil {
		return m.Trials
	}
	return nil
}

func (m *TrainingOutput) GetConsumedMlUnits() float64 {
	if m != nil {
		return m.ConsumedMlUnits
	}
	return 0
}

func (m *TrainingOutput) GetIsHyperparameterTuningJob() bool {
	if m != nil {
		return m.IsHyperparameterTuningJob
	}
	return false
}

// Represents input parameters for a prediction job.
type PredictionInput struct {
	// Required. The model or the version to use for prediction.
	//
	// Types that are valid to be assigned to ModelVersion:
	//	*PredictionInput_ModelName
	//	*PredictionInput_VersionName
	//	*PredictionInput_Uri
	ModelVersion isPredictionInput_ModelVersion `protobuf_oneof:"model_version"`
	// Required. The format of the input data files.
	DataFormat PredictionInput_DataFormat `protobuf:"varint,3,opt,name=data_format,json=dataFormat,proto3,enum=google.cloud.ml.v1.PredictionInput_DataFormat" json:"data_format,omitempty"`
	// Required. The Google Cloud Storage location of the input data files.
	// May contain wildcards.
	InputPaths []string `protobuf:"bytes,4,rep,name=input_paths,json=inputPaths,proto3" json:"input_paths,omitempty"`
	// Required. The output Google Cloud Storage location.
	OutputPath string `protobuf:"bytes,5,opt,name=output_path,json=outputPath,proto3" json:"output_path,omitempty"`
	// Optional. The maximum number of workers to be used for parallel processing.
	// Defaults to 10 if not specified.
	MaxWorkerCount int64 `protobuf:"varint,6,opt,name=max_worker_count,json=maxWorkerCount,proto3" json:"max_worker_count,omitempty"`
	// Required. The Google Compute Engine region to run the prediction job in.
	Region string `protobuf:"bytes,7,opt,name=region,proto3" json:"region,omitempty"`
	// Optional. The Google Cloud ML runtime version to use for this batch
	// prediction. If not set, Google Cloud ML will pick the runtime version used
	// during the CreateVersion request for this model version, or choose the
	// latest stable version when model version information is not available
	// such as when the model is specified by uri.
	RuntimeVersion       string   `protobuf:"bytes,8,opt,name=runtime_version,json=runtimeVersion,proto3" json:"runtime_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PredictionInput) Reset()         { *m = PredictionInput{} }
func (m *PredictionInput) String() string { return proto.CompactTextString(m) }
func (*PredictionInput) ProtoMessage()    {}
func (*PredictionInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_a9e7ba15cb43988d, []int{5}
}

func (m *PredictionInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PredictionInput.Unmarshal(m, b)
}
func (m *PredictionInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PredictionInput.Marshal(b, m, deterministic)
}
func (m *PredictionInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PredictionInput.Merge(m, src)
}
func (m *PredictionInput) XXX_Size() int {
	return xxx_messageInfo_PredictionInput.Size(m)
}
func (m *PredictionInput) XXX_DiscardUnknown() {
	xxx_messageInfo_PredictionInput.DiscardUnknown(m)
}

var xxx_messageInfo_PredictionInput proto.InternalMessageInfo

type isPredictionInput_ModelVersion interface {
	isPredictionInput_ModelVersion()
}

type PredictionInput_ModelName struct {
	ModelName string `protobuf:"bytes,1,opt,name=model_name,json=modelName,proto3,oneof"`
}

type PredictionInput_VersionName struct {
	VersionName string `protobuf:"bytes,2,opt,name=version_name,json=versionName,proto3,oneof"`
}

type PredictionInput_Uri struct {
	Uri string `protobuf:"bytes,9,opt,name=uri,proto3,oneof"`
}

func (*PredictionInput_ModelName) isPredictionInput_ModelVersion() {}

func (*PredictionInput_VersionName) isPredictionInput_ModelVersion() {}

func (*PredictionInput_Uri) isPredictionInput_ModelVersion() {}

func (m *PredictionInput) GetModelVersion() isPredictionInput_ModelVersion {
	if m != nil {
		return m.ModelVersion
	}
	return nil
}

func (m *PredictionInput) GetModelName() string {
	if x, ok := m.GetModelVersion().(*PredictionInput_ModelName); ok {
		return x.ModelName
	}
	return ""
}

func (m *PredictionInput) GetVersionName() string {
	if x, ok := m.GetModelVersion().(*PredictionInput_VersionName); ok {
		return x.VersionName
	}
	return ""
}

func (m *PredictionInput) GetUri() string {
	if x, ok := m.GetModelVersion().(*PredictionInput_Uri); ok {
		return x.Uri
	}
	return ""
}

func (m *PredictionInput) GetDataFormat() PredictionInput_DataFormat {
	if m != nil {
		return m.DataFormat
	}
	return PredictionInput_DATA_FORMAT_UNSPECIFIED
}

func (m *PredictionInput) GetInputPaths() []string {
	if m != nil {
		return m.InputPaths
	}
	return nil
}

func (m *PredictionInput) GetOutputPath() string {
	if m != nil {
		return m.OutputPath
	}
	return ""
}

func (m *PredictionInput) GetMaxWorkerCount() int64 {
	if m != nil {
		return m.MaxWorkerCount
	}
	return 0
}

func (m *PredictionInput) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *PredictionInput) GetRuntimeVersion() string {
	if m != nil {
		return m.RuntimeVersion
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*PredictionInput) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*PredictionInput_ModelName)(nil),
		(*PredictionInput_VersionName)(nil),
		(*PredictionInput_Uri)(nil),
	}
}

// Represents results of a prediction job.
type PredictionOutput struct {
	// The output Google Cloud Storage location provided at the job creation time.
	OutputPath string `protobuf:"bytes,1,opt,name=output_path,json=outputPath,proto3" json:"output_path,omitempty"`
	// The number of generated predictions.
	PredictionCount int64 `protobuf:"varint,2,opt,name=prediction_count,json=predictionCount,proto3" json:"prediction_count,omitempty"`
	// The number of data instances which resulted in errors.
	ErrorCount int64 `protobuf:"varint,3,opt,name=error_count,json=errorCount,proto3" json:"error_count,omitempty"`
	// Node hours used by the batch prediction job.
	NodeHours            float64  `protobuf:"fixed64,4,opt,name=node_hours,json=nodeHours,proto3" json:"node_hours,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PredictionOutput) Reset()         { *m = PredictionOutput{} }
func (m *PredictionOutput) String() string { return proto.CompactTextString(m) }
func (*PredictionOutput) ProtoMessage()    {}
func (*PredictionOutput) Descriptor() ([]byte, []int) {
	return fileDescriptor_a9e7ba15cb43988d, []int{6}
}

func (m *PredictionOutput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PredictionOutput.Unmarshal(m, b)
}
func (m *PredictionOutput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PredictionOutput.Marshal(b, m, deterministic)
}
func (m *PredictionOutput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PredictionOutput.Merge(m, src)
}
func (m *PredictionOutput) XXX_Size() int {
	return xxx_messageInfo_PredictionOutput.Size(m)
}
func (m *PredictionOutput) XXX_DiscardUnknown() {
	xxx_messageInfo_PredictionOutput.DiscardUnknown(m)
}

var xxx_messageInfo_PredictionOutput proto.InternalMessageInfo

func (m *PredictionOutput) GetOutputPath() string {
	if m != nil {
		return m.OutputPath
	}
	return ""
}

func (m *PredictionOutput) GetPredictionCount() int64 {
	if m != nil {
		return m.PredictionCount
	}
	return 0
}

func (m *PredictionOutput) GetErrorCount() int64 {
	if m != nil {
		return m.ErrorCount
	}
	return 0
}

func (m *PredictionOutput) GetNodeHours() float64 {
	if m != nil {
		return m.NodeHours
	}
	return 0
}

// Represents a training or prediction job.
type Job struct {
	// Required. The user-specified id of the job.
	JobId string `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	// Required. Parameters to create a job.
	//
	// Types that are valid to be assigned to Input:
	//	*Job_TrainingInput
	//	*Job_PredictionInput
	Input isJob_Input `protobuf_oneof:"input"`
	// Output only. When the job was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. When the job processing was started.
	StartTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. When the job processing was completed.
	EndTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The detailed state of a job.
	State Job_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.ml.v1.Job_State" json:"state,omitempty"`
	// Output only. The details of a failure or a cancellation.
	ErrorMessage string `protobuf:"bytes,8,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	// Output only. The current result of the job.
	//
	// Types that are valid to be assigned to Output:
	//	*Job_TrainingOutput
	//	*Job_PredictionOutput
	Output               isJob_Output `protobuf_oneof:"output"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Job) Reset()         { *m = Job{} }
func (m *Job) String() string { return proto.CompactTextString(m) }
func (*Job) ProtoMessage()    {}
func (*Job) Descriptor() ([]byte, []int) {
	return fileDescriptor_a9e7ba15cb43988d, []int{7}
}

func (m *Job) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Job.Unmarshal(m, b)
}
func (m *Job) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Job.Marshal(b, m, deterministic)
}
func (m *Job) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Job.Merge(m, src)
}
func (m *Job) XXX_Size() int {
	return xxx_messageInfo_Job.Size(m)
}
func (m *Job) XXX_DiscardUnknown() {
	xxx_messageInfo_Job.DiscardUnknown(m)
}

var xxx_messageInfo_Job proto.InternalMessageInfo

func (m *Job) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

type isJob_Input interface {
	isJob_Input()
}

type Job_TrainingInput struct {
	TrainingInput *TrainingInput `protobuf:"bytes,2,opt,name=training_input,json=trainingInput,proto3,oneof"`
}

type Job_PredictionInput struct {
	PredictionInput *PredictionInput `protobuf:"bytes,3,opt,name=prediction_input,json=predictionInput,proto3,oneof"`
}

func (*Job_TrainingInput) isJob_Input() {}

func (*Job_PredictionInput) isJob_Input() {}

func (m *Job) GetInput() isJob_Input {
	if m != nil {
		return m.Input
	}
	return nil
}

func (m *Job) GetTrainingInput() *TrainingInput {
	if x, ok := m.GetInput().(*Job_TrainingInput); ok {
		return x.TrainingInput
	}
	return nil
}

func (m *Job) GetPredictionInput() *PredictionInput {
	if x, ok := m.GetInput().(*Job_PredictionInput); ok {
		return x.PredictionInput
	}
	return nil
}

func (m *Job) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Job) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *Job) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *Job) GetState() Job_State {
	if m != nil {
		return m.State
	}
	return Job_STATE_UNSPECIFIED
}

func (m *Job) GetErrorMessage() string {
	if m != nil {
		return m.ErrorMessage
	}
	return ""
}

type isJob_Output interface {
	isJob_Output()
}

type Job_TrainingOutput struct {
	TrainingOutput *TrainingOutput `protobuf:"bytes,9,opt,name=training_output,json=trainingOutput,proto3,oneof"`
}

type Job_PredictionOutput struct {
	PredictionOutput *PredictionOutput `protobuf:"bytes,10,opt,name=prediction_output,json=predictionOutput,proto3,oneof"`
}

func (*Job_TrainingOutput) isJob_Output() {}

func (*Job_PredictionOutput) isJob_Output() {}

func (m *Job) GetOutput() isJob_Output {
	if m != nil {
		return m.Output
	}
	return nil
}

func (m *Job) GetTrainingOutput() *TrainingOutput {
	if x, ok := m.GetOutput().(*Job_TrainingOutput); ok {
		return x.TrainingOutput
	}
	return nil
}

func (m *Job) GetPredictionOutput() *PredictionOutput {
	if x, ok := m.GetOutput().(*Job_PredictionOutput); ok {
		return x.PredictionOutput
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Job) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Job_TrainingInput)(nil),
		(*Job_PredictionInput)(nil),
		(*Job_TrainingOutput)(nil),
		(*Job_PredictionOutput)(nil),
	}
}

// Request message for the CreateJob method.
type CreateJobRequest struct {
	// Required. The project name.
	//
	// Authorization: requires `Editor` role on the specified project.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The job to create.
	Job                  *Job     `protobuf:"bytes,2,opt,name=job,proto3" json:"job,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateJobRequest) Reset()         { *m = CreateJobRequest{} }
func (m *CreateJobRequest) String() string { return proto.CompactTextString(m) }
func (*CreateJobRequest) ProtoMessage()    {}
func (*CreateJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a9e7ba15cb43988d, []int{8}
}

func (m *CreateJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateJobRequest.Unmarshal(m, b)
}
func (m *CreateJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateJobRequest.Marshal(b, m, deterministic)
}
func (m *CreateJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateJobRequest.Merge(m, src)
}
func (m *CreateJobRequest) XXX_Size() int {
	return xxx_messageInfo_CreateJobRequest.Size(m)
}
func (m *CreateJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateJobRequest proto.InternalMessageInfo

func (m *CreateJobRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateJobRequest) GetJob() *Job {
	if m != nil {
		return m.Job
	}
	return nil
}

// Request message for the ListJobs method.
type ListJobsRequest struct {
	// Required. The name of the project for which to list jobs.
	//
	// Authorization: requires `Viewer` role on the specified project.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Specifies the subset of jobs to retrieve.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. A page token to request the next page of results.
	//
	// You get the token from the `next_page_token` field of the response from
	// the previous call.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The number of jobs to retrieve per "page" of results. If there
	// are more remaining results than this number, the response message will
	// contain a valid value in the `next_page_token` field.
	//
	// The default value is 20, and the maximum page size is 100.
	PageSize             int32    `protobuf:"varint,5,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListJobsRequest) Reset()         { *m = ListJobsRequest{} }
func (m *ListJobsRequest) String() string { return proto.CompactTextString(m) }
func (*ListJobsRequest) ProtoMessage()    {}
func (*ListJobsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a9e7ba15cb43988d, []int{9}
}

func (m *ListJobsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListJobsRequest.Unmarshal(m, b)
}
func (m *ListJobsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListJobsRequest.Marshal(b, m, deterministic)
}
func (m *ListJobsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListJobsRequest.Merge(m, src)
}
func (m *ListJobsRequest) XXX_Size() int {
	return xxx_messageInfo_ListJobsRequest.Size(m)
}
func (m *ListJobsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListJobsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListJobsRequest proto.InternalMessageInfo

func (m *ListJobsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListJobsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListJobsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListJobsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// Response message for the ListJobs method.
type ListJobsResponse struct {
	// The list of jobs.
	Jobs []*Job `protobuf:"bytes,1,rep,name=jobs,proto3" json:"jobs,omitempty"`
	// Optional. Pass this token as the `page_token` field of the request for a
	// subsequent call.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListJobsResponse) Reset()         { *m = ListJobsResponse{} }
func (m *ListJobsResponse) String() string { return proto.CompactTextString(m) }
func (*ListJobsResponse) ProtoMessage()    {}
func (*ListJobsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a9e7ba15cb43988d, []int{10}
}

func (m *ListJobsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListJobsResponse.Unmarshal(m, b)
}
func (m *ListJobsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListJobsResponse.Marshal(b, m, deterministic)
}
func (m *ListJobsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListJobsResponse.Merge(m, src)
}
func (m *ListJobsResponse) XXX_Size() int {
	return xxx_messageInfo_ListJobsResponse.Size(m)
}
func (m *ListJobsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListJobsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListJobsResponse proto.InternalMessageInfo

func (m *ListJobsResponse) GetJobs() []*Job {
	if m != nil {
		return m.Jobs
	}
	return nil
}

func (m *ListJobsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for the GetJob method.
type GetJobRequest struct {
	// Required. The name of the job to get the description of.
	//
	// Authorization: requires `Viewer` role on the parent project.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetJobRequest) Reset()         { *m = GetJobRequest{} }
func (m *GetJobRequest) String() string { return proto.CompactTextString(m) }
func (*GetJobRequest) ProtoMessage()    {}
func (*GetJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a9e7ba15cb43988d, []int{11}
}

func (m *GetJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetJobRequest.Unmarshal(m, b)
}
func (m *GetJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetJobRequest.Marshal(b, m, deterministic)
}
func (m *GetJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetJobRequest.Merge(m, src)
}
func (m *GetJobRequest) XXX_Size() int {
	return xxx_messageInfo_GetJobRequest.Size(m)
}
func (m *GetJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetJobRequest proto.InternalMessageInfo

func (m *GetJobRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for the CancelJob method.
type CancelJobRequest struct {
	// Required. The name of the job to cancel.
	//
	// Authorization: requires `Editor` role on the parent project.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CancelJobRequest) Reset()         { *m = CancelJobRequest{} }
func (m *CancelJobRequest) String() string { return proto.CompactTextString(m) }
func (*CancelJobRequest) ProtoMessage()    {}
func (*CancelJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a9e7ba15cb43988d, []int{12}
}

func (m *CancelJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CancelJobRequest.Unmarshal(m, b)
}
func (m *CancelJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CancelJobRequest.Marshal(b, m, deterministic)
}
func (m *CancelJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CancelJobRequest.Merge(m, src)
}
func (m *CancelJobRequest) XXX_Size() int {
	return xxx_messageInfo_CancelJobRequest.Size(m)
}
func (m *CancelJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CancelJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CancelJobRequest proto.InternalMessageInfo

func (m *CancelJobRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.cloud.ml.v1.TrainingInput_ScaleTier", TrainingInput_ScaleTier_name, TrainingInput_ScaleTier_value)
	proto.RegisterEnum("google.cloud.ml.v1.HyperparameterSpec_GoalType", HyperparameterSpec_GoalType_name, HyperparameterSpec_GoalType_value)
	proto.RegisterEnum("google.cloud.ml.v1.ParameterSpec_ParameterType", ParameterSpec_ParameterType_name, ParameterSpec_ParameterType_value)
	proto.RegisterEnum("google.cloud.ml.v1.ParameterSpec_ScaleType", ParameterSpec_ScaleType_name, ParameterSpec_ScaleType_value)
	proto.RegisterEnum("google.cloud.ml.v1.PredictionInput_DataFormat", PredictionInput_DataFormat_name, PredictionInput_DataFormat_value)
	proto.RegisterEnum("google.cloud.ml.v1.Job_State", Job_State_name, Job_State_value)
	proto.RegisterType((*TrainingInput)(nil), "google.cloud.ml.v1.TrainingInput")
	proto.RegisterType((*HyperparameterSpec)(nil), "google.cloud.ml.v1.HyperparameterSpec")
	proto.RegisterType((*ParameterSpec)(nil), "google.cloud.ml.v1.ParameterSpec")
	proto.RegisterType((*HyperparameterOutput)(nil), "google.cloud.ml.v1.HyperparameterOutput")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.ml.v1.HyperparameterOutput.HyperparametersEntry")
	proto.RegisterType((*HyperparameterOutput_HyperparameterMetric)(nil), "google.cloud.ml.v1.HyperparameterOutput.HyperparameterMetric")
	proto.RegisterType((*TrainingOutput)(nil), "google.cloud.ml.v1.TrainingOutput")
	proto.RegisterType((*PredictionInput)(nil), "google.cloud.ml.v1.PredictionInput")
	proto.RegisterType((*PredictionOutput)(nil), "google.cloud.ml.v1.PredictionOutput")
	proto.RegisterType((*Job)(nil), "google.cloud.ml.v1.Job")
	proto.RegisterType((*CreateJobRequest)(nil), "google.cloud.ml.v1.CreateJobRequest")
	proto.RegisterType((*ListJobsRequest)(nil), "google.cloud.ml.v1.ListJobsRequest")
	proto.RegisterType((*ListJobsResponse)(nil), "google.cloud.ml.v1.ListJobsResponse")
	proto.RegisterType((*GetJobRequest)(nil), "google.cloud.ml.v1.GetJobRequest")
	proto.RegisterType((*CancelJobRequest)(nil), "google.cloud.ml.v1.CancelJobRequest")
}

func init() {
	proto.RegisterFile("google/cloud/ml/v1/job_service.proto", fileDescriptor_a9e7ba15cb43988d)
}

var fileDescriptor_a9e7ba15cb43988d = []byte{
	// 2070 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x58, 0xdb, 0x6e, 0x1b, 0xc9,
	0x11, 0x15, 0xaf, 0x22, 0x8b, 0x12, 0x39, 0x6e, 0x5b, 0x36, 0x4d, 0xdb, 0x6b, 0x79, 0xe4, 0x38,
	0xb2, 0x17, 0x21, 0x21, 0xed, 0x06, 0xc8, 0x7a, 0xb1, 0x48, 0x28, 0x72, 0x2c, 0x51, 0x10, 0x29,
	0xa6, 0x39, 0x74, 0x36, 0x46, 0x90, 0x49, 0x93, 0x6c, 0xd3, 0x23, 0xcf, 0x2d, 0x33, 0x4d, 0x45,
	0xda, 0x85, 0x81, 0x20, 0x08, 0xf2, 0x03, 0x79, 0x0f, 0xf2, 0x4d, 0xc9, 0x1f, 0x04, 0x01, 0xf2,
	0x01, 0x79, 0x0e, 0x10, 0xf4, 0x85, 0xc3, 0x8b, 0x28, 0xd9, 0x48, 0xde, 0xd8, 0xa7, 0x4e, 0x55,
	0x75, 0x57, 0x55, 0x57, 0xd7, 0x10, 0x9e, 0x8e, 0x7d, 0x7f, 0xec, 0xd0, 0xda, 0xd0, 0xf1, 0x27,
	0xa3, 0x9a, 0xeb, 0xd4, 0xce, 0xf7, 0x6a, 0x67, 0xfe, 0xc0, 0x8a, 0x68, 0x78, 0x6e, 0x0f, 0x69,
	0x35, 0x08, 0x7d, 0xe6, 0x23, 0x24, 0x59, 0x55, 0xc1, 0xaa, 0xba, 0x4e, 0xf5, 0x7c, 0xaf, 0xf2,
	0x50, 0x69, 0x92, 0xc0, 0xae, 0x11, 0xcf, 0xf3, 0x19, 0x61, 0xb6, 0xef, 0x45, 0x52, 0xa3, 0xb2,
	0x35, 0x2f, 0x9d, 0xb0, 0x77, 0x0a, 0x7e, 0xa0, 0x60, 0xb1, 0x1a, 0x4c, 0xde, 0xd6, 0xa8, 0x1b,
	0xb0, 0x4b, 0x25, 0x7c, 0xbc, 0x2c, 0x64, 0xb6, 0x4b, 0x23, 0x46, 0xdc, 0x40, 0x12, 0xf4, 0x3f,
	0x66, 0x60, 0xd3, 0x0c, 0x89, 0xed, 0xd9, 0xde, 0xb8, 0xe5, 0x05, 0x13, 0x86, 0x8e, 0x01, 0xa2,
	0x21, 0x71, 0xa8, 0xc5, 0x6c, 0x1a, 0x96, 0x13, 0xdb, 0x89, 0xdd, 0xe2, 0xfe, 0xe7, 0xd5, 0xab,
	0xbb, 0xad, 0x2e, 0xa8, 0x55, 0x7b, 0x5c, 0xc7, 0xb4, 0x69, 0x88, 0xf3, 0xd1, 0xf4, 0x27, 0x7a,
	0x0c, 0x05, 0x97, 0x44, 0x8c, 0x86, 0x16, 0xbb, 0x0c, 0x68, 0x39, 0xb9, 0x9d, 0xd8, 0xcd, 0x63,
	0x90, 0x90, 0x79, 0x19, 0x50, 0x4e, 0xf8, 0x9d, 0x1f, 0xbe, 0x9f, 0x12, 0x52, 0x92, 0x20, 0x21,
	0x41, 0xd8, 0x87, 0xad, 0x80, 0x84, 0xc4, 0xa5, 0xdc, 0x08, 0x8f, 0xe0, 0x94, 0x9a, 0x16, 0xd4,
	0xdb, 0xb1, 0xb0, 0x27, 0x64, 0x42, 0xe7, 0x09, 0x6c, 0x28, 0xa3, 0x43, 0x7f, 0xe2, 0xb1, 0x72,
	0x66, 0x3b, 0xb1, 0x9b, 0xc2, 0xca, 0x51, 0x83, 0x43, 0xe8, 0x4b, 0xb8, 0x7b, 0xc5, 0xac, 0x24,
	0x67, 0x05, 0xf9, 0xce, 0x92, 0x5d, 0xa9, 0xf5, 0x04, 0x36, 0x02, 0x32, 0x7c, 0x4f, 0xc6, 0xd4,
	0x9a, 0x84, 0x76, 0x54, 0x5e, 0xdf, 0x4e, 0xed, 0xe6, 0x71, 0x41, 0x61, 0xfd, 0xd0, 0x8e, 0xd0,
	0x0e, 0x6c, 0x06, 0x97, 0xec, 0x9d, 0xef, 0x59, 0xae, 0x3f, 0x9a, 0x38, 0xb4, 0x9c, 0x13, 0xfb,
	0xdc, 0x90, 0x60, 0x5b, 0x60, 0x08, 0x41, 0x9a, 0x84, 0xe3, 0xa8, 0x0c, 0x42, 0x5f, 0xfc, 0x46,
	0x5d, 0x28, 0xbd, 0xbb, 0x0c, 0x68, 0x18, 0x3b, 0x8e, 0xca, 0x1b, 0xdb, 0x89, 0xdd, 0xc2, 0xfe,
	0xb3, 0x55, 0xb1, 0x3f, 0x5a, 0xa0, 0xf6, 0x02, 0x3a, 0xc4, 0xcb, 0xea, 0xe8, 0x2e, 0x64, 0x43,
	0x3a, 0xb6, 0x7d, 0xaf, 0x5c, 0x14, 0x7b, 0x50, 0x2b, 0x74, 0x0f, 0xd6, 0x79, 0x39, 0x8e, 0xec,
	0xb0, 0xac, 0x49, 0xc1, 0x99, 0x3f, 0x68, 0xda, 0x21, 0xfa, 0x21, 0x94, 0xc2, 0x89, 0xc7, 0x2b,
	0xc4, 0x3a, 0xa7, 0x61, 0xc4, 0x35, 0x4b, 0x82, 0x50, 0x54, 0xf0, 0x6b, 0x89, 0xea, 0x5d, 0xc8,
	0xc7, 0xe9, 0x46, 0x79, 0xc8, 0x1c, 0xd4, 0x7b, 0xad, 0x86, 0xb6, 0x86, 0x8a, 0x00, 0x3d, 0xb3,
	0xde, 0x69, 0xd6, 0x71, 0xd3, 0xda, 0xd3, 0x12, 0x68, 0x13, 0xf2, 0x5d, 0x6c, 0xb4, 0x5b, 0xfd,
	0xb6, 0xb5, 0xa7, 0xa5, 0xf8, 0x52, 0x30, 0xad, 0xc3, 0x6e, 0x5f, 0xcb, 0x22, 0x80, 0x6c, 0xa3,
	0xdf, 0x33, 0x4f, 0xdb, 0x5a, 0x46, 0xff, 0x47, 0x12, 0xd0, 0xd5, 0x33, 0xa1, 0x06, 0xa4, 0xc7,
	0x3e, 0x71, 0x54, 0x15, 0xd6, 0x3e, 0x2d, 0x12, 0xd5, 0x43, 0x9f, 0x38, 0xbc, 0x10, 0xb0, 0x50,
	0x46, 0x5f, 0x41, 0x56, 0xc8, 0xa3, 0x72, 0x72, 0x3b, 0xb5, 0x5b, 0xd8, 0x7f, 0xb2, 0xca, 0x4c,
	0x77, 0x21, 0x96, 0x4a, 0x01, 0x3d, 0x02, 0x70, 0xc9, 0x85, 0xc5, 0x42, 0x9b, 0x38, 0x91, 0xa8,
	0xce, 0x0c, 0xce, 0xbb, 0xe4, 0xc2, 0x14, 0x00, 0xaa, 0xc2, 0x6d, 0x2e, 0xe6, 0x64, 0xc7, 0xa1,
	0xce, 0x94, 0x97, 0x16, 0xbc, 0x5b, 0x2e, 0xb9, 0xe8, 0x2a, 0x89, 0xe2, 0xbf, 0x84, 0xfb, 0x8b,
	0x49, 0xb2, 0x5c, 0xca, 0x42, 0x7b, 0x68, 0x31, 0x32, 0x16, 0x55, 0x9a, 0xc7, 0xf7, 0x16, 0x09,
	0x6d, 0x21, 0x37, 0xc9, 0x58, 0xaf, 0x43, 0x6e, 0x7a, 0x2e, 0x74, 0x1f, 0xb6, 0x0e, 0x4f, 0xeb,
	0x27, 0x96, 0xf9, 0xcb, 0xae, 0x61, 0xf5, 0x3b, 0xbd, 0xae, 0xd1, 0x68, 0xbd, 0x6a, 0x19, 0x4d,
	0x6d, 0x0d, 0x6d, 0x40, 0xae, 0x5d, 0xff, 0xb6, 0xd5, 0x6e, 0xbd, 0x31, 0xb4, 0x84, 0x58, 0xb5,
	0x3a, 0x72, 0x95, 0xd4, 0xff, 0x9a, 0x86, 0xcd, 0x85, 0x73, 0xa2, 0x1f, 0x40, 0x71, 0xb6, 0x17,
	0x8f, 0xb8, 0x54, 0x44, 0x3a, 0x8f, 0x37, 0x63, 0xb4, 0x43, 0x5c, 0xca, 0xd3, 0x10, 0xdf, 0xb9,
	0x6b, 0xd2, 0xb0, 0x60, 0x77, 0xb6, 0x92, 0x69, 0xe0, 0xca, 0xe8, 0x01, 0xe4, 0x5d, 0xdb, 0xb3,
	0xce, 0x89, 0x33, 0x91, 0x9d, 0x20, 0x81, 0x73, 0xae, 0xed, 0xbd, 0xe6, 0x6b, 0x21, 0x24, 0x17,
	0x4a, 0x98, 0x52, 0x42, 0x72, 0x21, 0x85, 0x3f, 0x02, 0x34, 0x24, 0x8c, 0x8e, 0xfd, 0xd0, 0x1e,
	0x12, 0x47, 0x92, 0xa2, 0x72, 0x46, 0x5c, 0x9e, 0x5b, 0x73, 0x12, 0xc1, 0x8e, 0x78, 0x19, 0x8f,
	0xec, 0x68, 0x18, 0x52, 0x46, 0xa7, 0xdc, 0xec, 0x76, 0x6a, 0x37, 0x81, 0x8b, 0x53, 0x58, 0x11,
	0x67, 0x9d, 0x8e, 0x1f, 0x6e, 0xfd, 0xfa, 0x4e, 0xb7, 0x78, 0x38, 0x59, 0xfa, 0xfc, 0x60, 0xaa,
	0xd3, 0x5d, 0x06, 0x54, 0x1f, 0xcf, 0x85, 0x56, 0xe4, 0xe8, 0x33, 0xa8, 0x74, 0xeb, 0xb8, 0xde,
	0x36, 0x4c, 0x03, 0xaf, 0x4a, 0x14, 0x40, 0xb6, 0x79, 0xda, 0x3f, 0x38, 0xe1, 0x69, 0x2a, 0xc0,
	0x7a, 0xab, 0x63, 0x1a, 0x87, 0x06, 0xd6, 0x92, 0xa8, 0x04, 0x85, 0x46, 0xdd, 0x34, 0x0e, 0x4f,
	0x71, 0xab, 0x51, 0x3f, 0xd1, 0x52, 0x3c, 0x89, 0xcd, 0x56, 0xaf, 0x81, 0x0d, 0xd3, 0xd0, 0xd2,
	0xfa, 0xaf, 0xa6, 0x77, 0x8f, 0x3b, 0xc9, 0x41, 0xba, 0x73, 0xda, 0x31, 0xb4, 0x35, 0xb4, 0x05,
	0xb7, 0xfa, 0x9d, 0x96, 0x69, 0x9d, 0xb4, 0x3a, 0x46, 0x1d, 0x5b, 0xbd, 0x46, 0x5d, 0x58, 0x46,
	0x50, 0x94, 0xf0, 0xe9, 0xa1, 0xc2, 0x92, 0xa8, 0x02, 0x77, 0x05, 0x86, 0x8d, 0xd7, 0x06, 0xee,
	0x19, 0x73, 0xb2, 0x94, 0xfe, 0xa7, 0x34, 0xdc, 0x59, 0xbc, 0x51, 0xa7, 0x13, 0xc6, 0x5f, 0x85,
	0xfb, 0x90, 0x13, 0xd5, 0x6d, 0xd9, 0x23, 0x55, 0x23, 0xeb, 0x62, 0xdd, 0x1a, 0xa1, 0xf1, 0xd5,
	0xce, 0x25, 0x2f, 0xda, 0x37, 0x1f, 0xbf, 0xaf, 0xd2, 0xfa, 0x12, 0x18, 0x19, 0x1e, 0x0b, 0x2f,
	0xaf, 0x36, 0xb4, 0xdf, 0xc0, 0xc6, 0x5b, 0xdb, 0x23, 0x8e, 0xba, 0x35, 0xa2, 0x4e, 0xfe, 0x77,
	0x2f, 0xf2, 0x6a, 0xe1, 0x82, 0x30, 0x29, 0x17, 0xe8, 0xd7, 0x50, 0x20, 0xce, 0xd4, 0x3e, 0xbf,
	0xc8, 0xa9, 0xff, 0xdf, 0x01, 0x10, 0x47, 0x99, 0x8f, 0x2a, 0xa3, 0xe5, 0xe8, 0x2a, 0xbf, 0x3b,
	0xb0, 0xc9, 0xd4, 0x6b, 0x6a, 0x45, 0x8c, 0x06, 0x22, 0xc4, 0x29, 0xbc, 0x31, 0x05, 0x7b, 0x8c,
	0x06, 0xbc, 0xae, 0xfd, 0xc1, 0x19, 0x1d, 0x32, 0xfb, 0x9c, 0x2e, 0x5c, 0xa3, 0x62, 0x0c, 0x8b,
	0xc2, 0xae, 0x1c, 0x2c, 0x7b, 0x91, 0x01, 0x45, 0x1a, 0xa4, 0xde, 0xd3, 0x4b, 0x95, 0x3e, 0xfe,
	0x13, 0xdd, 0x81, 0xcc, 0xcc, 0x50, 0x1e, 0xcb, 0xc5, 0xcb, 0xe4, 0x4f, 0x12, 0xfa, 0xbf, 0x13,
	0x50, 0x9c, 0x3e, 0xf0, 0xaa, 0x04, 0xf6, 0x61, 0x6b, 0xe8, 0xbb, 0x81, 0x43, 0x19, 0x1d, 0xc9,
	0x56, 0xa7, 0x9e, 0x4c, 0xb9, 0xd9, 0xdb, 0xb1, 0x50, 0x74, 0x3b, 0xf9, 0x62, 0xfe, 0x0c, 0xb2,
	0xaa, 0x29, 0xca, 0x92, 0xd8, 0xfd, 0xd4, 0x58, 0x62, 0xa5, 0x87, 0x5e, 0xc0, 0xad, 0xa1, 0xef,
	0x45, 0x13, 0x97, 0x8e, 0x2c, 0xd7, 0xb1, 0x26, 0x9e, 0xcd, 0x22, 0xd5, 0x21, 0x4a, 0x53, 0x41,
	0xdb, 0xe9, 0x73, 0x18, 0xfd, 0x14, 0x1e, 0xda, 0x91, 0xb5, 0xd4, 0x62, 0xd9, 0x44, 0x84, 0xf5,
	0xcc, 0x1f, 0x88, 0xfe, 0x95, 0xc3, 0xf7, 0xed, 0x68, 0xd1, 0xa3, 0x29, 0x18, 0xc7, 0xfe, 0x40,
	0xff, 0x5b, 0x0a, 0x4a, 0xdd, 0x90, 0x8e, 0xec, 0x21, 0x1f, 0xbc, 0xe4, 0x3c, 0xf4, 0x18, 0xc0,
	0xf5, 0x47, 0xd4, 0x99, 0xeb, 0x8f, 0x47, 0x6b, 0x38, 0x2f, 0x30, 0xd1, 0x1d, 0x77, 0x60, 0x43,
	0x3d, 0x97, 0x92, 0x92, 0x54, 0x94, 0x82, 0x42, 0x05, 0x09, 0x41, 0x6a, 0x12, 0xda, 0xe5, 0xbc,
	0x92, 0xf1, 0x05, 0x3a, 0x85, 0xc2, 0x88, 0x30, 0x62, 0xbd, 0xf5, 0x43, 0x97, 0x30, 0x71, 0xa8,
	0xe2, 0x7e, 0x75, 0x65, 0x03, 0x5a, 0xdc, 0x53, 0xb5, 0x49, 0x18, 0x79, 0x25, 0xb4, 0x30, 0x8c,
	0xe2, 0xdf, 0x7c, 0x9a, 0xb2, 0xb9, 0xdc, 0x0a, 0x08, 0x7b, 0x27, 0xcb, 0x37, 0x8f, 0x41, 0x40,
	0x5d, 0x8e, 0x70, 0x82, 0x2f, 0xc2, 0x2b, 0x18, 0xea, 0xc9, 0x01, 0x09, 0x71, 0x06, 0xda, 0x05,
	0x8d, 0xf7, 0xe1, 0x85, 0xf1, 0x49, 0x4e, 0x44, 0x45, 0x97, 0x5c, 0xfc, 0x62, 0x6e, 0x82, 0x9a,
	0x4d, 0x17, 0xeb, 0x0b, 0xd3, 0xc5, 0x8a, 0x21, 0x22, 0xb7, 0x72, 0x88, 0x78, 0x0d, 0x30, 0x3b,
	0x06, 0x7a, 0x00, 0xf7, 0x9a, 0x75, 0xb3, 0x6e, 0xbd, 0x3a, 0xc5, 0xed, 0xba, 0xb9, 0xd4, 0x2b,
	0x73, 0x90, 0x36, 0x8d, 0x6f, 0x4d, 0x39, 0x51, 0x98, 0xaf, 0x2c, 0x6c, 0x34, 0x4e, 0x71, 0x53,
	0x4b, 0xf2, 0xf6, 0x16, 0x2f, 0xad, 0xc3, 0x37, 0xad, 0xae, 0x96, 0x3a, 0x28, 0xc1, 0xa6, 0xcc,
	0x97, 0x72, 0xaf, 0xff, 0x25, 0x01, 0xda, 0x2c, 0x80, 0xaa, 0x98, 0x97, 0x22, 0x91, 0xb8, 0x12,
	0x89, 0xe7, 0xa0, 0x05, 0xb1, 0x92, 0x8a, 0x44, 0x52, 0x44, 0xa2, 0x34, 0xc3, 0x65, 0x28, 0x1e,
	0x43, 0x81, 0x86, 0xa1, 0x3f, 0x8d, 0x57, 0x4a, 0xb0, 0x40, 0x40, 0x92, 0xf0, 0x08, 0xc0, 0xf3,
	0x47, 0xd4, 0x7a, 0xe7, 0x4f, 0x42, 0x39, 0x1e, 0x24, 0x70, 0x9e, 0x23, 0x47, 0x1c, 0xd0, 0xff,
	0x93, 0x81, 0xd4, 0xb1, 0x3f, 0x40, 0x5b, 0xc0, 0x27, 0xb1, 0x59, 0x87, 0xcd, 0x9c, 0xf9, 0x83,
	0xd6, 0x08, 0x1d, 0x43, 0x31, 0x6e, 0x0e, 0x22, 0x97, 0x62, 0x1f, 0xd7, 0xcc, 0x31, 0x0b, 0x43,
	0xf9, 0xd1, 0x1a, 0x8e, 0xfb, 0x8a, 0x2c, 0xe6, 0xee, 0xc2, 0xa9, 0xa4, 0x35, 0xd9, 0x46, 0x77,
	0x3e, 0xa1, 0xee, 0x8e, 0xd6, 0xe6, 0x0f, 0x2f, 0x2d, 0x7e, 0x0d, 0x85, 0x61, 0x48, 0x09, 0xe3,
	0xdf, 0x0b, 0xae, 0x1c, 0x11, 0x0a, 0xfb, 0x95, 0xa9, 0xb1, 0xe9, 0x77, 0x47, 0xd5, 0x9c, 0x7e,
	0x77, 0x60, 0x90, 0x74, 0x0e, 0xa0, 0xaf, 0x00, 0x22, 0x46, 0x42, 0x26, 0x75, 0x33, 0x1f, 0xd5,
	0xcd, 0x0b, 0xb6, 0x50, 0xfd, 0x31, 0xe4, 0xa8, 0x37, 0x92, 0x8a, 0xd9, 0x8f, 0x2a, 0xae, 0x53,
	0x6f, 0x24, 0xd4, 0xbe, 0x80, 0x4c, 0xc4, 0x08, 0x9b, 0x3e, 0xf7, 0x8f, 0x56, 0x9d, 0xfa, 0xd8,
	0x1f, 0x54, 0x7b, 0x9c, 0x84, 0x25, 0x97, 0xb7, 0x67, 0x99, 0x60, 0x97, 0x46, 0x11, 0x19, 0xc7,
	0x43, 0xbd, 0x00, 0xdb, 0x12, 0x43, 0x6d, 0x28, 0xc5, 0x69, 0x92, 0x75, 0x24, 0x6e, 0x7b, 0x61,
	0x5f, 0xbf, 0x29, 0x4f, 0xb2, 0x1c, 0x8f, 0x12, 0x38, 0xce, 0xb1, 0x2a, 0xd0, 0x1e, 0xdc, 0x9a,
	0xcb, 0x94, 0x32, 0x08, 0xc2, 0xe0, 0xd3, 0x9b, 0x53, 0x15, 0x9b, 0x9c, 0x4b, 0xb5, 0xc4, 0xf4,
	0xdf, 0x27, 0x20, 0x23, 0x4e, 0xc6, 0xe7, 0x85, 0x9e, 0x59, 0x37, 0x57, 0x4c, 0x25, 0x3f, 0xef,
	0x1b, 0x7d, 0xa3, 0x19, 0x4f, 0xef, 0xdd, 0x3a, 0x6e, 0x75, 0x0e, 0xb5, 0x24, 0x1f, 0x52, 0x70,
	0xbf, 0xd3, 0xe1, 0x0b, 0x31, 0xca, 0xf7, 0xfa, 0x8d, 0x86, 0x61, 0x34, 0x8d, 0xa6, 0x96, 0xe6,
	0x6a, 0xaf, 0xea, 0xad, 0x13, 0xa3, 0xa9, 0x65, 0xf8, 0x47, 0x40, 0xa3, 0xde, 0x69, 0x18, 0x27,
	0x27, 0x9c, 0x9a, 0xe5, 0x54, 0xb5, 0x36, 0x9a, 0xda, 0xfa, 0xc1, 0x3a, 0x64, 0x44, 0xd9, 0x1d,
	0xe4, 0x20, 0x2b, 0x4f, 0xa5, 0xf7, 0x41, 0x6b, 0x88, 0x9a, 0x38, 0xf6, 0x07, 0x98, 0xfe, 0x76,
	0x42, 0x23, 0xd1, 0x5e, 0x02, 0x12, 0x52, 0xf5, 0xba, 0xe4, 0xb1, 0x5a, 0xa1, 0xe7, 0x90, 0xe2,
	0x9d, 0x5c, 0xde, 0x80, 0x7b, 0xd7, 0x64, 0x0f, 0x73, 0x8e, 0xfe, 0x01, 0x4a, 0x27, 0x76, 0xc4,
	0x8e, 0xfd, 0x41, 0xf4, 0x31, 0xab, 0x77, 0x21, 0xfb, 0xd6, 0x76, 0x18, 0x0d, 0xd5, 0x43, 0xa8,
	0x56, 0xfc, 0xe2, 0x06, 0xfc, 0x6b, 0x8f, 0xf9, 0xef, 0xa9, 0xa7, 0x3e, 0x39, 0xf3, 0x1c, 0x31,
	0x39, 0xc0, 0xa7, 0x56, 0x21, 0x8e, 0xec, 0xef, 0x64, 0xf5, 0x66, 0x70, 0x8e, 0x03, 0x3d, 0xfb,
	0x3b, 0x3e, 0x11, 0x6a, 0x33, 0xf7, 0x51, 0xe0, 0x7b, 0x11, 0x45, 0x9f, 0x43, 0xfa, 0xcc, 0x1f,
	0x44, 0xe5, 0x84, 0x78, 0x0c, 0xaf, 0xdd, 0xbe, 0x20, 0xa1, 0x67, 0x50, 0xf2, 0xe8, 0x05, 0x6f,
	0x50, 0xf1, 0x0e, 0xe4, 0xee, 0x36, 0x39, 0xdc, 0x9d, 0xee, 0x42, 0xdf, 0x81, 0xcd, 0x43, 0xca,
	0xe6, 0x62, 0x87, 0x20, 0x3d, 0x37, 0xcb, 0x8b, 0xdf, 0xfa, 0x33, 0xd0, 0x1a, 0xc4, 0x1b, 0x52,
	0xe7, 0x66, 0xde, 0xfe, 0xbf, 0x52, 0x00, 0xc7, 0xfe, 0xa0, 0x27, 0xff, 0xab, 0x40, 0x13, 0xc8,
	0xc7, 0xa9, 0x41, 0x2b, 0xeb, 0x6e, 0x39, 0x73, 0x95, 0xeb, 0x4e, 0xa5, 0x3f, 0xff, 0xc3, 0xdf,
	0xff, 0xf9, 0xe7, 0xe4, 0x8e, 0xfe, 0xb0, 0x76, 0xbe, 0x57, 0xfb, 0x5e, 0x46, 0xfe, 0x9b, 0x20,
	0xf4, 0xf9, 0xec, 0x12, 0xd5, 0x5e, 0x7c, 0xa8, 0xf1, 0x53, 0xbf, 0xe4, 0xa9, 0x43, 0xdf, 0x43,
	0x6e, 0x1a, 0x3b, 0xb4, 0xb2, 0x31, 0x2d, 0x25, 0xb6, 0xf2, 0xf4, 0x66, 0x92, 0x0c, 0xbf, 0xfe,
	0x54, 0xec, 0xe0, 0x33, 0x74, 0xe3, 0x0e, 0xd0, 0x19, 0x64, 0x65, 0x3c, 0xd1, 0xca, 0x0e, 0xbb,
	0x10, 0xeb, 0xeb, 0x4f, 0xbb, 0xe8, 0x8b, 0xc7, 0x76, 0xce, 0x93, 0x70, 0x54, 0x7b, 0xf1, 0x01,
	0x5d, 0x42, 0x3e, 0x4e, 0xcb, 0x35, 0xf1, 0x5d, 0xca, 0x5a, 0xe5, 0xee, 0x95, 0x36, 0x67, 0xb8,
	0x01, 0xbb, 0xd4, 0xab, 0xc2, 0xe1, 0xae, 0xbe, 0x73, 0x93, 0xc3, 0x97, 0x43, 0x61, 0xee, 0x65,
	0xe2, 0xc5, 0x01, 0x85, 0xca, 0xd0, 0x77, 0xaf, 0xb8, 0x24, 0x81, 0x5d, 0x3d, 0xdf, 0x3b, 0x28,
	0xcd, 0x8a, 0xa0, 0xcb, 0xfd, 0x74, 0x13, 0x6f, 0xbe, 0x54, 0xd4, 0xb1, 0xef, 0x10, 0x6f, 0x5c,
	0xf5, 0xc3, 0x71, 0x6d, 0x4c, 0x3d, 0xb1, 0x8b, 0x9a, 0x14, 0x91, 0xc0, 0x8e, 0xe6, 0xff, 0xf6,
	0xfa, 0xda, 0x75, 0x06, 0x59, 0x41, 0xf8, 0xe2, 0xbf, 0x01, 0x00, 0x00, 0xff, 0xff, 0x4c, 0x7b,
	0x72, 0xd5, 0x16, 0x13, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// JobServiceClient is the client API for JobService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type JobServiceClient interface {
	// Creates a training or a batch prediction job.
	CreateJob(ctx context.Context, in *CreateJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Lists the jobs in the project.
	ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error)
	// Describes a job.
	GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Cancels a running job.
	CancelJob(ctx context.Context, in *CancelJobRequest, opts ...grpc.CallOption) (*empty.Empty, error)
}

type jobServiceClient struct {
	cc *grpc.ClientConn
}

func NewJobServiceClient(cc *grpc.ClientConn) JobServiceClient {
	return &jobServiceClient{cc}
}

func (c *jobServiceClient) CreateJob(ctx context.Context, in *CreateJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, "/google.cloud.ml.v1.JobService/CreateJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error) {
	out := new(ListJobsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.ml.v1.JobService/ListJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, "/google.cloud.ml.v1.JobService/GetJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) CancelJob(ctx context.Context, in *CancelJobRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.ml.v1.JobService/CancelJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// JobServiceServer is the server API for JobService service.
type JobServiceServer interface {
	// Creates a training or a batch prediction job.
	CreateJob(context.Context, *CreateJobRequest) (*Job, error)
	// Lists the jobs in the project.
	ListJobs(context.Context, *ListJobsRequest) (*ListJobsResponse, error)
	// Describes a job.
	GetJob(context.Context, *GetJobRequest) (*Job, error)
	// Cancels a running job.
	CancelJob(context.Context, *CancelJobRequest) (*empty.Empty, error)
}

func RegisterJobServiceServer(s *grpc.Server, srv JobServiceServer) {
	s.RegisterService(&_JobService_serviceDesc, srv)
}

func _JobService_CreateJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).CreateJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.ml.v1.JobService/CreateJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).CreateJob(ctx, req.(*CreateJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_ListJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).ListJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.ml.v1.JobService/ListJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).ListJobs(ctx, req.(*ListJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_GetJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).GetJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.ml.v1.JobService/GetJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).GetJob(ctx, req.(*GetJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_CancelJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).CancelJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.ml.v1.JobService/CancelJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).CancelJob(ctx, req.(*CancelJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _JobService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.ml.v1.JobService",
	HandlerType: (*JobServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateJob",
			Handler:    _JobService_CreateJob_Handler,
		},
		{
			MethodName: "ListJobs",
			Handler:    _JobService_ListJobs_Handler,
		},
		{
			MethodName: "GetJob",
			Handler:    _JobService_GetJob_Handler,
		},
		{
			MethodName: "CancelJob",
			Handler:    _JobService_CancelJob_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/ml/v1/job_service.proto",
}
