// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/devtools/resultstore/v2/resultstore_upload.proto

package resultstore

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request passed into CreateInvocation
type CreateInvocationRequest struct {
	// A unique identifier for this request. Must be set to a different value for
	// each request that affects a given resource (eg. a random UUID). Required
	// for the operation to be idempotent. This is achieved by ignoring this
	// request if the last successful operation on the resource had the same
	// request ID. If set, invocation_id must also be provided.
	// Restricted to 36 utf-8 bytes.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// The invocation ID.  If left empty then a new unique ID will be
	// assigned by the server. If populated, a RFC 4122-compliant v4 UUID is
	// preferred, but v3 or v5 UUIDs are allowed too.
	InvocationId string `protobuf:"bytes,2,opt,name=invocation_id,json=invocationId,proto3" json:"invocation_id,omitempty"`
	// The invocation to create.  Its name field will be ignored, since the name
	// will be derived from the id field above and assigned by the server.
	Invocation *Invocation `protobuf:"bytes,3,opt,name=invocation,proto3" json:"invocation,omitempty"`
	// This is a token to authorize upload access to this invocation. It must be
	// set to a RFC 4122-compliant v3, v4, or v5 UUID. Once this is set in
	// CreateInvocation, all other upload RPCs for that Invocation and any of its
	// child resources must also include the exact same token, or they will be
	// rejected. The generated token should be unique to this invocation, and it
	// should be kept secret.
	//
	// The purpose of this field is to prevent other users and tools from
	// clobbering your upload intentionally or accidentally. The standard way of
	// using this token is to create a second v4 UUID when the invocation_id is
	// created, and storing them together during the upload. Essentially, this is
	// a "password" to the invocation.
	AuthorizationToken string `protobuf:"bytes,4,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	// By default, Invocations are auto-finished if they are not modified for 24
	// hours. If you need auto-finish to happen sooner, set this field to the time
	// you'd like auto-finish to occur.
	AutoFinishTime       *timestamp.Timestamp `protobuf:"bytes,5,opt,name=auto_finish_time,json=autoFinishTime,proto3" json:"auto_finish_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *CreateInvocationRequest) Reset()         { *m = CreateInvocationRequest{} }
func (m *CreateInvocationRequest) String() string { return proto.CompactTextString(m) }
func (*CreateInvocationRequest) ProtoMessage()    {}
func (*CreateInvocationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{0}
}

func (m *CreateInvocationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateInvocationRequest.Unmarshal(m, b)
}
func (m *CreateInvocationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateInvocationRequest.Marshal(b, m, deterministic)
}
func (m *CreateInvocationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateInvocationRequest.Merge(m, src)
}
func (m *CreateInvocationRequest) XXX_Size() int {
	return xxx_messageInfo_CreateInvocationRequest.Size(m)
}
func (m *CreateInvocationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateInvocationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateInvocationRequest proto.InternalMessageInfo

func (m *CreateInvocationRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *CreateInvocationRequest) GetInvocationId() string {
	if m != nil {
		return m.InvocationId
	}
	return ""
}

func (m *CreateInvocationRequest) GetInvocation() *Invocation {
	if m != nil {
		return m.Invocation
	}
	return nil
}

func (m *CreateInvocationRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

func (m *CreateInvocationRequest) GetAutoFinishTime() *timestamp.Timestamp {
	if m != nil {
		return m.AutoFinishTime
	}
	return nil
}

// Request passed into UpdateInvocation
type UpdateInvocationRequest struct {
	// Contains the name and the fields of the invocation to be updated.  The
	// name format must be: invocations/${INVOCATION_ID}
	Invocation *Invocation `protobuf:"bytes,3,opt,name=invocation,proto3" json:"invocation,omitempty"`
	// Indicates which fields to update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken   string   `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateInvocationRequest) Reset()         { *m = UpdateInvocationRequest{} }
func (m *UpdateInvocationRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateInvocationRequest) ProtoMessage()    {}
func (*UpdateInvocationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{1}
}

func (m *UpdateInvocationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateInvocationRequest.Unmarshal(m, b)
}
func (m *UpdateInvocationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateInvocationRequest.Marshal(b, m, deterministic)
}
func (m *UpdateInvocationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateInvocationRequest.Merge(m, src)
}
func (m *UpdateInvocationRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateInvocationRequest.Size(m)
}
func (m *UpdateInvocationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateInvocationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateInvocationRequest proto.InternalMessageInfo

func (m *UpdateInvocationRequest) GetInvocation() *Invocation {
	if m != nil {
		return m.Invocation
	}
	return nil
}

func (m *UpdateInvocationRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateInvocationRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

// Request passed into FinishInvocation
type FinishInvocationRequest struct {
	// The name of the invocation.  Its format must be:
	// invocations/${INVOCATION_ID}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken   string   `protobuf:"bytes,3,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FinishInvocationRequest) Reset()         { *m = FinishInvocationRequest{} }
func (m *FinishInvocationRequest) String() string { return proto.CompactTextString(m) }
func (*FinishInvocationRequest) ProtoMessage()    {}
func (*FinishInvocationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{2}
}

func (m *FinishInvocationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FinishInvocationRequest.Unmarshal(m, b)
}
func (m *FinishInvocationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FinishInvocationRequest.Marshal(b, m, deterministic)
}
func (m *FinishInvocationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FinishInvocationRequest.Merge(m, src)
}
func (m *FinishInvocationRequest) XXX_Size() int {
	return xxx_messageInfo_FinishInvocationRequest.Size(m)
}
func (m *FinishInvocationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_FinishInvocationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_FinishInvocationRequest proto.InternalMessageInfo

func (m *FinishInvocationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *FinishInvocationRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

// Response returned from FinishInvocation
type FinishInvocationResponse struct {
	// The name of the invocation.  Its format will be:
	// invocations/${INVOCATION_ID}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource ID components that identify the Invocation.
	Id                   *Invocation_Id `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *FinishInvocationResponse) Reset()         { *m = FinishInvocationResponse{} }
func (m *FinishInvocationResponse) String() string { return proto.CompactTextString(m) }
func (*FinishInvocationResponse) ProtoMessage()    {}
func (*FinishInvocationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{3}
}

func (m *FinishInvocationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FinishInvocationResponse.Unmarshal(m, b)
}
func (m *FinishInvocationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FinishInvocationResponse.Marshal(b, m, deterministic)
}
func (m *FinishInvocationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FinishInvocationResponse.Merge(m, src)
}
func (m *FinishInvocationResponse) XXX_Size() int {
	return xxx_messageInfo_FinishInvocationResponse.Size(m)
}
func (m *FinishInvocationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_FinishInvocationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_FinishInvocationResponse proto.InternalMessageInfo

func (m *FinishInvocationResponse) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *FinishInvocationResponse) GetId() *Invocation_Id {
	if m != nil {
		return m.Id
	}
	return nil
}

// Request passed into CreateTarget
type CreateTargetRequest struct {
	// A unique identifier for this request. Must be set to a different value for
	// each request that affects a given resource (eg. a random UUID). Required
	// for the operation to be idempotent. This is achieved by ignoring this
	// request if the last successful operation on the resource had the same
	// request ID.  Restricted to 36 utf-8 bytes.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// The name of the parent invocation in which the target is created.
	// Its format must be invocations/${INVOCATION_ID}
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// The target identifier.  It can be any UTF-8 string up to 1024 bytes long
	// except for the reserved id '-'.
	TargetId string `protobuf:"bytes,3,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// The target to create.  Its name field will be ignored, since the name will
	// be derived from the id field above and assigned by the server.
	Target *Target `protobuf:"bytes,4,opt,name=target,proto3" json:"target,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken   string   `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateTargetRequest) Reset()         { *m = CreateTargetRequest{} }
func (m *CreateTargetRequest) String() string { return proto.CompactTextString(m) }
func (*CreateTargetRequest) ProtoMessage()    {}
func (*CreateTargetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{4}
}

func (m *CreateTargetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTargetRequest.Unmarshal(m, b)
}
func (m *CreateTargetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTargetRequest.Marshal(b, m, deterministic)
}
func (m *CreateTargetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTargetRequest.Merge(m, src)
}
func (m *CreateTargetRequest) XXX_Size() int {
	return xxx_messageInfo_CreateTargetRequest.Size(m)
}
func (m *CreateTargetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTargetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTargetRequest proto.InternalMessageInfo

func (m *CreateTargetRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *CreateTargetRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateTargetRequest) GetTargetId() string {
	if m != nil {
		return m.TargetId
	}
	return ""
}

func (m *CreateTargetRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *CreateTargetRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

// Request passed into UpdateTarget
type UpdateTargetRequest struct {
	// Contains the name and the fields of the target to be updated.  The name
	// format must be: invocations/${INVOCATION_ID}/targets/${TARGET_ID}
	Target *Target `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Indicates which fields to update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken   string   `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateTargetRequest) Reset()         { *m = UpdateTargetRequest{} }
func (m *UpdateTargetRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateTargetRequest) ProtoMessage()    {}
func (*UpdateTargetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{5}
}

func (m *UpdateTargetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateTargetRequest.Unmarshal(m, b)
}
func (m *UpdateTargetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateTargetRequest.Marshal(b, m, deterministic)
}
func (m *UpdateTargetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateTargetRequest.Merge(m, src)
}
func (m *UpdateTargetRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateTargetRequest.Size(m)
}
func (m *UpdateTargetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateTargetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateTargetRequest proto.InternalMessageInfo

func (m *UpdateTargetRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *UpdateTargetRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateTargetRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

// Request passed into FinishTarget
type FinishTargetRequest struct {
	// The name of the target.  Its format must be:
	// invocations/${INVOCATION_ID}/targets/${TARGET_ID}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken   string   `protobuf:"bytes,3,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FinishTargetRequest) Reset()         { *m = FinishTargetRequest{} }
func (m *FinishTargetRequest) String() string { return proto.CompactTextString(m) }
func (*FinishTargetRequest) ProtoMessage()    {}
func (*FinishTargetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{6}
}

func (m *FinishTargetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FinishTargetRequest.Unmarshal(m, b)
}
func (m *FinishTargetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FinishTargetRequest.Marshal(b, m, deterministic)
}
func (m *FinishTargetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FinishTargetRequest.Merge(m, src)
}
func (m *FinishTargetRequest) XXX_Size() int {
	return xxx_messageInfo_FinishTargetRequest.Size(m)
}
func (m *FinishTargetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_FinishTargetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_FinishTargetRequest proto.InternalMessageInfo

func (m *FinishTargetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *FinishTargetRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

// Response returned from FinishTarget
type FinishTargetResponse struct {
	// The name of the target.  Its format will be:
	// invocations/${INVOCATION_ID}/targets/${TARGET_ID}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource ID components that identify the Target.
	Id                   *Target_Id `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *FinishTargetResponse) Reset()         { *m = FinishTargetResponse{} }
func (m *FinishTargetResponse) String() string { return proto.CompactTextString(m) }
func (*FinishTargetResponse) ProtoMessage()    {}
func (*FinishTargetResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{7}
}

func (m *FinishTargetResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FinishTargetResponse.Unmarshal(m, b)
}
func (m *FinishTargetResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FinishTargetResponse.Marshal(b, m, deterministic)
}
func (m *FinishTargetResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FinishTargetResponse.Merge(m, src)
}
func (m *FinishTargetResponse) XXX_Size() int {
	return xxx_messageInfo_FinishTargetResponse.Size(m)
}
func (m *FinishTargetResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_FinishTargetResponse.DiscardUnknown(m)
}

var xxx_messageInfo_FinishTargetResponse proto.InternalMessageInfo

func (m *FinishTargetResponse) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *FinishTargetResponse) GetId() *Target_Id {
	if m != nil {
		return m.Id
	}
	return nil
}

// Request passed into CreateConfiguredTarget
type CreateConfiguredTargetRequest struct {
	// A unique identifier for this request. Must be set to a different value for
	// each request that affects a given resource (eg. a random UUID). Required
	// for the operation to be idempotent. This is achieved by ignoring this
	// request if the last successful operation on the resource had the same
	// request ID.  Restricted to 36 utf-8 bytes.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// The name of the parent target in which the configured target is created.
	// Its format must be:
	// invocations/${INVOCATION_ID}/targets/${TARGET_ID}
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// The configuration identifier. This must match the ID of an existing
	// Configuration under this Invocation. Cannot be the reserved id '-'.
	ConfigId string `protobuf:"bytes,3,opt,name=config_id,json=configId,proto3" json:"config_id,omitempty"`
	// The configured target to create. Its name field will be ignored, since the
	// name will be derived from the id field above and assigned by the server.
	ConfiguredTarget *ConfiguredTarget `protobuf:"bytes,4,opt,name=configured_target,json=configuredTarget,proto3" json:"configured_target,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken   string   `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateConfiguredTargetRequest) Reset()         { *m = CreateConfiguredTargetRequest{} }
func (m *CreateConfiguredTargetRequest) String() string { return proto.CompactTextString(m) }
func (*CreateConfiguredTargetRequest) ProtoMessage()    {}
func (*CreateConfiguredTargetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{8}
}

func (m *CreateConfiguredTargetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateConfiguredTargetRequest.Unmarshal(m, b)
}
func (m *CreateConfiguredTargetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateConfiguredTargetRequest.Marshal(b, m, deterministic)
}
func (m *CreateConfiguredTargetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateConfiguredTargetRequest.Merge(m, src)
}
func (m *CreateConfiguredTargetRequest) XXX_Size() int {
	return xxx_messageInfo_CreateConfiguredTargetRequest.Size(m)
}
func (m *CreateConfiguredTargetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateConfiguredTargetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateConfiguredTargetRequest proto.InternalMessageInfo

func (m *CreateConfiguredTargetRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *CreateConfiguredTargetRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateConfiguredTargetRequest) GetConfigId() string {
	if m != nil {
		return m.ConfigId
	}
	return ""
}

func (m *CreateConfiguredTargetRequest) GetConfiguredTarget() *ConfiguredTarget {
	if m != nil {
		return m.ConfiguredTarget
	}
	return nil
}

func (m *CreateConfiguredTargetRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

// Request passed into UpdateConfiguredTarget
type UpdateConfiguredTargetRequest struct {
	// Contains the name and the fields of the configured target to be updated.
	// The name format must be:
	// invocations/${INVOCATION_ID}/targets/${TARGET_ID}/configuredTargets/${CONFIG_ID}
	ConfiguredTarget *ConfiguredTarget `protobuf:"bytes,3,opt,name=configured_target,json=configuredTarget,proto3" json:"configured_target,omitempty"`
	// Indicates which fields to update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken   string   `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateConfiguredTargetRequest) Reset()         { *m = UpdateConfiguredTargetRequest{} }
func (m *UpdateConfiguredTargetRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateConfiguredTargetRequest) ProtoMessage()    {}
func (*UpdateConfiguredTargetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{9}
}

func (m *UpdateConfiguredTargetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateConfiguredTargetRequest.Unmarshal(m, b)
}
func (m *UpdateConfiguredTargetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateConfiguredTargetRequest.Marshal(b, m, deterministic)
}
func (m *UpdateConfiguredTargetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateConfiguredTargetRequest.Merge(m, src)
}
func (m *UpdateConfiguredTargetRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateConfiguredTargetRequest.Size(m)
}
func (m *UpdateConfiguredTargetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateConfiguredTargetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateConfiguredTargetRequest proto.InternalMessageInfo

func (m *UpdateConfiguredTargetRequest) GetConfiguredTarget() *ConfiguredTarget {
	if m != nil {
		return m.ConfiguredTarget
	}
	return nil
}

func (m *UpdateConfiguredTargetRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateConfiguredTargetRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

// Request passed into FinishConfiguredTarget
type FinishConfiguredTargetRequest struct {
	// The name of the configured target. Its format must be:
	// invocations/${INVOCATION_ID}/targets/${TARGET_ID}/configuredTargets/${CONFIG_ID}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken   string   `protobuf:"bytes,3,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FinishConfiguredTargetRequest) Reset()         { *m = FinishConfiguredTargetRequest{} }
func (m *FinishConfiguredTargetRequest) String() string { return proto.CompactTextString(m) }
func (*FinishConfiguredTargetRequest) ProtoMessage()    {}
func (*FinishConfiguredTargetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{10}
}

func (m *FinishConfiguredTargetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FinishConfiguredTargetRequest.Unmarshal(m, b)
}
func (m *FinishConfiguredTargetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FinishConfiguredTargetRequest.Marshal(b, m, deterministic)
}
func (m *FinishConfiguredTargetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FinishConfiguredTargetRequest.Merge(m, src)
}
func (m *FinishConfiguredTargetRequest) XXX_Size() int {
	return xxx_messageInfo_FinishConfiguredTargetRequest.Size(m)
}
func (m *FinishConfiguredTargetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_FinishConfiguredTargetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_FinishConfiguredTargetRequest proto.InternalMessageInfo

func (m *FinishConfiguredTargetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *FinishConfiguredTargetRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

// Response returned from FinishConfiguredTarget
type FinishConfiguredTargetResponse struct {
	// The name of the configured target. Its format must be:
	// invocations/${INVOCATION_ID}/targets/${TARGET_ID}/configuredTargets/${CONFIG_ID}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource ID components that identify the ConfiguredTarget.
	Id                   *ConfiguredTarget_Id `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *FinishConfiguredTargetResponse) Reset()         { *m = FinishConfiguredTargetResponse{} }
func (m *FinishConfiguredTargetResponse) String() string { return proto.CompactTextString(m) }
func (*FinishConfiguredTargetResponse) ProtoMessage()    {}
func (*FinishConfiguredTargetResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{11}
}

func (m *FinishConfiguredTargetResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FinishConfiguredTargetResponse.Unmarshal(m, b)
}
func (m *FinishConfiguredTargetResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FinishConfiguredTargetResponse.Marshal(b, m, deterministic)
}
func (m *FinishConfiguredTargetResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FinishConfiguredTargetResponse.Merge(m, src)
}
func (m *FinishConfiguredTargetResponse) XXX_Size() int {
	return xxx_messageInfo_FinishConfiguredTargetResponse.Size(m)
}
func (m *FinishConfiguredTargetResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_FinishConfiguredTargetResponse.DiscardUnknown(m)
}

var xxx_messageInfo_FinishConfiguredTargetResponse proto.InternalMessageInfo

func (m *FinishConfiguredTargetResponse) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *FinishConfiguredTargetResponse) GetId() *ConfiguredTarget_Id {
	if m != nil {
		return m.Id
	}
	return nil
}

// Request passed into CreateAction
type CreateActionRequest struct {
	// A unique identifier for this request. Must be set to a different value for
	// each request that affects a given resource (eg. a random UUID). Required
	// for the operation to be idempotent. This is achieved by ignoring this
	// request if the last successful operation on the resource had the same
	// request ID.  Restricted to 36 utf-8 bytes.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// The name of the parent configured target in which the action is created.
	// Its format must be:
	// invocations/${INVOCATION_ID}/targets/${TARGET_ID}/configuredTargets/${CONFIG_ID}
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// The action identifier. It can be any UTF-8 string up to 512 bytes long,
	// except for the reserved id '-'.
	ActionId string `protobuf:"bytes,3,opt,name=action_id,json=actionId,proto3" json:"action_id,omitempty"`
	// The action to create.  Its name field will be ignored, since the
	// name will be derived from the id field above and assigned by the server.
	Action *Action `protobuf:"bytes,4,opt,name=action,proto3" json:"action,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken   string   `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateActionRequest) Reset()         { *m = CreateActionRequest{} }
func (m *CreateActionRequest) String() string { return proto.CompactTextString(m) }
func (*CreateActionRequest) ProtoMessage()    {}
func (*CreateActionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{12}
}

func (m *CreateActionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateActionRequest.Unmarshal(m, b)
}
func (m *CreateActionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateActionRequest.Marshal(b, m, deterministic)
}
func (m *CreateActionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateActionRequest.Merge(m, src)
}
func (m *CreateActionRequest) XXX_Size() int {
	return xxx_messageInfo_CreateActionRequest.Size(m)
}
func (m *CreateActionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateActionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateActionRequest proto.InternalMessageInfo

func (m *CreateActionRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *CreateActionRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateActionRequest) GetActionId() string {
	if m != nil {
		return m.ActionId
	}
	return ""
}

func (m *CreateActionRequest) GetAction() *Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (m *CreateActionRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

// Request passed into UpdateAction
type UpdateActionRequest struct {
	// Contains the name and the fields of the action to be updated.  The
	// name format must be:
	// invocations/${INVOCATION_ID}/targets/${TARGET_ID}/configuredTargets/${CONFIG_ID}/actions/${ACTION_ID}
	Action *Action `protobuf:"bytes,3,opt,name=action,proto3" json:"action,omitempty"`
	// Indicates which fields to update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken   string   `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateActionRequest) Reset()         { *m = UpdateActionRequest{} }
func (m *UpdateActionRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateActionRequest) ProtoMessage()    {}
func (*UpdateActionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{13}
}

func (m *UpdateActionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateActionRequest.Unmarshal(m, b)
}
func (m *UpdateActionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateActionRequest.Marshal(b, m, deterministic)
}
func (m *UpdateActionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateActionRequest.Merge(m, src)
}
func (m *UpdateActionRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateActionRequest.Size(m)
}
func (m *UpdateActionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateActionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateActionRequest proto.InternalMessageInfo

func (m *UpdateActionRequest) GetAction() *Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (m *UpdateActionRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateActionRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

// Request passed into CreateConfiguration
type CreateConfigurationRequest struct {
	// A unique identifier for this request. Must be set to a different value for
	// each request that affects a given resource (eg. a random UUID). Required
	// for the operation to be idempotent. This is achieved by ignoring this
	// request if the last successful operation on the resource had the same
	// request ID.  Restricted to 36 utf-8 bytes.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// The name of the parent invocation in which the configuration is created.
	// Its format must be invocations/${INVOCATION_ID}
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// The configuration identifier. It can be any UTF-8 string up to 256 bytes
	// long. The configuration ID of "default" should be preferred for the default
	// configuration in a single-config invocation. Cannot be the reserved id '-'.
	ConfigId string `protobuf:"bytes,3,opt,name=config_id,json=configId,proto3" json:"config_id,omitempty"`
	// The configuration to create. Its name field will be ignored, since the name
	// will be derived from the id field above and assigned by the server.
	Configuration *Configuration `protobuf:"bytes,4,opt,name=configuration,proto3" json:"configuration,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken   string   `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateConfigurationRequest) Reset()         { *m = CreateConfigurationRequest{} }
func (m *CreateConfigurationRequest) String() string { return proto.CompactTextString(m) }
func (*CreateConfigurationRequest) ProtoMessage()    {}
func (*CreateConfigurationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{14}
}

func (m *CreateConfigurationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateConfigurationRequest.Unmarshal(m, b)
}
func (m *CreateConfigurationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateConfigurationRequest.Marshal(b, m, deterministic)
}
func (m *CreateConfigurationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateConfigurationRequest.Merge(m, src)
}
func (m *CreateConfigurationRequest) XXX_Size() int {
	return xxx_messageInfo_CreateConfigurationRequest.Size(m)
}
func (m *CreateConfigurationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateConfigurationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateConfigurationRequest proto.InternalMessageInfo

func (m *CreateConfigurationRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *CreateConfigurationRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateConfigurationRequest) GetConfigId() string {
	if m != nil {
		return m.ConfigId
	}
	return ""
}

func (m *CreateConfigurationRequest) GetConfiguration() *Configuration {
	if m != nil {
		return m.Configuration
	}
	return nil
}

func (m *CreateConfigurationRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

// Request passed into UpdateConfiguration
type UpdateConfigurationRequest struct {
	// Contains the name and fields of the configuration to be updated. The name
	// format must be: invocations/${INVOCATION_ID}/configs/${CONFIG_ID}
	Configuration *Configuration `protobuf:"bytes,3,opt,name=configuration,proto3" json:"configuration,omitempty"`
	// Indicates which fields to update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken   string   `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateConfigurationRequest) Reset()         { *m = UpdateConfigurationRequest{} }
func (m *UpdateConfigurationRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateConfigurationRequest) ProtoMessage()    {}
func (*UpdateConfigurationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{15}
}

func (m *UpdateConfigurationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateConfigurationRequest.Unmarshal(m, b)
}
func (m *UpdateConfigurationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateConfigurationRequest.Marshal(b, m, deterministic)
}
func (m *UpdateConfigurationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateConfigurationRequest.Merge(m, src)
}
func (m *UpdateConfigurationRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateConfigurationRequest.Size(m)
}
func (m *UpdateConfigurationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateConfigurationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateConfigurationRequest proto.InternalMessageInfo

func (m *UpdateConfigurationRequest) GetConfiguration() *Configuration {
	if m != nil {
		return m.Configuration
	}
	return nil
}

func (m *UpdateConfigurationRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateConfigurationRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

// Request passed into CreateFileSet
type CreateFileSetRequest struct {
	// A unique identifier for this request. Must be set to a different value for
	// each request that affects a given resource (eg. a random UUID). Required
	// for the operation to be idempotent. This is achieved by ignoring this
	// request if the last successful operation on the resource had the same
	// request ID.  Restricted to 36 utf-8 bytes.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// The name of the parent invocation in which the file set is created.
	// Its format must be invocations/${INVOCATION_ID}
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// The file set identifier. It can be any UTF-8 string up to 256 bytes long.
	FileSetId string `protobuf:"bytes,3,opt,name=file_set_id,json=fileSetId,proto3" json:"file_set_id,omitempty"`
	// The file set to create. Its name field will be ignored, since the name will
	// be derived from the id field above and assigned by the server.
	FileSet *FileSet `protobuf:"bytes,4,opt,name=file_set,json=fileSet,proto3" json:"file_set,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken   string   `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateFileSetRequest) Reset()         { *m = CreateFileSetRequest{} }
func (m *CreateFileSetRequest) String() string { return proto.CompactTextString(m) }
func (*CreateFileSetRequest) ProtoMessage()    {}
func (*CreateFileSetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{16}
}

func (m *CreateFileSetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateFileSetRequest.Unmarshal(m, b)
}
func (m *CreateFileSetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateFileSetRequest.Marshal(b, m, deterministic)
}
func (m *CreateFileSetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateFileSetRequest.Merge(m, src)
}
func (m *CreateFileSetRequest) XXX_Size() int {
	return xxx_messageInfo_CreateFileSetRequest.Size(m)
}
func (m *CreateFileSetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateFileSetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateFileSetRequest proto.InternalMessageInfo

func (m *CreateFileSetRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *CreateFileSetRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateFileSetRequest) GetFileSetId() string {
	if m != nil {
		return m.FileSetId
	}
	return ""
}

func (m *CreateFileSetRequest) GetFileSet() *FileSet {
	if m != nil {
		return m.FileSet
	}
	return nil
}

func (m *CreateFileSetRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

// Request passed into UpdateFileSet
type UpdateFileSetRequest struct {
	// Contains the name and fields of the file set to be updated. The name format
	// must be: invocations/${INVOCATION_ID}/fileSets/${FILE_SET_ID}
	FileSet *FileSet `protobuf:"bytes,1,opt,name=file_set,json=fileSet,proto3" json:"file_set,omitempty"`
	// Indicates which fields to update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken   string   `protobuf:"bytes,3,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateFileSetRequest) Reset()         { *m = UpdateFileSetRequest{} }
func (m *UpdateFileSetRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateFileSetRequest) ProtoMessage()    {}
func (*UpdateFileSetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c379de3a2f884aa, []int{17}
}

func (m *UpdateFileSetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateFileSetRequest.Unmarshal(m, b)
}
func (m *UpdateFileSetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateFileSetRequest.Marshal(b, m, deterministic)
}
func (m *UpdateFileSetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateFileSetRequest.Merge(m, src)
}
func (m *UpdateFileSetRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateFileSetRequest.Size(m)
}
func (m *UpdateFileSetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateFileSetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateFileSetRequest proto.InternalMessageInfo

func (m *UpdateFileSetRequest) GetFileSet() *FileSet {
	if m != nil {
		return m.FileSet
	}
	return nil
}

func (m *UpdateFileSetRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateFileSetRequest) GetAuthorizationToken() string {
	if m != nil {
		return m.AuthorizationToken
	}
	return ""
}

func init() {
	proto.RegisterType((*CreateInvocationRequest)(nil), "google.devtools.resultstore.v2.CreateInvocationRequest")
	proto.RegisterType((*UpdateInvocationRequest)(nil), "google.devtools.resultstore.v2.UpdateInvocationRequest")
	proto.RegisterType((*FinishInvocationRequest)(nil), "google.devtools.resultstore.v2.FinishInvocationRequest")
	proto.RegisterType((*FinishInvocationResponse)(nil), "google.devtools.resultstore.v2.FinishInvocationResponse")
	proto.RegisterType((*CreateTargetRequest)(nil), "google.devtools.resultstore.v2.CreateTargetRequest")
	proto.RegisterType((*UpdateTargetRequest)(nil), "google.devtools.resultstore.v2.UpdateTargetRequest")
	proto.RegisterType((*FinishTargetRequest)(nil), "google.devtools.resultstore.v2.FinishTargetRequest")
	proto.RegisterType((*FinishTargetResponse)(nil), "google.devtools.resultstore.v2.FinishTargetResponse")
	proto.RegisterType((*CreateConfiguredTargetRequest)(nil), "google.devtools.resultstore.v2.CreateConfiguredTargetRequest")
	proto.RegisterType((*UpdateConfiguredTargetRequest)(nil), "google.devtools.resultstore.v2.UpdateConfiguredTargetRequest")
	proto.RegisterType((*FinishConfiguredTargetRequest)(nil), "google.devtools.resultstore.v2.FinishConfiguredTargetRequest")
	proto.RegisterType((*FinishConfiguredTargetResponse)(nil), "google.devtools.resultstore.v2.FinishConfiguredTargetResponse")
	proto.RegisterType((*CreateActionRequest)(nil), "google.devtools.resultstore.v2.CreateActionRequest")
	proto.RegisterType((*UpdateActionRequest)(nil), "google.devtools.resultstore.v2.UpdateActionRequest")
	proto.RegisterType((*CreateConfigurationRequest)(nil), "google.devtools.resultstore.v2.CreateConfigurationRequest")
	proto.RegisterType((*UpdateConfigurationRequest)(nil), "google.devtools.resultstore.v2.UpdateConfigurationRequest")
	proto.RegisterType((*CreateFileSetRequest)(nil), "google.devtools.resultstore.v2.CreateFileSetRequest")
	proto.RegisterType((*UpdateFileSetRequest)(nil), "google.devtools.resultstore.v2.UpdateFileSetRequest")
}

func init() {
	proto.RegisterFile("google/devtools/resultstore/v2/resultstore_upload.proto", fileDescriptor_3c379de3a2f884aa)
}

var fileDescriptor_3c379de3a2f884aa = []byte{
	// 1348 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x99, 0xcf, 0x6f, 0xdc, 0x44,
	0x14, 0xc7, 0x35, 0xbb, 0x6d, 0x69, 0x5e, 0x12, 0x48, 0x27, 0x51, 0x12, 0x19, 0x92, 0x46, 0x0e,
	0x82, 0x26, 0x34, 0xeb, 0xe2, 0x84, 0xa6, 0xdd, 0x2a, 0x11, 0x4d, 0x50, 0xda, 0x2d, 0x42, 0x6a,
	0x37, 0xa9, 0x90, 0x2a, 0x95, 0x95, 0xbb, 0x9e, 0xdd, 0x5a, 0xd9, 0xb5, 0xb7, 0x6b, 0x6f, 0x24,
	0x40, 0x5c, 0xe0, 0x4f, 0xe0, 0x8a, 0x04, 0x17, 0x38, 0xf2, 0x43, 0xe2, 0x86, 0x38, 0xc1, 0x01,
	0xce, 0xbd, 0x21, 0x24, 0x04, 0xe2, 0x88, 0x38, 0x72, 0x46, 0x9e, 0x19, 0xef, 0xce, 0xf8, 0xc7,
	0xda, 0xde, 0xae, 0x72, 0xb3, 0xbd, 0xf3, 0xec, 0xcf, 0x77, 0xde, 0xd7, 0x33, 0xef, 0x79, 0x61,
	0xbb, 0xe9, 0x38, 0xcd, 0x16, 0xd1, 0x4c, 0x72, 0xe2, 0x39, 0x4e, 0xcb, 0xd5, 0xba, 0xc4, 0xed,
	0xb5, 0x3c, 0xd7, 0x73, 0xba, 0x44, 0x3b, 0xd1, 0xc5, 0xd3, 0x5a, 0xaf, 0xd3, 0x72, 0x0c, 0xb3,
	0xd4, 0xe9, 0x3a, 0x9e, 0x83, 0x97, 0x59, 0x60, 0x29, 0x08, 0x2c, 0x09, 0x23, 0x4b, 0x27, 0xba,
	0xf2, 0x12, 0xbf, 0xb1, 0xd1, 0xb1, 0x34, 0xc3, 0xb6, 0x1d, 0xcf, 0xf0, 0x2c, 0xc7, 0x76, 0x59,
	0xb4, 0xf2, 0x5a, 0xca, 0x63, 0x8d, 0xba, 0x3f, 0x9a, 0x0f, 0xd6, 0x53, 0x06, 0xd7, 0x1d, 0xbb,
	0x61, 0x35, 0x7b, 0x5d, 0x43, 0x88, 0xb9, 0x9a, 0x31, 0x86, 0x98, 0x35, 0xcf, 0xe8, 0x36, 0x89,
	0xc7, 0xe3, 0x36, 0x52, 0xe2, 0x1a, 0x56, 0x8b, 0xd4, 0xdc, 0xfe, 0x70, 0x2d, 0x65, 0xb8, 0x65,
	0x9f, 0x38, 0x75, 0x91, 0x2b, 0x4d, 0xb8, 0x04, 0xb3, 0xc2, 0x07, 0xd3, 0xb3, 0x47, 0xbd, 0x86,
	0xd6, 0xb0, 0x48, 0xcb, 0xac, 0xb5, 0x0d, 0xf7, 0x98, 0x8f, 0xb8, 0x18, 0x1e, 0xe1, 0x59, 0x6d,
	0xe2, 0x7a, 0x46, 0xbb, 0xc3, 0x06, 0xa8, 0x5f, 0x14, 0x60, 0x61, 0xbf, 0x4b, 0x0c, 0x8f, 0x54,
	0xfa, 0x28, 0x55, 0xf2, 0xa4, 0x47, 0x5c, 0x0f, 0x2f, 0x01, 0x74, 0xd9, 0x61, 0xcd, 0x32, 0x17,
	0xd1, 0x0a, 0xba, 0x34, 0x51, 0x9d, 0xe0, 0x57, 0x2a, 0x26, 0x5e, 0x85, 0xe9, 0x01, 0xbe, 0x3f,
	0xa2, 0x40, 0x47, 0x4c, 0x0d, 0x2e, 0x56, 0x4c, 0x7c, 0x07, 0x60, 0x70, 0xbe, 0x58, 0x5c, 0x41,
	0x97, 0x26, 0xf5, 0xf5, 0xd2, 0x70, 0x6f, 0x94, 0x04, 0x14, 0x21, 0x1a, 0x6b, 0x30, 0x6b, 0xf4,
	0xbc, 0xc7, 0x4e, 0xd7, 0xfa, 0x80, 0x3d, 0xd3, 0x73, 0x8e, 0x89, 0xbd, 0x78, 0x86, 0x3e, 0x16,
	0x4b, 0x3f, 0x1d, 0xf9, 0xbf, 0xe0, 0xb7, 0x60, 0xc6, 0xe8, 0x79, 0x4e, 0xad, 0x61, 0xd9, 0x96,
	0xfb, 0xb8, 0xe6, 0x6b, 0x5f, 0x3c, 0x4b, 0x11, 0x94, 0x00, 0x21, 0x98, 0x98, 0xd2, 0x51, 0x30,
	0x31, 0xd5, 0xe7, 0xfd, 0x98, 0x03, 0x1a, 0xe2, 0x5f, 0x54, 0x9f, 0x22, 0x58, 0xb8, 0xdf, 0x31,
	0x63, 0xa7, 0x68, 0x9c, 0xf2, 0x6e, 0xc0, 0x64, 0x8f, 0x3e, 0x86, 0x26, 0x90, 0xca, 0x8a, 0x03,
	0x3d, 0xf0, 0x73, 0xfc, 0x8e, 0xe1, 0x1e, 0x57, 0x81, 0x0d, 0xf7, 0x8f, 0x93, 0xe6, 0xe6, 0x6c,
	0xd2, 0xdc, 0xa8, 0xef, 0xc1, 0x02, 0xd3, 0x18, 0x15, 0x85, 0xe1, 0x8c, 0x6d, 0xb4, 0x09, 0xcf,
	0x38, 0x3d, 0x4e, 0xba, 0x7f, 0x31, 0xf1, 0xfe, 0x6d, 0x58, 0x8c, 0xde, 0xdf, 0xed, 0x38, 0xb6,
	0x4b, 0x62, 0x1f, 0xb0, 0x03, 0x05, 0x6e, 0xa1, 0x49, 0x7d, 0x23, 0xfb, 0x0c, 0x96, 0x2a, 0x66,
	0xb5, 0x60, 0x99, 0xea, 0x6f, 0x08, 0x66, 0x99, 0x8f, 0x8f, 0xe8, 0x1b, 0x92, 0xd1, 0xc3, 0xf3,
	0x70, 0xae, 0x63, 0x74, 0x89, 0xed, 0x71, 0xf3, 0xf2, 0x33, 0xfc, 0x22, 0x4c, 0xb0, 0x37, 0xcd,
	0x8f, 0x62, 0x22, 0xcf, 0xb3, 0x0b, 0x15, 0x13, 0xef, 0xc2, 0x39, 0x76, 0xcc, 0x73, 0xf4, 0x4a,
	0x1a, 0x2e, 0x47, 0xe2, 0x51, 0xf9, 0x73, 0xf5, 0x13, 0x82, 0x59, 0xe6, 0x40, 0x59, 0xdc, 0x00,
	0xa4, 0x38, 0x12, 0xc8, 0xe9, 0x3a, 0xee, 0x01, 0xcc, 0xf2, 0xb7, 0x4a, 0x12, 0x31, 0x16, 0xb7,
	0x11, 0x98, 0x93, 0xef, 0x3d, 0xc4, 0x69, 0xd7, 0x05, 0xa7, 0xad, 0x65, 0x9b, 0xb1, 0xc0, 0x65,
	0x9f, 0x14, 0x60, 0x89, 0xb9, 0x6c, 0xbf, 0xbf, 0x3f, 0x8c, 0xcb, 0x6f, 0x6c, 0xc7, 0x11, 0xfc,
	0xc6, 0x2e, 0x54, 0x4c, 0xfc, 0x10, 0x2e, 0x44, 0xb6, 0x23, 0x9e, 0xac, 0x2b, 0x69, 0xfc, 0x11,
	0xce, 0x99, 0x7a, 0xe8, 0x4a, 0xfe, 0x44, 0xfe, 0x83, 0x60, 0x89, 0xd9, 0x31, 0x69, 0x16, 0x62,
	0x89, 0x8b, 0x63, 0x23, 0x3e, 0x5d, 0xdf, 0x9a, 0xb0, 0xc4, 0xbc, 0x95, 0xa4, 0x76, 0x2c, 0x0e,
	0x7e, 0x1f, 0x96, 0x93, 0x9e, 0x32, 0xc4, 0xcb, 0xfb, 0x82, 0x97, 0x37, 0xf3, 0xce, 0x6c, 0x74,
	0xed, 0xbc, 0x59, 0xcf, 0xb1, 0xff, 0x0f, 0xf1, 0x32, 0x2b, 0xcf, 0x04, 0x2f, 0xb3, 0x0b, 0x6c,
	0xed, 0x64, 0xc7, 0x59, 0xd7, 0x4e, 0x8e, 0xc4, 0xa3, 0x9e, 0x65, 0xed, 0x94, 0xc5, 0x0d, 0x40,
	0x8a, 0x23, 0x81, 0x9c, 0xae, 0x07, 0xff, 0x43, 0xa0, 0xc8, 0x0b, 0x8f, 0x31, 0x9e, 0x4c, 0x25,
	0xaf, 0x3a, 0x87, 0x30, 0x2d, 0x15, 0xce, 0x5c, 0xe2, 0x46, 0x56, 0x97, 0x31, 0x40, 0xf9, 0x1e,
	0xf9, 0x85, 0xff, 0x81, 0x40, 0x91, 0xd7, 0x1a, 0x49, 0x78, 0x04, 0xb2, 0x38, 0x06, 0xc8, 0xd3,
	0x4d, 0xed, 0x5f, 0x08, 0xe6, 0x58, 0x6a, 0x0f, 0xac, 0x16, 0x39, 0x7c, 0xe6, 0xad, 0x64, 0x19,
	0x26, 0x83, 0x26, 0x64, 0x90, 0xd6, 0x89, 0x06, 0xbb, 0x77, 0xc5, 0xc4, 0x7b, 0x70, 0x3e, 0xf8,
	0x9d, 0x4b, 0x7b, 0x35, 0x6d, 0xb6, 0x02, 0xb0, 0xe7, 0xf8, 0x5d, 0xf2, 0x8b, 0xfc, 0x05, 0xc1,
	0x1c, 0x4b, 0x63, 0x48, 0xa4, 0x48, 0x83, 0x46, 0xa4, 0x09, 0xe5, 0xab, 0x30, 0x8e, 0x7c, 0x25,
	0x2e, 0xd4, 0xfa, 0xf7, 0xf3, 0x70, 0xa1, 0x4a, 0x89, 0x0e, 0x7d, 0xa2, 0xfb, 0xb4, 0xe9, 0xc5,
	0x9f, 0x21, 0x98, 0x09, 0xf7, 0x51, 0x78, 0x3b, 0xd5, 0x86, 0xf1, 0x9d, 0x97, 0x92, 0xa3, 0x85,
	0x50, 0x57, 0x3f, 0x7e, 0xfa, 0xf7, 0xa7, 0x85, 0x25, 0xf5, 0x05, 0xb9, 0x9f, 0x74, 0xcb, 0x62,
	0x6f, 0xf1, 0x2d, 0x82, 0x99, 0x70, 0x0f, 0x93, 0x8e, 0x97, 0xd0, 0xf5, 0xe4, 0xc2, 0xdb, 0xa6,
	0x78, 0xaf, 0xeb, 0xab, 0x3e, 0xde, 0x87, 0x42, 0xbf, 0xeb, 0xef, 0x5f, 0x3b, 0x02, 0xaf, 0xb6,
	0xfe, 0x91, 0x84, 0xfc, 0x1d, 0x82, 0x99, 0x70, 0x07, 0x91, 0x8e, 0x9c, 0xd0, 0xd3, 0x28, 0xd7,
	0xf2, 0x07, 0xb2, 0x6d, 0x57, 0x5d, 0xa7, 0x02, 0x5e, 0x56, 0x2f, 0x52, 0x01, 0x71, 0xd4, 0xac,
	0xbd, 0x2c, 0xa3, 0x75, 0xfc, 0x39, 0x82, 0x29, 0xb1, 0x0b, 0xc1, 0x9b, 0xd9, 0x1c, 0x20, 0xd5,
	0x13, 0x4a, 0xc6, 0x32, 0x5e, 0xd5, 0x29, 0xd9, 0x65, 0x55, 0xa5, 0x64, 0xec, 0xf5, 0x0f, 0xb1,
	0xf1, 0xef, 0x05, 0x6e, 0x39, 0x28, 0xf9, 0xbf, 0x42, 0x30, 0x25, 0xb6, 0x12, 0xe9, 0x84, 0x31,
	0x8d, 0x47, 0x66, 0xc2, 0xeb, 0x94, 0x70, 0x53, 0x5f, 0xa3, 0x84, 0xfc, 0xdb, 0x45, 0x74, 0x0a,
	0x03, 0x4a, 0x7f, 0x32, 0x03, 0xd0, 0x6f, 0x10, 0x4c, 0x89, 0x25, 0x7d, 0x3a, 0x68, 0x4c, 0x73,
	0xa1, 0x6c, 0xe5, 0x0b, 0xe2, 0x29, 0xdf, 0xa2, 0xd8, 0x25, 0x75, 0x2d, 0x21, 0xe5, 0x22, 0xef,
	0x20, 0xf9, 0xbf, 0x23, 0x98, 0x8f, 0x6f, 0x0e, 0xf0, 0x4e, 0x36, 0x1b, 0x24, 0x14, 0x98, 0x4a,
	0xee, 0x9a, 0x59, 0xbd, 0x47, 0x15, 0xbc, 0xad, 0x5e, 0x4d, 0xb4, 0x86, 0xa0, 0x41, 0x0b, 0x17,
	0xd8, 0x6e, 0x39, 0x5a, 0xbe, 0xe3, 0x7f, 0x11, 0xcc, 0xc7, 0x57, 0xfd, 0xe9, 0xf2, 0x86, 0x76,
	0x0b, 0x23, 0xc8, 0xab, 0x53, 0x79, 0x0f, 0xf5, 0xdb, 0x54, 0x5e, 0xf4, 0x5b, 0xdd, 0xb0, 0x94,
	0x45, 0xd5, 0xfa, 0x69, 0x8c, 0x11, 0xfc, 0x27, 0x82, 0xf9, 0xf8, 0x92, 0x3c, 0x5d, 0xf0, 0xd0,
	0x86, 0x41, 0xd9, 0x1d, 0x35, 0x9c, 0xfb, 0xf3, 0x36, 0x95, 0xbf, 0xa7, 0xee, 0xa4, 0xfa, 0x33,
	0x5e, 0xec, 0xc0, 0xb3, 0x3f, 0xf6, 0x17, 0x2c, 0x56, 0xde, 0x66, 0x5d, 0xb0, 0xa4, 0x5a, 0x5a,
	0xc9, 0x58, 0x3b, 0xab, 0x77, 0x29, 0xf7, 0x1d, 0xf5, 0xcd, 0x0c, 0xae, 0x8c, 0x25, 0xe7, 0xdf,
	0x7d, 0xdd, 0x72, 0x50, 0x85, 0xff, 0xdc, 0x5f, 0xce, 0xb2, 0xf2, 0xc7, 0xf4, 0x02, 0x99, 0xf9,
	0xdf, 0xa5, 0xfc, 0xf7, 0xf4, 0x5b, 0x94, 0x9f, 0x7f, 0x83, 0xce, 0x3b, 0xfd, 0x81, 0x06, 0xba,
	0xd8, 0x71, 0x19, 0x3f, 0xf4, 0x3b, 0x30, 0xa9, 0x30, 0xc5, 0xe5, 0x7c, 0xeb, 0x86, 0xb4, 0xe3,
	0xe5, 0xab, 0x81, 0x83, 0xa5, 0x7a, 0xe8, 0x66, 0xc2, 0xd4, 0xb8, 0xe5, 0x50, 0xbd, 0xfc, 0x6b,
	0xbf, 0xc5, 0xca, 0x49, 0x9f, 0x5c, 0xd8, 0xe7, 0xa5, 0xbf, 0x45, 0xe9, 0x6f, 0xea, 0x57, 0xa4,
	0x05, 0x21, 0xa9, 0xd0, 0x08, 0x84, 0xf8, 0x29, 0x08, 0x69, 0xf9, 0x12, 0xc1, 0xb4, 0x54, 0x8d,
	0xe3, 0xad, 0x6c, 0x39, 0x90, 0xeb, 0x5a, 0x25, 0x6b, 0x15, 0xab, 0xbe, 0x41, 0xc9, 0x35, 0x75,
	0x75, 0xc8, 0xbc, 0xf3, 0x42, 0xd7, 0x2d, 0xf7, 0x6b, 0x65, 0xfc, 0x35, 0x82, 0x69, 0xa9, 0xa0,
	0x4e, 0xe7, 0x8c, 0xab, 0xbf, 0xb3, 0x73, 0xee, 0x52, 0xce, 0x6b, 0xfa, 0x65, 0xca, 0xd9, 0xff,
	0x9b, 0x23, 0x66, 0x72, 0x03, 0x5a, 0x7f, 0x76, 0xfb, 0xc0, 0x7b, 0x4f, 0x40, 0xad, 0x3b, 0xed,
	0x94, 0xa7, 0xdd, 0x45, 0x0f, 0x2a, 0x7c, 0x44, 0xd3, 0x69, 0x19, 0x76, 0xb3, 0xe4, 0x74, 0x9b,
	0x5a, 0x93, 0xd8, 0xb4, 0x88, 0xe7, 0x7f, 0xa6, 0x18, 0x1d, 0xcb, 0x4d, 0xfa, 0x7f, 0xe4, 0x86,
	0x70, 0xfa, 0xe8, 0x1c, 0x8d, 0xda, 0xfc, 0x3f, 0x00, 0x00, 0xff, 0xff, 0x5e, 0xa6, 0x1a, 0x3d,
	0xc4, 0x1a, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ResultStoreUploadClient is the client API for ResultStoreUpload service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ResultStoreUploadClient interface {
	// Creates the given invocation. Generally, a unique ID will be assigned to
	// the invocation's name field by the server. This is not an implicitly
	// idempotent API, so a request id is required to make it idempotent.
	//
	// Returns an empty Invocation proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If an invocation with the same ID already exists.
	CreateInvocation(ctx context.Context, in *CreateInvocationRequest, opts ...grpc.CallOption) (*Invocation, error)
	// Applies a standard update to the invocation identified by the given proto's
	// name.  For all types of fields (primitive, message, or repeated), replaces
	// them with the given proto fields if they are under the given field mask
	// paths.  Fields that match the mask but aren't populated in the given
	// invocation are cleared. This is an implicitly idempotent API.
	//
	// Returns an empty Invocation proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If the invocation does not exist.
	// - If the invocation is finished.
	// - If no field mask was given.
	UpdateInvocation(ctx context.Context, in *UpdateInvocationRequest, opts ...grpc.CallOption) (*Invocation, error)
	// Declares the invocation with the given name as finished and immutable.
	// This is an implicitly idempotent API.
	//
	// If an Invocation is not updated for 24 hours, some time after that
	// this will be called automatically.
	//
	// An error will be reported in the following cases:
	// - If the invocation does not exist.
	FinishInvocation(ctx context.Context, in *FinishInvocationRequest, opts ...grpc.CallOption) (*FinishInvocationResponse, error)
	// Creates the given target under the given parent invocation. The given
	// target ID is URL encoded, converted to the full resource name, and assigned
	// to the target's name field. This is not an implicitly idempotent API, so a
	// request id is required to make it idempotent.
	//
	// Returns an empty Target proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If no target ID is provided.
	// - If the parent invocation does not exist.
	// - If the parent invocation is finished.
	// - If a target with the same name already exists.
	CreateTarget(ctx context.Context, in *CreateTargetRequest, opts ...grpc.CallOption) (*Target, error)
	// Applies a standard update to the target identified by the given proto's
	// name. For all types of fields (primitive, message, or repeated), replaces
	// them with the given proto fields if they are under the given field mask
	// paths. Fields that match the mask but aren't populated in the given
	// target are cleared. This is an implicitly idempotent API.
	//
	// Returns an empty Target proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If the target does not exist.
	// - If the target or parent invocation is finished.
	// - If no field mask was given.
	UpdateTarget(ctx context.Context, in *UpdateTargetRequest, opts ...grpc.CallOption) (*Target, error)
	// Declares the target with the given name as finished and immutable.
	// This is an implicitly idempotent API.
	//
	// An error will be reported in the following cases:
	// - If the target does not exist.
	FinishTarget(ctx context.Context, in *FinishTargetRequest, opts ...grpc.CallOption) (*FinishTargetResponse, error)
	// Creates the given configured target under the given parent target.
	// The given configured target ID is URL encoded, converted to the full
	// resource name, and assigned to the configured target's name field.
	// This is not an implicitly idempotent API, so a request id is required
	// to make it idempotent.
	//
	// Returns an empty ConfiguredTarget proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If no config ID is provided.
	// - If a configured target with the same ID already exists.
	// - If the parent target does not exist.
	// - If the parent target or invocation is finished.
	CreateConfiguredTarget(ctx context.Context, in *CreateConfiguredTargetRequest, opts ...grpc.CallOption) (*ConfiguredTarget, error)
	// Applies a standard update to the configured target identified by the given
	// proto's name. For all types of fields (primitive, message, or repeated),
	// replaces them with the given proto fields if they are under the given
	// field mask paths. Fields that match the mask but aren't populated in the
	// given configured target are cleared. This is an implicitly idempotent API.
	//
	// Returns an empty ConfiguredTarget proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If the configured target does not exist.
	// - If the parent target or invocation is finished.
	// - If no field mask was given.
	UpdateConfiguredTarget(ctx context.Context, in *UpdateConfiguredTargetRequest, opts ...grpc.CallOption) (*ConfiguredTarget, error)
	// Declares the configured target with the given name as finished and
	// immutable. This is an implicitly idempotent API.
	//
	// An error will be reported in the following cases:
	// - If the configured target does not exist.
	FinishConfiguredTarget(ctx context.Context, in *FinishConfiguredTargetRequest, opts ...grpc.CallOption) (*FinishConfiguredTargetResponse, error)
	// Creates the given action under the given configured target. The given
	// action ID is URL encoded, converted to the full resource name, and
	// assigned to the action's name field. This is not an implicitly
	// idempotent API, so a request id is required to make it idempotent.
	//
	// Returns an empty Action proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If no action ID provided.
	// - If the parent configured target does not exist.
	// - If the parent target or invocation is finished.
	// - If an action  with the same name already exists.
	CreateAction(ctx context.Context, in *CreateActionRequest, opts ...grpc.CallOption) (*Action, error)
	// Applies a standard update to the action identified by the given
	// proto's name.  For all types of fields (primitive, message, or repeated),
	// replaces them with the given proto fields if they are under the given
	// field mask paths.  Fields that match the mask but aren't populated in the
	// given action are cleared.  This is an implicitly idempotent API.
	//
	// Returns an empty Action proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If the action does not exist.
	// - If the parent target or invocation is finished.
	// - If no field mask was given.
	UpdateAction(ctx context.Context, in *UpdateActionRequest, opts ...grpc.CallOption) (*Action, error)
	// Creates the given configuration under the given parent invocation. The
	// given configuration ID is URL encoded, converted to the full resource name,
	// and assigned to the configuration's name field. The configuration ID of
	// "default" should be preferred for the default configuration in a
	// single-config invocation. This is not an implicitly idempotent API, so a
	// request id is required to make it idempotent.
	//
	// Returns an empty Configuration proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If no configuration ID is provided.
	// - If the parent invocation does not exist.
	// - If the parent invocation is finished.
	// - If a configuration with the same name already exists.
	CreateConfiguration(ctx context.Context, in *CreateConfigurationRequest, opts ...grpc.CallOption) (*Configuration, error)
	// Applies a standard update to the configuration identified by the given
	// proto's name. For all types of fields (primitive, message, or repeated),
	// replaces them with the given proto fields if they are under the given field
	// mask paths. Fields that match the mask but aren't populated in the given
	// configuration are cleared. This is an implicitly idempotent API.
	//
	// Returns an empty Configuration proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If the configuration does not exist.
	// - If the parent invocation is finished.
	// - If no field mask was given.
	// - If a given field mask path is not valid.
	UpdateConfiguration(ctx context.Context, in *UpdateConfigurationRequest, opts ...grpc.CallOption) (*Configuration, error)
	// Creates the given file set under the given parent invocation. The given
	// file set ID is URL encoded, converted to the full resource name, and
	// assigned to the file set's name field. This is not an implicitly idempotent
	// API, so a request id is required to make it idempotent.
	//
	// Returns an empty FileSet proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If no file set ID is provided.
	// - If a file set with the same name already exists.
	// - If the parent invocation does not exist.
	// - If the parent invocation is finished.
	CreateFileSet(ctx context.Context, in *CreateFileSetRequest, opts ...grpc.CallOption) (*FileSet, error)
	// Applies a standard update to the file set identified by the given proto's
	// name. For all types of fields (primitive, message, or repeated), replaces
	// them with the given proto fields if they are under the given field mask
	// paths. Fields that match the mask but aren't populated in the given
	// configuration are cleared. This is an implicitly idempotent API.
	//
	// Returns an empty FileSet proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If the file set does not exist.
	// - If the parent invocation is finished.
	// - If no field mask was given.
	// - If a given field mask path is not valid.
	UpdateFileSet(ctx context.Context, in *UpdateFileSetRequest, opts ...grpc.CallOption) (*FileSet, error)
}

type resultStoreUploadClient struct {
	cc *grpc.ClientConn
}

func NewResultStoreUploadClient(cc *grpc.ClientConn) ResultStoreUploadClient {
	return &resultStoreUploadClient{cc}
}

func (c *resultStoreUploadClient) CreateInvocation(ctx context.Context, in *CreateInvocationRequest, opts ...grpc.CallOption) (*Invocation, error) {
	out := new(Invocation)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/CreateInvocation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) UpdateInvocation(ctx context.Context, in *UpdateInvocationRequest, opts ...grpc.CallOption) (*Invocation, error) {
	out := new(Invocation)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateInvocation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) FinishInvocation(ctx context.Context, in *FinishInvocationRequest, opts ...grpc.CallOption) (*FinishInvocationResponse, error) {
	out := new(FinishInvocationResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/FinishInvocation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) CreateTarget(ctx context.Context, in *CreateTargetRequest, opts ...grpc.CallOption) (*Target, error) {
	out := new(Target)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/CreateTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) UpdateTarget(ctx context.Context, in *UpdateTargetRequest, opts ...grpc.CallOption) (*Target, error) {
	out := new(Target)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) FinishTarget(ctx context.Context, in *FinishTargetRequest, opts ...grpc.CallOption) (*FinishTargetResponse, error) {
	out := new(FinishTargetResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/FinishTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) CreateConfiguredTarget(ctx context.Context, in *CreateConfiguredTargetRequest, opts ...grpc.CallOption) (*ConfiguredTarget, error) {
	out := new(ConfiguredTarget)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/CreateConfiguredTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) UpdateConfiguredTarget(ctx context.Context, in *UpdateConfiguredTargetRequest, opts ...grpc.CallOption) (*ConfiguredTarget, error) {
	out := new(ConfiguredTarget)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateConfiguredTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) FinishConfiguredTarget(ctx context.Context, in *FinishConfiguredTargetRequest, opts ...grpc.CallOption) (*FinishConfiguredTargetResponse, error) {
	out := new(FinishConfiguredTargetResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/FinishConfiguredTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) CreateAction(ctx context.Context, in *CreateActionRequest, opts ...grpc.CallOption) (*Action, error) {
	out := new(Action)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/CreateAction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) UpdateAction(ctx context.Context, in *UpdateActionRequest, opts ...grpc.CallOption) (*Action, error) {
	out := new(Action)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateAction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) CreateConfiguration(ctx context.Context, in *CreateConfigurationRequest, opts ...grpc.CallOption) (*Configuration, error) {
	out := new(Configuration)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/CreateConfiguration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) UpdateConfiguration(ctx context.Context, in *UpdateConfigurationRequest, opts ...grpc.CallOption) (*Configuration, error) {
	out := new(Configuration)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateConfiguration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) CreateFileSet(ctx context.Context, in *CreateFileSetRequest, opts ...grpc.CallOption) (*FileSet, error) {
	out := new(FileSet)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/CreateFileSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) UpdateFileSet(ctx context.Context, in *UpdateFileSetRequest, opts ...grpc.CallOption) (*FileSet, error) {
	out := new(FileSet)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateFileSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ResultStoreUploadServer is the server API for ResultStoreUpload service.
type ResultStoreUploadServer interface {
	// Creates the given invocation. Generally, a unique ID will be assigned to
	// the invocation's name field by the server. This is not an implicitly
	// idempotent API, so a request id is required to make it idempotent.
	//
	// Returns an empty Invocation proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If an invocation with the same ID already exists.
	CreateInvocation(context.Context, *CreateInvocationRequest) (*Invocation, error)
	// Applies a standard update to the invocation identified by the given proto's
	// name.  For all types of fields (primitive, message, or repeated), replaces
	// them with the given proto fields if they are under the given field mask
	// paths.  Fields that match the mask but aren't populated in the given
	// invocation are cleared. This is an implicitly idempotent API.
	//
	// Returns an empty Invocation proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If the invocation does not exist.
	// - If the invocation is finished.
	// - If no field mask was given.
	UpdateInvocation(context.Context, *UpdateInvocationRequest) (*Invocation, error)
	// Declares the invocation with the given name as finished and immutable.
	// This is an implicitly idempotent API.
	//
	// If an Invocation is not updated for 24 hours, some time after that
	// this will be called automatically.
	//
	// An error will be reported in the following cases:
	// - If the invocation does not exist.
	FinishInvocation(context.Context, *FinishInvocationRequest) (*FinishInvocationResponse, error)
	// Creates the given target under the given parent invocation. The given
	// target ID is URL encoded, converted to the full resource name, and assigned
	// to the target's name field. This is not an implicitly idempotent API, so a
	// request id is required to make it idempotent.
	//
	// Returns an empty Target proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If no target ID is provided.
	// - If the parent invocation does not exist.
	// - If the parent invocation is finished.
	// - If a target with the same name already exists.
	CreateTarget(context.Context, *CreateTargetRequest) (*Target, error)
	// Applies a standard update to the target identified by the given proto's
	// name. For all types of fields (primitive, message, or repeated), replaces
	// them with the given proto fields if they are under the given field mask
	// paths. Fields that match the mask but aren't populated in the given
	// target are cleared. This is an implicitly idempotent API.
	//
	// Returns an empty Target proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If the target does not exist.
	// - If the target or parent invocation is finished.
	// - If no field mask was given.
	UpdateTarget(context.Context, *UpdateTargetRequest) (*Target, error)
	// Declares the target with the given name as finished and immutable.
	// This is an implicitly idempotent API.
	//
	// An error will be reported in the following cases:
	// - If the target does not exist.
	FinishTarget(context.Context, *FinishTargetRequest) (*FinishTargetResponse, error)
	// Creates the given configured target under the given parent target.
	// The given configured target ID is URL encoded, converted to the full
	// resource name, and assigned to the configured target's name field.
	// This is not an implicitly idempotent API, so a request id is required
	// to make it idempotent.
	//
	// Returns an empty ConfiguredTarget proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If no config ID is provided.
	// - If a configured target with the same ID already exists.
	// - If the parent target does not exist.
	// - If the parent target or invocation is finished.
	CreateConfiguredTarget(context.Context, *CreateConfiguredTargetRequest) (*ConfiguredTarget, error)
	// Applies a standard update to the configured target identified by the given
	// proto's name. For all types of fields (primitive, message, or repeated),
	// replaces them with the given proto fields if they are under the given
	// field mask paths. Fields that match the mask but aren't populated in the
	// given configured target are cleared. This is an implicitly idempotent API.
	//
	// Returns an empty ConfiguredTarget proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If the configured target does not exist.
	// - If the parent target or invocation is finished.
	// - If no field mask was given.
	UpdateConfiguredTarget(context.Context, *UpdateConfiguredTargetRequest) (*ConfiguredTarget, error)
	// Declares the configured target with the given name as finished and
	// immutable. This is an implicitly idempotent API.
	//
	// An error will be reported in the following cases:
	// - If the configured target does not exist.
	FinishConfiguredTarget(context.Context, *FinishConfiguredTargetRequest) (*FinishConfiguredTargetResponse, error)
	// Creates the given action under the given configured target. The given
	// action ID is URL encoded, converted to the full resource name, and
	// assigned to the action's name field. This is not an implicitly
	// idempotent API, so a request id is required to make it idempotent.
	//
	// Returns an empty Action proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If no action ID provided.
	// - If the parent configured target does not exist.
	// - If the parent target or invocation is finished.
	// - If an action  with the same name already exists.
	CreateAction(context.Context, *CreateActionRequest) (*Action, error)
	// Applies a standard update to the action identified by the given
	// proto's name.  For all types of fields (primitive, message, or repeated),
	// replaces them with the given proto fields if they are under the given
	// field mask paths.  Fields that match the mask but aren't populated in the
	// given action are cleared.  This is an implicitly idempotent API.
	//
	// Returns an empty Action proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If the action does not exist.
	// - If the parent target or invocation is finished.
	// - If no field mask was given.
	UpdateAction(context.Context, *UpdateActionRequest) (*Action, error)
	// Creates the given configuration under the given parent invocation. The
	// given configuration ID is URL encoded, converted to the full resource name,
	// and assigned to the configuration's name field. The configuration ID of
	// "default" should be preferred for the default configuration in a
	// single-config invocation. This is not an implicitly idempotent API, so a
	// request id is required to make it idempotent.
	//
	// Returns an empty Configuration proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If no configuration ID is provided.
	// - If the parent invocation does not exist.
	// - If the parent invocation is finished.
	// - If a configuration with the same name already exists.
	CreateConfiguration(context.Context, *CreateConfigurationRequest) (*Configuration, error)
	// Applies a standard update to the configuration identified by the given
	// proto's name. For all types of fields (primitive, message, or repeated),
	// replaces them with the given proto fields if they are under the given field
	// mask paths. Fields that match the mask but aren't populated in the given
	// configuration are cleared. This is an implicitly idempotent API.
	//
	// Returns an empty Configuration proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If the configuration does not exist.
	// - If the parent invocation is finished.
	// - If no field mask was given.
	// - If a given field mask path is not valid.
	UpdateConfiguration(context.Context, *UpdateConfigurationRequest) (*Configuration, error)
	// Creates the given file set under the given parent invocation. The given
	// file set ID is URL encoded, converted to the full resource name, and
	// assigned to the file set's name field. This is not an implicitly idempotent
	// API, so a request id is required to make it idempotent.
	//
	// Returns an empty FileSet proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If no file set ID is provided.
	// - If a file set with the same name already exists.
	// - If the parent invocation does not exist.
	// - If the parent invocation is finished.
	CreateFileSet(context.Context, *CreateFileSetRequest) (*FileSet, error)
	// Applies a standard update to the file set identified by the given proto's
	// name. For all types of fields (primitive, message, or repeated), replaces
	// them with the given proto fields if they are under the given field mask
	// paths. Fields that match the mask but aren't populated in the given
	// configuration are cleared. This is an implicitly idempotent API.
	//
	// Returns an empty FileSet proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If the file set does not exist.
	// - If the parent invocation is finished.
	// - If no field mask was given.
	// - If a given field mask path is not valid.
	UpdateFileSet(context.Context, *UpdateFileSetRequest) (*FileSet, error)
}

func RegisterResultStoreUploadServer(s *grpc.Server, srv ResultStoreUploadServer) {
	s.RegisterService(&_ResultStoreUpload_serviceDesc, srv)
}

func _ResultStoreUpload_CreateInvocation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInvocationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).CreateInvocation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/CreateInvocation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).CreateInvocation(ctx, req.(*CreateInvocationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_UpdateInvocation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInvocationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).UpdateInvocation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateInvocation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).UpdateInvocation(ctx, req.(*UpdateInvocationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_FinishInvocation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FinishInvocationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).FinishInvocation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/FinishInvocation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).FinishInvocation(ctx, req.(*FinishInvocationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_CreateTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).CreateTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/CreateTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).CreateTarget(ctx, req.(*CreateTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_UpdateTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).UpdateTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).UpdateTarget(ctx, req.(*UpdateTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_FinishTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FinishTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).FinishTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/FinishTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).FinishTarget(ctx, req.(*FinishTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_CreateConfiguredTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConfiguredTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).CreateConfiguredTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/CreateConfiguredTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).CreateConfiguredTarget(ctx, req.(*CreateConfiguredTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_UpdateConfiguredTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConfiguredTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).UpdateConfiguredTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateConfiguredTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).UpdateConfiguredTarget(ctx, req.(*UpdateConfiguredTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_FinishConfiguredTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FinishConfiguredTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).FinishConfiguredTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/FinishConfiguredTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).FinishConfiguredTarget(ctx, req.(*FinishConfiguredTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_CreateAction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateActionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).CreateAction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/CreateAction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).CreateAction(ctx, req.(*CreateActionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_UpdateAction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateActionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).UpdateAction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateAction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).UpdateAction(ctx, req.(*UpdateActionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_CreateConfiguration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConfigurationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).CreateConfiguration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/CreateConfiguration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).CreateConfiguration(ctx, req.(*CreateConfigurationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_UpdateConfiguration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConfigurationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).UpdateConfiguration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateConfiguration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).UpdateConfiguration(ctx, req.(*UpdateConfigurationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_CreateFileSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFileSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).CreateFileSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/CreateFileSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).CreateFileSet(ctx, req.(*CreateFileSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_UpdateFileSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFileSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).UpdateFileSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateFileSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).UpdateFileSet(ctx, req.(*UpdateFileSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ResultStoreUpload_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.resultstore.v2.ResultStoreUpload",
	HandlerType: (*ResultStoreUploadServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateInvocation",
			Handler:    _ResultStoreUpload_CreateInvocation_Handler,
		},
		{
			MethodName: "UpdateInvocation",
			Handler:    _ResultStoreUpload_UpdateInvocation_Handler,
		},
		{
			MethodName: "FinishInvocation",
			Handler:    _ResultStoreUpload_FinishInvocation_Handler,
		},
		{
			MethodName: "CreateTarget",
			Handler:    _ResultStoreUpload_CreateTarget_Handler,
		},
		{
			MethodName: "UpdateTarget",
			Handler:    _ResultStoreUpload_UpdateTarget_Handler,
		},
		{
			MethodName: "FinishTarget",
			Handler:    _ResultStoreUpload_FinishTarget_Handler,
		},
		{
			MethodName: "CreateConfiguredTarget",
			Handler:    _ResultStoreUpload_CreateConfiguredTarget_Handler,
		},
		{
			MethodName: "UpdateConfiguredTarget",
			Handler:    _ResultStoreUpload_UpdateConfiguredTarget_Handler,
		},
		{
			MethodName: "FinishConfiguredTarget",
			Handler:    _ResultStoreUpload_FinishConfiguredTarget_Handler,
		},
		{
			MethodName: "CreateAction",
			Handler:    _ResultStoreUpload_CreateAction_Handler,
		},
		{
			MethodName: "UpdateAction",
			Handler:    _ResultStoreUpload_UpdateAction_Handler,
		},
		{
			MethodName: "CreateConfiguration",
			Handler:    _ResultStoreUpload_CreateConfiguration_Handler,
		},
		{
			MethodName: "UpdateConfiguration",
			Handler:    _ResultStoreUpload_UpdateConfiguration_Handler,
		},
		{
			MethodName: "CreateFileSet",
			Handler:    _ResultStoreUpload_CreateFileSet_Handler,
		},
		{
			MethodName: "UpdateFileSet",
			Handler:    _ResultStoreUpload_UpdateFileSet_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/resultstore/v2/resultstore_upload.proto",
}
