// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/openshift/api/operator/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// NetworkLister helps list Networks.
type NetworkLister interface {
	// List lists all Networks in the indexer.
	List(selector labels.Selector) (ret []*v1.Network, err error)
	// Get retrieves the Network from the index for a given name.
	Get(name string) (*v1.Network, error)
	NetworkListerExpansion
}

// networkLister implements the NetworkLister interface.
type networkLister struct {
	indexer cache.Indexer
}

// NewNetworkLister returns a new NetworkLister.
func NewNetworkLister(indexer cache.Indexer) NetworkLister {
	return &networkLister{indexer: indexer}
}

// List lists all Networks in the indexer.
func (s *networkLister) List(selector labels.Selector) (ret []*v1.Network, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.Network))
	})
	return ret, err
}

// Get retrieves the Network from the index for a given name.
func (s *networkLister) Get(name string) (*v1.Network, error) {
	obj, exists, err := s.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("network"), name)
	}
	return obj.(*v1.Network), nil
}
