/*
 * REST API
 *
 * Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!
 *
 * API version: v1
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package rockset
import (
    "bytes"
    "encoding/json"
    "fmt"
    
)

// Integrations that can be associated with data sources to create collections. Only one type of integration may be specified.
type Integration struct {
	// ISO-8601 date
	CreatedAt string `json:"created_at,omitempty"`
	// email of user who created the integration
	CreatedBy string `json:"created_by"`
	// descriptive label and unique identifier
	Name string `json:"name"`
	// longer explanation for the integration
	Description string `json:"description,omitempty"`
	// Amazon S3 details, must have one of aws_access_key or aws_role
	S3 *S3Integration `json:"s3,omitempty"`
	// Amazon Kinesis details, must have one of aws_access_key or aws_role
	Kinesis *KinesisIntegration `json:"kinesis,omitempty"`
	// Amazon DynamoDB details, must have one of aws_access_key or aws_role
	Dynamodb *DynamodbIntegration `json:"dynamodb,omitempty"`
	// Amazon Redshift details
	Redshift *RedshiftIntegration `json:"redshift,omitempty"`
	// GCS details
	Gcs *GcsIntegration `json:"gcs,omitempty"`
	// credentials for an AWS key integration
	Aws *AwsKeyIntegration `json:"aws,omitempty"`
	// details of an AWS External Id integration
	AwsExternalId *AwsExternalIdIntegration `json:"aws_external_id,omitempty"`
	// details of a GCP Service Account integration
	GcpServiceAccount *GcpServiceAccount `json:"gcp_service_account,omitempty"`
}
func (m Integration) PrintResponse() {
    r, err := json.Marshal(m)
    var out bytes.Buffer
    err = json.Indent(&out, []byte(string(r)), "", "    ")
    if err != nil {
        fmt.Println("error parsing string")
        return
    }

    fmt.Println(out.String())
}

