// Code generated by go-bindata.
// sources:
// i18n/resources/de_DE.all.json
// i18n/resources/en_US.all.json
// i18n/resources/es_ES.all.json
// i18n/resources/fr_FR.all.json
// i18n/resources/it_IT.all.json
// i18n/resources/ja_JP.all.json
// i18n/resources/ko_KR.all.json
// i18n/resources/pt_BR.all.json
// i18n/resources/zh_Hans.all.json
// i18n/resources/zh_Hant.all.json
// DO NOT EDIT!

package resources

import (
	"bytes"
	"compress/gzip"
	"fmt"
	"io"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

func bindataRead(data []byte, name string) ([]byte, error) {
	gz, err := gzip.NewReader(bytes.NewBuffer(data))
	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}

	var buf bytes.Buffer
	_, err = io.Copy(&buf, gz)
	clErr := gz.Close()

	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}
	if clErr != nil {
		return nil, err
	}

	return buf.Bytes(), nil
}

type asset struct {
	bytes []byte
	info  os.FileInfo
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

func (fi bindataFileInfo) Name() string {
	return fi.name
}
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}
func (fi bindataFileInfo) IsDir() bool {
	return false
}
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _i18nResourcesDe_deAllJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xb4\x96\xc1\x92\xda\x46\x10\x86\xef\xfb\x14\x5d\x5c\x74\x59\x53\xe5\x2b\x37\xb2\x16\xd8\xb5\x1b\x20\x08\xe2\xaa\x84\x1c\x06\xa9\x25\x8d\x77\xd4\x43\x66\x7a\x20\x0b\xa5\xd7\xca\xc9\xb7\x7d\xb1\xd4\x48\x10\xd6\x8e\x06\x13\xd7\xfa\x42\x09\x34\xfd\xf7\xf7\x6b\x98\xbf\xf5\xfb\x0d\xc0\xe1\x06\x00\xa0\x27\xb3\xde\x00\x7a\x2b\x8a\x89\xd1\x80\x00\x72\xd5\x1a\x4d\xef\xb6\xbd\xcb\x46\x90\x55\x82\xa5\xa6\x76\xd9\x18\xd7\x48\x90\x48\x04\x94\x84\xf0\x9b\x28\x95\xbf\xea\xf7\x6e\x00\xea\xdb\xaf\x65\x87\x04\x68\x8c\x36\xa0\xd3\xd4\x19\x83\x19\xec\x4a\x24\x48\x0d\x0a\x96\x54\x80\xd2\x05\xe4\x52\x21\x44\x87\x43\x7f\x26\xb8\xac\xeb\x68\xb0\xa2\xc3\xa1\x1f\xfb\xb2\xba\x5e\xd1\x8a\x02\x2c\x3f\xa1\xac\x20\x36\x96\x51\x29\x24\xc8\xd0\xc0\xcc\x68\xd6\x8f\x5a\xa9\x4c\x30\xca\x97\xa2\x20\x2d\x7b\x4e\x18\x61\xa9\xbc\x4f\x97\x17\xc8\x06\x19\xe9\xbf\xfd\xae\xb6\xe2\xc9\x33\x57\x6d\xbc\x15\x83\x7f\x3a\xb4\xfc\x95\x5a\x98\xbd\x01\x1e\x52\xae\x4d\x86\xc6\x51\x01\x7b\xf7\xd2\x8e\x7f\xba\x16\x92\x0d\xca\xb4\x44\x23\x9c\xdd\xbb\xc2\x5e\xef\xe2\x7b\x3d\xd8\x8d\x26\x8b\xff\xd7\x04\xef\xb4\x61\x58\xe3\xfe\xf9\x73\xa1\x64\x5a\x36\x3f\x1f\xbd\x78\x6b\x3f\xc4\xcc\x9d\x76\x2a\x03\xd2\x0c\x06\x45\x06\xb9\xd1\x15\x48\xda\x38\x1e\x40\x00\xf8\x52\x45\x67\x8b\x58\x89\x8d\xc5\x6c\x10\xd0\xfb\x15\x8d\x65\xe3\x3d\xd1\x20\x20\xf0\x17\xa3\x21\xa1\x40\x38\x2e\x91\x58\xa6\x4d\x31\xe4\x42\x2a\xcc\xfa\xd0\x58\x84\x54\x67\x38\x80\x93\xe3\x3b\x9d\x61\x5d\xdf\x42\x85\xd6\x8a\xa2\xbd\xf1\x73\x7b\x5d\xd7\x01\x92\xd7\xef\xd3\x69\x67\x34\xfc\xf0\x10\xbf\x0b\x30\x8c\xe2\xf7\x0f\xe3\x38\xb9\x7b\xff\x30\x1c\xc7\x93\x6e\x81\x0f\xb4\x15\x4a\x66\x50\x18\x41\x0c\xfc\xb4\xc1\xe0\x66\x75\x2e\xbd\x28\xca\xfa\x11\x29\xa8\xb7\xa4\xe2\xf9\xb3\x62\x59\xa0\x85\xc5\x71\x65\xa7\xdc\xf4\x3e\xa0\x30\xbd\xef\x2e\x98\x29\x14\x16\x01\x9b\x00\x8d\x9e\xa2\x5b\x88\xc8\x7f\x3c\xa1\x8d\x40\x1b\x88\x48\x47\xfd\x80\xe6\x39\x4e\xa3\x4f\xff\x16\x7e\x12\x11\x68\x7f\x84\x22\x42\x49\xd1\x85\x7c\xfd\xa2\xf5\x29\xbb\x61\x8d\xbc\x43\x24\x78\x0b\xac\xfd\xae\xde\x69\x47\x5c\xd7\xdf\x66\x38\x47\xfa\x7e\x27\xad\xff\x5f\xc3\x5b\x70\x94\xbd\x10\xb9\x1e\xa6\xdd\x94\x5c\xe9\x36\xea\x5b\xb6\x2b\x19\x4e\x5b\x05\x63\x85\x92\x1f\x75\x55\x89\xfd\xe5\x49\xd3\xd9\xfc\xfb\x7a\x7e\x63\xa6\x7d\xd1\x69\x2b\x94\xc3\xeb\x1a\x10\x7c\x44\xc3\x17\x84\xe7\xf1\x2f\xcb\x38\x59\x84\xd2\x66\x38\x19\x4d\xe7\xef\xe2\xf9\x72\x32\x0e\xa4\xcd\x3c\x4e\x66\xd3\x49\x12\x87\x15\x16\x1f\xa7\xf3\x45\xa8\x1a\x2b\xcd\x08\x16\xcd\x16\x4d\x3b\x27\xfa\x90\xb0\x60\x67\xcf\xc9\xd1\x7e\x3f\x45\x07\xbe\x52\x7c\x9d\x27\x00\x64\x58\x41\x8e\xc6\x3f\xae\xa4\x21\x39\x31\x04\x10\xda\xd2\x6e\x84\x89\x48\x4b\x1f\xcf\x7c\x4d\xb6\x2d\x49\xac\x15\xfa\x13\x63\xc5\x16\x61\xa3\x5c\x21\x09\x52\x4d\xb9\x2c\x82\xa1\x72\x1a\x69\xc7\xd7\x0f\xe5\x8a\x37\x92\xde\xdc\x37\x45\xce\xb4\x19\x4c\x9e\x00\xaa\xe7\xbf\x9b\xd1\x78\x4c\x9d\x9b\x3f\xfe\x09\x00\x00\xff\xff\x44\x2c\xa0\x4e\x83\x09\x00\x00")

func i18nResourcesDe_deAllJsonBytes() ([]byte, error) {
	return bindataRead(
		_i18nResourcesDe_deAllJson,
		"i18n/resources/de_DE.all.json",
	)
}

func i18nResourcesDe_deAllJson() (*asset, error) {
	bytes, err := i18nResourcesDe_deAllJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "i18n/resources/de_DE.all.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _i18nResourcesEn_usAllJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xbc\x94\x41\x6f\xda\x40\x10\x85\xef\xfc\x8a\x27\x2e\xbe\x20\xa4\x5e\xb9\x45\xa9\x2b\x45\x69\x0b\x2d\xcd\xa9\xf4\xb0\xd8\x83\x59\x75\x99\x75\x77\x67\x49\x11\xda\xff\x5e\x19\x87\x54\x8a\x76\x83\x1b\xa1\x5e\x10\x68\xe6\x7d\xef\x0d\xb6\xde\xf7\x11\x70\x1c\x01\xc0\x58\xd7\xe3\x19\xc6\x2b\x2e\x59\xc8\x41\x81\xc3\x6e\x4d\x6e\x3c\xe9\xa7\xe2\x14\x7b\xa3\x44\x5b\x4e\xae\x8d\x80\x38\x79\x09\xbb\x61\x90\x73\xd6\xc1\x56\x55\x70\x8e\x6a\x3c\x6e\x89\x51\x39\x52\xa2\xb9\x81\xb1\x0d\x36\xda\x10\x8a\xe3\x71\xba\x50\xb2\x8d\xb1\x98\xad\xf8\x78\x9c\x96\x9d\x2c\xc6\x15\xaf\x38\x93\xe0\x3a\xec\xc1\xb1\x3b\x52\x1d\x76\x6d\x87\x76\xf4\x2b\x90\x97\x17\xb4\x7f\xc8\x39\x00\xf6\xc6\x60\xbe\xb5\xec\xe9\x5a\xc9\xd2\xb4\x64\xb4\x5b\x1b\x4c\x0d\xb6\x02\x47\xaa\xc6\xc6\xd9\x1d\x34\xb7\x41\x66\xc8\xd8\xbf\xa6\x48\x5a\x94\x46\xb5\x9e\xea\x59\x86\xf7\x3c\x4e\x8b\x7f\x0b\x39\x56\x06\x2a\xc8\x96\x58\x74\x75\x12\x62\xa3\xb4\xa1\x7a\x8a\xd3\x79\xa8\x6c\x4d\x33\x9c\xaf\xbd\xb5\x35\xc5\x38\xc1\x8e\xbc\x57\x4d\x3f\xf8\xd4\x7f\x8f\x31\x97\xe2\xea\x3e\xc9\x73\x3e\xdc\xdc\x7d\x2c\xdf\x67\x32\x3c\x0d\x93\xc2\x3b\xde\x2b\xa3\x6b\x34\x4e\xb1\x40\x0e\x2d\x65\x1f\x50\x72\xf5\x55\xa8\xd8\x9f\xc4\x17\x79\xe7\xad\x24\x6a\x7e\x9f\x51\xcf\xef\xd3\x82\x85\x21\xe5\x09\x74\xaa\xa3\xe2\x50\x4c\x50\x70\xf7\x71\x20\x5f\xc0\x3a\x14\x6c\x8b\x69\x86\x39\x4c\x7b\xd9\xf6\xdc\x82\x58\x93\x3c\x12\x31\xde\x41\x6c\xf7\x14\x6f\x6d\x60\x89\x71\x90\xff\x65\xc8\x90\x20\xfd\x5f\xbc\x31\xb6\x6f\xc1\x1e\x39\xd0\x3f\xa3\x1d\x6e\xfb\x06\xb7\xe1\x26\x7b\x65\x02\x0d\x62\x3f\x6d\x26\x91\x5f\xcb\x2f\x0f\xe5\xf2\x5b\xae\x44\x9e\xc7\x19\xf1\x72\x31\xff\xbc\x2c\xf3\xea\xf3\x3c\x2d\xa7\x9d\x15\x82\x27\xb7\x27\xd7\x77\xef\x14\x4b\x51\x12\xfc\xdf\x46\xe8\x7f\x9f\x2b\x81\xae\x54\x4b\xff\xc5\x3a\x79\xf4\x03\xab\xb5\xa1\xee\x55\xf6\x6a\x4f\x68\x4d\x68\x34\xa3\xb2\xbc\xd1\x4d\xb6\x2a\x2e\x88\x3a\xa3\xd1\x8f\x3f\x01\x00\x00\xff\xff\x85\x73\xde\xa8\xbc\x08\x00\x00")

func i18nResourcesEn_usAllJsonBytes() ([]byte, error) {
	return bindataRead(
		_i18nResourcesEn_usAllJson,
		"i18n/resources/en_US.all.json",
	)
}

func i18nResourcesEn_usAllJson() (*asset, error) {
	bytes, err := i18nResourcesEn_usAllJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "i18n/resources/en_US.all.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _i18nResourcesEs_esAllJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x95\xc1\x6e\x22\x47\x10\x86\xef\x3c\x45\x89\xcb\x5c\x10\xd2\x5e\xb9\x59\xec\x44\x42\xd9\x2c\x0e\xd8\xa7\x90\x43\x31\x5d\x0c\x9d\x34\x55\xb3\xd5\xdd\xb3\x41\x68\x1e\x26\x8f\x10\xed\x2d\x57\x5e\x2c\xea\x19\x5b\x4e\x1c\xda\x8b\x2d\x5f\x10\xa3\xee\xfa\xfe\xbf\xa6\xe0\xaf\x5f\x46\x00\xa7\x11\x00\xc0\xd8\x9a\xf1\x0c\xc6\x1b\x2e\x39\x90\x02\x02\xc7\xc3\x96\x74\x3c\x19\x4e\x83\x22\x7b\x87\xc1\x0a\x3f\x5c\xf3\x95\xda\x2d\x42\x64\xe0\xf3\xdf\x07\x52\x19\x8f\x00\xba\xc9\x73\xe0\x0d\x03\xa9\x8a\x82\x54\x55\x54\x25\x03\x5f\xf7\xc4\x50\x29\x61\xb0\x5c\x83\x93\x1a\x76\xd6\x11\x14\xa7\xd3\xf4\x16\xc3\xbe\xeb\x8a\xd9\x86\x4f\xa7\x69\x99\xca\xba\x6e\xc3\x1b\xce\xb8\x58\x13\xec\x11\x1a\x15\x13\x2b\x6b\x24\x79\x19\xb4\xd0\xf5\x02\x0a\xe4\x00\xb5\xda\xdb\x56\xc0\x10\x28\xd5\xd6\x07\x95\x97\xb5\xae\x6e\x23\xb9\x36\xf1\xd0\xa4\x36\x94\xbe\x44\xf2\xe1\x19\xed\x0d\xbe\x5b\x71\x15\x2a\x38\x04\x2f\xce\x56\x36\x44\xf3\x1c\xfa\x46\x83\xbe\x11\xf6\xf4\x9e\x0e\x13\x33\x75\x8d\x57\x39\x9c\x4b\x74\x06\x58\x02\x28\xa1\x81\x9d\xca\x01\x2c\x37\x31\xcc\x20\xe3\xe2\xa5\x8a\x8b\x12\xa5\xc3\xc6\x93\x99\x65\x78\x77\xe9\x31\xbd\x1d\x6b\x64\x96\x21\xfc\x11\x48\x19\x1d\x60\x0c\x7b\xe2\x60\xab\xbe\x1a\x76\x68\x1d\x99\x29\xf4\x3d\x42\x25\x86\x66\xf0\xd8\xf2\x5c\x0c\x75\xdd\x04\x0e\xe4\x3d\xd6\xc3\xc1\x4f\xc3\xf7\xae\xcb\x58\x79\x7f\x9d\x8b\xed\xfc\x70\xb3\xf8\x54\x7e\xcc\x79\x58\xad\x96\xab\xcb\x75\x0b\x6e\xd1\x59\x03\xb5\x22\x07\x08\xc7\x86\xb2\x43\xba\x78\xf5\x45\x68\x90\xdf\x89\xb3\xbc\x35\x9d\xff\x42\x07\x2c\xd0\x9e\xff\x74\xd6\x60\x0e\xb7\xfc\x31\xfb\xb3\x51\xa5\x2a\x64\x02\xe9\xd6\x11\x7a\x02\xea\x63\xae\x38\x16\x13\x28\x38\x7d\x1c\xc9\x17\x20\x0a\x05\x4b\x31\xcd\xbd\x31\xdf\x50\x65\x77\xf6\x4b\xa4\xff\x97\x3e\x54\x7e\x5f\xf4\x31\x5b\x61\x4b\xe1\x2b\x11\xc3\x07\x08\x92\x86\x39\x97\xc8\xa1\xeb\xae\x51\x7f\x8a\xdd\x04\x55\x82\x0f\x70\xfc\x0f\xe2\x1a\x1b\xc3\x38\x76\x4e\x86\x28\x1e\x5c\xbd\x52\x7d\xe7\x24\x20\x07\x7a\x98\x96\xbc\x46\xf9\x4d\x82\xaf\xd0\x69\xd1\x45\xba\x12\xdf\xa2\x13\xcd\x40\x57\xe5\xcf\xf7\xe5\xfa\x2e\x17\x2b\xeb\xe5\xa7\xc5\x7c\x71\x77\xff\x31\x93\x29\xab\x72\x7d\xbb\xfc\xbc\x2e\x73\xf5\xe9\x3c\xf1\x6f\x72\xf5\x74\x90\x40\xe0\x49\x5b\xd2\x21\x87\xa7\xb0\x0e\x18\xa2\x7f\x4a\x88\xe1\xf9\x31\x22\xe8\xbd\x62\xaa\xe7\x18\x72\xbd\xba\x35\xa2\xa0\xc9\x8d\x4c\x61\x7e\xfe\x66\x6c\xdd\xef\xd5\xb4\x02\x8c\x5c\xb0\x51\xfd\xeb\x4e\x22\x5d\x32\xc3\x1e\x7f\xbb\x2a\xcb\xee\x19\xb7\x8e\xd2\x5f\xc5\x63\x4b\xd0\xb8\x58\x5b\x86\x4a\x78\x67\xeb\x6c\x9a\x7c\x16\xf0\xc3\x2e\x13\x93\x16\x59\x1d\x51\xcd\xb0\xbd\x86\xca\xa8\x58\xd9\xf3\x37\xee\x9b\x1c\x98\xc3\x18\x46\xbf\xfe\x13\x00\x00\xff\xff\xb6\xf1\x5f\x1c\x1d\x09\x00\x00")

func i18nResourcesEs_esAllJsonBytes() ([]byte, error) {
	return bindataRead(
		_i18nResourcesEs_esAllJson,
		"i18n/resources/es_ES.all.json",
	)
}

func i18nResourcesEs_esAllJson() (*asset, error) {
	bytes, err := i18nResourcesEs_esAllJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "i18n/resources/es_ES.all.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _i18nResourcesFr_frAllJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x95\xcf\x6e\x32\x37\x14\xc5\xf7\x3c\xc5\x11\x9b\xd9\x50\xa4\x6f\xcb\x2e\x22\x53\xf5\x6b\xfe\x36\x34\xab\xd2\x85\x19\x5f\x06\xb7\x9e\x6b\x7a\x6d\x93\xa6\x68\x1e\x88\xbe\x06\x2f\x56\x79\xa6\xa4\x2a\x1f\x4e\x48\x94\x0d\x9a\x91\x7d\x7e\xe7\x58\x77\x38\xfe\x65\x00\x6c\x07\x00\x30\x34\x7a\x38\xc1\x70\xce\x25\x07\x12\x28\x70\x6c\x16\x24\xc3\x51\xbf\x1a\x44\xb1\xb7\x2a\x18\xc7\x2f\xdb\x84\xfe\x42\x64\xb0\x6b\x16\x42\xc3\x01\xd0\x8e\x8e\x71\x17\x0c\x12\x71\x02\x57\x55\x51\x84\x34\x9e\x56\xc4\xa8\x84\x54\x30\x5c\xc3\xba\x1a\x4b\x63\x09\xc5\x76\x3b\xbe\x57\x61\xd5\xb6\xc5\x64\xce\xdb\xed\xb8\x4c\xb2\xb6\x9d\xf3\x9c\x33\x19\x4a\x11\x8a\x02\xeb\xc4\x43\x13\xac\x42\x25\xfb\x5d\xb7\x0c\x1d\xb1\x34\xd5\xca\x90\xe0\x37\x17\x85\x95\x7d\xdd\xe1\xec\xf0\x29\xab\x8e\xcd\x3a\x85\x17\xfa\x23\x92\x0f\x47\xb4\xb3\xd3\x6a\x6a\x14\x6b\x4a\x6f\x1b\xa3\x55\x4d\x38\x26\x7d\x30\x95\x5f\x3b\xf6\xf4\xd1\x58\xb2\xdf\x75\xfa\xf7\xe6\x9a\xba\x68\x35\xd8\x05\x08\x29\x8d\xa5\xb8\x06\x86\xd7\x31\x4c\x90\xf1\x7e\x4d\x71\xd2\xa2\xb4\x6a\xed\x49\x4f\x72\x67\xa9\x5c\xb4\xfb\x1d\x26\x19\xf5\x9f\x81\xba\x2f\x41\xc5\xb0\x22\x0e\xa6\xea\xbf\x95\xa5\x32\x96\xf4\x18\xdd\xf9\x50\x39\x4d\x13\x1c\x8e\x3b\x75\x9a\xda\x76\x84\x86\xbc\x57\x75\xbf\x70\xd3\x3f\xb7\x6d\x2e\xc6\xa7\xfb\x9c\x3c\xce\xf7\x17\x5f\xaf\xcb\xcb\x5c\x86\xe9\x0f\xe5\xf4\xb4\xee\x2b\x6f\x94\x35\x1a\xb5\x28\x0e\x08\xcf\x6b\xca\x0e\xe8\xe4\xd6\x57\xa1\xc1\xfd\x4e\x9c\xe5\xfd\x48\xc1\xa5\xbe\x60\x74\xbb\x09\x39\xdc\xdd\x55\x86\x70\x77\x75\x5a\x70\x6f\x49\x79\x02\x75\xdd\x55\x3c\x17\x23\x14\x9c\x7e\x9e\xc9\x17\x70\x82\x82\x5d\x31\xce\x30\xaf\x0b\xe2\x20\xfb\x1d\x41\x3b\x13\xb0\xff\x3b\x08\x7d\xcb\x88\xff\x32\xde\xb6\x3f\x54\x27\x16\x14\x9e\x88\x18\x5f\x10\x5c\x1a\xe8\xd4\x45\x0e\x6d\x9b\xcb\x71\xdc\xa8\x09\x27\x84\x2f\xa0\xf0\x3f\xf5\x39\x09\xfa\x69\x2c\xad\xeb\x6b\xb6\x0f\x74\xb6\xf1\xd2\xba\x10\xd2\xc8\xfb\x31\xbd\xc7\xf2\x9d\x4e\xe7\x1b\x6c\x94\x8d\xf4\x26\xb7\x23\x52\x94\x0c\xf1\xa1\xfc\xe9\xb1\x9c\xfd\x9c\x2b\x90\xcb\xf2\xe6\xe2\xf6\xb2\xcc\x15\xc8\x43\x39\xbb\xbf\xbb\x9d\x95\x39\xf9\x43\xd9\x2d\x67\xe5\xd4\xb8\x40\xf0\x24\x1b\x92\xbe\xc3\xc7\x98\x05\x15\xa2\xff\xaf\x0d\xfa\xf7\x43\x1d\xd0\x67\x55\x52\xdf\xf2\x3a\xf6\xee\xe9\xd1\xf8\x34\xe1\x31\x12\x2e\x55\xbd\x4f\xc6\x01\x27\x42\x54\xdd\x8e\x82\x7a\x46\x36\x08\xce\x29\xad\x47\x56\x0b\x4b\xe9\xff\xe0\xd5\x86\xb0\xb6\xb1\x36\x8c\xca\xf1\xd2\xd4\xf9\x1a\x6a\xd6\xce\x7b\x93\x84\xba\x20\x16\xaa\x8d\x0f\x42\xd2\x5d\xf9\x9d\x34\xca\xcb\xb5\x9f\x90\xdf\x19\x3e\x54\xcb\xe0\xd7\x7f\x02\x00\x00\xff\xff\x78\x63\xf7\x53\xe3\x08\x00\x00")

func i18nResourcesFr_frAllJsonBytes() ([]byte, error) {
	return bindataRead(
		_i18nResourcesFr_frAllJson,
		"i18n/resources/fr_FR.all.json",
	)
}

func i18nResourcesFr_frAllJson() (*asset, error) {
	bytes, err := i18nResourcesFr_frAllJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "i18n/resources/fr_FR.all.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _i18nResourcesIt_itAllJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xb4\x56\xcd\x6e\xda\x4a\x14\xde\xf3\x14\x9f\xd8\x78\xc3\x45\xca\x96\x5d\xc4\xf5\xd5\x45\x69\x03\xc5\x64\x55\xba\x18\xec\x03\x8c\x3a\x3e\xc7\x9d\x19\x93\xa6\xc8\xef\xd3\x45\xdf\x22\x2f\x56\x8d\x4d\xd2\x36\x62\x08\x89\xd2\x0d\xc2\x9a\xf3\xfd\x1c\x1f\xf9\x3b\xf3\xb1\x07\xec\x7b\x00\xd0\xd7\x45\x7f\x84\xfe\x92\x53\xf6\x64\xa1\xc0\x75\xb9\x22\xdb\x1f\x74\xa7\xde\x2a\x76\x46\x79\x2d\xdc\x95\x4d\xca\x92\xbc\xd7\xa8\x39\x54\x92\x95\x7e\x0f\x68\x06\x4f\xf9\x2e\x19\x64\xad\x58\x48\x9e\xd7\xd6\x52\x81\xdb\x2d\x31\x72\x4b\xca\x6b\xde\xc0\xc8\x06\x6b\x6d\x08\xc9\x7e\x3f\x9c\x29\xbf\x6d\x9a\x64\xb4\xe4\xfd\x7e\x98\x06\x58\xd3\x2c\x79\xc9\x11\x13\x99\xc6\xfd\x77\xec\xc8\xea\xb5\xce\x95\x97\xe0\xa5\x15\x23\x14\xb5\x55\xec\x09\x46\xb5\x52\xdf\xb4\x30\xa1\x20\xd3\x69\x15\xba\xd5\x3d\x29\x79\x76\x37\x2d\x61\x5d\x56\xa1\x1b\x4b\x5f\x6a\x72\xfe\x09\xdb\xeb\xed\x6b\xd3\x52\x07\xe7\x46\xc1\xea\x7c\xab\xc9\x79\xf5\x94\xff\x95\x5e\x5d\x25\xec\xe8\xaf\x99\x75\x95\x9c\xeb\x75\x2c\xb5\x29\xc0\xe2\x61\x49\x15\x58\x5b\x29\xa1\xb9\xaa\xfd\x08\x11\x3f\xa7\x10\x47\x25\x52\xa3\x2a\x47\xc5\x28\xc2\xb7\xb0\xca\xe5\x62\x9d\x8c\x22\xf0\xaf\x9e\x2c\x2b\x03\x55\xfb\x2d\xb1\x0f\x2f\x41\x0b\x63\xad\xb4\xa1\x62\x88\xb6\x41\xe4\x52\xd0\x08\x0f\xfd\x8e\xa5\xa0\xa6\x19\xa0\x24\xe7\xd4\xa6\x3b\x78\xdf\xfd\x6f\x9a\x88\x8f\xb7\xd7\x39\xda\xce\x7f\x97\x93\x77\xe9\xbf\x11\x0f\xd7\xd3\x6b\xcc\x27\x37\xd9\x78\xb2\x98\x1e\x87\x4f\x78\xa7\x8c\x2e\xb0\x09\x93\x87\xbf\xab\x28\x3a\xa8\xa3\xa5\x27\x49\xbd\x7c\x26\x8e\xf2\x2d\xc2\x29\x58\x18\x6d\xb5\xc4\xd8\xa6\x57\x11\x82\xe9\xd5\x71\xc0\xcc\x90\x72\x04\x6a\xe3\x2f\xb9\x4b\x06\x48\x38\xfc\xdc\x91\x4b\x20\x16\x09\x4b\x32\x8c\x35\x79\x08\xc3\xc4\x3d\xc2\xdc\xfd\x8f\x04\x72\x40\x3d\x2f\xf8\x90\xb7\x58\x91\xbf\x25\x62\x5c\xc0\x4b\x18\xe4\x58\x6a\xf6\x4d\xf3\x9c\xf2\x63\x0c\x23\x97\xb2\xb2\xe4\x04\xde\x2a\x5c\x80\xfe\x20\x39\xc7\x48\x37\x85\xb5\x91\x2e\xa1\x3b\x5f\xe7\xeb\x17\x94\xeb\x52\x19\x3a\xcc\xe7\x25\x9a\x2f\x95\x3a\x5f\x61\xa7\x4c\x4d\x67\x10\xef\x94\x11\x4b\x11\xc6\x79\xfa\xe1\x26\xcd\x16\xb1\x08\x99\x4f\xc6\xff\x4f\xd2\x6c\x71\x19\x89\x90\x79\x9a\xcd\xa6\xd7\x59\x1a\xc7\x67\xb3\xe9\x09\x38\x95\xe2\x09\x8e\xec\x8e\x6c\x97\xbd\x43\x64\x5e\xf9\xda\xfd\xca\x83\xee\xf9\x21\x10\xe8\xad\x42\xa9\x0b\xfa\x83\xb4\x0d\x46\x64\x88\xb1\x14\x3a\x6f\x97\xa9\xf3\xca\xcb\x11\xfd\xfc\xb1\xa2\x5b\x15\x31\x17\x1b\x2d\xe7\x84\xd6\x0d\xab\x95\xa1\xf0\x5d\x38\xb5\x23\x54\xa6\xde\x68\x46\x2e\xbc\xd6\x9b\x78\xfe\x94\x95\x38\xa7\x57\x61\xf5\x39\x65\x76\xca\x76\xb7\x82\x16\x55\xdb\xdf\xae\x06\x81\xef\x1f\xcd\x87\x40\xe9\x7d\xfa\x19\x00\x00\xff\xff\xf5\xcb\xde\x17\x1c\x09\x00\x00")

func i18nResourcesIt_itAllJsonBytes() ([]byte, error) {
	return bindataRead(
		_i18nResourcesIt_itAllJson,
		"i18n/resources/it_IT.all.json",
	)
}

func i18nResourcesIt_itAllJson() (*asset, error) {
	bytes, err := i18nResourcesIt_itAllJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "i18n/resources/it_IT.all.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _i18nResourcesJa_jpAllJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xb4\x96\xcf\x6f\x1b\x45\x14\xc7\xef\xf9\x2b\x9e\x7c\xf1\x25\xb2\xd4\xab\x6f\x55\x30\x52\x55\x20\xa1\xa1\x27\xc2\x61\xe2\x7d\x76\x56\xac\x67\xcc\xec\x6c\x8a\x65\xad\xe4\x99\x2d\x52\x7e\xb8\x34\x2a\xb5\x42\xd5\xa0\x10\x14\x1a\x68\x95\xd4\x55\x14\xd4\x12\xa0\x7f\xcc\xeb\xae\xe1\xbf\x40\xb3\xdb\xb4\x51\xeb\x09\x56\x64\x2e\xa3\xb1\xe7\xfd\xf8\xbc\x7d\xfb\xbe\xb3\x9f\xcf\x00\x74\x67\x00\x00\x4a\xbe\x57\xaa\x42\x69\x89\xd7\xb8\x42\x09\x0c\x78\xd4\x5a\x46\x59\x9a\x2d\x4e\x95\x64\x3c\x0c\x98\xf2\x05\x2f\xcc\xb2\xc1\x30\xed\xed\x93\xb9\x97\x7e\xf3\x73\xba\xf1\x90\xf4\x36\xe9\x47\xa4\xef\x92\xfe\x91\xf4\x80\xf4\xed\xd2\x0c\x40\x3c\xfb\x6e\xfc\xab\x1c\x50\x4a\x21\x41\xd4\xeb\x91\x94\xe8\xc1\xad\x15\xe4\x50\x97\xc8\x94\xcf\x9b\x10\x88\x26\x34\xfc\x00\xa1\xdc\xed\x56\x16\x98\x5a\x89\xe3\x72\x75\x89\x77\xbb\x95\x9a\x75\x8b\xe3\x25\xbe\xc4\x1d\x50\x94\x1c\x92\x19\x52\x72\x4a\xc9\x80\xcc\x1e\x99\x7d\x4a\x9e\x9c\x0f\x04\x64\xee\xbd\xfa\x73\x27\x5b\xdb\x7a\xf5\xfc\x90\xf4\x13\x32\xbf\x50\xf2\x2b\x25\x7f\x90\xee\x8f\x1e\xfc\x3e\xba\xbf\x9b\x97\xf1\x57\xbe\xee\xbe\x9f\x76\xe2\x8a\x6c\x01\x5e\xd4\x6a\xdb\x8a\x24\x7e\x15\x61\xa8\xde\x89\xe6\x28\xe1\xef\x47\x3a\x7b\x66\x48\x1f\x51\xd2\xa3\xe4\x98\x92\xed\x4b\x90\x5e\x96\x33\x6c\x0b\x1e\xe2\x64\xa0\xe9\xcb\x9d\xd1\xe1\xfd\xff\x05\x74\x4e\x44\x81\x07\x5c\x28\x90\xc8\x3c\x68\x48\xd1\x02\x9f\xb7\x23\x55\x05\x07\xcc\x45\x1e\x63\x53\xd4\x02\xd6\x0e\xd1\xab\x3a\xe2\x8d\x4e\xfa\xff\xe8\x6f\xab\x0e\xdf\xaf\x15\x4a\xce\x02\x60\x91\x5a\x41\xae\xfc\x7a\xee\x07\x0d\xe6\x07\xe8\x55\x20\xaf\x0e\xea\xc2\xc3\x2a\x9c\x15\x3b\x27\x3c\x8c\xe3\x59\x68\x61\x18\xb2\x66\x71\xf0\x71\xb1\x8f\x63\x07\xc4\xf4\xf3\x8c\x2d\xe7\xc3\xab\xd7\x3e\xaa\x7d\xe0\xea\xf2\xfe\xb3\x6c\xb0\x3d\xde\xf1\x1a\x5f\x65\x81\xef\x41\x53\x32\xae\x40\x75\xda\xe8\xec\xcf\x58\xd3\x0b\x83\x2a\xf1\x25\x72\x67\x3c\x4a\xd6\xec\x1b\x66\x9e\xda\x37\x4f\xf7\x47\xb7\xf7\xd2\x8d\x17\xa4\x0f\x48\x3f\x70\x05\x9e\xbf\xee\x88\x35\x7f\x7d\xbc\xc3\x42\x80\x2c\x44\xc0\x5c\x0d\xcb\x9d\xf2\x2c\x94\xb9\x5d\x3a\x18\x96\x41\x48\x28\x73\x51\xae\xb8\xf8\x7a\xfd\x0e\xf5\xee\x50\x4f\x53\xaf\xcf\xdf\xec\x3a\x18\xbe\xde\xdb\x79\xd8\x25\xfd\xd4\x1e\x0b\xfb\x9f\x5b\x46\xa9\x67\x26\x00\x3c\x93\x6b\x58\x46\x75\x0b\x91\xc3\x15\x50\xc2\x76\x7f\x4e\x44\x5c\xc5\xb1\x8b\xf4\x0a\x90\xde\x24\xb3\x7e\xce\x14\x72\xba\x03\xd2\x47\xff\x29\xf1\x93\xb2\x15\x3d\x6d\x04\xa2\xd0\xf8\x02\xd5\x85\x94\xed\xac\xe7\xdd\x7c\x9c\x9d\x1c\xa5\x9b\x83\x74\x78\x37\x1b\x0c\x47\xe6\x45\x36\x18\x4e\x0d\x65\x52\x82\xe9\x3c\x80\x55\x16\x44\xe8\x4a\x76\xc9\x04\x37\x6a\x9f\xde\xac\x2d\x7e\xe6\x52\xb0\xe2\x1e\x71\x28\xd8\x8d\xda\xe2\xc2\xfc\x27\x8b\x35\x97\x73\xa1\xed\x2e\x67\x6c\x09\x85\x10\xa2\x5c\x45\x59\xdc\x28\x15\x58\x54\x4c\x45\xe1\x5b\x31\x2a\x7e\x9f\xa9\x11\x4e\x49\x11\x29\x79\x4c\xc9\x4f\x76\xf2\xed\xfc\x9f\x92\x39\xc9\xf7\x5b\xf9\x7a\xfa\xf6\xe6\xe9\x19\x18\x6d\xfc\x96\x1d\x6b\x32\xc7\xf9\xd9\xfa\x7b\x50\x76\x08\xdf\xd8\x5b\xdf\xf3\x86\xe7\x00\xad\x5d\xb2\x47\x49\x42\xe6\x34\x97\x9c\xe7\x93\x68\xea\x4d\xce\x96\x03\xb4\x13\x18\xb2\x55\x84\x76\x10\x35\x7d\x0e\x75\xc1\x1b\x7e\xf3\x02\x51\xdb\xb6\x3c\x66\x98\x7f\xb7\x1c\x67\x07\x9b\xd9\xda\x96\xfd\x60\x79\xf9\x43\x7a\xf8\x7d\x3e\x91\x77\xf2\xd1\x7c\x48\xe6\xbb\xd7\x32\x37\xf3\xc5\xbf\x01\x00\x00\xff\xff\x85\x49\x63\xd8\xc1\x09\x00\x00")

func i18nResourcesJa_jpAllJsonBytes() ([]byte, error) {
	return bindataRead(
		_i18nResourcesJa_jpAllJson,
		"i18n/resources/ja_JP.all.json",
	)
}

func i18nResourcesJa_jpAllJson() (*asset, error) {
	bytes, err := i18nResourcesJa_jpAllJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "i18n/resources/ja_JP.all.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _i18nResourcesKo_krAllJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xb4\x55\x4d\x6f\xdb\x46\x10\xbd\xfb\x57\x0c\x74\xe1\xc5\x15\x90\xab\x6e\x81\xcb\x02\x41\x3f\xe2\xc6\xcd\xa9\xee\x61\x2d\x8e\x64\xa2\xd4\xae\xba\x5c\x3a\x35\x04\x02\x4a\xcd\x06\x82\xa9\x02\x49\x2b\xb5\x6c\x2b\xba\x2e\x20\x21\x0d\xe0\x00\x8a\x1a\x23\x3a\x38\x7f\x88\x3b\xfc\x0f\x05\xc5\x0a\x71\x53\xad\x2b\xd4\xce\x85\x20\xb1\xf3\xde\xbc\xc7\x21\xdf\x7c\xbe\x01\xd0\xd9\x00\x00\xa8\xb8\x4e\xa5\x06\x95\x5d\x6e\x73\x85\x12\x18\xf0\xa0\xb5\x87\xb2\xb2\x59\x9e\x2a\xc9\xb8\xef\x31\xe5\x0a\x5e\x96\xe9\x59\x2f\x4f\xe6\x40\x27\xdf\xea\xd3\x49\x65\x03\x20\xdc\x7c\x9b\xeb\x36\x07\x94\x52\x48\x10\xf5\x7a\x20\x25\x3a\xf0\x60\x1f\x39\xd4\x25\x32\xe5\xf2\x26\x78\xa2\x09\x0d\xd7\x43\xb0\x3a\x9d\xea\x36\x53\xfb\x61\x68\xd5\x76\x79\xa7\x53\xb5\x0b\x58\x18\xee\xf2\x5d\x6e\x10\x70\x09\x02\xfa\xf7\x51\xf6\x6a\x0e\x79\xbf\x4f\xe9\x05\xa5\x11\xd0\xc9\x13\x8a\x5e\xe4\xc3\x53\xd0\xc3\x3e\xe8\x78\x4c\x69\x1f\x28\x19\xeb\x49\x92\x4d\xbb\xa0\xa7\x23\x3a\x4a\xf3\x1f\x7b\x74\x7c\xae\xe3\x9e\x8e\xc7\x55\xf8\x57\xdb\xb5\x1d\x15\x06\x9c\xa0\xd5\x2e\x1c\x49\xfc\x2a\x40\x5f\xbd\x65\xc2\x60\x81\x7e\x19\xd0\xec\x79\xa1\x57\x7f\x37\xce\x07\xd1\x35\xf4\xfe\x5f\xb5\x7e\x5b\x70\x1f\xd7\x94\x9b\x3e\xd1\xf1\xf9\x3b\x94\xbb\x25\x02\xcf\x01\x2e\x14\x48\x64\x0e\x34\xa4\x68\x81\xcb\xdb\x81\xaa\x81\x41\xd2\x55\x88\x95\x2d\x6c\x8f\xb5\x7d\x74\x6a\x06\xbe\x6c\xf6\x3a\xfb\xf3\x02\x28\x1e\x65\xd3\xa8\x66\xa0\xf8\x5a\xa1\xe4\xcc\x03\x16\xa8\x7d\xe4\xca\xad\x2f\xe0\xd0\x60\xae\x87\x4e\x15\x16\x26\xa1\x2e\x1c\xac\xc1\xd2\xf3\x96\x70\x30\x0c\x37\xa1\x85\xbe\xcf\x9a\xe5\xc1\xc7\xe5\x7d\x18\x1a\xb4\xdc\x7c\x9f\x95\x76\x3e\xb8\x7d\xe7\x23\xfb\x7d\xd3\xc8\xe3\x71\xde\xff\x63\x35\xf0\x0e\x3f\x60\x9e\xeb\x40\x53\x32\xae\x40\x1d\xb6\xd1\x38\xa6\x95\xa5\x57\x92\x2a\xf1\x25\x72\x23\x1f\x25\x67\x7a\x3a\xd0\x93\x97\xf4\xb4\x0b\x34\x3c\xa6\xb4\x0b\xf9\xa3\xd3\xfc\xe1\xd4\xc4\x7b\xf7\x43\x03\x55\xfe\xf3\x90\xd2\xf9\x6a\xd0\xb6\x87\xcc\x47\xc0\x45\x1e\x5a\x87\xd6\x26\x58\xbc\xb8\x1c\xa2\x6f\x81\x90\x60\x71\x61\x55\x4d\xf1\xf4\xa6\x9c\x92\x9e\x05\x3a\x79\xac\x8f\x07\x60\xd1\x30\xd2\x71\x8f\x92\xb1\xa5\x27\x17\x7f\x87\x67\x3e\x4c\x28\x7e\x4e\xf1\x88\x92\x71\x75\x0d\x29\xcb\x68\x86\x3d\x54\x0f\x10\x39\xdc\x02\x25\x8a\x51\x6f\x89\x80\xab\x30\x34\x69\xba\x05\xef\x5d\xaa\x02\xfa\xe6\x8c\xd2\x97\x94\x26\x40\xbd\xe4\x3a\x6a\xca\x91\x35\x3c\x51\xa6\x7a\x29\xce\x24\x62\x39\xbb\x79\x09\xb8\x99\xde\xeb\xb6\xbc\x56\xb3\x03\xe6\x05\x68\xea\x91\x4d\xbf\x2f\x17\xcf\x9a\xcc\xf7\xec\x4f\xef\xdb\x3b\x9f\x99\x82\xa8\x5c\x0d\x86\x04\xba\x67\xef\x6c\xdf\xfd\x64\xc7\x36\x82\x17\x41\x6d\x02\x63\x4b\x28\x04\x1f\xe5\x01\xca\x72\x3d\x54\x61\x47\x31\x15\xf8\x6f\xc2\xa4\x7c\x5e\xa6\x09\xde\x50\xa2\xd1\xaf\x8f\xb3\xd9\x33\xa0\x68\xa4\x67\xd1\x7f\xec\x0b\x3a\x7a\x98\x1f\x8d\x80\x5e\x0f\xf4\x0f\xa3\x15\x9a\x4a\xf4\xe5\xf3\x7f\xc8\xd2\xcf\x06\xc5\xeb\x7f\xda\x5d\x27\x02\xef\x73\xb6\xe7\x61\xf1\x0f\xf9\xec\x00\xa1\xed\x05\x4d\x97\x43\x5d\xf0\x86\xdb\x34\x66\x50\x3e\xe8\xeb\xdf\xce\xb2\x57\x73\x4a\xe7\x90\x9d\x9f\x51\xf4\x62\xf1\x01\x9c\x76\xe9\x64\x52\xac\x46\xea\x25\x40\x3f\x3d\xa2\xb4\x5f\x4e\x62\xe3\x8b\xbf\x02\x00\x00\xff\xff\xc8\xc6\xe4\xe5\x6c\x09\x00\x00")

func i18nResourcesKo_krAllJsonBytes() ([]byte, error) {
	return bindataRead(
		_i18nResourcesKo_krAllJson,
		"i18n/resources/ko_KR.all.json",
	)
}

func i18nResourcesKo_krAllJson() (*asset, error) {
	bytes, err := i18nResourcesKo_krAllJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "i18n/resources/ko_KR.all.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _i18nResourcesPt_brAllJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x95\xbf\x6e\xf3\x36\x14\xc5\x77\x3f\xc5\x85\x17\x2d\xae\x81\x6f\xf5\x66\x38\x0a\x6a\xe4\x8f\xd3\xd8\x99\xea\x0e\x8c\x78\xad\x10\xa5\xee\x75\x2e\x49\xa5\xa9\xa1\xa9\x43\x9f\xa3\xc8\x50\x74\xe8\xd4\xad\xab\x5e\xac\xa0\x94\x20\x6d\x6a\x3a\xce\x87\x2c\x86\x0d\xf2\x9c\xf3\xbb\xa2\x7c\xf8\xfd\x00\x60\x37\x00\x00\x18\x1a\x3d\x9c\xc0\x70\x4d\x39\x79\x14\x50\x40\xa1\xba\x45\x19\x8e\xfa\x55\x2f\x8a\x9c\x55\xde\x30\xf5\xdb\xe6\xe4\x8c\x28\x08\x15\x50\xfb\x77\x85\xc2\xc3\x01\x40\x33\x7a\xeb\x37\x25\x40\x11\x16\xe0\xa2\x08\x22\xa8\xe1\xe1\x0e\x09\x0a\x41\xe5\x0d\x95\x60\xb9\x84\x8d\xb1\x08\xd9\x6e\x37\xbe\x52\xfe\xae\x69\xb2\xc9\x9a\x76\xbb\x71\x1e\x65\x4d\xb3\xa6\x35\x25\x20\x16\x05\x8b\x60\x88\x0c\x31\x03\x14\x43\x21\x46\x09\x30\x28\xb9\x0f\xa6\x66\xd0\xd8\x25\x1c\x34\x3f\x9a\x3b\x62\xea\x50\x6d\x23\xb7\xe0\x7d\x40\xe7\xdf\xb8\x1d\x0f\xba\x51\x3f\xa3\x74\x6e\xa0\x15\x38\xb6\xa6\x30\x5e\xb5\xbf\xb7\x4f\xfc\xd6\xf3\x2b\xf9\xdc\x96\xc9\xe1\x27\x01\x76\x76\xce\xab\xa3\xd8\x66\x1c\xac\x06\x62\x0f\x82\x4a\xc3\x46\xb8\x02\x43\xdb\xe0\x27\x90\xc8\x3f\xa4\xd8\x1b\x91\x5b\xb5\x75\xa8\x27\x09\xbf\x13\x8c\x03\x19\xcd\x93\x84\xfc\x27\x8f\x42\xca\x82\x0a\xfe\x0e\xc9\x9b\xa2\x93\xc2\x46\x19\x8b\x7a\x0c\xdd\x80\x50\xb0\xc6\x09\xbc\xcc\x3b\x63\x8d\x4d\x33\x82\x0a\x9d\x53\x65\xbf\x70\xd1\x7f\x6f\x9a\x04\xc7\xe7\xe7\xec\x1d\xe7\x74\x3a\x3f\xcf\x4f\x52\xcf\x76\x71\x01\xa7\xd3\xf3\x6f\xa7\xfb\xb5\x73\xaa\x95\x35\x1a\x4a\x51\xe4\xc1\x3f\x6e\x31\x79\x4a\x7b\xb7\x1e\x34\xf5\xfc\x23\x52\xd2\x6f\x15\x57\xc1\x50\xdd\xfe\x66\xe3\x59\x25\xcc\x16\x67\xa9\xb7\xf6\x6c\xbf\xe0\xca\xa2\x72\x08\xd8\x15\x59\xf6\x98\x8d\x20\xa3\xf8\xf1\x88\x2e\x03\x16\xc8\x88\xb3\x71\x72\xc6\xae\xd6\xfe\xa7\x0a\xcf\xaa\xf7\x03\x5f\x9a\x13\x6e\xd1\x3f\x20\x12\x7c\x01\xcf\xf1\x10\x67\x1c\xc8\x37\xcd\x3b\xc9\xaf\x85\x1a\xfd\x04\xe1\x0b\xe0\x7f\xd4\xc7\x10\xf4\x4f\x7f\x63\xb9\x2f\xd9\x1e\xe8\xf8\xe0\x8d\x0d\x3e\x28\xf2\x08\xcf\x47\xf3\x91\xd4\xc3\x61\x27\xa6\x34\x1e\xff\x1d\xf6\x81\x88\x5a\xd9\x80\xef\x8f\x51\x2b\xcb\x92\xf0\xbb\xce\xbf\xbb\xc9\x97\xab\x54\x71\x2c\x17\xe7\xf3\xd9\x7c\x35\x6d\x7f\x6d\x7f\x59\x24\xca\xe3\x3a\x5f\x5e\x2d\x2e\x97\x79\xca\xa3\x5b\x5f\xae\xa6\x29\x39\x56\xec\x11\x1c\x4a\x8d\xd2\x97\xf8\x18\x96\x5e\xf9\xe0\x5e\x9b\xa0\xff\xfd\x52\x05\xf8\x59\x75\x14\xbb\x5d\x73\x97\x6d\x34\x0b\x48\x64\xe1\x31\xcc\xda\xbf\xb4\x29\xbb\xeb\xd2\x75\xc9\x7b\x20\x8a\xd7\x3d\x91\x67\x1f\x09\xc5\xf4\xea\x98\xc6\xba\x21\x75\x6b\x31\xfe\x31\x9c\xaa\x11\xb6\x36\x94\x86\xa0\x60\xda\x98\x32\xd9\x17\x97\xed\x13\x43\xfb\x07\x6c\xd9\xb9\xf6\xcf\x1a\x2d\x38\x65\x6b\x15\x5f\xbd\x5e\x19\xa4\xbf\x41\xe3\x8c\xd1\xf2\x1b\x43\xcf\xa5\x32\xf8\xe1\x9f\x00\x00\x00\xff\xff\xf8\x2f\x63\x7e\xea\x08\x00\x00")

func i18nResourcesPt_brAllJsonBytes() ([]byte, error) {
	return bindataRead(
		_i18nResourcesPt_brAllJson,
		"i18n/resources/pt_BR.all.json",
	)
}

func i18nResourcesPt_brAllJson() (*asset, error) {
	bytes, err := i18nResourcesPt_brAllJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "i18n/resources/pt_BR.all.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _i18nResourcesZh_hansAllJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x94\xcf\x8f\xda\x46\x14\xc7\xef\xfc\x15\x4f\x5c\x7c\x41\x48\xb9\x72\x8b\xb6\xae\x14\xf5\x47\xb6\xa1\x39\x95\x1e\x66\xf1\x83\xb5\x6a\x66\xe8\x78\x4c\x8a\x90\x25\x83\x1a\x85\x24\xbb\x5a\xb5\x59\x42\x43\x59\x35\x51\xb3\xd2\x1e\x1a\xd8\xa8\x29\x51\x02\x29\xff\x0b\xc1\x63\x73\xe2\x5f\xa8\x8c\xc5\x36\xda\x30\x01\xa2\x5c\x90\xf1\xcc\xfb\xbe\xcf\xe8\x79\x3e\xdf\x25\x00\x6a\x09\x00\x80\xa4\x69\x24\x33\x90\xcc\x51\x9d\x0a\xe4\x40\x80\x3a\xa5\x3d\xe4\xc9\x54\xbc\x2a\x38\xa1\xb6\x45\x84\xc9\x68\xbc\x2d\xec\xbf\x0c\xff\x7d\xe0\xdf\x3e\x95\xad\x73\xff\x59\x3b\x99\x00\x70\x53\x97\xd3\xae\x52\x40\xce\x19\x07\x96\xcf\x3b\x9c\xa3\x01\xb7\xf6\x91\x42\x9e\x23\x11\x26\x2d\x82\xc5\x8a\x50\x30\x2d\x04\xad\x56\x4b\xef\x12\xb1\xef\xba\x5a\x26\x47\x6b\xb5\xb4\x1e\x95\xb9\x6e\x8e\xe6\xa8\x02\xc1\x6f\xfe\xee\x0f\x5f\xcb\xf6\xa9\x3f\x6e\xcb\x87\x77\xa6\xc3\xc1\xc4\xeb\x5e\xc4\x4c\xbc\x13\xd9\x1e\xf8\x47\xbf\x04\xc7\x7f\xcc\x8e\x1f\x85\xfd\xfe\x7c\xd4\x79\x2f\x79\x63\xe8\x88\xd1\x70\x4a\xe5\x08\x9a\xe3\x8f\x0e\xda\xe2\x12\xa7\x82\x32\x7c\xf3\x97\xdf\x38\x0b\xfb\x2f\xe5\xf3\xc6\x3a\xa0\x8f\xc5\xb1\xcb\x8c\xda\xb8\x0d\x8f\xff\xe0\xd0\x7f\x7d\xfc\x71\x3c\x3b\xcc\xb1\x0c\xa0\x4c\x00\x47\x62\x40\x81\xb3\x12\x98\xb4\xec\x88\x0c\x28\x7a\x7e\xa8\x62\x65\x0b\xdd\x22\x65\x1b\x8d\x8c\x22\x2f\x18\x1e\x85\xe3\x3b\xb2\x3d\x98\xb5\xc6\xf3\x51\x47\x91\xf1\x93\x40\x4e\x89\x05\xc4\x11\xfb\x48\x85\x99\x5f\xd4\x43\x81\x98\x16\x1a\x69\x58\x9c\x12\xf2\xcc\xc0\x0c\x2c\x0f\xbd\xc3\x0c\x74\xdd\x14\x94\xd0\xb6\x49\x31\x5e\xf8\x2a\x7e\x76\x5d\x05\xcc\xa7\xef\xb3\xf2\x38\x9f\x5f\xbd\xf6\xa5\xfe\x99\xea\x2a\x3c\x7d\x1e\xbe\x38\x5d\x5d\x78\x8d\x56\x88\x65\x1a\x50\xe4\x84\x0a\x10\xd5\x32\x2a\xe7\xb4\x72\xeb\x07\x43\x05\xfb\x01\xa9\x32\x6f\x3a\x7c\x1a\xdc\x3d\x90\xed\xc7\xb2\xd5\x54\xce\xe9\xfa\x17\xaa\x29\x3f\xe9\xf9\x3d\x45\xd1\xae\x85\xc4\x46\xc0\x85\xaa\xb4\xaa\x96\x02\x8d\x46\x3f\x55\xb4\x35\x60\x1c\x34\xca\xb4\xb4\xea\x06\x2c\xc5\x35\xf1\xba\xd5\x89\x77\xf2\xd6\xab\x4f\xbc\x2e\xbd\x78\xaa\xa2\x1d\xc9\xa3\xf9\x30\x7a\xcb\x16\xaf\x1b\x1b\x50\x2c\x85\x09\x7b\x28\x6e\x21\x52\xb8\x02\x82\x45\x83\xdd\x61\x0e\x15\xae\xbb\x16\x07\xae\x80\xdf\x3c\x7f\xa7\x02\xa6\xaf\xee\xcf\xda\x2f\x82\xce\xcf\xb1\x62\x37\xe5\x88\x47\x53\xb0\x58\xec\xd8\x18\x6b\x6d\x7b\xd9\xbd\x2b\x5b\xcd\xa8\xd9\x3f\xbd\xa0\xf1\x4a\xb6\xce\xb7\xeb\xb7\x75\x9b\x2d\xce\x54\x21\x96\x83\x9b\x47\xfb\xde\x48\x99\x7b\x43\xff\xe6\xa6\x9e\xfd\x56\xa5\x96\x58\xd4\xaa\xcf\xfe\x86\x9e\xdd\xbd\xfe\x75\x56\x57\x55\xc7\x5a\x55\x56\x63\x89\x09\x04\x1b\x79\x05\x79\xec\xf4\x34\x64\x05\x11\x8e\xfd\xbf\x1f\xe2\xff\x4b\x41\xe0\x27\x92\x54\x38\xee\x06\x67\xf7\x65\xf7\xd0\xbf\xf7\xc4\x7f\x74\x16\xfb\xfe\xad\xd7\x08\xee\x0d\xa4\x57\x0f\x1e\xd7\xe7\xa3\xce\xa5\xe6\xf3\xd1\x41\xbc\x6d\x3a\xfc\xf3\x62\xc3\x3b\x00\xf3\xd1\x81\x1c\x34\x65\xbd\x1f\xaf\xac\xd1\xd7\x4d\x4a\xf6\x2c\x8c\x6e\x84\x4d\x2a\x08\x65\xcb\x29\x9a\x14\xf2\x8c\x16\xcc\xa2\xd2\x1f\x91\x39\xfe\x6e\x4d\xc7\x27\xfe\xb3\xdf\xe4\xd1\xaf\xd3\xe1\x60\x76\xfb\x30\x78\xd3\x5b\xba\x24\xf1\xfd\x7f\x01\x00\x00\xff\xff\x5d\x45\xf3\x2f\xbf\x08\x00\x00")

func i18nResourcesZh_hansAllJsonBytes() ([]byte, error) {
	return bindataRead(
		_i18nResourcesZh_hansAllJson,
		"i18n/resources/zh_Hans.all.json",
	)
}

func i18nResourcesZh_hansAllJson() (*asset, error) {
	bytes, err := i18nResourcesZh_hansAllJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "i18n/resources/zh_Hans.all.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _i18nResourcesZh_hantAllJson = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x94\x4d\x6f\x1a\x47\x18\xc7\xef\x7c\x8a\x47\x5c\xf6\x82\x90\x72\xe5\x16\xb9\x5b\x29\xea\x4b\xdc\xd0\x9c\x4a\x0f\x63\xf6\x01\xaf\xba\xcc\xd0\xd9\x59\x52\x0b\xad\x04\x08\x2b\x4e\x21\xed\xc1\x81\x04\x12\xc5\xad\x65\x57\xc8\x96\xed\xba\x55\x5b\x17\x6f\xfb\x65\xec\x9d\x5d\x4e\x7c\x85\x0a\x46\xb8\x96\xe3\x31\xc6\xf2\x65\x05\x9a\xf9\xbf\x3c\x3c\xec\xef\xab\x04\x40\x35\x01\x00\x90\xb4\xad\x64\x06\x92\x39\x6a\x52\x81\x1c\x08\x50\xaf\xb4\x82\x3c\x99\x52\xa7\x82\x13\xea\x3a\x44\xd8\x8c\xaa\x6b\xf1\x7e\x2b\x0e\x4e\xc2\xf5\x5d\xd9\x39\x09\x0f\x5e\x27\x13\x00\x7e\xea\xaa\xdb\x43\x0a\xc8\x39\xe3\xc0\xf2\x79\x8f\x73\xb4\xe0\xd9\x2a\x52\xc8\x73\x24\xc2\xa6\x45\x70\x58\x11\x0a\xb6\x83\x60\x54\xab\xe9\x65\x22\x56\x7d\xdf\xc8\xe4\x68\xb5\x9a\x36\x27\x32\xdf\xcf\xd1\x1c\xd5\x54\x08\x4f\x87\xd1\x7e\x4b\xbe\xde\x8d\xf7\xda\x72\xef\xd5\x65\x0b\x90\xbd\x46\xd4\x0b\xa2\x57\x5b\xa3\xf6\x51\xbc\xb7\x33\x0e\xfa\x1f\x98\xde\xba\xef\xa4\x9e\xe5\x95\xca\x93\xbe\x1c\xbf\xf5\xd0\x15\x57\x2a\xea\x0a\x36\xfe\x0d\x9f\x0f\xe3\x5f\xea\xf2\xb8\x31\xaf\xd0\x5d\xeb\xb8\x65\x46\x5d\x5c\xa4\x4f\xf8\xf6\xbd\x7c\xfe\xe2\x6e\x7d\x96\x98\xe7\x58\x40\x99\x00\x8e\xc4\x82\x02\x67\x25\xb0\x69\xd9\x13\x19\xd0\x64\xde\xa4\xb8\x36\xc2\x74\x48\xd9\x45\x2b\xa3\xf1\x8b\xfe\xdc\x94\x07\x7f\xc9\x5e\x63\xd4\xdd\x1c\x07\x7d\x8d\xc7\x77\x02\x39\x25\x0e\x10\x4f\xac\x22\x15\x76\x7e\xaa\x87\x02\xb1\x1d\xb4\xd2\x30\x9d\x12\xf2\xcc\xc2\x0c\xcc\x86\x5e\x62\x16\xfa\x7e\x0a\x4a\xe8\xba\xa4\xa8\x0e\x3e\x53\x9f\x7d\x5f\x53\xe6\xfe\x73\xae\x1d\xe7\xe3\x87\x8f\x3e\x35\x3f\xd2\x2d\x75\xe7\x58\x76\x34\x6f\xdf\x23\x5a\x21\x8e\x6d\x41\x91\x13\x2a\x40\xac\x95\x51\xbb\xa7\x6b\xaf\xde\x68\x2a\xd8\x37\x48\xb5\x7e\x51\xf3\x67\xd9\xd9\x88\xfa\xcd\x78\xf0\x26\xee\x6d\x69\x57\xf5\xf8\x13\x9d\xc1\xf6\x30\x3c\xd4\x88\x96\x1d\x24\x2e\x02\x4e\x41\x65\xac\x19\x29\x30\xe8\xe4\xb1\x86\xae\x01\x8c\x83\x41\x99\x91\xd6\xf8\x5e\x60\x6b\x22\x3c\xab\xd5\x0d\x3a\x7d\x4e\xa5\x72\xa3\x3b\xd5\x9e\xd5\x1a\xb7\x08\x9e\x11\x12\x56\x50\x3c\x43\xa4\xf0\x00\x04\x9b\xac\x73\x89\x79\x54\xf8\xfe\xfc\x06\x0f\x20\xdc\xf8\xf5\x92\x02\xce\xff\x6e\x8d\xba\x9b\x51\xbf\xa9\x98\x7a\xdb\x1e\x6a\x21\x05\x87\x29\xa8\xaa\x5a\x73\xe3\xe5\xbb\x17\x6a\x45\xf2\x8f\xc3\xd1\xe9\x7b\xd9\x39\x59\x2c\x6f\xe1\x98\x05\x66\xaa\x10\xc7\xc3\xb9\xd6\x61\x2d\xd0\xda\x3d\x31\xbf\x78\x6a\x66\xbf\xd4\x71\x44\x51\x59\xfb\xb7\x7c\x62\x66\x97\x1f\x7f\x9e\x35\x75\x72\x05\x51\xbd\x1c\x4b\x4c\x20\xb8\xc8\x2b\xc8\x15\xc2\xd3\x90\x15\x44\x78\xee\xff\x38\x50\xdf\x67\x3c\xc0\x7b\x62\xd2\xa8\xfe\x53\xb4\x7f\x74\x1e\x0c\xe5\xbb\x97\x61\x6f\xa0\xf0\x7e\x56\x6b\x44\xad\x9a\x5c\x6f\x45\xdb\xc1\x38\xe8\x5f\x09\x1f\x07\x6d\x75\xed\xe2\xf4\x52\xfa\x38\x68\xc7\x83\xef\x65\xfd\x48\x9d\xcc\x41\xd5\x53\x4a\x56\x1c\x9c\xbc\x07\x2e\xa9\x20\x94\x1d\xaf\x68\x53\xc8\x33\x5a\xb0\x8b\x37\xb2\xe2\xf7\x4e\xd8\xfc\x2d\x3c\x78\x13\xee\x74\xe5\x0f\x6f\xa3\x41\x2b\x0c\x7e\x1c\xad\xbf\x8c\xfe\x39\x9c\xfd\xc8\x89\xaf\xff\x0b\x00\x00\xff\xff\x6c\xad\x8d\xce\xac\x08\x00\x00")

func i18nResourcesZh_hantAllJsonBytes() ([]byte, error) {
	return bindataRead(
		_i18nResourcesZh_hantAllJson,
		"i18n/resources/zh_Hant.all.json",
	)
}

func i18nResourcesZh_hantAllJson() (*asset, error) {
	bytes, err := i18nResourcesZh_hantAllJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "i18n/resources/zh_Hant.all.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"i18n/resources/de_DE.all.json":   i18nResourcesDe_deAllJson,
	"i18n/resources/en_US.all.json":   i18nResourcesEn_usAllJson,
	"i18n/resources/es_ES.all.json":   i18nResourcesEs_esAllJson,
	"i18n/resources/fr_FR.all.json":   i18nResourcesFr_frAllJson,
	"i18n/resources/it_IT.all.json":   i18nResourcesIt_itAllJson,
	"i18n/resources/ja_JP.all.json":   i18nResourcesJa_jpAllJson,
	"i18n/resources/ko_KR.all.json":   i18nResourcesKo_krAllJson,
	"i18n/resources/pt_BR.all.json":   i18nResourcesPt_brAllJson,
	"i18n/resources/zh_Hans.all.json": i18nResourcesZh_hansAllJson,
	"i18n/resources/zh_Hant.all.json": i18nResourcesZh_hantAllJson,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"}
// AssetDir("data/img") would return []string{"a.png", "b.png"}
// AssetDir("foo.txt") and AssetDir("notexist") would return an error
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		cannonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(cannonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}

var _bintree = &bintree{nil, map[string]*bintree{
	"i18n": &bintree{nil, map[string]*bintree{
		"resources": &bintree{nil, map[string]*bintree{
			"de_DE.all.json":   &bintree{i18nResourcesDe_deAllJson, map[string]*bintree{}},
			"en_US.all.json":   &bintree{i18nResourcesEn_usAllJson, map[string]*bintree{}},
			"es_ES.all.json":   &bintree{i18nResourcesEs_esAllJson, map[string]*bintree{}},
			"fr_FR.all.json":   &bintree{i18nResourcesFr_frAllJson, map[string]*bintree{}},
			"it_IT.all.json":   &bintree{i18nResourcesIt_itAllJson, map[string]*bintree{}},
			"ja_JP.all.json":   &bintree{i18nResourcesJa_jpAllJson, map[string]*bintree{}},
			"ko_KR.all.json":   &bintree{i18nResourcesKo_krAllJson, map[string]*bintree{}},
			"pt_BR.all.json":   &bintree{i18nResourcesPt_brAllJson, map[string]*bintree{}},
			"zh_Hans.all.json": &bintree{i18nResourcesZh_hansAllJson, map[string]*bintree{}},
			"zh_Hant.all.json": &bintree{i18nResourcesZh_hantAllJson, map[string]*bintree{}},
		}},
	}},
}}

// RestoreAsset restores an asset under the given directory
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	err = os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
	if err != nil {
		return err
	}
	return nil
}

// RestoreAssets restores an asset under the given directory recursively
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(cannonicalName, "/")...)...)
}
