// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by the FlatBuffers compiler. DO NOT EDIT.

package flatbuf

import (
	flatbuffers "github.com/google/flatbuffers/go"
)

/// Time elapsed from the Unix epoch, 00:00:00.000 on 1 January 1970, excluding
/// leap seconds, as a 64-bit integer. Note that UNIX time does not include
/// leap seconds.
///
/// The Timestamp metadata supports both "time zone naive" and "time zone
/// aware" timestamps. Read about the timezone attribute for more detail
type Timestamp struct {
	_tab flatbuffers.Table
}

func GetRootAsTimestamp(buf []byte, offset flatbuffers.UOffsetT) *Timestamp {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &Timestamp{}
	x.Init(buf, n+offset)
	return x
}

func (rcv *Timestamp) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *Timestamp) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *Timestamp) Unit() TimeUnit {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.GetInt16(o + rcv._tab.Pos)
	}
	return 0
}

func (rcv *Timestamp) MutateUnit(n TimeUnit) bool {
	return rcv._tab.MutateInt16Slot(4, n)
}

/// The time zone is a string indicating the name of a time zone, one of:
///
/// * As used in the Olson time zone database (the "tz database" or
///   "tzdata"), such as "America/New_York"
/// * An absolute time zone offset of the form +XX:XX or -XX:XX, such as +07:30
///
/// Whether a timezone string is present indicates different semantics about
/// the data:
///
/// * If the time zone is null or equal to an empty string, the data is "time
///   zone naive" and shall be displayed *as is* to the user, not localized
///   to the locale of the user. This data can be though of as UTC but
///   without having "UTC" as the time zone, it is not considered to be
///   localized to any time zone
///
/// * If the time zone is set to a valid value, values can be displayed as
///   "localized" to that time zone, even though the underlying 64-bit
///   integers are identical to the same data stored in UTC. Converting
///   between time zones is a metadata-only operation and does not change the
///   underlying values
func (rcv *Timestamp) Timezone() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

/// The time zone is a string indicating the name of a time zone, one of:
///
/// * As used in the Olson time zone database (the "tz database" or
///   "tzdata"), such as "America/New_York"
/// * An absolute time zone offset of the form +XX:XX or -XX:XX, such as +07:30
///
/// Whether a timezone string is present indicates different semantics about
/// the data:
///
/// * If the time zone is null or equal to an empty string, the data is "time
///   zone naive" and shall be displayed *as is* to the user, not localized
///   to the locale of the user. This data can be though of as UTC but
///   without having "UTC" as the time zone, it is not considered to be
///   localized to any time zone
///
/// * If the time zone is set to a valid value, values can be displayed as
///   "localized" to that time zone, even though the underlying 64-bit
///   integers are identical to the same data stored in UTC. Converting
///   between time zones is a metadata-only operation and does not change the
///   underlying values
func TimestampStart(builder *flatbuffers.Builder) {
	builder.StartObject(2)
}
func TimestampAddUnit(builder *flatbuffers.Builder, unit int16) {
	builder.PrependInt16Slot(0, unit, 0)
}
func TimestampAddTimezone(builder *flatbuffers.Builder, timezone flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(timezone), 0)
}
func TimestampEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}
