// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package organizations

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListParentsInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the OU or account whose parent containers you
	// want to list. Don't specify a root.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a child ID string
	// requires one of the following:
	//
	//    * Account - A string that consists of exactly 12 digits.
	//
	//    * Organizational unit (OU) - A string that begins with "ou-" followed
	//    by from 4 to 32 lowercase letters or digits (the ID of the root that contains
	//    the OU). This string is followed by a second "-" dash and from 8 to 32
	//    additional lowercase letters or digits.
	//
	// ChildId is a required field
	ChildId *string `type:"string" required:"true"`

	// (Optional) Use this to limit the number of results you want included per
	// page in the response. If you do not include this parameter, it defaults to
	// a value that is specific to the operation. If additional items exist beyond
	// the maximum you specify, the NextToken response element is present and has
	// a value (is not null). Include that value as the NextToken request parameter
	// in the next call to the operation to get the next part of the results. Note
	// that Organizations might return fewer results than the maximum even when
	// there are more results available. You should check NextToken after every
	// operation to ensure that you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// Use this parameter if you receive a NextToken response in a previous request
	// that indicates that there is more output available. Set it to the value of
	// the previous call's NextToken response to indicate where the output should
	// continue from.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListParentsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListParentsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListParentsInput"}

	if s.ChildId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChildId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListParentsOutput struct {
	_ struct{} `type:"structure"`

	// If present, this value indicates that there is more output available than
	// is included in the current response. Use this value in the NextToken request
	// parameter in a subsequent call to the operation to get the next part of the
	// output. You should repeat this until the NextToken response element comes
	// back as null.
	NextToken *string `type:"string"`

	// A list of parents for the specified child account or OU.
	Parents []Parent `type:"list"`
}

// String returns the string representation
func (s ListParentsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListParents = "ListParents"

// ListParentsRequest returns a request value for making API operation for
// AWS Organizations.
//
// Lists the root or organizational units (OUs) that serve as the immediate
// parent of the specified child OU or account. This operation, along with ListChildren
// enables you to traverse the tree structure that makes up this root.
//
// Always check the NextToken response parameter for a null value when calling
// a List* operation. These operations can occasionally return an empty set
// of results even when there are more results available. The NextToken response
// parameter value is null only when there are no more results to display.
//
// This operation can be called only from the organization's master account.
//
// In the current release, a child can have only a single parent.
//
//    // Example sending a request using ListParentsRequest.
//    req := client.ListParentsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListParents
func (c *Client) ListParentsRequest(input *ListParentsInput) ListParentsRequest {
	op := &aws.Operation{
		Name:       opListParents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListParentsInput{}
	}

	req := c.newRequest(op, input, &ListParentsOutput{})
	return ListParentsRequest{Request: req, Input: input, Copy: c.ListParentsRequest}
}

// ListParentsRequest is the request type for the
// ListParents API operation.
type ListParentsRequest struct {
	*aws.Request
	Input *ListParentsInput
	Copy  func(*ListParentsInput) ListParentsRequest
}

// Send marshals and sends the ListParents API request.
func (r ListParentsRequest) Send(ctx context.Context) (*ListParentsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListParentsResponse{
		ListParentsOutput: r.Request.Data.(*ListParentsOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListParentsRequestPaginator returns a paginator for ListParents.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListParentsRequest(input)
//   p := organizations.NewListParentsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListParentsPaginator(req ListParentsRequest) ListParentsPaginator {
	return ListParentsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListParentsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListParentsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListParentsPaginator struct {
	aws.Pager
}

func (p *ListParentsPaginator) CurrentPage() *ListParentsOutput {
	return p.Pager.CurrentPage().(*ListParentsOutput)
}

// ListParentsResponse is the response type for the
// ListParents API operation.
type ListParentsResponse struct {
	*ListParentsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListParents request.
func (r *ListParentsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
