// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package storagegateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeCacheInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeCacheInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCacheInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeCacheInput"}

	if s.GatewayARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(aws.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeCacheOutput struct {
	_ struct{} `type:"structure"`

	// The amount of cache in bytes allocated to the a gateway.
	CacheAllocatedInBytes *int64 `type:"long"`

	// The file share's contribution to the overall percentage of the gateway's
	// cache that has not been persisted to AWS. The sample is taken at the end
	// of the reporting period.
	CacheDirtyPercentage *float64 `type:"double"`

	// Percent of application read operations from the file shares that are served
	// from cache. The sample is taken at the end of the reporting period.
	CacheHitPercentage *float64 `type:"double"`

	// Percent of application read operations from the file shares that are not
	// served from cache. The sample is taken at the end of the reporting period.
	CacheMissPercentage *float64 `type:"double"`

	// Percent use of the gateway's cache storage. This metric applies only to the
	// gateway-cached volume setup. The sample is taken at the end of the reporting
	// period.
	CacheUsedPercentage *float64 `type:"double"`

	// An array of strings that identify disks that are to be configured as working
	// storage. Each string have a minimum length of 1 and maximum length of 300.
	// You can get the disk IDs from the ListLocalDisks API.
	DiskIds []string `type:"list"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DescribeCacheOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeCache = "DescribeCache"

// DescribeCacheRequest returns a request value for making API operation for
// AWS Storage Gateway.
//
// Returns information about the cache of a gateway. This operation is only
// supported in the cached volume, tape and file gateway types.
//
// The response includes disk IDs that are configured as cache, and it includes
// the amount of cache allocated and used.
//
//    // Example sending a request using DescribeCacheRequest.
//    req := client.DescribeCacheRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeCache
func (c *Client) DescribeCacheRequest(input *DescribeCacheInput) DescribeCacheRequest {
	op := &aws.Operation{
		Name:       opDescribeCache,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCacheInput{}
	}

	req := c.newRequest(op, input, &DescribeCacheOutput{})
	return DescribeCacheRequest{Request: req, Input: input, Copy: c.DescribeCacheRequest}
}

// DescribeCacheRequest is the request type for the
// DescribeCache API operation.
type DescribeCacheRequest struct {
	*aws.Request
	Input *DescribeCacheInput
	Copy  func(*DescribeCacheInput) DescribeCacheRequest
}

// Send marshals and sends the DescribeCache API request.
func (r DescribeCacheRequest) Send(ctx context.Context) (*DescribeCacheResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeCacheResponse{
		DescribeCacheOutput: r.Request.Data.(*DescribeCacheOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeCacheResponse is the response type for the
// DescribeCache API operation.
type DescribeCacheResponse struct {
	*DescribeCacheOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeCache request.
func (r *DescribeCacheResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
