// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetAccountSendingEnabledInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetAccountSendingEnabledInput) String() string {
	return awsutil.Prettify(s)
}

// Represents a request to return the email sending status for your Amazon SES
// account in the current AWS Region.
type GetAccountSendingEnabledOutput struct {
	_ struct{} `type:"structure"`

	// Describes whether email sending is enabled or disabled for your Amazon SES
	// account in the current AWS Region.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s GetAccountSendingEnabledOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetAccountSendingEnabled = "GetAccountSendingEnabled"

// GetAccountSendingEnabledRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Returns the email sending status of the Amazon SES account for the current
// region.
//
// You can execute this operation no more than once per second.
//
//    // Example sending a request using GetAccountSendingEnabledRequest.
//    req := client.GetAccountSendingEnabledRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetAccountSendingEnabled
func (c *Client) GetAccountSendingEnabledRequest(input *GetAccountSendingEnabledInput) GetAccountSendingEnabledRequest {
	op := &aws.Operation{
		Name:       opGetAccountSendingEnabled,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAccountSendingEnabledInput{}
	}

	req := c.newRequest(op, input, &GetAccountSendingEnabledOutput{})
	return GetAccountSendingEnabledRequest{Request: req, Input: input, Copy: c.GetAccountSendingEnabledRequest}
}

// GetAccountSendingEnabledRequest is the request type for the
// GetAccountSendingEnabled API operation.
type GetAccountSendingEnabledRequest struct {
	*aws.Request
	Input *GetAccountSendingEnabledInput
	Copy  func(*GetAccountSendingEnabledInput) GetAccountSendingEnabledRequest
}

// Send marshals and sends the GetAccountSendingEnabled API request.
func (r GetAccountSendingEnabledRequest) Send(ctx context.Context) (*GetAccountSendingEnabledResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetAccountSendingEnabledResponse{
		GetAccountSendingEnabledOutput: r.Request.Data.(*GetAccountSendingEnabledOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetAccountSendingEnabledResponse is the response type for the
// GetAccountSendingEnabled API operation.
type GetAccountSendingEnabledResponse struct {
	*GetAccountSendingEnabledOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetAccountSendingEnabled request.
func (r *GetAccountSendingEnabledResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
