// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type StopMonitoringScheduleInput struct {
	_ struct{} `type:"structure"`

	// The name of the schedule to stop.
	//
	// MonitoringScheduleName is a required field
	MonitoringScheduleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopMonitoringScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopMonitoringScheduleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopMonitoringScheduleInput"}

	if s.MonitoringScheduleName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MonitoringScheduleName"))
	}
	if s.MonitoringScheduleName != nil && len(*s.MonitoringScheduleName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MonitoringScheduleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StopMonitoringScheduleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopMonitoringScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopMonitoringSchedule = "StopMonitoringSchedule"

// StopMonitoringScheduleRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Stops a previously started monitoring schedule.
//
//    // Example sending a request using StopMonitoringScheduleRequest.
//    req := client.StopMonitoringScheduleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopMonitoringSchedule
func (c *Client) StopMonitoringScheduleRequest(input *StopMonitoringScheduleInput) StopMonitoringScheduleRequest {
	op := &aws.Operation{
		Name:       opStopMonitoringSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopMonitoringScheduleInput{}
	}

	req := c.newRequest(op, input, &StopMonitoringScheduleOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return StopMonitoringScheduleRequest{Request: req, Input: input, Copy: c.StopMonitoringScheduleRequest}
}

// StopMonitoringScheduleRequest is the request type for the
// StopMonitoringSchedule API operation.
type StopMonitoringScheduleRequest struct {
	*aws.Request
	Input *StopMonitoringScheduleInput
	Copy  func(*StopMonitoringScheduleInput) StopMonitoringScheduleRequest
}

// Send marshals and sends the StopMonitoringSchedule API request.
func (r StopMonitoringScheduleRequest) Send(ctx context.Context) (*StopMonitoringScheduleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopMonitoringScheduleResponse{
		StopMonitoringScheduleOutput: r.Request.Data.(*StopMonitoringScheduleOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopMonitoringScheduleResponse is the response type for the
// StopMonitoringSchedule API operation.
type StopMonitoringScheduleResponse struct {
	*StopMonitoringScheduleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopMonitoringSchedule request.
func (r *StopMonitoringScheduleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
