// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

type DeleteClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the parameter group to be deleted.
	//
	// Constraints:
	//
	//    * Must be the name of an existing cluster parameter group.
	//
	//    * Cannot delete a default cluster parameter group.
	//
	// ParameterGroupName is a required field
	ParameterGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClusterParameterGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteClusterParameterGroupInput"}

	if s.ParameterGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteClusterParameterGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteClusterParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteClusterParameterGroup = "DeleteClusterParameterGroup"

// DeleteClusterParameterGroupRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Deletes a specified Amazon Redshift parameter group.
//
// You cannot delete a parameter group if it is associated with a cluster.
//
//    // Example sending a request using DeleteClusterParameterGroupRequest.
//    req := client.DeleteClusterParameterGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterParameterGroup
func (c *Client) DeleteClusterParameterGroupRequest(input *DeleteClusterParameterGroupInput) DeleteClusterParameterGroupRequest {
	op := &aws.Operation{
		Name:       opDeleteClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteClusterParameterGroupInput{}
	}

	req := c.newRequest(op, input, &DeleteClusterParameterGroupOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteClusterParameterGroupRequest{Request: req, Input: input, Copy: c.DeleteClusterParameterGroupRequest}
}

// DeleteClusterParameterGroupRequest is the request type for the
// DeleteClusterParameterGroup API operation.
type DeleteClusterParameterGroupRequest struct {
	*aws.Request
	Input *DeleteClusterParameterGroupInput
	Copy  func(*DeleteClusterParameterGroupInput) DeleteClusterParameterGroupRequest
}

// Send marshals and sends the DeleteClusterParameterGroup API request.
func (r DeleteClusterParameterGroupRequest) Send(ctx context.Context) (*DeleteClusterParameterGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteClusterParameterGroupResponse{
		DeleteClusterParameterGroupOutput: r.Request.Data.(*DeleteClusterParameterGroupOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteClusterParameterGroupResponse is the response type for the
// DeleteClusterParameterGroup API operation.
type DeleteClusterParameterGroupResponse struct {
	*DeleteClusterParameterGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteClusterParameterGroup request.
func (r *DeleteClusterParameterGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
