// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mturk

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type AcceptQualificationRequestInput struct {
	_ struct{} `type:"structure"`

	// The value of the Qualification. You can omit this value if you are using
	// the presence or absence of the Qualification as the basis for a HIT requirement.
	IntegerValue *int64 `type:"integer"`

	// The ID of the Qualification request, as returned by the GetQualificationRequests
	// operation.
	//
	// QualificationRequestId is a required field
	QualificationRequestId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AcceptQualificationRequestInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptQualificationRequestInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AcceptQualificationRequestInput"}

	if s.QualificationRequestId == nil {
		invalidParams.Add(aws.NewErrParamRequired("QualificationRequestId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AcceptQualificationRequestOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AcceptQualificationRequestOutput) String() string {
	return awsutil.Prettify(s)
}

const opAcceptQualificationRequest = "AcceptQualificationRequest"

// AcceptQualificationRequestRequest returns a request value for making API operation for
// Amazon Mechanical Turk.
//
// The AcceptQualificationRequest operation approves a Worker's request for
// a Qualification.
//
// Only the owner of the Qualification type can grant a Qualification request
// for that type.
//
// A successful request for the AcceptQualificationRequest operation returns
// with no errors and an empty body.
//
//    // Example sending a request using AcceptQualificationRequestRequest.
//    req := client.AcceptQualificationRequestRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/AcceptQualificationRequest
func (c *Client) AcceptQualificationRequestRequest(input *AcceptQualificationRequestInput) AcceptQualificationRequestRequest {
	op := &aws.Operation{
		Name:       opAcceptQualificationRequest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcceptQualificationRequestInput{}
	}

	req := c.newRequest(op, input, &AcceptQualificationRequestOutput{})
	return AcceptQualificationRequestRequest{Request: req, Input: input, Copy: c.AcceptQualificationRequestRequest}
}

// AcceptQualificationRequestRequest is the request type for the
// AcceptQualificationRequest API operation.
type AcceptQualificationRequestRequest struct {
	*aws.Request
	Input *AcceptQualificationRequestInput
	Copy  func(*AcceptQualificationRequestInput) AcceptQualificationRequestRequest
}

// Send marshals and sends the AcceptQualificationRequest API request.
func (r AcceptQualificationRequestRequest) Send(ctx context.Context) (*AcceptQualificationRequestResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AcceptQualificationRequestResponse{
		AcceptQualificationRequestOutput: r.Request.Data.(*AcceptQualificationRequestOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AcceptQualificationRequestResponse is the response type for the
// AcceptQualificationRequest API operation.
type AcceptQualificationRequestResponse struct {
	*AcceptQualificationRequestOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AcceptQualificationRequest request.
func (r *AcceptQualificationRequestResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
