// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kendra

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateIndexInput struct {
	_ struct{} `type:"structure"`

	// A description for the index.
	Description *string `min:"1" type:"string"`

	// The name for the new index.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// An IAM role that gives Amazon Kendra permissions to access your Amazon CloudWatch
	// logs and metrics. This is also the role used when you use the BatchPutDocument
	// operation to index documents from an Amazon S3 bucket.
	//
	// RoleArn is a required field
	RoleArn *string `min:"1" type:"string" required:"true"`

	// The identifier of the AWS KMS customer managed key (CMK) to use to encrypt
	// data indexed by Amazon Kendra. Amazon Kendra doesn't support asymmetric CMKs.
	ServerSideEncryptionConfiguration *ServerSideEncryptionConfiguration `type:"structure"`
}

// String returns the string representation
func (s CreateIndexInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIndexInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateIndexInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 1))
	}
	if s.ServerSideEncryptionConfiguration != nil {
		if err := s.ServerSideEncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ServerSideEncryptionConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateIndexOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the index. Use this identifier when you query an
	// index, set up a data source, or index a document.
	Id *string `min:"36" type:"string"`
}

// String returns the string representation
func (s CreateIndexOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateIndex = "CreateIndex"

// CreateIndexRequest returns a request value for making API operation for
// AWSKendraFrontendService.
//
// Creates a new Amazon Kendra index. Index creation is an asynchronous operation.
// To determine if index creation has completed, check the Status field returned
// from a call to . The Status field is set to ACTIVE when the index is ready
// to use.
//
// Once the index is active you can index your documents using the operation
// or using one of the supported data sources.
//
//    // Example sending a request using CreateIndexRequest.
//    req := client.CreateIndexRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateIndex
func (c *Client) CreateIndexRequest(input *CreateIndexInput) CreateIndexRequest {
	op := &aws.Operation{
		Name:       opCreateIndex,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateIndexInput{}
	}

	req := c.newRequest(op, input, &CreateIndexOutput{})
	return CreateIndexRequest{Request: req, Input: input, Copy: c.CreateIndexRequest}
}

// CreateIndexRequest is the request type for the
// CreateIndex API operation.
type CreateIndexRequest struct {
	*aws.Request
	Input *CreateIndexInput
	Copy  func(*CreateIndexInput) CreateIndexRequest
}

// Send marshals and sends the CreateIndex API request.
func (r CreateIndexRequest) Send(ctx context.Context) (*CreateIndexResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateIndexResponse{
		CreateIndexOutput: r.Request.Data.(*CreateIndexOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateIndexResponse is the response type for the
// CreateIndex API operation.
type CreateIndexResponse struct {
	*CreateIndexOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateIndex request.
func (r *CreateIndexResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
