// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeAuditTaskInput struct {
	_ struct{} `type:"structure"`

	// The ID of the audit whose information you want to get.
	//
	// TaskId is a required field
	TaskId *string `location:"uri" locationName:"taskId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAuditTaskInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAuditTaskInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeAuditTaskInput"}

	if s.TaskId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TaskId"))
	}
	if s.TaskId != nil && len(*s.TaskId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TaskId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeAuditTaskInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.TaskId != nil {
		v := *s.TaskId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "taskId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeAuditTaskOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about each check performed during this audit.
	AuditDetails map[string]AuditCheckDetails `locationName:"auditDetails" type:"map"`

	// The name of the scheduled audit (only if the audit was a scheduled audit).
	ScheduledAuditName *string `locationName:"scheduledAuditName" min:"1" type:"string"`

	// The time the audit started.
	TaskStartTime *time.Time `locationName:"taskStartTime" type:"timestamp"`

	// Statistical information about the audit.
	TaskStatistics *TaskStatistics `locationName:"taskStatistics" type:"structure"`

	// The status of the audit: one of "IN_PROGRESS", "COMPLETED", "FAILED", or
	// "CANCELED".
	TaskStatus AuditTaskStatus `locationName:"taskStatus" type:"string" enum:"true"`

	// The type of audit: "ON_DEMAND_AUDIT_TASK" or "SCHEDULED_AUDIT_TASK".
	TaskType AuditTaskType `locationName:"taskType" type:"string" enum:"true"`
}

// String returns the string representation
func (s DescribeAuditTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeAuditTaskOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AuditDetails != nil {
		v := s.AuditDetails

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "auditDetails", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.ScheduledAuditName != nil {
		v := *s.ScheduledAuditName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "scheduledAuditName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TaskStartTime != nil {
		v := *s.TaskStartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "taskStartTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.TaskStatistics != nil {
		v := s.TaskStatistics

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "taskStatistics", v, metadata)
	}
	if len(s.TaskStatus) > 0 {
		v := s.TaskStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "taskStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.TaskType) > 0 {
		v := s.TaskType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "taskType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

const opDescribeAuditTask = "DescribeAuditTask"

// DescribeAuditTaskRequest returns a request value for making API operation for
// AWS IoT.
//
// Gets information about a Device Defender audit.
//
//    // Example sending a request using DescribeAuditTaskRequest.
//    req := client.DescribeAuditTaskRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DescribeAuditTaskRequest(input *DescribeAuditTaskInput) DescribeAuditTaskRequest {
	op := &aws.Operation{
		Name:       opDescribeAuditTask,
		HTTPMethod: "GET",
		HTTPPath:   "/audit/tasks/{taskId}",
	}

	if input == nil {
		input = &DescribeAuditTaskInput{}
	}

	req := c.newRequest(op, input, &DescribeAuditTaskOutput{})
	return DescribeAuditTaskRequest{Request: req, Input: input, Copy: c.DescribeAuditTaskRequest}
}

// DescribeAuditTaskRequest is the request type for the
// DescribeAuditTask API operation.
type DescribeAuditTaskRequest struct {
	*aws.Request
	Input *DescribeAuditTaskInput
	Copy  func(*DescribeAuditTaskInput) DescribeAuditTaskRequest
}

// Send marshals and sends the DescribeAuditTask API request.
func (r DescribeAuditTaskRequest) Send(ctx context.Context) (*DescribeAuditTaskResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAuditTaskResponse{
		DescribeAuditTaskOutput: r.Request.Data.(*DescribeAuditTaskOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeAuditTaskResponse is the response type for the
// DescribeAuditTask API operation.
type DescribeAuditTaskResponse struct {
	*DescribeAuditTaskOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeAuditTask request.
func (r *DescribeAuditTaskResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
