// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteTriggerInput struct {
	_ struct{} `type:"structure"`

	// The name of the trigger to delete.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTriggerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTriggerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteTriggerInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteTriggerOutput struct {
	_ struct{} `type:"structure"`

	// The name of the trigger that was deleted.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteTriggerOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteTrigger = "DeleteTrigger"

// DeleteTriggerRequest returns a request value for making API operation for
// AWS Glue.
//
// Deletes a specified trigger. If the trigger is not found, no exception is
// thrown.
//
//    // Example sending a request using DeleteTriggerRequest.
//    req := client.DeleteTriggerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTrigger
func (c *Client) DeleteTriggerRequest(input *DeleteTriggerInput) DeleteTriggerRequest {
	op := &aws.Operation{
		Name:       opDeleteTrigger,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTriggerInput{}
	}

	req := c.newRequest(op, input, &DeleteTriggerOutput{})
	return DeleteTriggerRequest{Request: req, Input: input, Copy: c.DeleteTriggerRequest}
}

// DeleteTriggerRequest is the request type for the
// DeleteTrigger API operation.
type DeleteTriggerRequest struct {
	*aws.Request
	Input *DeleteTriggerInput
	Copy  func(*DeleteTriggerInput) DeleteTriggerRequest
}

// Send marshals and sends the DeleteTrigger API request.
func (r DeleteTriggerRequest) Send(ctx context.Context) (*DeleteTriggerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteTriggerResponse{
		DeleteTriggerOutput: r.Request.Data.(*DeleteTriggerOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteTriggerResponse is the response type for the
// DeleteTrigger API operation.
type DeleteTriggerResponse struct {
	*DeleteTriggerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteTrigger request.
func (r *DeleteTriggerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
