// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directoryservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StartSchemaExtensionInput struct {
	_ struct{} `type:"structure"`

	// If true, creates a snapshot of the directory before applying the schema extension.
	//
	// CreateSnapshotBeforeSchemaExtension is a required field
	CreateSnapshotBeforeSchemaExtension *bool `type:"boolean" required:"true"`

	// A description of the schema extension.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The identifier of the directory for which the schema extension will be applied
	// to.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The LDIF file represented as a string. To construct the LdifContent string,
	// precede each line as it would be formatted in an ldif file with \n. See the
	// example request below for more details. The file size can be no larger than
	// 1MB.
	//
	// LdifContent is a required field
	LdifContent *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartSchemaExtensionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartSchemaExtensionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartSchemaExtensionInput"}

	if s.CreateSnapshotBeforeSchemaExtension == nil {
		invalidParams.Add(aws.NewErrParamRequired("CreateSnapshotBeforeSchemaExtension"))
	}

	if s.Description == nil {
		invalidParams.Add(aws.NewErrParamRequired("Description"))
	}

	if s.DirectoryId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DirectoryId"))
	}

	if s.LdifContent == nil {
		invalidParams.Add(aws.NewErrParamRequired("LdifContent"))
	}
	if s.LdifContent != nil && len(*s.LdifContent) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LdifContent", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StartSchemaExtensionOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the schema extension that will be applied.
	SchemaExtensionId *string `type:"string"`
}

// String returns the string representation
func (s StartSchemaExtensionOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartSchemaExtension = "StartSchemaExtension"

// StartSchemaExtensionRequest returns a request value for making API operation for
// AWS Directory Service.
//
// Applies a schema extension to a Microsoft AD directory.
//
//    // Example sending a request using StartSchemaExtensionRequest.
//    req := client.StartSchemaExtensionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/StartSchemaExtension
func (c *Client) StartSchemaExtensionRequest(input *StartSchemaExtensionInput) StartSchemaExtensionRequest {
	op := &aws.Operation{
		Name:       opStartSchemaExtension,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartSchemaExtensionInput{}
	}

	req := c.newRequest(op, input, &StartSchemaExtensionOutput{})
	return StartSchemaExtensionRequest{Request: req, Input: input, Copy: c.StartSchemaExtensionRequest}
}

// StartSchemaExtensionRequest is the request type for the
// StartSchemaExtension API operation.
type StartSchemaExtensionRequest struct {
	*aws.Request
	Input *StartSchemaExtensionInput
	Copy  func(*StartSchemaExtensionInput) StartSchemaExtensionRequest
}

// Send marshals and sends the StartSchemaExtension API request.
func (r StartSchemaExtensionRequest) Send(ctx context.Context) (*StartSchemaExtensionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartSchemaExtensionResponse{
		StartSchemaExtensionOutput: r.Request.Data.(*StartSchemaExtensionOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartSchemaExtensionResponse is the response type for the
// StartSchemaExtension API operation.
type StartSchemaExtensionResponse struct {
	*StartSchemaExtensionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartSchemaExtension request.
func (r *StartSchemaExtensionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
