// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package comprehendmedicaliface provides an interface to enable mocking the AWS Comprehend Medical service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package comprehendmedicaliface

import (
	"github.com/aws/aws-sdk-go-v2/service/comprehendmedical"
)

// ClientAPI provides an interface to enable mocking the
// comprehendmedical.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // ComprehendMedical.
//    func myFunc(svc comprehendmedicaliface.ClientAPI) bool {
//        // Make svc.DescribeEntitiesDetectionV2Job request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := comprehendmedical.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        comprehendmedicaliface.ClientPI
//    }
//    func (m *mockClientClient) DescribeEntitiesDetectionV2Job(input *comprehendmedical.DescribeEntitiesDetectionV2JobInput) (*comprehendmedical.DescribeEntitiesDetectionV2JobOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	DescribeEntitiesDetectionV2JobRequest(*comprehendmedical.DescribeEntitiesDetectionV2JobInput) comprehendmedical.DescribeEntitiesDetectionV2JobRequest

	DescribePHIDetectionJobRequest(*comprehendmedical.DescribePHIDetectionJobInput) comprehendmedical.DescribePHIDetectionJobRequest

	DetectEntitiesRequest(*comprehendmedical.DetectEntitiesInput) comprehendmedical.DetectEntitiesRequest

	DetectEntitiesV2Request(*comprehendmedical.DetectEntitiesV2Input) comprehendmedical.DetectEntitiesV2Request

	DetectPHIRequest(*comprehendmedical.DetectPHIInput) comprehendmedical.DetectPHIRequest

	ListEntitiesDetectionV2JobsRequest(*comprehendmedical.ListEntitiesDetectionV2JobsInput) comprehendmedical.ListEntitiesDetectionV2JobsRequest

	ListPHIDetectionJobsRequest(*comprehendmedical.ListPHIDetectionJobsInput) comprehendmedical.ListPHIDetectionJobsRequest

	StartEntitiesDetectionV2JobRequest(*comprehendmedical.StartEntitiesDetectionV2JobInput) comprehendmedical.StartEntitiesDetectionV2JobRequest

	StartPHIDetectionJobRequest(*comprehendmedical.StartPHIDetectionJobInput) comprehendmedical.StartPHIDetectionJobRequest

	StopEntitiesDetectionV2JobRequest(*comprehendmedical.StopEntitiesDetectionV2JobInput) comprehendmedical.StopEntitiesDetectionV2JobRequest

	StopPHIDetectionJobRequest(*comprehendmedical.StopPHIDetectionJobInput) comprehendmedical.StopPHIDetectionJobRequest
}

var _ ClientAPI = (*comprehendmedical.Client)(nil)
