
/*
 * Copyright (C) Nginx, Inc.
 *
 * Do not edit, generated by: utils/lexer_keyword.py.
 */


#ifndef _NJS_LEXER_TABLES_H_INCLUDED_
#define _NJS_LEXER_TABLES_H_INCLUDED_


static const njs_keyword_t njs_lexer_kws[48] =
{
    { .entry = { njs_str("null") }, .type = NJS_TOKEN_NULL },
    { .entry = { njs_str("false") }, .type = NJS_TOKEN_FALSE },
    { .entry = { njs_str("true") }, .type = NJS_TOKEN_TRUE },
    { .entry = { njs_str("in") }, .type = NJS_TOKEN_IN },
    { .entry = { njs_str("typeof") }, .type = NJS_TOKEN_TYPEOF },
    { .entry = { njs_str("instanceof") }, .type = NJS_TOKEN_INSTANCEOF },
    { .entry = { njs_str("void") }, .type = NJS_TOKEN_VOID },
    { .entry = { njs_str("new") }, .type = NJS_TOKEN_NEW },
    { .entry = { njs_str("delete") }, .type = NJS_TOKEN_DELETE },
    { .entry = { njs_str("yield") }, .type = NJS_TOKEN_YIELD },
    { .entry = { njs_str("var") }, .type = NJS_TOKEN_VAR },
    { .entry = { njs_str("if") }, .type = NJS_TOKEN_IF },
    { .entry = { njs_str("else") }, .type = NJS_TOKEN_ELSE },
    { .entry = { njs_str("while") }, .type = NJS_TOKEN_WHILE },
    { .entry = { njs_str("do") }, .type = NJS_TOKEN_DO },
    { .entry = { njs_str("for") }, .type = NJS_TOKEN_FOR },
    { .entry = { njs_str("break") }, .type = NJS_TOKEN_BREAK },
    { .entry = { njs_str("continue") }, .type = NJS_TOKEN_CONTINUE },
    { .entry = { njs_str("switch") }, .type = NJS_TOKEN_SWITCH },
    { .entry = { njs_str("case") }, .type = NJS_TOKEN_CASE },
    { .entry = { njs_str("default") }, .type = NJS_TOKEN_DEFAULT },
    { .entry = { njs_str("function") }, .type = NJS_TOKEN_FUNCTION },
    { .entry = { njs_str("return") }, .type = NJS_TOKEN_RETURN },
    { .entry = { njs_str("with") }, .type = NJS_TOKEN_WITH },
    { .entry = { njs_str("try") }, .type = NJS_TOKEN_TRY },
    { .entry = { njs_str("catch") }, .type = NJS_TOKEN_CATCH },
    { .entry = { njs_str("finally") }, .type = NJS_TOKEN_FINALLY },
    { .entry = { njs_str("throw") }, .type = NJS_TOKEN_THROW },
    { .entry = { njs_str("import") }, .type = NJS_TOKEN_IMPORT },
    { .entry = { njs_str("export") }, .type = NJS_TOKEN_EXPORT },
    { .entry = { njs_str("this") }, .type = NJS_TOKEN_THIS },
    { .entry = { njs_str("arguments") }, .type = NJS_TOKEN_ARGUMENTS },
    { .entry = { njs_str("eval") }, .type = NJS_TOKEN_EVAL },
    { .entry = { njs_str("await") }, .type = NJS_TOKEN_AWAIT },
    { .entry = { njs_str("class") }, .type = NJS_TOKEN_CLASS },
    { .entry = { njs_str("const") }, .type = NJS_TOKEN_CONST },
    { .entry = { njs_str("debugger") }, .type = NJS_TOKEN_DEBUGGER },
    { .entry = { njs_str("enum") }, .type = NJS_TOKEN_ENUM },
    { .entry = { njs_str("extends") }, .type = NJS_TOKEN_EXTENDS },
    { .entry = { njs_str("implements") }, .type = NJS_TOKEN_IMPLEMENTS },
    { .entry = { njs_str("interface") }, .type = NJS_TOKEN_INTERFACE },
    { .entry = { njs_str("let") }, .type = NJS_TOKEN_LET },
    { .entry = { njs_str("package") }, .type = NJS_TOKEN_PACKAGE },
    { .entry = { njs_str("private") }, .type = NJS_TOKEN_PRIVATE },
    { .entry = { njs_str("protected") }, .type = NJS_TOKEN_PROTECTED },
    { .entry = { njs_str("public") }, .type = NJS_TOKEN_PUBLIC },
    { .entry = { njs_str("static") }, .type = NJS_TOKEN_STATIC },
    { .entry = { njs_str("super") }, .type = NJS_TOKEN_SUPER },
};


static const njs_lexer_keyword_entry_t njs_lexer_keyword_entries[75] =
{
    { NULL, NULL, 74, 0 },
    { "case", &njs_lexer_kws[19], 4, 0 },
    { "continue", &njs_lexer_kws[17], 8, 0 },
    { "do", &njs_lexer_kws[14], 2, 0 },
    { "enum", &njs_lexer_kws[37], 4, 0 },
    { "extends", &njs_lexer_kws[38], 7, 0 },
    { "instanceof", &njs_lexer_kws[5], 10, 0 },
    { "public", &njs_lexer_kws[45], 6, 0 },
    { "static", &njs_lexer_kws[46], 6, 0 },
    { "in", &njs_lexer_kws[3], 2, 0 },
    { "await", &njs_lexer_kws[33], 5, 0 },
    { "private", &njs_lexer_kws[43], 7, 0 },
    { NULL, NULL, 0, 0 },
    { "debugger", &njs_lexer_kws[36], 8, 0 },
    { "for", &njs_lexer_kws[15], 3, 1 },
    { NULL, NULL, 0, 0 },
    { "catch", &njs_lexer_kws[25], 5, 0 },
    { NULL, NULL, 0, 0 },
    { "super", &njs_lexer_kws[47], 5, 2 },
    { NULL, NULL, 0, 0 },
    { "const", &njs_lexer_kws[35], 5, 0 },
    { NULL, NULL, 0, 0 },
    { "false", &njs_lexer_kws[1], 5, 0 },
    { "with", &njs_lexer_kws[23], 4, 0 },
    { "implements", &njs_lexer_kws[39], 10, 0 },
    { "this", &njs_lexer_kws[30], 4, 0 },
    { "let", &njs_lexer_kws[41], 3, 0 },
    { NULL, NULL, 0, 0 },
    { NULL, NULL, 0, 0 },
    { "true", &njs_lexer_kws[2], 4, 0 },
    { NULL, NULL, 0, 0 },
    { "export", &njs_lexer_kws[29], 6, 0 },
    { NULL, NULL, 0, 0 },
    { "interface", &njs_lexer_kws[40], 9, 0 },
    { NULL, NULL, 0, 0 },
    { "eval", &njs_lexer_kws[32], 4, 0 },
    { "protected", &njs_lexer_kws[44], 9, 0 },
    { "while", &njs_lexer_kws[13], 5, 0 },
    { NULL, NULL, 0, 0 },
    { "void", &njs_lexer_kws[6], 4, 0 },
    { NULL, NULL, 0, 0 },
    { "return", &njs_lexer_kws[22], 6, 0 },
    { NULL, NULL, 0, 0 },
    { "delete", &njs_lexer_kws[8], 6, 0 },
    { "yield", &njs_lexer_kws[9], 5, 0 },
    { "null", &njs_lexer_kws[0], 4, 0 },
    { "throw", &njs_lexer_kws[27], 5, 0 },
    { NULL, NULL, 0, 0 },
    { NULL, NULL, 0, 0 },
    { NULL, NULL, 0, 0 },
    { NULL, NULL, 0, 0 },
    { "import", &njs_lexer_kws[28], 6, 0 },
    { NULL, NULL, 0, 0 },
    { "switch", &njs_lexer_kws[18], 6, 0 },
    { "try", &njs_lexer_kws[24], 3, 0 },
    { "function", &njs_lexer_kws[21], 8, 0 },
    { NULL, NULL, 0, 0 },
    { "if", &njs_lexer_kws[11], 2, 0 },
    { "break", &njs_lexer_kws[16], 5, 0 },
    { NULL, NULL, 0, 0 },
    { NULL, NULL, 0, 0 },
    { NULL, NULL, 0, 0 },
    { "var", &njs_lexer_kws[10], 3, 4 },
    { NULL, NULL, 0, 0 },
    { "default", &njs_lexer_kws[20], 7, 0 },
    { "arguments", &njs_lexer_kws[31], 9, 6 },
    { "finally", &njs_lexer_kws[26], 7, 0 },
    { NULL, NULL, 0, 0 },
    { "else", &njs_lexer_kws[12], 4, 0 },
    { "class", &njs_lexer_kws[34], 5, 7 },
    { "new", &njs_lexer_kws[7], 3, 8 },
    { NULL, NULL, 0, 0 },
    { "package", &njs_lexer_kws[42], 7, 11 },
    { "typeof", &njs_lexer_kws[4], 6, 0 },
    { NULL, NULL, 0, 0 },
};


#endif /* _NJS_LEXER_TABLES_H_INCLUDED_ */
