// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/data/accesslog/v2/accesslog.proto

package envoy_data_accesslog_v2

import (
	encoding_binary "encoding/binary"
	fmt "fmt"
	io "io"
	math "math"
	time "time"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	types "github.com/gogo/protobuf/types"
	_ "github.com/lyft/protoc-gen-validate/validate"

	core "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// HTTP version
type HTTPAccessLogEntry_HTTPVersion int32

const (
	HTTPAccessLogEntry_PROTOCOL_UNSPECIFIED HTTPAccessLogEntry_HTTPVersion = 0
	HTTPAccessLogEntry_HTTP10               HTTPAccessLogEntry_HTTPVersion = 1
	HTTPAccessLogEntry_HTTP11               HTTPAccessLogEntry_HTTPVersion = 2
	HTTPAccessLogEntry_HTTP2                HTTPAccessLogEntry_HTTPVersion = 3
)

var HTTPAccessLogEntry_HTTPVersion_name = map[int32]string{
	0: "PROTOCOL_UNSPECIFIED",
	1: "HTTP10",
	2: "HTTP11",
	3: "HTTP2",
}

var HTTPAccessLogEntry_HTTPVersion_value = map[string]int32{
	"PROTOCOL_UNSPECIFIED": 0,
	"HTTP10":               1,
	"HTTP11":               2,
	"HTTP2":                3,
}

func (x HTTPAccessLogEntry_HTTPVersion) String() string {
	return proto.EnumName(HTTPAccessLogEntry_HTTPVersion_name, int32(x))
}

func (HTTPAccessLogEntry_HTTPVersion) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ca1a3c8f3c17c754, []int{1, 0}
}

// Reasons why the request was unauthorized
type ResponseFlags_Unauthorized_Reason int32

const (
	ResponseFlags_Unauthorized_REASON_UNSPECIFIED ResponseFlags_Unauthorized_Reason = 0
	// The request was denied by the external authorization service.
	ResponseFlags_Unauthorized_EXTERNAL_SERVICE ResponseFlags_Unauthorized_Reason = 1
)

var ResponseFlags_Unauthorized_Reason_name = map[int32]string{
	0: "REASON_UNSPECIFIED",
	1: "EXTERNAL_SERVICE",
}

var ResponseFlags_Unauthorized_Reason_value = map[string]int32{
	"REASON_UNSPECIFIED": 0,
	"EXTERNAL_SERVICE":   1,
}

func (x ResponseFlags_Unauthorized_Reason) String() string {
	return proto.EnumName(ResponseFlags_Unauthorized_Reason_name, int32(x))
}

func (ResponseFlags_Unauthorized_Reason) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ca1a3c8f3c17c754, []int{3, 0, 0}
}

type TLSProperties_TLSVersion int32

const (
	TLSProperties_VERSION_UNSPECIFIED TLSProperties_TLSVersion = 0
	TLSProperties_TLSv1               TLSProperties_TLSVersion = 1
	TLSProperties_TLSv1_1             TLSProperties_TLSVersion = 2
	TLSProperties_TLSv1_2             TLSProperties_TLSVersion = 3
	TLSProperties_TLSv1_3             TLSProperties_TLSVersion = 4
)

var TLSProperties_TLSVersion_name = map[int32]string{
	0: "VERSION_UNSPECIFIED",
	1: "TLSv1",
	2: "TLSv1_1",
	3: "TLSv1_2",
	4: "TLSv1_3",
}

var TLSProperties_TLSVersion_value = map[string]int32{
	"VERSION_UNSPECIFIED": 0,
	"TLSv1":               1,
	"TLSv1_1":             2,
	"TLSv1_2":             3,
	"TLSv1_3":             4,
}

func (x TLSProperties_TLSVersion) String() string {
	return proto.EnumName(TLSProperties_TLSVersion_name, int32(x))
}

func (TLSProperties_TLSVersion) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ca1a3c8f3c17c754, []int{4, 0}
}

// [#not-implemented-hide:]
type TCPAccessLogEntry struct {
	// Common properties shared by all Envoy access logs.
	CommonProperties     *AccessLogCommon `protobuf:"bytes,1,opt,name=common_properties,json=commonProperties,proto3" json:"common_properties,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *TCPAccessLogEntry) Reset()         { *m = TCPAccessLogEntry{} }
func (m *TCPAccessLogEntry) String() string { return proto.CompactTextString(m) }
func (*TCPAccessLogEntry) ProtoMessage()    {}
func (*TCPAccessLogEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_ca1a3c8f3c17c754, []int{0}
}
func (m *TCPAccessLogEntry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TCPAccessLogEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *TCPAccessLogEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TCPAccessLogEntry.Merge(m, src)
}
func (m *TCPAccessLogEntry) XXX_Size() int {
	return m.Size()
}
func (m *TCPAccessLogEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_TCPAccessLogEntry.DiscardUnknown(m)
}

var xxx_messageInfo_TCPAccessLogEntry proto.InternalMessageInfo

func (m *TCPAccessLogEntry) GetCommonProperties() *AccessLogCommon {
	if m != nil {
		return m.CommonProperties
	}
	return nil
}

type HTTPAccessLogEntry struct {
	// Common properties shared by all Envoy access logs.
	CommonProperties *AccessLogCommon               `protobuf:"bytes,1,opt,name=common_properties,json=commonProperties,proto3" json:"common_properties,omitempty"`
	ProtocolVersion  HTTPAccessLogEntry_HTTPVersion `protobuf:"varint,2,opt,name=protocol_version,json=protocolVersion,proto3,enum=envoy.data.accesslog.v2.HTTPAccessLogEntry_HTTPVersion" json:"protocol_version,omitempty"`
	// Description of the incoming HTTP request.
	Request *HTTPRequestProperties `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
	// Description of the outgoing HTTP response.
	Response             *HTTPResponseProperties `protobuf:"bytes,4,opt,name=response,proto3" json:"response,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *HTTPAccessLogEntry) Reset()         { *m = HTTPAccessLogEntry{} }
func (m *HTTPAccessLogEntry) String() string { return proto.CompactTextString(m) }
func (*HTTPAccessLogEntry) ProtoMessage()    {}
func (*HTTPAccessLogEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_ca1a3c8f3c17c754, []int{1}
}
func (m *HTTPAccessLogEntry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HTTPAccessLogEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *HTTPAccessLogEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPAccessLogEntry.Merge(m, src)
}
func (m *HTTPAccessLogEntry) XXX_Size() int {
	return m.Size()
}
func (m *HTTPAccessLogEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPAccessLogEntry.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPAccessLogEntry proto.InternalMessageInfo

func (m *HTTPAccessLogEntry) GetCommonProperties() *AccessLogCommon {
	if m != nil {
		return m.CommonProperties
	}
	return nil
}

func (m *HTTPAccessLogEntry) GetProtocolVersion() HTTPAccessLogEntry_HTTPVersion {
	if m != nil {
		return m.ProtocolVersion
	}
	return HTTPAccessLogEntry_PROTOCOL_UNSPECIFIED
}

func (m *HTTPAccessLogEntry) GetRequest() *HTTPRequestProperties {
	if m != nil {
		return m.Request
	}
	return nil
}

func (m *HTTPAccessLogEntry) GetResponse() *HTTPResponseProperties {
	if m != nil {
		return m.Response
	}
	return nil
}

// Defines fields that are shared by all Envoy access logs.
type AccessLogCommon struct {
	// [#not-implemented-hide:]
	// This field indicates the rate at which this log entry was sampled.
	// Valid range is (0.0, 1.0].
	SampleRate float64 `protobuf:"fixed64,1,opt,name=sample_rate,json=sampleRate,proto3" json:"sample_rate,omitempty"`
	// This field is the remote/origin address on which the request from the user was received.
	// Note: This may not be the physical peer. E.g, if the remote address is inferred from for
	// example the x-forwarder-for header, proxy protocol, etc.
	DownstreamRemoteAddress *core.Address `protobuf:"bytes,2,opt,name=downstream_remote_address,json=downstreamRemoteAddress,proto3" json:"downstream_remote_address,omitempty"`
	// This field is the local/destination address on which the request from the user was received.
	DownstreamLocalAddress *core.Address `protobuf:"bytes,3,opt,name=downstream_local_address,json=downstreamLocalAddress,proto3" json:"downstream_local_address,omitempty"`
	// [#not-implemented-hide:]
	// If the connection is secure,S this field will contain TLS properties.
	TlsProperties *TLSProperties `protobuf:"bytes,4,opt,name=tls_properties,json=tlsProperties,proto3" json:"tls_properties,omitempty"`
	// The time that Envoy started servicing this request. This is effectively the time that the first
	// downstream byte is received.
	StartTime *time.Time `protobuf:"bytes,5,opt,name=start_time,json=startTime,proto3,stdtime" json:"start_time,omitempty"`
	// Interval between the first downstream byte received and the last
	// downstream byte received (i.e. time it takes to receive a request).
	TimeToLastRxByte *time.Duration `protobuf:"bytes,6,opt,name=time_to_last_rx_byte,json=timeToLastRxByte,proto3,stdduration" json:"time_to_last_rx_byte,omitempty"`
	// Interval between the first downstream byte received and the first upstream byte sent. There may
	// by considerable delta between *time_to_last_rx_byte* and this value due to filters.
	// Additionally, the same caveats apply as documented in *time_to_last_downstream_tx_byte* about
	// not accounting for kernel socket buffer time, etc.
	TimeToFirstUpstreamTxByte *time.Duration `protobuf:"bytes,7,opt,name=time_to_first_upstream_tx_byte,json=timeToFirstUpstreamTxByte,proto3,stdduration" json:"time_to_first_upstream_tx_byte,omitempty"`
	// Interval between the first downstream byte received and the last upstream byte sent. There may
	// by considerable delta between *time_to_last_rx_byte* and this value due to filters.
	// Additionally, the same caveats apply as documented in *time_to_last_downstream_tx_byte* about
	// not accounting for kernel socket buffer time, etc.
	TimeToLastUpstreamTxByte *time.Duration `protobuf:"bytes,8,opt,name=time_to_last_upstream_tx_byte,json=timeToLastUpstreamTxByte,proto3,stdduration" json:"time_to_last_upstream_tx_byte,omitempty"`
	// Interval between the first downstream byte received and the first upstream
	// byte received (i.e. time it takes to start receiving a response).
	TimeToFirstUpstreamRxByte *time.Duration `protobuf:"bytes,9,opt,name=time_to_first_upstream_rx_byte,json=timeToFirstUpstreamRxByte,proto3,stdduration" json:"time_to_first_upstream_rx_byte,omitempty"`
	// Interval between the first downstream byte received and the last upstream
	// byte received (i.e. time it takes to receive a complete response).
	TimeToLastUpstreamRxByte *time.Duration `protobuf:"bytes,10,opt,name=time_to_last_upstream_rx_byte,json=timeToLastUpstreamRxByte,proto3,stdduration" json:"time_to_last_upstream_rx_byte,omitempty"`
	// Interval between the first downstream byte received and the first downstream byte sent.
	// There may be a considerable delta between the *time_to_first_upstream_rx_byte* and this field
	// due to filters. Additionally, the same caveats apply as documented in
	// *time_to_last_downstream_tx_byte* about not accounting for kernel socket buffer time, etc.
	TimeToFirstDownstreamTxByte *time.Duration `protobuf:"bytes,11,opt,name=time_to_first_downstream_tx_byte,json=timeToFirstDownstreamTxByte,proto3,stdduration" json:"time_to_first_downstream_tx_byte,omitempty"`
	// Interval between the first downstream byte received and the last downstream byte sent.
	// Depending on protocol, buffering, windowing, filters, etc. there may be a considerable delta
	// between *time_to_last_upstream_rx_byte* and this field. Note also that this is an approximate
	// time. In the current implementation it does not include kernel socket buffer time. In the
	// current implementation it also does not include send window buffering inside the HTTP/2 codec.
	// In the future it is likely that work will be done to make this duration more accurate.
	TimeToLastDownstreamTxByte *time.Duration `protobuf:"bytes,12,opt,name=time_to_last_downstream_tx_byte,json=timeToLastDownstreamTxByte,proto3,stdduration" json:"time_to_last_downstream_tx_byte,omitempty"`
	// The upstream remote/destination address that handles this exchange. This does not include
	// retries.
	UpstreamRemoteAddress *core.Address `protobuf:"bytes,13,opt,name=upstream_remote_address,json=upstreamRemoteAddress,proto3" json:"upstream_remote_address,omitempty"`
	// The upstream local/origin address that handles this exchange. This does not include retries.
	UpstreamLocalAddress *core.Address `protobuf:"bytes,14,opt,name=upstream_local_address,json=upstreamLocalAddress,proto3" json:"upstream_local_address,omitempty"`
	// The upstream cluster that *upstream_remote_address* belongs to.
	UpstreamCluster string `protobuf:"bytes,15,opt,name=upstream_cluster,json=upstreamCluster,proto3" json:"upstream_cluster,omitempty"`
	// Flags indicating occurrences during request/response processing.
	ResponseFlags *ResponseFlags `protobuf:"bytes,16,opt,name=response_flags,json=responseFlags,proto3" json:"response_flags,omitempty"`
	// All metadata encountered during request processing, including endpoint
	// selection.
	//
	// This can be used to associate IDs attached to the various configurations
	// used to process this request with the access log entry. For example, a
	// route created from a higher level forwarding rule with some ID can place
	// that ID in this field and cross reference later. It can also be used to
	// determine if a canary endpoint was used or not.
	Metadata *core.Metadata `protobuf:"bytes,17,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// If upstream connection failed due to transport socket (e.g. TLS handshake), provides the
	// failure reason from the transport socket. The format of this field depends on the configured
	// upstream transport socket. Common TLS failures are in
	// :ref:`TLS trouble shooting <arch_overview_ssl_trouble_shooting>`.
	UpstreamTransportFailureReason string   `protobuf:"bytes,18,opt,name=upstream_transport_failure_reason,json=upstreamTransportFailureReason,proto3" json:"upstream_transport_failure_reason,omitempty"`
	XXX_NoUnkeyedLiteral           struct{} `json:"-"`
	XXX_unrecognized               []byte   `json:"-"`
	XXX_sizecache                  int32    `json:"-"`
}

func (m *AccessLogCommon) Reset()         { *m = AccessLogCommon{} }
func (m *AccessLogCommon) String() string { return proto.CompactTextString(m) }
func (*AccessLogCommon) ProtoMessage()    {}
func (*AccessLogCommon) Descriptor() ([]byte, []int) {
	return fileDescriptor_ca1a3c8f3c17c754, []int{2}
}
func (m *AccessLogCommon) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AccessLogCommon) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *AccessLogCommon) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccessLogCommon.Merge(m, src)
}
func (m *AccessLogCommon) XXX_Size() int {
	return m.Size()
}
func (m *AccessLogCommon) XXX_DiscardUnknown() {
	xxx_messageInfo_AccessLogCommon.DiscardUnknown(m)
}

var xxx_messageInfo_AccessLogCommon proto.InternalMessageInfo

func (m *AccessLogCommon) GetSampleRate() float64 {
	if m != nil {
		return m.SampleRate
	}
	return 0
}

func (m *AccessLogCommon) GetDownstreamRemoteAddress() *core.Address {
	if m != nil {
		return m.DownstreamRemoteAddress
	}
	return nil
}

func (m *AccessLogCommon) GetDownstreamLocalAddress() *core.Address {
	if m != nil {
		return m.DownstreamLocalAddress
	}
	return nil
}

func (m *AccessLogCommon) GetTlsProperties() *TLSProperties {
	if m != nil {
		return m.TlsProperties
	}
	return nil
}

func (m *AccessLogCommon) GetStartTime() *time.Time {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *AccessLogCommon) GetTimeToLastRxByte() *time.Duration {
	if m != nil {
		return m.TimeToLastRxByte
	}
	return nil
}

func (m *AccessLogCommon) GetTimeToFirstUpstreamTxByte() *time.Duration {
	if m != nil {
		return m.TimeToFirstUpstreamTxByte
	}
	return nil
}

func (m *AccessLogCommon) GetTimeToLastUpstreamTxByte() *time.Duration {
	if m != nil {
		return m.TimeToLastUpstreamTxByte
	}
	return nil
}

func (m *AccessLogCommon) GetTimeToFirstUpstreamRxByte() *time.Duration {
	if m != nil {
		return m.TimeToFirstUpstreamRxByte
	}
	return nil
}

func (m *AccessLogCommon) GetTimeToLastUpstreamRxByte() *time.Duration {
	if m != nil {
		return m.TimeToLastUpstreamRxByte
	}
	return nil
}

func (m *AccessLogCommon) GetTimeToFirstDownstreamTxByte() *time.Duration {
	if m != nil {
		return m.TimeToFirstDownstreamTxByte
	}
	return nil
}

func (m *AccessLogCommon) GetTimeToLastDownstreamTxByte() *time.Duration {
	if m != nil {
		return m.TimeToLastDownstreamTxByte
	}
	return nil
}

func (m *AccessLogCommon) GetUpstreamRemoteAddress() *core.Address {
	if m != nil {
		return m.UpstreamRemoteAddress
	}
	return nil
}

func (m *AccessLogCommon) GetUpstreamLocalAddress() *core.Address {
	if m != nil {
		return m.UpstreamLocalAddress
	}
	return nil
}

func (m *AccessLogCommon) GetUpstreamCluster() string {
	if m != nil {
		return m.UpstreamCluster
	}
	return ""
}

func (m *AccessLogCommon) GetResponseFlags() *ResponseFlags {
	if m != nil {
		return m.ResponseFlags
	}
	return nil
}

func (m *AccessLogCommon) GetMetadata() *core.Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *AccessLogCommon) GetUpstreamTransportFailureReason() string {
	if m != nil {
		return m.UpstreamTransportFailureReason
	}
	return ""
}

// Flags indicating occurrences during request/response processing.
type ResponseFlags struct {
	// Indicates local server healthcheck failed.
	FailedLocalHealthcheck bool `protobuf:"varint,1,opt,name=failed_local_healthcheck,json=failedLocalHealthcheck,proto3" json:"failed_local_healthcheck,omitempty"`
	// Indicates there was no healthy upstream.
	NoHealthyUpstream bool `protobuf:"varint,2,opt,name=no_healthy_upstream,json=noHealthyUpstream,proto3" json:"no_healthy_upstream,omitempty"`
	// Indicates an there was an upstream request timeout.
	UpstreamRequestTimeout bool `protobuf:"varint,3,opt,name=upstream_request_timeout,json=upstreamRequestTimeout,proto3" json:"upstream_request_timeout,omitempty"`
	// Indicates local codec level reset was sent on the stream.
	LocalReset bool `protobuf:"varint,4,opt,name=local_reset,json=localReset,proto3" json:"local_reset,omitempty"`
	// Indicates remote codec level reset was received on the stream.
	UpstreamRemoteReset bool `protobuf:"varint,5,opt,name=upstream_remote_reset,json=upstreamRemoteReset,proto3" json:"upstream_remote_reset,omitempty"`
	// Indicates there was a local reset by a connection pool due to an initial connection failure.
	UpstreamConnectionFailure bool `protobuf:"varint,6,opt,name=upstream_connection_failure,json=upstreamConnectionFailure,proto3" json:"upstream_connection_failure,omitempty"`
	// Indicates the stream was reset due to an upstream connection termination.
	UpstreamConnectionTermination bool `protobuf:"varint,7,opt,name=upstream_connection_termination,json=upstreamConnectionTermination,proto3" json:"upstream_connection_termination,omitempty"`
	// Indicates the stream was reset because of a resource overflow.
	UpstreamOverflow bool `protobuf:"varint,8,opt,name=upstream_overflow,json=upstreamOverflow,proto3" json:"upstream_overflow,omitempty"`
	// Indicates no route was found for the request.
	NoRouteFound bool `protobuf:"varint,9,opt,name=no_route_found,json=noRouteFound,proto3" json:"no_route_found,omitempty"`
	// Indicates that the request was delayed before proxying.
	DelayInjected bool `protobuf:"varint,10,opt,name=delay_injected,json=delayInjected,proto3" json:"delay_injected,omitempty"`
	// Indicates that the request was aborted with an injected error code.
	FaultInjected bool `protobuf:"varint,11,opt,name=fault_injected,json=faultInjected,proto3" json:"fault_injected,omitempty"`
	// Indicates that the request was rate-limited locally.
	RateLimited bool `protobuf:"varint,12,opt,name=rate_limited,json=rateLimited,proto3" json:"rate_limited,omitempty"`
	// Indicates if the request was deemed unauthorized and the reason for it.
	UnauthorizedDetails *ResponseFlags_Unauthorized `protobuf:"bytes,13,opt,name=unauthorized_details,json=unauthorizedDetails,proto3" json:"unauthorized_details,omitempty"`
	// Indicates that the request was rejected because there was an error in rate limit service.
	RateLimitServiceError bool `protobuf:"varint,14,opt,name=rate_limit_service_error,json=rateLimitServiceError,proto3" json:"rate_limit_service_error,omitempty"`
	// Indicates the stream was reset due to a downstream connection termination.
	DownstreamConnectionTermination bool `protobuf:"varint,15,opt,name=downstream_connection_termination,json=downstreamConnectionTermination,proto3" json:"downstream_connection_termination,omitempty"`
	// Indicates that the upstream retry limit was exceeded, resulting in a downstream error.
	UpstreamRetryLimitExceeded bool `protobuf:"varint,16,opt,name=upstream_retry_limit_exceeded,json=upstreamRetryLimitExceeded,proto3" json:"upstream_retry_limit_exceeded,omitempty"`
	// Indicates that the stream idle timeout was hit, resulting in a downstream 408.
	StreamIdleTimeout    bool     `protobuf:"varint,17,opt,name=stream_idle_timeout,json=streamIdleTimeout,proto3" json:"stream_idle_timeout,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResponseFlags) Reset()         { *m = ResponseFlags{} }
func (m *ResponseFlags) String() string { return proto.CompactTextString(m) }
func (*ResponseFlags) ProtoMessage()    {}
func (*ResponseFlags) Descriptor() ([]byte, []int) {
	return fileDescriptor_ca1a3c8f3c17c754, []int{3}
}
func (m *ResponseFlags) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResponseFlags) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *ResponseFlags) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResponseFlags.Merge(m, src)
}
func (m *ResponseFlags) XXX_Size() int {
	return m.Size()
}
func (m *ResponseFlags) XXX_DiscardUnknown() {
	xxx_messageInfo_ResponseFlags.DiscardUnknown(m)
}

var xxx_messageInfo_ResponseFlags proto.InternalMessageInfo

func (m *ResponseFlags) GetFailedLocalHealthcheck() bool {
	if m != nil {
		return m.FailedLocalHealthcheck
	}
	return false
}

func (m *ResponseFlags) GetNoHealthyUpstream() bool {
	if m != nil {
		return m.NoHealthyUpstream
	}
	return false
}

func (m *ResponseFlags) GetUpstreamRequestTimeout() bool {
	if m != nil {
		return m.UpstreamRequestTimeout
	}
	return false
}

func (m *ResponseFlags) GetLocalReset() bool {
	if m != nil {
		return m.LocalReset
	}
	return false
}

func (m *ResponseFlags) GetUpstreamRemoteReset() bool {
	if m != nil {
		return m.UpstreamRemoteReset
	}
	return false
}

func (m *ResponseFlags) GetUpstreamConnectionFailure() bool {
	if m != nil {
		return m.UpstreamConnectionFailure
	}
	return false
}

func (m *ResponseFlags) GetUpstreamConnectionTermination() bool {
	if m != nil {
		return m.UpstreamConnectionTermination
	}
	return false
}

func (m *ResponseFlags) GetUpstreamOverflow() bool {
	if m != nil {
		return m.UpstreamOverflow
	}
	return false
}

func (m *ResponseFlags) GetNoRouteFound() bool {
	if m != nil {
		return m.NoRouteFound
	}
	return false
}

func (m *ResponseFlags) GetDelayInjected() bool {
	if m != nil {
		return m.DelayInjected
	}
	return false
}

func (m *ResponseFlags) GetFaultInjected() bool {
	if m != nil {
		return m.FaultInjected
	}
	return false
}

func (m *ResponseFlags) GetRateLimited() bool {
	if m != nil {
		return m.RateLimited
	}
	return false
}

func (m *ResponseFlags) GetUnauthorizedDetails() *ResponseFlags_Unauthorized {
	if m != nil {
		return m.UnauthorizedDetails
	}
	return nil
}

func (m *ResponseFlags) GetRateLimitServiceError() bool {
	if m != nil {
		return m.RateLimitServiceError
	}
	return false
}

func (m *ResponseFlags) GetDownstreamConnectionTermination() bool {
	if m != nil {
		return m.DownstreamConnectionTermination
	}
	return false
}

func (m *ResponseFlags) GetUpstreamRetryLimitExceeded() bool {
	if m != nil {
		return m.UpstreamRetryLimitExceeded
	}
	return false
}

func (m *ResponseFlags) GetStreamIdleTimeout() bool {
	if m != nil {
		return m.StreamIdleTimeout
	}
	return false
}

type ResponseFlags_Unauthorized struct {
	Reason               ResponseFlags_Unauthorized_Reason `protobuf:"varint,1,opt,name=reason,proto3,enum=envoy.data.accesslog.v2.ResponseFlags_Unauthorized_Reason" json:"reason,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *ResponseFlags_Unauthorized) Reset()         { *m = ResponseFlags_Unauthorized{} }
func (m *ResponseFlags_Unauthorized) String() string { return proto.CompactTextString(m) }
func (*ResponseFlags_Unauthorized) ProtoMessage()    {}
func (*ResponseFlags_Unauthorized) Descriptor() ([]byte, []int) {
	return fileDescriptor_ca1a3c8f3c17c754, []int{3, 0}
}
func (m *ResponseFlags_Unauthorized) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResponseFlags_Unauthorized) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *ResponseFlags_Unauthorized) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResponseFlags_Unauthorized.Merge(m, src)
}
func (m *ResponseFlags_Unauthorized) XXX_Size() int {
	return m.Size()
}
func (m *ResponseFlags_Unauthorized) XXX_DiscardUnknown() {
	xxx_messageInfo_ResponseFlags_Unauthorized.DiscardUnknown(m)
}

var xxx_messageInfo_ResponseFlags_Unauthorized proto.InternalMessageInfo

func (m *ResponseFlags_Unauthorized) GetReason() ResponseFlags_Unauthorized_Reason {
	if m != nil {
		return m.Reason
	}
	return ResponseFlags_Unauthorized_REASON_UNSPECIFIED
}

// [#not-implemented-hide:]
// Properties of a negotiated TLS connection.
type TLSProperties struct {
	// Version of TLS that was negotiated.
	TlsVersion TLSProperties_TLSVersion `protobuf:"varint,1,opt,name=tls_version,json=tlsVersion,proto3,enum=envoy.data.accesslog.v2.TLSProperties_TLSVersion" json:"tls_version,omitempty"`
	// TLS cipher suite negotiated during handshake. The value is a
	// four-digit hex code defined by the IANA TLS Cipher Suite Registry
	// (e.g. ``009C`` for ``TLS_RSA_WITH_AES_128_GCM_SHA256``).
	//
	// Here it is expressed as an integer.
	TlsCipherSuite *types.UInt32Value `protobuf:"bytes,2,opt,name=tls_cipher_suite,json=tlsCipherSuite,proto3" json:"tls_cipher_suite,omitempty"`
	// SNI hostname from handshake.
	TlsSniHostname       string   `protobuf:"bytes,3,opt,name=tls_sni_hostname,json=tlsSniHostname,proto3" json:"tls_sni_hostname,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TLSProperties) Reset()         { *m = TLSProperties{} }
func (m *TLSProperties) String() string { return proto.CompactTextString(m) }
func (*TLSProperties) ProtoMessage()    {}
func (*TLSProperties) Descriptor() ([]byte, []int) {
	return fileDescriptor_ca1a3c8f3c17c754, []int{4}
}
func (m *TLSProperties) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TLSProperties) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *TLSProperties) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TLSProperties.Merge(m, src)
}
func (m *TLSProperties) XXX_Size() int {
	return m.Size()
}
func (m *TLSProperties) XXX_DiscardUnknown() {
	xxx_messageInfo_TLSProperties.DiscardUnknown(m)
}

var xxx_messageInfo_TLSProperties proto.InternalMessageInfo

func (m *TLSProperties) GetTlsVersion() TLSProperties_TLSVersion {
	if m != nil {
		return m.TlsVersion
	}
	return TLSProperties_VERSION_UNSPECIFIED
}

func (m *TLSProperties) GetTlsCipherSuite() *types.UInt32Value {
	if m != nil {
		return m.TlsCipherSuite
	}
	return nil
}

func (m *TLSProperties) GetTlsSniHostname() string {
	if m != nil {
		return m.TlsSniHostname
	}
	return ""
}

type HTTPRequestProperties struct {
	// The request method (RFC 7231/2616).
	// [#comment:TODO(htuch): add (validate.rules).enum.defined_only = true once
	// https://github.com/lyft/protoc-gen-validate/issues/42 is resolved.]
	RequestMethod core.RequestMethod `protobuf:"varint,1,opt,name=request_method,json=requestMethod,proto3,enum=envoy.api.v2.core.RequestMethod" json:"request_method,omitempty"`
	// The scheme portion of the incoming request URI.
	Scheme string `protobuf:"bytes,2,opt,name=scheme,proto3" json:"scheme,omitempty"`
	// HTTP/2 ``:authority`` or HTTP/1.1 ``Host`` header value.
	Authority string `protobuf:"bytes,3,opt,name=authority,proto3" json:"authority,omitempty"`
	// The port of the incoming request URI
	// (unused currently, as port is composed onto authority).
	Port *types.UInt32Value `protobuf:"bytes,4,opt,name=port,proto3" json:"port,omitempty"`
	// The path portion from the incoming request URI.
	Path string `protobuf:"bytes,5,opt,name=path,proto3" json:"path,omitempty"`
	// Value of the ``User-Agent`` request header.
	UserAgent string `protobuf:"bytes,6,opt,name=user_agent,json=userAgent,proto3" json:"user_agent,omitempty"`
	// Value of the ``Referer`` request header.
	Referer string `protobuf:"bytes,7,opt,name=referer,proto3" json:"referer,omitempty"`
	// Value of the ``X-Forwarded-For`` request header.
	ForwardedFor string `protobuf:"bytes,8,opt,name=forwarded_for,json=forwardedFor,proto3" json:"forwarded_for,omitempty"`
	// Value of the ``X-Request-Id`` request header
	//
	// This header is used by Envoy to uniquely identify a request.
	// It will be generated for all external requests and internal requests that
	// do not already have a request ID.
	RequestId string `protobuf:"bytes,9,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Value of the ``X-Envoy-Original-Path`` request header.
	OriginalPath string `protobuf:"bytes,10,opt,name=original_path,json=originalPath,proto3" json:"original_path,omitempty"`
	// Size of the HTTP request headers in bytes.
	//
	// This value is captured from the OSI layer 7 perspective, i.e. it does not
	// include overhead from framing or encoding at other networking layers.
	RequestHeadersBytes uint64 `protobuf:"varint,11,opt,name=request_headers_bytes,json=requestHeadersBytes,proto3" json:"request_headers_bytes,omitempty"`
	// Size of the HTTP request body in bytes.
	//
	// This value is captured from the OSI layer 7 perspective, i.e. it does not
	// include overhead from framing or encoding at other networking layers.
	RequestBodyBytes uint64 `protobuf:"varint,12,opt,name=request_body_bytes,json=requestBodyBytes,proto3" json:"request_body_bytes,omitempty"`
	// Map of additional headers that have been configured to be logged.
	RequestHeaders       map[string]string `protobuf:"bytes,13,rep,name=request_headers,json=requestHeaders,proto3" json:"request_headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *HTTPRequestProperties) Reset()         { *m = HTTPRequestProperties{} }
func (m *HTTPRequestProperties) String() string { return proto.CompactTextString(m) }
func (*HTTPRequestProperties) ProtoMessage()    {}
func (*HTTPRequestProperties) Descriptor() ([]byte, []int) {
	return fileDescriptor_ca1a3c8f3c17c754, []int{5}
}
func (m *HTTPRequestProperties) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HTTPRequestProperties) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *HTTPRequestProperties) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPRequestProperties.Merge(m, src)
}
func (m *HTTPRequestProperties) XXX_Size() int {
	return m.Size()
}
func (m *HTTPRequestProperties) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPRequestProperties.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPRequestProperties proto.InternalMessageInfo

func (m *HTTPRequestProperties) GetRequestMethod() core.RequestMethod {
	if m != nil {
		return m.RequestMethod
	}
	return core.METHOD_UNSPECIFIED
}

func (m *HTTPRequestProperties) GetScheme() string {
	if m != nil {
		return m.Scheme
	}
	return ""
}

func (m *HTTPRequestProperties) GetAuthority() string {
	if m != nil {
		return m.Authority
	}
	return ""
}

func (m *HTTPRequestProperties) GetPort() *types.UInt32Value {
	if m != nil {
		return m.Port
	}
	return nil
}

func (m *HTTPRequestProperties) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *HTTPRequestProperties) GetUserAgent() string {
	if m != nil {
		return m.UserAgent
	}
	return ""
}

func (m *HTTPRequestProperties) GetReferer() string {
	if m != nil {
		return m.Referer
	}
	return ""
}

func (m *HTTPRequestProperties) GetForwardedFor() string {
	if m != nil {
		return m.ForwardedFor
	}
	return ""
}

func (m *HTTPRequestProperties) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *HTTPRequestProperties) GetOriginalPath() string {
	if m != nil {
		return m.OriginalPath
	}
	return ""
}

func (m *HTTPRequestProperties) GetRequestHeadersBytes() uint64 {
	if m != nil {
		return m.RequestHeadersBytes
	}
	return 0
}

func (m *HTTPRequestProperties) GetRequestBodyBytes() uint64 {
	if m != nil {
		return m.RequestBodyBytes
	}
	return 0
}

func (m *HTTPRequestProperties) GetRequestHeaders() map[string]string {
	if m != nil {
		return m.RequestHeaders
	}
	return nil
}

type HTTPResponseProperties struct {
	// The HTTP response code returned by Envoy.
	ResponseCode *types.UInt32Value `protobuf:"bytes,1,opt,name=response_code,json=responseCode,proto3" json:"response_code,omitempty"`
	// Size of the HTTP response headers in bytes.
	//
	// This value is captured from the OSI layer 7 perspective, i.e. it does not
	// include overhead from framing or encoding at other networking layers.
	ResponseHeadersBytes uint64 `protobuf:"varint,2,opt,name=response_headers_bytes,json=responseHeadersBytes,proto3" json:"response_headers_bytes,omitempty"`
	// Size of the HTTP response body in bytes.
	//
	// This value is captured from the OSI layer 7 perspective, i.e. it does not
	// include overhead from framing or encoding at other networking layers.
	ResponseBodyBytes uint64 `protobuf:"varint,3,opt,name=response_body_bytes,json=responseBodyBytes,proto3" json:"response_body_bytes,omitempty"`
	// Map of additional headers configured to be logged.
	ResponseHeaders map[string]string `protobuf:"bytes,4,rep,name=response_headers,json=responseHeaders,proto3" json:"response_headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Map of trailers configured to be logged.
	ResponseTrailers     map[string]string `protobuf:"bytes,5,rep,name=response_trailers,json=responseTrailers,proto3" json:"response_trailers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *HTTPResponseProperties) Reset()         { *m = HTTPResponseProperties{} }
func (m *HTTPResponseProperties) String() string { return proto.CompactTextString(m) }
func (*HTTPResponseProperties) ProtoMessage()    {}
func (*HTTPResponseProperties) Descriptor() ([]byte, []int) {
	return fileDescriptor_ca1a3c8f3c17c754, []int{6}
}
func (m *HTTPResponseProperties) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HTTPResponseProperties) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *HTTPResponseProperties) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPResponseProperties.Merge(m, src)
}
func (m *HTTPResponseProperties) XXX_Size() int {
	return m.Size()
}
func (m *HTTPResponseProperties) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPResponseProperties.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPResponseProperties proto.InternalMessageInfo

func (m *HTTPResponseProperties) GetResponseCode() *types.UInt32Value {
	if m != nil {
		return m.ResponseCode
	}
	return nil
}

func (m *HTTPResponseProperties) GetResponseHeadersBytes() uint64 {
	if m != nil {
		return m.ResponseHeadersBytes
	}
	return 0
}

func (m *HTTPResponseProperties) GetResponseBodyBytes() uint64 {
	if m != nil {
		return m.ResponseBodyBytes
	}
	return 0
}

func (m *HTTPResponseProperties) GetResponseHeaders() map[string]string {
	if m != nil {
		return m.ResponseHeaders
	}
	return nil
}

func (m *HTTPResponseProperties) GetResponseTrailers() map[string]string {
	if m != nil {
		return m.ResponseTrailers
	}
	return nil
}

func init() {
	proto.RegisterEnum("envoy.data.accesslog.v2.HTTPAccessLogEntry_HTTPVersion", HTTPAccessLogEntry_HTTPVersion_name, HTTPAccessLogEntry_HTTPVersion_value)
	proto.RegisterEnum("envoy.data.accesslog.v2.ResponseFlags_Unauthorized_Reason", ResponseFlags_Unauthorized_Reason_name, ResponseFlags_Unauthorized_Reason_value)
	proto.RegisterEnum("envoy.data.accesslog.v2.TLSProperties_TLSVersion", TLSProperties_TLSVersion_name, TLSProperties_TLSVersion_value)
	proto.RegisterType((*TCPAccessLogEntry)(nil), "envoy.data.accesslog.v2.TCPAccessLogEntry")
	proto.RegisterType((*HTTPAccessLogEntry)(nil), "envoy.data.accesslog.v2.HTTPAccessLogEntry")
	proto.RegisterType((*AccessLogCommon)(nil), "envoy.data.accesslog.v2.AccessLogCommon")
	proto.RegisterType((*ResponseFlags)(nil), "envoy.data.accesslog.v2.ResponseFlags")
	proto.RegisterType((*ResponseFlags_Unauthorized)(nil), "envoy.data.accesslog.v2.ResponseFlags.Unauthorized")
	proto.RegisterType((*TLSProperties)(nil), "envoy.data.accesslog.v2.TLSProperties")
	proto.RegisterType((*HTTPRequestProperties)(nil), "envoy.data.accesslog.v2.HTTPRequestProperties")
	proto.RegisterMapType((map[string]string)(nil), "envoy.data.accesslog.v2.HTTPRequestProperties.RequestHeadersEntry")
	proto.RegisterType((*HTTPResponseProperties)(nil), "envoy.data.accesslog.v2.HTTPResponseProperties")
	proto.RegisterMapType((map[string]string)(nil), "envoy.data.accesslog.v2.HTTPResponseProperties.ResponseHeadersEntry")
	proto.RegisterMapType((map[string]string)(nil), "envoy.data.accesslog.v2.HTTPResponseProperties.ResponseTrailersEntry")
}

func init() {
	proto.RegisterFile("envoy/data/accesslog/v2/accesslog.proto", fileDescriptor_ca1a3c8f3c17c754)
}

var fileDescriptor_ca1a3c8f3c17c754 = []byte{
	// 1847 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x57, 0x4d, 0x73, 0x23, 0x49,
	0xd1, 0x5e, 0x59, 0xb2, 0x47, 0x4a, 0xf9, 0xa3, 0x5d, 0x96, 0xed, 0xb6, 0x66, 0xc6, 0xf6, 0xe8,
	0x7d, 0x17, 0x4c, 0x40, 0x48, 0x3b, 0x1a, 0x82, 0xd9, 0xd8, 0x03, 0x1b, 0x92, 0x2c, 0x63, 0x2d,
	0x9e, 0xb1, 0xa3, 0x24, 0x1b, 0x6e, 0x4d, 0x59, 0x5d, 0x92, 0x7a, 0xa7, 0xd5, 0x25, 0xaa, 0x4b,
	0x9a, 0x11, 0xbf, 0x62, 0x8f, 0x04, 0x3f, 0x02, 0x22, 0x38, 0x72, 0xe2, 0xc8, 0x11, 0x6e, 0xdc,
	0x80, 0xb9, 0x71, 0xe3, 0x27, 0x10, 0xf5, 0xd1, 0xdd, 0x92, 0x2d, 0x8f, 0x3d, 0x73, 0x40, 0xa7,
	0xae, 0xcc, 0x27, 0x9f, 0xcc, 0xca, 0xca, 0xcc, 0x2a, 0xc1, 0xf7, 0x69, 0x30, 0x61, 0xd3, 0x8a,
	0x4b, 0x04, 0xa9, 0x90, 0x6e, 0x97, 0x86, 0xa1, 0xcf, 0xfa, 0x95, 0x49, 0x35, 0x59, 0x94, 0x47,
	0x9c, 0x09, 0x86, 0x76, 0x15, 0xb0, 0x2c, 0x81, 0xe5, 0x44, 0x37, 0xa9, 0x16, 0x0f, 0x34, 0x03,
	0x19, 0x79, 0xd2, 0xac, 0xcb, 0x38, 0xad, 0x10, 0xd7, 0xe5, 0x34, 0x0c, 0xb5, 0x65, 0xf1, 0xc9,
	0x6d, 0xc0, 0x35, 0x09, 0xa9, 0xd1, 0xee, 0xf7, 0x19, 0xeb, 0xfb, 0xb4, 0xa2, 0x56, 0xd7, 0xe3,
	0x5e, 0xc5, 0x1d, 0x73, 0x22, 0x3c, 0x16, 0x18, 0xfd, 0xc1, 0x4d, 0xbd, 0xf0, 0x86, 0x34, 0x14,
	0x64, 0x38, 0xba, 0x8b, 0xe0, 0x2d, 0x27, 0xa3, 0x11, 0xe5, 0x91, 0xfb, 0x42, 0x9f, 0xf5, 0x99,
	0xfa, 0xac, 0xc8, 0x2f, 0x23, 0xdd, 0x9d, 0x10, 0xdf, 0x73, 0x89, 0xa0, 0x95, 0xe8, 0x43, 0x2b,
	0x4a, 0xdf, 0xc2, 0x66, 0xa7, 0x71, 0x51, 0x53, 0x3b, 0x3c, 0x63, 0xfd, 0x66, 0x20, 0xf8, 0x14,
	0x5d, 0xc2, 0x66, 0x97, 0x0d, 0x87, 0x2c, 0x70, 0x46, 0x9c, 0x8d, 0x28, 0x17, 0x1e, 0x0d, 0xed,
	0xd4, 0x61, 0xea, 0x28, 0x5f, 0x3d, 0x2a, 0xdf, 0x91, 0x98, 0x72, 0xcc, 0xd1, 0x50, 0xa6, 0xd8,
	0xd2, 0x14, 0x17, 0x31, 0x43, 0xe9, 0x8f, 0x69, 0x40, 0xa7, 0x9d, 0xce, 0xff, 0xc6, 0x1b, 0xba,
	0x06, 0x4b, 0x6d, 0xb1, 0xcb, 0x7c, 0x67, 0x42, 0x79, 0xe8, 0xb1, 0xc0, 0x5e, 0x3a, 0x4c, 0x1d,
	0xad, 0x57, 0x5f, 0xde, 0xc9, 0x7a, 0x3b, 0x3a, 0x25, 0xba, 0xd2, 0xe6, 0x78, 0x23, 0x22, 0x34,
	0x02, 0x74, 0x0a, 0x8f, 0x38, 0xfd, 0xf5, 0x98, 0x86, 0xc2, 0x4e, 0xab, 0x80, 0xcb, 0x1f, 0xa4,
	0xc6, 0x1a, 0x9b, 0x04, 0x89, 0x23, 0x73, 0xf4, 0x73, 0xc8, 0x72, 0x1a, 0x8e, 0x58, 0x10, 0x52,
	0x3b, 0xa3, 0xa8, 0x2a, 0xf7, 0x50, 0x69, 0xf0, 0x0c, 0x57, 0x4c, 0x50, 0xfa, 0x06, 0xf2, 0x33,
	0x61, 0x23, 0x1b, 0x0a, 0x17, 0xf8, 0xbc, 0x73, 0xde, 0x38, 0x3f, 0x73, 0x2e, 0x5f, 0xb7, 0x2f,
	0x9a, 0x8d, 0xd6, 0x49, 0xab, 0x79, 0x6c, 0x7d, 0x86, 0x00, 0x56, 0x24, 0xf0, 0xf9, 0x17, 0x56,
	0x2a, 0xfe, 0x7e, 0x6e, 0x2d, 0xa1, 0x1c, 0x2c, 0xcb, 0xef, 0xaa, 0x95, 0x2e, 0xfd, 0x2b, 0x0f,
	0x1b, 0x37, 0x92, 0x8d, 0x6a, 0x90, 0x0f, 0xc9, 0x70, 0xe4, 0x53, 0x87, 0x13, 0x41, 0xd5, 0x59,
	0xa5, 0xea, 0x87, 0x7f, 0xfa, 0xf7, 0x9f, 0xd3, 0x79, 0x94, 0x7b, 0xf6, 0x99, 0xf9, 0x99, 0xf5,
	0x9e, 0x5e, 0xfd, 0xe7, 0x6b, 0x0c, 0xda, 0x08, 0x13, 0x41, 0xd1, 0x15, 0xec, 0xb9, 0xec, 0x6d,
	0x10, 0x0a, 0x4e, 0xc9, 0xd0, 0xe1, 0x74, 0xc8, 0x04, 0x75, 0x4c, 0x23, 0xa9, 0x63, 0xca, 0x57,
	0x8b, 0x26, 0x01, 0x64, 0xe4, 0xc9, 0x5d, 0xcb, 0x4e, 0x2a, 0xd7, 0x34, 0x02, 0xef, 0x26, 0xc6,
	0x58, 0xd9, 0x1a, 0x05, 0xea, 0x80, 0x3d, 0xc3, 0xeb, 0xb3, 0x2e, 0xf1, 0x63, 0xda, 0xf4, 0xbd,
	0xb4, 0x3b, 0x89, 0xed, 0x99, 0x34, 0x8d, 0x58, 0x5f, 0xc1, 0xba, 0xf0, 0xc3, 0xd9, 0xfa, 0xd4,
	0x67, 0xf4, 0xbd, 0x3b, 0xcf, 0xa8, 0x73, 0xd6, 0x9e, 0x39, 0x9a, 0x35, 0xe1, 0x87, 0x33, 0xa5,
	0xf9, 0x35, 0x40, 0x28, 0x08, 0x17, 0x8e, 0x6c, 0x6e, 0x7b, 0xd9, 0x84, 0xa5, 0x1b, 0xbb, 0x1c,
	0x35, 0x76, 0xb9, 0x13, 0x75, 0x7e, 0x3d, 0xf3, 0xdd, 0x3f, 0x0e, 0x52, 0x38, 0xa7, 0x6c, 0xa4,
	0x14, 0x9d, 0x43, 0x41, 0x9a, 0x3a, 0x82, 0x39, 0x3e, 0x09, 0x85, 0xc3, 0xdf, 0x39, 0xd7, 0x53,
	0x41, 0xed, 0x15, 0x45, 0xb5, 0x77, 0x8b, 0xea, 0xd8, 0x0c, 0x99, 0x7a, 0xe6, 0xb7, 0x92, 0xc9,
	0x92, 0xc6, 0x1d, 0x76, 0x46, 0x42, 0x81, 0xdf, 0xd5, 0xa7, 0x82, 0xa2, 0x6b, 0xd8, 0x8f, 0x08,
	0x7b, 0x1e, 0x0f, 0x85, 0x33, 0x1e, 0x99, 0x14, 0x0a, 0x43, 0xfd, 0xe8, 0x61, 0xd4, 0x7b, 0x9a,
	0xfa, 0x44, 0x92, 0x5c, 0x1a, 0x8e, 0x8e, 0xf6, 0xf1, 0x2b, 0x78, 0x3a, 0x17, 0xf4, 0x2d, 0x17,
	0xd9, 0x87, 0xb9, 0xb0, 0x93, 0xe8, 0x6f, 0x78, 0xb8, 0x7b, 0x17, 0x51, 0x82, 0x72, 0x9f, 0xbe,
	0x0b, 0x7c, 0xcf, 0x2e, 0x22, 0x17, 0xf0, 0xc9, 0xbb, 0x30, 0x1e, 0x7a, 0x70, 0x38, 0xbf, 0x8b,
	0x99, 0x82, 0x8e, 0x52, 0x95, 0x7f, 0x98, 0x93, 0xc7, 0x33, 0xfb, 0x38, 0x8e, 0x59, 0x4c, 0xb6,
	0x5c, 0x38, 0x98, 0xdb, 0xc9, 0x02, 0x37, 0xab, 0x0f, 0x73, 0x53, 0x4c, 0xf6, 0x72, 0xcb, 0x0b,
	0x86, 0xdd, 0x24, 0x45, 0xf3, 0x6d, 0xbe, 0x76, 0x6f, 0x3f, 0x6e, 0x47, 0xa6, 0xf3, 0x4d, 0x7e,
	0x01, 0x3b, 0x31, 0xe7, 0x7c, 0x8b, 0xaf, 0xdf, 0x4b, 0x59, 0x88, 0x2c, 0xe7, 0x1a, 0xfc, 0x07,
	0x60, 0xc5, 0x8c, 0x5d, 0x7f, 0x1c, 0x0a, 0xca, 0xed, 0x8d, 0xc3, 0xd4, 0x51, 0x0e, 0x6f, 0x44,
	0xf2, 0x86, 0x16, 0xcb, 0x59, 0x10, 0x0d, 0x5a, 0xa7, 0xe7, 0x93, 0x7e, 0x68, 0x5b, 0xf7, 0xcc,
	0x82, 0x68, 0x56, 0x9f, 0x48, 0x34, 0x5e, 0xe3, 0xb3, 0x4b, 0xf4, 0x12, 0xb2, 0x43, 0x2a, 0x88,
	0xb4, 0xb2, 0x37, 0x15, 0xd1, 0xe3, 0x05, 0xd1, 0xbf, 0x32, 0x10, 0x1c, 0x83, 0x51, 0x0b, 0x9e,
	0x25, 0x1d, 0xc4, 0x49, 0x10, 0x8e, 0x18, 0x17, 0x4e, 0x8f, 0x78, 0xfe, 0x98, 0x53, 0x87, 0x53,
	0x12, 0xb2, 0xc0, 0x46, 0x6a, 0x0f, 0xfb, 0x11, 0xb0, 0x13, 0xe1, 0x4e, 0x34, 0x0c, 0x2b, 0x54,
	0xe9, 0x6f, 0x59, 0x58, 0x9b, 0x0b, 0x12, 0x7d, 0x09, 0xb6, 0x64, 0xa2, 0xae, 0xc9, 0xef, 0x80,
	0x12, 0x5f, 0x0c, 0xba, 0x03, 0xda, 0x7d, 0xa3, 0xc6, 0x7d, 0x16, 0xef, 0x68, 0xbd, 0xca, 0xe2,
	0x69, 0xa2, 0x45, 0x65, 0xd8, 0x0a, 0x98, 0xc1, 0x4f, 0xe3, 0xee, 0x50, 0x23, 0x3d, 0x8b, 0x37,
	0x03, 0xa6, 0xb1, 0xd3, 0xa8, 0xe6, 0xa5, 0xa7, 0x99, 0xfa, 0x50, 0x97, 0xa1, 0x1a, 0x8b, 0x6c,
	0xac, 0xef, 0xd4, 0x2c, 0xde, 0x49, 0x8a, 0x40, 0xa9, 0x3b, 0x5a, 0x8b, 0x0e, 0x20, 0xaf, 0x83,
	0xe3, 0x34, 0xa4, 0x42, 0x4d, 0xe4, 0x2c, 0x06, 0x25, 0xc2, 0x52, 0x82, 0xaa, 0xb0, 0x7d, 0xb3,
	0xf4, 0x34, 0x74, 0x59, 0x41, 0xb7, 0xe6, 0x8b, 0x4b, 0xdb, 0xfc, 0x14, 0x1e, 0x27, 0x85, 0xc0,
	0x82, 0x80, 0x76, 0x65, 0x9d, 0x47, 0x69, 0x55, 0x03, 0x36, 0x8b, 0xf7, 0xe2, 0x9a, 0x88, 0x11,
	0x26, 0xa1, 0xe8, 0x04, 0x0e, 0x16, 0xd9, 0x0b, 0xca, 0x87, 0x5e, 0xa0, 0x7a, 0x46, 0x4d, 0xd2,
	0x2c, 0x7e, 0x7a, 0x9b, 0xa3, 0x93, 0x80, 0xd0, 0x0f, 0x61, 0x33, 0xe6, 0x61, 0x13, 0xca, 0x7b,
	0x3e, 0x7b, 0xab, 0x06, 0x64, 0x16, 0xc7, 0x95, 0x7a, 0x6e, 0xe4, 0xe8, 0xff, 0x61, 0x3d, 0x60,
	0x0e, 0x67, 0x63, 0x41, 0x9d, 0x1e, 0x1b, 0x07, 0xae, 0x9a, 0x73, 0x59, 0xbc, 0x1a, 0x30, 0x2c,
	0x85, 0x27, 0x52, 0x86, 0x3e, 0x87, 0x75, 0x97, 0xfa, 0x64, 0xea, 0x78, 0xc1, 0xb7, 0xb4, 0x2b,
	0xa8, 0xab, 0x46, 0x55, 0x16, 0xaf, 0x29, 0x69, 0xcb, 0x08, 0x25, 0xac, 0x47, 0xc6, 0xbe, 0x48,
	0x60, 0x79, 0x0d, 0x53, 0xd2, 0x18, 0xf6, 0x0c, 0x56, 0xe5, 0xe5, 0xef, 0xf8, 0xde, 0xd0, 0x93,
	0xa0, 0x55, 0x05, 0xca, 0x4b, 0xd9, 0x99, 0x16, 0xa1, 0x1e, 0x14, 0xc6, 0x01, 0x19, 0x8b, 0x01,
	0xe3, 0xde, 0x6f, 0xa8, 0xeb, 0xb8, 0x54, 0x10, 0xcf, 0x8f, 0xfa, 0xfe, 0xc5, 0xc3, 0xfa, 0xa5,
	0x7c, 0x39, 0x43, 0x81, 0xb7, 0x66, 0x09, 0x8f, 0x35, 0x1f, 0x7a, 0x09, 0x76, 0x12, 0x8a, 0x13,
	0x52, 0x3e, 0xf1, 0xba, 0xd4, 0xa1, 0x9c, 0x33, 0xae, 0x06, 0x42, 0x16, 0x6f, 0xc7, 0x61, 0xb5,
	0xb5, 0xb6, 0x29, 0x95, 0xe8, 0x1b, 0x78, 0x36, 0x33, 0xf4, 0xee, 0x38, 0xae, 0x0d, 0xc5, 0x70,
	0x90, 0x00, 0x17, 0x1f, 0x58, 0x0d, 0x9e, 0xce, 0x14, 0x9b, 0xe0, 0x53, 0x13, 0x0e, 0x7d, 0xd7,
	0xa5, 0xd4, 0xa5, 0xae, 0x9a, 0x12, 0x59, 0x5c, 0x4c, 0x8a, 0x4e, 0xf0, 0xa9, 0x0a, 0xa9, 0x69,
	0x10, 0xb2, 0x75, 0x0c, 0x81, 0xe7, 0xfa, 0x34, 0xee, 0x82, 0x4d, 0xdd, 0x3a, 0x5a, 0xd5, 0x72,
	0x7d, 0x6a, 0x1a, 0xa0, 0xf8, 0xbb, 0x14, 0xac, 0xce, 0x66, 0x07, 0x61, 0x58, 0x31, 0x7d, 0x9f,
	0x52, 0x0f, 0xdd, 0xaf, 0x3e, 0x21, 0xc5, 0x65, 0x3d, 0x13, 0xb0, 0x61, 0x2a, 0xfd, 0x04, 0x56,
	0xb4, 0x04, 0xed, 0x00, 0xc2, 0xcd, 0x5a, 0xfb, 0xfc, 0xf5, 0x8d, 0x47, 0x64, 0x01, 0xac, 0xe6,
	0x2f, 0x3b, 0x4d, 0xfc, 0xba, 0x76, 0xe6, 0xb4, 0x9b, 0xf8, 0xaa, 0xd5, 0x68, 0x5a, 0xa9, 0xd2,
	0xef, 0x97, 0x60, 0x6d, 0xee, 0x11, 0x84, 0x30, 0xe4, 0xe5, 0x23, 0x2a, 0x7a, 0x8b, 0xeb, 0x10,
	0x9f, 0x3f, 0xec, 0x05, 0x25, 0x57, 0xd1, 0x2b, 0x1c, 0x84, 0x1f, 0x46, 0x4f, 0xdb, 0x13, 0xb0,
	0x24, 0x67, 0xd7, 0x1b, 0x0d, 0x28, 0x77, 0xc2, 0xb1, 0x27, 0xa8, 0x79, 0x3d, 0x3e, 0xb9, 0x75,
	0x69, 0x5d, 0xb6, 0x02, 0xf1, 0xa2, 0x7a, 0x45, 0xfc, 0x31, 0xc5, 0xf2, 0x39, 0xd7, 0x50, 0x46,
	0x6d, 0x69, 0x83, 0x8e, 0x34, 0x4f, 0x18, 0x78, 0xce, 0x80, 0x85, 0x22, 0x20, 0x43, 0xaa, 0xa6,
	0x4f, 0x4e, 0x21, 0xdb, 0x81, 0x77, 0x6a, 0xa4, 0xa5, 0x5f, 0x00, 0x24, 0xb1, 0xa0, 0x5d, 0xd8,
	0xba, 0x6a, 0xe2, 0x76, 0xeb, 0x56, 0x52, 0x72, 0xb0, 0xdc, 0x39, 0x6b, 0x4f, 0x9e, 0x5b, 0x29,
	0x94, 0x87, 0x47, 0xea, 0xd3, 0x91, 0x2f, 0xeb, 0x78, 0x51, 0xb5, 0xd2, 0xc9, 0xe2, 0x85, 0x95,
	0x29, 0x7d, 0xb7, 0x0c, 0xdb, 0x0b, 0xff, 0x24, 0xa0, 0x9f, 0xc9, 0x1b, 0x47, 0x4f, 0xc6, 0x21,
	0x15, 0x03, 0xe6, 0x9a, 0xdc, 0x1d, 0x2e, 0xb8, 0x28, 0x8c, 0xf5, 0x2b, 0x85, 0x93, 0x77, 0xcd,
	0xcc, 0x12, 0xed, 0xc0, 0x4a, 0xd8, 0x1d, 0xd0, 0xa1, 0xce, 0x51, 0x0e, 0x9b, 0x15, 0x7a, 0x02,
	0x39, 0x53, 0x00, 0x62, 0x6a, 0xb6, 0x9d, 0x08, 0xd0, 0x17, 0x90, 0x91, 0x57, 0x86, 0x79, 0xf2,
	0x7e, 0x38, 0xaf, 0x0a, 0x89, 0x10, 0x64, 0x46, 0x44, 0x0c, 0xd4, 0x9c, 0xcd, 0x61, 0xf5, 0x8d,
	0x9e, 0x02, 0x8c, 0x43, 0xca, 0x1d, 0xd2, 0xa7, 0x81, 0x50, 0x73, 0x34, 0x87, 0x73, 0x52, 0x52,
	0x93, 0x02, 0x64, 0xcb, 0x7f, 0x52, 0x3d, 0xca, 0x29, 0x57, 0xf3, 0x31, 0x87, 0xa3, 0x25, 0xfa,
	0x3f, 0x58, 0xeb, 0x31, 0xfe, 0x96, 0x70, 0x97, 0xba, 0x4e, 0x8f, 0x71, 0x35, 0x05, 0x73, 0x78,
	0x35, 0x16, 0x9e, 0x30, 0x2e, 0xd9, 0xa3, 0x14, 0x79, 0x7a, 0xfa, 0xe5, 0x70, 0xce, 0x48, 0x5a,
	0xae, 0xe4, 0x60, 0xdc, 0xeb, 0x7b, 0x01, 0xf1, 0x1d, 0x15, 0x19, 0x68, 0x8e, 0x48, 0x78, 0x21,
	0x23, 0xac, 0xc2, 0x76, 0xc4, 0x31, 0xa0, 0xc4, 0xa5, 0x3c, 0x54, 0x8f, 0xa0, 0x50, 0xcd, 0xbf,
	0x0c, 0xde, 0x32, 0xca, 0x53, 0xad, 0x93, 0x8f, 0x9b, 0x10, 0xfd, 0x08, 0x50, 0x64, 0x73, 0xcd,
	0xdc, 0xa9, 0x31, 0x58, 0x55, 0x06, 0x96, 0xd1, 0xd4, 0x99, 0x3b, 0xd5, 0xe8, 0x37, 0xb0, 0x71,
	0xc3, 0x83, 0xbd, 0x76, 0x98, 0x3e, 0xca, 0x57, 0xeb, 0x1f, 0xf7, 0xb7, 0x31, 0x3a, 0x65, 0x13,
	0x8a, 0xfa, 0xa3, 0x8a, 0xd7, 0xe7, 0xe3, 0x2b, 0xd6, 0x60, 0x6b, 0x01, 0x0c, 0x59, 0x90, 0x7e,
	0x43, 0xa7, 0xaa, 0x82, 0x72, 0x58, 0x7e, 0xa2, 0x02, 0x2c, 0x4f, 0xe4, 0xe1, 0x99, 0xa2, 0xd0,
	0x8b, 0xaf, 0x96, 0xbe, 0x4c, 0x95, 0xfe, 0x90, 0x81, 0x9d, 0xc5, 0x7f, 0x36, 0x51, 0x0d, 0xe2,
	0x77, 0x8c, 0xd3, 0x65, 0x2e, 0x35, 0x7f, 0xd8, 0x3f, 0x5c, 0x1d, 0xab, 0x91, 0x49, 0x83, 0xb9,
	0x14, 0xfd, 0x18, 0x76, 0x62, 0x8a, 0xf9, 0x84, 0x2f, 0xa9, 0xfc, 0x15, 0x22, 0xed, 0x5c, 0xc6,
	0xcb, 0xb0, 0x15, 0x5b, 0xcd, 0xa4, 0x3c, 0xad, 0x4c, 0x36, 0x23, 0x55, 0x92, 0x73, 0x06, 0xd6,
	0x4d, 0x2f, 0x76, 0x46, 0x25, 0xfd, 0xf8, 0x23, 0xff, 0x60, 0xc7, 0x43, 0x73, 0x2e, 0xed, 0x1b,
	0x37, 0xa2, 0x44, 0x1c, 0xe2, 0x28, 0xe4, 0xbb, 0xcc, 0xf3, 0xa5, 0xc7, 0x65, 0xe5, 0xb1, 0xf9,
	0xa9, 0x1e, 0x3b, 0x86, 0x47, 0xbb, 0x8c, 0x37, 0x14, 0x89, 0x8b, 0x75, 0x28, 0x2c, 0x0a, 0xee,
	0x63, 0x0e, 0xbb, 0xd8, 0x80, 0xed, 0x85, 0xee, 0x3e, 0x86, 0xa4, 0xde, 0xfa, 0xcb, 0xfb, 0xfd,
	0xd4, 0x5f, 0xdf, 0xef, 0xa7, 0xfe, 0xfe, 0x7e, 0x3f, 0xf5, 0xcf, 0xf7, 0xfb, 0x29, 0xf8, 0xdc,
	0x63, 0x7a, 0xd7, 0x23, 0xce, 0xde, 0x4d, 0xef, 0x4a, 0x40, 0x7d, 0xbd, 0x16, 0xad, 0x2e, 0x64,
	0xe5, 0x5c, 0xa4, 0xae, 0x57, 0x54, 0x09, 0xbd, 0xf8, 0x6f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x7a,
	0x65, 0x0c, 0x54, 0xb3, 0x13, 0x00, 0x00,
}

func (m *TCPAccessLogEntry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TCPAccessLogEntry) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.CommonProperties != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.CommonProperties.Size()))
		n1, err := m.CommonProperties.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HTTPAccessLogEntry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HTTPAccessLogEntry) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.CommonProperties != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.CommonProperties.Size()))
		n2, err := m.CommonProperties.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.ProtocolVersion != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.ProtocolVersion))
	}
	if m.Request != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.Request.Size()))
		n3, err := m.Request.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.Response != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.Response.Size()))
		n4, err := m.Response.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *AccessLogCommon) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AccessLogCommon) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.SampleRate != 0 {
		dAtA[i] = 0x9
		i++
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.SampleRate))))
		i += 8
	}
	if m.DownstreamRemoteAddress != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.DownstreamRemoteAddress.Size()))
		n5, err := m.DownstreamRemoteAddress.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.DownstreamLocalAddress != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.DownstreamLocalAddress.Size()))
		n6, err := m.DownstreamLocalAddress.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.TlsProperties != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.TlsProperties.Size()))
		n7, err := m.TlsProperties.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.StartTime != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdTime(*m.StartTime)))
		n8, err := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.StartTime, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.TimeToLastRxByte != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.TimeToLastRxByte)))
		n9, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.TimeToLastRxByte, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.TimeToFirstUpstreamTxByte != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.TimeToFirstUpstreamTxByte)))
		n10, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.TimeToFirstUpstreamTxByte, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.TimeToLastUpstreamTxByte != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.TimeToLastUpstreamTxByte)))
		n11, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.TimeToLastUpstreamTxByte, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if m.TimeToFirstUpstreamRxByte != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.TimeToFirstUpstreamRxByte)))
		n12, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.TimeToFirstUpstreamRxByte, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if m.TimeToLastUpstreamRxByte != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.TimeToLastUpstreamRxByte)))
		n13, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.TimeToLastUpstreamRxByte, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if m.TimeToFirstDownstreamTxByte != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.TimeToFirstDownstreamTxByte)))
		n14, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.TimeToFirstDownstreamTxByte, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if m.TimeToLastDownstreamTxByte != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.TimeToLastDownstreamTxByte)))
		n15, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.TimeToLastDownstreamTxByte, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	if m.UpstreamRemoteAddress != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.UpstreamRemoteAddress.Size()))
		n16, err := m.UpstreamRemoteAddress.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	if m.UpstreamLocalAddress != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.UpstreamLocalAddress.Size()))
		n17, err := m.UpstreamLocalAddress.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	if len(m.UpstreamCluster) > 0 {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(len(m.UpstreamCluster)))
		i += copy(dAtA[i:], m.UpstreamCluster)
	}
	if m.ResponseFlags != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.ResponseFlags.Size()))
		n18, err := m.ResponseFlags.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	if m.Metadata != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.Metadata.Size()))
		n19, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	if len(m.UpstreamTransportFailureReason) > 0 {
		dAtA[i] = 0x92
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(len(m.UpstreamTransportFailureReason)))
		i += copy(dAtA[i:], m.UpstreamTransportFailureReason)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ResponseFlags) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResponseFlags) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.FailedLocalHealthcheck {
		dAtA[i] = 0x8
		i++
		if m.FailedLocalHealthcheck {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.NoHealthyUpstream {
		dAtA[i] = 0x10
		i++
		if m.NoHealthyUpstream {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.UpstreamRequestTimeout {
		dAtA[i] = 0x18
		i++
		if m.UpstreamRequestTimeout {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.LocalReset {
		dAtA[i] = 0x20
		i++
		if m.LocalReset {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.UpstreamRemoteReset {
		dAtA[i] = 0x28
		i++
		if m.UpstreamRemoteReset {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.UpstreamConnectionFailure {
		dAtA[i] = 0x30
		i++
		if m.UpstreamConnectionFailure {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.UpstreamConnectionTermination {
		dAtA[i] = 0x38
		i++
		if m.UpstreamConnectionTermination {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.UpstreamOverflow {
		dAtA[i] = 0x40
		i++
		if m.UpstreamOverflow {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.NoRouteFound {
		dAtA[i] = 0x48
		i++
		if m.NoRouteFound {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.DelayInjected {
		dAtA[i] = 0x50
		i++
		if m.DelayInjected {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.FaultInjected {
		dAtA[i] = 0x58
		i++
		if m.FaultInjected {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.RateLimited {
		dAtA[i] = 0x60
		i++
		if m.RateLimited {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.UnauthorizedDetails != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.UnauthorizedDetails.Size()))
		n20, err := m.UnauthorizedDetails.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n20
	}
	if m.RateLimitServiceError {
		dAtA[i] = 0x70
		i++
		if m.RateLimitServiceError {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.DownstreamConnectionTermination {
		dAtA[i] = 0x78
		i++
		if m.DownstreamConnectionTermination {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.UpstreamRetryLimitExceeded {
		dAtA[i] = 0x80
		i++
		dAtA[i] = 0x1
		i++
		if m.UpstreamRetryLimitExceeded {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.StreamIdleTimeout {
		dAtA[i] = 0x88
		i++
		dAtA[i] = 0x1
		i++
		if m.StreamIdleTimeout {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ResponseFlags_Unauthorized) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResponseFlags_Unauthorized) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Reason != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.Reason))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TLSProperties) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TLSProperties) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.TlsVersion != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.TlsVersion))
	}
	if m.TlsCipherSuite != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.TlsCipherSuite.Size()))
		n21, err := m.TlsCipherSuite.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	if len(m.TlsSniHostname) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(len(m.TlsSniHostname)))
		i += copy(dAtA[i:], m.TlsSniHostname)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HTTPRequestProperties) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HTTPRequestProperties) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RequestMethod != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.RequestMethod))
	}
	if len(m.Scheme) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(len(m.Scheme)))
		i += copy(dAtA[i:], m.Scheme)
	}
	if len(m.Authority) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(len(m.Authority)))
		i += copy(dAtA[i:], m.Authority)
	}
	if m.Port != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.Port.Size()))
		n22, err := m.Port.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n22
	}
	if len(m.Path) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(len(m.Path)))
		i += copy(dAtA[i:], m.Path)
	}
	if len(m.UserAgent) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(len(m.UserAgent)))
		i += copy(dAtA[i:], m.UserAgent)
	}
	if len(m.Referer) > 0 {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(len(m.Referer)))
		i += copy(dAtA[i:], m.Referer)
	}
	if len(m.ForwardedFor) > 0 {
		dAtA[i] = 0x42
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(len(m.ForwardedFor)))
		i += copy(dAtA[i:], m.ForwardedFor)
	}
	if len(m.RequestId) > 0 {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(len(m.RequestId)))
		i += copy(dAtA[i:], m.RequestId)
	}
	if len(m.OriginalPath) > 0 {
		dAtA[i] = 0x52
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(len(m.OriginalPath)))
		i += copy(dAtA[i:], m.OriginalPath)
	}
	if m.RequestHeadersBytes != 0 {
		dAtA[i] = 0x58
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.RequestHeadersBytes))
	}
	if m.RequestBodyBytes != 0 {
		dAtA[i] = 0x60
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.RequestBodyBytes))
	}
	if len(m.RequestHeaders) > 0 {
		keysForRequestHeaders := make([]string, 0, len(m.RequestHeaders))
		for k, _ := range m.RequestHeaders {
			keysForRequestHeaders = append(keysForRequestHeaders, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForRequestHeaders)
		for _, k := range keysForRequestHeaders {
			dAtA[i] = 0x6a
			i++
			v := m.RequestHeaders[string(k)]
			mapSize := 1 + len(k) + sovAccesslog(uint64(len(k))) + 1 + len(v) + sovAccesslog(uint64(len(v)))
			i = encodeVarintAccesslog(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintAccesslog(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintAccesslog(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HTTPResponseProperties) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HTTPResponseProperties) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ResponseCode != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.ResponseCode.Size()))
		n23, err := m.ResponseCode.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n23
	}
	if m.ResponseHeadersBytes != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.ResponseHeadersBytes))
	}
	if m.ResponseBodyBytes != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintAccesslog(dAtA, i, uint64(m.ResponseBodyBytes))
	}
	if len(m.ResponseHeaders) > 0 {
		keysForResponseHeaders := make([]string, 0, len(m.ResponseHeaders))
		for k, _ := range m.ResponseHeaders {
			keysForResponseHeaders = append(keysForResponseHeaders, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForResponseHeaders)
		for _, k := range keysForResponseHeaders {
			dAtA[i] = 0x22
			i++
			v := m.ResponseHeaders[string(k)]
			mapSize := 1 + len(k) + sovAccesslog(uint64(len(k))) + 1 + len(v) + sovAccesslog(uint64(len(v)))
			i = encodeVarintAccesslog(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintAccesslog(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintAccesslog(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if len(m.ResponseTrailers) > 0 {
		keysForResponseTrailers := make([]string, 0, len(m.ResponseTrailers))
		for k, _ := range m.ResponseTrailers {
			keysForResponseTrailers = append(keysForResponseTrailers, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForResponseTrailers)
		for _, k := range keysForResponseTrailers {
			dAtA[i] = 0x2a
			i++
			v := m.ResponseTrailers[string(k)]
			mapSize := 1 + len(k) + sovAccesslog(uint64(len(k))) + 1 + len(v) + sovAccesslog(uint64(len(v)))
			i = encodeVarintAccesslog(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintAccesslog(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintAccesslog(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintAccesslog(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *TCPAccessLogEntry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CommonProperties != nil {
		l = m.CommonProperties.Size()
		n += 1 + l + sovAccesslog(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HTTPAccessLogEntry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CommonProperties != nil {
		l = m.CommonProperties.Size()
		n += 1 + l + sovAccesslog(uint64(l))
	}
	if m.ProtocolVersion != 0 {
		n += 1 + sovAccesslog(uint64(m.ProtocolVersion))
	}
	if m.Request != nil {
		l = m.Request.Size()
		n += 1 + l + sovAccesslog(uint64(l))
	}
	if m.Response != nil {
		l = m.Response.Size()
		n += 1 + l + sovAccesslog(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AccessLogCommon) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.SampleRate != 0 {
		n += 9
	}
	if m.DownstreamRemoteAddress != nil {
		l = m.DownstreamRemoteAddress.Size()
		n += 1 + l + sovAccesslog(uint64(l))
	}
	if m.DownstreamLocalAddress != nil {
		l = m.DownstreamLocalAddress.Size()
		n += 1 + l + sovAccesslog(uint64(l))
	}
	if m.TlsProperties != nil {
		l = m.TlsProperties.Size()
		n += 1 + l + sovAccesslog(uint64(l))
	}
	if m.StartTime != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.StartTime)
		n += 1 + l + sovAccesslog(uint64(l))
	}
	if m.TimeToLastRxByte != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.TimeToLastRxByte)
		n += 1 + l + sovAccesslog(uint64(l))
	}
	if m.TimeToFirstUpstreamTxByte != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.TimeToFirstUpstreamTxByte)
		n += 1 + l + sovAccesslog(uint64(l))
	}
	if m.TimeToLastUpstreamTxByte != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.TimeToLastUpstreamTxByte)
		n += 1 + l + sovAccesslog(uint64(l))
	}
	if m.TimeToFirstUpstreamRxByte != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.TimeToFirstUpstreamRxByte)
		n += 1 + l + sovAccesslog(uint64(l))
	}
	if m.TimeToLastUpstreamRxByte != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.TimeToLastUpstreamRxByte)
		n += 1 + l + sovAccesslog(uint64(l))
	}
	if m.TimeToFirstDownstreamTxByte != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.TimeToFirstDownstreamTxByte)
		n += 1 + l + sovAccesslog(uint64(l))
	}
	if m.TimeToLastDownstreamTxByte != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.TimeToLastDownstreamTxByte)
		n += 1 + l + sovAccesslog(uint64(l))
	}
	if m.UpstreamRemoteAddress != nil {
		l = m.UpstreamRemoteAddress.Size()
		n += 1 + l + sovAccesslog(uint64(l))
	}
	if m.UpstreamLocalAddress != nil {
		l = m.UpstreamLocalAddress.Size()
		n += 1 + l + sovAccesslog(uint64(l))
	}
	l = len(m.UpstreamCluster)
	if l > 0 {
		n += 1 + l + sovAccesslog(uint64(l))
	}
	if m.ResponseFlags != nil {
		l = m.ResponseFlags.Size()
		n += 2 + l + sovAccesslog(uint64(l))
	}
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 2 + l + sovAccesslog(uint64(l))
	}
	l = len(m.UpstreamTransportFailureReason)
	if l > 0 {
		n += 2 + l + sovAccesslog(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ResponseFlags) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.FailedLocalHealthcheck {
		n += 2
	}
	if m.NoHealthyUpstream {
		n += 2
	}
	if m.UpstreamRequestTimeout {
		n += 2
	}
	if m.LocalReset {
		n += 2
	}
	if m.UpstreamRemoteReset {
		n += 2
	}
	if m.UpstreamConnectionFailure {
		n += 2
	}
	if m.UpstreamConnectionTermination {
		n += 2
	}
	if m.UpstreamOverflow {
		n += 2
	}
	if m.NoRouteFound {
		n += 2
	}
	if m.DelayInjected {
		n += 2
	}
	if m.FaultInjected {
		n += 2
	}
	if m.RateLimited {
		n += 2
	}
	if m.UnauthorizedDetails != nil {
		l = m.UnauthorizedDetails.Size()
		n += 1 + l + sovAccesslog(uint64(l))
	}
	if m.RateLimitServiceError {
		n += 2
	}
	if m.DownstreamConnectionTermination {
		n += 2
	}
	if m.UpstreamRetryLimitExceeded {
		n += 3
	}
	if m.StreamIdleTimeout {
		n += 3
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ResponseFlags_Unauthorized) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Reason != 0 {
		n += 1 + sovAccesslog(uint64(m.Reason))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TLSProperties) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TlsVersion != 0 {
		n += 1 + sovAccesslog(uint64(m.TlsVersion))
	}
	if m.TlsCipherSuite != nil {
		l = m.TlsCipherSuite.Size()
		n += 1 + l + sovAccesslog(uint64(l))
	}
	l = len(m.TlsSniHostname)
	if l > 0 {
		n += 1 + l + sovAccesslog(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HTTPRequestProperties) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RequestMethod != 0 {
		n += 1 + sovAccesslog(uint64(m.RequestMethod))
	}
	l = len(m.Scheme)
	if l > 0 {
		n += 1 + l + sovAccesslog(uint64(l))
	}
	l = len(m.Authority)
	if l > 0 {
		n += 1 + l + sovAccesslog(uint64(l))
	}
	if m.Port != nil {
		l = m.Port.Size()
		n += 1 + l + sovAccesslog(uint64(l))
	}
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovAccesslog(uint64(l))
	}
	l = len(m.UserAgent)
	if l > 0 {
		n += 1 + l + sovAccesslog(uint64(l))
	}
	l = len(m.Referer)
	if l > 0 {
		n += 1 + l + sovAccesslog(uint64(l))
	}
	l = len(m.ForwardedFor)
	if l > 0 {
		n += 1 + l + sovAccesslog(uint64(l))
	}
	l = len(m.RequestId)
	if l > 0 {
		n += 1 + l + sovAccesslog(uint64(l))
	}
	l = len(m.OriginalPath)
	if l > 0 {
		n += 1 + l + sovAccesslog(uint64(l))
	}
	if m.RequestHeadersBytes != 0 {
		n += 1 + sovAccesslog(uint64(m.RequestHeadersBytes))
	}
	if m.RequestBodyBytes != 0 {
		n += 1 + sovAccesslog(uint64(m.RequestBodyBytes))
	}
	if len(m.RequestHeaders) > 0 {
		for k, v := range m.RequestHeaders {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovAccesslog(uint64(len(k))) + 1 + len(v) + sovAccesslog(uint64(len(v)))
			n += mapEntrySize + 1 + sovAccesslog(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HTTPResponseProperties) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ResponseCode != nil {
		l = m.ResponseCode.Size()
		n += 1 + l + sovAccesslog(uint64(l))
	}
	if m.ResponseHeadersBytes != 0 {
		n += 1 + sovAccesslog(uint64(m.ResponseHeadersBytes))
	}
	if m.ResponseBodyBytes != 0 {
		n += 1 + sovAccesslog(uint64(m.ResponseBodyBytes))
	}
	if len(m.ResponseHeaders) > 0 {
		for k, v := range m.ResponseHeaders {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovAccesslog(uint64(len(k))) + 1 + len(v) + sovAccesslog(uint64(len(v)))
			n += mapEntrySize + 1 + sovAccesslog(uint64(mapEntrySize))
		}
	}
	if len(m.ResponseTrailers) > 0 {
		for k, v := range m.ResponseTrailers {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovAccesslog(uint64(len(k))) + 1 + len(v) + sovAccesslog(uint64(len(v)))
			n += mapEntrySize + 1 + sovAccesslog(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovAccesslog(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozAccesslog(x uint64) (n int) {
	return sovAccesslog(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *TCPAccessLogEntry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAccesslog
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TCPAccessLogEntry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TCPAccessLogEntry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommonProperties", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CommonProperties == nil {
				m.CommonProperties = &AccessLogCommon{}
			}
			if err := m.CommonProperties.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAccesslog(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAccesslog
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAccesslog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HTTPAccessLogEntry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAccesslog
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HTTPAccessLogEntry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HTTPAccessLogEntry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommonProperties", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CommonProperties == nil {
				m.CommonProperties = &AccessLogCommon{}
			}
			if err := m.CommonProperties.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProtocolVersion", wireType)
			}
			m.ProtocolVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ProtocolVersion |= HTTPAccessLogEntry_HTTPVersion(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Request", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Request == nil {
				m.Request = &HTTPRequestProperties{}
			}
			if err := m.Request.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Response", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Response == nil {
				m.Response = &HTTPResponseProperties{}
			}
			if err := m.Response.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAccesslog(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAccesslog
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAccesslog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AccessLogCommon) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAccesslog
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AccessLogCommon: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AccessLogCommon: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field SampleRate", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.SampleRate = float64(math.Float64frombits(v))
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DownstreamRemoteAddress", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DownstreamRemoteAddress == nil {
				m.DownstreamRemoteAddress = &core.Address{}
			}
			if err := m.DownstreamRemoteAddress.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DownstreamLocalAddress", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DownstreamLocalAddress == nil {
				m.DownstreamLocalAddress = &core.Address{}
			}
			if err := m.DownstreamLocalAddress.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsProperties", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TlsProperties == nil {
				m.TlsProperties = &TLSProperties{}
			}
			if err := m.TlsProperties.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartTime == nil {
				m.StartTime = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.StartTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeToLastRxByte", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TimeToLastRxByte == nil {
				m.TimeToLastRxByte = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.TimeToLastRxByte, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeToFirstUpstreamTxByte", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TimeToFirstUpstreamTxByte == nil {
				m.TimeToFirstUpstreamTxByte = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.TimeToFirstUpstreamTxByte, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeToLastUpstreamTxByte", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TimeToLastUpstreamTxByte == nil {
				m.TimeToLastUpstreamTxByte = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.TimeToLastUpstreamTxByte, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeToFirstUpstreamRxByte", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TimeToFirstUpstreamRxByte == nil {
				m.TimeToFirstUpstreamRxByte = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.TimeToFirstUpstreamRxByte, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeToLastUpstreamRxByte", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TimeToLastUpstreamRxByte == nil {
				m.TimeToLastUpstreamRxByte = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.TimeToLastUpstreamRxByte, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeToFirstDownstreamTxByte", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TimeToFirstDownstreamTxByte == nil {
				m.TimeToFirstDownstreamTxByte = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.TimeToFirstDownstreamTxByte, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeToLastDownstreamTxByte", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TimeToLastDownstreamTxByte == nil {
				m.TimeToLastDownstreamTxByte = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.TimeToLastDownstreamTxByte, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpstreamRemoteAddress", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UpstreamRemoteAddress == nil {
				m.UpstreamRemoteAddress = &core.Address{}
			}
			if err := m.UpstreamRemoteAddress.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpstreamLocalAddress", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UpstreamLocalAddress == nil {
				m.UpstreamLocalAddress = &core.Address{}
			}
			if err := m.UpstreamLocalAddress.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpstreamCluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UpstreamCluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseFlags", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResponseFlags == nil {
				m.ResponseFlags = &ResponseFlags{}
			}
			if err := m.ResponseFlags.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &core.Metadata{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpstreamTransportFailureReason", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UpstreamTransportFailureReason = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAccesslog(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAccesslog
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAccesslog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResponseFlags) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAccesslog
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResponseFlags: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResponseFlags: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailedLocalHealthcheck", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.FailedLocalHealthcheck = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NoHealthyUpstream", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NoHealthyUpstream = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpstreamRequestTimeout", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UpstreamRequestTimeout = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalReset", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LocalReset = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpstreamRemoteReset", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UpstreamRemoteReset = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpstreamConnectionFailure", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UpstreamConnectionFailure = bool(v != 0)
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpstreamConnectionTermination", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UpstreamConnectionTermination = bool(v != 0)
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpstreamOverflow", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UpstreamOverflow = bool(v != 0)
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NoRouteFound", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NoRouteFound = bool(v != 0)
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DelayInjected", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DelayInjected = bool(v != 0)
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FaultInjected", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.FaultInjected = bool(v != 0)
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RateLimited", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RateLimited = bool(v != 0)
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UnauthorizedDetails", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UnauthorizedDetails == nil {
				m.UnauthorizedDetails = &ResponseFlags_Unauthorized{}
			}
			if err := m.UnauthorizedDetails.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RateLimitServiceError", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RateLimitServiceError = bool(v != 0)
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DownstreamConnectionTermination", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DownstreamConnectionTermination = bool(v != 0)
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpstreamRetryLimitExceeded", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UpstreamRetryLimitExceeded = bool(v != 0)
		case 17:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StreamIdleTimeout", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.StreamIdleTimeout = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipAccesslog(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAccesslog
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAccesslog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResponseFlags_Unauthorized) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAccesslog
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Unauthorized: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Unauthorized: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reason", wireType)
			}
			m.Reason = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Reason |= ResponseFlags_Unauthorized_Reason(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAccesslog(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAccesslog
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAccesslog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TLSProperties) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAccesslog
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TLSProperties: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TLSProperties: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsVersion", wireType)
			}
			m.TlsVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TlsVersion |= TLSProperties_TLSVersion(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsCipherSuite", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TlsCipherSuite == nil {
				m.TlsCipherSuite = &types.UInt32Value{}
			}
			if err := m.TlsCipherSuite.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsSniHostname", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TlsSniHostname = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAccesslog(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAccesslog
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAccesslog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HTTPRequestProperties) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAccesslog
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HTTPRequestProperties: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HTTPRequestProperties: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestMethod", wireType)
			}
			m.RequestMethod = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RequestMethod |= core.RequestMethod(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scheme", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Scheme = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Authority", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Authority = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Port == nil {
				m.Port = &types.UInt32Value{}
			}
			if err := m.Port.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserAgent", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UserAgent = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Referer", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Referer = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForwardedFor", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ForwardedFor = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OriginalPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OriginalPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeadersBytes", wireType)
			}
			m.RequestHeadersBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RequestHeadersBytes |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestBodyBytes", wireType)
			}
			m.RequestBodyBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RequestBodyBytes |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeaders", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RequestHeaders == nil {
				m.RequestHeaders = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAccesslog
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAccesslog
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthAccesslog
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthAccesslog
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAccesslog
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthAccesslog
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthAccesslog
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAccesslog(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAccesslog
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.RequestHeaders[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAccesslog(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAccesslog
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAccesslog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HTTPResponseProperties) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAccesslog
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HTTPResponseProperties: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HTTPResponseProperties: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseCode", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResponseCode == nil {
				m.ResponseCode = &types.UInt32Value{}
			}
			if err := m.ResponseCode.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeadersBytes", wireType)
			}
			m.ResponseHeadersBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ResponseHeadersBytes |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseBodyBytes", wireType)
			}
			m.ResponseBodyBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ResponseBodyBytes |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeaders", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResponseHeaders == nil {
				m.ResponseHeaders = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAccesslog
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAccesslog
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthAccesslog
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthAccesslog
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAccesslog
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthAccesslog
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthAccesslog
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAccesslog(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAccesslog
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ResponseHeaders[mapkey] = mapvalue
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseTrailers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAccesslog
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAccesslog
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResponseTrailers == nil {
				m.ResponseTrailers = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAccesslog
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAccesslog
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthAccesslog
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthAccesslog
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAccesslog
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthAccesslog
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthAccesslog
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAccesslog(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAccesslog
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ResponseTrailers[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAccesslog(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAccesslog
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAccesslog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipAccesslog(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowAccesslog
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAccesslog
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthAccesslog
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthAccesslog
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowAccesslog
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipAccesslog(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthAccesslog
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthAccesslog = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowAccesslog   = fmt.Errorf("proto: integer overflow")
)
