// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/config/filter/network/http_connection_manager/v2/http_connection_manager.proto

package v2

import (
	fmt "fmt"
	io "io"
	math "math"
	time "time"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	types "github.com/gogo/protobuf/types"
	_ "github.com/lyft/protoc-gen-validate/validate"

	v2 "github.com/envoyproxy/go-control-plane/envoy/api/v2"
	core "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
	v21 "github.com/envoyproxy/go-control-plane/envoy/config/filter/accesslog/v2"
	_type "github.com/envoyproxy/go-control-plane/envoy/type"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type HttpConnectionManager_CodecType int32

const (
	// For every new connection, the connection manager will determine which
	// codec to use. This mode supports both ALPN for TLS listeners as well as
	// protocol inference for plaintext listeners. If ALPN data is available, it
	// is preferred, otherwise protocol inference is used. In almost all cases,
	// this is the right option to choose for this setting.
	AUTO HttpConnectionManager_CodecType = 0
	// The connection manager will assume that the client is speaking HTTP/1.1.
	HTTP1 HttpConnectionManager_CodecType = 1
	// The connection manager will assume that the client is speaking HTTP/2
	// (Envoy does not require HTTP/2 to take place over TLS or to use ALPN.
	// Prior knowledge is allowed).
	HTTP2 HttpConnectionManager_CodecType = 2
)

var HttpConnectionManager_CodecType_name = map[int32]string{
	0: "AUTO",
	1: "HTTP1",
	2: "HTTP2",
}

var HttpConnectionManager_CodecType_value = map[string]int32{
	"AUTO":  0,
	"HTTP1": 1,
	"HTTP2": 2,
}

func (x HttpConnectionManager_CodecType) String() string {
	return proto.EnumName(HttpConnectionManager_CodecType_name, int32(x))
}

func (HttpConnectionManager_CodecType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8fe65268985a88f7, []int{0, 0}
}

// How to handle the :ref:`config_http_conn_man_headers_x-forwarded-client-cert` (XFCC) HTTP
// header.
type HttpConnectionManager_ForwardClientCertDetails int32

const (
	// Do not send the XFCC header to the next hop. This is the default value.
	SANITIZE HttpConnectionManager_ForwardClientCertDetails = 0
	// When the client connection is mTLS (Mutual TLS), forward the XFCC header
	// in the request.
	FORWARD_ONLY HttpConnectionManager_ForwardClientCertDetails = 1
	// When the client connection is mTLS, append the client certificate
	// information to the request’s XFCC header and forward it.
	APPEND_FORWARD HttpConnectionManager_ForwardClientCertDetails = 2
	// When the client connection is mTLS, reset the XFCC header with the client
	// certificate information and send it to the next hop.
	SANITIZE_SET HttpConnectionManager_ForwardClientCertDetails = 3
	// Always forward the XFCC header in the request, regardless of whether the
	// client connection is mTLS.
	ALWAYS_FORWARD_ONLY HttpConnectionManager_ForwardClientCertDetails = 4
)

var HttpConnectionManager_ForwardClientCertDetails_name = map[int32]string{
	0: "SANITIZE",
	1: "FORWARD_ONLY",
	2: "APPEND_FORWARD",
	3: "SANITIZE_SET",
	4: "ALWAYS_FORWARD_ONLY",
}

var HttpConnectionManager_ForwardClientCertDetails_value = map[string]int32{
	"SANITIZE":            0,
	"FORWARD_ONLY":        1,
	"APPEND_FORWARD":      2,
	"SANITIZE_SET":        3,
	"ALWAYS_FORWARD_ONLY": 4,
}

func (x HttpConnectionManager_ForwardClientCertDetails) String() string {
	return proto.EnumName(HttpConnectionManager_ForwardClientCertDetails_name, int32(x))
}

func (HttpConnectionManager_ForwardClientCertDetails) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8fe65268985a88f7, []int{0, 1}
}

type HttpConnectionManager_Tracing_OperationName int32

const (
	// The HTTP listener is used for ingress/incoming requests.
	INGRESS HttpConnectionManager_Tracing_OperationName = 0
	// The HTTP listener is used for egress/outgoing requests.
	EGRESS HttpConnectionManager_Tracing_OperationName = 1
)

var HttpConnectionManager_Tracing_OperationName_name = map[int32]string{
	0: "INGRESS",
	1: "EGRESS",
}

var HttpConnectionManager_Tracing_OperationName_value = map[string]int32{
	"INGRESS": 0,
	"EGRESS":  1,
}

func (x HttpConnectionManager_Tracing_OperationName) String() string {
	return proto.EnumName(HttpConnectionManager_Tracing_OperationName_name, int32(x))
}

func (HttpConnectionManager_Tracing_OperationName) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8fe65268985a88f7, []int{0, 0, 0}
}

// [#comment:next free field: 30]
type HttpConnectionManager struct {
	// Supplies the type of codec that the connection manager should use.
	CodecType HttpConnectionManager_CodecType `protobuf:"varint,1,opt,name=codec_type,json=codecType,proto3,enum=envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager_CodecType" json:"codec_type,omitempty"`
	// The human readable prefix to use when emitting statistics for the
	// connection manager. See the :ref:`statistics documentation <config_http_conn_man_stats>` for
	// more information.
	StatPrefix string `protobuf:"bytes,2,opt,name=stat_prefix,json=statPrefix,proto3" json:"stat_prefix,omitempty"`
	// Types that are valid to be assigned to RouteSpecifier:
	//	*HttpConnectionManager_Rds
	//	*HttpConnectionManager_RouteConfig
	RouteSpecifier isHttpConnectionManager_RouteSpecifier `protobuf_oneof:"route_specifier"`
	// A list of individual HTTP filters that make up the filter chain for
	// requests made to the connection manager. Order matters as the filters are
	// processed sequentially as request events happen.
	HttpFilters []*HttpFilter `protobuf:"bytes,5,rep,name=http_filters,json=httpFilters,proto3" json:"http_filters,omitempty"`
	// Whether the connection manager manipulates the :ref:`config_http_conn_man_headers_user-agent`
	// and :ref:`config_http_conn_man_headers_downstream-service-cluster` headers. See the linked
	// documentation for more information. Defaults to false.
	AddUserAgent *types.BoolValue `protobuf:"bytes,6,opt,name=add_user_agent,json=addUserAgent,proto3" json:"add_user_agent,omitempty"`
	// Presence of the object defines whether the connection manager
	// emits :ref:`tracing <arch_overview_tracing>` data to the :ref:`configured tracing provider
	// <envoy_api_msg_config.trace.v2.Tracing>`.
	Tracing *HttpConnectionManager_Tracing `protobuf:"bytes,7,opt,name=tracing,proto3" json:"tracing,omitempty"`
	// Additional HTTP/1 settings that are passed to the HTTP/1 codec.
	HttpProtocolOptions *core.Http1ProtocolOptions `protobuf:"bytes,8,opt,name=http_protocol_options,json=httpProtocolOptions,proto3" json:"http_protocol_options,omitempty"`
	// Additional HTTP/2 settings that are passed directly to the HTTP/2 codec.
	Http2ProtocolOptions *core.Http2ProtocolOptions `protobuf:"bytes,9,opt,name=http2_protocol_options,json=http2ProtocolOptions,proto3" json:"http2_protocol_options,omitempty"`
	// An optional override that the connection manager will write to the server
	// header in responses. If not set, the default is *envoy*.
	ServerName string `protobuf:"bytes,10,opt,name=server_name,json=serverName,proto3" json:"server_name,omitempty"`
	// The maximum request headers size for incoming connections.
	// If unconfigured, the default max request headers allowed is 60 KiB.
	// Requests that exceed this limit will receive a 431 response.
	// The max configurable limit is 96 KiB, based on current implementation
	// constraints.
	MaxRequestHeadersKb *types.UInt32Value `protobuf:"bytes,29,opt,name=max_request_headers_kb,json=maxRequestHeadersKb,proto3" json:"max_request_headers_kb,omitempty"`
	// The idle timeout for connections managed by the connection manager. The
	// idle timeout is defined as the period in which there are no active
	// requests. If not set, there is no idle timeout. When the idle timeout is
	// reached the connection will be closed. If the connection is an HTTP/2
	// connection a drain sequence will occur prior to closing the connection. See
	// :ref:`drain_timeout
	// <envoy_api_field_config.filter.network.http_connection_manager.v2.HttpConnectionManager.drain_timeout>`.
	IdleTimeout *time.Duration `protobuf:"bytes,11,opt,name=idle_timeout,json=idleTimeout,proto3,stdduration" json:"idle_timeout,omitempty"`
	// The stream idle timeout for connections managed by the connection manager.
	// If not specified, this defaults to 5 minutes. The default value was selected
	// so as not to interfere with any smaller configured timeouts that may have
	// existed in configurations prior to the introduction of this feature, while
	// introducing robustness to TCP connections that terminate without a FIN.
	//
	// This idle timeout applies to new streams and is overridable by the
	// :ref:`route-level idle_timeout
	// <envoy_api_field_route.RouteAction.idle_timeout>`. Even on a stream in
	// which the override applies, prior to receipt of the initial request
	// headers, the :ref:`stream_idle_timeout
	// <envoy_api_field_config.filter.network.http_connection_manager.v2.HttpConnectionManager.stream_idle_timeout>`
	// applies. Each time an encode/decode event for headers or data is processed
	// for the stream, the timer will be reset. If the timeout fires, the stream
	// is terminated with a 408 Request Timeout error code if no upstream response
	// header has been received, otherwise a stream reset occurs.
	//
	// Note that it is possible to idle timeout even if the wire traffic for a stream is non-idle, due
	// to the granularity of events presented to the connection manager. For example, while receiving
	// very large request headers, it may be the case that there is traffic regularly arriving on the
	// wire while the connection manage is only able to observe the end-of-headers event, hence the
	// stream may still idle timeout.
	//
	// A value of 0 will completely disable the connection manager stream idle
	// timeout, although per-route idle timeout overrides will continue to apply.
	StreamIdleTimeout *time.Duration `protobuf:"bytes,24,opt,name=stream_idle_timeout,json=streamIdleTimeout,proto3,stdduration" json:"stream_idle_timeout,omitempty"`
	// A timeout for idle requests managed by the connection manager.
	// The timer is activated when the request is initiated, and is disarmed when the last byte of the
	// request is sent upstream (i.e. all decoding filters have processed the request), OR when the
	// response is initiated. If not specified or set to 0, this timeout is disabled.
	RequestTimeout *time.Duration `protobuf:"bytes,28,opt,name=request_timeout,json=requestTimeout,proto3,stdduration" json:"request_timeout,omitempty"`
	// The time that Envoy will wait between sending an HTTP/2 “shutdown
	// notification” (GOAWAY frame with max stream ID) and a final GOAWAY frame.
	// This is used so that Envoy provides a grace period for new streams that
	// race with the final GOAWAY frame. During this grace period, Envoy will
	// continue to accept new streams. After the grace period, a final GOAWAY
	// frame is sent and Envoy will start refusing new streams. Draining occurs
	// both when a connection hits the idle timeout or during general server
	// draining. The default grace period is 5000 milliseconds (5 seconds) if this
	// option is not specified.
	DrainTimeout *time.Duration `protobuf:"bytes,12,opt,name=drain_timeout,json=drainTimeout,proto3,stdduration" json:"drain_timeout,omitempty"`
	// The delayed close timeout is for downstream connections managed by the HTTP connection manager.
	// It is defined as a grace period after connection close processing has been locally initiated
	// during which Envoy will flush the write buffers for the connection and await the peer to close
	// (i.e., a TCP FIN/RST is received by Envoy from the downstream connection).
	//
	// Delaying Envoy's connection close and giving the peer the opportunity to initiate the close
	// sequence mitigates a race condition that exists when downstream clients do not drain/process
	// data in a connection's receive buffer after a remote close has been detected via a socket
	// write(). This race leads to such clients failing to process the response code sent by Envoy,
	// which could result in erroneous downstream processing.
	//
	// If the timeout triggers, Envoy will close the connection's socket.
	//
	// The default timeout is 1000 ms if this option is not specified.
	//
	// A value of 0 will completely disable delayed close processing, and the downstream connection's
	// socket will be closed immediately after the write flush is completed.
	DelayedCloseTimeout *time.Duration `protobuf:"bytes,26,opt,name=delayed_close_timeout,json=delayedCloseTimeout,proto3,stdduration" json:"delayed_close_timeout,omitempty"`
	// Configuration for :ref:`HTTP access logs <arch_overview_access_logs>`
	// emitted by the connection manager.
	AccessLog []*v21.AccessLog `protobuf:"bytes,13,rep,name=access_log,json=accessLog,proto3" json:"access_log,omitempty"`
	// If set to true, the connection manager will use the real remote address
	// of the client connection when determining internal versus external origin and manipulating
	// various headers. If set to false or absent, the connection manager will use the
	// :ref:`config_http_conn_man_headers_x-forwarded-for` HTTP header. See the documentation for
	// :ref:`config_http_conn_man_headers_x-forwarded-for`,
	// :ref:`config_http_conn_man_headers_x-envoy-internal`, and
	// :ref:`config_http_conn_man_headers_x-envoy-external-address` for more information.
	UseRemoteAddress *types.BoolValue `protobuf:"bytes,14,opt,name=use_remote_address,json=useRemoteAddress,proto3" json:"use_remote_address,omitempty"`
	// The number of additional ingress proxy hops from the right side of the
	// :ref:`config_http_conn_man_headers_x-forwarded-for` HTTP header to trust when
	// determining the origin client's IP address. The default is zero if this option
	// is not specified. See the documentation for
	// :ref:`config_http_conn_man_headers_x-forwarded-for` for more information.
	XffNumTrustedHops uint32 `protobuf:"varint,19,opt,name=xff_num_trusted_hops,json=xffNumTrustedHops,proto3" json:"xff_num_trusted_hops,omitempty"`
	// Configures what network addresses are considered internal for stats and header sanitation
	// purposes. If unspecified, only RFC1918 IP addresses will be considered internal.
	// See the documentation for :ref:`config_http_conn_man_headers_x-envoy-internal` for more
	// information about internal/external addresses.
	InternalAddressConfig *HttpConnectionManager_InternalAddressConfig `protobuf:"bytes,25,opt,name=internal_address_config,json=internalAddressConfig,proto3" json:"internal_address_config,omitempty"`
	// If set, Envoy will not append the remote address to the
	// :ref:`config_http_conn_man_headers_x-forwarded-for` HTTP header. This may be used in
	// conjunction with HTTP filters that explicitly manipulate XFF after the HTTP connection manager
	// has mutated the request headers. While :ref:`use_remote_address
	// <envoy_api_field_config.filter.network.http_connection_manager.v2.HttpConnectionManager.use_remote_address>`
	// will also suppress XFF addition, it has consequences for logging and other
	// Envoy uses of the remote address, so *skip_xff_append* should be used
	// when only an elision of XFF addition is intended.
	SkipXffAppend bool `protobuf:"varint,21,opt,name=skip_xff_append,json=skipXffAppend,proto3" json:"skip_xff_append,omitempty"`
	// Via header value to append to request and response headers. If this is
	// empty, no via header will be appended.
	Via string `protobuf:"bytes,22,opt,name=via,proto3" json:"via,omitempty"`
	// Whether the connection manager will generate the :ref:`x-request-id
	// <config_http_conn_man_headers_x-request-id>` header if it does not exist. This defaults to
	// true. Generating a random UUID4 is expensive so in high throughput scenarios where this feature
	// is not desired it can be disabled.
	GenerateRequestId *types.BoolValue `protobuf:"bytes,15,opt,name=generate_request_id,json=generateRequestId,proto3" json:"generate_request_id,omitempty"`
	// How to handle the :ref:`config_http_conn_man_headers_x-forwarded-client-cert` (XFCC) HTTP
	// header.
	ForwardClientCertDetails HttpConnectionManager_ForwardClientCertDetails `protobuf:"varint,16,opt,name=forward_client_cert_details,json=forwardClientCertDetails,proto3,enum=envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager_ForwardClientCertDetails" json:"forward_client_cert_details,omitempty"`
	// This field is valid only when :ref:`forward_client_cert_details
	// <envoy_api_field_config.filter.network.http_connection_manager.v2.HttpConnectionManager.forward_client_cert_details>`
	// is APPEND_FORWARD or SANITIZE_SET and the client connection is mTLS. It specifies the fields in
	// the client certificate to be forwarded. Note that in the
	// :ref:`config_http_conn_man_headers_x-forwarded-client-cert` header, *Hash* is always set, and
	// *By* is always set when the client certificate presents the URI type Subject Alternative Name
	// value.
	SetCurrentClientCertDetails *HttpConnectionManager_SetCurrentClientCertDetails `protobuf:"bytes,17,opt,name=set_current_client_cert_details,json=setCurrentClientCertDetails,proto3" json:"set_current_client_cert_details,omitempty"`
	// If proxy_100_continue is true, Envoy will proxy incoming "Expect:
	// 100-continue" headers upstream, and forward "100 Continue" responses
	// downstream. If this is false or not set, Envoy will instead strip the
	// "Expect: 100-continue" header, and send a "100 Continue" response itself.
	Proxy_100Continue bool `protobuf:"varint,18,opt,name=proxy_100_continue,json=proxy100Continue,proto3" json:"proxy_100_continue,omitempty"`
	// If
	// :ref:`use_remote_address
	// <envoy_api_field_config.filter.network.http_connection_manager.v2.HttpConnectionManager.use_remote_address>`
	// is true and represent_ipv4_remote_address_as_ipv4_mapped_ipv6 is true and the remote address is
	// an IPv4 address, the address will be mapped to IPv6 before it is appended to *x-forwarded-for*.
	// This is useful for testing compatibility of upstream services that parse the header value. For
	// example, 50.0.0.1 is represented as ::FFFF:50.0.0.1. See `IPv4-Mapped IPv6 Addresses
	// <https://tools.ietf.org/html/rfc4291#section-2.5.5.2>`_ for details. This will also affect the
	// :ref:`config_http_conn_man_headers_x-envoy-external-address` header. See
	// :ref:`http_connection_manager.represent_ipv4_remote_address_as_ipv4_mapped_ipv6
	// <config_http_conn_man_runtime_represent_ipv4_remote_address_as_ipv4_mapped_ipv6>` for runtime
	// control.
	RepresentIpv4RemoteAddressAsIpv4MappedIpv6 bool                                   `protobuf:"varint,20,opt,name=represent_ipv4_remote_address_as_ipv4_mapped_ipv6,json=representIpv4RemoteAddressAsIpv4MappedIpv6,proto3" json:"represent_ipv4_remote_address_as_ipv4_mapped_ipv6,omitempty"`
	UpgradeConfigs                             []*HttpConnectionManager_UpgradeConfig `protobuf:"bytes,23,rep,name=upgrade_configs,json=upgradeConfigs,proto3" json:"upgrade_configs,omitempty"`
	XXX_NoUnkeyedLiteral                       struct{}                               `json:"-"`
	XXX_unrecognized                           []byte                                 `json:"-"`
	XXX_sizecache                              int32                                  `json:"-"`
}

func (m *HttpConnectionManager) Reset()         { *m = HttpConnectionManager{} }
func (m *HttpConnectionManager) String() string { return proto.CompactTextString(m) }
func (*HttpConnectionManager) ProtoMessage()    {}
func (*HttpConnectionManager) Descriptor() ([]byte, []int) {
	return fileDescriptor_8fe65268985a88f7, []int{0}
}
func (m *HttpConnectionManager) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HttpConnectionManager) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HttpConnectionManager.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HttpConnectionManager) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HttpConnectionManager.Merge(m, src)
}
func (m *HttpConnectionManager) XXX_Size() int {
	return m.Size()
}
func (m *HttpConnectionManager) XXX_DiscardUnknown() {
	xxx_messageInfo_HttpConnectionManager.DiscardUnknown(m)
}

var xxx_messageInfo_HttpConnectionManager proto.InternalMessageInfo

type isHttpConnectionManager_RouteSpecifier interface {
	isHttpConnectionManager_RouteSpecifier()
	MarshalTo([]byte) (int, error)
	Size() int
}

type HttpConnectionManager_Rds struct {
	Rds *Rds `protobuf:"bytes,3,opt,name=rds,proto3,oneof"`
}
type HttpConnectionManager_RouteConfig struct {
	RouteConfig *v2.RouteConfiguration `protobuf:"bytes,4,opt,name=route_config,json=routeConfig,proto3,oneof"`
}

func (*HttpConnectionManager_Rds) isHttpConnectionManager_RouteSpecifier()         {}
func (*HttpConnectionManager_RouteConfig) isHttpConnectionManager_RouteSpecifier() {}

func (m *HttpConnectionManager) GetRouteSpecifier() isHttpConnectionManager_RouteSpecifier {
	if m != nil {
		return m.RouteSpecifier
	}
	return nil
}

func (m *HttpConnectionManager) GetCodecType() HttpConnectionManager_CodecType {
	if m != nil {
		return m.CodecType
	}
	return AUTO
}

func (m *HttpConnectionManager) GetStatPrefix() string {
	if m != nil {
		return m.StatPrefix
	}
	return ""
}

func (m *HttpConnectionManager) GetRds() *Rds {
	if x, ok := m.GetRouteSpecifier().(*HttpConnectionManager_Rds); ok {
		return x.Rds
	}
	return nil
}

func (m *HttpConnectionManager) GetRouteConfig() *v2.RouteConfiguration {
	if x, ok := m.GetRouteSpecifier().(*HttpConnectionManager_RouteConfig); ok {
		return x.RouteConfig
	}
	return nil
}

func (m *HttpConnectionManager) GetHttpFilters() []*HttpFilter {
	if m != nil {
		return m.HttpFilters
	}
	return nil
}

func (m *HttpConnectionManager) GetAddUserAgent() *types.BoolValue {
	if m != nil {
		return m.AddUserAgent
	}
	return nil
}

func (m *HttpConnectionManager) GetTracing() *HttpConnectionManager_Tracing {
	if m != nil {
		return m.Tracing
	}
	return nil
}

func (m *HttpConnectionManager) GetHttpProtocolOptions() *core.Http1ProtocolOptions {
	if m != nil {
		return m.HttpProtocolOptions
	}
	return nil
}

func (m *HttpConnectionManager) GetHttp2ProtocolOptions() *core.Http2ProtocolOptions {
	if m != nil {
		return m.Http2ProtocolOptions
	}
	return nil
}

func (m *HttpConnectionManager) GetServerName() string {
	if m != nil {
		return m.ServerName
	}
	return ""
}

func (m *HttpConnectionManager) GetMaxRequestHeadersKb() *types.UInt32Value {
	if m != nil {
		return m.MaxRequestHeadersKb
	}
	return nil
}

func (m *HttpConnectionManager) GetIdleTimeout() *time.Duration {
	if m != nil {
		return m.IdleTimeout
	}
	return nil
}

func (m *HttpConnectionManager) GetStreamIdleTimeout() *time.Duration {
	if m != nil {
		return m.StreamIdleTimeout
	}
	return nil
}

func (m *HttpConnectionManager) GetRequestTimeout() *time.Duration {
	if m != nil {
		return m.RequestTimeout
	}
	return nil
}

func (m *HttpConnectionManager) GetDrainTimeout() *time.Duration {
	if m != nil {
		return m.DrainTimeout
	}
	return nil
}

func (m *HttpConnectionManager) GetDelayedCloseTimeout() *time.Duration {
	if m != nil {
		return m.DelayedCloseTimeout
	}
	return nil
}

func (m *HttpConnectionManager) GetAccessLog() []*v21.AccessLog {
	if m != nil {
		return m.AccessLog
	}
	return nil
}

func (m *HttpConnectionManager) GetUseRemoteAddress() *types.BoolValue {
	if m != nil {
		return m.UseRemoteAddress
	}
	return nil
}

func (m *HttpConnectionManager) GetXffNumTrustedHops() uint32 {
	if m != nil {
		return m.XffNumTrustedHops
	}
	return 0
}

func (m *HttpConnectionManager) GetInternalAddressConfig() *HttpConnectionManager_InternalAddressConfig {
	if m != nil {
		return m.InternalAddressConfig
	}
	return nil
}

func (m *HttpConnectionManager) GetSkipXffAppend() bool {
	if m != nil {
		return m.SkipXffAppend
	}
	return false
}

func (m *HttpConnectionManager) GetVia() string {
	if m != nil {
		return m.Via
	}
	return ""
}

func (m *HttpConnectionManager) GetGenerateRequestId() *types.BoolValue {
	if m != nil {
		return m.GenerateRequestId
	}
	return nil
}

func (m *HttpConnectionManager) GetForwardClientCertDetails() HttpConnectionManager_ForwardClientCertDetails {
	if m != nil {
		return m.ForwardClientCertDetails
	}
	return SANITIZE
}

func (m *HttpConnectionManager) GetSetCurrentClientCertDetails() *HttpConnectionManager_SetCurrentClientCertDetails {
	if m != nil {
		return m.SetCurrentClientCertDetails
	}
	return nil
}

func (m *HttpConnectionManager) GetProxy_100Continue() bool {
	if m != nil {
		return m.Proxy_100Continue
	}
	return false
}

func (m *HttpConnectionManager) GetRepresentIpv4RemoteAddressAsIpv4MappedIpv6() bool {
	if m != nil {
		return m.RepresentIpv4RemoteAddressAsIpv4MappedIpv6
	}
	return false
}

func (m *HttpConnectionManager) GetUpgradeConfigs() []*HttpConnectionManager_UpgradeConfig {
	if m != nil {
		return m.UpgradeConfigs
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*HttpConnectionManager) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _HttpConnectionManager_OneofMarshaler, _HttpConnectionManager_OneofUnmarshaler, _HttpConnectionManager_OneofSizer, []interface{}{
		(*HttpConnectionManager_Rds)(nil),
		(*HttpConnectionManager_RouteConfig)(nil),
	}
}

func _HttpConnectionManager_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*HttpConnectionManager)
	// route_specifier
	switch x := m.RouteSpecifier.(type) {
	case *HttpConnectionManager_Rds:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Rds); err != nil {
			return err
		}
	case *HttpConnectionManager_RouteConfig:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RouteConfig); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("HttpConnectionManager.RouteSpecifier has unexpected type %T", x)
	}
	return nil
}

func _HttpConnectionManager_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*HttpConnectionManager)
	switch tag {
	case 3: // route_specifier.rds
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Rds)
		err := b.DecodeMessage(msg)
		m.RouteSpecifier = &HttpConnectionManager_Rds{msg}
		return true, err
	case 4: // route_specifier.route_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(v2.RouteConfiguration)
		err := b.DecodeMessage(msg)
		m.RouteSpecifier = &HttpConnectionManager_RouteConfig{msg}
		return true, err
	default:
		return false, nil
	}
}

func _HttpConnectionManager_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*HttpConnectionManager)
	// route_specifier
	switch x := m.RouteSpecifier.(type) {
	case *HttpConnectionManager_Rds:
		s := proto.Size(x.Rds)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *HttpConnectionManager_RouteConfig:
		s := proto.Size(x.RouteConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type HttpConnectionManager_Tracing struct {
	// The span name will be derived from this field.
	OperationName HttpConnectionManager_Tracing_OperationName `protobuf:"varint,1,opt,name=operation_name,json=operationName,proto3,enum=envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager_Tracing_OperationName" json:"operation_name,omitempty"`
	// A list of header names used to create tags for the active span. The header name is used to
	// populate the tag name, and the header value is used to populate the tag value. The tag is
	// created if the specified header name is present in the request's headers.
	RequestHeadersForTags []string `protobuf:"bytes,2,rep,name=request_headers_for_tags,json=requestHeadersForTags,proto3" json:"request_headers_for_tags,omitempty"`
	// Target percentage of requests managed by this HTTP connection manager that will be force
	// traced if the :ref:`x-client-trace-id <config_http_conn_man_headers_x-client-trace-id>`
	// header is set. This field is a direct analog for the runtime variable
	// 'tracing.client_sampling' in the :ref:`HTTP Connection Manager
	// <config_http_conn_man_runtime>`.
	// Default: 100%
	ClientSampling *_type.Percent `protobuf:"bytes,3,opt,name=client_sampling,json=clientSampling,proto3" json:"client_sampling,omitempty"`
	// Target percentage of requests managed by this HTTP connection manager that will be randomly
	// selected for trace generation, if not requested by the client or not forced. This field is
	// a direct analog for the runtime variable 'tracing.random_sampling' in the
	// :ref:`HTTP Connection Manager <config_http_conn_man_runtime>`.
	// Default: 100%
	RandomSampling *_type.Percent `protobuf:"bytes,4,opt,name=random_sampling,json=randomSampling,proto3" json:"random_sampling,omitempty"`
	// Target percentage of requests managed by this HTTP connection manager that will be traced
	// after all other sampling checks have been applied (client-directed, force tracing, random
	// sampling). This field functions as an upper limit on the total configured sampling rate. For
	// instance, setting client_sampling to 100% but overall_sampling to 1% will result in only 1%
	// of client requests with the appropriate headers to be force traced. This field is a direct
	// analog for the runtime variable 'tracing.global_enabled' in the
	// :ref:`HTTP Connection Manager <config_http_conn_man_runtime>`.
	// Default: 100%
	OverallSampling *_type.Percent `protobuf:"bytes,5,opt,name=overall_sampling,json=overallSampling,proto3" json:"overall_sampling,omitempty"`
	// Whether to annotate spans with additional data. If true, spans will include logs for stream
	// events.
	Verbose              bool     `protobuf:"varint,6,opt,name=verbose,proto3" json:"verbose,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HttpConnectionManager_Tracing) Reset()         { *m = HttpConnectionManager_Tracing{} }
func (m *HttpConnectionManager_Tracing) String() string { return proto.CompactTextString(m) }
func (*HttpConnectionManager_Tracing) ProtoMessage()    {}
func (*HttpConnectionManager_Tracing) Descriptor() ([]byte, []int) {
	return fileDescriptor_8fe65268985a88f7, []int{0, 0}
}
func (m *HttpConnectionManager_Tracing) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HttpConnectionManager_Tracing) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HttpConnectionManager_Tracing.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HttpConnectionManager_Tracing) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HttpConnectionManager_Tracing.Merge(m, src)
}
func (m *HttpConnectionManager_Tracing) XXX_Size() int {
	return m.Size()
}
func (m *HttpConnectionManager_Tracing) XXX_DiscardUnknown() {
	xxx_messageInfo_HttpConnectionManager_Tracing.DiscardUnknown(m)
}

var xxx_messageInfo_HttpConnectionManager_Tracing proto.InternalMessageInfo

func (m *HttpConnectionManager_Tracing) GetOperationName() HttpConnectionManager_Tracing_OperationName {
	if m != nil {
		return m.OperationName
	}
	return INGRESS
}

func (m *HttpConnectionManager_Tracing) GetRequestHeadersForTags() []string {
	if m != nil {
		return m.RequestHeadersForTags
	}
	return nil
}

func (m *HttpConnectionManager_Tracing) GetClientSampling() *_type.Percent {
	if m != nil {
		return m.ClientSampling
	}
	return nil
}

func (m *HttpConnectionManager_Tracing) GetRandomSampling() *_type.Percent {
	if m != nil {
		return m.RandomSampling
	}
	return nil
}

func (m *HttpConnectionManager_Tracing) GetOverallSampling() *_type.Percent {
	if m != nil {
		return m.OverallSampling
	}
	return nil
}

func (m *HttpConnectionManager_Tracing) GetVerbose() bool {
	if m != nil {
		return m.Verbose
	}
	return false
}

type HttpConnectionManager_InternalAddressConfig struct {
	// Whether unix socket addresses should be considered internal.
	UnixSockets          bool     `protobuf:"varint,1,opt,name=unix_sockets,json=unixSockets,proto3" json:"unix_sockets,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HttpConnectionManager_InternalAddressConfig) Reset() {
	*m = HttpConnectionManager_InternalAddressConfig{}
}
func (m *HttpConnectionManager_InternalAddressConfig) String() string {
	return proto.CompactTextString(m)
}
func (*HttpConnectionManager_InternalAddressConfig) ProtoMessage() {}
func (*HttpConnectionManager_InternalAddressConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_8fe65268985a88f7, []int{0, 1}
}
func (m *HttpConnectionManager_InternalAddressConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HttpConnectionManager_InternalAddressConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HttpConnectionManager_InternalAddressConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HttpConnectionManager_InternalAddressConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HttpConnectionManager_InternalAddressConfig.Merge(m, src)
}
func (m *HttpConnectionManager_InternalAddressConfig) XXX_Size() int {
	return m.Size()
}
func (m *HttpConnectionManager_InternalAddressConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_HttpConnectionManager_InternalAddressConfig.DiscardUnknown(m)
}

var xxx_messageInfo_HttpConnectionManager_InternalAddressConfig proto.InternalMessageInfo

func (m *HttpConnectionManager_InternalAddressConfig) GetUnixSockets() bool {
	if m != nil {
		return m.UnixSockets
	}
	return false
}

type HttpConnectionManager_SetCurrentClientCertDetails struct {
	// Whether to forward the subject of the client cert. Defaults to false.
	Subject *types.BoolValue `protobuf:"bytes,1,opt,name=subject,proto3" json:"subject,omitempty"`
	// Whether to forward the entire client cert in URL encoded PEM format. This will appear in the
	// XFCC header comma separated from other values with the value Cert="PEM".
	// Defaults to false.
	Cert bool `protobuf:"varint,3,opt,name=cert,proto3" json:"cert,omitempty"`
	// Whether to forward the DNS type Subject Alternative Names of the client cert.
	// Defaults to false.
	Dns bool `protobuf:"varint,4,opt,name=dns,proto3" json:"dns,omitempty"`
	// Whether to forward the URI type Subject Alternative Name of the client cert. Defaults to
	// false.
	Uri                  bool     `protobuf:"varint,5,opt,name=uri,proto3" json:"uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HttpConnectionManager_SetCurrentClientCertDetails) Reset() {
	*m = HttpConnectionManager_SetCurrentClientCertDetails{}
}
func (m *HttpConnectionManager_SetCurrentClientCertDetails) String() string {
	return proto.CompactTextString(m)
}
func (*HttpConnectionManager_SetCurrentClientCertDetails) ProtoMessage() {}
func (*HttpConnectionManager_SetCurrentClientCertDetails) Descriptor() ([]byte, []int) {
	return fileDescriptor_8fe65268985a88f7, []int{0, 2}
}
func (m *HttpConnectionManager_SetCurrentClientCertDetails) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HttpConnectionManager_SetCurrentClientCertDetails) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HttpConnectionManager_SetCurrentClientCertDetails.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HttpConnectionManager_SetCurrentClientCertDetails) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HttpConnectionManager_SetCurrentClientCertDetails.Merge(m, src)
}
func (m *HttpConnectionManager_SetCurrentClientCertDetails) XXX_Size() int {
	return m.Size()
}
func (m *HttpConnectionManager_SetCurrentClientCertDetails) XXX_DiscardUnknown() {
	xxx_messageInfo_HttpConnectionManager_SetCurrentClientCertDetails.DiscardUnknown(m)
}

var xxx_messageInfo_HttpConnectionManager_SetCurrentClientCertDetails proto.InternalMessageInfo

func (m *HttpConnectionManager_SetCurrentClientCertDetails) GetSubject() *types.BoolValue {
	if m != nil {
		return m.Subject
	}
	return nil
}

func (m *HttpConnectionManager_SetCurrentClientCertDetails) GetCert() bool {
	if m != nil {
		return m.Cert
	}
	return false
}

func (m *HttpConnectionManager_SetCurrentClientCertDetails) GetDns() bool {
	if m != nil {
		return m.Dns
	}
	return false
}

func (m *HttpConnectionManager_SetCurrentClientCertDetails) GetUri() bool {
	if m != nil {
		return m.Uri
	}
	return false
}

// The configuration for HTTP upgrades.
// For each upgrade type desired, an UpgradeConfig must be added.
//
// .. warning::
//
//    The current implementation of upgrade headers does not handle
//    multi-valued upgrade headers. Support for multi-valued headers may be
//    added in the future if needed.
//
// .. warning::
//    The current implementation of upgrade headers does not work with HTTP/2
//    upstreams.
type HttpConnectionManager_UpgradeConfig struct {
	// The case-insensitive name of this upgrade, e.g. "websocket".
	// For each upgrade type present in upgrade_configs, requests with
	// Upgrade: [upgrade_type]
	// will be proxied upstream.
	UpgradeType string `protobuf:"bytes,1,opt,name=upgrade_type,json=upgradeType,proto3" json:"upgrade_type,omitempty"`
	// If present, this represents the filter chain which will be created for
	// this type of upgrade. If no filters are present, the filter chain for
	// HTTP connections will be used for this upgrade type.
	Filters []*HttpFilter `protobuf:"bytes,2,rep,name=filters,proto3" json:"filters,omitempty"`
	// Determines if upgrades are enabled or disabled by default. Defaults to true.
	// This can be overridden on a per-route basis with :ref:`cluster
	// <envoy_api_field_route.RouteAction.upgrade_configs>` as documented in the
	// :ref:`upgrade documentation <arch_overview_websocket>`.
	Enabled              *types.BoolValue `protobuf:"bytes,3,opt,name=enabled,proto3" json:"enabled,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *HttpConnectionManager_UpgradeConfig) Reset()         { *m = HttpConnectionManager_UpgradeConfig{} }
func (m *HttpConnectionManager_UpgradeConfig) String() string { return proto.CompactTextString(m) }
func (*HttpConnectionManager_UpgradeConfig) ProtoMessage()    {}
func (*HttpConnectionManager_UpgradeConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_8fe65268985a88f7, []int{0, 3}
}
func (m *HttpConnectionManager_UpgradeConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HttpConnectionManager_UpgradeConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HttpConnectionManager_UpgradeConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HttpConnectionManager_UpgradeConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HttpConnectionManager_UpgradeConfig.Merge(m, src)
}
func (m *HttpConnectionManager_UpgradeConfig) XXX_Size() int {
	return m.Size()
}
func (m *HttpConnectionManager_UpgradeConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_HttpConnectionManager_UpgradeConfig.DiscardUnknown(m)
}

var xxx_messageInfo_HttpConnectionManager_UpgradeConfig proto.InternalMessageInfo

func (m *HttpConnectionManager_UpgradeConfig) GetUpgradeType() string {
	if m != nil {
		return m.UpgradeType
	}
	return ""
}

func (m *HttpConnectionManager_UpgradeConfig) GetFilters() []*HttpFilter {
	if m != nil {
		return m.Filters
	}
	return nil
}

func (m *HttpConnectionManager_UpgradeConfig) GetEnabled() *types.BoolValue {
	if m != nil {
		return m.Enabled
	}
	return nil
}

type Rds struct {
	// Configuration source specifier for RDS.
	ConfigSource core.ConfigSource `protobuf:"bytes,1,opt,name=config_source,json=configSource,proto3" json:"config_source"`
	// The name of the route configuration. This name will be passed to the RDS
	// API. This allows an Envoy configuration with multiple HTTP listeners (and
	// associated HTTP connection manager filters) to use different route
	// configurations.
	RouteConfigName      string   `protobuf:"bytes,2,opt,name=route_config_name,json=routeConfigName,proto3" json:"route_config_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Rds) Reset()         { *m = Rds{} }
func (m *Rds) String() string { return proto.CompactTextString(m) }
func (*Rds) ProtoMessage()    {}
func (*Rds) Descriptor() ([]byte, []int) {
	return fileDescriptor_8fe65268985a88f7, []int{1}
}
func (m *Rds) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Rds) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Rds.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Rds) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Rds.Merge(m, src)
}
func (m *Rds) XXX_Size() int {
	return m.Size()
}
func (m *Rds) XXX_DiscardUnknown() {
	xxx_messageInfo_Rds.DiscardUnknown(m)
}

var xxx_messageInfo_Rds proto.InternalMessageInfo

func (m *Rds) GetConfigSource() core.ConfigSource {
	if m != nil {
		return m.ConfigSource
	}
	return core.ConfigSource{}
}

func (m *Rds) GetRouteConfigName() string {
	if m != nil {
		return m.RouteConfigName
	}
	return ""
}

type HttpFilter struct {
	// The name of the filter to instantiate. The name must match a supported
	// filter. The built-in filters are:
	//
	// [#comment:TODO(mattklein123): Auto generate the following list]
	// * :ref:`envoy.buffer <config_http_filters_buffer>`
	// * :ref:`envoy.cors <config_http_filters_cors>`
	// * :ref:`envoy.ext_authz <config_http_filters_ext_authz>`
	// * :ref:`envoy.fault <config_http_filters_fault_injection>`
	// * :ref:`envoy.filters.http.header_to_metadata <config_http_filters_header_to_metadata>`
	// * :ref:`envoy.filters.http.grpc_http1_reverse_bridge \
	//   <config_http_filters_grpc_http1_reverse_bridge>`
	// * :ref:`envoy.filters.http.jwt_authn <config_http_filters_jwt_authn>`
	// * :ref:`envoy.filters.http.rbac <config_http_filters_rbac>`
	// * :ref:`envoy.filters.http.tap <config_http_filters_tap>`
	// * :ref:`envoy.gzip <config_http_filters_gzip>`
	// * :ref:`envoy.http_dynamo_filter <config_http_filters_dynamo>`
	// * :ref:`envoy.grpc_http1_bridge <config_http_filters_grpc_bridge>`
	// * :ref:`envoy.grpc_json_transcoder <config_http_filters_grpc_json_transcoder>`
	// * :ref:`envoy.grpc_web <config_http_filters_grpc_web>`
	// * :ref:`envoy.health_check <config_http_filters_health_check>`
	// * :ref:`envoy.ip_tagging <config_http_filters_ip_tagging>`
	// * :ref:`envoy.lua <config_http_filters_lua>`
	// * :ref:`envoy.rate_limit <config_http_filters_rate_limit>`
	// * :ref:`envoy.router <config_http_filters_router>`
	// * :ref:`envoy.squash <config_http_filters_squash>`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Filter specific configuration which depends on the filter being instantiated. See the supported
	// filters for further documentation.
	//
	// Types that are valid to be assigned to ConfigType:
	//	*HttpFilter_Config
	//	*HttpFilter_TypedConfig
	ConfigType           isHttpFilter_ConfigType `protobuf_oneof:"config_type"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *HttpFilter) Reset()         { *m = HttpFilter{} }
func (m *HttpFilter) String() string { return proto.CompactTextString(m) }
func (*HttpFilter) ProtoMessage()    {}
func (*HttpFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_8fe65268985a88f7, []int{2}
}
func (m *HttpFilter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HttpFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HttpFilter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HttpFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HttpFilter.Merge(m, src)
}
func (m *HttpFilter) XXX_Size() int {
	return m.Size()
}
func (m *HttpFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_HttpFilter.DiscardUnknown(m)
}

var xxx_messageInfo_HttpFilter proto.InternalMessageInfo

type isHttpFilter_ConfigType interface {
	isHttpFilter_ConfigType()
	MarshalTo([]byte) (int, error)
	Size() int
}

type HttpFilter_Config struct {
	Config *types.Struct `protobuf:"bytes,2,opt,name=config,proto3,oneof"`
}
type HttpFilter_TypedConfig struct {
	TypedConfig *types.Any `protobuf:"bytes,4,opt,name=typed_config,json=typedConfig,proto3,oneof"`
}

func (*HttpFilter_Config) isHttpFilter_ConfigType()      {}
func (*HttpFilter_TypedConfig) isHttpFilter_ConfigType() {}

func (m *HttpFilter) GetConfigType() isHttpFilter_ConfigType {
	if m != nil {
		return m.ConfigType
	}
	return nil
}

func (m *HttpFilter) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Deprecated: Do not use.
func (m *HttpFilter) GetConfig() *types.Struct {
	if x, ok := m.GetConfigType().(*HttpFilter_Config); ok {
		return x.Config
	}
	return nil
}

func (m *HttpFilter) GetTypedConfig() *types.Any {
	if x, ok := m.GetConfigType().(*HttpFilter_TypedConfig); ok {
		return x.TypedConfig
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*HttpFilter) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _HttpFilter_OneofMarshaler, _HttpFilter_OneofUnmarshaler, _HttpFilter_OneofSizer, []interface{}{
		(*HttpFilter_Config)(nil),
		(*HttpFilter_TypedConfig)(nil),
	}
}

func _HttpFilter_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*HttpFilter)
	// config_type
	switch x := m.ConfigType.(type) {
	case *HttpFilter_Config:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Config); err != nil {
			return err
		}
	case *HttpFilter_TypedConfig:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TypedConfig); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("HttpFilter.ConfigType has unexpected type %T", x)
	}
	return nil
}

func _HttpFilter_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*HttpFilter)
	switch tag {
	case 2: // config_type.config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(types.Struct)
		err := b.DecodeMessage(msg)
		m.ConfigType = &HttpFilter_Config{msg}
		return true, err
	case 4: // config_type.typed_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(types.Any)
		err := b.DecodeMessage(msg)
		m.ConfigType = &HttpFilter_TypedConfig{msg}
		return true, err
	default:
		return false, nil
	}
}

func _HttpFilter_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*HttpFilter)
	// config_type
	switch x := m.ConfigType.(type) {
	case *HttpFilter_Config:
		s := proto.Size(x.Config)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *HttpFilter_TypedConfig:
		s := proto.Size(x.TypedConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterEnum("envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager_CodecType", HttpConnectionManager_CodecType_name, HttpConnectionManager_CodecType_value)
	proto.RegisterEnum("envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager_ForwardClientCertDetails", HttpConnectionManager_ForwardClientCertDetails_name, HttpConnectionManager_ForwardClientCertDetails_value)
	proto.RegisterEnum("envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager_Tracing_OperationName", HttpConnectionManager_Tracing_OperationName_name, HttpConnectionManager_Tracing_OperationName_value)
	proto.RegisterType((*HttpConnectionManager)(nil), "envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager")
	proto.RegisterType((*HttpConnectionManager_Tracing)(nil), "envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.Tracing")
	proto.RegisterType((*HttpConnectionManager_InternalAddressConfig)(nil), "envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.InternalAddressConfig")
	proto.RegisterType((*HttpConnectionManager_SetCurrentClientCertDetails)(nil), "envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.SetCurrentClientCertDetails")
	proto.RegisterType((*HttpConnectionManager_UpgradeConfig)(nil), "envoy.config.filter.network.http_connection_manager.v2.HttpConnectionManager.UpgradeConfig")
	proto.RegisterType((*Rds)(nil), "envoy.config.filter.network.http_connection_manager.v2.Rds")
	proto.RegisterType((*HttpFilter)(nil), "envoy.config.filter.network.http_connection_manager.v2.HttpFilter")
}

func init() {
	proto.RegisterFile("envoy/config/filter/network/http_connection_manager/v2/http_connection_manager.proto", fileDescriptor_8fe65268985a88f7)
}

var fileDescriptor_8fe65268985a88f7 = []byte{
	// 1741 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x57, 0xcd, 0x6f, 0x23, 0x49,
	0x15, 0x4f, 0xdb, 0xce, 0xc4, 0x79, 0x76, 0x92, 0x9e, 0x4a, 0x32, 0xe9, 0x71, 0x66, 0x13, 0x13,
	0x09, 0x88, 0x06, 0x64, 0x27, 0xde, 0xd9, 0x41, 0x7c, 0x08, 0x61, 0x27, 0x19, 0xec, 0x30, 0x9b,
	0x44, 0x6d, 0x87, 0x61, 0x77, 0x41, 0x4d, 0xa5, 0xbb, 0xec, 0x34, 0x63, 0x77, 0x35, 0x55, 0xd5,
	0x9e, 0xe4, 0x84, 0xb4, 0xe2, 0x80, 0xb8, 0xc1, 0x01, 0x21, 0x71, 0xe4, 0x0f, 0x40, 0x70, 0x42,
	0x9c, 0xf6, 0x84, 0xf6, 0xc8, 0x5f, 0xc0, 0xc7, 0xdc, 0xf6, 0x1f, 0xe0, 0x8c, 0xea, 0xa3, 0x9d,
	0x38, 0x71, 0xb2, 0xa3, 0x21, 0x7b, 0xab, 0x7a, 0xef, 0xfd, 0x7e, 0xef, 0xd5, 0xab, 0xf7, 0xea,
	0x03, 0x3a, 0x24, 0x1a, 0xd2, 0xf3, 0xaa, 0x4f, 0xa3, 0x6e, 0xd8, 0xab, 0x76, 0xc3, 0xbe, 0x20,
	0xac, 0x1a, 0x11, 0xf1, 0x8a, 0xb2, 0x97, 0xd5, 0x53, 0x21, 0x62, 0xcf, 0xa7, 0x51, 0x44, 0x7c,
	0x11, 0xd2, 0xc8, 0x1b, 0xe0, 0x08, 0xf7, 0x08, 0xab, 0x0e, 0x6b, 0x37, 0xa9, 0x2a, 0x31, 0xa3,
	0x82, 0xa2, 0xa7, 0x8a, 0xb5, 0xa2, 0x59, 0x2b, 0x9a, 0xb5, 0x62, 0x58, 0x2b, 0x37, 0x41, 0x87,
	0xb5, 0xd2, 0x97, 0x75, 0x34, 0x38, 0x0e, 0xa5, 0x0f, 0x9f, 0x32, 0x62, 0x22, 0xf3, 0x38, 0x4d,
	0x98, 0x4f, 0x34, 0x7d, 0xa9, 0x7c, 0xdd, 0x4c, 0x29, 0x7c, 0xda, 0x37, 0x16, 0x0f, 0xc6, 0x2c,
	0x58, 0xc0, 0x8d, 0x7c, 0x6b, 0xd2, 0x72, 0xb1, 0xef, 0x13, 0xce, 0xfb, 0xb4, 0x27, 0x6d, 0x47,
	0x13, 0x83, 0x70, 0x34, 0x42, 0x9c, 0xc7, 0xa4, 0x1a, 0x13, 0xe6, 0x93, 0x48, 0x18, 0xcd, 0xc3,
	0x1e, 0xa5, 0xbd, 0xbe, 0x71, 0x7d, 0x92, 0x74, 0xab, 0x38, 0x3a, 0x37, 0xaa, 0xb5, 0xab, 0xaa,
	0x20, 0x61, 0x58, 0x2e, 0xd6, 0xe8, 0x1f, 0x5d, 0xd5, 0x73, 0xc1, 0x12, 0x5f, 0xdc, 0x84, 0x7e,
	0xc5, 0x70, 0x1c, 0x13, 0x96, 0x2e, 0x62, 0x65, 0x88, 0xfb, 0x61, 0x80, 0x05, 0xa9, 0xa6, 0x03,
	0xa3, 0x58, 0xea, 0xd1, 0x1e, 0x55, 0xc3, 0xaa, 0x1c, 0x69, 0xe9, 0xc6, 0x7f, 0x57, 0x61, 0xb9,
	0x29, 0x44, 0xbc, 0x33, 0x4a, 0xf9, 0xfb, 0x3a, 0xe3, 0xe8, 0x63, 0x0b, 0xc0, 0xa7, 0x01, 0xf1,
	0x3d, 0xb9, 0x3c, 0xc7, 0x2a, 0x5b, 0x9b, 0xf3, 0xb5, 0x17, 0x95, 0xb7, 0xdb, 0xbc, 0xca, 0x44,
	0x1f, 0x95, 0x1d, 0xc9, 0xdf, 0x39, 0x8f, 0x49, 0x03, 0xfe, 0xf6, 0xd9, 0x27, 0xd9, 0xe9, 0x8f,
	0xad, 0x8c, 0x6d, 0xb9, 0xb3, 0x7e, 0x2a, 0x46, 0x8f, 0xa1, 0xc0, 0x05, 0x16, 0x5e, 0xcc, 0x48,
	0x37, 0x3c, 0x73, 0x32, 0x65, 0x6b, 0x73, 0xb6, 0x31, 0x2b, 0x6d, 0x73, 0x2c, 0x53, 0xb6, 0x5c,
	0x90, 0xda, 0x23, 0xa5, 0x44, 0x87, 0x90, 0x65, 0x01, 0x77, 0xb2, 0x65, 0x6b, 0xb3, 0x50, 0xfb,
	0xf6, 0xdb, 0x06, 0xea, 0x06, 0xbc, 0x39, 0xe5, 0x4a, 0x26, 0xb4, 0x07, 0x45, 0x46, 0x13, 0x41,
	0x3c, 0x4d, 0xe2, 0xe4, 0x14, 0x73, 0xd9, 0x30, 0xe3, 0x38, 0x54, 0xf6, 0xd2, 0x62, 0x47, 0x19,
	0x98, 0x6d, 0x6c, 0x4e, 0xb9, 0x05, 0x76, 0x21, 0x45, 0x04, 0x8a, 0xca, 0x9f, 0x8e, 0x81, 0x3b,
	0xd3, 0xe5, 0xec, 0x66, 0xa1, 0xd6, 0xf8, 0x7f, 0x32, 0xf9, 0x4c, 0x59, 0xbb, 0x85, 0xd3, 0xd1,
	0x98, 0xa3, 0xef, 0xc1, 0x3c, 0x0e, 0x02, 0x2f, 0xe1, 0x84, 0x79, 0xb8, 0x47, 0x22, 0xe1, 0xdc,
	0x53, 0xf1, 0x96, 0x2a, 0xba, 0x62, 0x2a, 0x69, 0xc5, 0x54, 0x1a, 0x94, 0xf6, 0x7f, 0x88, 0xfb,
	0x09, 0x71, 0x8b, 0x38, 0x08, 0x8e, 0x39, 0x61, 0x75, 0x69, 0x8f, 0x28, 0xcc, 0x08, 0x86, 0xfd,
	0x30, 0xea, 0x39, 0x33, 0x0a, 0x7a, 0x7c, 0xb7, 0xbb, 0xdd, 0xd1, 0xe4, 0x6e, 0xea, 0x05, 0x7d,
	0x04, 0xcb, 0x8a, 0x24, 0xed, 0x4f, 0x8f, 0xc6, 0xd2, 0x9e, 0x3b, 0x79, 0xe5, 0xfe, 0xab, 0xe3,
	0x99, 0x96, 0xad, 0xac, 0x98, 0xb7, 0x8f, 0x8c, 0xfd, 0xa1, 0x36, 0x77, 0x17, 0x25, 0xcb, 0x15,
	0x21, 0xfa, 0x09, 0x3c, 0x90, 0xe2, 0xda, 0x75, 0xf6, 0xd9, 0x5b, 0xd9, 0x6b, 0x57, 0xd9, 0x97,
	0x4e, 0x27, 0x48, 0xd1, 0x3a, 0x14, 0x38, 0x61, 0x43, 0xc2, 0xbc, 0x08, 0x0f, 0x88, 0x03, 0xb2,
	0x32, 0x5d, 0xd0, 0xa2, 0x03, 0x3c, 0x20, 0x88, 0xc0, 0x83, 0x01, 0x3e, 0xf3, 0x18, 0xf9, 0x79,
	0x42, 0xb8, 0xf0, 0x4e, 0x09, 0x0e, 0x08, 0xe3, 0xde, 0xcb, 0x13, 0xe7, 0x1d, 0xe5, 0xff, 0xd1,
	0xb5, 0x7d, 0x39, 0x6e, 0x45, 0xe2, 0xdd, 0x9a, 0xda, 0x99, 0x06, 0x52, 0x35, 0xfe, 0x38, 0x53,
	0x9e, 0x32, 0x03, 0xe7, 0xa7, 0xee, 0xe2, 0x00, 0x9f, 0xb9, 0x9a, 0xae, 0xa9, 0xd9, 0x7e, 0x70,
	0x82, 0x1a, 0x50, 0x0c, 0x83, 0x3e, 0xf1, 0x44, 0x38, 0x20, 0x34, 0x11, 0x4e, 0x41, 0x91, 0x3f,
	0xbc, 0x46, 0xbe, 0x6b, 0xaa, 0xb3, 0x91, 0xfb, 0xfd, 0xbf, 0xd6, 0x2d, 0xb7, 0x20, 0x41, 0x1d,
	0x8d, 0x41, 0x87, 0xb0, 0xc8, 0x05, 0x23, 0x78, 0xe0, 0x8d, 0x51, 0x39, 0x6f, 0x46, 0x75, 0x5f,
	0x63, 0x5b, 0x97, 0x08, 0x9b, 0xb0, 0x90, 0xae, 0x3b, 0x25, 0x7b, 0xf4, 0x66, 0x64, 0xf3, 0x06,
	0x97, 0x32, 0xed, 0xc2, 0x5c, 0xc0, 0x70, 0x18, 0x8d, 0x78, 0x8a, 0x6f, 0xc6, 0x53, 0x54, 0xa8,
	0x94, 0xa5, 0x0d, 0xcb, 0x01, 0xe9, 0xe3, 0x73, 0x12, 0x78, 0x7e, 0x9f, 0xf2, 0x8b, 0x25, 0x96,
	0xde, 0x8c, 0x6d, 0xd1, 0xa0, 0x77, 0x24, 0x38, 0x25, 0xdd, 0x07, 0xd0, 0xf7, 0x81, 0xd7, 0xa7,
	0x3d, 0x67, 0x4e, 0x75, 0xf5, 0xd7, 0x26, 0x76, 0xcc, 0xc5, 0xb5, 0x31, 0xac, 0x55, 0xea, 0x6a,
	0xf2, 0x9c, 0xf6, 0xdc, 0x59, 0x9c, 0x0e, 0x51, 0x13, 0x50, 0xc2, 0x89, 0xc7, 0xc8, 0x80, 0x0a,
	0xe2, 0xe1, 0x20, 0x60, 0x84, 0x73, 0x67, 0xfe, 0x73, 0x1b, 0xd8, 0x4e, 0x38, 0x71, 0x15, 0xa8,
	0xae, 0x31, 0xa8, 0x0a, 0x4b, 0x67, 0xdd, 0xae, 0x17, 0x25, 0x03, 0x4f, 0xb0, 0x84, 0x0b, 0x12,
	0x78, 0xa7, 0x34, 0xe6, 0xce, 0x62, 0xd9, 0xda, 0x9c, 0x73, 0xef, 0x9f, 0x75, 0xbb, 0x07, 0xc9,
	0xa0, 0xa3, 0x35, 0x4d, 0x1a, 0x73, 0xf4, 0x07, 0x0b, 0x56, 0xc2, 0x48, 0x10, 0x16, 0xe1, 0x7e,
	0xea, 0x39, 0x3d, 0xf1, 0x1e, 0xaa, 0x00, 0xfc, 0xbb, 0x3d, 0x06, 0x5a, 0xc6, 0x99, 0x89, 0x58,
	0x9f, 0x92, 0xee, 0x72, 0x38, 0x49, 0x8c, 0xbe, 0x02, 0x0b, 0xfc, 0x65, 0x18, 0x7b, 0x72, 0x4d,
	0xf2, 0x9e, 0x8b, 0x02, 0x67, 0xb9, 0x6c, 0x6d, 0xe6, 0xdd, 0x39, 0x29, 0xfe, 0x51, 0xb7, 0x5b,
	0x57, 0x42, 0x64, 0x43, 0x76, 0x18, 0x62, 0xe7, 0x81, 0x6a, 0x43, 0x39, 0x44, 0xfb, 0xb0, 0xd8,
	0x23, 0x11, 0x61, 0x58, 0x90, 0x51, 0x13, 0x86, 0x81, 0xb3, 0xf0, 0xb9, 0x39, 0xbd, 0x9f, 0xc2,
	0x4c, 0xaf, 0xb5, 0x02, 0xf4, 0x67, 0x0b, 0x56, 0xbb, 0x94, 0xbd, 0xc2, 0x4c, 0x16, 0x50, 0x48,
	0x22, 0xe1, 0xf9, 0x84, 0x09, 0x2f, 0x20, 0x02, 0x87, 0x7d, 0xee, 0xd8, 0xea, 0x72, 0xec, 0xde,
	0x6d, 0x9e, 0x9e, 0x69, 0x87, 0x3b, 0xca, 0xdf, 0x0e, 0x61, 0x62, 0x57, 0x7b, 0x1b, 0xbb, 0x2b,
	0x9d, 0xee, 0x0d, 0x56, 0xe8, 0x4f, 0x16, 0xac, 0x73, 0x22, 0x3c, 0x3f, 0x61, 0x4c, 0x05, 0x3c,
	0x21, 0xee, 0xfb, 0x2a, 0x19, 0xe1, 0xdd, 0xc6, 0xdd, 0x26, 0x62, 0x47, 0xfb, 0xbc, 0x16, 0x94,
	0xbb, 0xca, 0x6f, 0x56, 0xa2, 0xaf, 0x03, 0x8a, 0x19, 0x3d, 0x3b, 0xf7, 0xb6, 0xb7, 0xb6, 0xa4,
	0x47, 0x11, 0x46, 0x09, 0x71, 0x90, 0xda, 0x6e, 0x5b, 0x69, 0xb6, 0xb7, 0xb6, 0x76, 0x8c, 0x1c,
	0x11, 0xd8, 0x66, 0x24, 0x66, 0x84, 0xcb, 0x55, 0x85, 0xf1, 0xf0, 0xc9, 0x95, 0xee, 0xf1, 0x30,
	0xd7, 0xe2, 0x81, 0xac, 0x9b, 0x40, 0x8e, 0x9f, 0x3a, 0x4b, 0x8a, 0xec, 0xf1, 0x08, 0xd8, 0x8a,
	0x87, 0x4f, 0xc6, 0xfa, 0xa7, 0xce, 0xa5, 0xe8, 0x7d, 0x05, 0x69, 0xc5, 0xc3, 0xa7, 0xe8, 0x97,
	0x16, 0x2c, 0x24, 0x71, 0x8f, 0xe1, 0x20, 0x7d, 0x07, 0x70, 0x67, 0x45, 0xf5, 0xfa, 0x47, 0x77,
	0x9b, 0xb6, 0x63, 0xed, 0xc4, 0xb4, 0xc3, 0x7c, 0x72, 0x79, 0xca, 0x4b, 0xff, 0xc9, 0xc2, 0x8c,
	0xb9, 0x3f, 0xd1, 0xef, 0x2c, 0x98, 0xa7, 0x31, 0xd1, 0x27, 0x94, 0xbe, 0x7e, 0xf4, 0xeb, 0xcc,
	0xff, 0x42, 0xee, 0xeb, 0xca, 0x61, 0xea, 0x4b, 0xde, 0x6b, 0x63, 0xd5, 0x37, 0x47, 0x2f, 0xab,
	0xd0, 0x37, 0xc0, 0xb9, 0x7a, 0xdd, 0x75, 0x29, 0xf3, 0x04, 0xee, 0x71, 0x27, 0x53, 0xce, 0x6e,
	0xce, 0xba, 0xcb, 0x6c, 0xec, 0xfe, 0x7a, 0x46, 0x59, 0x07, 0xf7, 0x38, 0xfa, 0x0e, 0x2c, 0x98,
	0xf2, 0xe4, 0x78, 0x10, 0xf7, 0xe5, 0x0b, 0x44, 0x3f, 0xe3, 0x16, 0xcd, 0x8a, 0xe4, 0x13, 0xb4,
	0x72, 0xa4, 0x5f, 0xd8, 0xee, 0xbc, 0xb6, 0x6d, 0x1b, 0x53, 0x89, 0x66, 0x38, 0x0a, 0xe8, 0xe0,
	0x02, 0x9d, 0xbb, 0x05, 0xad, 0x6d, 0x47, 0xe8, 0xef, 0x82, 0x4d, 0x87, 0x84, 0xe1, 0x7e, 0xff,
	0x02, 0x3e, 0x7d, 0x33, 0x7c, 0xc1, 0x18, 0x8f, 0xf0, 0x0e, 0xcc, 0x0c, 0x09, 0x3b, 0xa1, 0x9c,
	0xa8, 0x07, 0x57, 0xde, 0x4d, 0xa7, 0x1b, 0x15, 0x98, 0x1b, 0x4b, 0x1d, 0x2a, 0xc0, 0x4c, 0xeb,
	0xe0, 0xfb, 0xee, 0x5e, 0xbb, 0x6d, 0x4f, 0x21, 0x80, 0x7b, 0x7b, 0x7a, 0x6c, 0x95, 0x72, 0xbf,
	0xfa, 0xe3, 0xda, 0x54, 0xe9, 0x5b, 0xb0, 0x3c, 0xf1, 0x6c, 0x44, 0x5f, 0x82, 0x62, 0x12, 0x85,
	0x67, 0x1e, 0xa7, 0xfe, 0x4b, 0x22, 0xb8, 0xda, 0xed, 0xbc, 0x5b, 0x90, 0xb2, 0xb6, 0x16, 0x95,
	0x7e, 0x63, 0xc1, 0xea, 0x2d, 0x8d, 0x87, 0x9e, 0xc0, 0x0c, 0x4f, 0x4e, 0x7e, 0x46, 0x7c, 0xa1,
	0xd0, 0xb7, 0x9f, 0x80, 0xa9, 0x29, 0x42, 0x90, 0x93, 0xe7, 0x85, 0xda, 0x8c, 0xbc, 0xab, 0xc6,
	0xf2, 0xa4, 0x0d, 0x22, 0xae, 0x32, 0x9c, 0x77, 0xe5, 0x50, 0x4a, 0x12, 0x16, 0xaa, 0xa4, 0xe5,
	0x5d, 0x39, 0xdc, 0xcf, 0xe5, 0x33, 0x76, 0xb6, 0xf4, 0x77, 0x0b, 0xe6, 0xc6, 0xaa, 0x5a, 0x2d,
	0xc4, 0xf4, 0xd2, 0xe8, 0x53, 0x31, 0xeb, 0x16, 0x8c, 0x4c, 0xbd, 0xf8, 0x7f, 0x0c, 0x33, 0xe9,
	0x43, 0x39, 0x73, 0x67, 0x0f, 0xe5, 0x94, 0x52, 0xa6, 0x81, 0x44, 0xf8, 0xa4, 0x4f, 0x02, 0x53,
	0x60, 0xb7, 0xa6, 0xc1, 0x98, 0x6e, 0x6c, 0xc3, 0xec, 0xe8, 0xa7, 0x82, 0xf2, 0x90, 0xab, 0x1f,
	0x77, 0x0e, 0xed, 0x29, 0x34, 0x0b, 0xd3, 0xcd, 0x4e, 0xe7, 0x68, 0xdb, 0xb6, 0xd2, 0x61, 0xcd,
	0xce, 0xe8, 0xbd, 0xdc, 0xf8, 0x05, 0x38, 0x37, 0x9d, 0xdf, 0xa8, 0x08, 0xf9, 0x76, 0xfd, 0xa0,
	0xd5, 0x69, 0x7d, 0xb8, 0x67, 0x4f, 0x21, 0x1b, 0x8a, 0xcf, 0x0e, 0xdd, 0x17, 0x75, 0x77, 0xd7,
	0x3b, 0x3c, 0x78, 0xfe, 0x81, 0x6d, 0x21, 0x04, 0xf3, 0xf5, 0xa3, 0xa3, 0xbd, 0x83, 0x5d, 0xcf,
	0x28, 0xec, 0x8c, 0xb4, 0x4a, 0x31, 0x5e, 0x7b, 0xaf, 0x63, 0x67, 0xd1, 0x0a, 0x2c, 0xd6, 0x9f,
	0xbf, 0xa8, 0x7f, 0xd0, 0xf6, 0xc6, 0xe0, 0x39, 0x1d, 0x40, 0xc3, 0x81, 0x05, 0xfd, 0x79, 0xe1,
	0x31, 0xf1, 0xc3, 0x6e, 0x48, 0x18, 0x9a, 0xfe, 0xeb, 0x67, 0x9f, 0x64, 0xad, 0xfd, 0x5c, 0x7e,
	0xd5, 0x7e, 0xb4, 0xf1, 0x5b, 0x0b, 0xb2, 0x6e, 0xc0, 0x51, 0x07, 0xe6, 0xc6, 0x7e, 0xd1, 0xa6,
	0x3c, 0xd6, 0x27, 0xbc, 0x8e, 0xf5, 0x26, 0xb6, 0x95, 0x59, 0x63, 0xfe, 0xd3, 0x7f, 0xae, 0xab,
	0xb7, 0xe9, 0xf4, 0xaf, 0xd5, 0x51, 0x50, 0xf4, 0x2f, 0x69, 0xd1, 0x7b, 0x70, 0xff, 0xf2, 0xd7,
	0x49, 0x1f, 0x52, 0xd7, 0x7e, 0x6f, 0x0b, 0x97, 0xbe, 0x49, 0xb2, 0x41, 0x36, 0xfe, 0x62, 0x01,
	0x5c, 0x6c, 0x1b, 0x7a, 0x07, 0x72, 0xa3, 0xd3, 0x6d, 0x0c, 0xa8, 0xc4, 0xe8, 0x3d, 0xb8, 0x67,
	0xde, 0x29, 0x19, 0x15, 0xf3, 0xca, 0xb5, 0xbd, 0x6c, 0xab, 0x9f, 0x73, 0x23, 0xe3, 0x58, 0xcd,
	0x29, 0xd7, 0x18, 0xa3, 0x6f, 0x42, 0x51, 0x16, 0x5f, 0x30, 0xfe, 0xad, 0x5b, 0xba, 0x06, 0xae,
	0x47, 0xe7, 0xf2, 0x2b, 0xa7, 0x6c, 0x75, 0x8c, 0x8d, 0x39, 0x28, 0x98, 0x05, 0x49, 0xe9, 0x7e,
	0x2e, 0x9f, 0xb5, 0x73, 0x0d, 0xf1, 0xe9, 0xeb, 0x35, 0xeb, 0x1f, 0xaf, 0xd7, 0xac, 0x7f, 0xbf,
	0x5e, 0xb3, 0x60, 0x37, 0xa4, 0x3a, 0x75, 0xea, 0xc2, 0x7a, 0xcb, 0xda, 0x6d, 0x94, 0x26, 0x9e,
	0xc8, 0xea, 0x0f, 0x72, 0x64, 0x7d, 0x98, 0x19, 0xd6, 0x4e, 0xee, 0xa9, 0x38, 0xdf, 0xfd, 0x5f,
	0x00, 0x00, 0x00, 0xff, 0xff, 0x5e, 0x3a, 0xae, 0x61, 0xa4, 0x11, 0x00, 0x00,
}

func (m *HttpConnectionManager) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HttpConnectionManager) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.CodecType != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(m.CodecType))
	}
	if len(m.StatPrefix) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(len(m.StatPrefix)))
		i += copy(dAtA[i:], m.StatPrefix)
	}
	if m.RouteSpecifier != nil {
		nn1, err := m.RouteSpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn1
	}
	if len(m.HttpFilters) > 0 {
		for _, msg := range m.HttpFilters {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintHttpConnectionManager(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.AddUserAgent != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(m.AddUserAgent.Size()))
		n2, err := m.AddUserAgent.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.Tracing != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(m.Tracing.Size()))
		n3, err := m.Tracing.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.HttpProtocolOptions != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(m.HttpProtocolOptions.Size()))
		n4, err := m.HttpProtocolOptions.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.Http2ProtocolOptions != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(m.Http2ProtocolOptions.Size()))
		n5, err := m.Http2ProtocolOptions.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if len(m.ServerName) > 0 {
		dAtA[i] = 0x52
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(len(m.ServerName)))
		i += copy(dAtA[i:], m.ServerName)
	}
	if m.IdleTimeout != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.IdleTimeout)))
		n6, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.IdleTimeout, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.DrainTimeout != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.DrainTimeout)))
		n7, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.DrainTimeout, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if len(m.AccessLog) > 0 {
		for _, msg := range m.AccessLog {
			dAtA[i] = 0x6a
			i++
			i = encodeVarintHttpConnectionManager(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.UseRemoteAddress != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(m.UseRemoteAddress.Size()))
		n8, err := m.UseRemoteAddress.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.GenerateRequestId != nil {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(m.GenerateRequestId.Size()))
		n9, err := m.GenerateRequestId.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.ForwardClientCertDetails != 0 {
		dAtA[i] = 0x80
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(m.ForwardClientCertDetails))
	}
	if m.SetCurrentClientCertDetails != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(m.SetCurrentClientCertDetails.Size()))
		n10, err := m.SetCurrentClientCertDetails.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.Proxy_100Continue {
		dAtA[i] = 0x90
		i++
		dAtA[i] = 0x1
		i++
		if m.Proxy_100Continue {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XffNumTrustedHops != 0 {
		dAtA[i] = 0x98
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(m.XffNumTrustedHops))
	}
	if m.RepresentIpv4RemoteAddressAsIpv4MappedIpv6 {
		dAtA[i] = 0xa0
		i++
		dAtA[i] = 0x1
		i++
		if m.RepresentIpv4RemoteAddressAsIpv4MappedIpv6 {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.SkipXffAppend {
		dAtA[i] = 0xa8
		i++
		dAtA[i] = 0x1
		i++
		if m.SkipXffAppend {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.Via) > 0 {
		dAtA[i] = 0xb2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(len(m.Via)))
		i += copy(dAtA[i:], m.Via)
	}
	if len(m.UpgradeConfigs) > 0 {
		for _, msg := range m.UpgradeConfigs {
			dAtA[i] = 0xba
			i++
			dAtA[i] = 0x1
			i++
			i = encodeVarintHttpConnectionManager(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.StreamIdleTimeout != nil {
		dAtA[i] = 0xc2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.StreamIdleTimeout)))
		n11, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.StreamIdleTimeout, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if m.InternalAddressConfig != nil {
		dAtA[i] = 0xca
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(m.InternalAddressConfig.Size()))
		n12, err := m.InternalAddressConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if m.DelayedCloseTimeout != nil {
		dAtA[i] = 0xd2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.DelayedCloseTimeout)))
		n13, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.DelayedCloseTimeout, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if m.RequestTimeout != nil {
		dAtA[i] = 0xe2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.RequestTimeout)))
		n14, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.RequestTimeout, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if m.MaxRequestHeadersKb != nil {
		dAtA[i] = 0xea
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(m.MaxRequestHeadersKb.Size()))
		n15, err := m.MaxRequestHeadersKb.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HttpConnectionManager_Rds) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Rds != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(m.Rds.Size()))
		n16, err := m.Rds.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	return i, nil
}
func (m *HttpConnectionManager_RouteConfig) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RouteConfig != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(m.RouteConfig.Size()))
		n17, err := m.RouteConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	return i, nil
}
func (m *HttpConnectionManager_Tracing) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HttpConnectionManager_Tracing) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.OperationName != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(m.OperationName))
	}
	if len(m.RequestHeadersForTags) > 0 {
		for _, s := range m.RequestHeadersForTags {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.ClientSampling != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(m.ClientSampling.Size()))
		n18, err := m.ClientSampling.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	if m.RandomSampling != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(m.RandomSampling.Size()))
		n19, err := m.RandomSampling.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	if m.OverallSampling != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(m.OverallSampling.Size()))
		n20, err := m.OverallSampling.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n20
	}
	if m.Verbose {
		dAtA[i] = 0x30
		i++
		if m.Verbose {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HttpConnectionManager_InternalAddressConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HttpConnectionManager_InternalAddressConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.UnixSockets {
		dAtA[i] = 0x8
		i++
		if m.UnixSockets {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HttpConnectionManager_SetCurrentClientCertDetails) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HttpConnectionManager_SetCurrentClientCertDetails) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Subject != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(m.Subject.Size()))
		n21, err := m.Subject.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	if m.Cert {
		dAtA[i] = 0x18
		i++
		if m.Cert {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Dns {
		dAtA[i] = 0x20
		i++
		if m.Dns {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Uri {
		dAtA[i] = 0x28
		i++
		if m.Uri {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HttpConnectionManager_UpgradeConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HttpConnectionManager_UpgradeConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.UpgradeType) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(len(m.UpgradeType)))
		i += copy(dAtA[i:], m.UpgradeType)
	}
	if len(m.Filters) > 0 {
		for _, msg := range m.Filters {
			dAtA[i] = 0x12
			i++
			i = encodeVarintHttpConnectionManager(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Enabled != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(m.Enabled.Size()))
		n22, err := m.Enabled.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n22
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Rds) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Rds) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintHttpConnectionManager(dAtA, i, uint64(m.ConfigSource.Size()))
	n23, err := m.ConfigSource.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n23
	if len(m.RouteConfigName) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(len(m.RouteConfigName)))
		i += copy(dAtA[i:], m.RouteConfigName)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HttpFilter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HttpFilter) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.ConfigType != nil {
		nn24, err := m.ConfigType.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn24
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HttpFilter_Config) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Config != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(m.Config.Size()))
		n25, err := m.Config.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n25
	}
	return i, nil
}
func (m *HttpFilter_TypedConfig) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.TypedConfig != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintHttpConnectionManager(dAtA, i, uint64(m.TypedConfig.Size()))
		n26, err := m.TypedConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n26
	}
	return i, nil
}
func encodeVarintHttpConnectionManager(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *HttpConnectionManager) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CodecType != 0 {
		n += 1 + sovHttpConnectionManager(uint64(m.CodecType))
	}
	l = len(m.StatPrefix)
	if l > 0 {
		n += 1 + l + sovHttpConnectionManager(uint64(l))
	}
	if m.RouteSpecifier != nil {
		n += m.RouteSpecifier.Size()
	}
	if len(m.HttpFilters) > 0 {
		for _, e := range m.HttpFilters {
			l = e.Size()
			n += 1 + l + sovHttpConnectionManager(uint64(l))
		}
	}
	if m.AddUserAgent != nil {
		l = m.AddUserAgent.Size()
		n += 1 + l + sovHttpConnectionManager(uint64(l))
	}
	if m.Tracing != nil {
		l = m.Tracing.Size()
		n += 1 + l + sovHttpConnectionManager(uint64(l))
	}
	if m.HttpProtocolOptions != nil {
		l = m.HttpProtocolOptions.Size()
		n += 1 + l + sovHttpConnectionManager(uint64(l))
	}
	if m.Http2ProtocolOptions != nil {
		l = m.Http2ProtocolOptions.Size()
		n += 1 + l + sovHttpConnectionManager(uint64(l))
	}
	l = len(m.ServerName)
	if l > 0 {
		n += 1 + l + sovHttpConnectionManager(uint64(l))
	}
	if m.IdleTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.IdleTimeout)
		n += 1 + l + sovHttpConnectionManager(uint64(l))
	}
	if m.DrainTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.DrainTimeout)
		n += 1 + l + sovHttpConnectionManager(uint64(l))
	}
	if len(m.AccessLog) > 0 {
		for _, e := range m.AccessLog {
			l = e.Size()
			n += 1 + l + sovHttpConnectionManager(uint64(l))
		}
	}
	if m.UseRemoteAddress != nil {
		l = m.UseRemoteAddress.Size()
		n += 1 + l + sovHttpConnectionManager(uint64(l))
	}
	if m.GenerateRequestId != nil {
		l = m.GenerateRequestId.Size()
		n += 1 + l + sovHttpConnectionManager(uint64(l))
	}
	if m.ForwardClientCertDetails != 0 {
		n += 2 + sovHttpConnectionManager(uint64(m.ForwardClientCertDetails))
	}
	if m.SetCurrentClientCertDetails != nil {
		l = m.SetCurrentClientCertDetails.Size()
		n += 2 + l + sovHttpConnectionManager(uint64(l))
	}
	if m.Proxy_100Continue {
		n += 3
	}
	if m.XffNumTrustedHops != 0 {
		n += 2 + sovHttpConnectionManager(uint64(m.XffNumTrustedHops))
	}
	if m.RepresentIpv4RemoteAddressAsIpv4MappedIpv6 {
		n += 3
	}
	if m.SkipXffAppend {
		n += 3
	}
	l = len(m.Via)
	if l > 0 {
		n += 2 + l + sovHttpConnectionManager(uint64(l))
	}
	if len(m.UpgradeConfigs) > 0 {
		for _, e := range m.UpgradeConfigs {
			l = e.Size()
			n += 2 + l + sovHttpConnectionManager(uint64(l))
		}
	}
	if m.StreamIdleTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.StreamIdleTimeout)
		n += 2 + l + sovHttpConnectionManager(uint64(l))
	}
	if m.InternalAddressConfig != nil {
		l = m.InternalAddressConfig.Size()
		n += 2 + l + sovHttpConnectionManager(uint64(l))
	}
	if m.DelayedCloseTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.DelayedCloseTimeout)
		n += 2 + l + sovHttpConnectionManager(uint64(l))
	}
	if m.RequestTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.RequestTimeout)
		n += 2 + l + sovHttpConnectionManager(uint64(l))
	}
	if m.MaxRequestHeadersKb != nil {
		l = m.MaxRequestHeadersKb.Size()
		n += 2 + l + sovHttpConnectionManager(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HttpConnectionManager_Rds) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Rds != nil {
		l = m.Rds.Size()
		n += 1 + l + sovHttpConnectionManager(uint64(l))
	}
	return n
}
func (m *HttpConnectionManager_RouteConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RouteConfig != nil {
		l = m.RouteConfig.Size()
		n += 1 + l + sovHttpConnectionManager(uint64(l))
	}
	return n
}
func (m *HttpConnectionManager_Tracing) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.OperationName != 0 {
		n += 1 + sovHttpConnectionManager(uint64(m.OperationName))
	}
	if len(m.RequestHeadersForTags) > 0 {
		for _, s := range m.RequestHeadersForTags {
			l = len(s)
			n += 1 + l + sovHttpConnectionManager(uint64(l))
		}
	}
	if m.ClientSampling != nil {
		l = m.ClientSampling.Size()
		n += 1 + l + sovHttpConnectionManager(uint64(l))
	}
	if m.RandomSampling != nil {
		l = m.RandomSampling.Size()
		n += 1 + l + sovHttpConnectionManager(uint64(l))
	}
	if m.OverallSampling != nil {
		l = m.OverallSampling.Size()
		n += 1 + l + sovHttpConnectionManager(uint64(l))
	}
	if m.Verbose {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HttpConnectionManager_InternalAddressConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.UnixSockets {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HttpConnectionManager_SetCurrentClientCertDetails) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Subject != nil {
		l = m.Subject.Size()
		n += 1 + l + sovHttpConnectionManager(uint64(l))
	}
	if m.Cert {
		n += 2
	}
	if m.Dns {
		n += 2
	}
	if m.Uri {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HttpConnectionManager_UpgradeConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.UpgradeType)
	if l > 0 {
		n += 1 + l + sovHttpConnectionManager(uint64(l))
	}
	if len(m.Filters) > 0 {
		for _, e := range m.Filters {
			l = e.Size()
			n += 1 + l + sovHttpConnectionManager(uint64(l))
		}
	}
	if m.Enabled != nil {
		l = m.Enabled.Size()
		n += 1 + l + sovHttpConnectionManager(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Rds) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ConfigSource.Size()
	n += 1 + l + sovHttpConnectionManager(uint64(l))
	l = len(m.RouteConfigName)
	if l > 0 {
		n += 1 + l + sovHttpConnectionManager(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HttpFilter) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovHttpConnectionManager(uint64(l))
	}
	if m.ConfigType != nil {
		n += m.ConfigType.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HttpFilter_Config) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Config != nil {
		l = m.Config.Size()
		n += 1 + l + sovHttpConnectionManager(uint64(l))
	}
	return n
}
func (m *HttpFilter_TypedConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TypedConfig != nil {
		l = m.TypedConfig.Size()
		n += 1 + l + sovHttpConnectionManager(uint64(l))
	}
	return n
}

func sovHttpConnectionManager(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozHttpConnectionManager(x uint64) (n int) {
	return sovHttpConnectionManager(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *HttpConnectionManager) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHttpConnectionManager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HttpConnectionManager: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HttpConnectionManager: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CodecType", wireType)
			}
			m.CodecType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CodecType |= HttpConnectionManager_CodecType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatPrefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StatPrefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rds", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Rds{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.RouteSpecifier = &HttpConnectionManager_Rds{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RouteConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &v2.RouteConfiguration{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.RouteSpecifier = &HttpConnectionManager_RouteConfig{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpFilters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HttpFilters = append(m.HttpFilters, &HttpFilter{})
			if err := m.HttpFilters[len(m.HttpFilters)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AddUserAgent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AddUserAgent == nil {
				m.AddUserAgent = &types.BoolValue{}
			}
			if err := m.AddUserAgent.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tracing", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Tracing == nil {
				m.Tracing = &HttpConnectionManager_Tracing{}
			}
			if err := m.Tracing.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpProtocolOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HttpProtocolOptions == nil {
				m.HttpProtocolOptions = &core.Http1ProtocolOptions{}
			}
			if err := m.HttpProtocolOptions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Http2ProtocolOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Http2ProtocolOptions == nil {
				m.Http2ProtocolOptions = &core.Http2ProtocolOptions{}
			}
			if err := m.Http2ProtocolOptions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServerName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServerName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IdleTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IdleTimeout == nil {
				m.IdleTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.IdleTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DrainTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DrainTimeout == nil {
				m.DrainTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.DrainTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessLog", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccessLog = append(m.AccessLog, &v21.AccessLog{})
			if err := m.AccessLog[len(m.AccessLog)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UseRemoteAddress", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UseRemoteAddress == nil {
				m.UseRemoteAddress = &types.BoolValue{}
			}
			if err := m.UseRemoteAddress.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GenerateRequestId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GenerateRequestId == nil {
				m.GenerateRequestId = &types.BoolValue{}
			}
			if err := m.GenerateRequestId.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForwardClientCertDetails", wireType)
			}
			m.ForwardClientCertDetails = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ForwardClientCertDetails |= HttpConnectionManager_ForwardClientCertDetails(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SetCurrentClientCertDetails", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SetCurrentClientCertDetails == nil {
				m.SetCurrentClientCertDetails = &HttpConnectionManager_SetCurrentClientCertDetails{}
			}
			if err := m.SetCurrentClientCertDetails.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 18:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Proxy_100Continue", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Proxy_100Continue = bool(v != 0)
		case 19:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field XffNumTrustedHops", wireType)
			}
			m.XffNumTrustedHops = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.XffNumTrustedHops |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 20:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RepresentIpv4RemoteAddressAsIpv4MappedIpv6", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RepresentIpv4RemoteAddressAsIpv4MappedIpv6 = bool(v != 0)
		case 21:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SkipXffAppend", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SkipXffAppend = bool(v != 0)
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Via", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Via = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 23:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpgradeConfigs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UpgradeConfigs = append(m.UpgradeConfigs, &HttpConnectionManager_UpgradeConfig{})
			if err := m.UpgradeConfigs[len(m.UpgradeConfigs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 24:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StreamIdleTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StreamIdleTimeout == nil {
				m.StreamIdleTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.StreamIdleTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 25:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InternalAddressConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.InternalAddressConfig == nil {
				m.InternalAddressConfig = &HttpConnectionManager_InternalAddressConfig{}
			}
			if err := m.InternalAddressConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 26:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DelayedCloseTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DelayedCloseTimeout == nil {
				m.DelayedCloseTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.DelayedCloseTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 28:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RequestTimeout == nil {
				m.RequestTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.RequestTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 29:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxRequestHeadersKb", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MaxRequestHeadersKb == nil {
				m.MaxRequestHeadersKb = &types.UInt32Value{}
			}
			if err := m.MaxRequestHeadersKb.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipHttpConnectionManager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HttpConnectionManager_Tracing) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHttpConnectionManager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Tracing: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Tracing: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OperationName", wireType)
			}
			m.OperationName = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.OperationName |= HttpConnectionManager_Tracing_OperationName(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeadersForTags", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestHeadersForTags = append(m.RequestHeadersForTags, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientSampling", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ClientSampling == nil {
				m.ClientSampling = &_type.Percent{}
			}
			if err := m.ClientSampling.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RandomSampling", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RandomSampling == nil {
				m.RandomSampling = &_type.Percent{}
			}
			if err := m.RandomSampling.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OverallSampling", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OverallSampling == nil {
				m.OverallSampling = &_type.Percent{}
			}
			if err := m.OverallSampling.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Verbose", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Verbose = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipHttpConnectionManager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HttpConnectionManager_InternalAddressConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHttpConnectionManager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InternalAddressConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InternalAddressConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UnixSockets", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UnixSockets = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipHttpConnectionManager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HttpConnectionManager_SetCurrentClientCertDetails) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHttpConnectionManager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SetCurrentClientCertDetails: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SetCurrentClientCertDetails: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subject", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Subject == nil {
				m.Subject = &types.BoolValue{}
			}
			if err := m.Subject.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cert", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Cert = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dns", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Dns = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Uri", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Uri = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipHttpConnectionManager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HttpConnectionManager_UpgradeConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHttpConnectionManager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpgradeConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpgradeConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpgradeType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UpgradeType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Filters = append(m.Filters, &HttpFilter{})
			if err := m.Filters[len(m.Filters)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Enabled", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Enabled == nil {
				m.Enabled = &types.BoolValue{}
			}
			if err := m.Enabled.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipHttpConnectionManager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Rds) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHttpConnectionManager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Rds: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Rds: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConfigSource", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ConfigSource.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RouteConfigName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RouteConfigName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipHttpConnectionManager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HttpFilter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHttpConnectionManager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HttpFilter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HttpFilter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &types.Struct{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ConfigType = &HttpFilter_Config{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TypedConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &types.Any{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ConfigType = &HttpFilter_TypedConfig{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipHttpConnectionManager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthHttpConnectionManager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipHttpConnectionManager(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowHttpConnectionManager
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowHttpConnectionManager
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthHttpConnectionManager
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthHttpConnectionManager
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowHttpConnectionManager
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipHttpConnectionManager(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthHttpConnectionManager
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthHttpConnectionManager = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowHttpConnectionManager   = fmt.Errorf("proto: integer overflow")
)
