// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/api/v2/listener/listener.proto

package listener

import (
	bytes "bytes"
	fmt "fmt"
	io "io"
	math "math"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	types "github.com/gogo/protobuf/types"
	_ "github.com/lyft/protoc-gen-validate/validate"

	auth "github.com/envoyproxy/go-control-plane/envoy/api/v2/auth"
	core "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type FilterChainMatch_ConnectionSourceType int32

const (
	// Any connection source matches.
	FilterChainMatch_ANY FilterChainMatch_ConnectionSourceType = 0
	// Match a connection originating from the same host.
	FilterChainMatch_LOCAL FilterChainMatch_ConnectionSourceType = 1
	// Match a connection originating from a different host.
	FilterChainMatch_EXTERNAL FilterChainMatch_ConnectionSourceType = 2
)

var FilterChainMatch_ConnectionSourceType_name = map[int32]string{
	0: "ANY",
	1: "LOCAL",
	2: "EXTERNAL",
}

var FilterChainMatch_ConnectionSourceType_value = map[string]int32{
	"ANY":      0,
	"LOCAL":    1,
	"EXTERNAL": 2,
}

func (x FilterChainMatch_ConnectionSourceType) String() string {
	return proto.EnumName(FilterChainMatch_ConnectionSourceType_name, int32(x))
}

func (FilterChainMatch_ConnectionSourceType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_0ced541f18749edd, []int{1, 0}
}

type Filter struct {
	// The name of the filter to instantiate. The name must match a supported
	// filter. The built-in filters are:
	//
	// [#comment:TODO(mattklein123): Auto generate the following list]
	// * :ref:`envoy.client_ssl_auth<config_network_filters_client_ssl_auth>`
	// * :ref:`envoy.echo <config_network_filters_echo>`
	// * :ref:`envoy.http_connection_manager <config_http_conn_man>`
	// * :ref:`envoy.mongo_proxy <config_network_filters_mongo_proxy>`
	// * :ref:`envoy.ratelimit <config_network_filters_rate_limit>`
	// * :ref:`envoy.redis_proxy <config_network_filters_redis_proxy>`
	// * :ref:`envoy.tcp_proxy <config_network_filters_tcp_proxy>`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Filter specific configuration which depends on the filter being
	// instantiated. See the supported filters for further documentation.
	//
	// Types that are valid to be assigned to ConfigType:
	//	*Filter_Config
	//	*Filter_TypedConfig
	ConfigType           isFilter_ConfigType `protobuf_oneof:"config_type"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Filter) Reset()         { *m = Filter{} }
func (m *Filter) String() string { return proto.CompactTextString(m) }
func (*Filter) ProtoMessage()    {}
func (*Filter) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ced541f18749edd, []int{0}
}
func (m *Filter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Filter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Filter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Filter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Filter.Merge(m, src)
}
func (m *Filter) XXX_Size() int {
	return m.Size()
}
func (m *Filter) XXX_DiscardUnknown() {
	xxx_messageInfo_Filter.DiscardUnknown(m)
}

var xxx_messageInfo_Filter proto.InternalMessageInfo

type isFilter_ConfigType interface {
	isFilter_ConfigType()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type Filter_Config struct {
	Config *types.Struct `protobuf:"bytes,2,opt,name=config,proto3,oneof"`
}
type Filter_TypedConfig struct {
	TypedConfig *types.Any `protobuf:"bytes,4,opt,name=typed_config,json=typedConfig,proto3,oneof"`
}

func (*Filter_Config) isFilter_ConfigType()      {}
func (*Filter_TypedConfig) isFilter_ConfigType() {}

func (m *Filter) GetConfigType() isFilter_ConfigType {
	if m != nil {
		return m.ConfigType
	}
	return nil
}

func (m *Filter) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Deprecated: Do not use.
func (m *Filter) GetConfig() *types.Struct {
	if x, ok := m.GetConfigType().(*Filter_Config); ok {
		return x.Config
	}
	return nil
}

func (m *Filter) GetTypedConfig() *types.Any {
	if x, ok := m.GetConfigType().(*Filter_TypedConfig); ok {
		return x.TypedConfig
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Filter) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Filter_OneofMarshaler, _Filter_OneofUnmarshaler, _Filter_OneofSizer, []interface{}{
		(*Filter_Config)(nil),
		(*Filter_TypedConfig)(nil),
	}
}

func _Filter_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Filter)
	// config_type
	switch x := m.ConfigType.(type) {
	case *Filter_Config:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Config); err != nil {
			return err
		}
	case *Filter_TypedConfig:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TypedConfig); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Filter.ConfigType has unexpected type %T", x)
	}
	return nil
}

func _Filter_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Filter)
	switch tag {
	case 2: // config_type.config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(types.Struct)
		err := b.DecodeMessage(msg)
		m.ConfigType = &Filter_Config{msg}
		return true, err
	case 4: // config_type.typed_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(types.Any)
		err := b.DecodeMessage(msg)
		m.ConfigType = &Filter_TypedConfig{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Filter_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Filter)
	// config_type
	switch x := m.ConfigType.(type) {
	case *Filter_Config:
		s := proto.Size(x.Config)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Filter_TypedConfig:
		s := proto.Size(x.TypedConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Specifies the match criteria for selecting a specific filter chain for a
// listener.
//
// In order for a filter chain to be selected, *ALL* of its criteria must be
// fulfilled by the incoming connection, properties of which are set by the
// networking stack and/or listener filters.
//
// The following order applies:
//
// 1. Destination port.
// 2. Destination IP address.
// 3. Server name (e.g. SNI for TLS protocol),
// 4. Transport protocol.
// 5. Application protocols (e.g. ALPN for TLS protocol).
// 6. Source type (e.g. any, local or external network).
//
// For criteria that allow ranges or wildcards, the most specific value in any
// of the configured filter chains that matches the incoming connection is going
// to be used (e.g. for SNI ``www.example.com`` the most specific match would be
// ``www.example.com``, then ``*.example.com``, then ``*.com``, then any filter
// chain without ``server_names`` requirements).
//
// [#comment: Implemented rules are kept in the preference order, with deprecated fields
// listed at the end, because that's how we want to list them in the docs.
//
// [#comment:TODO(PiotrSikora): Add support for configurable precedence of the rules]
type FilterChainMatch struct {
	// Optional destination port to consider when use_original_dst is set on the
	// listener in determining a filter chain match.
	DestinationPort *types.UInt32Value `protobuf:"bytes,8,opt,name=destination_port,json=destinationPort,proto3" json:"destination_port,omitempty"`
	// If non-empty, an IP address and prefix length to match addresses when the
	// listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
	PrefixRanges []*core.CidrRange `protobuf:"bytes,3,rep,name=prefix_ranges,json=prefixRanges,proto3" json:"prefix_ranges,omitempty"`
	// If non-empty, an IP address and suffix length to match addresses when the
	// listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
	// [#not-implemented-hide:]
	AddressSuffix string `protobuf:"bytes,4,opt,name=address_suffix,json=addressSuffix,proto3" json:"address_suffix,omitempty"`
	// [#not-implemented-hide:]
	SuffixLen *types.UInt32Value `protobuf:"bytes,5,opt,name=suffix_len,json=suffixLen,proto3" json:"suffix_len,omitempty"`
	// Specifies the connection source IP match type. Can be any, local or external network.
	SourceType FilterChainMatch_ConnectionSourceType `protobuf:"varint,12,opt,name=source_type,json=sourceType,proto3,enum=envoy.api.v2.listener.FilterChainMatch_ConnectionSourceType" json:"source_type,omitempty"`
	// The criteria is satisfied if the source IP address of the downstream
	// connection is contained in at least one of the specified subnets. If the
	// parameter is not specified or the list is empty, the source IP address is
	// ignored.
	// [#not-implemented-hide:]
	SourcePrefixRanges []*core.CidrRange `protobuf:"bytes,6,rep,name=source_prefix_ranges,json=sourcePrefixRanges,proto3" json:"source_prefix_ranges,omitempty"`
	// The criteria is satisfied if the source port of the downstream connection
	// is contained in at least one of the specified ports. If the parameter is
	// not specified, the source port is ignored.
	// [#not-implemented-hide:]
	SourcePorts []*types.UInt32Value `protobuf:"bytes,7,rep,name=source_ports,json=sourcePorts,proto3" json:"source_ports,omitempty"`
	// If non-empty, a list of server names (e.g. SNI for TLS protocol) to consider when determining
	// a filter chain match. Those values will be compared against the server names of a new
	// connection, when detected by one of the listener filters.
	//
	// The server name will be matched against all wildcard domains, i.e. ``www.example.com``
	// will be first matched against ``www.example.com``, then ``*.example.com``, then ``*.com``.
	//
	// Note that partial wildcards are not supported, and values like ``*w.example.com`` are invalid.
	//
	// .. attention::
	//
	//   See the :ref:`FAQ entry <faq_how_to_setup_sni>` on how to configure SNI for more
	//   information.
	ServerNames []string `protobuf:"bytes,11,rep,name=server_names,json=serverNames,proto3" json:"server_names,omitempty"`
	// If non-empty, a transport protocol to consider when determining a filter chain match.
	// This value will be compared against the transport protocol of a new connection, when
	// it's detected by one of the listener filters.
	//
	// Suggested values include:
	//
	// * ``raw_buffer`` - default, used when no transport protocol is detected,
	// * ``tls`` - set by :ref:`envoy.listener.tls_inspector <config_listener_filters_tls_inspector>`
	//   when TLS protocol is detected.
	TransportProtocol string `protobuf:"bytes,9,opt,name=transport_protocol,json=transportProtocol,proto3" json:"transport_protocol,omitempty"`
	// If non-empty, a list of application protocols (e.g. ALPN for TLS protocol) to consider when
	// determining a filter chain match. Those values will be compared against the application
	// protocols of a new connection, when detected by one of the listener filters.
	//
	// Suggested values include:
	//
	// * ``http/1.1`` - set by :ref:`envoy.listener.tls_inspector
	//   <config_listener_filters_tls_inspector>`,
	// * ``h2`` - set by :ref:`envoy.listener.tls_inspector <config_listener_filters_tls_inspector>`
	//
	// .. attention::
	//
	//   Currently, only :ref:`TLS Inspector <config_listener_filters_tls_inspector>` provides
	//   application protocol detection based on the requested
	//   `ALPN <https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation>`_ values.
	//
	//   However, the use of ALPN is pretty much limited to the HTTP/2 traffic on the Internet,
	//   and matching on values other than ``h2`` is going to lead to a lot of false negatives,
	//   unless all connecting clients are known to use ALPN.
	ApplicationProtocols []string `protobuf:"bytes,10,rep,name=application_protocols,json=applicationProtocols,proto3" json:"application_protocols,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FilterChainMatch) Reset()         { *m = FilterChainMatch{} }
func (m *FilterChainMatch) String() string { return proto.CompactTextString(m) }
func (*FilterChainMatch) ProtoMessage()    {}
func (*FilterChainMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ced541f18749edd, []int{1}
}
func (m *FilterChainMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FilterChainMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FilterChainMatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FilterChainMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FilterChainMatch.Merge(m, src)
}
func (m *FilterChainMatch) XXX_Size() int {
	return m.Size()
}
func (m *FilterChainMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_FilterChainMatch.DiscardUnknown(m)
}

var xxx_messageInfo_FilterChainMatch proto.InternalMessageInfo

func (m *FilterChainMatch) GetDestinationPort() *types.UInt32Value {
	if m != nil {
		return m.DestinationPort
	}
	return nil
}

func (m *FilterChainMatch) GetPrefixRanges() []*core.CidrRange {
	if m != nil {
		return m.PrefixRanges
	}
	return nil
}

func (m *FilterChainMatch) GetAddressSuffix() string {
	if m != nil {
		return m.AddressSuffix
	}
	return ""
}

func (m *FilterChainMatch) GetSuffixLen() *types.UInt32Value {
	if m != nil {
		return m.SuffixLen
	}
	return nil
}

func (m *FilterChainMatch) GetSourceType() FilterChainMatch_ConnectionSourceType {
	if m != nil {
		return m.SourceType
	}
	return FilterChainMatch_ANY
}

func (m *FilterChainMatch) GetSourcePrefixRanges() []*core.CidrRange {
	if m != nil {
		return m.SourcePrefixRanges
	}
	return nil
}

func (m *FilterChainMatch) GetSourcePorts() []*types.UInt32Value {
	if m != nil {
		return m.SourcePorts
	}
	return nil
}

func (m *FilterChainMatch) GetServerNames() []string {
	if m != nil {
		return m.ServerNames
	}
	return nil
}

func (m *FilterChainMatch) GetTransportProtocol() string {
	if m != nil {
		return m.TransportProtocol
	}
	return ""
}

func (m *FilterChainMatch) GetApplicationProtocols() []string {
	if m != nil {
		return m.ApplicationProtocols
	}
	return nil
}

// A filter chain wraps a set of match criteria, an option TLS context, a set of filters, and
// various other parameters.
type FilterChain struct {
	// The criteria to use when matching a connection to this filter chain.
	FilterChainMatch *FilterChainMatch `protobuf:"bytes,1,opt,name=filter_chain_match,json=filterChainMatch,proto3" json:"filter_chain_match,omitempty"`
	// The TLS context for this filter chain.
	TlsContext *auth.DownstreamTlsContext `protobuf:"bytes,2,opt,name=tls_context,json=tlsContext,proto3" json:"tls_context,omitempty"`
	// A list of individual network filters that make up the filter chain for
	// connections established with the listener. Order matters as the filters are
	// processed sequentially as connection events happen. Note: If the filter
	// list is empty, the connection will close by default.
	Filters []Filter `protobuf:"bytes,3,rep,name=filters,proto3" json:"filters"`
	// Whether the listener should expect a PROXY protocol V1 header on new
	// connections. If this option is enabled, the listener will assume that that
	// remote address of the connection is the one specified in the header. Some
	// load balancers including the AWS ELB support this option. If the option is
	// absent or set to false, Envoy will use the physical peer address of the
	// connection as the remote address.
	UseProxyProto *types.BoolValue `protobuf:"bytes,4,opt,name=use_proxy_proto,json=useProxyProto,proto3" json:"use_proxy_proto,omitempty"`
	// [#not-implemented-hide:] filter chain metadata.
	Metadata *core.Metadata `protobuf:"bytes,5,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// See :ref:`base.TransportSocket<envoy_api_msg_core.TransportSocket>` description.
	TransportSocket      *core.TransportSocket `protobuf:"bytes,6,opt,name=transport_socket,json=transportSocket,proto3" json:"transport_socket,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *FilterChain) Reset()         { *m = FilterChain{} }
func (m *FilterChain) String() string { return proto.CompactTextString(m) }
func (*FilterChain) ProtoMessage()    {}
func (*FilterChain) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ced541f18749edd, []int{2}
}
func (m *FilterChain) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FilterChain) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FilterChain.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FilterChain) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FilterChain.Merge(m, src)
}
func (m *FilterChain) XXX_Size() int {
	return m.Size()
}
func (m *FilterChain) XXX_DiscardUnknown() {
	xxx_messageInfo_FilterChain.DiscardUnknown(m)
}

var xxx_messageInfo_FilterChain proto.InternalMessageInfo

func (m *FilterChain) GetFilterChainMatch() *FilterChainMatch {
	if m != nil {
		return m.FilterChainMatch
	}
	return nil
}

func (m *FilterChain) GetTlsContext() *auth.DownstreamTlsContext {
	if m != nil {
		return m.TlsContext
	}
	return nil
}

func (m *FilterChain) GetFilters() []Filter {
	if m != nil {
		return m.Filters
	}
	return nil
}

func (m *FilterChain) GetUseProxyProto() *types.BoolValue {
	if m != nil {
		return m.UseProxyProto
	}
	return nil
}

func (m *FilterChain) GetMetadata() *core.Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *FilterChain) GetTransportSocket() *core.TransportSocket {
	if m != nil {
		return m.TransportSocket
	}
	return nil
}

type ListenerFilter struct {
	// The name of the filter to instantiate. The name must match a supported
	// filter. The built-in filters are:
	//
	// [#comment:TODO(mattklein123): Auto generate the following list]
	// * :ref:`envoy.listener.original_dst <config_listener_filters_original_dst>`
	// * :ref:`envoy.listener.tls_inspector <config_listener_filters_tls_inspector>`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Filter specific configuration which depends on the filter being instantiated.
	// See the supported filters for further documentation.
	//
	// Types that are valid to be assigned to ConfigType:
	//	*ListenerFilter_Config
	//	*ListenerFilter_TypedConfig
	ConfigType           isListenerFilter_ConfigType `protobuf_oneof:"config_type"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *ListenerFilter) Reset()         { *m = ListenerFilter{} }
func (m *ListenerFilter) String() string { return proto.CompactTextString(m) }
func (*ListenerFilter) ProtoMessage()    {}
func (*ListenerFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ced541f18749edd, []int{3}
}
func (m *ListenerFilter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListenerFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListenerFilter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListenerFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListenerFilter.Merge(m, src)
}
func (m *ListenerFilter) XXX_Size() int {
	return m.Size()
}
func (m *ListenerFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_ListenerFilter.DiscardUnknown(m)
}

var xxx_messageInfo_ListenerFilter proto.InternalMessageInfo

type isListenerFilter_ConfigType interface {
	isListenerFilter_ConfigType()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type ListenerFilter_Config struct {
	Config *types.Struct `protobuf:"bytes,2,opt,name=config,proto3,oneof"`
}
type ListenerFilter_TypedConfig struct {
	TypedConfig *types.Any `protobuf:"bytes,3,opt,name=typed_config,json=typedConfig,proto3,oneof"`
}

func (*ListenerFilter_Config) isListenerFilter_ConfigType()      {}
func (*ListenerFilter_TypedConfig) isListenerFilter_ConfigType() {}

func (m *ListenerFilter) GetConfigType() isListenerFilter_ConfigType {
	if m != nil {
		return m.ConfigType
	}
	return nil
}

func (m *ListenerFilter) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Deprecated: Do not use.
func (m *ListenerFilter) GetConfig() *types.Struct {
	if x, ok := m.GetConfigType().(*ListenerFilter_Config); ok {
		return x.Config
	}
	return nil
}

func (m *ListenerFilter) GetTypedConfig() *types.Any {
	if x, ok := m.GetConfigType().(*ListenerFilter_TypedConfig); ok {
		return x.TypedConfig
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ListenerFilter) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ListenerFilter_OneofMarshaler, _ListenerFilter_OneofUnmarshaler, _ListenerFilter_OneofSizer, []interface{}{
		(*ListenerFilter_Config)(nil),
		(*ListenerFilter_TypedConfig)(nil),
	}
}

func _ListenerFilter_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ListenerFilter)
	// config_type
	switch x := m.ConfigType.(type) {
	case *ListenerFilter_Config:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Config); err != nil {
			return err
		}
	case *ListenerFilter_TypedConfig:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TypedConfig); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ListenerFilter.ConfigType has unexpected type %T", x)
	}
	return nil
}

func _ListenerFilter_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ListenerFilter)
	switch tag {
	case 2: // config_type.config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(types.Struct)
		err := b.DecodeMessage(msg)
		m.ConfigType = &ListenerFilter_Config{msg}
		return true, err
	case 3: // config_type.typed_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(types.Any)
		err := b.DecodeMessage(msg)
		m.ConfigType = &ListenerFilter_TypedConfig{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ListenerFilter_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ListenerFilter)
	// config_type
	switch x := m.ConfigType.(type) {
	case *ListenerFilter_Config:
		s := proto.Size(x.Config)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ListenerFilter_TypedConfig:
		s := proto.Size(x.TypedConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterEnum("envoy.api.v2.listener.FilterChainMatch_ConnectionSourceType", FilterChainMatch_ConnectionSourceType_name, FilterChainMatch_ConnectionSourceType_value)
	proto.RegisterType((*Filter)(nil), "envoy.api.v2.listener.Filter")
	proto.RegisterType((*FilterChainMatch)(nil), "envoy.api.v2.listener.FilterChainMatch")
	proto.RegisterType((*FilterChain)(nil), "envoy.api.v2.listener.FilterChain")
	proto.RegisterType((*ListenerFilter)(nil), "envoy.api.v2.listener.ListenerFilter")
}

func init() {
	proto.RegisterFile("envoy/api/v2/listener/listener.proto", fileDescriptor_0ced541f18749edd)
}

var fileDescriptor_0ced541f18749edd = []byte{
	// 886 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x54, 0x4d, 0x6f, 0xe3, 0x44,
	0x18, 0xee, 0xc4, 0x69, 0x9a, 0x8c, 0x93, 0xd6, 0x8c, 0xb2, 0xaa, 0x29, 0xbb, 0xd9, 0x10, 0x40,
	0x44, 0x48, 0xd8, 0x52, 0x2a, 0x04, 0x08, 0x10, 0x8a, 0x43, 0x51, 0x59, 0xa5, 0x21, 0x72, 0xba,
	0x15, 0x70, 0xb1, 0xa6, 0xce, 0x24, 0x1d, 0x70, 0x66, 0xac, 0x99, 0x49, 0xb6, 0xb9, 0xf2, 0x6b,
	0x10, 0x07, 0xc4, 0x15, 0x4e, 0x1c, 0xf7, 0xc8, 0x2f, 0x40, 0xd0, 0x1b, 0xbf, 0x62, 0x91, 0xc7,
	0x76, 0x68, 0xd2, 0x68, 0x59, 0x71, 0xd8, 0xdb, 0xcc, 0xfb, 0x3e, 0xcf, 0x33, 0xef, 0xe7, 0xc0,
	0x37, 0x09, 0x5b, 0xf0, 0xa5, 0x8b, 0x63, 0xea, 0x2e, 0x3a, 0x6e, 0x44, 0xa5, 0x22, 0x8c, 0x88,
	0xd5, 0xc1, 0x89, 0x05, 0x57, 0x1c, 0xdd, 0xd3, 0x28, 0x07, 0xc7, 0xd4, 0x59, 0x74, 0x9c, 0xdc,
	0x79, 0xf4, 0x70, 0x8d, 0x1c, 0x72, 0x41, 0x5c, 0x3c, 0x1e, 0x0b, 0x22, 0x65, 0xca, 0x3b, 0xba,
	0xbf, 0x06, 0xc0, 0x73, 0x75, 0xe5, 0x86, 0x44, 0xa8, 0xad, 0x5e, 0x4d, 0xbf, 0xc4, 0x92, 0x64,
	0xde, 0x57, 0xa7, 0x9c, 0x4f, 0x23, 0xe2, 0xea, 0xdb, 0xe5, 0x7c, 0xe2, 0x62, 0xb6, 0xcc, 0x89,
	0x9b, 0x2e, 0xa9, 0xc4, 0x3c, 0xcc, 0x65, 0x1b, 0x9b, 0xde, 0x27, 0x02, 0xc7, 0x31, 0x11, 0x79,
	0x50, 0x87, 0x0b, 0x1c, 0xd1, 0x31, 0x56, 0xc4, 0xcd, 0x0f, 0x99, 0xa3, 0x3e, 0xe5, 0x53, 0xae,
	0x8f, 0x6e, 0x72, 0x4a, 0xad, 0xad, 0x9f, 0x00, 0x2c, 0x7d, 0x4e, 0x23, 0x45, 0x04, 0x7a, 0x00,
	0x8b, 0x0c, 0xcf, 0x88, 0x0d, 0x9a, 0xa0, 0x5d, 0xf1, 0x2a, 0xbf, 0xfe, 0xfd, 0x9b, 0x51, 0x14,
	0x85, 0x26, 0xf0, 0xb5, 0x19, 0xbd, 0x07, 0x4b, 0x21, 0x67, 0x13, 0x3a, 0xb5, 0x0b, 0x4d, 0xd0,
	0x36, 0x3b, 0x87, 0x4e, 0x1a, 0x89, 0x93, 0x47, 0xe2, 0x8c, 0x74, 0x9c, 0x5e, 0xc1, 0x06, 0xa7,
	0x3b, 0x7e, 0x06, 0x46, 0x1f, 0xc2, 0xaa, 0x5a, 0xc6, 0x64, 0x1c, 0x64, 0xe4, 0xa2, 0x26, 0xd7,
	0xef, 0x90, 0xbb, 0x6c, 0x79, 0xba, 0xe3, 0x9b, 0x1a, 0xdb, 0xd3, 0x50, 0xaf, 0x06, 0xcd, 0x94,
	0x14, 0x24, 0xd6, 0x47, 0xc5, 0xb2, 0x61, 0x15, 0x5b, 0x7f, 0xed, 0x42, 0x2b, 0x0d, 0xb8, 0x77,
	0x85, 0x29, 0x3b, 0xc3, 0x2a, 0xbc, 0x42, 0x17, 0xd0, 0x1a, 0x13, 0xa9, 0x28, 0xc3, 0x8a, 0x72,
	0x16, 0xc4, 0x5c, 0x28, 0xbb, 0xac, 0x1f, 0xba, 0x7f, 0xe7, 0xa1, 0xc7, 0x5f, 0x30, 0x75, 0xdc,
	0xb9, 0xc0, 0xd1, 0x9c, 0x78, 0xb5, 0x24, 0xc9, 0xf2, 0x3b, 0x25, 0xfb, 0xd9, 0x33, 0xa3, 0x0d,
	0xfc, 0x83, 0x5b, 0x22, 0x43, 0x2e, 0x14, 0xea, 0xc2, 0x5a, 0x2c, 0xc8, 0x84, 0x5e, 0x07, 0x02,
	0xb3, 0x29, 0x91, 0xb6, 0xd1, 0x34, 0xb4, 0xe8, 0xda, 0xc4, 0x24, 0xbd, 0x75, 0x7a, 0x74, 0x2c,
	0xfc, 0x04, 0xe4, 0x57, 0x53, 0x8a, 0xbe, 0x48, 0xf4, 0x16, 0xdc, 0xcf, 0xa6, 0x26, 0x90, 0xf3,
	0xc9, 0x84, 0x5e, 0xeb, 0x0a, 0x54, 0xfc, 0x5a, 0x66, 0x1d, 0x69, 0x23, 0xfa, 0x08, 0xc2, 0xd4,
	0x1d, 0x44, 0x84, 0xd9, 0xbb, 0xff, 0x1d, 0xbb, 0x5f, 0x49, 0xf1, 0x7d, 0xc2, 0x10, 0x85, 0xa6,
	0xe4, 0x73, 0x11, 0x12, 0x5d, 0x28, 0xbb, 0xda, 0x04, 0xed, 0xfd, 0xce, 0xc7, 0xce, 0xd6, 0xb1,
	0x76, 0x36, 0x8b, 0xe7, 0xf4, 0x38, 0x63, 0x24, 0x4c, 0x72, 0x1e, 0x69, 0x91, 0xf3, 0x65, 0x4c,
	0x3c, 0x98, 0x54, 0x66, 0xf7, 0x7b, 0x50, 0xb0, 0x80, 0x0f, 0xe5, 0xca, 0x8e, 0x06, 0xb0, 0x9e,
	0x3d, 0xb5, 0x5e, 0x98, 0xd2, 0x0b, 0x14, 0x06, 0xa5, 0xcc, 0xe1, 0xed, 0xf2, 0x7c, 0x0a, 0xab,
	0xb9, 0x1e, 0x17, 0x4a, 0xda, 0x7b, 0x99, 0xce, 0xf3, 0x32, 0xcf, 0x92, 0x4d, 0x3a, 0x24, 0xd1,
	0xeb, 0xb0, 0x2a, 0x89, 0x58, 0x10, 0x11, 0x24, 0x53, 0x2a, 0x6d, 0xb3, 0x69, 0xb4, 0x2b, 0xbe,
	0x99, 0xda, 0x06, 0x89, 0x09, 0xbd, 0x0b, 0x91, 0x12, 0x98, 0xc9, 0xe4, 0x85, 0x40, 0x2b, 0x86,
	0x3c, 0xb2, 0x2b, 0xba, 0x0d, 0xaf, 0xac, 0x3c, 0xc3, 0xcc, 0x81, 0x8e, 0xe1, 0x3d, 0x1c, 0xc7,
	0x11, 0x0d, 0xb3, 0x61, 0xca, 0xec, 0xd2, 0x86, 0x5a, 0xba, 0x7e, 0xcb, 0x99, 0x73, 0x64, 0xeb,
	0x03, 0x58, 0xdf, 0x56, 0x47, 0xb4, 0x07, 0x8d, 0xee, 0xe0, 0x6b, 0x6b, 0x07, 0x55, 0xe0, 0x6e,
	0xff, 0xcb, 0x5e, 0xb7, 0x6f, 0x01, 0x54, 0x85, 0xe5, 0x93, 0xaf, 0xce, 0x4f, 0xfc, 0x41, 0xb7,
	0x6f, 0x15, 0x1e, 0x15, 0xcb, 0xc0, 0x2a, 0xf8, 0xa6, 0x64, 0x34, 0x18, 0xf3, 0x19, 0xa6, 0x4c,
	0xb6, 0x7e, 0x31, 0xa0, 0x79, 0xab, 0x4d, 0xe8, 0x31, 0x44, 0x13, 0x7d, 0x0d, 0xc2, 0xe4, 0x1e,
	0xcc, 0x92, 0xbe, 0xe9, 0x3d, 0x35, 0x3b, 0x6f, 0xbf, 0x60, 0x9b, 0x7d, 0x6b, 0xb2, 0xb9, 0x35,
	0xa7, 0xd0, 0x54, 0x91, 0x4c, 0x16, 0x53, 0x91, 0x6b, 0x95, 0xad, 0xf5, 0x86, 0x5e, 0xf2, 0xab,
	0x39, 0x9f, 0xf1, 0x27, 0x4c, 0x2a, 0x41, 0xf0, 0xec, 0x3c, 0x92, 0xbd, 0x14, 0xee, 0x43, 0xb5,
	0x3a, 0xa3, 0x4f, 0xe0, 0x5e, 0xaa, 0x9e, 0x6f, 0xc8, 0x83, 0xe7, 0x46, 0xe5, 0x15, 0x9f, 0xfe,
	0xf1, 0x70, 0xc7, 0xcf, 0x39, 0xc8, 0x83, 0x07, 0x73, 0x99, 0x4c, 0x14, 0xbf, 0x5e, 0xa6, 0xf5,
	0xce, 0xbe, 0x89, 0xa3, 0x3b, 0x73, 0xe0, 0x71, 0x1e, 0xa5, 0x53, 0x50, 0x9b, 0x4b, 0x32, 0x4c,
	0x18, 0xba, 0x09, 0xe8, 0x7d, 0x58, 0x9e, 0x11, 0x85, 0xc7, 0x58, 0xe1, 0x6c, 0x7d, 0x5e, 0xdb,
	0x32, 0x8c, 0x67, 0x19, 0xc4, 0x5f, 0x81, 0xd1, 0x19, 0xb4, 0xfe, 0x9d, 0x0e, 0xc9, 0xc3, 0xef,
	0x88, 0xb2, 0x4b, 0x5a, 0xa0, 0xb5, 0x45, 0xe0, 0x3c, 0x87, 0x8e, 0x34, 0xd2, 0x3f, 0x50, 0xeb,
	0x86, 0xd6, 0xcf, 0x00, 0xee, 0xf7, 0xb3, 0x74, 0x5f, 0xea, 0xc7, 0x6a, 0xfc, 0xdf, 0x8f, 0xd5,
	0xfb, 0xf6, 0x87, 0x9b, 0x06, 0x78, 0x7a, 0xd3, 0x00, 0xbf, 0xdf, 0x34, 0xc0, 0x9f, 0x37, 0x0d,
	0x00, 0xdf, 0xa0, 0x3c, 0xcd, 0x5d, 0xb7, 0x64, 0x7b, 0x2f, 0xbd, 0x5a, 0x9e, 0xa6, 0x6e, 0xc0,
	0x10, 0x7c, 0x53, 0xce, 0x5d, 0x3f, 0x16, 0x0e, 0x4f, 0x34, 0xa5, 0x1b, 0x53, 0xe7, 0xa2, 0xe3,
	0xe4, 0xc0, 0xc1, 0xe8, 0xb2, 0xa4, 0xe3, 0x3a, 0xfe, 0x27, 0x00, 0x00, 0xff, 0xff, 0xf4, 0xb6,
	0x1d, 0x69, 0x9a, 0x07, 0x00, 0x00,
}

func (this *Filter) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Filter)
	if !ok {
		that2, ok := that.(Filter)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if that1.ConfigType == nil {
		if this.ConfigType != nil {
			return false
		}
	} else if this.ConfigType == nil {
		return false
	} else if !this.ConfigType.Equal(that1.ConfigType) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Filter_Config) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Filter_Config)
	if !ok {
		that2, ok := that.(Filter_Config)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Config.Equal(that1.Config) {
		return false
	}
	return true
}
func (this *Filter_TypedConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Filter_TypedConfig)
	if !ok {
		that2, ok := that.(Filter_TypedConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.TypedConfig.Equal(that1.TypedConfig) {
		return false
	}
	return true
}
func (this *FilterChainMatch) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*FilterChainMatch)
	if !ok {
		that2, ok := that.(FilterChainMatch)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.DestinationPort.Equal(that1.DestinationPort) {
		return false
	}
	if len(this.PrefixRanges) != len(that1.PrefixRanges) {
		return false
	}
	for i := range this.PrefixRanges {
		if !this.PrefixRanges[i].Equal(that1.PrefixRanges[i]) {
			return false
		}
	}
	if this.AddressSuffix != that1.AddressSuffix {
		return false
	}
	if !this.SuffixLen.Equal(that1.SuffixLen) {
		return false
	}
	if this.SourceType != that1.SourceType {
		return false
	}
	if len(this.SourcePrefixRanges) != len(that1.SourcePrefixRanges) {
		return false
	}
	for i := range this.SourcePrefixRanges {
		if !this.SourcePrefixRanges[i].Equal(that1.SourcePrefixRanges[i]) {
			return false
		}
	}
	if len(this.SourcePorts) != len(that1.SourcePorts) {
		return false
	}
	for i := range this.SourcePorts {
		if !this.SourcePorts[i].Equal(that1.SourcePorts[i]) {
			return false
		}
	}
	if len(this.ServerNames) != len(that1.ServerNames) {
		return false
	}
	for i := range this.ServerNames {
		if this.ServerNames[i] != that1.ServerNames[i] {
			return false
		}
	}
	if this.TransportProtocol != that1.TransportProtocol {
		return false
	}
	if len(this.ApplicationProtocols) != len(that1.ApplicationProtocols) {
		return false
	}
	for i := range this.ApplicationProtocols {
		if this.ApplicationProtocols[i] != that1.ApplicationProtocols[i] {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *FilterChain) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*FilterChain)
	if !ok {
		that2, ok := that.(FilterChain)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.FilterChainMatch.Equal(that1.FilterChainMatch) {
		return false
	}
	if !this.TlsContext.Equal(that1.TlsContext) {
		return false
	}
	if len(this.Filters) != len(that1.Filters) {
		return false
	}
	for i := range this.Filters {
		if !this.Filters[i].Equal(&that1.Filters[i]) {
			return false
		}
	}
	if !this.UseProxyProto.Equal(that1.UseProxyProto) {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if !this.TransportSocket.Equal(that1.TransportSocket) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ListenerFilter) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ListenerFilter)
	if !ok {
		that2, ok := that.(ListenerFilter)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if that1.ConfigType == nil {
		if this.ConfigType != nil {
			return false
		}
	} else if this.ConfigType == nil {
		return false
	} else if !this.ConfigType.Equal(that1.ConfigType) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ListenerFilter_Config) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ListenerFilter_Config)
	if !ok {
		that2, ok := that.(ListenerFilter_Config)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Config.Equal(that1.Config) {
		return false
	}
	return true
}
func (this *ListenerFilter_TypedConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ListenerFilter_TypedConfig)
	if !ok {
		that2, ok := that.(ListenerFilter_TypedConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.TypedConfig.Equal(that1.TypedConfig) {
		return false
	}
	return true
}
func (m *Filter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Filter) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintListener(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.ConfigType != nil {
		nn1, err := m.ConfigType.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn1
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Filter_Config) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Config != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintListener(dAtA, i, uint64(m.Config.Size()))
		n2, err := m.Config.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	return i, nil
}
func (m *Filter_TypedConfig) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.TypedConfig != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintListener(dAtA, i, uint64(m.TypedConfig.Size()))
		n3, err := m.TypedConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	return i, nil
}
func (m *FilterChainMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FilterChainMatch) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.PrefixRanges) > 0 {
		for _, msg := range m.PrefixRanges {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintListener(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.AddressSuffix) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintListener(dAtA, i, uint64(len(m.AddressSuffix)))
		i += copy(dAtA[i:], m.AddressSuffix)
	}
	if m.SuffixLen != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintListener(dAtA, i, uint64(m.SuffixLen.Size()))
		n4, err := m.SuffixLen.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if len(m.SourcePrefixRanges) > 0 {
		for _, msg := range m.SourcePrefixRanges {
			dAtA[i] = 0x32
			i++
			i = encodeVarintListener(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.SourcePorts) > 0 {
		for _, msg := range m.SourcePorts {
			dAtA[i] = 0x3a
			i++
			i = encodeVarintListener(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.DestinationPort != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintListener(dAtA, i, uint64(m.DestinationPort.Size()))
		n5, err := m.DestinationPort.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if len(m.TransportProtocol) > 0 {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintListener(dAtA, i, uint64(len(m.TransportProtocol)))
		i += copy(dAtA[i:], m.TransportProtocol)
	}
	if len(m.ApplicationProtocols) > 0 {
		for _, s := range m.ApplicationProtocols {
			dAtA[i] = 0x52
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.ServerNames) > 0 {
		for _, s := range m.ServerNames {
			dAtA[i] = 0x5a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.SourceType != 0 {
		dAtA[i] = 0x60
		i++
		i = encodeVarintListener(dAtA, i, uint64(m.SourceType))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *FilterChain) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FilterChain) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.FilterChainMatch != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintListener(dAtA, i, uint64(m.FilterChainMatch.Size()))
		n6, err := m.FilterChainMatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.TlsContext != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintListener(dAtA, i, uint64(m.TlsContext.Size()))
		n7, err := m.TlsContext.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if len(m.Filters) > 0 {
		for _, msg := range m.Filters {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintListener(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.UseProxyProto != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintListener(dAtA, i, uint64(m.UseProxyProto.Size()))
		n8, err := m.UseProxyProto.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.Metadata != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintListener(dAtA, i, uint64(m.Metadata.Size()))
		n9, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.TransportSocket != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintListener(dAtA, i, uint64(m.TransportSocket.Size()))
		n10, err := m.TransportSocket.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ListenerFilter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListenerFilter) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintListener(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.ConfigType != nil {
		nn11, err := m.ConfigType.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn11
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ListenerFilter_Config) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Config != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintListener(dAtA, i, uint64(m.Config.Size()))
		n12, err := m.Config.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	return i, nil
}
func (m *ListenerFilter_TypedConfig) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.TypedConfig != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintListener(dAtA, i, uint64(m.TypedConfig.Size()))
		n13, err := m.TypedConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	return i, nil
}
func encodeVarintListener(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Filter) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovListener(uint64(l))
	}
	if m.ConfigType != nil {
		n += m.ConfigType.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Filter_Config) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Config != nil {
		l = m.Config.Size()
		n += 1 + l + sovListener(uint64(l))
	}
	return n
}
func (m *Filter_TypedConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TypedConfig != nil {
		l = m.TypedConfig.Size()
		n += 1 + l + sovListener(uint64(l))
	}
	return n
}
func (m *FilterChainMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.PrefixRanges) > 0 {
		for _, e := range m.PrefixRanges {
			l = e.Size()
			n += 1 + l + sovListener(uint64(l))
		}
	}
	l = len(m.AddressSuffix)
	if l > 0 {
		n += 1 + l + sovListener(uint64(l))
	}
	if m.SuffixLen != nil {
		l = m.SuffixLen.Size()
		n += 1 + l + sovListener(uint64(l))
	}
	if len(m.SourcePrefixRanges) > 0 {
		for _, e := range m.SourcePrefixRanges {
			l = e.Size()
			n += 1 + l + sovListener(uint64(l))
		}
	}
	if len(m.SourcePorts) > 0 {
		for _, e := range m.SourcePorts {
			l = e.Size()
			n += 1 + l + sovListener(uint64(l))
		}
	}
	if m.DestinationPort != nil {
		l = m.DestinationPort.Size()
		n += 1 + l + sovListener(uint64(l))
	}
	l = len(m.TransportProtocol)
	if l > 0 {
		n += 1 + l + sovListener(uint64(l))
	}
	if len(m.ApplicationProtocols) > 0 {
		for _, s := range m.ApplicationProtocols {
			l = len(s)
			n += 1 + l + sovListener(uint64(l))
		}
	}
	if len(m.ServerNames) > 0 {
		for _, s := range m.ServerNames {
			l = len(s)
			n += 1 + l + sovListener(uint64(l))
		}
	}
	if m.SourceType != 0 {
		n += 1 + sovListener(uint64(m.SourceType))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *FilterChain) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.FilterChainMatch != nil {
		l = m.FilterChainMatch.Size()
		n += 1 + l + sovListener(uint64(l))
	}
	if m.TlsContext != nil {
		l = m.TlsContext.Size()
		n += 1 + l + sovListener(uint64(l))
	}
	if len(m.Filters) > 0 {
		for _, e := range m.Filters {
			l = e.Size()
			n += 1 + l + sovListener(uint64(l))
		}
	}
	if m.UseProxyProto != nil {
		l = m.UseProxyProto.Size()
		n += 1 + l + sovListener(uint64(l))
	}
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovListener(uint64(l))
	}
	if m.TransportSocket != nil {
		l = m.TransportSocket.Size()
		n += 1 + l + sovListener(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListenerFilter) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovListener(uint64(l))
	}
	if m.ConfigType != nil {
		n += m.ConfigType.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListenerFilter_Config) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Config != nil {
		l = m.Config.Size()
		n += 1 + l + sovListener(uint64(l))
	}
	return n
}
func (m *ListenerFilter_TypedConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TypedConfig != nil {
		l = m.TypedConfig.Size()
		n += 1 + l + sovListener(uint64(l))
	}
	return n
}

func sovListener(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozListener(x uint64) (n int) {
	return sovListener(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Filter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowListener
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Filter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Filter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthListener
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthListener
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &types.Struct{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ConfigType = &Filter_Config{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TypedConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthListener
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &types.Any{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ConfigType = &Filter_TypedConfig{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipListener(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthListener
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthListener
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FilterChainMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowListener
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FilterChainMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FilterChainMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrefixRanges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthListener
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PrefixRanges = append(m.PrefixRanges, &core.CidrRange{})
			if err := m.PrefixRanges[len(m.PrefixRanges)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AddressSuffix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthListener
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AddressSuffix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SuffixLen", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthListener
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SuffixLen == nil {
				m.SuffixLen = &types.UInt32Value{}
			}
			if err := m.SuffixLen.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourcePrefixRanges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthListener
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourcePrefixRanges = append(m.SourcePrefixRanges, &core.CidrRange{})
			if err := m.SourcePrefixRanges[len(m.SourcePrefixRanges)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourcePorts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthListener
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourcePorts = append(m.SourcePorts, &types.UInt32Value{})
			if err := m.SourcePorts[len(m.SourcePorts)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationPort", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthListener
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DestinationPort == nil {
				m.DestinationPort = &types.UInt32Value{}
			}
			if err := m.DestinationPort.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TransportProtocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthListener
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TransportProtocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApplicationProtocols", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthListener
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApplicationProtocols = append(m.ApplicationProtocols, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServerNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthListener
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServerNames = append(m.ServerNames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceType", wireType)
			}
			m.SourceType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SourceType |= FilterChainMatch_ConnectionSourceType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipListener(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthListener
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthListener
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FilterChain) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowListener
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FilterChain: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FilterChain: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FilterChainMatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthListener
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FilterChainMatch == nil {
				m.FilterChainMatch = &FilterChainMatch{}
			}
			if err := m.FilterChainMatch.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsContext", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthListener
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TlsContext == nil {
				m.TlsContext = &auth.DownstreamTlsContext{}
			}
			if err := m.TlsContext.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthListener
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Filters = append(m.Filters, Filter{})
			if err := m.Filters[len(m.Filters)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UseProxyProto", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthListener
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UseProxyProto == nil {
				m.UseProxyProto = &types.BoolValue{}
			}
			if err := m.UseProxyProto.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthListener
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &core.Metadata{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TransportSocket", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthListener
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TransportSocket == nil {
				m.TransportSocket = &core.TransportSocket{}
			}
			if err := m.TransportSocket.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipListener(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthListener
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthListener
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListenerFilter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowListener
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListenerFilter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListenerFilter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthListener
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthListener
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &types.Struct{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ConfigType = &ListenerFilter_Config{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TypedConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthListener
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &types.Any{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ConfigType = &ListenerFilter_TypedConfig{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipListener(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthListener
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthListener
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipListener(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowListener
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowListener
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowListener
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthListener
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthListener
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowListener
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipListener(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthListener
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthListener = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowListener   = fmt.Errorf("proto: integer overflow")
)
