// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/api/v2/cds.proto

package v2

import (
	bytes "bytes"
	context "context"
	fmt "fmt"
	io "io"
	math "math"
	time "time"

	_ "github.com/gogo/googleapis/google/api"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	types "github.com/gogo/protobuf/types"
	_ "github.com/lyft/protoc-gen-validate/validate"
	grpc "google.golang.org/grpc"

	auth "github.com/envoyproxy/go-control-plane/envoy/api/v2/auth"
	cluster "github.com/envoyproxy/go-control-plane/envoy/api/v2/cluster"
	core "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
	_type "github.com/envoyproxy/go-control-plane/envoy/type"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Refer to :ref:`service discovery type <arch_overview_service_discovery_types>`
// for an explanation on each type.
type Cluster_DiscoveryType int32

const (
	// Refer to the :ref:`static discovery type<arch_overview_service_discovery_types_static>`
	// for an explanation.
	Cluster_STATIC Cluster_DiscoveryType = 0
	// Refer to the :ref:`strict DNS discovery
	// type<arch_overview_service_discovery_types_strict_dns>`
	// for an explanation.
	Cluster_STRICT_DNS Cluster_DiscoveryType = 1
	// Refer to the :ref:`logical DNS discovery
	// type<arch_overview_service_discovery_types_logical_dns>`
	// for an explanation.
	Cluster_LOGICAL_DNS Cluster_DiscoveryType = 2
	// Refer to the :ref:`service discovery type<arch_overview_service_discovery_types_eds>`
	// for an explanation.
	Cluster_EDS Cluster_DiscoveryType = 3
	// Refer to the :ref:`original destination discovery
	// type<arch_overview_service_discovery_types_original_destination>`
	// for an explanation.
	Cluster_ORIGINAL_DST Cluster_DiscoveryType = 4
)

var Cluster_DiscoveryType_name = map[int32]string{
	0: "STATIC",
	1: "STRICT_DNS",
	2: "LOGICAL_DNS",
	3: "EDS",
	4: "ORIGINAL_DST",
}

var Cluster_DiscoveryType_value = map[string]int32{
	"STATIC":       0,
	"STRICT_DNS":   1,
	"LOGICAL_DNS":  2,
	"EDS":          3,
	"ORIGINAL_DST": 4,
}

func (x Cluster_DiscoveryType) String() string {
	return proto.EnumName(Cluster_DiscoveryType_name, int32(x))
}

func (Cluster_DiscoveryType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e73f50fbb1daa302, []int{0, 0}
}

// Refer to :ref:`load balancer type <arch_overview_load_balancing_types>` architecture
// overview section for information on each type.
type Cluster_LbPolicy int32

const (
	// Refer to the :ref:`round robin load balancing
	// policy<arch_overview_load_balancing_types_round_robin>`
	// for an explanation.
	Cluster_ROUND_ROBIN Cluster_LbPolicy = 0
	// Refer to the :ref:`least request load balancing
	// policy<arch_overview_load_balancing_types_least_request>`
	// for an explanation.
	Cluster_LEAST_REQUEST Cluster_LbPolicy = 1
	// Refer to the :ref:`ring hash load balancing
	// policy<arch_overview_load_balancing_types_ring_hash>`
	// for an explanation.
	Cluster_RING_HASH Cluster_LbPolicy = 2
	// Refer to the :ref:`random load balancing
	// policy<arch_overview_load_balancing_types_random>`
	// for an explanation.
	Cluster_RANDOM Cluster_LbPolicy = 3
	// Refer to the :ref:`original destination load balancing
	// policy<arch_overview_load_balancing_types_original_destination>`
	// for an explanation.
	Cluster_ORIGINAL_DST_LB Cluster_LbPolicy = 4
	// Refer to the :ref:`Maglev load balancing policy<arch_overview_load_balancing_types_maglev>`
	// for an explanation.
	Cluster_MAGLEV Cluster_LbPolicy = 5
)

var Cluster_LbPolicy_name = map[int32]string{
	0: "ROUND_ROBIN",
	1: "LEAST_REQUEST",
	2: "RING_HASH",
	3: "RANDOM",
	4: "ORIGINAL_DST_LB",
	5: "MAGLEV",
}

var Cluster_LbPolicy_value = map[string]int32{
	"ROUND_ROBIN":     0,
	"LEAST_REQUEST":   1,
	"RING_HASH":       2,
	"RANDOM":          3,
	"ORIGINAL_DST_LB": 4,
	"MAGLEV":          5,
}

func (x Cluster_LbPolicy) String() string {
	return proto.EnumName(Cluster_LbPolicy_name, int32(x))
}

func (Cluster_LbPolicy) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e73f50fbb1daa302, []int{0, 1}
}

// When V4_ONLY is selected, the DNS resolver will only perform a lookup for
// addresses in the IPv4 family. If V6_ONLY is selected, the DNS resolver will
// only perform a lookup for addresses in the IPv6 family. If AUTO is
// specified, the DNS resolver will first perform a lookup for addresses in
// the IPv6 family and fallback to a lookup for addresses in the IPv4 family.
// For cluster types other than
// :ref:`STRICT_DNS<envoy_api_enum_value_Cluster.DiscoveryType.STRICT_DNS>` and
// :ref:`LOGICAL_DNS<envoy_api_enum_value_Cluster.DiscoveryType.LOGICAL_DNS>`,
// this setting is
// ignored.
type Cluster_DnsLookupFamily int32

const (
	Cluster_AUTO    Cluster_DnsLookupFamily = 0
	Cluster_V4_ONLY Cluster_DnsLookupFamily = 1
	Cluster_V6_ONLY Cluster_DnsLookupFamily = 2
)

var Cluster_DnsLookupFamily_name = map[int32]string{
	0: "AUTO",
	1: "V4_ONLY",
	2: "V6_ONLY",
}

var Cluster_DnsLookupFamily_value = map[string]int32{
	"AUTO":    0,
	"V4_ONLY": 1,
	"V6_ONLY": 2,
}

func (x Cluster_DnsLookupFamily) String() string {
	return proto.EnumName(Cluster_DnsLookupFamily_name, int32(x))
}

func (Cluster_DnsLookupFamily) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e73f50fbb1daa302, []int{0, 2}
}

type Cluster_ClusterProtocolSelection int32

const (
	// Cluster can only operate on one of the possible upstream protocols (HTTP1.1, HTTP2).
	// If :ref:`http2_protocol_options <envoy_api_field_Cluster.http2_protocol_options>` are
	// present, HTTP2 will be used, otherwise HTTP1.1 will be used.
	Cluster_USE_CONFIGURED_PROTOCOL Cluster_ClusterProtocolSelection = 0
	// Use HTTP1.1 or HTTP2, depending on which one is used on the downstream connection.
	Cluster_USE_DOWNSTREAM_PROTOCOL Cluster_ClusterProtocolSelection = 1
)

var Cluster_ClusterProtocolSelection_name = map[int32]string{
	0: "USE_CONFIGURED_PROTOCOL",
	1: "USE_DOWNSTREAM_PROTOCOL",
}

var Cluster_ClusterProtocolSelection_value = map[string]int32{
	"USE_CONFIGURED_PROTOCOL": 0,
	"USE_DOWNSTREAM_PROTOCOL": 1,
}

func (x Cluster_ClusterProtocolSelection) String() string {
	return proto.EnumName(Cluster_ClusterProtocolSelection_name, int32(x))
}

func (Cluster_ClusterProtocolSelection) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e73f50fbb1daa302, []int{0, 3}
}

// If NO_FALLBACK is selected, a result
// equivalent to no healthy hosts is reported. If ANY_ENDPOINT is selected,
// any cluster endpoint may be returned (subject to policy, health checks,
// etc). If DEFAULT_SUBSET is selected, load balancing is performed over the
// endpoints matching the values from the default_subset field.
type Cluster_LbSubsetConfig_LbSubsetFallbackPolicy int32

const (
	Cluster_LbSubsetConfig_NO_FALLBACK    Cluster_LbSubsetConfig_LbSubsetFallbackPolicy = 0
	Cluster_LbSubsetConfig_ANY_ENDPOINT   Cluster_LbSubsetConfig_LbSubsetFallbackPolicy = 1
	Cluster_LbSubsetConfig_DEFAULT_SUBSET Cluster_LbSubsetConfig_LbSubsetFallbackPolicy = 2
)

var Cluster_LbSubsetConfig_LbSubsetFallbackPolicy_name = map[int32]string{
	0: "NO_FALLBACK",
	1: "ANY_ENDPOINT",
	2: "DEFAULT_SUBSET",
}

var Cluster_LbSubsetConfig_LbSubsetFallbackPolicy_value = map[string]int32{
	"NO_FALLBACK":    0,
	"ANY_ENDPOINT":   1,
	"DEFAULT_SUBSET": 2,
}

func (x Cluster_LbSubsetConfig_LbSubsetFallbackPolicy) String() string {
	return proto.EnumName(Cluster_LbSubsetConfig_LbSubsetFallbackPolicy_name, int32(x))
}

func (Cluster_LbSubsetConfig_LbSubsetFallbackPolicy) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e73f50fbb1daa302, []int{0, 4, 0}
}

// The hash function used to hash hosts onto the ketama ring.
type Cluster_RingHashLbConfig_HashFunction int32

const (
	// Use `xxHash <https://github.com/Cyan4973/xxHash>`_, this is the default hash function.
	Cluster_RingHashLbConfig_XX_HASH Cluster_RingHashLbConfig_HashFunction = 0
	// Use `MurmurHash2 <https://sites.google.com/site/murmurhash/>`_, this is compatible with
	// std:hash<string> in GNU libstdc++ 3.4.20 or above. This is typically the case when compiled
	// on Linux and not macOS.
	Cluster_RingHashLbConfig_MURMUR_HASH_2 Cluster_RingHashLbConfig_HashFunction = 1
)

var Cluster_RingHashLbConfig_HashFunction_name = map[int32]string{
	0: "XX_HASH",
	1: "MURMUR_HASH_2",
}

var Cluster_RingHashLbConfig_HashFunction_value = map[string]int32{
	"XX_HASH":       0,
	"MURMUR_HASH_2": 1,
}

func (x Cluster_RingHashLbConfig_HashFunction) String() string {
	return proto.EnumName(Cluster_RingHashLbConfig_HashFunction_name, int32(x))
}

func (Cluster_RingHashLbConfig_HashFunction) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e73f50fbb1daa302, []int{0, 6, 0}
}

// Configuration for a single upstream cluster.
// [#comment:next free field: 39]
type Cluster struct {
	// Supplies the name of the cluster which must be unique across all clusters.
	// The cluster name is used when emitting
	// :ref:`statistics <config_cluster_manager_cluster_stats>` if :ref:`alt_stat_name
	// <envoy_api_field_Cluster.alt_stat_name>` is not provided.
	// Any ``:`` in the cluster name will be converted to ``_`` when emitting statistics.
	// By default, the maximum length of a cluster name is limited to 60
	// characters. This limit can be increased by setting the
	// :option:`--max-obj-name-len` command line argument to the desired value.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// An optional alternative to the cluster name to be used while emitting stats.
	// Any ``:`` in the name will be converted to ``_`` when emitting statistics. This should not be
	// confused with :ref:`Router Filter Header
	// <config_http_filters_router_x-envoy-upstream-alt-stat-name>`.
	AltStatName string `protobuf:"bytes,28,opt,name=alt_stat_name,json=altStatName,proto3" json:"alt_stat_name,omitempty"`
	// Types that are valid to be assigned to ClusterDiscoveryType:
	//	*Cluster_Type
	//	*Cluster_ClusterType
	ClusterDiscoveryType isCluster_ClusterDiscoveryType `protobuf_oneof:"cluster_discovery_type"`
	// Configuration to use for EDS updates for the Cluster.
	EdsClusterConfig *Cluster_EdsClusterConfig `protobuf:"bytes,3,opt,name=eds_cluster_config,json=edsClusterConfig,proto3" json:"eds_cluster_config,omitempty"`
	// The timeout for new network connections to hosts in the cluster.
	ConnectTimeout time.Duration `protobuf:"bytes,4,opt,name=connect_timeout,json=connectTimeout,proto3,stdduration" json:"connect_timeout"`
	// Soft limit on size of the cluster’s connections read and write buffers. If
	// unspecified, an implementation defined default is applied (1MiB).
	PerConnectionBufferLimitBytes *types.UInt32Value `protobuf:"bytes,5,opt,name=per_connection_buffer_limit_bytes,json=perConnectionBufferLimitBytes,proto3" json:"per_connection_buffer_limit_bytes,omitempty"`
	// The :ref:`load balancer type <arch_overview_load_balancing_types>` to use
	// when picking a host in the cluster.
	LbPolicy Cluster_LbPolicy `protobuf:"varint,6,opt,name=lb_policy,json=lbPolicy,proto3,enum=envoy.api.v2.Cluster_LbPolicy" json:"lb_policy,omitempty"`
	// If the service discovery type is
	// :ref:`STATIC<envoy_api_enum_value_Cluster.DiscoveryType.STATIC>`,
	// :ref:`STRICT_DNS<envoy_api_enum_value_Cluster.DiscoveryType.STRICT_DNS>`
	// or :ref:`LOGICAL_DNS<envoy_api_enum_value_Cluster.DiscoveryType.LOGICAL_DNS>`,
	// then hosts is required.
	//
	// .. attention::
	//
	//   **This field is deprecated**. Set the
	//   :ref:`load_assignment<envoy_api_field_Cluster.load_assignment>` field instead.
	//
	Hosts []*core.Address `protobuf:"bytes,7,rep,name=hosts,proto3" json:"hosts,omitempty"` // Deprecated: Do not use.
	// Setting this is required for specifying members of
	// :ref:`STATIC<envoy_api_enum_value_Cluster.DiscoveryType.STATIC>`,
	// :ref:`STRICT_DNS<envoy_api_enum_value_Cluster.DiscoveryType.STRICT_DNS>`
	// or :ref:`LOGICAL_DNS<envoy_api_enum_value_Cluster.DiscoveryType.LOGICAL_DNS>` clusters.
	// This field supersedes :ref:`hosts<envoy_api_field_Cluster.hosts>` field.
	// [#comment:TODO(dio): Deprecate the hosts field and add it to DEPRECATED.md
	// once load_assignment is implemented.]
	//
	// .. attention::
	//
	//   Setting this allows non-EDS cluster types to contain embedded EDS equivalent
	//   :ref:`endpoint assignments<envoy_api_msg_ClusterLoadAssignment>`.
	//   Setting this overrides :ref:`hosts<envoy_api_field_Cluster.hosts>` values.
	//
	LoadAssignment *ClusterLoadAssignment `protobuf:"bytes,33,opt,name=load_assignment,json=loadAssignment,proto3" json:"load_assignment,omitempty"`
	// Optional :ref:`active health checking <arch_overview_health_checking>`
	// configuration for the cluster. If no
	// configuration is specified no health checking will be done and all cluster
	// members will be considered healthy at all times.
	HealthChecks []*core.HealthCheck `protobuf:"bytes,8,rep,name=health_checks,json=healthChecks,proto3" json:"health_checks,omitempty"`
	// Optional maximum requests for a single upstream connection. This parameter
	// is respected by both the HTTP/1.1 and HTTP/2 connection pool
	// implementations. If not specified, there is no limit. Setting this
	// parameter to 1 will effectively disable keep alive.
	MaxRequestsPerConnection *types.UInt32Value `protobuf:"bytes,9,opt,name=max_requests_per_connection,json=maxRequestsPerConnection,proto3" json:"max_requests_per_connection,omitempty"`
	// Optional :ref:`circuit breaking <arch_overview_circuit_break>` for the cluster.
	CircuitBreakers *cluster.CircuitBreakers `protobuf:"bytes,10,opt,name=circuit_breakers,json=circuitBreakers,proto3" json:"circuit_breakers,omitempty"`
	// The TLS configuration for connections to the upstream cluster. If no TLS
	// configuration is specified, TLS will not be used for new connections.
	//
	// .. attention::
	//
	//   Server certificate verification is not enabled by default. Configure
	//   :ref:`trusted_ca<envoy_api_field_auth.CertificateValidationContext.trusted_ca>` to enable
	//   verification.
	TlsContext *auth.UpstreamTlsContext `protobuf:"bytes,11,opt,name=tls_context,json=tlsContext,proto3" json:"tls_context,omitempty"`
	// Additional options when handling HTTP requests. These options will be applicable to both
	// HTTP1 and HTTP2 requests.
	CommonHttpProtocolOptions *core.HttpProtocolOptions `protobuf:"bytes,29,opt,name=common_http_protocol_options,json=commonHttpProtocolOptions,proto3" json:"common_http_protocol_options,omitempty"`
	// Additional options when handling HTTP1 requests.
	HttpProtocolOptions *core.Http1ProtocolOptions `protobuf:"bytes,13,opt,name=http_protocol_options,json=httpProtocolOptions,proto3" json:"http_protocol_options,omitempty"`
	// Even if default HTTP2 protocol options are desired, this field must be
	// set so that Envoy will assume that the upstream supports HTTP/2 when
	// making new HTTP connection pool connections. Currently, Envoy only
	// supports prior knowledge for upstream connections. Even if TLS is used
	// with ALPN, `http2_protocol_options` must be specified. As an aside this allows HTTP/2
	// connections to happen over plain text.
	Http2ProtocolOptions *core.Http2ProtocolOptions `protobuf:"bytes,14,opt,name=http2_protocol_options,json=http2ProtocolOptions,proto3" json:"http2_protocol_options,omitempty"`
	// The extension_protocol_options field is used to provide extension-specific protocol options
	// for upstream connections. The key should match the extension filter name, such as
	// "envoy.filters.network.thrift_proxy". See the extension's documentation for details on
	// specific options.
	ExtensionProtocolOptions map[string]*types.Struct `protobuf:"bytes,35,rep,name=extension_protocol_options,json=extensionProtocolOptions,proto3" json:"extension_protocol_options,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"` // Deprecated: Do not use.
	// The extension_protocol_options field is used to provide extension-specific protocol options
	// for upstream connections. The key should match the extension filter name, such as
	// "envoy.filters.network.thrift_proxy". See the extension's documentation for details on
	// specific options.
	TypedExtensionProtocolOptions map[string]*types.Any `protobuf:"bytes,36,rep,name=typed_extension_protocol_options,json=typedExtensionProtocolOptions,proto3" json:"typed_extension_protocol_options,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// If the DNS refresh rate is specified and the cluster type is either
	// :ref:`STRICT_DNS<envoy_api_enum_value_Cluster.DiscoveryType.STRICT_DNS>`,
	// or :ref:`LOGICAL_DNS<envoy_api_enum_value_Cluster.DiscoveryType.LOGICAL_DNS>`,
	// this value is used as the cluster’s DNS refresh
	// rate. If this setting is not specified, the value defaults to 5000ms. For
	// cluster types other than
	// :ref:`STRICT_DNS<envoy_api_enum_value_Cluster.DiscoveryType.STRICT_DNS>`
	// and :ref:`LOGICAL_DNS<envoy_api_enum_value_Cluster.DiscoveryType.LOGICAL_DNS>`
	// this setting is ignored.
	DnsRefreshRate *time.Duration `protobuf:"bytes,16,opt,name=dns_refresh_rate,json=dnsRefreshRate,proto3,stdduration" json:"dns_refresh_rate,omitempty"`
	// The DNS IP address resolution policy. If this setting is not specified, the
	// value defaults to
	// :ref:`AUTO<envoy_api_enum_value_Cluster.DnsLookupFamily.AUTO>`.
	DnsLookupFamily Cluster_DnsLookupFamily `protobuf:"varint,17,opt,name=dns_lookup_family,json=dnsLookupFamily,proto3,enum=envoy.api.v2.Cluster_DnsLookupFamily" json:"dns_lookup_family,omitempty"`
	// If DNS resolvers are specified and the cluster type is either
	// :ref:`STRICT_DNS<envoy_api_enum_value_Cluster.DiscoveryType.STRICT_DNS>`,
	// or :ref:`LOGICAL_DNS<envoy_api_enum_value_Cluster.DiscoveryType.LOGICAL_DNS>`,
	// this value is used to specify the cluster’s dns resolvers.
	// If this setting is not specified, the value defaults to the default
	// resolver, which uses /etc/resolv.conf for configuration. For cluster types
	// other than
	// :ref:`STRICT_DNS<envoy_api_enum_value_Cluster.DiscoveryType.STRICT_DNS>`
	// and :ref:`LOGICAL_DNS<envoy_api_enum_value_Cluster.DiscoveryType.LOGICAL_DNS>`
	// this setting is ignored.
	DnsResolvers []*core.Address `protobuf:"bytes,18,rep,name=dns_resolvers,json=dnsResolvers,proto3" json:"dns_resolvers,omitempty"`
	// If specified, outlier detection will be enabled for this upstream cluster.
	// Each of the configuration values can be overridden via
	// :ref:`runtime values <config_cluster_manager_cluster_runtime_outlier_detection>`.
	OutlierDetection *cluster.OutlierDetection `protobuf:"bytes,19,opt,name=outlier_detection,json=outlierDetection,proto3" json:"outlier_detection,omitempty"`
	// The interval for removing stale hosts from a cluster type
	// :ref:`ORIGINAL_DST<envoy_api_enum_value_Cluster.DiscoveryType.ORIGINAL_DST>`.
	// Hosts are considered stale if they have not been used
	// as upstream destinations during this interval. New hosts are added
	// to original destination clusters on demand as new connections are
	// redirected to Envoy, causing the number of hosts in the cluster to
	// grow over time. Hosts that are not stale (they are actively used as
	// destinations) are kept in the cluster, which allows connections to
	// them remain open, saving the latency that would otherwise be spent
	// on opening new connections. If this setting is not specified, the
	// value defaults to 5000ms. For cluster types other than
	// :ref:`ORIGINAL_DST<envoy_api_enum_value_Cluster.DiscoveryType.ORIGINAL_DST>`
	// this setting is ignored.
	CleanupInterval *time.Duration `protobuf:"bytes,20,opt,name=cleanup_interval,json=cleanupInterval,proto3,stdduration" json:"cleanup_interval,omitempty"`
	// Optional configuration used to bind newly established upstream connections.
	// This overrides any bind_config specified in the bootstrap proto.
	// If the address and port are empty, no bind will be performed.
	UpstreamBindConfig *core.BindConfig `protobuf:"bytes,21,opt,name=upstream_bind_config,json=upstreamBindConfig,proto3" json:"upstream_bind_config,omitempty"`
	// Configuration for load balancing subsetting.
	LbSubsetConfig *Cluster_LbSubsetConfig `protobuf:"bytes,22,opt,name=lb_subset_config,json=lbSubsetConfig,proto3" json:"lb_subset_config,omitempty"`
	// Optional configuration for the load balancing algorithm selected by
	// LbPolicy. Currently only
	// :ref:`RING_HASH<envoy_api_enum_value_Cluster.LbPolicy.RING_HASH>` and
	// :ref:`LEAST_REQUEST<envoy_api_enum_value_Cluster.LbPolicy.LEAST_REQUEST>`
	// has additional configuration options.
	// Specifying ring_hash_lb_config or least_request_lb_config without setting the corresponding
	// LbPolicy will generate an error at runtime.
	//
	// Types that are valid to be assigned to LbConfig:
	//	*Cluster_RingHashLbConfig_
	//	*Cluster_OriginalDstLbConfig_
	//	*Cluster_LeastRequestLbConfig_
	LbConfig isCluster_LbConfig `protobuf_oneof:"lb_config"`
	// Common configuration for all load balancer implementations.
	CommonLbConfig *Cluster_CommonLbConfig `protobuf:"bytes,27,opt,name=common_lb_config,json=commonLbConfig,proto3" json:"common_lb_config,omitempty"`
	// Optional custom transport socket implementation to use for upstream connections.
	TransportSocket *core.TransportSocket `protobuf:"bytes,24,opt,name=transport_socket,json=transportSocket,proto3" json:"transport_socket,omitempty"`
	// The Metadata field can be used to provide additional information about the
	// cluster. It can be used for stats, logging, and varying filter behavior.
	// Fields should use reverse DNS notation to denote which entity within Envoy
	// will need the information. For instance, if the metadata is intended for
	// the Router filter, the filter name should be specified as *envoy.router*.
	Metadata *core.Metadata `protobuf:"bytes,25,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Determines how Envoy selects the protocol used to speak to upstream hosts.
	ProtocolSelection Cluster_ClusterProtocolSelection `protobuf:"varint,26,opt,name=protocol_selection,json=protocolSelection,proto3,enum=envoy.api.v2.Cluster_ClusterProtocolSelection" json:"protocol_selection,omitempty"`
	// Optional options for upstream connections.
	UpstreamConnectionOptions *UpstreamConnectionOptions `protobuf:"bytes,30,opt,name=upstream_connection_options,json=upstreamConnectionOptions,proto3" json:"upstream_connection_options,omitempty"`
	// If an upstream host becomes unhealthy (as determined by the configured health checks
	// or outlier detection), immediately close all connections to the failed host.
	//
	// .. note::
	//
	//   This is currently only supported for connections created by tcp_proxy.
	//
	// .. note::
	//
	//   The current implementation of this feature closes all connections immediately when
	//   the unhealthy status is detected. If there are a large number of connections open
	//   to an upstream host that becomes unhealthy, Envoy may spend a substantial amount of
	//   time exclusively closing these connections, and not processing any other traffic.
	CloseConnectionsOnHostHealthFailure bool `protobuf:"varint,31,opt,name=close_connections_on_host_health_failure,json=closeConnectionsOnHostHealthFailure,proto3" json:"close_connections_on_host_health_failure,omitempty"`
	// If this cluster uses EDS or STRICT_DNS to configure its hosts, immediately drain
	// connections from any hosts that are removed from service discovery.
	//
	// This only affects behavior for hosts that are being actively health checked.
	// If this flag is not set to true, Envoy will wait until the hosts fail active health
	// checking before removing it from the cluster.
	DrainConnectionsOnHostRemoval bool     `protobuf:"varint,32,opt,name=drain_connections_on_host_removal,json=drainConnectionsOnHostRemoval,proto3" json:"drain_connections_on_host_removal,omitempty"`
	XXX_NoUnkeyedLiteral          struct{} `json:"-"`
	XXX_unrecognized              []byte   `json:"-"`
	XXX_sizecache                 int32    `json:"-"`
}

func (m *Cluster) Reset()         { *m = Cluster{} }
func (m *Cluster) String() string { return proto.CompactTextString(m) }
func (*Cluster) ProtoMessage()    {}
func (*Cluster) Descriptor() ([]byte, []int) {
	return fileDescriptor_e73f50fbb1daa302, []int{0}
}
func (m *Cluster) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Cluster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *Cluster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster.Merge(m, src)
}
func (m *Cluster) XXX_Size() int {
	return m.Size()
}
func (m *Cluster) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster proto.InternalMessageInfo

type isCluster_ClusterDiscoveryType interface {
	isCluster_ClusterDiscoveryType()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}
type isCluster_LbConfig interface {
	isCluster_LbConfig()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type Cluster_Type struct {
	Type Cluster_DiscoveryType `protobuf:"varint,2,opt,name=type,proto3,enum=envoy.api.v2.Cluster_DiscoveryType,oneof"`
}
type Cluster_ClusterType struct {
	ClusterType *Cluster_CustomClusterType `protobuf:"bytes,38,opt,name=cluster_type,json=clusterType,proto3,oneof"`
}
type Cluster_RingHashLbConfig_ struct {
	RingHashLbConfig *Cluster_RingHashLbConfig `protobuf:"bytes,23,opt,name=ring_hash_lb_config,json=ringHashLbConfig,proto3,oneof"`
}
type Cluster_OriginalDstLbConfig_ struct {
	OriginalDstLbConfig *Cluster_OriginalDstLbConfig `protobuf:"bytes,34,opt,name=original_dst_lb_config,json=originalDstLbConfig,proto3,oneof"`
}
type Cluster_LeastRequestLbConfig_ struct {
	LeastRequestLbConfig *Cluster_LeastRequestLbConfig `protobuf:"bytes,37,opt,name=least_request_lb_config,json=leastRequestLbConfig,proto3,oneof"`
}

func (*Cluster_Type) isCluster_ClusterDiscoveryType()        {}
func (*Cluster_ClusterType) isCluster_ClusterDiscoveryType() {}
func (*Cluster_RingHashLbConfig_) isCluster_LbConfig()       {}
func (*Cluster_OriginalDstLbConfig_) isCluster_LbConfig()    {}
func (*Cluster_LeastRequestLbConfig_) isCluster_LbConfig()   {}

func (m *Cluster) GetClusterDiscoveryType() isCluster_ClusterDiscoveryType {
	if m != nil {
		return m.ClusterDiscoveryType
	}
	return nil
}
func (m *Cluster) GetLbConfig() isCluster_LbConfig {
	if m != nil {
		return m.LbConfig
	}
	return nil
}

func (m *Cluster) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Cluster) GetAltStatName() string {
	if m != nil {
		return m.AltStatName
	}
	return ""
}

func (m *Cluster) GetType() Cluster_DiscoveryType {
	if x, ok := m.GetClusterDiscoveryType().(*Cluster_Type); ok {
		return x.Type
	}
	return Cluster_STATIC
}

func (m *Cluster) GetClusterType() *Cluster_CustomClusterType {
	if x, ok := m.GetClusterDiscoveryType().(*Cluster_ClusterType); ok {
		return x.ClusterType
	}
	return nil
}

func (m *Cluster) GetEdsClusterConfig() *Cluster_EdsClusterConfig {
	if m != nil {
		return m.EdsClusterConfig
	}
	return nil
}

func (m *Cluster) GetConnectTimeout() time.Duration {
	if m != nil {
		return m.ConnectTimeout
	}
	return 0
}

func (m *Cluster) GetPerConnectionBufferLimitBytes() *types.UInt32Value {
	if m != nil {
		return m.PerConnectionBufferLimitBytes
	}
	return nil
}

func (m *Cluster) GetLbPolicy() Cluster_LbPolicy {
	if m != nil {
		return m.LbPolicy
	}
	return Cluster_ROUND_ROBIN
}

// Deprecated: Do not use.
func (m *Cluster) GetHosts() []*core.Address {
	if m != nil {
		return m.Hosts
	}
	return nil
}

func (m *Cluster) GetLoadAssignment() *ClusterLoadAssignment {
	if m != nil {
		return m.LoadAssignment
	}
	return nil
}

func (m *Cluster) GetHealthChecks() []*core.HealthCheck {
	if m != nil {
		return m.HealthChecks
	}
	return nil
}

func (m *Cluster) GetMaxRequestsPerConnection() *types.UInt32Value {
	if m != nil {
		return m.MaxRequestsPerConnection
	}
	return nil
}

func (m *Cluster) GetCircuitBreakers() *cluster.CircuitBreakers {
	if m != nil {
		return m.CircuitBreakers
	}
	return nil
}

func (m *Cluster) GetTlsContext() *auth.UpstreamTlsContext {
	if m != nil {
		return m.TlsContext
	}
	return nil
}

func (m *Cluster) GetCommonHttpProtocolOptions() *core.HttpProtocolOptions {
	if m != nil {
		return m.CommonHttpProtocolOptions
	}
	return nil
}

func (m *Cluster) GetHttpProtocolOptions() *core.Http1ProtocolOptions {
	if m != nil {
		return m.HttpProtocolOptions
	}
	return nil
}

func (m *Cluster) GetHttp2ProtocolOptions() *core.Http2ProtocolOptions {
	if m != nil {
		return m.Http2ProtocolOptions
	}
	return nil
}

// Deprecated: Do not use.
func (m *Cluster) GetExtensionProtocolOptions() map[string]*types.Struct {
	if m != nil {
		return m.ExtensionProtocolOptions
	}
	return nil
}

func (m *Cluster) GetTypedExtensionProtocolOptions() map[string]*types.Any {
	if m != nil {
		return m.TypedExtensionProtocolOptions
	}
	return nil
}

func (m *Cluster) GetDnsRefreshRate() *time.Duration {
	if m != nil {
		return m.DnsRefreshRate
	}
	return nil
}

func (m *Cluster) GetDnsLookupFamily() Cluster_DnsLookupFamily {
	if m != nil {
		return m.DnsLookupFamily
	}
	return Cluster_AUTO
}

func (m *Cluster) GetDnsResolvers() []*core.Address {
	if m != nil {
		return m.DnsResolvers
	}
	return nil
}

func (m *Cluster) GetOutlierDetection() *cluster.OutlierDetection {
	if m != nil {
		return m.OutlierDetection
	}
	return nil
}

func (m *Cluster) GetCleanupInterval() *time.Duration {
	if m != nil {
		return m.CleanupInterval
	}
	return nil
}

func (m *Cluster) GetUpstreamBindConfig() *core.BindConfig {
	if m != nil {
		return m.UpstreamBindConfig
	}
	return nil
}

func (m *Cluster) GetLbSubsetConfig() *Cluster_LbSubsetConfig {
	if m != nil {
		return m.LbSubsetConfig
	}
	return nil
}

func (m *Cluster) GetRingHashLbConfig() *Cluster_RingHashLbConfig {
	if x, ok := m.GetLbConfig().(*Cluster_RingHashLbConfig_); ok {
		return x.RingHashLbConfig
	}
	return nil
}

func (m *Cluster) GetOriginalDstLbConfig() *Cluster_OriginalDstLbConfig {
	if x, ok := m.GetLbConfig().(*Cluster_OriginalDstLbConfig_); ok {
		return x.OriginalDstLbConfig
	}
	return nil
}

func (m *Cluster) GetLeastRequestLbConfig() *Cluster_LeastRequestLbConfig {
	if x, ok := m.GetLbConfig().(*Cluster_LeastRequestLbConfig_); ok {
		return x.LeastRequestLbConfig
	}
	return nil
}

func (m *Cluster) GetCommonLbConfig() *Cluster_CommonLbConfig {
	if m != nil {
		return m.CommonLbConfig
	}
	return nil
}

func (m *Cluster) GetTransportSocket() *core.TransportSocket {
	if m != nil {
		return m.TransportSocket
	}
	return nil
}

func (m *Cluster) GetMetadata() *core.Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Cluster) GetProtocolSelection() Cluster_ClusterProtocolSelection {
	if m != nil {
		return m.ProtocolSelection
	}
	return Cluster_USE_CONFIGURED_PROTOCOL
}

func (m *Cluster) GetUpstreamConnectionOptions() *UpstreamConnectionOptions {
	if m != nil {
		return m.UpstreamConnectionOptions
	}
	return nil
}

func (m *Cluster) GetCloseConnectionsOnHostHealthFailure() bool {
	if m != nil {
		return m.CloseConnectionsOnHostHealthFailure
	}
	return false
}

func (m *Cluster) GetDrainConnectionsOnHostRemoval() bool {
	if m != nil {
		return m.DrainConnectionsOnHostRemoval
	}
	return false
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Cluster) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Cluster_OneofMarshaler, _Cluster_OneofUnmarshaler, _Cluster_OneofSizer, []interface{}{
		(*Cluster_Type)(nil),
		(*Cluster_ClusterType)(nil),
		(*Cluster_RingHashLbConfig_)(nil),
		(*Cluster_OriginalDstLbConfig_)(nil),
		(*Cluster_LeastRequestLbConfig_)(nil),
	}
}

func _Cluster_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Cluster)
	// cluster_discovery_type
	switch x := m.ClusterDiscoveryType.(type) {
	case *Cluster_Type:
		_ = b.EncodeVarint(2<<3 | proto.WireVarint)
		_ = b.EncodeVarint(uint64(x.Type))
	case *Cluster_ClusterType:
		_ = b.EncodeVarint(38<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ClusterType); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Cluster.ClusterDiscoveryType has unexpected type %T", x)
	}
	// lb_config
	switch x := m.LbConfig.(type) {
	case *Cluster_RingHashLbConfig_:
		_ = b.EncodeVarint(23<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RingHashLbConfig); err != nil {
			return err
		}
	case *Cluster_OriginalDstLbConfig_:
		_ = b.EncodeVarint(34<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.OriginalDstLbConfig); err != nil {
			return err
		}
	case *Cluster_LeastRequestLbConfig_:
		_ = b.EncodeVarint(37<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.LeastRequestLbConfig); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Cluster.LbConfig has unexpected type %T", x)
	}
	return nil
}

func _Cluster_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Cluster)
	switch tag {
	case 2: // cluster_discovery_type.type
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.ClusterDiscoveryType = &Cluster_Type{Cluster_DiscoveryType(x)}
		return true, err
	case 38: // cluster_discovery_type.cluster_type
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Cluster_CustomClusterType)
		err := b.DecodeMessage(msg)
		m.ClusterDiscoveryType = &Cluster_ClusterType{msg}
		return true, err
	case 23: // lb_config.ring_hash_lb_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Cluster_RingHashLbConfig)
		err := b.DecodeMessage(msg)
		m.LbConfig = &Cluster_RingHashLbConfig_{msg}
		return true, err
	case 34: // lb_config.original_dst_lb_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Cluster_OriginalDstLbConfig)
		err := b.DecodeMessage(msg)
		m.LbConfig = &Cluster_OriginalDstLbConfig_{msg}
		return true, err
	case 37: // lb_config.least_request_lb_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Cluster_LeastRequestLbConfig)
		err := b.DecodeMessage(msg)
		m.LbConfig = &Cluster_LeastRequestLbConfig_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Cluster_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Cluster)
	// cluster_discovery_type
	switch x := m.ClusterDiscoveryType.(type) {
	case *Cluster_Type:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.Type))
	case *Cluster_ClusterType:
		s := proto.Size(x.ClusterType)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// lb_config
	switch x := m.LbConfig.(type) {
	case *Cluster_RingHashLbConfig_:
		s := proto.Size(x.RingHashLbConfig)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Cluster_OriginalDstLbConfig_:
		s := proto.Size(x.OriginalDstLbConfig)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Cluster_LeastRequestLbConfig_:
		s := proto.Size(x.LeastRequestLbConfig)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Extended cluster type.
type Cluster_CustomClusterType struct {
	// The type of the cluster to instantiate. The name must match a supported cluster type.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Cluster specific configuration which depends on the cluster being instantiated.
	// See the supported cluster for further documentation.
	TypedConfig          *types.Any `protobuf:"bytes,2,opt,name=typed_config,json=typedConfig,proto3" json:"typed_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Cluster_CustomClusterType) Reset()         { *m = Cluster_CustomClusterType{} }
func (m *Cluster_CustomClusterType) String() string { return proto.CompactTextString(m) }
func (*Cluster_CustomClusterType) ProtoMessage()    {}
func (*Cluster_CustomClusterType) Descriptor() ([]byte, []int) {
	return fileDescriptor_e73f50fbb1daa302, []int{0, 0}
}
func (m *Cluster_CustomClusterType) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Cluster_CustomClusterType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *Cluster_CustomClusterType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster_CustomClusterType.Merge(m, src)
}
func (m *Cluster_CustomClusterType) XXX_Size() int {
	return m.Size()
}
func (m *Cluster_CustomClusterType) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster_CustomClusterType.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster_CustomClusterType proto.InternalMessageInfo

func (m *Cluster_CustomClusterType) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Cluster_CustomClusterType) GetTypedConfig() *types.Any {
	if m != nil {
		return m.TypedConfig
	}
	return nil
}

// Only valid when discovery type is EDS.
type Cluster_EdsClusterConfig struct {
	// Configuration for the source of EDS updates for this Cluster.
	EdsConfig *core.ConfigSource `protobuf:"bytes,1,opt,name=eds_config,json=edsConfig,proto3" json:"eds_config,omitempty"`
	// Optional alternative to cluster name to present to EDS. This does not
	// have the same restrictions as cluster name, i.e. it may be arbitrary
	// length.
	ServiceName          string   `protobuf:"bytes,2,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Cluster_EdsClusterConfig) Reset()         { *m = Cluster_EdsClusterConfig{} }
func (m *Cluster_EdsClusterConfig) String() string { return proto.CompactTextString(m) }
func (*Cluster_EdsClusterConfig) ProtoMessage()    {}
func (*Cluster_EdsClusterConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e73f50fbb1daa302, []int{0, 1}
}
func (m *Cluster_EdsClusterConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Cluster_EdsClusterConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *Cluster_EdsClusterConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster_EdsClusterConfig.Merge(m, src)
}
func (m *Cluster_EdsClusterConfig) XXX_Size() int {
	return m.Size()
}
func (m *Cluster_EdsClusterConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster_EdsClusterConfig.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster_EdsClusterConfig proto.InternalMessageInfo

func (m *Cluster_EdsClusterConfig) GetEdsConfig() *core.ConfigSource {
	if m != nil {
		return m.EdsConfig
	}
	return nil
}

func (m *Cluster_EdsClusterConfig) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

// Optionally divide the endpoints in this cluster into subsets defined by
// endpoint metadata and selected by route and weighted cluster metadata.
type Cluster_LbSubsetConfig struct {
	// The behavior used when no endpoint subset matches the selected route's
	// metadata. The value defaults to
	// :ref:`NO_FALLBACK<envoy_api_enum_value_Cluster.LbSubsetConfig.LbSubsetFallbackPolicy.NO_FALLBACK>`.
	FallbackPolicy Cluster_LbSubsetConfig_LbSubsetFallbackPolicy `protobuf:"varint,1,opt,name=fallback_policy,json=fallbackPolicy,proto3,enum=envoy.api.v2.Cluster_LbSubsetConfig_LbSubsetFallbackPolicy" json:"fallback_policy,omitempty"`
	// Specifies the default subset of endpoints used during fallback if
	// fallback_policy is
	// :ref:`DEFAULT_SUBSET<envoy_api_enum_value_Cluster.LbSubsetConfig.LbSubsetFallbackPolicy.DEFAULT_SUBSET>`.
	// Each field in default_subset is
	// compared to the matching LbEndpoint.Metadata under the *envoy.lb*
	// namespace. It is valid for no hosts to match, in which case the behavior
	// is the same as a fallback_policy of
	// :ref:`NO_FALLBACK<envoy_api_enum_value_Cluster.LbSubsetConfig.LbSubsetFallbackPolicy.NO_FALLBACK>`.
	DefaultSubset *types.Struct `protobuf:"bytes,2,opt,name=default_subset,json=defaultSubset,proto3" json:"default_subset,omitempty"`
	// For each entry, LbEndpoint.Metadata's
	// *envoy.lb* namespace is traversed and a subset is created for each unique
	// combination of key and value. For example:
	//
	// .. code-block:: json
	//
	//   { "subset_selectors": [
	//       { "keys": [ "version" ] },
	//       { "keys": [ "stage", "hardware_type" ] }
	//   ]}
	//
	// A subset is matched when the metadata from the selected route and
	// weighted cluster contains the same keys and values as the subset's
	// metadata. The same host may appear in multiple subsets.
	SubsetSelectors []*Cluster_LbSubsetConfig_LbSubsetSelector `protobuf:"bytes,3,rep,name=subset_selectors,json=subsetSelectors,proto3" json:"subset_selectors,omitempty"`
	// If true, routing to subsets will take into account the localities and locality weights of the
	// endpoints when making the routing decision.
	//
	// There are some potential pitfalls associated with enabling this feature, as the resulting
	// traffic split after applying both a subset match and locality weights might be undesirable.
	//
	// Consider for example a situation in which you have 50/50 split across two localities X/Y
	// which have 100 hosts each without subsetting. If the subset LB results in X having only 1
	// host selected but Y having 100, then a lot more load is being dumped on the single host in X
	// than originally anticipated in the load balancing assignment delivered via EDS.
	LocalityWeightAware bool `protobuf:"varint,4,opt,name=locality_weight_aware,json=localityWeightAware,proto3" json:"locality_weight_aware,omitempty"`
	// When used with locality_weight_aware, scales the weight of each locality by the ratio
	// of hosts in the subset vs hosts in the original subset. This aims to even out the load
	// going to an individual locality if said locality is disproportionally affected by the
	// subset predicate.
	ScaleLocalityWeight bool `protobuf:"varint,5,opt,name=scale_locality_weight,json=scaleLocalityWeight,proto3" json:"scale_locality_weight,omitempty"`
	// If true, when a fallback policy is configured and its corresponding subset fails to find
	// a host this will cause any host to be selected instead.
	//
	// This is useful when using the default subset as the fallback policy, given the default
	// subset might become empty. With this option enabled, if that happens the LB will attempt
	// to select a host from the entire cluster.
	PanicModeAny         bool     `protobuf:"varint,6,opt,name=panic_mode_any,json=panicModeAny,proto3" json:"panic_mode_any,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Cluster_LbSubsetConfig) Reset()         { *m = Cluster_LbSubsetConfig{} }
func (m *Cluster_LbSubsetConfig) String() string { return proto.CompactTextString(m) }
func (*Cluster_LbSubsetConfig) ProtoMessage()    {}
func (*Cluster_LbSubsetConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e73f50fbb1daa302, []int{0, 4}
}
func (m *Cluster_LbSubsetConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Cluster_LbSubsetConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *Cluster_LbSubsetConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster_LbSubsetConfig.Merge(m, src)
}
func (m *Cluster_LbSubsetConfig) XXX_Size() int {
	return m.Size()
}
func (m *Cluster_LbSubsetConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster_LbSubsetConfig.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster_LbSubsetConfig proto.InternalMessageInfo

func (m *Cluster_LbSubsetConfig) GetFallbackPolicy() Cluster_LbSubsetConfig_LbSubsetFallbackPolicy {
	if m != nil {
		return m.FallbackPolicy
	}
	return Cluster_LbSubsetConfig_NO_FALLBACK
}

func (m *Cluster_LbSubsetConfig) GetDefaultSubset() *types.Struct {
	if m != nil {
		return m.DefaultSubset
	}
	return nil
}

func (m *Cluster_LbSubsetConfig) GetSubsetSelectors() []*Cluster_LbSubsetConfig_LbSubsetSelector {
	if m != nil {
		return m.SubsetSelectors
	}
	return nil
}

func (m *Cluster_LbSubsetConfig) GetLocalityWeightAware() bool {
	if m != nil {
		return m.LocalityWeightAware
	}
	return false
}

func (m *Cluster_LbSubsetConfig) GetScaleLocalityWeight() bool {
	if m != nil {
		return m.ScaleLocalityWeight
	}
	return false
}

func (m *Cluster_LbSubsetConfig) GetPanicModeAny() bool {
	if m != nil {
		return m.PanicModeAny
	}
	return false
}

// Specifications for subsets.
type Cluster_LbSubsetConfig_LbSubsetSelector struct {
	// List of keys to match with the weighted cluster metadata.
	Keys                 []string `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Cluster_LbSubsetConfig_LbSubsetSelector) Reset() {
	*m = Cluster_LbSubsetConfig_LbSubsetSelector{}
}
func (m *Cluster_LbSubsetConfig_LbSubsetSelector) String() string { return proto.CompactTextString(m) }
func (*Cluster_LbSubsetConfig_LbSubsetSelector) ProtoMessage()    {}
func (*Cluster_LbSubsetConfig_LbSubsetSelector) Descriptor() ([]byte, []int) {
	return fileDescriptor_e73f50fbb1daa302, []int{0, 4, 0}
}
func (m *Cluster_LbSubsetConfig_LbSubsetSelector) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Cluster_LbSubsetConfig_LbSubsetSelector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *Cluster_LbSubsetConfig_LbSubsetSelector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster_LbSubsetConfig_LbSubsetSelector.Merge(m, src)
}
func (m *Cluster_LbSubsetConfig_LbSubsetSelector) XXX_Size() int {
	return m.Size()
}
func (m *Cluster_LbSubsetConfig_LbSubsetSelector) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster_LbSubsetConfig_LbSubsetSelector.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster_LbSubsetConfig_LbSubsetSelector proto.InternalMessageInfo

func (m *Cluster_LbSubsetConfig_LbSubsetSelector) GetKeys() []string {
	if m != nil {
		return m.Keys
	}
	return nil
}

// Specific configuration for the LeastRequest load balancing policy.
type Cluster_LeastRequestLbConfig struct {
	// The number of random healthy hosts from which the host with the fewest active requests will
	// be chosen. Defaults to 2 so that we perform two-choice selection if the field is not set.
	ChoiceCount          *types.UInt32Value `protobuf:"bytes,1,opt,name=choice_count,json=choiceCount,proto3" json:"choice_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *Cluster_LeastRequestLbConfig) Reset()         { *m = Cluster_LeastRequestLbConfig{} }
func (m *Cluster_LeastRequestLbConfig) String() string { return proto.CompactTextString(m) }
func (*Cluster_LeastRequestLbConfig) ProtoMessage()    {}
func (*Cluster_LeastRequestLbConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e73f50fbb1daa302, []int{0, 5}
}
func (m *Cluster_LeastRequestLbConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Cluster_LeastRequestLbConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *Cluster_LeastRequestLbConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster_LeastRequestLbConfig.Merge(m, src)
}
func (m *Cluster_LeastRequestLbConfig) XXX_Size() int {
	return m.Size()
}
func (m *Cluster_LeastRequestLbConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster_LeastRequestLbConfig.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster_LeastRequestLbConfig proto.InternalMessageInfo

func (m *Cluster_LeastRequestLbConfig) GetChoiceCount() *types.UInt32Value {
	if m != nil {
		return m.ChoiceCount
	}
	return nil
}

// Specific configuration for the :ref:`RingHash<arch_overview_load_balancing_types_ring_hash>`
// load balancing policy.
type Cluster_RingHashLbConfig struct {
	// Minimum hash ring size. The larger the ring is (that is, the more hashes there are for each
	// provided host) the better the request distribution will reflect the desired weights. Defaults
	// to 1024 entries, and limited to 8M entries. See also
	// :ref:`maximum_ring_size<envoy_api_field_Cluster.RingHashLbConfig.maximum_ring_size>`.
	MinimumRingSize *types.UInt64Value `protobuf:"bytes,1,opt,name=minimum_ring_size,json=minimumRingSize,proto3" json:"minimum_ring_size,omitempty"`
	// Deprecated settings from v1 config.
	// [#not-implemented-hide:] Hide from docs.
	DeprecatedV1 *Cluster_RingHashLbConfig_DeprecatedV1 `protobuf:"bytes,2,opt,name=deprecated_v1,json=deprecatedV1,proto3" json:"deprecated_v1,omitempty"` // Deprecated: Do not use.
	// The hash function used to hash hosts onto the ketama ring. The value defaults to
	// :ref:`XX_HASH<envoy_api_enum_value_Cluster.RingHashLbConfig.HashFunction.XX_HASH>`.
	HashFunction Cluster_RingHashLbConfig_HashFunction `protobuf:"varint,3,opt,name=hash_function,json=hashFunction,proto3,enum=envoy.api.v2.Cluster_RingHashLbConfig_HashFunction" json:"hash_function,omitempty"`
	// Maximum hash ring size. Defaults to 8M entries, and limited to 8M entries, but can be lowered
	// to further constrain resource use. See also
	// :ref:`minimum_ring_size<envoy_api_field_Cluster.RingHashLbConfig.minimum_ring_size>`.
	MaximumRingSize      *types.UInt64Value `protobuf:"bytes,4,opt,name=maximum_ring_size,json=maximumRingSize,proto3" json:"maximum_ring_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *Cluster_RingHashLbConfig) Reset()         { *m = Cluster_RingHashLbConfig{} }
func (m *Cluster_RingHashLbConfig) String() string { return proto.CompactTextString(m) }
func (*Cluster_RingHashLbConfig) ProtoMessage()    {}
func (*Cluster_RingHashLbConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e73f50fbb1daa302, []int{0, 6}
}
func (m *Cluster_RingHashLbConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Cluster_RingHashLbConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *Cluster_RingHashLbConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster_RingHashLbConfig.Merge(m, src)
}
func (m *Cluster_RingHashLbConfig) XXX_Size() int {
	return m.Size()
}
func (m *Cluster_RingHashLbConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster_RingHashLbConfig.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster_RingHashLbConfig proto.InternalMessageInfo

func (m *Cluster_RingHashLbConfig) GetMinimumRingSize() *types.UInt64Value {
	if m != nil {
		return m.MinimumRingSize
	}
	return nil
}

// Deprecated: Do not use.
func (m *Cluster_RingHashLbConfig) GetDeprecatedV1() *Cluster_RingHashLbConfig_DeprecatedV1 {
	if m != nil {
		return m.DeprecatedV1
	}
	return nil
}

func (m *Cluster_RingHashLbConfig) GetHashFunction() Cluster_RingHashLbConfig_HashFunction {
	if m != nil {
		return m.HashFunction
	}
	return Cluster_RingHashLbConfig_XX_HASH
}

func (m *Cluster_RingHashLbConfig) GetMaximumRingSize() *types.UInt64Value {
	if m != nil {
		return m.MaximumRingSize
	}
	return nil
}

// [#not-implemented-hide:] Hide from docs.
type Cluster_RingHashLbConfig_DeprecatedV1 struct {
	// Defaults to false, meaning that `xxHash <https://github.com/Cyan4973/xxHash>`_
	// is to hash hosts onto the ketama ring.
	UseStdHash           *types.BoolValue `protobuf:"bytes,1,opt,name=use_std_hash,json=useStdHash,proto3" json:"use_std_hash,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Cluster_RingHashLbConfig_DeprecatedV1) Reset()         { *m = Cluster_RingHashLbConfig_DeprecatedV1{} }
func (m *Cluster_RingHashLbConfig_DeprecatedV1) String() string { return proto.CompactTextString(m) }
func (*Cluster_RingHashLbConfig_DeprecatedV1) ProtoMessage()    {}
func (*Cluster_RingHashLbConfig_DeprecatedV1) Descriptor() ([]byte, []int) {
	return fileDescriptor_e73f50fbb1daa302, []int{0, 6, 0}
}
func (m *Cluster_RingHashLbConfig_DeprecatedV1) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Cluster_RingHashLbConfig_DeprecatedV1) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *Cluster_RingHashLbConfig_DeprecatedV1) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster_RingHashLbConfig_DeprecatedV1.Merge(m, src)
}
func (m *Cluster_RingHashLbConfig_DeprecatedV1) XXX_Size() int {
	return m.Size()
}
func (m *Cluster_RingHashLbConfig_DeprecatedV1) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster_RingHashLbConfig_DeprecatedV1.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster_RingHashLbConfig_DeprecatedV1 proto.InternalMessageInfo

func (m *Cluster_RingHashLbConfig_DeprecatedV1) GetUseStdHash() *types.BoolValue {
	if m != nil {
		return m.UseStdHash
	}
	return nil
}

// Specific configuration for the
// :ref:`Original Destination <arch_overview_load_balancing_types_original_destination>`
// load balancing policy.
type Cluster_OriginalDstLbConfig struct {
	// When true, :ref:`x-envoy-original-dst-host
	// <config_http_conn_man_headers_x-envoy-original-dst-host>` can be used to override destination
	// address.
	//
	// .. attention::
	//
	//   This header isn't sanitized by default, so enabling this feature allows HTTP clients to
	//   route traffic to arbitrary hosts and/or ports, which may have serious security
	//   consequences.
	UseHttpHeader        bool     `protobuf:"varint,1,opt,name=use_http_header,json=useHttpHeader,proto3" json:"use_http_header,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Cluster_OriginalDstLbConfig) Reset()         { *m = Cluster_OriginalDstLbConfig{} }
func (m *Cluster_OriginalDstLbConfig) String() string { return proto.CompactTextString(m) }
func (*Cluster_OriginalDstLbConfig) ProtoMessage()    {}
func (*Cluster_OriginalDstLbConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e73f50fbb1daa302, []int{0, 7}
}
func (m *Cluster_OriginalDstLbConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Cluster_OriginalDstLbConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *Cluster_OriginalDstLbConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster_OriginalDstLbConfig.Merge(m, src)
}
func (m *Cluster_OriginalDstLbConfig) XXX_Size() int {
	return m.Size()
}
func (m *Cluster_OriginalDstLbConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster_OriginalDstLbConfig.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster_OriginalDstLbConfig proto.InternalMessageInfo

func (m *Cluster_OriginalDstLbConfig) GetUseHttpHeader() bool {
	if m != nil {
		return m.UseHttpHeader
	}
	return false
}

// Common configuration for all load balancer implementations.
type Cluster_CommonLbConfig struct {
	// Configures the :ref:`healthy panic threshold <arch_overview_load_balancing_panic_threshold>`.
	// If not specified, the default is 50%.
	//
	// .. note::
	//   The specified percent will be truncated to the nearest 1%.
	HealthyPanicThreshold *_type.Percent `protobuf:"bytes,1,opt,name=healthy_panic_threshold,json=healthyPanicThreshold,proto3" json:"healthy_panic_threshold,omitempty"`
	// Types that are valid to be assigned to LocalityConfigSpecifier:
	//	*Cluster_CommonLbConfig_ZoneAwareLbConfig_
	//	*Cluster_CommonLbConfig_LocalityWeightedLbConfig_
	LocalityConfigSpecifier isCluster_CommonLbConfig_LocalityConfigSpecifier `protobuf_oneof:"locality_config_specifier"`
	// If set, all health check/weight/metadata updates that happen within this duration will be
	// merged and delivered in one shot when the duration expires. The start of the duration is when
	// the first update happens. This is useful for big clusters, with potentially noisy deploys
	// that might trigger excessive CPU usage due to a constant stream of healthcheck state changes
	// or metadata updates. The first set of updates to be seen apply immediately (e.g.: a new
	// cluster).
	//
	// If this is not set, we default to a merge window of 1000ms. To disable it, set the merge
	// window to 0.
	//
	// Note: merging does not apply to cluster membership changes (e.g.: adds/removes); this is
	// because merging those updates isn't currently safe. See
	// https://github.com/envoyproxy/envoy/pull/3941.
	UpdateMergeWindow    *types.Duration `protobuf:"bytes,4,opt,name=update_merge_window,json=updateMergeWindow,proto3" json:"update_merge_window,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *Cluster_CommonLbConfig) Reset()         { *m = Cluster_CommonLbConfig{} }
func (m *Cluster_CommonLbConfig) String() string { return proto.CompactTextString(m) }
func (*Cluster_CommonLbConfig) ProtoMessage()    {}
func (*Cluster_CommonLbConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e73f50fbb1daa302, []int{0, 8}
}
func (m *Cluster_CommonLbConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Cluster_CommonLbConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *Cluster_CommonLbConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster_CommonLbConfig.Merge(m, src)
}
func (m *Cluster_CommonLbConfig) XXX_Size() int {
	return m.Size()
}
func (m *Cluster_CommonLbConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster_CommonLbConfig.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster_CommonLbConfig proto.InternalMessageInfo

type isCluster_CommonLbConfig_LocalityConfigSpecifier interface {
	isCluster_CommonLbConfig_LocalityConfigSpecifier()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type Cluster_CommonLbConfig_ZoneAwareLbConfig_ struct {
	ZoneAwareLbConfig *Cluster_CommonLbConfig_ZoneAwareLbConfig `protobuf:"bytes,2,opt,name=zone_aware_lb_config,json=zoneAwareLbConfig,proto3,oneof"`
}
type Cluster_CommonLbConfig_LocalityWeightedLbConfig_ struct {
	LocalityWeightedLbConfig *Cluster_CommonLbConfig_LocalityWeightedLbConfig `protobuf:"bytes,3,opt,name=locality_weighted_lb_config,json=localityWeightedLbConfig,proto3,oneof"`
}

func (*Cluster_CommonLbConfig_ZoneAwareLbConfig_) isCluster_CommonLbConfig_LocalityConfigSpecifier() {}
func (*Cluster_CommonLbConfig_LocalityWeightedLbConfig_) isCluster_CommonLbConfig_LocalityConfigSpecifier() {
}

func (m *Cluster_CommonLbConfig) GetLocalityConfigSpecifier() isCluster_CommonLbConfig_LocalityConfigSpecifier {
	if m != nil {
		return m.LocalityConfigSpecifier
	}
	return nil
}

func (m *Cluster_CommonLbConfig) GetHealthyPanicThreshold() *_type.Percent {
	if m != nil {
		return m.HealthyPanicThreshold
	}
	return nil
}

func (m *Cluster_CommonLbConfig) GetZoneAwareLbConfig() *Cluster_CommonLbConfig_ZoneAwareLbConfig {
	if x, ok := m.GetLocalityConfigSpecifier().(*Cluster_CommonLbConfig_ZoneAwareLbConfig_); ok {
		return x.ZoneAwareLbConfig
	}
	return nil
}

func (m *Cluster_CommonLbConfig) GetLocalityWeightedLbConfig() *Cluster_CommonLbConfig_LocalityWeightedLbConfig {
	if x, ok := m.GetLocalityConfigSpecifier().(*Cluster_CommonLbConfig_LocalityWeightedLbConfig_); ok {
		return x.LocalityWeightedLbConfig
	}
	return nil
}

func (m *Cluster_CommonLbConfig) GetUpdateMergeWindow() *types.Duration {
	if m != nil {
		return m.UpdateMergeWindow
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Cluster_CommonLbConfig) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Cluster_CommonLbConfig_OneofMarshaler, _Cluster_CommonLbConfig_OneofUnmarshaler, _Cluster_CommonLbConfig_OneofSizer, []interface{}{
		(*Cluster_CommonLbConfig_ZoneAwareLbConfig_)(nil),
		(*Cluster_CommonLbConfig_LocalityWeightedLbConfig_)(nil),
	}
}

func _Cluster_CommonLbConfig_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Cluster_CommonLbConfig)
	// locality_config_specifier
	switch x := m.LocalityConfigSpecifier.(type) {
	case *Cluster_CommonLbConfig_ZoneAwareLbConfig_:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ZoneAwareLbConfig); err != nil {
			return err
		}
	case *Cluster_CommonLbConfig_LocalityWeightedLbConfig_:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.LocalityWeightedLbConfig); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Cluster_CommonLbConfig.LocalityConfigSpecifier has unexpected type %T", x)
	}
	return nil
}

func _Cluster_CommonLbConfig_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Cluster_CommonLbConfig)
	switch tag {
	case 2: // locality_config_specifier.zone_aware_lb_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Cluster_CommonLbConfig_ZoneAwareLbConfig)
		err := b.DecodeMessage(msg)
		m.LocalityConfigSpecifier = &Cluster_CommonLbConfig_ZoneAwareLbConfig_{msg}
		return true, err
	case 3: // locality_config_specifier.locality_weighted_lb_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Cluster_CommonLbConfig_LocalityWeightedLbConfig)
		err := b.DecodeMessage(msg)
		m.LocalityConfigSpecifier = &Cluster_CommonLbConfig_LocalityWeightedLbConfig_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Cluster_CommonLbConfig_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Cluster_CommonLbConfig)
	// locality_config_specifier
	switch x := m.LocalityConfigSpecifier.(type) {
	case *Cluster_CommonLbConfig_ZoneAwareLbConfig_:
		s := proto.Size(x.ZoneAwareLbConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Cluster_CommonLbConfig_LocalityWeightedLbConfig_:
		s := proto.Size(x.LocalityWeightedLbConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Configuration for :ref:`zone aware routing
// <arch_overview_load_balancing_zone_aware_routing>`.
type Cluster_CommonLbConfig_ZoneAwareLbConfig struct {
	// Configures percentage of requests that will be considered for zone aware routing
	// if zone aware routing is configured. If not specified, the default is 100%.
	// * :ref:`runtime values <config_cluster_manager_cluster_runtime_zone_routing>`.
	// * :ref:`Zone aware routing support <arch_overview_load_balancing_zone_aware_routing>`.
	RoutingEnabled *_type.Percent `protobuf:"bytes,1,opt,name=routing_enabled,json=routingEnabled,proto3" json:"routing_enabled,omitempty"`
	// Configures minimum upstream cluster size required for zone aware routing
	// If upstream cluster size is less than specified, zone aware routing is not performed
	// even if zone aware routing is configured. If not specified, the default is 6.
	// * :ref:`runtime values <config_cluster_manager_cluster_runtime_zone_routing>`.
	// * :ref:`Zone aware routing support <arch_overview_load_balancing_zone_aware_routing>`.
	MinClusterSize       *types.UInt64Value `protobuf:"bytes,2,opt,name=min_cluster_size,json=minClusterSize,proto3" json:"min_cluster_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) Reset() {
	*m = Cluster_CommonLbConfig_ZoneAwareLbConfig{}
}
func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) String() string { return proto.CompactTextString(m) }
func (*Cluster_CommonLbConfig_ZoneAwareLbConfig) ProtoMessage()    {}
func (*Cluster_CommonLbConfig_ZoneAwareLbConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e73f50fbb1daa302, []int{0, 8, 0}
}
func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster_CommonLbConfig_ZoneAwareLbConfig.Merge(m, src)
}
func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) XXX_Size() int {
	return m.Size()
}
func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster_CommonLbConfig_ZoneAwareLbConfig.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster_CommonLbConfig_ZoneAwareLbConfig proto.InternalMessageInfo

func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) GetRoutingEnabled() *_type.Percent {
	if m != nil {
		return m.RoutingEnabled
	}
	return nil
}

func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) GetMinClusterSize() *types.UInt64Value {
	if m != nil {
		return m.MinClusterSize
	}
	return nil
}

// Configuration for :ref:`locality weighted load balancing
// <arch_overview_load_balancing_locality_weighted_lb>`
type Cluster_CommonLbConfig_LocalityWeightedLbConfig struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig) Reset() {
	*m = Cluster_CommonLbConfig_LocalityWeightedLbConfig{}
}
func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig) String() string {
	return proto.CompactTextString(m)
}
func (*Cluster_CommonLbConfig_LocalityWeightedLbConfig) ProtoMessage() {}
func (*Cluster_CommonLbConfig_LocalityWeightedLbConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e73f50fbb1daa302, []int{0, 8, 1}
}
func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster_CommonLbConfig_LocalityWeightedLbConfig.Merge(m, src)
}
func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig) XXX_Size() int {
	return m.Size()
}
func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster_CommonLbConfig_LocalityWeightedLbConfig.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster_CommonLbConfig_LocalityWeightedLbConfig proto.InternalMessageInfo

// An extensible structure containing the address Envoy should bind to when
// establishing upstream connections.
type UpstreamBindConfig struct {
	// The address Envoy should bind to when establishing upstream connections.
	SourceAddress        *core.Address `protobuf:"bytes,1,opt,name=source_address,json=sourceAddress,proto3" json:"source_address,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *UpstreamBindConfig) Reset()         { *m = UpstreamBindConfig{} }
func (m *UpstreamBindConfig) String() string { return proto.CompactTextString(m) }
func (*UpstreamBindConfig) ProtoMessage()    {}
func (*UpstreamBindConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e73f50fbb1daa302, []int{1}
}
func (m *UpstreamBindConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpstreamBindConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *UpstreamBindConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpstreamBindConfig.Merge(m, src)
}
func (m *UpstreamBindConfig) XXX_Size() int {
	return m.Size()
}
func (m *UpstreamBindConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_UpstreamBindConfig.DiscardUnknown(m)
}

var xxx_messageInfo_UpstreamBindConfig proto.InternalMessageInfo

func (m *UpstreamBindConfig) GetSourceAddress() *core.Address {
	if m != nil {
		return m.SourceAddress
	}
	return nil
}

type UpstreamConnectionOptions struct {
	// If set then set SO_KEEPALIVE on the socket to enable TCP Keepalives.
	TcpKeepalive         *core.TcpKeepalive `protobuf:"bytes,1,opt,name=tcp_keepalive,json=tcpKeepalive,proto3" json:"tcp_keepalive,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *UpstreamConnectionOptions) Reset()         { *m = UpstreamConnectionOptions{} }
func (m *UpstreamConnectionOptions) String() string { return proto.CompactTextString(m) }
func (*UpstreamConnectionOptions) ProtoMessage()    {}
func (*UpstreamConnectionOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_e73f50fbb1daa302, []int{2}
}
func (m *UpstreamConnectionOptions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpstreamConnectionOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *UpstreamConnectionOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpstreamConnectionOptions.Merge(m, src)
}
func (m *UpstreamConnectionOptions) XXX_Size() int {
	return m.Size()
}
func (m *UpstreamConnectionOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_UpstreamConnectionOptions.DiscardUnknown(m)
}

var xxx_messageInfo_UpstreamConnectionOptions proto.InternalMessageInfo

func (m *UpstreamConnectionOptions) GetTcpKeepalive() *core.TcpKeepalive {
	if m != nil {
		return m.TcpKeepalive
	}
	return nil
}

func init() {
	proto.RegisterEnum("envoy.api.v2.Cluster_DiscoveryType", Cluster_DiscoveryType_name, Cluster_DiscoveryType_value)
	proto.RegisterEnum("envoy.api.v2.Cluster_LbPolicy", Cluster_LbPolicy_name, Cluster_LbPolicy_value)
	proto.RegisterEnum("envoy.api.v2.Cluster_DnsLookupFamily", Cluster_DnsLookupFamily_name, Cluster_DnsLookupFamily_value)
	proto.RegisterEnum("envoy.api.v2.Cluster_ClusterProtocolSelection", Cluster_ClusterProtocolSelection_name, Cluster_ClusterProtocolSelection_value)
	proto.RegisterEnum("envoy.api.v2.Cluster_LbSubsetConfig_LbSubsetFallbackPolicy", Cluster_LbSubsetConfig_LbSubsetFallbackPolicy_name, Cluster_LbSubsetConfig_LbSubsetFallbackPolicy_value)
	proto.RegisterEnum("envoy.api.v2.Cluster_RingHashLbConfig_HashFunction", Cluster_RingHashLbConfig_HashFunction_name, Cluster_RingHashLbConfig_HashFunction_value)
	proto.RegisterType((*Cluster)(nil), "envoy.api.v2.Cluster")
	proto.RegisterMapType((map[string]*types.Struct)(nil), "envoy.api.v2.Cluster.ExtensionProtocolOptionsEntry")
	proto.RegisterMapType((map[string]*types.Any)(nil), "envoy.api.v2.Cluster.TypedExtensionProtocolOptionsEntry")
	proto.RegisterType((*Cluster_CustomClusterType)(nil), "envoy.api.v2.Cluster.CustomClusterType")
	proto.RegisterType((*Cluster_EdsClusterConfig)(nil), "envoy.api.v2.Cluster.EdsClusterConfig")
	proto.RegisterType((*Cluster_LbSubsetConfig)(nil), "envoy.api.v2.Cluster.LbSubsetConfig")
	proto.RegisterType((*Cluster_LbSubsetConfig_LbSubsetSelector)(nil), "envoy.api.v2.Cluster.LbSubsetConfig.LbSubsetSelector")
	proto.RegisterType((*Cluster_LeastRequestLbConfig)(nil), "envoy.api.v2.Cluster.LeastRequestLbConfig")
	proto.RegisterType((*Cluster_RingHashLbConfig)(nil), "envoy.api.v2.Cluster.RingHashLbConfig")
	proto.RegisterType((*Cluster_RingHashLbConfig_DeprecatedV1)(nil), "envoy.api.v2.Cluster.RingHashLbConfig.DeprecatedV1")
	proto.RegisterType((*Cluster_OriginalDstLbConfig)(nil), "envoy.api.v2.Cluster.OriginalDstLbConfig")
	proto.RegisterType((*Cluster_CommonLbConfig)(nil), "envoy.api.v2.Cluster.CommonLbConfig")
	proto.RegisterType((*Cluster_CommonLbConfig_ZoneAwareLbConfig)(nil), "envoy.api.v2.Cluster.CommonLbConfig.ZoneAwareLbConfig")
	proto.RegisterType((*Cluster_CommonLbConfig_LocalityWeightedLbConfig)(nil), "envoy.api.v2.Cluster.CommonLbConfig.LocalityWeightedLbConfig")
	proto.RegisterType((*UpstreamBindConfig)(nil), "envoy.api.v2.UpstreamBindConfig")
	proto.RegisterType((*UpstreamConnectionOptions)(nil), "envoy.api.v2.UpstreamConnectionOptions")
}

func init() { proto.RegisterFile("envoy/api/v2/cds.proto", fileDescriptor_e73f50fbb1daa302) }

var fileDescriptor_e73f50fbb1daa302 = []byte{
	// 2652 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x59, 0x4b, 0x73, 0x1b, 0xc7,
	0xb5, 0xe6, 0x80, 0x90, 0x45, 0x35, 0xf1, 0x18, 0x36, 0x29, 0x69, 0x04, 0x4a, 0x14, 0x05, 0x4b,
	0xba, 0xbc, 0x2a, 0x5f, 0xf0, 0x9a, 0xf2, 0xab, 0x1c, 0x3f, 0x0a, 0x2f, 0x8a, 0xb4, 0x41, 0x80,
	0x69, 0x80, 0xa2, 0x1d, 0xc7, 0xd5, 0x6e, 0xcc, 0x34, 0x88, 0x09, 0x07, 0x33, 0x93, 0xe9, 0x1e,
	0x4a, 0xd0, 0x22, 0xe5, 0xb8, 0xb2, 0xc8, 0x3e, 0x9b, 0xe4, 0x1f, 0xa4, 0x92, 0x7f, 0x90, 0xca,
	0x22, 0x4b, 0x67, 0x97, 0xaa, 0x6c, 0xb2, 0x4a, 0x52, 0xaa, 0x2c, 0x92, 0x7f, 0x91, 0x9a, 0xee,
	0x1e, 0x10, 0x8f, 0x01, 0x29, 0xa7, 0xb2, 0x22, 0xfa, 0x9c, 0xef, 0x7c, 0xa7, 0xe7, 0x74, 0xf7,
	0x39, 0xa7, 0x9b, 0xe0, 0x06, 0x75, 0xcf, 0xbc, 0xe1, 0x36, 0xf1, 0xed, 0xed, 0xb3, 0x9d, 0x6d,
	0xd3, 0x62, 0x25, 0x3f, 0xf0, 0xb8, 0x07, 0x33, 0x42, 0x5e, 0x22, 0xbe, 0x5d, 0x3a, 0xdb, 0x29,
	0xdc, 0x9d, 0x44, 0x79, 0x01, 0xdd, 0x26, 0x96, 0x15, 0x50, 0xa6, 0xe0, 0x85, 0xdb, 0x13, 0x00,
	0x12, 0xf2, 0xfe, 0xb6, 0x49, 0x03, 0x9e, 0xa8, 0x15, 0xe6, 0x5d, 0xc2, 0xa8, 0xd2, 0x3e, 0x98,
	0xd5, 0x9a, 0x9e, 0xdb, 0xb3, 0x4f, 0x30, 0xf3, 0xc2, 0xc0, 0xa4, 0x89, 0x24, 0x96, 0xcd, 0x4c,
	0xef, 0x8c, 0x06, 0x43, 0xa5, 0xbd, 0x3f, 0x4b, 0xd2, 0xa7, 0xc4, 0xe1, 0x7d, 0x6c, 0xf6, 0xa9,
	0x79, 0xaa, 0x50, 0x9b, 0xb3, 0x28, 0xa1, 0x30, 0x3d, 0x47, 0x21, 0x1e, 0x4d, 0x22, 0x9c, 0x90,
	0x71, 0x1a, 0x6c, 0x9b, 0x76, 0x60, 0x86, 0x36, 0xc7, 0xdd, 0x80, 0x92, 0x53, 0x1a, 0x28, 0xec,
	0x1b, 0x89, 0x58, 0x2f, 0xe4, 0x8e, 0x4d, 0x03, 0x6c, 0x51, 0x4e, 0x4d, 0x6e, 0x7b, 0xae, 0x42,
	0x4f, 0x46, 0x9a, 0xc6, 0x91, 0x2e, 0x18, 0x52, 0xce, 0x87, 0x3e, 0xdd, 0xf6, 0x69, 0x60, 0x52,
	0x77, 0x14, 0xb6, 0x13, 0xcf, 0x3b, 0x71, 0xa8, 0x30, 0x21, 0xae, 0xeb, 0x71, 0x12, 0xd1, 0xc5,
	0x76, 0xb7, 0x94, 0x56, 0x8c, 0xba, 0x61, 0x6f, 0x9b, 0xb8, 0x71, 0x30, 0x36, 0xa6, 0x55, 0x56,
	0x18, 0x90, 0xb1, 0xa9, 0xdc, 0x9e, 0xd6, 0x33, 0x1e, 0x84, 0x26, 0x9f, 0x67, 0xfd, 0x2c, 0x20,
	0xbe, 0x4f, 0x83, 0xd8, 0xf1, 0xcd, 0x33, 0xe2, 0xd8, 0x16, 0xe1, 0x74, 0x3b, 0xfe, 0xa1, 0x14,
	0x6b, 0x27, 0xde, 0x89, 0x27, 0x7e, 0x6e, 0x47, 0xbf, 0xa4, 0xb4, 0xf8, 0xfb, 0x37, 0xc0, 0xd5,
	0xaa, 0x8c, 0x0d, 0xbc, 0x03, 0xd2, 0x2e, 0x19, 0x50, 0x43, 0xdb, 0xd4, 0xb6, 0xae, 0x55, 0xae,
	0xfd, 0xee, 0x5f, 0x7f, 0x58, 0x4c, 0x07, 0xa9, 0x4d, 0x0d, 0x09, 0x31, 0x2c, 0x82, 0x2c, 0x71,
	0x38, 0x66, 0x9c, 0x70, 0x2c, 0x70, 0xb7, 0x23, 0x1c, 0x5a, 0x26, 0x0e, 0x6f, 0x73, 0xc2, 0x9b,
	0x11, 0xa6, 0x0e, 0xd2, 0x51, 0xa8, 0x8c, 0xd4, 0xa6, 0xb6, 0x95, 0xdb, 0x79, 0xbd, 0x34, 0xbe,
	0x4f, 0x4b, 0xca, 0x4f, 0xa9, 0x16, 0xef, 0x8e, 0xce, 0xd0, 0xa7, 0x15, 0x10, 0xf9, 0xb9, 0xf2,
	0x8d, 0x96, 0xd2, 0xb5, 0xbd, 0x05, 0x24, 0xcc, 0x61, 0x03, 0x64, 0xd4, 0x82, 0x61, 0x41, 0xf7,
	0x70, 0x53, 0xdb, 0x5a, 0xde, 0xf9, 0x9f, 0x64, 0xba, 0x6a, 0xc8, 0xb8, 0x37, 0x50, 0xa3, 0x88,
	0x72, 0x6f, 0x01, 0x2d, 0x9b, 0xe7, 0x43, 0xd8, 0x01, 0x90, 0x5a, 0x0c, 0xc7, 0x8c, 0x72, 0xfb,
	0x1a, 0x8b, 0x82, 0xf3, 0x61, 0x32, 0x67, 0xdd, 0x62, 0xea, 0x67, 0x55, 0xa0, 0x91, 0x4e, 0xa7,
	0x24, 0xf0, 0x29, 0xc8, 0x9b, 0x9e, 0xeb, 0x52, 0x93, 0x63, 0x6e, 0x0f, 0xa8, 0x17, 0x72, 0x23,
	0x2d, 0x28, 0x6f, 0x95, 0xe4, 0x12, 0x95, 0xe2, 0x25, 0x2a, 0xd5, 0xd4, 0x02, 0x57, 0xe0, 0xb7,
	0x7f, 0xbd, 0xbb, 0xf0, 0xcb, 0xbf, 0xdd, 0xd5, 0xc4, 0x37, 0xff, 0x46, 0x4b, 0x3d, 0x5a, 0x40,
	0x39, 0xc5, 0xd2, 0x91, 0x24, 0xb0, 0x07, 0xee, 0xf9, 0x72, 0x96, 0xae, 0xdc, 0xa1, 0xb8, 0x1b,
	0xf6, 0x7a, 0x34, 0xc0, 0x8e, 0x3d, 0x88, 0x36, 0xf9, 0x90, 0x53, 0x66, 0x5c, 0x11, 0x9e, 0x6e,
	0xcf, 0x78, 0x3a, 0xda, 0x77, 0xf9, 0xe3, 0x9d, 0xa7, 0xc4, 0x09, 0x29, 0xba, 0xe3, 0x8b, 0xb9,
	0x2a, 0x96, 0x8a, 0x20, 0x69, 0x44, 0x1c, 0x95, 0x88, 0x02, 0x3e, 0x01, 0xd7, 0x9c, 0x2e, 0xf6,
	0x3d, 0xc7, 0x36, 0x87, 0xc6, 0x6b, 0x62, 0xbd, 0x36, 0x92, 0x83, 0xd1, 0xe8, 0x1e, 0x0a, 0xd4,
	0xf8, 0x52, 0xa1, 0x25, 0x47, 0x49, 0xe1, 0x5b, 0xe0, 0x4a, 0xdf, 0x63, 0x9c, 0x19, 0x57, 0x37,
	0x17, 0xb7, 0x96, 0x77, 0x0a, 0x93, 0x24, 0xd1, 0x31, 0x2e, 0x95, 0x65, 0x3a, 0xaa, 0xa4, 0x0c,
	0x0d, 0x49, 0x30, 0x6c, 0x80, 0xbc, 0xe3, 0x11, 0x0b, 0x13, 0xc6, 0xec, 0x13, 0x77, 0x40, 0x5d,
	0x6e, 0xdc, 0x13, 0x1f, 0x95, 0xbc, 0x69, 0x1a, 0x1e, 0xb1, 0xca, 0x23, 0x28, 0xca, 0x39, 0x13,
	0x63, 0x58, 0x05, 0xd9, 0xf1, 0x84, 0xc2, 0x8c, 0x25, 0x31, 0x97, 0x8d, 0x84, 0xb9, 0xec, 0x09,
	0x5c, 0x35, 0x82, 0xa1, 0x4c, 0xff, 0x7c, 0xc0, 0xe0, 0x17, 0x60, 0x7d, 0x40, 0x9e, 0xe3, 0x80,
	0xfe, 0x38, 0xa4, 0x8c, 0x33, 0x3c, 0xb9, 0x0c, 0xc6, 0xb5, 0x57, 0x88, 0xb9, 0x31, 0x20, 0xcf,
	0x91, 0xb2, 0x3f, 0x1c, 0x0f, 0x3f, 0x3c, 0x04, 0xfa, 0x54, 0x9e, 0x62, 0x06, 0x10, 0x8c, 0x0f,
	0xa6, 0x26, 0x19, 0x6f, 0x6b, 0x89, 0xae, 0x28, 0x30, 0xca, 0x9b, 0x93, 0x02, 0xb8, 0x0b, 0x96,
	0xb9, 0xc3, 0xa2, 0x19, 0x72, 0xfa, 0x9c, 0x1b, 0xcb, 0x49, 0x64, 0x51, 0xae, 0x2f, 0x1d, 0xf9,
	0x8c, 0x07, 0x94, 0x0c, 0x3a, 0x0e, 0xab, 0x4a, 0x30, 0x02, 0x7c, 0xf4, 0x1b, 0x9e, 0x80, 0xdb,
	0xa6, 0x37, 0x18, 0x78, 0x2e, 0xee, 0x73, 0xee, 0xe3, 0x38, 0xe5, 0x62, 0xcf, 0x17, 0x09, 0xcd,
	0xb8, 0x93, 0x74, 0x50, 0x64, 0x28, 0x39, 0xf7, 0x0f, 0x15, 0xbc, 0x25, 0xd1, 0xe8, 0x96, 0xe4,
	0x4a, 0x50, 0xc1, 0x2f, 0xc0, 0xf5, 0x64, 0x0f, 0xd9, 0xa4, 0xe3, 0x3d, 0xf2, 0xf0, 0xe6, 0xb4,
	0x8b, 0xd5, 0x7e, 0x02, 0xf9, 0x97, 0xe0, 0x46, 0x24, 0xde, 0x99, 0x65, 0xcf, 0x5d, 0xc8, 0xbe,
	0x33, 0xcd, 0xbe, 0xd6, 0x4f, 0x90, 0xc2, 0x10, 0x14, 0xe8, 0x73, 0x4e, 0x5d, 0x16, 0x1d, 0xc8,
	0x19, 0x17, 0xaf, 0x8b, 0xdd, 0xf6, 0x78, 0x4e, 0x2e, 0x89, 0xed, 0xa6, 0x38, 0xeb, 0x2e, 0x0f,
	0x86, 0xe2, 0x48, 0x18, 0x74, 0x0e, 0x04, 0xfe, 0x54, 0x03, 0x9b, 0x51, 0x06, 0xb4, 0xf0, 0x05,
	0xde, 0xef, 0x0b, 0xef, 0xef, 0x25, 0x7b, 0x8f, 0x32, 0xa0, 0x75, 0xe1, 0x14, 0xd0, 0x1d, 0x7e,
	0x11, 0x06, 0xb6, 0x81, 0x6e, 0xb9, 0x0c, 0x07, 0xb4, 0x17, 0x50, 0xd6, 0xc7, 0x01, 0xe1, 0xd4,
	0xd0, 0x2f, 0xcb, 0x74, 0xb9, 0xe9, 0x2c, 0x67, 0xb9, 0x0c, 0x49, 0x06, 0x44, 0x38, 0x85, 0x5f,
	0x82, 0x95, 0x88, 0xd4, 0xf1, 0xbc, 0xd3, 0xd0, 0xc7, 0x3d, 0x32, 0xb0, 0x9d, 0xa1, 0xb1, 0x22,
	0xb2, 0xd0, 0x83, 0x39, 0x55, 0xc3, 0x65, 0x0d, 0x81, 0xde, 0x15, 0xe0, 0x89, 0x64, 0x94, 0xb7,
	0x26, 0x95, 0xf0, 0x63, 0x90, 0x95, 0x73, 0x66, 0x9e, 0x73, 0x16, 0x1d, 0x35, 0x78, 0x59, 0x6e,
	0x42, 0x19, 0x31, 0x43, 0x85, 0x87, 0x6d, 0xb0, 0x32, 0xd3, 0x2a, 0x18, 0xab, 0x89, 0x27, 0x41,
	0xcd, 0xaf, 0x25, 0xe1, 0xb5, 0x18, 0x8d, 0x74, 0x6f, 0x4a, 0x02, 0x3b, 0x40, 0x37, 0x1d, 0x4a,
	0xdc, 0xd0, 0xc7, 0xb6, 0xcb, 0x69, 0x70, 0x46, 0x1c, 0x63, 0xed, 0xbb, 0x46, 0x32, 0xaf, 0x28,
	0xf6, 0x15, 0x03, 0x6c, 0x81, 0xb5, 0x50, 0x9d, 0x70, 0xdc, 0xb5, 0x5d, 0x2b, 0x2e, 0x70, 0xd7,
	0x05, 0xf3, 0x9d, 0x84, 0x4f, 0xae, 0xd8, 0xae, 0xa5, 0xea, 0x1a, 0x8c, 0x4d, 0xcf, 0x65, 0xb0,
	0x09, 0x74, 0xa7, 0x8b, 0x59, 0xd8, 0x65, 0x94, 0xc7, 0x64, 0x37, 0x04, 0xd9, 0xfd, 0x79, 0x05,
	0xa2, 0x2d, 0xc0, 0x8a, 0x33, 0xe7, 0x4c, 0x8c, 0xe1, 0x31, 0x58, 0x0d, 0x6c, 0xf7, 0x04, 0xf7,
	0x09, 0xeb, 0x63, 0xa7, 0x1b, 0x53, 0xde, 0xbc, 0xa8, 0x00, 0x23, 0xdb, 0x3d, 0xd9, 0x23, 0xac,
	0xdf, 0xe8, 0x4a, 0x92, 0x3d, 0x0d, 0xe9, 0xc1, 0x94, 0x0c, 0x7e, 0x05, 0x6e, 0x78, 0x81, 0x7d,
	0x62, 0xbb, 0xc4, 0xc1, 0x16, 0xe3, 0x63, 0xdc, 0x45, 0xc1, 0xfd, 0xbf, 0xc9, 0xdc, 0x2d, 0x65,
	0x53, 0x63, 0x7c, 0x8c, 0x7e, 0xd5, 0x9b, 0x15, 0x43, 0x13, 0xdc, 0x74, 0x28, 0x61, 0x3c, 0x2e,
	0x0a, 0x63, 0x2e, 0x1e, 0x08, 0x17, 0x8f, 0xe6, 0x44, 0x24, 0x32, 0x52, 0x85, 0x60, 0xcc, 0xc7,
	0x9a, 0x93, 0x20, 0x8f, 0xe2, 0xad, 0x12, 0xf0, 0x39, 0xfb, 0xfa, 0x45, 0xf1, 0xae, 0x0a, 0x74,
	0x6c, 0x1f, 0x75, 0x10, 0xe3, 0x63, 0x78, 0x00, 0x74, 0x1e, 0x10, 0x97, 0xf9, 0x5e, 0xc0, 0x31,
	0xf3, 0xcc, 0x53, 0xca, 0x0d, 0x43, 0xf0, 0x15, 0x13, 0x36, 0x43, 0x27, 0x86, 0xb6, 0x05, 0x12,
	0xe5, 0xf9, 0xa4, 0x00, 0xbe, 0x0b, 0x96, 0x06, 0x94, 0x13, 0x8b, 0x70, 0x62, 0xdc, 0x12, 0x34,
	0xeb, 0x09, 0x34, 0x07, 0x0a, 0x82, 0x46, 0x60, 0xf8, 0x25, 0x80, 0xa3, 0x5c, 0xc5, 0xa8, 0xa3,
	0x0e, 0x51, 0x41, 0x1c, 0xf2, 0xd2, 0x9c, 0x2f, 0x93, 0x7f, 0xe3, 0x14, 0xd4, 0x8e, 0xad, 0xd0,
	0x8a, 0x3f, 0x2d, 0x82, 0x27, 0x60, 0x7d, 0xb4, 0xef, 0xc7, 0xba, 0xa5, 0x38, 0x2b, 0x6e, 0x24,
	0xa5, 0xfd, 0xb8, 0x14, 0x9e, 0x17, 0xe6, 0x51, 0xdd, 0x0a, 0xe7, 0xa9, 0xe0, 0x11, 0xd8, 0x32,
	0x1d, 0x8f, 0xd1, 0x31, 0x2f, 0x0c, 0x47, 0xe5, 0xd2, 0x63, 0x1c, 0xab, 0xb6, 0xa3, 0x47, 0x6c,
	0x27, 0x0c, 0xa8, 0x71, 0x77, 0x53, 0xdb, 0x5a, 0x42, 0xaf, 0x0b, 0xfc, 0x39, 0x13, 0x6b, 0xb9,
	0x7b, 0x1e, 0xe3, 0xb2, 0xf5, 0xd8, 0x95, 0x50, 0xb8, 0x07, 0xee, 0x59, 0x01, 0xb1, 0xdd, 0x44,
	0xda, 0x80, 0x0e, 0xbc, 0x28, 0x3d, 0x6c, 0x0a, 0xbe, 0x3b, 0x02, 0x38, 0xc3, 0x87, 0x24, 0xa8,
	0x70, 0x0a, 0x56, 0x66, 0x9a, 0xe0, 0xcb, 0xba, 0xf9, 0x77, 0x41, 0x46, 0x16, 0x16, 0xb5, 0xe1,
	0x52, 0x22, 0x5c, 0x6b, 0x33, 0x79, 0xa8, 0xec, 0x0e, 0xd1, 0xb2, 0x40, 0xca, 0xdd, 0x55, 0x08,
	0x81, 0x3e, 0xdd, 0x1d, 0xc3, 0x8f, 0x00, 0x10, 0x1d, 0xb6, 0xa4, 0xd2, 0x04, 0xd5, 0xdd, 0x84,
	0x4d, 0x22, 0xe1, 0x6d, 0x71, 0x71, 0x44, 0xd7, 0xa2, 0x96, 0x5a, 0xda, 0xdf, 0x03, 0x19, 0x46,
	0x83, 0x33, 0xdb, 0xa4, 0xf2, 0x66, 0x91, 0x92, 0x37, 0x0b, 0x25, 0x8b, 0x6e, 0x16, 0x05, 0x0b,
	0xdc, 0xb9, 0xb0, 0x8a, 0x41, 0x1d, 0x2c, 0x9e, 0xd2, 0xa1, 0xfc, 0x5c, 0x14, 0xfd, 0x84, 0xff,
	0x07, 0xae, 0x9c, 0x45, 0x5d, 0x99, 0xfa, 0xb6, 0x9b, 0x33, 0xdf, 0xd6, 0x16, 0x17, 0x2b, 0x24,
	0x51, 0xef, 0xa7, 0xde, 0xd3, 0x0a, 0x3d, 0x50, 0xbc, 0xbc, 0x60, 0x26, 0xb8, 0x7a, 0x34, 0xe9,
	0x2a, 0x39, 0x8c, 0x63, 0x7e, 0x7e, 0x9b, 0x06, 0xb9, 0xc9, 0xac, 0x09, 0x7d, 0x90, 0xef, 0x11,
	0xc7, 0xe9, 0x12, 0xf3, 0x34, 0xee, 0xca, 0x35, 0x71, 0x54, 0xbe, 0xf7, 0x2a, 0x49, 0x77, 0x34,
	0xdc, 0x55, 0x1c, 0x09, 0x2d, 0x7b, 0xae, 0x37, 0xa1, 0x83, 0x1f, 0x81, 0x9c, 0x45, 0x7b, 0x24,
	0x8c, 0x2e, 0x75, 0xc2, 0xf6, 0xb2, 0x40, 0x65, 0x15, 0x5c, 0x7a, 0x82, 0x5f, 0x01, 0x5d, 0x15,
	0x09, 0x79, 0xba, 0xbd, 0x80, 0x19, 0x8b, 0xa2, 0xce, 0xbe, 0xfd, 0x9d, 0xa6, 0xdc, 0x56, 0xd6,
	0x28, 0xcf, 0x26, 0xc6, 0x0c, 0xee, 0x80, 0xeb, 0x8e, 0x67, 0x12, 0xc7, 0xe6, 0x43, 0xfc, 0x8c,
	0xda, 0x27, 0x7d, 0x8e, 0xc9, 0x33, 0x12, 0x50, 0x71, 0xd3, 0x5a, 0x42, 0xab, 0xb1, 0xf2, 0x58,
	0xe8, 0xca, 0x91, 0x2a, 0xb2, 0x61, 0x26, 0x71, 0x28, 0x9e, 0xb2, 0x14, 0x77, 0xa6, 0x25, 0xb4,
	0x2a, 0x94, 0x8d, 0x09, 0x43, 0x78, 0x1f, 0xe4, 0x7c, 0xe2, 0xda, 0x26, 0x1e, 0x78, 0x16, 0xc5,
	0xc4, 0x95, 0x17, 0xa2, 0x25, 0x94, 0x11, 0xd2, 0x03, 0xcf, 0xa2, 0x65, 0x77, 0x58, 0x78, 0x08,
	0xf4, 0xe9, 0x29, 0x43, 0x08, 0xd2, 0xa7, 0x74, 0xc8, 0x0c, 0x6d, 0x73, 0x71, 0xeb, 0x1a, 0x12,
	0xbf, 0x8b, 0x2d, 0x70, 0x23, 0x79, 0x35, 0x60, 0x1e, 0x2c, 0x37, 0x5b, 0x78, 0xb7, 0xdc, 0x68,
	0x54, 0xca, 0xd5, 0x4f, 0xf5, 0x05, 0xa8, 0x83, 0x4c, 0xb9, 0xf9, 0x39, 0xae, 0x37, 0x6b, 0x87,
	0xad, 0xfd, 0x66, 0x47, 0xd7, 0x20, 0x04, 0xb9, 0x5a, 0x7d, 0xb7, 0x7c, 0xd4, 0xe8, 0xe0, 0xf6,
	0x51, 0xa5, 0x5d, 0xef, 0xe8, 0xa9, 0x42, 0x17, 0xac, 0x25, 0x15, 0x14, 0xf8, 0x09, 0xc8, 0x98,
	0x7d, 0x2f, 0x3a, 0x35, 0xa6, 0x17, 0xba, 0x5c, 0x1d, 0xbc, 0x0b, 0x6f, 0x28, 0x2a, 0x11, 0x3c,
	0x4a, 0x6d, 0xa5, 0xd0, 0xb2, 0x34, 0xae, 0x46, 0xb6, 0x85, 0x9f, 0xa5, 0x81, 0x3e, 0x5d, 0x74,
	0xe1, 0x53, 0xb0, 0x32, 0xb0, 0x5d, 0x7b, 0x10, 0x0e, 0xb0, 0xa8, 0xe0, 0xcc, 0x7e, 0x41, 0x2f,
	0xf4, 0xf2, 0xce, 0x5b, 0xd2, 0x4b, 0x26, 0xf2, 0x72, 0x75, 0xe7, 0x8a, 0xf1, 0xf5, 0xd7, 0x5f,
	0xa7, 0x51, 0x5e, 0x91, 0x44, 0xfc, 0x6d, 0xfb, 0x05, 0x85, 0x3f, 0x04, 0x59, 0x8b, 0xfa, 0x01,
	0x35, 0x09, 0xa7, 0x16, 0x3e, 0x7b, 0x53, 0x6d, 0xbc, 0xc7, 0xaf, 0xd6, 0x0b, 0x94, 0x6a, 0x23,
	0xdb, 0xa7, 0x6f, 0x8a, 0x06, 0x3a, 0x63, 0x8d, 0x49, 0xa0, 0x05, 0xb2, 0xa2, 0xd5, 0xe8, 0x85,
	0xae, 0x2c, 0x39, 0x8b, 0xe2, 0x1c, 0xbd, 0x2a, 0x7b, 0x34, 0xd8, 0x55, 0xa6, 0x13, 0xe7, 0x27,
	0xd3, 0x1f, 0xd3, 0x88, 0xd8, 0x90, 0xe7, 0x53, 0xb1, 0x49, 0xff, 0x07, 0xb1, 0x91, 0x24, 0x71,
	0x6c, 0x0a, 0x0d, 0x90, 0x19, 0xff, 0x3e, 0xf8, 0x01, 0xc8, 0x84, 0x8c, 0x62, 0xc6, 0x2d, 0xd1,
	0x40, 0xa9, 0xf0, 0x17, 0x66, 0x5c, 0x54, 0x3c, 0xcf, 0x91, 0x97, 0x50, 0x10, 0x32, 0xda, 0xe6,
	0x56, 0xf4, 0x1d, 0xc5, 0x12, 0xc8, 0x8c, 0x7f, 0x0f, 0x5c, 0x06, 0x57, 0x3f, 0xfb, 0x0c, 0xef,
	0x95, 0xdb, 0x7b, 0xfa, 0x02, 0x5c, 0x01, 0xd9, 0x83, 0x23, 0x74, 0x70, 0x84, 0x84, 0x00, 0xef,
	0xe8, 0x5a, 0xe1, 0x43, 0xb0, 0x9a, 0xd0, 0x1e, 0xc1, 0x87, 0x20, 0x1f, 0x4d, 0x42, 0x5c, 0xdf,
	0xfa, 0x94, 0x58, 0x34, 0x10, 0xf3, 0x58, 0x42, 0xd9, 0x90, 0xd1, 0xe8, 0x1a, 0xb5, 0x27, 0x84,
	0x85, 0x7f, 0xa6, 0x41, 0x6e, 0xb2, 0x3b, 0x81, 0x9f, 0x82, 0x9b, 0xb2, 0x46, 0x0e, 0xb1, 0x3c,
	0x63, 0xbc, 0x1f, 0xdd, 0x02, 0x3c, 0xc7, 0x52, 0x9f, 0xb2, 0xaa, 0xd6, 0x25, 0x2a, 0x32, 0xa5,
	0x43, 0xf9, 0xc6, 0x86, 0xae, 0x2b, 0x9b, 0xc3, 0xc8, 0xa4, 0x13, 0x5b, 0x40, 0x1b, 0xac, 0xbd,
	0xf0, 0x5c, 0x2a, 0xb3, 0xc0, 0x58, 0xbb, 0x24, 0xf7, 0xcf, 0x3b, 0xaf, 0xd2, 0x2e, 0x95, 0x7e,
	0xe0, 0xb9, 0x54, 0xa4, 0x8a, 0x51, 0x63, 0xb6, 0x80, 0x56, 0x5e, 0x4c, 0x0b, 0xe1, 0x4f, 0xc0,
	0xfa, 0x54, 0x06, 0xa1, 0xd6, 0x98, 0x47, 0xf9, 0x7c, 0xf4, 0xe1, 0x2b, 0x79, 0x9c, 0xcc, 0x36,
	0xd4, 0x1a, 0x73, 0x6c, 0x38, 0x73, 0x74, 0x70, 0x1f, 0xac, 0x86, 0xbe, 0x45, 0x38, 0xc5, 0x03,
	0x1a, 0x9c, 0x50, 0xfc, 0xcc, 0x76, 0x2d, 0xef, 0xd9, 0xa5, 0x6f, 0x4c, 0x68, 0x45, 0x5a, 0x1d,
	0x44, 0x46, 0xc7, 0xc2, 0xa6, 0xf0, 0x2b, 0x0d, 0xac, 0xcc, 0x7c, 0x35, 0xfc, 0x00, 0xe4, 0x03,
	0x2f, 0xe4, 0xd1, 0xde, 0xa5, 0x2e, 0xe9, 0x3a, 0xf4, 0xc2, 0x05, 0xc9, 0x29, 0x6c, 0x5d, 0x42,
	0xe1, 0x2e, 0xd0, 0x07, 0x51, 0xef, 0xa2, 0x1e, 0xd5, 0xc4, 0xee, 0x4f, 0x5d, 0xbe, 0xfb, 0x51,
	0x6e, 0x60, 0xbb, 0x2a, 0x4c, 0x62, 0xbb, 0x17, 0x80, 0x31, 0x2f, 0x3c, 0x95, 0x75, 0x70, 0x6b,
	0xb4, 0x04, 0xf1, 0xa3, 0xb3, 0x4f, 0x4d, 0xbb, 0x67, 0xd3, 0xa0, 0x78, 0x0c, 0xb2, 0x13, 0x0f,
	0x89, 0x10, 0x80, 0xd7, 0xda, 0x9d, 0x72, 0x67, 0xbf, 0xaa, 0x2f, 0xc0, 0x1c, 0x00, 0xed, 0x0e,
	0xda, 0xaf, 0x76, 0x70, 0xad, 0xd9, 0xd6, 0xb5, 0x28, 0xf1, 0x36, 0x5a, 0x4f, 0xf6, 0xab, 0xe5,
	0x86, 0x10, 0xa4, 0xe0, 0x55, 0xb0, 0x58, 0xaf, 0xb5, 0xf5, 0xc5, 0x28, 0x03, 0xb7, 0xd0, 0xfe,
	0x93, 0xfd, 0x66, 0xa4, 0x6a, 0x77, 0xf4, 0x74, 0xf1, 0x47, 0x60, 0x29, 0x7e, 0xf1, 0x8a, 0xec,
	0x50, 0xeb, 0xa8, 0x59, 0xc3, 0xa8, 0x55, 0xd9, 0x6f, 0xca, 0x23, 0xd3, 0xa8, 0x97, 0xdb, 0x1d,
	0x8c, 0xea, 0xdf, 0x3f, 0xaa, 0xb7, 0xa3, 0x8c, 0x9d, 0x05, 0xd7, 0xd0, 0x7e, 0xf3, 0x89, 0x3c,
	0x54, 0xa9, 0x68, 0x1a, 0xa8, 0xdc, 0xac, 0xb5, 0x0e, 0xf4, 0x45, 0xb8, 0x0a, 0xf2, 0xe3, 0xe4,
	0xb8, 0x51, 0xd1, 0xd3, 0x11, 0xe0, 0xa0, 0xfc, 0xa4, 0x51, 0x7f, 0xaa, 0x5f, 0x29, 0xbe, 0x0d,
	0xf2, 0x53, 0xf7, 0x5a, 0xb8, 0x04, 0xd2, 0xe5, 0xa3, 0x4e, 0x4b, 0x5f, 0x88, 0xce, 0xea, 0xd3,
	0xb7, 0x70, 0xab, 0xd9, 0xf8, 0x5c, 0xd7, 0xc4, 0xe0, 0x1d, 0x39, 0x48, 0x15, 0x3b, 0xc0, 0x98,
	0xd7, 0x29, 0xc3, 0x75, 0x70, 0xf3, 0xa8, 0x5d, 0xc7, 0xd5, 0x56, 0x73, 0x77, 0xff, 0xc9, 0x11,
	0xaa, 0xd7, 0xf0, 0x21, 0x6a, 0x75, 0x5a, 0xd5, 0x56, 0x43, 0x5f, 0x88, 0x95, 0xb5, 0xd6, 0x71,
	0xb3, 0xdd, 0x41, 0xf5, 0xf2, 0xc1, 0xb9, 0x52, 0xab, 0x18, 0xe0, 0x46, 0xbc, 0x9c, 0xa3, 0x07,
	0x7c, 0xf1, 0xfe, 0x5a, 0x59, 0x16, 0x6f, 0x85, 0x72, 0x09, 0x3e, 0x49, 0x2f, 0x65, 0xf4, 0xec,
	0x27, 0xe9, 0xa5, 0xbc, 0xae, 0x17, 0x8f, 0x01, 0x3c, 0x9a, 0xbd, 0x40, 0x96, 0x41, 0x4e, 0xfe,
	0x73, 0x00, 0xab, 0xff, 0x43, 0x8c, 0x92, 0xd6, 0xfc, 0xeb, 0x77, 0x56, 0x5a, 0xa8, 0x61, 0x91,
	0x80, 0x5b, 0x73, 0x7b, 0x75, 0x58, 0x03, 0x59, 0x6e, 0xfa, 0xf8, 0x94, 0x52, 0x9f, 0x38, 0xf6,
	0x19, 0xbd, 0xa0, 0xe3, 0xec, 0x98, 0xfe, 0xa7, 0x31, 0x0c, 0x65, 0xf8, 0xd8, 0x68, 0xe7, 0x8f,
	0x29, 0x70, 0x53, 0x45, 0x71, 0xb4, 0x91, 0xda, 0xb2, 0xe3, 0x84, 0xc7, 0x20, 0xd7, 0x96, 0xce,
	0x25, 0x80, 0xc1, 0xa9, 0xa7, 0xc4, 0x91, 0x85, 0xaa, 0xc9, 0x85, 0xbb, 0x73, 0xf5, 0xcc, 0xf7,
	0x5c, 0x46, 0x8b, 0x0b, 0x5b, 0xda, 0xff, 0x6b, 0xf0, 0x2b, 0x90, 0xad, 0x51, 0x87, 0x93, 0x11,
	0xef, 0xd4, 0x73, 0xa7, 0x50, 0xce, 0x90, 0xdf, 0xbf, 0x18, 0x34, 0xe1, 0x81, 0x81, 0xec, 0x2e,
	0xe5, 0x66, 0xff, 0xbf, 0x37, 0xf3, 0x7b, 0xdf, 0xfc, 0xf9, 0x1f, 0xbf, 0x48, 0xad, 0x17, 0x6f,
	0x4c, 0xfc, 0x6b, 0xe7, 0x7d, 0xb5, 0x57, 0xd8, 0xfb, 0xda, 0xa3, 0xca, 0xc7, 0xbf, 0x7e, 0xb9,
	0xa1, 0x7d, 0xfb, 0x72, 0x43, 0xfb, 0xd3, 0xcb, 0x0d, 0xed, 0x2f, 0x2f, 0x37, 0xb4, 0xbf, 0xbf,
	0xdc, 0xd0, 0x40, 0xc1, 0xf6, 0x24, 0xb7, 0x1f, 0x78, 0xcf, 0x87, 0x13, 0x6e, 0x2a, 0x4b, 0x55,
	0x8b, 0x89, 0xcd, 0x7b, 0xa8, 0xfd, 0x5c, 0xd3, 0xba, 0xaf, 0x89, 0x64, 0xf1, 0xf8, 0xdf, 0x01,
	0x00, 0x00, 0xff, 0xff, 0xb6, 0x1d, 0x90, 0x28, 0xf2, 0x1a, 0x00, 0x00,
}

func (this *Cluster) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster)
	if !ok {
		that2, ok := that.(Cluster)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.AltStatName != that1.AltStatName {
		return false
	}
	if that1.ClusterDiscoveryType == nil {
		if this.ClusterDiscoveryType != nil {
			return false
		}
	} else if this.ClusterDiscoveryType == nil {
		return false
	} else if !this.ClusterDiscoveryType.Equal(that1.ClusterDiscoveryType) {
		return false
	}
	if !this.EdsClusterConfig.Equal(that1.EdsClusterConfig) {
		return false
	}
	if this.ConnectTimeout != that1.ConnectTimeout {
		return false
	}
	if !this.PerConnectionBufferLimitBytes.Equal(that1.PerConnectionBufferLimitBytes) {
		return false
	}
	if this.LbPolicy != that1.LbPolicy {
		return false
	}
	if len(this.Hosts) != len(that1.Hosts) {
		return false
	}
	for i := range this.Hosts {
		if !this.Hosts[i].Equal(that1.Hosts[i]) {
			return false
		}
	}
	if !this.LoadAssignment.Equal(that1.LoadAssignment) {
		return false
	}
	if len(this.HealthChecks) != len(that1.HealthChecks) {
		return false
	}
	for i := range this.HealthChecks {
		if !this.HealthChecks[i].Equal(that1.HealthChecks[i]) {
			return false
		}
	}
	if !this.MaxRequestsPerConnection.Equal(that1.MaxRequestsPerConnection) {
		return false
	}
	if !this.CircuitBreakers.Equal(that1.CircuitBreakers) {
		return false
	}
	if !this.TlsContext.Equal(that1.TlsContext) {
		return false
	}
	if !this.CommonHttpProtocolOptions.Equal(that1.CommonHttpProtocolOptions) {
		return false
	}
	if !this.HttpProtocolOptions.Equal(that1.HttpProtocolOptions) {
		return false
	}
	if !this.Http2ProtocolOptions.Equal(that1.Http2ProtocolOptions) {
		return false
	}
	if len(this.ExtensionProtocolOptions) != len(that1.ExtensionProtocolOptions) {
		return false
	}
	for i := range this.ExtensionProtocolOptions {
		if !this.ExtensionProtocolOptions[i].Equal(that1.ExtensionProtocolOptions[i]) {
			return false
		}
	}
	if len(this.TypedExtensionProtocolOptions) != len(that1.TypedExtensionProtocolOptions) {
		return false
	}
	for i := range this.TypedExtensionProtocolOptions {
		if !this.TypedExtensionProtocolOptions[i].Equal(that1.TypedExtensionProtocolOptions[i]) {
			return false
		}
	}
	if this.DnsRefreshRate != nil && that1.DnsRefreshRate != nil {
		if *this.DnsRefreshRate != *that1.DnsRefreshRate {
			return false
		}
	} else if this.DnsRefreshRate != nil {
		return false
	} else if that1.DnsRefreshRate != nil {
		return false
	}
	if this.DnsLookupFamily != that1.DnsLookupFamily {
		return false
	}
	if len(this.DnsResolvers) != len(that1.DnsResolvers) {
		return false
	}
	for i := range this.DnsResolvers {
		if !this.DnsResolvers[i].Equal(that1.DnsResolvers[i]) {
			return false
		}
	}
	if !this.OutlierDetection.Equal(that1.OutlierDetection) {
		return false
	}
	if this.CleanupInterval != nil && that1.CleanupInterval != nil {
		if *this.CleanupInterval != *that1.CleanupInterval {
			return false
		}
	} else if this.CleanupInterval != nil {
		return false
	} else if that1.CleanupInterval != nil {
		return false
	}
	if !this.UpstreamBindConfig.Equal(that1.UpstreamBindConfig) {
		return false
	}
	if !this.LbSubsetConfig.Equal(that1.LbSubsetConfig) {
		return false
	}
	if that1.LbConfig == nil {
		if this.LbConfig != nil {
			return false
		}
	} else if this.LbConfig == nil {
		return false
	} else if !this.LbConfig.Equal(that1.LbConfig) {
		return false
	}
	if !this.CommonLbConfig.Equal(that1.CommonLbConfig) {
		return false
	}
	if !this.TransportSocket.Equal(that1.TransportSocket) {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if this.ProtocolSelection != that1.ProtocolSelection {
		return false
	}
	if !this.UpstreamConnectionOptions.Equal(that1.UpstreamConnectionOptions) {
		return false
	}
	if this.CloseConnectionsOnHostHealthFailure != that1.CloseConnectionsOnHostHealthFailure {
		return false
	}
	if this.DrainConnectionsOnHostRemoval != that1.DrainConnectionsOnHostRemoval {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Cluster_Type) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster_Type)
	if !ok {
		that2, ok := that.(Cluster_Type)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	return true
}
func (this *Cluster_ClusterType) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster_ClusterType)
	if !ok {
		that2, ok := that.(Cluster_ClusterType)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ClusterType.Equal(that1.ClusterType) {
		return false
	}
	return true
}
func (this *Cluster_RingHashLbConfig_) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster_RingHashLbConfig_)
	if !ok {
		that2, ok := that.(Cluster_RingHashLbConfig_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RingHashLbConfig.Equal(that1.RingHashLbConfig) {
		return false
	}
	return true
}
func (this *Cluster_OriginalDstLbConfig_) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster_OriginalDstLbConfig_)
	if !ok {
		that2, ok := that.(Cluster_OriginalDstLbConfig_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.OriginalDstLbConfig.Equal(that1.OriginalDstLbConfig) {
		return false
	}
	return true
}
func (this *Cluster_LeastRequestLbConfig_) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster_LeastRequestLbConfig_)
	if !ok {
		that2, ok := that.(Cluster_LeastRequestLbConfig_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.LeastRequestLbConfig.Equal(that1.LeastRequestLbConfig) {
		return false
	}
	return true
}
func (this *Cluster_CustomClusterType) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster_CustomClusterType)
	if !ok {
		that2, ok := that.(Cluster_CustomClusterType)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if !this.TypedConfig.Equal(that1.TypedConfig) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Cluster_EdsClusterConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster_EdsClusterConfig)
	if !ok {
		that2, ok := that.(Cluster_EdsClusterConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.EdsConfig.Equal(that1.EdsConfig) {
		return false
	}
	if this.ServiceName != that1.ServiceName {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Cluster_LbSubsetConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster_LbSubsetConfig)
	if !ok {
		that2, ok := that.(Cluster_LbSubsetConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.FallbackPolicy != that1.FallbackPolicy {
		return false
	}
	if !this.DefaultSubset.Equal(that1.DefaultSubset) {
		return false
	}
	if len(this.SubsetSelectors) != len(that1.SubsetSelectors) {
		return false
	}
	for i := range this.SubsetSelectors {
		if !this.SubsetSelectors[i].Equal(that1.SubsetSelectors[i]) {
			return false
		}
	}
	if this.LocalityWeightAware != that1.LocalityWeightAware {
		return false
	}
	if this.ScaleLocalityWeight != that1.ScaleLocalityWeight {
		return false
	}
	if this.PanicModeAny != that1.PanicModeAny {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Cluster_LbSubsetConfig_LbSubsetSelector) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster_LbSubsetConfig_LbSubsetSelector)
	if !ok {
		that2, ok := that.(Cluster_LbSubsetConfig_LbSubsetSelector)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Keys) != len(that1.Keys) {
		return false
	}
	for i := range this.Keys {
		if this.Keys[i] != that1.Keys[i] {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Cluster_LeastRequestLbConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster_LeastRequestLbConfig)
	if !ok {
		that2, ok := that.(Cluster_LeastRequestLbConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ChoiceCount.Equal(that1.ChoiceCount) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Cluster_RingHashLbConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster_RingHashLbConfig)
	if !ok {
		that2, ok := that.(Cluster_RingHashLbConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.MinimumRingSize.Equal(that1.MinimumRingSize) {
		return false
	}
	if !this.DeprecatedV1.Equal(that1.DeprecatedV1) {
		return false
	}
	if this.HashFunction != that1.HashFunction {
		return false
	}
	if !this.MaximumRingSize.Equal(that1.MaximumRingSize) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Cluster_RingHashLbConfig_DeprecatedV1) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster_RingHashLbConfig_DeprecatedV1)
	if !ok {
		that2, ok := that.(Cluster_RingHashLbConfig_DeprecatedV1)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.UseStdHash.Equal(that1.UseStdHash) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Cluster_OriginalDstLbConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster_OriginalDstLbConfig)
	if !ok {
		that2, ok := that.(Cluster_OriginalDstLbConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.UseHttpHeader != that1.UseHttpHeader {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Cluster_CommonLbConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster_CommonLbConfig)
	if !ok {
		that2, ok := that.(Cluster_CommonLbConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.HealthyPanicThreshold.Equal(that1.HealthyPanicThreshold) {
		return false
	}
	if that1.LocalityConfigSpecifier == nil {
		if this.LocalityConfigSpecifier != nil {
			return false
		}
	} else if this.LocalityConfigSpecifier == nil {
		return false
	} else if !this.LocalityConfigSpecifier.Equal(that1.LocalityConfigSpecifier) {
		return false
	}
	if !this.UpdateMergeWindow.Equal(that1.UpdateMergeWindow) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Cluster_CommonLbConfig_ZoneAwareLbConfig_) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster_CommonLbConfig_ZoneAwareLbConfig_)
	if !ok {
		that2, ok := that.(Cluster_CommonLbConfig_ZoneAwareLbConfig_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ZoneAwareLbConfig.Equal(that1.ZoneAwareLbConfig) {
		return false
	}
	return true
}
func (this *Cluster_CommonLbConfig_LocalityWeightedLbConfig_) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster_CommonLbConfig_LocalityWeightedLbConfig_)
	if !ok {
		that2, ok := that.(Cluster_CommonLbConfig_LocalityWeightedLbConfig_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.LocalityWeightedLbConfig.Equal(that1.LocalityWeightedLbConfig) {
		return false
	}
	return true
}
func (this *Cluster_CommonLbConfig_ZoneAwareLbConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster_CommonLbConfig_ZoneAwareLbConfig)
	if !ok {
		that2, ok := that.(Cluster_CommonLbConfig_ZoneAwareLbConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RoutingEnabled.Equal(that1.RoutingEnabled) {
		return false
	}
	if !this.MinClusterSize.Equal(that1.MinClusterSize) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Cluster_CommonLbConfig_LocalityWeightedLbConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Cluster_CommonLbConfig_LocalityWeightedLbConfig)
	if !ok {
		that2, ok := that.(Cluster_CommonLbConfig_LocalityWeightedLbConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *UpstreamBindConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*UpstreamBindConfig)
	if !ok {
		that2, ok := that.(UpstreamBindConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.SourceAddress.Equal(that1.SourceAddress) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *UpstreamConnectionOptions) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*UpstreamConnectionOptions)
	if !ok {
		that2, ok := that.(UpstreamConnectionOptions)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.TcpKeepalive.Equal(that1.TcpKeepalive) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ClusterDiscoveryServiceClient is the client API for ClusterDiscoveryService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ClusterDiscoveryServiceClient interface {
	StreamClusters(ctx context.Context, opts ...grpc.CallOption) (ClusterDiscoveryService_StreamClustersClient, error)
	DeltaClusters(ctx context.Context, opts ...grpc.CallOption) (ClusterDiscoveryService_DeltaClustersClient, error)
	FetchClusters(ctx context.Context, in *DiscoveryRequest, opts ...grpc.CallOption) (*DiscoveryResponse, error)
}

type clusterDiscoveryServiceClient struct {
	cc *grpc.ClientConn
}

func NewClusterDiscoveryServiceClient(cc *grpc.ClientConn) ClusterDiscoveryServiceClient {
	return &clusterDiscoveryServiceClient{cc}
}

func (c *clusterDiscoveryServiceClient) StreamClusters(ctx context.Context, opts ...grpc.CallOption) (ClusterDiscoveryService_StreamClustersClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ClusterDiscoveryService_serviceDesc.Streams[0], "/envoy.api.v2.ClusterDiscoveryService/StreamClusters", opts...)
	if err != nil {
		return nil, err
	}
	x := &clusterDiscoveryServiceStreamClustersClient{stream}
	return x, nil
}

type ClusterDiscoveryService_StreamClustersClient interface {
	Send(*DiscoveryRequest) error
	Recv() (*DiscoveryResponse, error)
	grpc.ClientStream
}

type clusterDiscoveryServiceStreamClustersClient struct {
	grpc.ClientStream
}

func (x *clusterDiscoveryServiceStreamClustersClient) Send(m *DiscoveryRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *clusterDiscoveryServiceStreamClustersClient) Recv() (*DiscoveryResponse, error) {
	m := new(DiscoveryResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *clusterDiscoveryServiceClient) DeltaClusters(ctx context.Context, opts ...grpc.CallOption) (ClusterDiscoveryService_DeltaClustersClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ClusterDiscoveryService_serviceDesc.Streams[1], "/envoy.api.v2.ClusterDiscoveryService/DeltaClusters", opts...)
	if err != nil {
		return nil, err
	}
	x := &clusterDiscoveryServiceDeltaClustersClient{stream}
	return x, nil
}

type ClusterDiscoveryService_DeltaClustersClient interface {
	Send(*DeltaDiscoveryRequest) error
	Recv() (*DeltaDiscoveryResponse, error)
	grpc.ClientStream
}

type clusterDiscoveryServiceDeltaClustersClient struct {
	grpc.ClientStream
}

func (x *clusterDiscoveryServiceDeltaClustersClient) Send(m *DeltaDiscoveryRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *clusterDiscoveryServiceDeltaClustersClient) Recv() (*DeltaDiscoveryResponse, error) {
	m := new(DeltaDiscoveryResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *clusterDiscoveryServiceClient) FetchClusters(ctx context.Context, in *DiscoveryRequest, opts ...grpc.CallOption) (*DiscoveryResponse, error) {
	out := new(DiscoveryResponse)
	err := c.cc.Invoke(ctx, "/envoy.api.v2.ClusterDiscoveryService/FetchClusters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ClusterDiscoveryServiceServer is the server API for ClusterDiscoveryService service.
type ClusterDiscoveryServiceServer interface {
	StreamClusters(ClusterDiscoveryService_StreamClustersServer) error
	DeltaClusters(ClusterDiscoveryService_DeltaClustersServer) error
	FetchClusters(context.Context, *DiscoveryRequest) (*DiscoveryResponse, error)
}

func RegisterClusterDiscoveryServiceServer(s *grpc.Server, srv ClusterDiscoveryServiceServer) {
	s.RegisterService(&_ClusterDiscoveryService_serviceDesc, srv)
}

func _ClusterDiscoveryService_StreamClusters_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ClusterDiscoveryServiceServer).StreamClusters(&clusterDiscoveryServiceStreamClustersServer{stream})
}

type ClusterDiscoveryService_StreamClustersServer interface {
	Send(*DiscoveryResponse) error
	Recv() (*DiscoveryRequest, error)
	grpc.ServerStream
}

type clusterDiscoveryServiceStreamClustersServer struct {
	grpc.ServerStream
}

func (x *clusterDiscoveryServiceStreamClustersServer) Send(m *DiscoveryResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *clusterDiscoveryServiceStreamClustersServer) Recv() (*DiscoveryRequest, error) {
	m := new(DiscoveryRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _ClusterDiscoveryService_DeltaClusters_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ClusterDiscoveryServiceServer).DeltaClusters(&clusterDiscoveryServiceDeltaClustersServer{stream})
}

type ClusterDiscoveryService_DeltaClustersServer interface {
	Send(*DeltaDiscoveryResponse) error
	Recv() (*DeltaDiscoveryRequest, error)
	grpc.ServerStream
}

type clusterDiscoveryServiceDeltaClustersServer struct {
	grpc.ServerStream
}

func (x *clusterDiscoveryServiceDeltaClustersServer) Send(m *DeltaDiscoveryResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *clusterDiscoveryServiceDeltaClustersServer) Recv() (*DeltaDiscoveryRequest, error) {
	m := new(DeltaDiscoveryRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _ClusterDiscoveryService_FetchClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DiscoveryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterDiscoveryServiceServer).FetchClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/envoy.api.v2.ClusterDiscoveryService/FetchClusters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterDiscoveryServiceServer).FetchClusters(ctx, req.(*DiscoveryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ClusterDiscoveryService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "envoy.api.v2.ClusterDiscoveryService",
	HandlerType: (*ClusterDiscoveryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "FetchClusters",
			Handler:    _ClusterDiscoveryService_FetchClusters_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamClusters",
			Handler:       _ClusterDiscoveryService_StreamClusters_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "DeltaClusters",
			Handler:       _ClusterDiscoveryService_DeltaClusters_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "envoy/api/v2/cds.proto",
}

func (m *Cluster) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCds(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.ClusterDiscoveryType != nil {
		nn1, err := m.ClusterDiscoveryType.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn1
	}
	if m.EdsClusterConfig != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.EdsClusterConfig.Size()))
		n2, err := m.EdsClusterConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintCds(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(m.ConnectTimeout)))
	n3, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(m.ConnectTimeout, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	if m.PerConnectionBufferLimitBytes != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.PerConnectionBufferLimitBytes.Size()))
		n4, err := m.PerConnectionBufferLimitBytes.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.LbPolicy != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.LbPolicy))
	}
	if len(m.Hosts) > 0 {
		for _, msg := range m.Hosts {
			dAtA[i] = 0x3a
			i++
			i = encodeVarintCds(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.HealthChecks) > 0 {
		for _, msg := range m.HealthChecks {
			dAtA[i] = 0x42
			i++
			i = encodeVarintCds(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.MaxRequestsPerConnection != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.MaxRequestsPerConnection.Size()))
		n5, err := m.MaxRequestsPerConnection.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.CircuitBreakers != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.CircuitBreakers.Size()))
		n6, err := m.CircuitBreakers.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.TlsContext != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.TlsContext.Size()))
		n7, err := m.TlsContext.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.HttpProtocolOptions != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.HttpProtocolOptions.Size()))
		n8, err := m.HttpProtocolOptions.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.Http2ProtocolOptions != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.Http2ProtocolOptions.Size()))
		n9, err := m.Http2ProtocolOptions.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.DnsRefreshRate != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.DnsRefreshRate)))
		n10, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.DnsRefreshRate, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.DnsLookupFamily != 0 {
		dAtA[i] = 0x88
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.DnsLookupFamily))
	}
	if len(m.DnsResolvers) > 0 {
		for _, msg := range m.DnsResolvers {
			dAtA[i] = 0x92
			i++
			dAtA[i] = 0x1
			i++
			i = encodeVarintCds(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.OutlierDetection != nil {
		dAtA[i] = 0x9a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.OutlierDetection.Size()))
		n11, err := m.OutlierDetection.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if m.CleanupInterval != nil {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.CleanupInterval)))
		n12, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.CleanupInterval, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if m.UpstreamBindConfig != nil {
		dAtA[i] = 0xaa
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.UpstreamBindConfig.Size()))
		n13, err := m.UpstreamBindConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if m.LbSubsetConfig != nil {
		dAtA[i] = 0xb2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.LbSubsetConfig.Size()))
		n14, err := m.LbSubsetConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if m.LbConfig != nil {
		nn15, err := m.LbConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn15
	}
	if m.TransportSocket != nil {
		dAtA[i] = 0xc2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.TransportSocket.Size()))
		n16, err := m.TransportSocket.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	if m.Metadata != nil {
		dAtA[i] = 0xca
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.Metadata.Size()))
		n17, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	if m.ProtocolSelection != 0 {
		dAtA[i] = 0xd0
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.ProtocolSelection))
	}
	if m.CommonLbConfig != nil {
		dAtA[i] = 0xda
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.CommonLbConfig.Size()))
		n18, err := m.CommonLbConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	if len(m.AltStatName) > 0 {
		dAtA[i] = 0xe2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(len(m.AltStatName)))
		i += copy(dAtA[i:], m.AltStatName)
	}
	if m.CommonHttpProtocolOptions != nil {
		dAtA[i] = 0xea
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.CommonHttpProtocolOptions.Size()))
		n19, err := m.CommonHttpProtocolOptions.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	if m.UpstreamConnectionOptions != nil {
		dAtA[i] = 0xf2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.UpstreamConnectionOptions.Size()))
		n20, err := m.UpstreamConnectionOptions.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n20
	}
	if m.CloseConnectionsOnHostHealthFailure {
		dAtA[i] = 0xf8
		i++
		dAtA[i] = 0x1
		i++
		if m.CloseConnectionsOnHostHealthFailure {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.DrainConnectionsOnHostRemoval {
		dAtA[i] = 0x80
		i++
		dAtA[i] = 0x2
		i++
		if m.DrainConnectionsOnHostRemoval {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.LoadAssignment != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.LoadAssignment.Size()))
		n21, err := m.LoadAssignment.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	if len(m.ExtensionProtocolOptions) > 0 {
		keysForExtensionProtocolOptions := make([]string, 0, len(m.ExtensionProtocolOptions))
		for k, _ := range m.ExtensionProtocolOptions {
			keysForExtensionProtocolOptions = append(keysForExtensionProtocolOptions, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForExtensionProtocolOptions)
		for _, k := range keysForExtensionProtocolOptions {
			dAtA[i] = 0x9a
			i++
			dAtA[i] = 0x2
			i++
			v := m.ExtensionProtocolOptions[string(k)]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovCds(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovCds(uint64(len(k))) + msgSize
			i = encodeVarintCds(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintCds(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintCds(dAtA, i, uint64(v.Size()))
				n22, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n22
			}
		}
	}
	if len(m.TypedExtensionProtocolOptions) > 0 {
		keysForTypedExtensionProtocolOptions := make([]string, 0, len(m.TypedExtensionProtocolOptions))
		for k, _ := range m.TypedExtensionProtocolOptions {
			keysForTypedExtensionProtocolOptions = append(keysForTypedExtensionProtocolOptions, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForTypedExtensionProtocolOptions)
		for _, k := range keysForTypedExtensionProtocolOptions {
			dAtA[i] = 0xa2
			i++
			dAtA[i] = 0x2
			i++
			v := m.TypedExtensionProtocolOptions[string(k)]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovCds(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovCds(uint64(len(k))) + msgSize
			i = encodeVarintCds(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintCds(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintCds(dAtA, i, uint64(v.Size()))
				n23, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n23
			}
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Cluster_Type) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x10
	i++
	i = encodeVarintCds(dAtA, i, uint64(m.Type))
	return i, nil
}
func (m *Cluster_RingHashLbConfig_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RingHashLbConfig != nil {
		dAtA[i] = 0xba
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.RingHashLbConfig.Size()))
		n24, err := m.RingHashLbConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n24
	}
	return i, nil
}
func (m *Cluster_OriginalDstLbConfig_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.OriginalDstLbConfig != nil {
		dAtA[i] = 0x92
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.OriginalDstLbConfig.Size()))
		n25, err := m.OriginalDstLbConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n25
	}
	return i, nil
}
func (m *Cluster_LeastRequestLbConfig_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.LeastRequestLbConfig != nil {
		dAtA[i] = 0xaa
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.LeastRequestLbConfig.Size()))
		n26, err := m.LeastRequestLbConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n26
	}
	return i, nil
}
func (m *Cluster_ClusterType) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ClusterType != nil {
		dAtA[i] = 0xb2
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.ClusterType.Size()))
		n27, err := m.ClusterType.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n27
	}
	return i, nil
}
func (m *Cluster_CustomClusterType) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster_CustomClusterType) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCds(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.TypedConfig != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.TypedConfig.Size()))
		n28, err := m.TypedConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n28
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Cluster_EdsClusterConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster_EdsClusterConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.EdsConfig != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.EdsConfig.Size()))
		n29, err := m.EdsConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n29
	}
	if len(m.ServiceName) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCds(dAtA, i, uint64(len(m.ServiceName)))
		i += copy(dAtA[i:], m.ServiceName)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Cluster_LbSubsetConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster_LbSubsetConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.FallbackPolicy != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.FallbackPolicy))
	}
	if m.DefaultSubset != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.DefaultSubset.Size()))
		n30, err := m.DefaultSubset.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n30
	}
	if len(m.SubsetSelectors) > 0 {
		for _, msg := range m.SubsetSelectors {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintCds(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.LocalityWeightAware {
		dAtA[i] = 0x20
		i++
		if m.LocalityWeightAware {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.ScaleLocalityWeight {
		dAtA[i] = 0x28
		i++
		if m.ScaleLocalityWeight {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.PanicModeAny {
		dAtA[i] = 0x30
		i++
		if m.PanicModeAny {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Cluster_LbSubsetConfig_LbSubsetSelector) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster_LbSubsetConfig_LbSubsetSelector) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Keys) > 0 {
		for _, s := range m.Keys {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Cluster_LeastRequestLbConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster_LeastRequestLbConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ChoiceCount != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.ChoiceCount.Size()))
		n31, err := m.ChoiceCount.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n31
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Cluster_RingHashLbConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster_RingHashLbConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.MinimumRingSize != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.MinimumRingSize.Size()))
		n32, err := m.MinimumRingSize.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n32
	}
	if m.DeprecatedV1 != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.DeprecatedV1.Size()))
		n33, err := m.DeprecatedV1.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n33
	}
	if m.HashFunction != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.HashFunction))
	}
	if m.MaximumRingSize != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.MaximumRingSize.Size()))
		n34, err := m.MaximumRingSize.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n34
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Cluster_RingHashLbConfig_DeprecatedV1) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster_RingHashLbConfig_DeprecatedV1) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.UseStdHash != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.UseStdHash.Size()))
		n35, err := m.UseStdHash.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n35
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Cluster_OriginalDstLbConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster_OriginalDstLbConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.UseHttpHeader {
		dAtA[i] = 0x8
		i++
		if m.UseHttpHeader {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Cluster_CommonLbConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster_CommonLbConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.HealthyPanicThreshold != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.HealthyPanicThreshold.Size()))
		n36, err := m.HealthyPanicThreshold.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n36
	}
	if m.LocalityConfigSpecifier != nil {
		nn37, err := m.LocalityConfigSpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn37
	}
	if m.UpdateMergeWindow != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.UpdateMergeWindow.Size()))
		n38, err := m.UpdateMergeWindow.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n38
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ZoneAwareLbConfig != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.ZoneAwareLbConfig.Size()))
		n39, err := m.ZoneAwareLbConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n39
	}
	return i, nil
}
func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.LocalityWeightedLbConfig != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.LocalityWeightedLbConfig.Size()))
		n40, err := m.LocalityWeightedLbConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n40
	}
	return i, nil
}
func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RoutingEnabled != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.RoutingEnabled.Size()))
		n41, err := m.RoutingEnabled.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n41
	}
	if m.MinClusterSize != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.MinClusterSize.Size()))
		n42, err := m.MinClusterSize.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n42
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *UpstreamBindConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpstreamBindConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.SourceAddress != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.SourceAddress.Size()))
		n43, err := m.SourceAddress.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n43
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *UpstreamConnectionOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpstreamConnectionOptions) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.TcpKeepalive != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.TcpKeepalive.Size()))
		n44, err := m.TcpKeepalive.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n44
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintCds(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Cluster) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovCds(uint64(l))
	}
	if m.ClusterDiscoveryType != nil {
		n += m.ClusterDiscoveryType.Size()
	}
	if m.EdsClusterConfig != nil {
		l = m.EdsClusterConfig.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	l = github_com_gogo_protobuf_types.SizeOfStdDuration(m.ConnectTimeout)
	n += 1 + l + sovCds(uint64(l))
	if m.PerConnectionBufferLimitBytes != nil {
		l = m.PerConnectionBufferLimitBytes.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.LbPolicy != 0 {
		n += 1 + sovCds(uint64(m.LbPolicy))
	}
	if len(m.Hosts) > 0 {
		for _, e := range m.Hosts {
			l = e.Size()
			n += 1 + l + sovCds(uint64(l))
		}
	}
	if len(m.HealthChecks) > 0 {
		for _, e := range m.HealthChecks {
			l = e.Size()
			n += 1 + l + sovCds(uint64(l))
		}
	}
	if m.MaxRequestsPerConnection != nil {
		l = m.MaxRequestsPerConnection.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.CircuitBreakers != nil {
		l = m.CircuitBreakers.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.TlsContext != nil {
		l = m.TlsContext.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.HttpProtocolOptions != nil {
		l = m.HttpProtocolOptions.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.Http2ProtocolOptions != nil {
		l = m.Http2ProtocolOptions.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.DnsRefreshRate != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.DnsRefreshRate)
		n += 2 + l + sovCds(uint64(l))
	}
	if m.DnsLookupFamily != 0 {
		n += 2 + sovCds(uint64(m.DnsLookupFamily))
	}
	if len(m.DnsResolvers) > 0 {
		for _, e := range m.DnsResolvers {
			l = e.Size()
			n += 2 + l + sovCds(uint64(l))
		}
	}
	if m.OutlierDetection != nil {
		l = m.OutlierDetection.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	if m.CleanupInterval != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.CleanupInterval)
		n += 2 + l + sovCds(uint64(l))
	}
	if m.UpstreamBindConfig != nil {
		l = m.UpstreamBindConfig.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	if m.LbSubsetConfig != nil {
		l = m.LbSubsetConfig.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	if m.LbConfig != nil {
		n += m.LbConfig.Size()
	}
	if m.TransportSocket != nil {
		l = m.TransportSocket.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	if m.ProtocolSelection != 0 {
		n += 2 + sovCds(uint64(m.ProtocolSelection))
	}
	if m.CommonLbConfig != nil {
		l = m.CommonLbConfig.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	l = len(m.AltStatName)
	if l > 0 {
		n += 2 + l + sovCds(uint64(l))
	}
	if m.CommonHttpProtocolOptions != nil {
		l = m.CommonHttpProtocolOptions.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	if m.UpstreamConnectionOptions != nil {
		l = m.UpstreamConnectionOptions.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	if m.CloseConnectionsOnHostHealthFailure {
		n += 3
	}
	if m.DrainConnectionsOnHostRemoval {
		n += 3
	}
	if m.LoadAssignment != nil {
		l = m.LoadAssignment.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	if len(m.ExtensionProtocolOptions) > 0 {
		for k, v := range m.ExtensionProtocolOptions {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovCds(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovCds(uint64(len(k))) + l
			n += mapEntrySize + 2 + sovCds(uint64(mapEntrySize))
		}
	}
	if len(m.TypedExtensionProtocolOptions) > 0 {
		for k, v := range m.TypedExtensionProtocolOptions {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovCds(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovCds(uint64(len(k))) + l
			n += mapEntrySize + 2 + sovCds(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Cluster_Type) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovCds(uint64(m.Type))
	return n
}
func (m *Cluster_RingHashLbConfig_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RingHashLbConfig != nil {
		l = m.RingHashLbConfig.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	return n
}
func (m *Cluster_OriginalDstLbConfig_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.OriginalDstLbConfig != nil {
		l = m.OriginalDstLbConfig.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	return n
}
func (m *Cluster_LeastRequestLbConfig_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.LeastRequestLbConfig != nil {
		l = m.LeastRequestLbConfig.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	return n
}
func (m *Cluster_ClusterType) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ClusterType != nil {
		l = m.ClusterType.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	return n
}
func (m *Cluster_CustomClusterType) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovCds(uint64(l))
	}
	if m.TypedConfig != nil {
		l = m.TypedConfig.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Cluster_EdsClusterConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.EdsConfig != nil {
		l = m.EdsConfig.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	l = len(m.ServiceName)
	if l > 0 {
		n += 1 + l + sovCds(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Cluster_LbSubsetConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.FallbackPolicy != 0 {
		n += 1 + sovCds(uint64(m.FallbackPolicy))
	}
	if m.DefaultSubset != nil {
		l = m.DefaultSubset.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if len(m.SubsetSelectors) > 0 {
		for _, e := range m.SubsetSelectors {
			l = e.Size()
			n += 1 + l + sovCds(uint64(l))
		}
	}
	if m.LocalityWeightAware {
		n += 2
	}
	if m.ScaleLocalityWeight {
		n += 2
	}
	if m.PanicModeAny {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Cluster_LbSubsetConfig_LbSubsetSelector) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Keys) > 0 {
		for _, s := range m.Keys {
			l = len(s)
			n += 1 + l + sovCds(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Cluster_LeastRequestLbConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ChoiceCount != nil {
		l = m.ChoiceCount.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Cluster_RingHashLbConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MinimumRingSize != nil {
		l = m.MinimumRingSize.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.DeprecatedV1 != nil {
		l = m.DeprecatedV1.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.HashFunction != 0 {
		n += 1 + sovCds(uint64(m.HashFunction))
	}
	if m.MaximumRingSize != nil {
		l = m.MaximumRingSize.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Cluster_RingHashLbConfig_DeprecatedV1) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.UseStdHash != nil {
		l = m.UseStdHash.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Cluster_OriginalDstLbConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.UseHttpHeader {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Cluster_CommonLbConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.HealthyPanicThreshold != nil {
		l = m.HealthyPanicThreshold.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.LocalityConfigSpecifier != nil {
		n += m.LocalityConfigSpecifier.Size()
	}
	if m.UpdateMergeWindow != nil {
		l = m.UpdateMergeWindow.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ZoneAwareLbConfig != nil {
		l = m.ZoneAwareLbConfig.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	return n
}
func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.LocalityWeightedLbConfig != nil {
		l = m.LocalityWeightedLbConfig.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	return n
}
func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RoutingEnabled != nil {
		l = m.RoutingEnabled.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.MinClusterSize != nil {
		l = m.MinClusterSize.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UpstreamBindConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.SourceAddress != nil {
		l = m.SourceAddress.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UpstreamConnectionOptions) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TcpKeepalive != nil {
		l = m.TcpKeepalive.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovCds(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozCds(x uint64) (n int) {
	return sovCds(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Cluster) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Cluster: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Cluster: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var v Cluster_DiscoveryType
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= Cluster_DiscoveryType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ClusterDiscoveryType = &Cluster_Type{v}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EdsClusterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EdsClusterConfig == nil {
				m.EdsClusterConfig = &Cluster_EdsClusterConfig{}
			}
			if err := m.EdsClusterConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnectTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(&m.ConnectTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PerConnectionBufferLimitBytes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PerConnectionBufferLimitBytes == nil {
				m.PerConnectionBufferLimitBytes = &types.UInt32Value{}
			}
			if err := m.PerConnectionBufferLimitBytes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LbPolicy", wireType)
			}
			m.LbPolicy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LbPolicy |= Cluster_LbPolicy(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hosts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hosts = append(m.Hosts, &core.Address{})
			if err := m.Hosts[len(m.Hosts)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HealthChecks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HealthChecks = append(m.HealthChecks, &core.HealthCheck{})
			if err := m.HealthChecks[len(m.HealthChecks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxRequestsPerConnection", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MaxRequestsPerConnection == nil {
				m.MaxRequestsPerConnection = &types.UInt32Value{}
			}
			if err := m.MaxRequestsPerConnection.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CircuitBreakers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CircuitBreakers == nil {
				m.CircuitBreakers = &cluster.CircuitBreakers{}
			}
			if err := m.CircuitBreakers.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsContext", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TlsContext == nil {
				m.TlsContext = &auth.UpstreamTlsContext{}
			}
			if err := m.TlsContext.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpProtocolOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HttpProtocolOptions == nil {
				m.HttpProtocolOptions = &core.Http1ProtocolOptions{}
			}
			if err := m.HttpProtocolOptions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Http2ProtocolOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Http2ProtocolOptions == nil {
				m.Http2ProtocolOptions = &core.Http2ProtocolOptions{}
			}
			if err := m.Http2ProtocolOptions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsRefreshRate", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DnsRefreshRate == nil {
				m.DnsRefreshRate = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.DnsRefreshRate, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsLookupFamily", wireType)
			}
			m.DnsLookupFamily = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DnsLookupFamily |= Cluster_DnsLookupFamily(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsResolvers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DnsResolvers = append(m.DnsResolvers, &core.Address{})
			if err := m.DnsResolvers[len(m.DnsResolvers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OutlierDetection", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OutlierDetection == nil {
				m.OutlierDetection = &cluster.OutlierDetection{}
			}
			if err := m.OutlierDetection.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CleanupInterval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CleanupInterval == nil {
				m.CleanupInterval = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.CleanupInterval, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpstreamBindConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UpstreamBindConfig == nil {
				m.UpstreamBindConfig = &core.BindConfig{}
			}
			if err := m.UpstreamBindConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LbSubsetConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LbSubsetConfig == nil {
				m.LbSubsetConfig = &Cluster_LbSubsetConfig{}
			}
			if err := m.LbSubsetConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 23:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RingHashLbConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Cluster_RingHashLbConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.LbConfig = &Cluster_RingHashLbConfig_{v}
			iNdEx = postIndex
		case 24:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TransportSocket", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TransportSocket == nil {
				m.TransportSocket = &core.TransportSocket{}
			}
			if err := m.TransportSocket.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 25:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &core.Metadata{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 26:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProtocolSelection", wireType)
			}
			m.ProtocolSelection = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ProtocolSelection |= Cluster_ClusterProtocolSelection(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 27:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommonLbConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CommonLbConfig == nil {
				m.CommonLbConfig = &Cluster_CommonLbConfig{}
			}
			if err := m.CommonLbConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 28:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AltStatName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AltStatName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 29:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommonHttpProtocolOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CommonHttpProtocolOptions == nil {
				m.CommonHttpProtocolOptions = &core.HttpProtocolOptions{}
			}
			if err := m.CommonHttpProtocolOptions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 30:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpstreamConnectionOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UpstreamConnectionOptions == nil {
				m.UpstreamConnectionOptions = &UpstreamConnectionOptions{}
			}
			if err := m.UpstreamConnectionOptions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 31:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CloseConnectionsOnHostHealthFailure", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CloseConnectionsOnHostHealthFailure = bool(v != 0)
		case 32:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DrainConnectionsOnHostRemoval", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DrainConnectionsOnHostRemoval = bool(v != 0)
		case 33:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LoadAssignment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LoadAssignment == nil {
				m.LoadAssignment = &ClusterLoadAssignment{}
			}
			if err := m.LoadAssignment.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 34:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OriginalDstLbConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Cluster_OriginalDstLbConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.LbConfig = &Cluster_OriginalDstLbConfig_{v}
			iNdEx = postIndex
		case 35:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExtensionProtocolOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExtensionProtocolOptions == nil {
				m.ExtensionProtocolOptions = make(map[string]*types.Struct)
			}
			var mapkey string
			var mapvalue *types.Struct
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowCds
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowCds
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthCds
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthCds
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowCds
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthCds
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthCds
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &types.Struct{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipCds(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthCds
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ExtensionProtocolOptions[mapkey] = mapvalue
			iNdEx = postIndex
		case 36:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TypedExtensionProtocolOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TypedExtensionProtocolOptions == nil {
				m.TypedExtensionProtocolOptions = make(map[string]*types.Any)
			}
			var mapkey string
			var mapvalue *types.Any
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowCds
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowCds
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthCds
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthCds
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowCds
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthCds
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthCds
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &types.Any{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipCds(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthCds
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.TypedExtensionProtocolOptions[mapkey] = mapvalue
			iNdEx = postIndex
		case 37:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeastRequestLbConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Cluster_LeastRequestLbConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.LbConfig = &Cluster_LeastRequestLbConfig_{v}
			iNdEx = postIndex
		case 38:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterType", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Cluster_CustomClusterType{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ClusterDiscoveryType = &Cluster_ClusterType{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Cluster_CustomClusterType) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CustomClusterType: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CustomClusterType: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TypedConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TypedConfig == nil {
				m.TypedConfig = &types.Any{}
			}
			if err := m.TypedConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Cluster_EdsClusterConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EdsClusterConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EdsClusterConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EdsConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EdsConfig == nil {
				m.EdsConfig = &core.ConfigSource{}
			}
			if err := m.EdsConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServiceName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Cluster_LbSubsetConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LbSubsetConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LbSubsetConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FallbackPolicy", wireType)
			}
			m.FallbackPolicy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FallbackPolicy |= Cluster_LbSubsetConfig_LbSubsetFallbackPolicy(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultSubset", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DefaultSubset == nil {
				m.DefaultSubset = &types.Struct{}
			}
			if err := m.DefaultSubset.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubsetSelectors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubsetSelectors = append(m.SubsetSelectors, &Cluster_LbSubsetConfig_LbSubsetSelector{})
			if err := m.SubsetSelectors[len(m.SubsetSelectors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalityWeightAware", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LocalityWeightAware = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScaleLocalityWeight", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ScaleLocalityWeight = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PanicModeAny", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.PanicModeAny = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Cluster_LbSubsetConfig_LbSubsetSelector) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LbSubsetSelector: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LbSubsetSelector: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Keys = append(m.Keys, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Cluster_LeastRequestLbConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LeastRequestLbConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LeastRequestLbConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChoiceCount", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ChoiceCount == nil {
				m.ChoiceCount = &types.UInt32Value{}
			}
			if err := m.ChoiceCount.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Cluster_RingHashLbConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RingHashLbConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RingHashLbConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinimumRingSize", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MinimumRingSize == nil {
				m.MinimumRingSize = &types.UInt64Value{}
			}
			if err := m.MinimumRingSize.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeprecatedV1", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeprecatedV1 == nil {
				m.DeprecatedV1 = &Cluster_RingHashLbConfig_DeprecatedV1{}
			}
			if err := m.DeprecatedV1.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HashFunction", wireType)
			}
			m.HashFunction = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HashFunction |= Cluster_RingHashLbConfig_HashFunction(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaximumRingSize", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MaximumRingSize == nil {
				m.MaximumRingSize = &types.UInt64Value{}
			}
			if err := m.MaximumRingSize.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Cluster_RingHashLbConfig_DeprecatedV1) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeprecatedV1: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeprecatedV1: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UseStdHash", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UseStdHash == nil {
				m.UseStdHash = &types.BoolValue{}
			}
			if err := m.UseStdHash.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Cluster_OriginalDstLbConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OriginalDstLbConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OriginalDstLbConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UseHttpHeader", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UseHttpHeader = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Cluster_CommonLbConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommonLbConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommonLbConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HealthyPanicThreshold", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HealthyPanicThreshold == nil {
				m.HealthyPanicThreshold = &_type.Percent{}
			}
			if err := m.HealthyPanicThreshold.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ZoneAwareLbConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Cluster_CommonLbConfig_ZoneAwareLbConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.LocalityConfigSpecifier = &Cluster_CommonLbConfig_ZoneAwareLbConfig_{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalityWeightedLbConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Cluster_CommonLbConfig_LocalityWeightedLbConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.LocalityConfigSpecifier = &Cluster_CommonLbConfig_LocalityWeightedLbConfig_{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdateMergeWindow", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UpdateMergeWindow == nil {
				m.UpdateMergeWindow = &types.Duration{}
			}
			if err := m.UpdateMergeWindow.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ZoneAwareLbConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ZoneAwareLbConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RoutingEnabled", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RoutingEnabled == nil {
				m.RoutingEnabled = &_type.Percent{}
			}
			if err := m.RoutingEnabled.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinClusterSize", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MinClusterSize == nil {
				m.MinClusterSize = &types.UInt64Value{}
			}
			if err := m.MinClusterSize.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LocalityWeightedLbConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LocalityWeightedLbConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpstreamBindConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpstreamBindConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpstreamBindConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceAddress", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SourceAddress == nil {
				m.SourceAddress = &core.Address{}
			}
			if err := m.SourceAddress.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpstreamConnectionOptions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpstreamConnectionOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpstreamConnectionOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TcpKeepalive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCds
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TcpKeepalive == nil {
				m.TcpKeepalive = &core.TcpKeepalive{}
			}
			if err := m.TcpKeepalive.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipCds(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowCds
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCds
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCds
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthCds
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthCds
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowCds
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipCds(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthCds
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthCds = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowCds   = fmt.Errorf("proto: integer overflow")
)
